/*
 * Decompiled with CFR 0.152.
 */
package GUI.Dashboard;

import GUI.CSA.CSABootVolumeCreationPage;
import GUI.CSA.CSAConfigurationSummaryPage;
import GUI.CSA.CSADriveGroupCreationPage;
import GUI.CSA.CSAModeSelectionPage;
import GUI.CSA.CSAVirtualDiskCreationPage;
import GUI.ConfigFileManager;
import GUI.FirmwareDialog;
import GUI.MainFrame;
import GUI.OperationDetailPanel;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.ConfigurationSummaryPage;
import GUI.venus.configuration.DriveGroupSelectionPage;
import GUI.venus.configuration.ModeSelectionPage;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroupCreationPage;
import GUI.venus.configuration.advanced.VirtualDiskCreationPage;
import GUI.venus.configuration.simple.SimpleConfigEngine;
import GUI.venus.configuration.simple.VirtualDriveSettingsPage;
import GUI.venus.configuration.supersizedcache.SSCConfigurationSummaryPage;
import GUI.venus.configuration.supersizedcache.SSCDriveGroupCreationPage;
import GUI.venus.configuration.supersizedcache.SSCHolesUnconfigPdSelectionPage;
import GUI.venus.configuration.supersizedcache.SSCVirtualDiskCreationPage;
import GUI.venus.wizard.WizardController;
import GUI.venus.wizard.WizardNavigationException;
import GUIHelper.AdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.PhysicalDriveHelper;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class ActionsPanel
extends JPanel
implements Observer {
    private AdapterHelper m_adapHelper = null;

    public ActionsPanel(AdapterHelper adapterHelper) {
        this.m_adapHelper = adapterHelper;
        this.updatePanel();
        this.m_adapHelper.addObserver(this);
    }

    private int isConfigAllowed() {
        OperationDetails operationDetails = new OperationDetails(9, null);
        int n = 0;
        try {
            ((SASAdapter)this.m_adapHelper.getDeviceObject()).fireConfigOperation(operationDetails);
            n = (Integer)operationDetails.getParam();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public void updatePanel() {
        Object object;
        JLabel jLabel;
        this.removeAll();
        String[] stringArray = null;
        String string = null;
        this.setBackground(MainFrame.BACKGROUND_COLOR);
        TitledBorder titledBorder = new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), Resource.getString("ACTIONS_TEXT", "Actions"));
        titledBorder.setTitleColor(MainFrame.TITLE_COLOR);
        this.setBorder(titledBorder);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(MainFrame.BACKGROUND_COLOR);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        boolean bl = MainFrame.fullAccess;
        if (this.m_adapHelper.getAdapterInfo().getmaxLDs() != '\u0000') {
            Object object2;
            Object object3;
            Object object4;
            block33: {
                block32: {
                    string = Resource.getString("ACTION_CREATE_VD", "Create virtual drive");
                    jLabel = new JLabel();
                    object = new CreateVDAction();
                    JPanel jPanel2 = new JPanel(new FlowLayout(0));
                    jPanel2.setBackground(MainFrame.BACKGROUND_COLOR);
                    jPanel2.add(jLabel);
                    jPanel.add((Component)jPanel2, gridBagConstraints);
                    if ((this.isConfigAllowed() & 1) == 1 && bl) {
                        try {
                            object4 = new AdvanceConfigEngine(this.m_adapHelper);
                            if (((AdvanceConfigEngine)object4).canCreateConfig()) {
                                stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_CREATE_VD"));
                                object3 = new JMenuItem(stringArray[0]);
                                if (stringArray.length == 2) {
                                    ((AbstractButton)object3).setMnemonic(stringArray[1].charAt(0));
                                }
                                jLabel.setText("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string + "\">" + string + "</a></body></html>");
                                jLabel.addMouseListener((MouseListener)object);
                                jLabel.addMouseListener(new MouseAdapter(){

                                    @Override
                                    public void mouseClicked(MouseEvent mouseEvent) {
                                        System.out.println("inside mouse click");
                                    }

                                    @Override
                                    public void mouseEntered(MouseEvent mouseEvent) {
                                        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                                    }
                                });
                                break block32;
                            }
                            jLabel.setText("<html><body>&nbsp&nbsp&nbsp<u>" + string + "</u></body></html>");
                            jLabel.removeMouseListener((MouseListener)object);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        jLabel.setText("<html><body>&nbsp&nbsp&nbsp<u>" + string + "</u></body></html>");
                        jLabel.removeMouseListener((MouseListener)object);
                    }
                }
                if (this.m_adapHelper.isCSA()) {
                    string = Resource.getString("OPERATION_CREATE_CSA_CACHECADE", "Create Nytro\u2122 Cache");
                    object4 = new JLabel();
                    object3 = new CreateCSACacheCadeAction();
                    object2 = new JPanel(new FlowLayout(0));
                    ((JComponent)object2).setBackground(MainFrame.BACKGROUND_COLOR);
                    ((Container)object2).add((Component)object4);
                    ++gridBagConstraints.gridy;
                    jPanel.add((Component)object2, gridBagConstraints);
                    if (bl) {
                        try {
                            if (this.m_adapHelper.canCreateCSACacheCade()) {
                                stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_CREATE_CSA_CACHECADE"));
                                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                                if (stringArray.length == 2) {
                                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                                }
                                ((JLabel)object4).setText("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string + "\">" + string + "</a></body></html>");
                                ((Component)object4).addMouseListener((MouseListener)object3);
                                ((Component)object4).addMouseListener(new MouseAdapter(){

                                    @Override
                                    public void mouseClicked(MouseEvent mouseEvent) {
                                        System.out.println("inside mouse click");
                                    }

                                    @Override
                                    public void mouseEntered(MouseEvent mouseEvent) {
                                        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                                    }
                                });
                                break block33;
                            }
                            ((JLabel)object4).setText("<html><body>&nbsp&nbsp&nbsp<u>" + string + "</u></body></html>");
                            ((Component)object4).removeMouseListener((MouseListener)object3);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        ((JLabel)object4).setText("<html><body>&nbsp&nbsp&nbsp<u>" + string + "</u></body></html>");
                        ((Component)object4).removeMouseListener((MouseListener)object);
                    }
                } else {
                    ++gridBagConstraints.gridy;
                    string = Resource.getString("ACTION_CREATE_SSCD", "Create CacheCade\u2122");
                    object4 = new JLabel();
                    object3 = new JPanel(new FlowLayout(0));
                    ((JComponent)object3).setBackground(MainFrame.BACKGROUND_COLOR);
                    ((Container)object3).add((Component)object4);
                    jPanel.add((Component)object3, gridBagConstraints);
                    object2 = new CreateSSCAction();
                    if ((this.isConfigAllowed() & 1) == 1 && bl) {
                        short s = this.m_adapHelper.getAdapterInfo().getMaxSSCsize();
                        short s2 = this.m_adapHelper.getAdapterInfo().getcurrentSSCsize();
                        int n = s - s2;
                        if (s != 0 && n > 0) {
                            boolean bl2 = false;
                            PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapHelper.getUnconfiguredPhysicalDrives();
                            if (physicalDriveHelperArray != null && physicalDriveHelperArray.length > 0) {
                                for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                                    if (physicalDriveHelperArray[i].isSSDDrive()) {
                                        stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_CREATE_SSCD", "Create CacheCade\u2122"));
                                        JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                                        if (stringArray.length == 2) {
                                            jMenuItem.setMnemonic(stringArray[1].charAt(0));
                                        }
                                        ((JLabel)object4).setText("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string + "\">" + string + "</a></body></html>");
                                        ((Component)object4).addMouseListener((MouseListener)object2);
                                        ((Component)object4).addMouseListener(new MouseAdapter(){

                                            @Override
                                            public void mouseClicked(MouseEvent mouseEvent) {
                                                System.out.println("inside mouse click");
                                            }

                                            @Override
                                            public void mouseEntered(MouseEvent mouseEvent) {
                                                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                                            }
                                        });
                                        bl2 = true;
                                        break;
                                    }
                                    ((JLabel)object4).setText("<html><body>&nbsp&nbsp&nbsp<u>" + string + "</u></body></html>");
                                    ((Component)object4).removeMouseListener((MouseListener)object);
                                }
                            } else {
                                ((JLabel)object4).setText("<html><body>&nbsp&nbsp&nbsp<u>" + string + "</u></body></html>");
                                ((Component)object4).removeMouseListener((MouseListener)object);
                            }
                        } else {
                            ((JLabel)object4).setText("<html><body>&nbsp&nbsp&nbsp<u>" + string + "</u></body></html>");
                            ((Component)object4).removeMouseListener((MouseListener)object);
                        }
                    } else {
                        ((JLabel)object4).setText("<html><body>&nbsp&nbsp&nbsp<u>" + string + "</u></body></html>");
                        ((Component)object4).removeMouseListener((MouseListener)object);
                    }
                }
            }
            ++gridBagConstraints.gridy;
            string = Resource.getString("ACTION_LOAD_CONFIG", "Load configuration");
            object4 = new JLabel();
            object3 = new JPanel(new FlowLayout(0));
            ((JComponent)object3).setBackground(MainFrame.BACKGROUND_COLOR);
            ((Container)object3).add((Component)object4);
            jPanel.add((Component)object3, gridBagConstraints);
            object2 = new LoadConfigAction();
            if (bl) {
                ((JLabel)object4).setText("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string + "\">" + string + "</a></body></html>");
                ((Component)object4).addMouseListener((MouseListener)object2);
                ((Component)object4).addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        System.out.println("inside mouse click");
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                    }
                });
            } else {
                ((JLabel)object4).setText("<html><body>&nbsp&nbsp&nbsp<u>" + string + "</u></body></html>");
                ((Component)object4).removeMouseListener((MouseListener)object2);
            }
        }
        if (VivaldiStartupDialog.OEM_TYPE != 2561) {
            string = Resource.getString("ACTION_UPDATE_FIRMWARE", "Update firmware");
            ++gridBagConstraints.gridy;
            jLabel = new JLabel();
            object = new JPanel(new FlowLayout(0));
            ((JComponent)object).setBackground(MainFrame.BACKGROUND_COLOR);
            ((Container)object).add(jLabel);
            jPanel.add((Component)object, gridBagConstraints);
            if (bl && !this.m_adapHelper.isSWRController()) {
                jLabel.setText("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string + "\">" + string + "</a></body></html>");
                jLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        System.out.println("inside mouse click");
                        new FirmwareDialog(ActionsPanel.this.m_adapHelper);
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                    }
                });
            } else {
                jLabel.setText("<html><body>&nbsp&nbsp&nbsp<u>" + string + "</u></body></html>");
            }
        }
        if (this.m_adapHelper.getAdapterInfo().getmaxLDs() != '\u0000') {
            ++gridBagConstraints.gridy;
            string = Resource.getString("ACTION_SILENCE_ALARM", "Silence alarm");
            jLabel = new JLabel();
            object = new JPanel(new FlowLayout(0));
            ((JComponent)object).setBackground(MainFrame.BACKGROUND_COLOR);
            ((Container)object).add(jLabel);
            jPanel.add((Component)object, gridBagConstraints);
            if (bl && this.m_adapHelper.getAdapterProperties().getalarmEnable() != '\u0000') {
                jLabel.setText("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string + "\">" + string + "</a></body></html>");
                jLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        OperationDetails operationDetails = new OperationDetails(10, "Silence Alarm", "Temporarily quiets the controller alarm for the current event", null);
                        ActionsPanel.this.m_adapHelper.issueOperation(operationDetails);
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                    }
                });
            } else {
                jLabel.setText("<html><body>&nbsp&nbsp&nbsp<u>" + string + "</u></body></html>");
            }
        }
        this.add((Component)jPanel, "North");
    }

    @Override
    public void update(Observable observable, Object object) {
        MR_EVT_DETAIL mR_EVT_DETAIL;
        NotifyObject notifyObject = (NotifyObject)object;
        MR_EVT_DETAIL mR_EVT_DETAIL2 = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        GUIHelperInterface gUIHelperInterface = (GUIHelperInterface)((Object)observable);
        if (gUIHelperInterface instanceof AdapterHelper) {
            if (notifyObject.getNotifyCode() == 0x102001 || notifyObject.getNotifyCode() == 0x102002 || notifyObject.getNotifyCode() == 1056772) {
                this.updatePanel();
            }
            if (mR_EVT_DETAIL2 != null) {
                switch (mR_EVT_DETAIL2.getcode()) {
                    case 7: 
                    case 8: {
                        this.updatePanel();
                    }
                }
            }
        }
        if (notifyObject.getNotifyObject() instanceof MR_EVT_DETAIL && ((mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject()).getcode() == 65532 || mR_EVT_DETAIL.getcode() == 65533 || mR_EVT_DETAIL.getcode() == 65534 || mR_EVT_DETAIL.getcode() == 65535 || mR_EVT_DETAIL.getcode() == 65526 || mR_EVT_DETAIL.getcode() == 65525 || mR_EVT_DETAIL.getcode() == 65523 || mR_EVT_DETAIL.getcode() == 65522)) {
            try {
                ((SASAdapter)this.m_adapHelper.getDeviceObject()).refresh();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.validate();
            this.repaint();
        }
    }

    class CreateCSACacheCadeAction
    implements MouseListener {
        CreateCSACacheCadeAction() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                WizardController wizardController = new WizardController();
                HashMap hashMap = wizardController.getWizardData();
                hashMap.put("AdapterHelper", ActionsPanel.this.m_adapHelper);
                AdvanceConfigEngine advanceConfigEngine = new AdvanceConfigEngine(ActionsPanel.this.m_adapHelper);
                hashMap.put("AdvanceConfigEngine", advanceConfigEngine);
                wizardController.addPage(CSAModeSelectionPage.class.getName(), "CSAModeSelectionPage");
                wizardController.addPage(CSADriveGroupCreationPage.class.getName(), "CSADriveGroupCreationPage");
                wizardController.addPage(CSAVirtualDiskCreationPage.class.getName(), "CSAVirtualDiskCreationPage");
                wizardController.addPage(CSAConfigurationSummaryPage.class.getName(), "CSAConfigurationSummaryPage");
                wizardController.addPage(CSABootVolumeCreationPage.class.getName(), "CSABootVolumeCreationPage");
                wizardController.setFirstPage("CSADriveGroupCreationPage");
                try {
                    if (ActionsPanel.this.m_adapHelper.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getSupportDataLDonSSCArray() != 0) {
                        wizardController.setFirstPage("CSAModeSelectionPage");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                wizardController.addPageTransition("CSAModeSelectionPage", 0, "CSADriveGroupCreationPage");
                wizardController.addPageTransition("CSAHolesUnconfigPdSelectionPage", 2, "CSAVirtualDiskCreationPage");
                wizardController.addPageTransition("CSAHolesUnconfigPdSelectionPage", 3, "CSADriveGroupCreationPage");
                wizardController.addPageTransition("CSADriveGroupCreationPage", 0, "CSAVirtualDiskCreationPage");
                wizardController.addPageTransition("CSAVirtualDiskCreationPage", 0, "CSAConfigurationSummaryPage");
                wizardController.addPageTransition("CSAModeSelectionPage", 1, "CSABootVolumeCreationPage");
                wizardController.addPageTransition("CSABootVolumeCreationPage", 0, "CSAConfigurationSummaryPage");
                wizardController.launchWizard();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class UpdateFirmwareAction
    implements MouseListener {
        UpdateFirmwareAction() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            final VivaldiBaseDialog vivaldiBaseDialog = new VivaldiBaseDialog();
            JPanel jPanel = new JPanel(new FlowLayout(1));
            vivaldiBaseDialog.setTitle(Resource.getResourceMnemonic(Resource.getString("ADAPTER_OPERATION_4", "Load Firmware"))[0]);
            final OperationDetails operationDetails = new OperationDetails(3, "Update Controller Firmware", "Updates controller firmware with a specified firmware image", true);
            final OperationDetailPanel operationDetailPanel = new OperationDetailPanel(operationDetails, ActionsPanel.this.m_adapHelper);
            vivaldiBaseDialog.getContentPane().add((Component)operationDetailPanel, "Center");
            String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_LABEL_OK", "OK"));
            JButton jButton = new JButton(stringArray[0]);
            jButton.setToolTipText(Resource.getString("ABOUT_OKBUTTON_TEXT_DSC", "OK"));
            if (stringArray.length == 2) {
                jButton.setMnemonic(stringArray[1].charAt(0));
            }
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (operationDetails.getOpcode() == 0x1150000) {
                        operationDetailPanel.isReady();
                    } else if (operationDetailPanel.isReady() && ActionsPanel.this.m_adapHelper.isOperationAllowed(operationDetails.getOpcode())) {
                        ActionsPanel.this.m_adapHelper.issueOperation(operationDetails);
                    }
                    vivaldiBaseDialog.dispose();
                }
            });
            jPanel.add(jButton);
            String[] stringArray2 = Resource.getResourceMnemonic(Resource.getString("BUTTON_CANCEL_TEXT", "Go"));
            JButton jButton2 = new JButton(stringArray2[0]);
            jButton2.setToolTipText(Resource.getString("BUTTON_CANCEL_TEXT", "Go"));
            if (stringArray2.length == 2) {
                jButton2.setMnemonic(stringArray[1].charAt(0));
            }
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionPane jOptionPane = new JOptionPane(Resource.getString("CONFIG_CANCEL_MSG"), 3, 0);
                    JDialog jDialog = jOptionPane.createDialog(vivaldiBaseDialog, vivaldiBaseDialog.getTitle());
                    Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                    jDialog.setIconImage(image);
                    jDialog.setVisible(true);
                    Object object = jOptionPane.getValue();
                    if (object instanceof Integer) {
                        if ((Integer)object == 0) {
                            jDialog.dispose();
                            vivaldiBaseDialog.dispose();
                        } else {
                            jDialog.dispose();
                        }
                    }
                }
            });
            jPanel.add(jButton2);
            vivaldiBaseDialog.getContentPane().add((Component)jPanel, "South");
            vivaldiBaseDialog.setResizable(false);
            vivaldiBaseDialog.setModal(true);
            vivaldiBaseDialog.pack();
            GUIUtils.centerDialogOnScreen(vivaldiBaseDialog);
            vivaldiBaseDialog.setVisible(true);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class LoadConfigAction
    implements MouseListener {
        LoadConfigAction() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ConfigFileManager configFileManager = new ConfigFileManager(ActionsPanel.this.m_adapHelper);
            if (!configFileManager.loadConfig()) {
                new CustomMsgBox(Resource.getString("MSG_FAIL_ADD_CONFIG", "Add configuration failed"));
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class CreateSSCAction
    implements MouseListener {
        CreateSSCAction() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                WizardController wizardController = new WizardController();
                HashMap hashMap = wizardController.getWizardData();
                hashMap.put("AdapterHelper", ActionsPanel.this.m_adapHelper);
                AdvanceConfigEngine advanceConfigEngine = new AdvanceConfigEngine(ActionsPanel.this.m_adapHelper);
                hashMap.put("AdvanceConfigEngine", advanceConfigEngine);
                wizardController.addPage(SSCHolesUnconfigPdSelectionPage.class.getName(), "SSCHolesUnconfigPdSelectionPage");
                wizardController.addPage(SSCDriveGroupCreationPage.class.getName(), "SSCDriveGroupCreationPage");
                wizardController.addPage(SSCVirtualDiskCreationPage.class.getName(), "SSCVirtualDiskCreationPage");
                wizardController.addPage(SSCConfigurationSummaryPage.class.getName(), "SSCConfigurationSummaryPage");
                wizardController.setFirstPage("SSCDriveGroupCreationPage");
                wizardController.addPageTransition("SSCHolesUnconfigPdSelectionPage", 2, "SSCVirtualDiskCreationPage");
                wizardController.addPageTransition("SSCHolesUnconfigPdSelectionPage", 3, "SSCDriveGroupCreationPage");
                wizardController.addPageTransition("SSCDriveGroupCreationPage", 0, "SSCVirtualDiskCreationPage");
                wizardController.addPageTransition("SSCVirtualDiskCreationPage", 0, "SSCConfigurationSummaryPage");
                wizardController.launchWizard();
            }
            catch (WizardNavigationException wizardNavigationException) {
                wizardNavigationException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class CreateVDAction
    implements MouseListener {
        CreateVDAction() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                SimpleConfigEngine simpleConfigEngine = new SimpleConfigEngine(ActionsPanel.this.m_adapHelper);
                AdvanceConfigEngine advanceConfigEngine = new AdvanceConfigEngine(ActionsPanel.this.m_adapHelper);
                WizardController wizardController = new WizardController();
                HashMap hashMap = wizardController.getWizardData();
                hashMap.put("isSimpleAllowed", true);
                hashMap.put("SimpleConfigEngine", simpleConfigEngine);
                hashMap.put("AdapterHelper", ActionsPanel.this.m_adapHelper);
                hashMap.put("WarningDialogTitle", Resource.getString("CONFIG_CONFIRMATION_TITLE", "Create virtual Drive - Confirmation"));
                hashMap.put("AdvanceConfigEngine", advanceConfigEngine);
                wizardController.addPage(ModeSelectionPage.class.getName(), "ModeSelectionPage");
                wizardController.addPage(DriveGroupSelectionPage.class.getName(), "DriveGroupSelectionPage");
                wizardController.addPage(VirtualDriveSettingsPage.class.getName(), "VirtualDriveSettingsPage");
                wizardController.addPage(DriveGroupCreationPage.class.getName(), "AdvanceDGCreationPage");
                wizardController.addPage(VirtualDiskCreationPage.class.getName(), "AdvanceVDCreationPage");
                wizardController.addPage(ConfigurationSummaryPage.class.getName(), "ConfigurationSummaryPage");
                wizardController.setFirstPage("ModeSelectionPage");
                wizardController.addPageTransition("ModeSelectionPage", 0, "DriveGroupSelectionPage");
                wizardController.addPageTransition("ModeSelectionPage", 1, "VirtualDriveSettingsPage");
                wizardController.addPageTransition("DriveGroupSelectionPage", 0, "ConfigurationSummaryPage");
                wizardController.addPageTransition("DriveGroupSelectionPage", 1, "VirtualDriveSettingsPage");
                wizardController.addPageTransition("VirtualDriveSettingsPage", 0, "ConfigurationSummaryPage");
                wizardController.addPageTransition("ModeSelectionPage", 2, "AdvanceDGCreationPage");
                wizardController.addPageTransition("DriveGroupSelectionPage", 2, "AdvanceVDCreationPage");
                wizardController.addPageTransition("DriveGroupSelectionPage", 3, "AdvanceDGCreationPage");
                wizardController.addPageTransition("AdvanceDGCreationPage", 0, "AdvanceVDCreationPage");
                wizardController.addPageTransition("AdvanceVDCreationPage", 0, "ConfigurationSummaryPage");
                wizardController.launchWizard();
            }
            catch (WizardNavigationException wizardNavigationException) {
                wizardNavigationException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

