/*
 * Decompiled with CFR 0.152.
 */
package GUI.Dashboard;

import GUI.Dashboard.ControllerTabPanel;
import GUI.MainFrame;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.ServerObjectHelper;
import Utils.CustomTabbedPane;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class DashboardPanel
extends JPanel {
    private ServerObjectHelper m_servObjHelper = null;
    CustomTabbedPane m_controllerTabbedPane = null;

    public DashboardPanel(ServerObjectHelper serverObjectHelper) {
        this.m_servObjHelper = serverObjectHelper;
        this.updateControllerTabs(this.m_servObjHelper);
    }

    public ServerObjectHelper getServerObjectHelper() {
        return this.m_servObjHelper;
    }

    public void updateControllerTabs(ServerObjectHelper serverObjectHelper) {
        this.removeAll();
        this.m_servObjHelper = serverObjectHelper;
        this.setBackground(MainFrame.BACKGROUND_COLOR);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        AdapterHelper[] adapterHelperArray = this.m_servObjHelper.getAdapterHelpers();
        int n = adapterHelperArray.length;
        ControllerTabPanel[] controllerTabPanelArray = new ControllerTabPanel[n];
        this.m_controllerTabbedPane = new CustomTabbedPane();
        for (int i = 0; i < n; ++i) {
            controllerTabPanelArray[i] = new ControllerTabPanel(adapterHelperArray[i]);
            int n2 = 0;
            JScrollPane jScrollPane = new JScrollPane(controllerTabPanelArray[i]);
            if (MainFrame.SCREEN_SIZE.height - 320 < 450) {
                n2 = MainFrame.SCREEN_SIZE.height - 372;
                jScrollPane.setVerticalScrollBarPolicy(22);
            } else {
                n2 = 450;
            }
            if (MainFrame.SCREEN_SIZE.width < 1046) {
                jScrollPane.setHorizontalScrollBarPolicy(32);
            }
            jScrollPane.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width, n2));
            jScrollPane.setBackground(MainFrame.BACKGROUND_COLOR);
            String string = Resource.getString("CONTROLLER_TEXT", "Controller:") + " " + adapterHelperArray[i].getText();
            this.m_controllerTabbedPane.addTab(string, this.getImageIcon(adapterHelperArray[i].getDashboardStatusIcon()), jScrollPane, string);
            controllerTabPanelArray[i].setControllerTabbedPane(this.m_controllerTabbedPane, i);
        }
        jPanel.add((Component)this.m_controllerTabbedPane, "West");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
    }

    public void repaintControllerTabs() {
        int n = 0;
        JScrollPane jScrollPane = (JScrollPane)this.m_controllerTabbedPane.getSelectedComponent();
        if (MainFrame.DASHBOARD_SCREEN_SIZE.height - 320 < 450) {
            n = MainFrame.DASHBOARD_SCREEN_SIZE.height - 372;
            jScrollPane.setVerticalScrollBarPolicy(22);
        } else {
            n = 450;
        }
        if (MainFrame.DASHBOARD_SCREEN_SIZE.width < 1046) {
            jScrollPane.setHorizontalScrollBarPolicy(32);
        }
        jScrollPane.setPreferredSize(new Dimension(MainFrame.DASHBOARD_SCREEN_SIZE.width - 10, n));
        jScrollPane.setBackground(MainFrame.BACKGROUND_COLOR);
        jScrollPane.validate();
        jScrollPane.repaint();
        jScrollPane.updateUI();
        this.m_controllerTabbedPane.validate();
        this.m_controllerTabbedPane.repaint();
        this.m_controllerTabbedPane.updateUI();
        if (VivaldiStartupDialog.mainScreen != null) {
            VivaldiStartupDialog.mainScreen.repaint();
        }
    }

    public JTabbedPane getControllerTabbedPane() {
        return this.m_controllerTabbedPane;
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

