/*
 * Decompiled with CFR 0.152.
 */
package GUI.Dashboard;

import GUI.MainFrame;
import GUI.PremiumFeatures.PFKeyController;
import GUI.PremiumFeatures.PremiumFeature;
import GUI.PremiumFeatures.PremiumFeaturesDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.GUIHelperInterface;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_PROP;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.SASAdapter.SASAdapter;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class FeaturesPanel
extends JPanel
implements Observer {
    private AdapterHelper m_adapHelper = null;
    private MR_CTRL_INFO m_adapterInfo = null;
    private MR_CTRL_PROP m_adapterProp = null;
    String m_StringEnabled = Resource.getString("ENABLED_TEXT", "Enabled");
    String m_StringDisabled = Resource.getString("DISABLED_TEXT", "Disabled");
    private JLabel m_alarmLabelValue = new JLabel();
    private JLabel m_recoveryLabelValue = new JLabel();
    private JLabel m_sscLabelValue = new JLabel();
    private JLabel m_driveSecurityLabelValue = new JLabel();
    private JLabel m_UnconfSpinDownLabelValue = new JLabel();
    private JLabel m_HSPSpinDownLabelValue = new JLabel();
    private JLabel m_clusterLabelValue = new JLabel();
    private PFKeyController pfkeyHandle;
    String link = null;

    public FeaturesPanel(AdapterHelper adapterHelper) {
        this.m_adapHelper = adapterHelper;
        this.m_adapterInfo = this.m_adapHelper.getAdapterInfo();
        this.m_adapterProp = this.m_adapHelper.getAdapterProperties();
        this.m_adapHelper.addObserver(this);
        this.updatePanel();
    }

    public void updatePanel() {
        if (this.m_adapHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isPFKSupported()) {
            JLabel jLabel;
            String[] stringArray;
            int n;
            this.removeAll();
            this.setBackground(MainFrame.BACKGROUND_COLOR);
            TitledBorder titledBorder = new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), Resource.getString("PREMIUM_FEATURES_TEXT", "PremiumFeatures"));
            titledBorder.setTitleColor(MainFrame.TITLE_COLOR);
            this.setBorder(titledBorder);
            ArrayList<PremiumFeature> arrayList = this.getPFKeyControllerHandle().getFeatureList();
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setBackground(MainFrame.BACKGROUND_COLOR);
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 1.0;
            boolean bl = this.m_adapHelper.isViewOnlyMode();
            for (n = 0; n < arrayList.size(); ++n) {
                stringArray = new JLabel();
                stringArray.setText(arrayList.get(n).getFeatureName());
                jPanel.add((Component)stringArray, gridBagConstraints);
                this.add((Component)jPanel, "North");
                ++gridBagConstraints.gridx;
                jLabel = new JLabel();
                jLabel.setText(this.m_StringEnabled);
                jPanel.add((Component)jLabel, gridBagConstraints);
                this.add((Component)jPanel, "North");
                gridBagConstraints.gridx = 0;
                ++gridBagConstraints.gridy;
            }
            if (!bl && this.m_adapHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isPFKSupported()) {
                n = this.m_adapHelper.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getDisableOnlinePFKChange();
                stringArray = n != 1 ? Resource.getResourceMnemonic(Resource.getString("PFKEY_TITLE", "Manage Premium Features")) : Resource.getResourceMnemonic(Resource.getString("PFKEY_TITLE_BOOT", "Premium Features"));
                this.link = stringArray[0];
                jLabel = new JLabel();
                jLabel.setText("<html><body><a href=\"" + this.link + "\">" + this.link + "</a></body></html>");
                jLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        System.out.println("inside mouse click");
                        PremiumFeaturesDialog premiumFeaturesDialog = new PremiumFeaturesDialog(FeaturesPanel.this.m_adapHelper);
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                    }
                });
                JPanel jPanel2 = new JPanel(new FlowLayout(1));
                jPanel2.setBackground(MainFrame.BACKGROUND_COLOR);
                jPanel2.add(jLabel);
                jPanel.add((Component)jPanel2, gridBagConstraints);
                ++gridBagConstraints.gridy;
                if (arrayList.size() == 0) {
                    this.add((Component)jPanel, "North");
                }
            }
        } else {
            this.removeAll();
            this.setBackground(MainFrame.BACKGROUND_COLOR);
            TitledBorder titledBorder = new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), Resource.getString("FEATURES_TEXT", "Features"));
            titledBorder.setTitleColor(MainFrame.TITLE_COLOR);
            this.setBorder(titledBorder);
            this.setLayout(new GridLayout(7, 2, 0, 0));
            this.add(new JLabel(Resource.getString("ALARM_TEXT", "Alarm:"), 2));
            this.m_alarmLabelValue.setText(this.m_adapterProp.getalarmEnable() != '\u0000' ? this.m_StringEnabled : this.m_StringDisabled);
            this.m_alarmLabelValue.setHorizontalAlignment(0);
            this.add(this.m_alarmLabelValue);
            this.add(new JLabel(Resource.getString("MEGARAID_RECOVERY_TEXT", "MegaRAID recovery:"), 2));
            this.m_recoveryLabelValue.setText(this.m_adapterInfo.getadapterOperations_MR_CTRL_INFO().isSupportSnapshot() ? this.m_StringEnabled : this.m_StringDisabled);
            this.m_recoveryLabelValue.setHorizontalAlignment(0);
            this.add(this.m_recoveryLabelValue);
            this.add(new JLabel(Resource.getString("SUPER_SIZED_CACHE_TEXT", "CacheCade\u2122:"), 2));
            this.m_sscLabelValue.setText(this.m_adapterInfo.getMaxSSCsize() != 0 ? this.m_StringEnabled : this.m_StringDisabled);
            this.m_sscLabelValue.setHorizontalAlignment(0);
            this.add(this.m_sscLabelValue);
            this.add(new JLabel(Resource.getString("DRIVE_SECURITY_TEXT", "Drive security:"), 2));
            this.m_driveSecurityLabelValue.setText(this.m_adapHelper.isLockKeyAssigned() ? this.m_StringEnabled : this.m_StringDisabled);
            this.m_driveSecurityLabelValue.setHorizontalAlignment(0);
            this.add(this.m_driveSecurityLabelValue);
            this.add(new JLabel(Resource.getString("UNCONFGOOD_SPIN_DOWN_TEXT", "Unconfigured good spin down:"), 2));
            this.m_UnconfSpinDownLabelValue.setText(this.m_adapterProp.getOnOffProperties_MR_CTRL_PROP().isSpinDownUnconfiguredDrivesEnabled() ? this.m_StringEnabled : this.m_StringDisabled);
            this.m_UnconfSpinDownLabelValue.setHorizontalAlignment(0);
            this.add(this.m_UnconfSpinDownLabelValue);
            this.add(new JLabel(Resource.getString("HSP_SPIN_DOWN_TEXT", "Hot spare spin down:"), 2));
            this.m_HSPSpinDownLabelValue.setText(this.m_adapterProp.getOnOffProperties_MR_CTRL_PROP().isdisableSpinDownHS() ? this.m_StringDisabled : this.m_StringEnabled);
            this.m_HSPSpinDownLabelValue.setHorizontalAlignment(0);
            this.add(this.m_HSPSpinDownLabelValue);
            this.add(new JLabel(Resource.getString("CLUSTER_TEXT", "Cluster:"), 2));
            this.m_clusterLabelValue.setText(this.m_adapterProp.getclusterEnable() != '\u0000' ? this.m_StringEnabled : this.m_StringDisabled);
            this.m_clusterLabelValue.setHorizontalAlignment(0);
            this.add(this.m_clusterLabelValue);
        }
    }

    private PFKeyController getPFKeyControllerHandle() {
        if (this.pfkeyHandle == null) {
            this.pfkeyHandle = new PFKeyController((SASAdapter)this.m_adapHelper.getDeviceObject());
        }
        return this.pfkeyHandle;
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object == null) {
            return;
        }
        NotifyObject notifyObject = (NotifyObject)object;
        if (!(notifyObject.getNotifyObject() instanceof MR_EVT_DETAIL)) {
            return;
        }
        GUIHelperInterface gUIHelperInterface = (GUIHelperInterface)((Object)observable);
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL != null && gUIHelperInterface instanceof AdapterHelper) {
            switch (mR_EVT_DETAIL.getcode()) {
                case 7: 
                case 8: {
                    this.m_alarmLabelValue.setText(this.m_adapterProp.getalarmEnable() != '\u0000' ? this.m_StringEnabled : this.m_StringDisabled);
                    this.m_alarmLabelValue.repaint();
                    break;
                }
                case 191: 
                case 192: {
                    this.m_clusterLabelValue.setText(this.m_adapterProp.getclusterEnable() != '\u0000' ? this.m_StringEnabled : this.m_StringDisabled);
                    this.m_clusterLabelValue.repaint();
                    break;
                }
                case 303: {
                    this.m_UnconfSpinDownLabelValue.setText(this.m_adapterProp.getOnOffProperties_MR_CTRL_PROP().isSpinDownUnconfiguredDrivesEnabled() ? this.m_StringEnabled : this.m_StringDisabled);
                    this.m_UnconfSpinDownLabelValue.repaint();
                }
            }
        }
    }
}

