/*
 * Decompiled with CFR 0.152.
 */
package GUI.Dashboard;

import GUI.MainFrame;
import GUIHelper.AdapterHelper;
import SASKernel.SASAdapter.SASAdapter;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class HelpPanel
extends JPanel
implements HelpInterface {
    private AdapterHelper m_adapHelper = null;
    private String m_strHelpPage;
    private boolean isAdapterMR = false;
    private boolean isWarhawk = false;
    private boolean m_isCSA = false;

    public HelpPanel(AdapterHelper adapterHelper) {
        this.m_adapHelper = adapterHelper;
        this.isAdapterMR = ((SASAdapter)this.m_adapHelper.getDeviceObject()).getAdapterType() == 1;
        if (!this.isAdapterMR) {
            this.isWarhawk = ((SASAdapter)this.m_adapHelper.getDeviceObject()).isWarhawk();
        }
        this.m_isCSA = this.m_adapHelper.isCSA();
        this.updatePanel();
    }

    public void updatePanel() {
        JPanel jPanel;
        JLabel jLabel;
        this.removeAll();
        this.setBackground(MainFrame.BACKGROUND_COLOR);
        TitledBorder titledBorder = new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), Resource.getString("HELP_TEXT", "Help"));
        titledBorder.setTitleColor(MainFrame.TITLE_COLOR);
        this.setBorder(titledBorder);
        this.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(MainFrame.BACKGROUND_COLOR);
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        String string = Resource.getString("USE_MSM_TEXT", "How to use MSM?");
        JLabel jLabel2 = new JLabel("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string + "\">" + string + "</a></body></html>");
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.setBackground(MainFrame.BACKGROUND_COLOR);
        jPanel3.add(jLabel2);
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (HelpPanel.this.m_isCSA) {
                    HelpPanel.this.m_strHelpPage = "MSM_CSA_MEGARAID_STORAGE_MANAGER_WINDOW_AND_MENUS";
                } else if (HelpPanel.this.isAdapterMR) {
                    HelpPanel.this.m_strHelpPage = "MR_MEGARAID_STORAGE_MANAGER_WINDOW";
                } else {
                    HelpPanel.this.m_strHelpPage = "IR_MEGARAID_STORAGE_MANAGER_WINDOW";
                }
                HelpContext.executeHelpProcess(HelpPanel.this.getHelpPage());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        if (!this.isWarhawk && this.m_adapHelper.getAdapterInfo().getmaxLDs() != '\u0000') {
            ++gridBagConstraints.gridy;
            string = Resource.getString("CREATE_VIRTUAL_DRIVE_TEXT", "How to create virtual drive?");
            jLabel = new JLabel("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string + "\">" + string + "</a></body></html>");
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBackground(MainFrame.BACKGROUND_COLOR);
            jPanel.add(jLabel);
            jPanel2.add((Component)jPanel, gridBagConstraints);
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (HelpPanel.this.m_isCSA) {
                        HelpPanel.this.m_strHelpPage = "MSM_CSA_CREATING_A_NEW_STORAGE_CONFIGURATION_USING_MSM";
                    } else if (HelpPanel.this.isAdapterMR) {
                        HelpPanel.this.m_strHelpPage = "MR_CREATING_A_NEW_CONFIGURATION";
                    } else {
                        HelpPanel.this.m_strHelpPage = "IR_CREATING_A_NEW_CONFIGURATION";
                    }
                    HelpContext.executeHelpProcess(HelpPanel.this.getHelpPage());
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            });
            ++gridBagConstraints.gridy;
            string = Resource.getString("ENABLE_PREMIUM_FEATURE_TEXT", "How to enable premium feature?");
            JLabel jLabel3 = new JLabel("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string + "\">" + string + "</a></body></html>");
            JPanel jPanel4 = new JPanel(new FlowLayout(0));
            jPanel4.setBackground(MainFrame.BACKGROUND_COLOR);
            jPanel4.add(jLabel3);
            if (!this.m_adapHelper.isCSA()) {
                jPanel2.add((Component)jPanel4, gridBagConstraints);
            }
            jLabel3.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (HelpPanel.this.isAdapterMR) {
                        HelpPanel.this.m_strHelpPage = "MR_USING_MEGARAID_ADVANCED_SOFTWARE";
                    } else {
                        HelpPanel.this.m_strHelpPage = "HELP_PAGE_DEFAULT";
                    }
                    HelpContext.executeHelpProcess(HelpPanel.this.getHelpPage());
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            });
        }
        this.m_strHelpPage = "MR_USING_MEGARAID_ADVANCED_SOFTWARE";
        ++gridBagConstraints.gridy;
        string = Resource.getString("GLOSSARY_TEXT", "Glossary");
        jLabel = new JLabel("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string + "\">" + string + "</a></body></html>");
        jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBackground(MainFrame.BACKGROUND_COLOR);
        jPanel.add(jLabel);
        jPanel2.add((Component)jPanel, gridBagConstraints);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (HelpPanel.this.m_isCSA) {
                    HelpPanel.this.m_strHelpPage = "MSM_CSA_GLOSSARY";
                } else if (HelpPanel.this.isAdapterMR) {
                    HelpPanel.this.m_strHelpPage = "MR_GLOSSARY";
                } else {
                    HelpPanel.this.m_strHelpPage = "IR_GLOSSARY";
                }
                HelpContext.executeHelpProcess(HelpPanel.this.getHelpPage());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        this.add((Component)jPanel2, "North");
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpPage);
    }
}

