/*
 * Decompiled with CFR 0.152.
 */
package GUI.Dashboard;

import GUI.MainFrame;
import GUI.PremiumFeatures.PFKeyController;
import GUI.PremiumFeatures.PremiumFeature;
import GUI.PremiumFeatures.PremiumFeaturesDialog;
import GUIHelper.AdapterHelper;
import SASKernel.SASAdapter.SASAdapter;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class IRPremiumFeaturesPanel
extends JPanel
implements Observer {
    private String m_StringEnabled = Resource.getString("ENABLED_TEXT", "Enabled");
    private String m_StringDisabled = Resource.getString("DISABLED_TEXT", "Disabled");
    private AdapterHelper m_adapHelper = null;
    private PFKeyController pfkeyHandle;

    public IRPremiumFeaturesPanel(AdapterHelper adapterHelper) {
        this.m_adapHelper = adapterHelper;
        this.updatePanel();
    }

    public void updatePanel() {
        String[] stringArray;
        int n;
        this.removeAll();
        this.setBackground(MainFrame.BACKGROUND_COLOR);
        TitledBorder titledBorder = new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), Resource.getString("IR_ADV_SOFWARE_OPTIONS_TEXT", "Advanced Software Options"));
        titledBorder.setTitleColor(MainFrame.TITLE_COLOR);
        this.setBorder(titledBorder);
        ArrayList<PremiumFeature> arrayList = this.getPFKeyControllerHandle().getFeatureList();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(MainFrame.BACKGROUND_COLOR);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        for (n = 0; n < arrayList.size(); ++n) {
            JLabel jLabel = new JLabel();
            jLabel.setText(arrayList.get(n).getFeatureName());
            jPanel.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridx;
            stringArray = new JLabel();
            stringArray.setText(this.m_StringEnabled);
            jPanel.add((Component)stringArray, gridBagConstraints);
            this.add((Component)jPanel, "North");
        }
        n = this.m_adapHelper.isViewOnlyMode() ? 1 : 0;
        if (n == 0) {
            int n2 = this.m_adapHelper.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getDisableOnlinePFKChange();
            boolean bl = this.m_adapHelper.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getDisableOnlinePFKChange() != 1;
            stringArray = bl ? Resource.getResourceMnemonic(Resource.getString("IR_MANAGE_ADV_SOFTWARE_OPTIONS_TEXT", "Manag(e) Advanced Software Options")) : Resource.getResourceMnemonic(Resource.getString("IR_ADV_SOFTWARE_OPTIONS_TEXT", "(A)dvanced Software Options"));
            String string = stringArray[0];
            JLabel jLabel = new JLabel();
            jLabel.setText("<html><body><a href=\"" + string + "\">" + string + "</a></body></html>");
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    PremiumFeaturesDialog premiumFeaturesDialog = new PremiumFeaturesDialog(IRPremiumFeaturesPanel.this.m_adapHelper);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            });
            JPanel jPanel2 = new JPanel(new FlowLayout(1));
            jPanel2.setBackground(MainFrame.BACKGROUND_COLOR);
            jPanel2.add(jLabel);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            jPanel.add((Component)jPanel2, gridBagConstraints);
            this.add((Component)jPanel, "North");
        }
    }

    private PFKeyController getPFKeyControllerHandle() {
        if (this.pfkeyHandle == null) {
            this.pfkeyHandle = new PFKeyController((SASAdapter)this.m_adapHelper.getDeviceObject());
        }
        return this.pfkeyHandle;
    }

    @Override
    public void update(Observable observable, Object object) {
    }
}

