/*
 * Decompiled with CFR 0.152.
 */
package GUI.Dashboard;

import GUI.MainFrame;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.ProgressInfo;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import Utils.Resource;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressBars
extends JPanel
implements Observer {
    private GUIHelperInterface m_guiHelper;
    private ProgressInfo m_progressInfo;
    private JProgressBar m_progressBar;
    private JPanel m_progPanel;
    GridBagConstraints m_gbc;
    private JLabel m_opName;
    private JLabel brea;
    private JLabel m_percentCompleted;

    public ProgressBars(GUIHelperInterface gUIHelperInterface) {
        String string;
        block7: {
            this.m_progPanel = new JPanel();
            this.m_gbc = new GridBagConstraints();
            this.m_opName = new JLabel();
            this.brea = new JLabel();
            this.m_percentCompleted = new JLabel("", null, 4);
            this.m_guiHelper = gUIHelperInterface;
            this.setLayout(new GridBagLayout());
            this.setBackground(MainFrame.BACKGROUND_COLOR);
            this.m_gbc.gridx = 0;
            this.m_gbc.gridy = 0;
            this.m_gbc.insets = new Insets(0, 10, 5, 10);
            this.m_gbc.anchor = 11;
            this.m_progPanel.setLayout(new GridLayout(4, 1, 5, 0));
            this.m_progPanel.setBackground(MainFrame.BACKGROUND_COLOR);
            string = null;
            if (this.m_guiHelper instanceof PhysicalDriveHelper) {
                try {
                    if (this.m_guiHelper.getProgressInfo().opCode == 34275584) {
                        string = ((PhysicalDriveHelper)this.m_guiHelper).getCopyBackPDText();
                        break block7;
                    }
                    string = ((PhysicalDriveHelper)this.m_guiHelper).getText(true);
                }
                catch (Exception exception) {
                    string = ((PhysicalDriveHelper)this.m_guiHelper).getText(true);
                }
            } else {
                string = this.m_guiHelper.getText();
            }
        }
        this.m_progPanel.add(new JLabel(string));
        this.m_progPanel.add(this.m_opName);
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setStringPainted(false);
        ProgressInfo progressInfo = null;
        progressInfo = this.m_guiHelper.getProgressInfo();
        if (!progressInfo.state) {
            this.m_progPanel.add(this.m_progressBar);
            this.m_progPanel.add(this.m_percentCompleted);
        } else {
            this.brea.setText("<html><br></html>");
            this.m_progPanel.add(this.brea);
            this.m_opName.setText(progressInfo.text);
            this.m_progPanel.add(this.m_opName);
        }
        this.add((Component)this.m_progPanel, this.m_gbc);
        this.refresh();
        ((Observable)((Object)this.m_guiHelper)).addObserver(this);
    }

    private synchronized void refresh() {
        try {
            this.m_progressInfo = this.m_guiHelper.getProgressInfo();
            this.setVisible(true);
        }
        catch (Exception exception) {
            this.setVisible(false);
            return;
        }
        ProgressInfo progressInfo = null;
        progressInfo = this.m_guiHelper.getProgressInfo();
        if (!progressInfo.state) {
            this.m_opName.setText(this.m_progressInfo.text + ":");
        }
        this.m_progressBar.setValue((int)this.m_progressInfo.value);
        this.m_percentCompleted.setText((int)this.m_progressInfo.value + "%" + Resource.getString("COMPLETED_TEXT", "Completed"));
        this.m_progressBar.setToolTipText((int)this.m_progressInfo.value + "%" + Resource.getString("COMPLETED_TEXT", "Completed"));
        this.validate();
        this.repaint();
    }

    public void busy() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    public void ready() {
        this.setCursor(Cursor.getDefaultCursor());
        this.setEnabled(true);
    }

    public void remove() {
        if (this.m_guiHelper instanceof LogicalDriveHelper) {
            ((LogicalDriveHelper)this.m_guiHelper).deleteObserver(this);
        } else if (this.m_guiHelper instanceof PhysicalDriveHelper) {
            ((PhysicalDriveHelper)this.m_guiHelper).deleteObserver(this);
        }
        this.m_progressBar.setValue(0);
        this.m_progressBar.setVisible(false);
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        switch (mR_EVT_DETAIL.getargType()) {
            case '\u0007': 
            case '\u000e': {
                this.refresh();
                break;
            }
        }
    }
}

