/*
 * Decompiled with CFR 0.152.
 */
package GUI.Dashboard;

import GUI.Dashboard.ProgressBars;
import GUI.GroupShowProgressDialog;
import GUI.MainFrame;
import GUIHelper.AdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.ServerObjectHelper;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_PD_PROGRESS;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.Resource;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ProgressPanels
extends JPanel
implements Observer {
    private JPanel m_physicalPart = new JPanel(new GridLayout(0, 1, 0, 20));
    private JPanel m_virtualPart = new JPanel(new GridLayout(0, 1, 0, 20));
    JScrollPane m_virtualScrollPane = null;
    JScrollPane m_physicalScrollPane = null;
    private String[] m_virtualMnemonics = Resource.getResourceMnemonic(Resource.getString("VDOP_PROGRESS_TEXT", "(V)irtual drive operations in progress"));
    private String[] m_physicalMnemonics = Resource.getResourceMnemonic(Resource.getString("PDOP_PROGRESS_TEXT", "(P)hysical drive operations in progress"));
    JLabel m_virtualScrollPaneLabel = new JLabel();
    JLabel m_physicalScrollPaneLabel = new JLabel();
    private int m_prevVirtualCount = 0;
    private int m_prevPhysicalCount = 0;
    private LogicalDriveHelper[] logi;
    private PhysicalDriveHelper[] phys;
    private AdapterHelper m_adapterHelper;
    private Hashtable progHash = new Hashtable();

    public ProgressPanels(AdapterHelper adapterHelper) {
        this.m_adapterHelper = adapterHelper;
        this.updatePanel(adapterHelper);
        this.m_adapterHelper.addObserver(this);
    }

    public void updatePanel(AdapterHelper adapterHelper) {
        this.removeAll();
        if (this.m_virtualScrollPane != null) {
            this.m_virtualScrollPane.removeAll();
        }
        if (this.m_physicalScrollPane != null) {
            this.m_physicalScrollPane.removeAll();
        }
        this.setBackground(MainFrame.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        this.m_virtualPart.setBackground(MainFrame.BACKGROUND_COLOR);
        this.m_virtualScrollPane = new JScrollPane(this.m_virtualPart, 20, 30);
        this.m_virtualScrollPane.setPreferredSize(new Dimension(250, 60));
        if (this.m_virtualMnemonics.length == 2) {
            this.m_virtualScrollPaneLabel.setDisplayedMnemonic(this.m_virtualMnemonics[1].charAt(0));
            this.m_virtualScrollPaneLabel.setLabelFor(this.m_virtualScrollPane);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.m_virtualScrollPaneLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.m_virtualScrollPane, gridBagConstraints);
        this.m_physicalPart.setBackground(MainFrame.BACKGROUND_COLOR);
        this.m_physicalScrollPane = new JScrollPane(this.m_physicalPart, 20, 30);
        this.m_physicalScrollPane.setPreferredSize(new Dimension(250, 60));
        if (this.m_physicalMnemonics.length == 2) {
            this.m_physicalScrollPaneLabel.setDisplayedMnemonic(this.m_physicalMnemonics[1].charAt(0));
            this.m_physicalScrollPaneLabel.setLabelFor(this.m_physicalScrollPane);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.m_physicalScrollPaneLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.m_physicalScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        String string = Resource.getString("MORE_DETAILS_TEXT", "More details");
        JLabel jLabel = new JLabel("<html><body><a href=\"" + string + "\">" + string + "</a></body></html>");
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                new GroupShowProgressDialog((ServerObjectHelper)ProgressPanels.this.m_adapterHelper.getParent());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        this.add((Component)jLabel, gridBagConstraints);
        this.refresh();
    }

    private void updateLDProgress() {
        int n = 0;
        this.m_virtualPart.removeAll();
        for (int i = 0; i < this.logi.length; ++i) {
            try {
                if (this.logi[i].getProgressInfo() == null) continue;
                ProgressBars progressBars = new ProgressBars(this.logi[i]);
                this.progHash.put(this.logi[i], progressBars);
                this.m_virtualPart.add(progressBars);
                ++n;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_prevVirtualCount = n;
        this.m_virtualScrollPaneLabel.setText(this.m_virtualMnemonics[0] + ": " + this.m_prevVirtualCount);
        this.m_virtualPart.validate();
        this.m_virtualPart.repaint();
    }

    private void updatePDProgress() {
        int n = 0;
        this.m_physicalPart.removeAll();
        for (int i = 0; i < this.phys.length; ++i) {
            try {
                if (this.phys[i].getProgressInfo() == null) continue;
                ProgressBars progressBars = new ProgressBars(this.phys[i]);
                this.progHash.put(this.phys[i], progressBars);
                this.m_physicalPart.add(progressBars);
                ++n;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_prevPhysicalCount = n;
        this.m_physicalScrollPaneLabel.setText(this.m_physicalMnemonics[0] + ": " + this.m_prevPhysicalCount);
        this.m_physicalPart.validate();
        this.m_physicalPart.repaint();
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        GUIHelperInterface gUIHelperInterface = (GUIHelperInterface)((Object)observable);
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (gUIHelperInterface instanceof AdapterHelper) {
            if (notifyObject.getNotifyCode() == 0x102001 || notifyObject.getNotifyCode() == 0x102002 || notifyObject.getNotifyCode() == 1056772) {
                this.refresh();
            }
            if (mR_EVT_DETAIL != null) {
                switch (mR_EVT_DETAIL.getcode()) {
                    case 35: {
                        this.phys = this.m_adapterHelper.getPhysicalDrives();
                        int n2 = this.phys.length;
                        for (int i = 0; i < n2; ++i) {
                            short s = ((SASPhysicalDrive)this.phys[i].getDeviceObject()).getState();
                            if (s != 24 && s != 2) continue;
                            this.phys[i].getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().setpatrol(0);
                        }
                        this.refresh();
                        break;
                    }
                    case 37: 
                    case 39: 
                    case 279: {
                        this.refresh();
                        break;
                    }
                    case 36: {
                        this.refresh();
                        this.validate();
                        this.repaint();
                        break;
                    }
                    case 38: {
                        this.refresh();
                        this.validate();
                        this.repaint();
                        break;
                    }
                    case 419: {
                        this.refresh();
                    }
                }
            }
        } else {
            try {
                switch (n) {
                    case 52: 
                    case 53: 
                    case 65: 
                    case 66: 
                    case 69: 
                    case 71: 
                    case 77: 
                    case 80: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 276: 
                    case 281: 
                    case 422: 
                    case 423: 
                    case 427: 
                    case 435: 
                    case 438: {
                        if (gUIHelperInterface.getProgressInfo() == null || this.progHash.containsKey(gUIHelperInterface)) break;
                        System.out.println("here... ");
                        ProgressBars progressBars = new ProgressBars(gUIHelperInterface);
                        this.progHash.put(gUIHelperInterface, progressBars);
                        if (gUIHelperInterface instanceof LogicalDriveHelper) {
                            ++this.m_prevVirtualCount;
                            this.m_virtualScrollPaneLabel.setText(this.m_virtualMnemonics[0] + ": " + this.m_prevVirtualCount);
                            this.m_virtualScrollPaneLabel.repaint();
                            this.m_virtualPart.add(progressBars);
                            this.m_virtualPart.validate();
                            this.m_virtualPart.repaint();
                            break;
                        }
                        if (gUIHelperInterface instanceof PhysicalDriveHelper) {
                            ++this.m_prevPhysicalCount;
                            this.m_physicalScrollPaneLabel.setText(this.m_physicalMnemonics[0] + ": " + this.m_prevPhysicalCount);
                            this.m_physicalScrollPaneLabel.repaint();
                            this.m_physicalPart.add(progressBars);
                            this.m_physicalPart.validate();
                            this.m_physicalPart.repaint();
                        }
                        break;
                    }
                    case 428: {
                        if (this.progHash.containsKey(gUIHelperInterface)) break;
                        ProgressBars progressBars = new ProgressBars(gUIHelperInterface);
                        if (!(gUIHelperInterface instanceof LogicalDriveHelper) || this.progHash.containsKey(gUIHelperInterface)) break;
                        this.progHash.put(gUIHelperInterface, progressBars);
                        ++this.m_prevVirtualCount;
                        this.m_virtualScrollPaneLabel.setText(this.m_virtualMnemonics[0] + ": " + this.m_prevVirtualCount);
                        this.m_virtualScrollPaneLabel.repaint();
                        this.m_virtualPart.add(progressBars);
                        this.m_virtualPart.validate();
                        this.m_virtualPart.repaint();
                        PhysicalDriveHelper[] physicalDriveHelperArray = ((LogicalDriveHelper)gUIHelperInterface).getPDListInLd();
                        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                            PhysicalDriveHelper physicalDriveHelper = physicalDriveHelperArray[i];
                            if (!((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).isPRStoppedBySecureErase()) continue;
                            if (!this.progHash.containsKey(physicalDriveHelper)) break;
                            ProgressBars progressBars2 = (ProgressBars)this.progHash.get(physicalDriveHelper);
                            progressBars2.remove();
                            this.progHash.remove(physicalDriveHelper);
                            this.m_physicalPart.remove(progressBars2);
                            --this.m_prevPhysicalCount;
                        }
                        this.m_physicalScrollPaneLabel.setText(this.m_physicalMnemonics[0] + ": " + this.m_prevPhysicalCount);
                        this.m_physicalScrollPaneLabel.repaint();
                        this.validate();
                        this.repaint();
                        break;
                    }
                    case 94: {
                        MR_PD_PROGRESS mR_PD_PROGRESS = ((PhysicalDriveHelper)gUIHelperInterface).getInformation().getprogInfo();
                        if ((int)mR_PD_PROGRESS.getpatrol().getprogress() != 100) {
                            if (gUIHelperInterface.getProgressInfo() == null || this.progHash.containsKey(gUIHelperInterface)) break;
                            ProgressBars progressBars = new ProgressBars(gUIHelperInterface);
                            this.progHash.put(gUIHelperInterface, progressBars);
                            if (gUIHelperInterface instanceof LogicalDriveHelper) {
                                ++this.m_prevVirtualCount;
                                this.m_virtualScrollPaneLabel.setText(this.m_virtualMnemonics[0] + ": " + this.m_prevVirtualCount);
                                this.m_virtualScrollPaneLabel.repaint();
                                this.m_virtualPart.add(progressBars);
                                this.m_virtualPart.validate();
                                this.m_virtualPart.repaint();
                                break;
                            }
                            if (gUIHelperInterface instanceof PhysicalDriveHelper) {
                                ++this.m_prevPhysicalCount;
                                this.m_physicalScrollPaneLabel.setText(this.m_physicalMnemonics[0] + ": " + this.m_prevPhysicalCount);
                                this.m_physicalScrollPaneLabel.repaint();
                                this.m_physicalPart.add(progressBars);
                                this.m_physicalPart.validate();
                                this.m_physicalPart.repaint();
                            }
                            break;
                        }
                        if (!this.progHash.containsKey(gUIHelperInterface)) break;
                        ProgressBars progressBars = (ProgressBars)this.progHash.get(gUIHelperInterface);
                        progressBars.remove();
                        if (gUIHelperInterface instanceof PhysicalDriveHelper) {
                            --this.m_prevPhysicalCount;
                            this.m_physicalScrollPaneLabel.setText(this.m_physicalMnemonics[0] + ": " + this.m_prevPhysicalCount);
                            this.m_physicalScrollPaneLabel.repaint();
                            this.m_physicalPart.remove(progressBars);
                        }
                        this.progHash.remove(gUIHelperInterface);
                        this.validate();
                        this.repaint();
                        break;
                    }
                    case 46: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 61: 
                    case 62: 
                    case 67: 
                    case 68: 
                    case 72: 
                    case 74: 
                    case 75: 
                    case 98: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 107: 
                    case 277: 
                    case 278: 
                    case 282: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 420: 
                    case 421: 
                    case 424: 
                    case 425: 
                    case 426: 
                    case 429: 
                    case 436: 
                    case 437: 
                    case 439: 
                    case 445: {
                        if (!this.progHash.containsKey(gUIHelperInterface)) break;
                        ProgressBars progressBars = (ProgressBars)this.progHash.get(gUIHelperInterface);
                        progressBars.remove();
                        if (gUIHelperInterface instanceof LogicalDriveHelper) {
                            --this.m_prevVirtualCount;
                            this.m_virtualScrollPaneLabel.setText(this.m_virtualMnemonics[0] + ": " + this.m_prevVirtualCount);
                            this.m_virtualScrollPaneLabel.repaint();
                            this.m_virtualPart.remove(progressBars);
                        } else if (gUIHelperInterface instanceof PhysicalDriveHelper) {
                            --this.m_prevPhysicalCount;
                            this.m_physicalScrollPaneLabel.setText(this.m_physicalMnemonics[0] + ": " + this.m_prevPhysicalCount);
                            this.m_physicalScrollPaneLabel.repaint();
                            this.m_physicalPart.remove(progressBars);
                        }
                        this.progHash.remove(gUIHelperInterface);
                        this.validate();
                        this.repaint();
                        break;
                    }
                    case 407: 
                    case 409: 
                    case 411: 
                    case 412: 
                    case 413: {
                        this.refresh();
                        this.validate();
                        this.repaint();
                        break;
                    }
                    case 78: 
                    case 104: 
                    case 280: 
                    case 408: 
                    case 410: {
                        this.refresh();
                        this.validate();
                        this.repaint();
                        break;
                    }
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: {
                        this.refresh();
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void refresh() {
        int n;
        this.progHash.clear();
        this.logi = this.m_adapterHelper.getLogicalDrives();
        this.phys = this.m_adapterHelper.getPhysicalDrives();
        this.updateLDProgress();
        this.updatePDProgress();
        for (n = 0; n < this.logi.length; ++n) {
            this.logi[n].addObserver(this);
        }
        for (n = 0; n < this.phys.length; ++n) {
            this.phys[n].addObserver(this);
        }
    }
}

