/*
 * Decompiled with CFR 0.152.
 */
package GUI.Dashboard;

import GUI.Dashboard.ServerProfileSummaryGenerator;
import GUI.Dashboard.ServerProfileSummaryPanel;
import GUI.MainFrame;
import GUIHelper.AdapterHelper;
import GUIHelper.BBUHelper;
import GUIHelper.EnclosureHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDevice;
import Services.KernelConstants;
import Utils.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class PropertiesPanel
extends JPanel
implements Observer {
    private AdapterHelper m_adapHelper = null;
    private JLabel m_statusLabeltext = new JLabel();
    private JLabel m_statusLabelValue = new JLabel();
    private JLabel m_statusHAClustertext = new JLabel();
    private JLabel m_HAClusterValue = new JLabel();
    private JLabel m_enclosuresLabelValue = new JLabel();
    private JLabel m_backplanesLabelValue = new JLabel();
    private JLabel m_drivesLabelValue = new JLabel();
    private JLabel m_driveGroupsLabelValue = new JLabel();
    private JLabel m_virtualDrivesLabelValue = new JLabel();
    SASAdapter adapter = null;
    private boolean isWarhawk = false;
    private JLabel m_ssdLifeLeftTxt = new JLabel();
    private JLabel m_ssdLifeLeftVal = new JLabel();
    private JLabel m_vdPermissionTxt = new JLabel();
    private JLabel m_vdPermissionVal = new JLabel();
    private JLabel m_totalCapacityTxt = new JLabel();
    private JLabel m_totalCapacityVal = new JLabel();
    private JLabel m_ddStatusTxt = new JLabel();
    private JLabel m_ddStatusVal = new JLabel();
    private JLabel m_alarmPresentTxt = new JLabel();
    private JLabel m_alarmPresentVal = new JLabel();
    private JLabel m_lifeCurveStatusTxt = new JLabel();
    private JLabel m_lifeCurveStatusVal = new JLabel();
    private JLabel m_auxiliaryPowerTxt = new JLabel();
    private JLabel m_auxiliaryPowerVal = new JLabel();
    private JTabbedPane m_ctrlTabbedPane = null;
    private int m_index = 0;

    public PropertiesPanel(AdapterHelper adapterHelper) {
        this.m_adapHelper = adapterHelper;
        if (this.m_adapHelper.getDeviceObject() != null) {
            this.adapter = (SASAdapter)this.m_adapHelper.getDeviceObject();
            this.isWarhawk = this.adapter.isWarhawk();
        }
        this.updatePanel();
        this.addObservers();
    }

    public void updatePanel() {
        this.removeAll();
        this.setBackground(MainFrame.BACKGROUND_COLOR);
        TitledBorder titledBorder = new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), Resource.getString("PROPERTIES_TEXT", "Properties"));
        titledBorder.setTitleColor(MainFrame.TITLE_COLOR);
        this.setBorder(titledBorder);
        if (this.isWarhawk) {
            this.setLayout(new GridLayout(8, 2, 5, 0));
        } else {
            this.setLayout(new GridLayout(8, 2, 5, 0));
        }
        JPanel jPanel = new JPanel();
        jPanel.setBackground(MainFrame.BACKGROUND_COLOR);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        if (this.isWarhawk) {
            this.m_adapHelper.updateDashboardStatus();
            this.m_ddStatusTxt.setText(Resource.getString("PROPERTY_DD_STATUS_TEXT", "Controller Status"));
            this.m_ddStatusTxt.setHorizontalAlignment(2);
            this.add(this.m_ddStatusTxt);
            this.m_ddStatusVal.setText(this.getDDStatus());
            this.m_ddStatusVal.setHorizontalAlignment(2);
            this.m_ddStatusVal.setIcon(this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
            this.m_ddStatusVal.repaint();
            this.add(this.m_ddStatusVal);
            this.m_ssdLifeLeftTxt.setText(Resource.getString("PROPERTY_SSD_LIFE_LEFT_TEXT", "SSD Life Left"));
            this.m_ssdLifeLeftTxt.setHorizontalAlignment(2);
            this.add(this.m_ssdLifeLeftTxt);
            this.m_ssdLifeLeftVal.setText(this.adapter.getWhDDInfo().getSSDLifeLeft() + " %" + " - " + this.getSSDLifeLeftStatus());
            this.m_ssdLifeLeftVal.setHorizontalAlignment(2);
            this.add(this.m_ssdLifeLeftVal);
            this.m_lifeCurveStatusTxt.setText(Resource.getString("PROPERTY_LIFE_CURVE_STATUS_TEXT", "Life Curve Status"));
            this.m_lifeCurveStatusTxt.setHorizontalAlignment(2);
            this.add(this.m_lifeCurveStatusTxt);
            this.m_lifeCurveStatusVal.setText(this.getLifeCurveStatus());
            this.m_lifeCurveStatusVal.setHorizontalAlignment(2);
            this.add(this.m_lifeCurveStatusVal);
            this.m_totalCapacityTxt.setText(Resource.getString("TOTAL_CAPACITY_TEXT", "Total capacity"));
            this.m_totalCapacityTxt.setHorizontalAlignment(2);
            this.add(this.m_totalCapacityTxt);
            long l = this.m_adapHelper.getTotalCapacity();
            this.m_totalCapacityVal.setText(KernelConstants.getConvertedSize(l));
            this.m_totalCapacityVal.setHorizontalAlignment(2);
            this.add(this.m_totalCapacityVal);
            this.m_alarmPresentTxt.setText(Resource.getString("PROPERTY_ISALARMPRESENT_TEXT", "Alarm Present"));
            this.m_alarmPresentTxt.setHorizontalAlignment(2);
            this.add(this.m_alarmPresentTxt);
            if (this.m_adapHelper.getAdapterInfo().gethwPresent_MR_CTRL_INFO().getalarm() != 0) {
                this.m_alarmPresentVal.setText(Resource.getString("PROPERTY_YES_TEXT", "Yes"));
            } else {
                this.m_alarmPresentVal.setText(Resource.getString("PROPERTY_NO_TEXT", "No"));
            }
            this.m_alarmPresentVal.setHorizontalAlignment(2);
            this.add(this.m_alarmPresentVal);
            this.m_auxiliaryPowerTxt.setText(Resource.getString("PROPERTY_AUX_POW_TEXT", "Auxiliary Power"));
            this.m_auxiliaryPowerTxt.setHorizontalAlignment(2);
            this.add(this.m_auxiliaryPowerTxt);
            this.m_auxiliaryPowerVal.setText(this.getAuxPowPresent());
            this.m_auxiliaryPowerVal.setHorizontalAlignment(2);
            this.add(this.m_auxiliaryPowerVal);
        } else {
            this.m_statusLabeltext = new JLabel(Resource.getString("STATUS_TEXT", "Status:"), this.m_adapHelper.getIcon(), 2);
            this.add(this.m_statusLabeltext);
            this.m_adapHelper.updateDashboardStatus();
            this.m_statusLabelValue.setText(this.m_adapHelper.getDashboardStatusString());
            this.m_statusLabelValue.setHorizontalAlignment(2);
            this.m_statusLabelValue.setIcon(this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
            this.add(this.m_statusLabelValue);
            if (this.m_adapHelper.getAdapterInfo().getmaxHANodes() > 1) {
                boolean bl = this.m_adapHelper.getAdapterInfo().getcluster_MR_CTRL_INFO().getclusterActive() == 1;
                boolean bl2 = this.m_adapHelper.getAdapterInfo().getcluster_MR_CTRL_INFO().getClusterPeerMismatch() == 1;
                this.add(new JLabel(Resource.getString("HIGH_AVAILABILITY_TEXT", "High Availability Cluster:"), this.getImageIcon(Resource.getString("HIGH_AVAILABILITY_IMAGE", "HA_cluster.jpg")), 2));
                if (bl && !bl2) {
                    this.m_HAClusterValue.setText(Resource.getString("HA_ACTIVE", "Active"));
                } else if (!bl) {
                    this.m_HAClusterValue.setText(Resource.getString("HA_INACTIVE", "Inactive"));
                } else if (bl && bl2) {
                    this.m_HAClusterValue.setText(Resource.getString("HA_INCOMPATIBLE", "Incompatible"));
                }
                this.add(this.m_HAClusterValue);
            }
            this.add(new JLabel(Resource.getString("ENCLOSURES_TEXT", "Enclosures:"), this.getImageIcon(Resource.getString("ENCLOSURE_IMAGE", "enclosure.png")), 2));
            this.m_enclosuresLabelValue.setText("" + this.m_adapHelper.getEnclosureCount());
            this.add(this.m_enclosuresLabelValue);
            this.add(new JLabel(Resource.getString("BACKPLANES_TEXT", "Backplanes:"), this.getImageIcon(Resource.getString("BACKPLANE_IMAGE", "backplane.png")), 2));
            this.m_backplanesLabelValue.setText("" + this.m_adapHelper.getBackplaneCount());
            this.add(this.m_backplanesLabelValue);
            this.add(new JLabel(Resource.getString("DRIVES_TEXT", "Drives:"), this.getImageIcon(Resource.getString("UNCONFIGURED_IMAGE", "unconfigured.png")), 2));
            this.m_drivesLabelValue.setText("" + this.m_adapHelper.getPhysicalDrives().length);
            this.add(this.m_drivesLabelValue);
            if (this.m_adapHelper.getAdapterInfo().getmaxLDs() != '\u0000') {
                this.add(new JLabel(Resource.getString("DRIVE_GROUPS_TEXT", "Drive groups:"), this.getImageIcon(Resource.getString("ARRAY_IMAGE", "array.png")), 2));
                this.m_driveGroupsLabelValue.setText("" + this.m_adapHelper.getArrays().length);
                this.add(this.m_driveGroupsLabelValue);
                this.add(new JLabel(Resource.getString("VIRTUAL_DRIVES_TEXT", "Virtual drives:"), this.getImageIcon(Resource.getString("VOLUME_IMAGE", "volume.png")), 2));
                this.m_virtualDrivesLabelValue.setText("" + this.m_adapHelper.getLogicalDrives().length);
                this.add(this.m_virtualDrivesLabelValue);
            }
        }
        String string = Resource.getString("SERVER_PROFILE_TEXT", "View server profile");
        JLabel jLabel = new JLabel("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string + "\">" + string + "</a></body></html>");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setBackground(MainFrame.BACKGROUND_COLOR);
        jPanel2.add(jLabel);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                String string = null;
                ServerProfileSummaryGenerator serverProfileSummaryGenerator = new ServerProfileSummaryGenerator(PropertiesPanel.this.m_adapHelper);
                string = serverProfileSummaryGenerator.getSummaryServerProfile();
                new ServerProfileSummaryPanel(string);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        this.add((Component)jPanel, "North");
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setControllerTabbedPane(JTabbedPane jTabbedPane, int n) {
        this.m_ctrlTabbedPane = jTabbedPane;
        this.m_index = n;
    }

    private void addObservers() {
        this.m_adapHelper.addObserver(this);
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapHelper.getPhysicalDrives();
        int n = physicalDriveHelperArray.length;
        for (int i = 0; i < n; ++i) {
            physicalDriveHelperArray[i].addObserver(this);
        }
        EnclosureHelper[] enclosureHelperArray = this.m_adapHelper.getEnclosures();
        int n2 = enclosureHelperArray.length;
        for (int i = 0; i < n2; ++i) {
            enclosureHelperArray[i].addObserver(this);
        }
        LogicalDriveHelper[] logicalDriveHelperArray = this.m_adapHelper.getLogicalDrives();
        int n3 = logicalDriveHelperArray.length;
        for (int i = 0; i < n3; ++i) {
            logicalDriveHelperArray[i].addObserver(this);
        }
        BBUHelper bBUHelper = this.m_adapHelper.getBBU();
        if (bBUHelper != null) {
            bBUHelper.addObserver(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object == null) {
            return;
        }
        NotifyObject notifyObject = (NotifyObject)object;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        GUIHelperInterface gUIHelperInterface = (GUIHelperInterface)((Object)observable);
        if (this.isWarhawk) {
            switch (mR_EVT_DETAIL.getcode()) {
                case 65534: {
                    this.adapter.getWhDDInfo().setLifeCurveStatus((short)100);
                    break;
                }
                case 65535: {
                    this.adapter.getWhDDInfo().setLifeCurveStatus((short)90);
                    break;
                }
            }
            this.updatePanel();
            this.m_ctrlTabbedPane.setIconAt(this.m_index, this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
            this.m_ctrlTabbedPane.repaint();
        } else if (gUIHelperInterface instanceof PhysicalDriveHelper) {
            int n = notifyObject.getNotifyCode() - 0x102000;
            switch (n) {
                case 91: 
                case 112: 
                case 462: 
                case 463: {
                    this.m_drivesLabelValue.setText("" + this.m_adapHelper.getPhysicalDrives().length);
                    this.m_drivesLabelValue.repaint();
                    this.m_enclosuresLabelValue.setText("" + this.m_adapHelper.getEnclosureCount());
                    this.m_enclosuresLabelValue.repaint();
                    this.m_backplanesLabelValue.setText("" + this.m_adapHelper.getBackplaneCount());
                    this.m_backplanesLabelValue.repaint();
                }
                case 114: 
                case 115: {
                    this.m_adapHelper.updateDashboardStatus();
                    this.m_statusLabelValue.setText(this.m_adapHelper.getDashboardStatusString());
                    this.m_statusLabelValue.setIcon(this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
                    this.m_statusLabelValue.repaint();
                    this.m_ctrlTabbedPane.setIconAt(this.m_index, this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
                    this.m_ctrlTabbedPane.repaint();
                }
            }
        } else if (gUIHelperInterface instanceof BBUHelper) {
            this.m_adapHelper.updateDashboardStatus();
            this.m_statusLabelValue.setText(this.m_adapHelper.getDashboardStatusString());
            this.m_statusLabelValue.setIcon(this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
            this.m_statusLabelValue.repaint();
            this.m_ctrlTabbedPane.setIconAt(this.m_index, this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
            this.m_ctrlTabbedPane.repaint();
        } else if (gUIHelperInterface instanceof EnclosureHelper) {
            this.m_adapHelper.updateDashboardStatus();
            this.m_statusLabelValue.setText(this.m_adapHelper.getDashboardStatusString());
            this.m_statusLabelValue.setIcon(this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
            this.m_statusLabelValue.repaint();
            this.m_ctrlTabbedPane.setIconAt(this.m_index, this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
            this.m_ctrlTabbedPane.repaint();
        } else if (gUIHelperInterface instanceof LogicalDriveHelper) {
            int n = notifyObject.getNotifyCode() - 0x102000;
            switch (n) {
                case 138: 
                case 139: {
                    this.m_driveGroupsLabelValue.setText("" + this.m_adapHelper.getArrays().length);
                    this.m_driveGroupsLabelValue.repaint();
                    this.m_virtualDrivesLabelValue.setText("" + this.m_adapHelper.getLogicalDrives().length);
                    this.m_virtualDrivesLabelValue.repaint();
                    break;
                }
                case 81: {
                    this.m_adapHelper.updateDashboardStatus();
                    this.m_statusLabelValue.setText(this.m_adapHelper.getDashboardStatusString());
                    this.m_statusLabelValue.setIcon(this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
                    this.m_statusLabelValue.repaint();
                    this.m_ctrlTabbedPane.setIconAt(this.m_index, this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
                    this.m_ctrlTabbedPane.repaint();
                }
            }
        } else if (gUIHelperInterface instanceof AdapterHelper) {
            if (mR_EVT_DETAIL != null && (mR_EVT_DETAIL.getcode() == 308 || mR_EVT_DETAIL.getcode() == 314)) {
                this.m_statusLabeltext.setIcon(this.m_adapHelper.getIcon());
                this.m_statusLabeltext.repaint();
            }
            if (mR_EVT_DETAIL.getcode() == 460 || mR_EVT_DETAIL.getcode() == 461) {
                boolean bl;
                boolean bl2 = this.m_adapHelper.getAdapterInfo().getcluster_MR_CTRL_INFO().getclusterActive() == 1;
                boolean bl3 = bl = this.m_adapHelper.getAdapterInfo().getcluster_MR_CTRL_INFO().getClusterPeerMismatch() == 1;
                if (bl2 && !bl) {
                    this.m_HAClusterValue.setText(Resource.getString("HA_ACTIVE", "Active"));
                } else if (!bl2) {
                    this.m_HAClusterValue.setText(Resource.getString("HA_INACTIVE", "Inactive"));
                } else if (bl2 && bl) {
                    this.m_HAClusterValue.setText(Resource.getString("HA_INCOMPATIBLE", "Incompatible"));
                }
                this.m_HAClusterValue.repaint();
            }
            if (notifyObject.getNotifyCode() == 0x102001 || notifyObject.getNotifyCode() == 1056772) {
                this.addObservers();
                this.m_driveGroupsLabelValue.setText("" + this.m_adapHelper.getArrays().length);
                this.m_driveGroupsLabelValue.repaint();
                this.m_virtualDrivesLabelValue.setText("" + this.m_adapHelper.getLogicalDrives().length);
                this.m_virtualDrivesLabelValue.repaint();
                this.m_adapHelper.updateDashboardStatus();
                this.m_statusLabelValue.setText(this.m_adapHelper.getDashboardStatusString());
                this.m_statusLabelValue.setIcon(this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
                this.m_statusLabelValue.repaint();
                this.m_ctrlTabbedPane.setIconAt(this.m_index, this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
                this.m_ctrlTabbedPane.repaint();
            } else if (notifyObject.getNotifyCode() == 0x102002) {
                this.addObservers();
                this.m_drivesLabelValue.setText("" + this.m_adapHelper.getPhysicalDrives().length);
                this.m_drivesLabelValue.repaint();
                this.m_enclosuresLabelValue.setText("" + this.m_adapHelper.getEnclosureCount());
                this.m_enclosuresLabelValue.repaint();
                this.m_backplanesLabelValue.setText("" + this.m_adapHelper.getBackplaneCount());
                this.m_backplanesLabelValue.repaint();
                this.m_adapHelper.updateDashboardStatus();
                this.m_statusLabelValue.setText(this.m_adapHelper.getDashboardStatusString());
                this.m_statusLabelValue.setIcon(this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
                this.m_statusLabelValue.repaint();
                this.m_ctrlTabbedPane.setIconAt(this.m_index, this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
                this.m_ctrlTabbedPane.repaint();
            } else if (notifyObject.getNotifyCode() == 1056771) {
                this.addObservers();
                this.m_adapHelper.updateDashboardStatus();
                this.m_statusLabelValue.setText(this.m_adapHelper.getDashboardStatusString());
                this.m_statusLabelValue.setIcon(this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
                this.m_statusLabelValue.repaint();
                this.m_ctrlTabbedPane.setIconAt(this.m_index, this.getImageIcon(this.m_adapHelper.getDashboardStatusIcon()));
                this.m_ctrlTabbedPane.repaint();
            }
        }
    }

    public String getVDWritePermission() {
        String string = null;
        if (this.isWarhawk) {
            int n = this.adapter.getWhDDInfo().getSSDLifeLeft();
            string = n > this.adapter.getWhDDInfo().getDriveLifeErrorThreshold() ? Resource.getString("PROPERTY_VD_READ_WRITE_PERMISSION_TEXT", "Read-Write") : Resource.getString("PROPERTY_VD_READ_ONLY_PERMISSION_TEXT", "Read-Only");
        }
        return string;
    }

    public String getLifeCurveStatus() {
        String string;
        block9: {
            string = null;
            ArrayList arrayList = new ArrayList();
            if (this.isWarhawk) {
                short s = this.adapter.getWhDDInfo().getLifeCurveStatus();
                if (s == 100) {
                    string = Resource.getString("PROPERTY_NO_SSD_THROTTLING_TEXT", "No SSD is being throttled");
                } else if (s == 90) {
                    int n = 0;
                    try {
                        arrayList = this.adapter.getSASObjectsArrayList((short)4096);
                        for (SASPhysicalDevice sASPhysicalDevice : arrayList) {
                            if (sASPhysicalDevice.getSSDInformation().getLifeCurveStatus() != 90) continue;
                            ++n;
                        }
                        if (n > 1) {
                            string = n + " " + Resource.getString("SSD_TEXT", "SSD") + "s " + Resource.getString("THROTTLING_TEXT", "throttling");
                            break block9;
                        }
                        string = n + " " + Resource.getString("SSD_TEXT", "SSD") + Resource.getString("THROTTLING_TEXT", "throttling");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    string = Resource.getString("PROPERTY_DD_UNKNOWN_TEXT", "Unknown");
                }
            }
        }
        return string;
    }

    public String getAuxPowPresent() {
        String string = null;
        if (this.isWarhawk) {
            short s = this.adapter.getWhDDInfo().getAuxiliaryPowerPresent();
            string = s == 0 ? Resource.getString("PROPERTY_AUX_POW_NOT_PRESENT_TEXT", "Not Present") : (s == 1 ? Resource.getString("PROPERTY_AUX_POW_PRESENT_TEXT", "Present") : (s == 255 ? Resource.getString("PROPERTY_AUX_POW_NOT_SUPPORTED_TEXT", "Not Supported") : Resource.getString("PROPERTY_DD_UNKNOWN_TEXT", "Unknown")));
        }
        return string;
    }

    public String getDDStatus() {
        String string = null;
        if (this.isWarhawk) {
            int n = this.adapter.getWhDDInfo().getDDStatus();
            if (n == 0) {
                string = Resource.getString("PROPERTY_DD_STATUS_GOOD_TEXT", "Good");
            } else if (n == 1) {
                string = Resource.getString("PROPERTY_DD_STATUS_WARNING_TEXT", "Warning");
            } else if (n == 2) {
                string = Resource.getString("PROPERTY_DD_STATUS_ERROR_TEXT", "Error");
            } else if (n == 255) {
                string = Resource.getString("PROPERTY_DD_STATUS_UNKNOWN_TEXT", "Unknown");
            }
        }
        return string;
    }

    public String getSSDLifeLeftStatus() {
        String string = null;
        if (this.isWarhawk) {
            int n = this.adapter.getWhDDInfo().getSSDLifeLeft();
            string = n > this.adapter.getWhDDInfo().getDriveLifeWarningThreshold() ? Resource.getString("PROPERTY_SSD_LIFE_LEFT_OPTIMAL_TEXT", "Optimal") : (n <= this.adapter.getWhDDInfo().getDriveLifeWarningThreshold() && n > this.adapter.getWhDDInfo().getDriveLifeErrorThreshold() ? Resource.getString("PROPERTY_SSD_LIFE_LEFT_NEEDS_ATTENTION_TEXT", "Needs Attention") : Resource.getString("STATUS_EXHAUSTED", "Exhausted"));
        }
        return string;
    }
}

