/*
 * Decompiled with CFR 0.152.
 */
package GUI.Dashboard;

import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.CDROMHelper;
import GUIHelper.EnclosureHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.TapeHelper;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_DRV_DRIVER_VERSION;
import SASKernel.LibraryAPI.StoreLib.MR_FLASH_COMP_INFO;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASCDROM;
import SASKernel.SASPhysical.SASPhysicalDrive;
import SASKernel.SASPhysical.SASTape;
import SASKernel.SASServer;
import Services.KernelConstants;
import Utils.Resource;

public class ServerProfileSummaryGenerator {
    private static final String TABS_1 = "\t";
    private static final String TABS_2 = "\t\t";
    private static final String TABS_3 = "\t\t\t";
    private static final String NEW_LINE = "\r\n";
    private static final int STR_LEN = 25;
    private AdapterHelper m_adapterHelper = null;
    private SASServer m_sasServer = null;
    private SASAdapter m_Adapter = null;
    private MR_CTRL_INFO m_adapterInfo = null;

    public ServerProfileSummaryGenerator(AdapterHelper adapterHelper) {
        this.m_adapterHelper = adapterHelper;
        this.m_Adapter = (SASAdapter)this.m_adapterHelper.getDeviceObject();
        this.m_sasServer = (SASServer)this.m_Adapter.parent();
        this.m_adapterInfo = this.m_adapterHelper.getAdapterInfo();
    }

    public String getSummaryServerProfile() {
        LogicalDriveHelper[] logicalDriveHelperArray;
        CDROMHelper[] cDROMHelperArray;
        int n = this.m_adapterHelper.getEnclosureCount() + this.m_adapterHelper.getBackplaneCount();
        if (VivaldiStartupDialog.isWindows) {
            LogicalDriveHelper[] logicalDriveHelperArray2;
            CDROMHelper[] cDROMHelperArray2;
            TapeHelper[] tapeHelperArray;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Resource.getString("SERVER_", "SERVER---"));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("SERVER_IP", "Server IP:")));
            stringBuffer.append(this.m_sasServer.getInformation().getIP());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("SERVER_NAME", "Server Name:")));
            stringBuffer.append(this.m_sasServer.getInformation().getHostName());
            stringBuffer.append(NEW_LINE);
            if (!this.m_sasServer.isCIMOMServer()) {
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("OS_NAME", "OS name:")));
                stringBuffer.append(this.m_sasServer.getInformation().OperatingSystemName());
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("OS_VERSION", "OS Version:")));
                stringBuffer.append(this.m_sasServer.getInformation().OperatingSystemVersion());
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("OS_ARCH", "OS Architechture:")));
                stringBuffer.append(this.m_sasServer.getInformation().OperatingSystemArch());
                stringBuffer.append(NEW_LINE);
            } else {
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("OS_NAME", "OS name:")));
                stringBuffer.append(this.formatString(Resource.getString("OS_NAME_VMWARE_ESXI", "VMWare ESXi")));
                stringBuffer.append(NEW_LINE);
            }
            MR_DRV_DRIVER_VERSION mR_DRV_DRIVER_VERSION = this.m_adapterHelper.getMrDrvDriverVersion();
            if (mR_DRV_DRIVER_VERSION != null) {
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("DRIVER_NAME", "Driver Name:")));
                stringBuffer.append(new String(mR_DRV_DRIVER_VERSION.getdriverName()).trim());
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("DRIVER_VERSION", "Driver Version:")));
                stringBuffer.append(new String(mR_DRV_DRIVER_VERSION.getdriverVersion()).trim());
                stringBuffer.append(NEW_LINE);
            }
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("APP_VER", "Application Version:")));
            stringBuffer.append(VivaldiStartupDialog.FRAME_TITLE);
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(this.formatString(Resource.getString("HARDWARE_TEXT", "HARDWARE---")));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("CONTROLLER_TEXT", "Controller:")));
            stringBuffer.append(this.m_adapterHelper.getDescription());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("STATUS_TEXT", "Status:")));
            stringBuffer.append(this.m_adapterHelper.getDashboardStatusString());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("FW_PACKAGE_VER", "Firmware Package Version:")));
            stringBuffer.append(Resource.zeroTrim(this.m_adapterInfo.getfwPackageVersion()));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("FW_VER", "Firmware Version:")));
            String string = null;
            MR_FLASH_COMP_INFO[] mR_FLASH_COMP_INFOArray = this.m_adapterInfo.getimageComponent_MR_CTRL_INFO();
            for (int i = 0; i < mR_FLASH_COMP_INFOArray.length; ++i) {
                if (!new String(mR_FLASH_COMP_INFOArray[i].getname()).trim().equals("APP")) continue;
                string = new String(mR_FLASH_COMP_INFOArray[i].getversion()).trim();
                break;
            }
            stringBuffer.append(string);
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("BBU_TEXT", "BBU:")));
            if (this.m_adapterInfo.gethwPresent_MR_CTRL_INFO().getbbu() == 1) {
                stringBuffer.append("YES");
            } else {
                stringBuffer.append("NO");
            }
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("ENCL_TEXT", "Enclosure(s):")));
            stringBuffer.append("" + n);
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("DRIVE_TEXT", "Drive(s):")));
            stringBuffer.append("" + this.m_adapterHelper.getPhysicalDrives().length);
            stringBuffer.append(NEW_LINE);
            if (this.m_adapterHelper.getAdapterInfo().getmaxLDs() != '\u0000') {
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("VIRTUAL_DRIVES_TEXT", "Virtual Drive(s):")));
                stringBuffer.append("" + this.m_adapterHelper.getLogicalDrives().length);
                stringBuffer.append(NEW_LINE);
            }
            if (this.m_adapterInfo.gethwPresent_MR_CTRL_INFO().getbbu() == 1) {
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(Resource.getString("BBU_HEAD", "BBU---"));
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("BBU_TYPE", "BBU Type:")));
                if (this.m_adapterHelper.getBBU() != null) {
                    stringBuffer.append(this.m_adapterHelper.getBBU().getBatteryType());
                }
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("BBU_STATUS", "BBU Status:")));
                if (this.m_adapterHelper.getBBU() != null) {
                    stringBuffer.append(this.m_adapterHelper.getBBU().getBatteryStatus());
                }
                stringBuffer.append(NEW_LINE);
            }
            EnclosureHelper[] enclosureHelperArray = this.m_adapterHelper.getEnclosures();
            if (n > 0) {
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(Resource.getString("ENCL_HEAD_TEXT", "Enclosures---"));
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("PROD_NAME", "PRODUCT NAME")));
                stringBuffer.append(this.formatString(Resource.getString("TYPE_TEXT", "TYPE")));
                stringBuffer.append(this.formatString(Resource.getString("STATUS_HEAD", "STATUS")));
                stringBuffer.append(NEW_LINE);
                for (int n2 = 0; n2 < enclosureHelperArray.length; n2 = (int)((short)(n2 + 1))) {
                    PhysicalDriveHelper[] physicalDriveHelperArray;
                    boolean bl = true;
                    if (enclosureHelperArray[n2].isBackplane() && ((physicalDriveHelperArray = enclosureHelperArray[n2].getPhysicalDrives()) == null || physicalDriveHelperArray.length == 0)) {
                        bl = false;
                    }
                    if (enclosureHelperArray[n2].getEnclosureProductName() == null || !bl) continue;
                    stringBuffer.append(TABS_1);
                    stringBuffer.append(this.formatString(enclosureHelperArray[n2].getEnclosureProductName()));
                    stringBuffer.append(this.formatString(enclosureHelperArray[n2].getEnclosureType()));
                    stringBuffer.append(this.formatString(enclosureHelperArray[n2].getEnclosureStatusFault()));
                    stringBuffer.append(NEW_LINE);
                }
            }
            PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapterHelper.getPhysicalDrives();
            SASAdapter sASAdapter = (SASAdapter)this.m_adapterHelper.getDeviceObject();
            if (physicalDriveHelperArray.length > 0) {
                int n3;
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(Resource.getString("DRIVES_HEAD", "Drives---"));
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(TABS_1);
                if (!this.m_adapterHelper.isSWRController() && sASAdapter.getAdapterType() != 2 && sASAdapter.getAdapterType() != 3 && sASAdapter.getAdapterType() != 4) {
                    stringBuffer.append(this.formatString(Resource.getString("CONNECTOR_HEAD", "CONNECTOR")));
                }
                stringBuffer.append(this.formatString(Resource.getString("PROD_HEAD", "PRODUCT ID")));
                stringBuffer.append(this.formatString(Resource.getString("VENDOR_ID_HEAD", "VENDOR ID")));
                stringBuffer.append(this.formatString(Resource.getString("STATE_HEAD", "STATE")));
                stringBuffer.append(this.formatString(Resource.getString("DISK_TYPE_HEAD", "DISK TYPE")));
                stringBuffer.append(this.formatString(Resource.getString("CAPACITY_HEAD", "CAPACITY")));
                stringBuffer.append(this.formatString(Resource.getString("POWER_STATE_HEAD", "POWER STATE")));
                for (n3 = 0; n3 < physicalDriveHelperArray.length; n3 = (int)((short)(n3 + 1))) {
                    if (((SASPhysicalDrive)physicalDriveHelperArray[n3].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getCopyBack() == 0 && ((SASPhysicalDrive)physicalDriveHelperArray[n3].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getrbld() == 0 && ((SASPhysicalDrive)physicalDriveHelperArray[n3].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() == 0) continue;
                    stringBuffer.append(this.formatString(Resource.getString("OPERATION_PROG_HEAD", "OPERATION PROGRESS")));
                    break;
                }
                stringBuffer.append(NEW_LINE);
                for (n3 = 0; n3 < physicalDriveHelperArray.length; n3 = (int)((short)(n3 + 1))) {
                    stringBuffer.append(TABS_1);
                    if (!this.m_adapterHelper.isSWRController() && sASAdapter.getAdapterType() != 2 && sASAdapter.getAdapterType() != 3 && sASAdapter.getAdapterType() != 4) {
                        stringBuffer.append(this.formatString(physicalDriveHelperArray[n3].getConnectorname()));
                    }
                    stringBuffer.append(this.formatString(physicalDriveHelperArray[n3].getProductID()));
                    stringBuffer.append(this.formatString(physicalDriveHelperArray[n3].getVendorID()));
                    stringBuffer.append(this.formatString(physicalDriveHelperArray[n3].getState()));
                    stringBuffer.append(this.formatString(physicalDriveHelperArray[n3].getPDDriveType()));
                    stringBuffer.append(this.formatString("" + KernelConstants.getConvertedSize(physicalDriveHelperArray[n3].getSize(), physicalDriveHelperArray[n3].getUserDataBlockSize())));
                    stringBuffer.append(this.formatString(physicalDriveHelperArray[n3].getPDPowerState()));
                    if (((SASPhysicalDrive)physicalDriveHelperArray[n3].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getCopyBack() != 0) {
                        stringBuffer.append(this.formatString(Resource.getString("REPLACING_PHYSICAL_DRIVE_INPROGRESS", "Replacing ")));
                    } else if (((SASPhysicalDrive)physicalDriveHelperArray[n3].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getrbld() != 0) {
                        stringBuffer.append(this.formatString(Resource.getString("REBUILD_TEXT", "Rebuild")));
                    } else if (((SASPhysicalDrive)physicalDriveHelperArray[n3].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() != 0) {
                        stringBuffer.append(this.formatString(Resource.getString("OPERATION_PATROLREAD_TEXT", "Patrol Read")));
                    } else {
                        stringBuffer.append(this.formatString(Resource.getString("", "")));
                    }
                    stringBuffer.append(NEW_LINE);
                }
            }
            if ((tapeHelperArray = this.m_adapterHelper.getTapes()).length > 0) {
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(Resource.getString("TAPE_HEAD", "Tapes---"));
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("PROD_HEAD", "PRODUCT ID")));
                stringBuffer.append(this.formatString(Resource.getString("VENDOR_ID_HEAD", "VENDOR ID")));
                stringBuffer.append(this.formatString(Resource.getString("PROP_SCSIDEVTYPE_TEXT_HEAD", "SCSI DEVICE TYPE")));
                stringBuffer.append(this.formatString(Resource.getString("PROPERTY_REVLEVEL_TEXT_HEAD", "REVISION LEVEL")));
                stringBuffer.append(NEW_LINE);
                for (int n4 = 0; n4 < tapeHelperArray.length; n4 = (int)((short)(n4 + 1))) {
                    stringBuffer.append(TABS_1);
                    SASTape sASTape = (SASTape)tapeHelperArray[n4].getDeviceObject();
                    stringBuffer.append(this.formatString(sASTape.getProductInfo()));
                    stringBuffer.append(this.formatString(sASTape.getVendorInfo()));
                    stringBuffer.append(this.formatString(tapeHelperArray[n4].getScsiDeviceType()));
                    stringBuffer.append(this.formatString(sASTape.getProductRevisionLevel()));
                }
                stringBuffer.append(NEW_LINE);
            }
            if ((cDROMHelperArray2 = this.m_adapterHelper.getCDROMs()).length > 0) {
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(Resource.getString("CDROM_HEAD", "Optical Drives---"));
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("PROD_HEAD", "PRODUCT ID")));
                stringBuffer.append(this.formatString(Resource.getString("VENDOR_ID_HEAD", "VENDOR ID")));
                stringBuffer.append(this.formatString(Resource.getString("PROP_SCSIDEVTYPE_TEXT_HEAD", "SCSI DEVICE TYPE")));
                stringBuffer.append(this.formatString(Resource.getString("PROPERTY_REVLEVEL_TEXT_HEAD", "REVISION LEVEL")));
                stringBuffer.append(NEW_LINE);
                for (int n5 = 0; n5 < cDROMHelperArray2.length; n5 = (int)((short)(n5 + 1))) {
                    stringBuffer.append(TABS_1);
                    SASCDROM sASCDROM = (SASCDROM)cDROMHelperArray2[n5].getDeviceObject();
                    stringBuffer.append(this.formatString(sASCDROM.getProductInfo()));
                    stringBuffer.append(this.formatString(sASCDROM.getVendorInfo()));
                    stringBuffer.append(this.formatString(cDROMHelperArray2[n5].getScsiDeviceType()));
                    stringBuffer.append(this.formatString(sASCDROM.getProductRevisionLevel()));
                }
                stringBuffer.append(NEW_LINE);
            }
            if (this.m_adapterHelper.getAdapterInfo().getmaxLDs() != '\u0000' && (logicalDriveHelperArray2 = this.m_adapterHelper.getLogicalDrives()).length > 0) {
                int n6;
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(Resource.getString("VIRTUAL_DRIVES_TEXT_HEAD", "Virtual Drives---"));
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(Resource.getString("TARGET_ID_HEAD", "TARGET ID")));
                stringBuffer.append(this.formatString(Resource.getString("NAME_HEAD", "NAME")));
                stringBuffer.append(this.formatString(Resource.getString("CAPACITY_HEAD", "CAPACITY")));
                stringBuffer.append(this.formatString(Resource.getString("STATE_HEAD", "STATE")));
                stringBuffer.append(this.formatString(Resource.getString("RAID_LEVEL_HEAD", "RAID LEVEL")));
                stringBuffer.append(this.formatString(Resource.getString("MEGARAID_RECOVERY_TEXT", "MegaRAID RECOVERY")));
                for (n6 = 0; n6 < logicalDriveHelperArray2.length; n6 = (int)((short)(n6 + 1))) {
                    if (!((SASLogicalDrive)logicalDriveHelperArray2[n6].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getcc() && !((SASLogicalDrive)logicalDriveHelperArray2[n6].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon() && !((SASLogicalDrive)logicalDriveHelperArray2[n6].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getbgi() && !((SASLogicalDrive)logicalDriveHelperArray2[n6].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getfgi()) continue;
                    stringBuffer.append(this.formatString(Resource.getString("OPERATION_PROG_HEAD", "OPERATION PROGRESS")));
                    break;
                }
                stringBuffer.append(NEW_LINE);
                for (n6 = 0; n6 < logicalDriveHelperArray2.length; n6 = (int)((short)(n6 + 1))) {
                    stringBuffer.append(TABS_1);
                    stringBuffer.append(this.formatString("" + logicalDriveHelperArray2[n6].getDeviceObject().getID()));
                    if (logicalDriveHelperArray2[n6].getVDname().length() == 0) {
                        stringBuffer.append(this.formatString("-"));
                    } else {
                        stringBuffer.append(this.formatString(logicalDriveHelperArray2[n6].getVDname()));
                    }
                    stringBuffer.append(this.formatString(logicalDriveHelperArray2[n6].getVDsize()));
                    stringBuffer.append(this.formatString(logicalDriveHelperArray2[n6].getState()));
                    stringBuffer.append(this.formatString(logicalDriveHelperArray2[n6].getRaidLevelString()));
                    stringBuffer.append(this.formatString(logicalDriveHelperArray2[n6].getSnapshotEnabled()));
                    if (((SASLogicalDrive)logicalDriveHelperArray2[n6].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getcc()) {
                        stringBuffer.append(this.formatString(Resource.getString("CONSISTENCY_CHECK_TEXT", "Consistency Check")));
                    } else if (((SASLogicalDrive)logicalDriveHelperArray2[n6].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon()) {
                        stringBuffer.append(this.formatString(Resource.getString("RECONSTRUCTION_TEXT", "Reconstruction")));
                    } else if (((SASLogicalDrive)logicalDriveHelperArray2[n6].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getbgi()) {
                        stringBuffer.append(this.formatString(Resource.getString("INITIALIZATION_TEXT", "Initialization")));
                    } else if (((SASLogicalDrive)logicalDriveHelperArray2[n6].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getfgi()) {
                        stringBuffer.append(this.formatString(Resource.getString("INITIALIZATION_TEXT", "Initialization")));
                    } else {
                        stringBuffer.append(this.formatString(Resource.getString("", "")));
                    }
                    stringBuffer.append(NEW_LINE);
                }
            }
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("SERVER_", "SERVER---"));
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(TABS_1);
        stringBuffer.append(Resource.getString("SERVER_IP", "Server IP:"));
        stringBuffer.append(TABS_2);
        stringBuffer.append(this.m_sasServer.getInformation().getIP());
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(TABS_1);
        stringBuffer.append(Resource.getString("SERVER_NAME", "Server Name:"));
        stringBuffer.append(TABS_2);
        stringBuffer.append(this.m_sasServer.getInformation().getHostName());
        stringBuffer.append(NEW_LINE);
        if (!this.m_sasServer.isCIMOMServer()) {
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("OS_NAME", "OS name:"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(this.m_sasServer.getInformation().OperatingSystemName());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("OS_VERSION", "OS Version:"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(this.m_sasServer.getInformation().OperatingSystemVersion());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("OS_ARCH", "OS Architechture:"));
            if (!VivaldiStartupDialog.isSolaris) {
                stringBuffer.append(TABS_1);
            } else if (this.m_adapterHelper.isSolaris11()) {
                stringBuffer.append(TABS_1);
            } else {
                stringBuffer.append(TABS_2);
            }
            stringBuffer.append(this.m_sasServer.getInformation().OperatingSystemArch());
            stringBuffer.append(NEW_LINE);
        } else {
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("OS_NAME", "OS name:")));
            stringBuffer.append(this.formatString(Resource.getString("OS_NAME_VMWARE_ESXI", "VMWare ESXi")));
            stringBuffer.append(NEW_LINE);
        }
        MR_DRV_DRIVER_VERSION mR_DRV_DRIVER_VERSION = this.m_adapterHelper.getMrDrvDriverVersion();
        if (mR_DRV_DRIVER_VERSION != null) {
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("DRIVER_NAME", "Driver Name:"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(new String(mR_DRV_DRIVER_VERSION.getdriverName()).trim());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("DRIVER_VERSION", "Driver Version:"));
            if (this.m_adapterHelper.isSolaris11()) {
                stringBuffer.append(TABS_1);
            } else {
                stringBuffer.append(TABS_2);
            }
            stringBuffer.append(new String(mR_DRV_DRIVER_VERSION.getdriverVersion()).trim());
            stringBuffer.append(NEW_LINE);
        }
        stringBuffer.append(TABS_1);
        stringBuffer.append(Resource.getString("APP_VER", "Application Version:"));
        stringBuffer.append(TABS_1);
        stringBuffer.append(VivaldiStartupDialog.FRAME_TITLE);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(this.formatString(Resource.getString("HARDWARE_TEXT", "HARDWARE---")));
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(TABS_1);
        stringBuffer.append(Resource.getString("CONTROLLER_TEXT", "Controller:"));
        stringBuffer.append(TABS_2);
        stringBuffer.append(this.m_adapterHelper.getDescription());
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(TABS_1);
        stringBuffer.append(Resource.getString("STATUS_TEXT", "Status:"));
        stringBuffer.append(TABS_2);
        stringBuffer.append(this.m_adapterHelper.getDashboardStatusString());
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(TABS_1);
        stringBuffer.append(this.formatString(Resource.getString("FW_PACKAGE_VER", "Firmware Package Version:")));
        stringBuffer.append(TABS_1);
        stringBuffer.append(Resource.zeroTrim(this.m_adapterInfo.getfwPackageVersion()));
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(TABS_1);
        stringBuffer.append(Resource.getString("FW_VER", "Firmware Version:"));
        stringBuffer.append(TABS_1);
        String string = null;
        MR_FLASH_COMP_INFO[] mR_FLASH_COMP_INFOArray = this.m_adapterInfo.getimageComponent_MR_CTRL_INFO();
        for (int i = 0; i < mR_FLASH_COMP_INFOArray.length; ++i) {
            if (!new String(mR_FLASH_COMP_INFOArray[i].getname()).trim().equals("APP")) continue;
            string = new String(mR_FLASH_COMP_INFOArray[i].getversion()).trim();
            break;
        }
        stringBuffer.append(string);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(TABS_1);
        stringBuffer.append(Resource.getString("BBU_TEXT", "BBU:"));
        stringBuffer.append(TABS_2);
        if (this.m_adapterInfo.gethwPresent_MR_CTRL_INFO().getbbu() == 1) {
            stringBuffer.append("YES");
        } else {
            stringBuffer.append("NO");
        }
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(TABS_1);
        stringBuffer.append(Resource.getString("ENCL_TEXT", "Enclosure(s):"));
        stringBuffer.append(TABS_2);
        stringBuffer.append("" + n);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(TABS_1);
        stringBuffer.append(Resource.getString("DRIVE_TEXT", "Drive(s):"));
        stringBuffer.append(TABS_2);
        stringBuffer.append("" + this.m_adapterHelper.getPhysicalDrives().length);
        stringBuffer.append(NEW_LINE);
        if (this.m_adapterHelper.getAdapterInfo().getmaxLDs() != '\u0000') {
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("VIRTUAL_DRIVES_TEXT", "Virtual Drive(s):"));
            if (!VivaldiStartupDialog.isSolaris) {
                stringBuffer.append(TABS_1);
            } else if (this.m_adapterHelper.isSolaris11()) {
                stringBuffer.append(TABS_1);
            } else {
                stringBuffer.append(TABS_2);
            }
            stringBuffer.append("" + this.m_adapterHelper.getLogicalDrives().length);
            stringBuffer.append(NEW_LINE);
        }
        if (this.m_adapterInfo.gethwPresent_MR_CTRL_INFO().getbbu() == 1) {
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(Resource.getString("BBU_HEAD", "BBU---"));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("BBU_TYPE", "BBU Type:"));
            stringBuffer.append(TABS_2);
            if (this.m_adapterHelper.getBBU() != null) {
                stringBuffer.append(this.m_adapterHelper.getBBU().getBatteryType());
            }
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("BBU_STATUS", "BBU Status:"));
            stringBuffer.append(TABS_2);
            if (this.m_adapterHelper.getBBU() != null) {
                stringBuffer.append(this.m_adapterHelper.getBBU().getBatteryStatus());
            }
            stringBuffer.append(NEW_LINE);
        }
        EnclosureHelper[] enclosureHelperArray = this.m_adapterHelper.getEnclosures();
        if (n > 0) {
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(Resource.getString("ENCL_HEAD_TEXT", "Enclosures---"));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("PROD_NAME", "PRODUCT NAME"));
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("TYPE_TEXT", "TYPE"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(Resource.getString("STATUS_HEAD", "STATUS"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(NEW_LINE);
            for (int n7 = 0; n7 < enclosureHelperArray.length; n7 = (int)((short)(n7 + 1))) {
                Object object;
                boolean bl = true;
                if (enclosureHelperArray[n7].isBackplane() && ((object = enclosureHelperArray[n7].getPhysicalDrives()) == null || ((PhysicalDriveHelper[])object).length == 0)) {
                    bl = false;
                }
                if (enclosureHelperArray[n7].getEnclosureProductName() == null || !bl) continue;
                stringBuffer.append(TABS_1);
                object = enclosureHelperArray[n7].getEnclosureProductName();
                if (object != null) {
                    if (((String)object).length() > 25) {
                        object = this.formatString((String)object);
                    }
                    stringBuffer.append((String)object);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded((String)object));
                object = enclosureHelperArray[n7].getEnclosureType();
                if (object != null) {
                    if (((String)object).length() > 25) {
                        object = this.formatString((String)object);
                    }
                    stringBuffer.append((String)object);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded((String)object));
                object = enclosureHelperArray[n7].getEnclosureStatusFault();
                if (object != null) {
                    if (((String)object).length() > 25) {
                        object = this.formatString((String)object);
                    }
                    stringBuffer.append((String)object);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded((String)object));
                stringBuffer.append(NEW_LINE);
            }
        }
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapterHelper.getPhysicalDrives();
        SASAdapter sASAdapter = (SASAdapter)this.m_adapterHelper.getDeviceObject();
        boolean bl = false;
        if (physicalDriveHelperArray.length > 0) {
            String string2;
            int n8;
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(Resource.getString("DRIVES_HEAD", "Drives---"));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            if (!this.m_adapterHelper.isSWRController() && sASAdapter.getAdapterType() != 2 && sASAdapter.getAdapterType() != 3 && sASAdapter.getAdapterType() != 4) {
                stringBuffer.append(Resource.getString("CONNECTOR_HEAD", "CONNECTOR"));
                stringBuffer.append(TABS_2);
            }
            stringBuffer.append(Resource.getString("PROD_HEAD", "PRODUCT ID"));
            stringBuffer.append(TABS_2);
            for (n8 = 0; n8 < physicalDriveHelperArray.length; n8 = (int)((short)(n8 + 1))) {
                string2 = physicalDriveHelperArray[n8].getProductID();
                if (string2.length() <= 20) continue;
                stringBuffer.append(TABS_1);
                bl = true;
                break;
            }
            stringBuffer.append(Resource.getString("VENDOR_ID_HEAD", "VENDOR ID"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(Resource.getString("STATE_HEAD", "STATE"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(Resource.getString("DISK_TYPE_HEAD", "DISK TYPE"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(Resource.getString("CAPACITY_HEAD", "CAPACITY"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(Resource.getString("POWER_STATE_HEAD", "POWER STATE"));
            stringBuffer.append(TABS_2);
            for (n8 = 0; n8 < physicalDriveHelperArray.length; n8 = (int)((short)(n8 + 1))) {
                if (((SASPhysicalDrive)physicalDriveHelperArray[n8].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getCopyBack() == 0 && ((SASPhysicalDrive)physicalDriveHelperArray[n8].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getrbld() == 0 && ((SASPhysicalDrive)physicalDriveHelperArray[n8].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() == 0) continue;
                stringBuffer.append(Resource.getString("OPERATION_PROG_HEAD", "OPERATION PROGRESS"));
                stringBuffer.append(TABS_1);
                break;
            }
            stringBuffer.append(NEW_LINE);
            for (n8 = 0; n8 < physicalDriveHelperArray.length; n8 = (int)((short)(n8 + 1))) {
                stringBuffer.append(TABS_1);
                string2 = physicalDriveHelperArray[n8].getConnectorname();
                if (!this.m_adapterHelper.isSWRController() && sASAdapter.getAdapterType() != 2 && sASAdapter.getAdapterType() != 3 && sASAdapter.getAdapterType() != 4) {
                    if (string2 != null) {
                        if (string2.length() > 25) {
                            string2 = this.formatString(string2);
                        }
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append(this.NoOfTabsToBeAdded(string2));
                }
                if ((string2 = physicalDriveHelperArray[n8].getProductID()) != null) {
                    if (!bl) {
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append(TABS_1);
                    if (string2.length() <= 11) {
                        stringBuffer.append(TABS_1);
                    }
                }
                if (bl) {
                    stringBuffer.append(string2);
                    stringBuffer.append(TABS_3);
                }
                if ((string2 = physicalDriveHelperArray[n8].getVendorID()) != null) {
                    if (string2.length() > 25) {
                        string2 = this.formatString(string2);
                    }
                    stringBuffer.append(string2);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded(string2));
                string2 = physicalDriveHelperArray[n8].getState();
                if (string2 != null) {
                    if (string2.length() > 25) {
                        string2 = this.formatString(string2);
                    }
                    stringBuffer.append(string2);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded(string2));
                string2 = physicalDriveHelperArray[n8].getPDDriveType();
                if (string2 != null) {
                    if (string2.length() > 25) {
                        string2 = this.formatString(string2);
                    }
                    stringBuffer.append(string2);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded(string2));
                string2 = "" + KernelConstants.getConvertedSize(physicalDriveHelperArray[n8].getSize(), physicalDriveHelperArray[n8].getUserDataBlockSize());
                if (string2 != null) {
                    if (string2.length() > 25) {
                        string2 = this.formatString(string2);
                    }
                    stringBuffer.append(string2);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded(string2));
                string2 = physicalDriveHelperArray[n8].getPDPowerState();
                if (string2 != null) {
                    if (string2.length() > 25) {
                        string2 = this.formatString(string2);
                    }
                    stringBuffer.append(string2);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded(string2));
                if (((SASPhysicalDrive)physicalDriveHelperArray[n8].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getCopyBack() != 0) {
                    stringBuffer.append(this.formatString(Resource.getString("REPLACING_PHYSICAL_DRIVE_INPROGRESS", "Replacing ")));
                } else if (((SASPhysicalDrive)physicalDriveHelperArray[n8].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getrbld() != 0) {
                    stringBuffer.append(this.formatString(Resource.getString("REBUILD_TEXT", "Rebuild")));
                } else if (((SASPhysicalDrive)physicalDriveHelperArray[n8].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() != 0) {
                    stringBuffer.append(this.formatString(Resource.getString("OPERATION_PATROLREAD_TEXT", "Patrol Read")));
                } else {
                    stringBuffer.append(this.formatString(Resource.getString("", "")));
                }
                stringBuffer.append(NEW_LINE);
            }
        }
        bl = false;
        TapeHelper[] tapeHelperArray = this.m_adapterHelper.getTapes();
        if (tapeHelperArray.length > 0) {
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(Resource.getString("TAPE_HEAD", "Tapes---"));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("PROD_HEAD", "PRODUCT ID")));
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("VENDOR_ID_HEAD", "VENDOR ID")));
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("PROP_SCSIDEVTYPE_TEXT_HEAD", "SCSI DEVICE TYPE")));
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("PROPERTY_REVLEVEL_TEXT_HEAD", "REVISION LEVEL")));
            stringBuffer.append(TABS_1);
            stringBuffer.append(NEW_LINE);
            for (int n9 = 0; n9 < tapeHelperArray.length; n9 = (int)((short)(n9 + 1))) {
                SASTape sASTape = (SASTape)tapeHelperArray[n9].getDeviceObject();
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(sASTape.getProductInfo()));
                if (!VivaldiStartupDialog.isSolaris) {
                    stringBuffer.append(TABS_1);
                } else {
                    stringBuffer.append(TABS_2);
                }
                stringBuffer.append(this.formatString(sASTape.getVendorInfo()));
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(tapeHelperArray[n9].getScsiDeviceType()));
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(sASTape.getProductRevisionLevel()));
                stringBuffer.append(NEW_LINE);
            }
        }
        if ((cDROMHelperArray = this.m_adapterHelper.getCDROMs()).length > 0) {
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(Resource.getString("CDROM_HEAD", "Optical Drives---"));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("PROD_HEAD", "PRODUCT ID")));
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("VENDOR_ID_HEAD", "VENDOR ID")));
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("PROP_SCSIDEVTYPE_TEXT_HEAD", "SCSI DEVICE TYPE")));
            stringBuffer.append(TABS_1);
            stringBuffer.append(this.formatString(Resource.getString("PROPERTY_REVLEVEL_TEXT_HEAD", "REVISION LEVEL")));
            stringBuffer.append(NEW_LINE);
            for (int n10 = 0; n10 < cDROMHelperArray.length; n10 = (int)((short)(n10 + 1))) {
                SASCDROM sASCDROM = (SASCDROM)cDROMHelperArray[n10].getDeviceObject();
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(sASCDROM.getProductInfo()));
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(sASCDROM.getVendorInfo()));
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(cDROMHelperArray[n10].getScsiDeviceType()));
                stringBuffer.append(TABS_1);
                stringBuffer.append(this.formatString(sASCDROM.getProductRevisionLevel()));
            }
            stringBuffer.append(NEW_LINE);
        }
        if (this.m_adapterHelper.getAdapterInfo().getmaxLDs() != '\u0000' && (logicalDriveHelperArray = this.m_adapterHelper.getLogicalDrives()).length > 0) {
            int n11;
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(Resource.getString("VIRTUAL_DRIVES_TEXT_HEAD", "Virtual Drives---"));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("TARGET_ID_HEAD", "TARGET ID"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(Resource.getString("NAME_HEAD", "NAME"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(Resource.getString("CAPACITY_HEAD", "CAPACITY"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(Resource.getString("STATE_HEAD", "STATE"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(Resource.getString("RAID_LEVEL_HEAD", "RAID LEVEL"));
            stringBuffer.append(TABS_2);
            stringBuffer.append(Resource.getString("MEGARAID_RECOVERY_TEXT", "MegaRAID RECOVERY"));
            stringBuffer.append(TABS_1);
            for (n11 = 0; n11 < logicalDriveHelperArray.length; n11 = (int)((short)(n11 + 1))) {
                if (!((SASLogicalDrive)logicalDriveHelperArray[n11].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getcc() && !((SASLogicalDrive)logicalDriveHelperArray[n11].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon() && !((SASLogicalDrive)logicalDriveHelperArray[n11].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getbgi() && !((SASLogicalDrive)logicalDriveHelperArray[n11].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getfgi()) continue;
                stringBuffer.append(Resource.getString("OPERATION_PROG_HEAD", "OPERATION PROGRESS"));
                stringBuffer.append(TABS_1);
                break;
            }
            stringBuffer.append(NEW_LINE);
            for (n11 = 0; n11 < logicalDriveHelperArray.length; n11 = (int)((short)(n11 + 1))) {
                stringBuffer.append(TABS_1);
                String string3 = "" + logicalDriveHelperArray[n11].getDeviceObject().getID();
                if (string3 != null) {
                    if (string3.length() > 25) {
                        string3 = this.formatString(string3);
                    }
                    stringBuffer.append(string3);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded(string3));
                if (logicalDriveHelperArray[n11].getVDname().length() == 0) {
                    string3 = "-";
                    if (string3 != null) {
                        if (string3.length() > 25) {
                            string3 = this.formatString(string3);
                        }
                        stringBuffer.append(string3);
                    }
                    stringBuffer.append(this.NoOfTabsToBeAdded(string3));
                } else {
                    string3 = logicalDriveHelperArray[n11].getVDname();
                    if (string3 != null) {
                        stringBuffer.append(string3);
                        stringBuffer.append(TABS_1);
                        if (string3.length() < 11) {
                            stringBuffer.append(TABS_1);
                        }
                    }
                }
                string3 = logicalDriveHelperArray[n11].getVDsize();
                if (string3 != null) {
                    if (string3.length() > 25) {
                        string3 = this.formatString(string3);
                    }
                    stringBuffer.append(string3);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded(string3));
                string3 = logicalDriveHelperArray[n11].getState();
                if (string3 != null) {
                    if (string3.length() > 25) {
                        string3 = this.formatString(string3);
                    }
                    stringBuffer.append(string3);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded(string3));
                string3 = logicalDriveHelperArray[n11].getRaidLevelString();
                if (string3 != null) {
                    if (string3.length() > 25) {
                        string3 = this.formatString(string3);
                    }
                    stringBuffer.append(string3);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded(string3));
                string3 = logicalDriveHelperArray[n11].getSnapshotEnabled();
                if (string3 != null) {
                    if (string3.length() > 25) {
                        string3 = this.formatString(string3);
                    }
                    stringBuffer.append(string3);
                }
                stringBuffer.append(this.NoOfTabsToBeAdded(string3));
                if (((SASLogicalDrive)logicalDriveHelperArray[n11].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getcc()) {
                    stringBuffer.append(this.formatString(Resource.getString("CONSISTENCY_CHECK_TEXT", "Consistency Check")));
                } else if (((SASLogicalDrive)logicalDriveHelperArray[n11].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon()) {
                    stringBuffer.append(this.formatString(Resource.getString("RECONSTRUCTION_TEXT", "Reconstruction")));
                } else if (((SASLogicalDrive)logicalDriveHelperArray[n11].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getbgi()) {
                    stringBuffer.append(this.formatString(Resource.getString("INITIALIZATION_TEXT", "Initialization")));
                } else if (((SASLogicalDrive)logicalDriveHelperArray[n11].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getfgi()) {
                    stringBuffer.append(this.formatString(Resource.getString("INITIALIZATION_TEXT", "Initialization")));
                } else {
                    stringBuffer.append(this.formatString(Resource.getString("", "")));
                }
                stringBuffer.append(NEW_LINE);
            }
        }
        return stringBuffer.toString();
    }

    public String formatString(String string) {
        char[] cArray = new char[25];
        for (int n = 0; n < 25; n = (int)((short)(n + 1))) {
            cArray[n] = 32;
        }
        if (string != null) {
            String string2 = string;
            int n = string2.length();
            if (n > 25) {
                n = 25;
            }
            for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
                cArray[n2] = string2.charAt(n2);
            }
        }
        return new String(cArray);
    }

    public String NoOfTabsToBeAdded(String string) {
        if (string == null) {
            return TABS_3;
        }
        int n = string.length();
        if (n >= 25) {
            return "";
        }
        if (n < 16) {
            return TABS_2;
        }
        if (n >= 16 && n < 24) {
            return TABS_1;
        }
        return "";
    }
}

