/*
 * Decompiled with CFR 0.152.
 */
package GUI.Dashboard;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class ServerProfileSummaryPanel
extends VivaldiBaseDialog {
    private String m_strSummaryText = null;
    private JTextArea m_taSummary = null;
    private JTextField m_findString = null;
    private String m_strVDName = null;
    private JButton m_findButton = null;
    private JScrollPane m_summaryJSP = null;
    public JLabel m_resultsLabel = new JLabel(" ");

    public ServerProfileSummaryPanel(String string) {
        this.m_strSummaryText = string;
        this.buildPanel();
    }

    private void buildPanel() {
        String[] stringArray = null;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 15, 10, 0);
        this.m_taSummary = new JTextArea(25, 85);
        this.m_taSummary.setText(this.m_strSummaryText);
        this.m_taSummary.setEditable(false);
        stringArray = Resource.getResourceMnemonic(Resource.getString("FIND_NEXT", "Find (N)ext"));
        this.m_findButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_findButton.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("SERVER_PROFILE", "(S)erver Profile:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_summaryJSP);
        }
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.m_summaryJSP = new JScrollPane(this.m_taSummary, 20, 30);
        this.m_summaryJSP.setPreferredSize(new Dimension(600, 300));
        this.m_taSummary.setCaretPosition(0);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 15, 10, 15);
        jPanel.add((Component)this.m_summaryJSP, gridBagConstraints);
        this.m_findString = new JTextField(15);
        this.m_findString.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (ServerProfileSummaryPanel.this.m_findString.getText().length() == 0) {
                    ServerProfileSummaryPanel.this.m_findButton.setEnabled(false);
                } else {
                    ServerProfileSummaryPanel.this.m_findButton.setEnabled(true);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (ServerProfileSummaryPanel.this.m_findString.getText().length() == 0) {
                    ServerProfileSummaryPanel.this.m_findButton.setEnabled(false);
                } else {
                    ServerProfileSummaryPanel.this.m_findButton.setEnabled(true);
                }
            }
        });
        this.m_findString.setEditable(true);
        this.m_findButton.setEnabled(false);
        this.m_findButton.addActionListener(new FindAction());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 3, 10, 0));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        stringArray = Resource.getResourceMnemonic(Resource.getString("FIND_WHAT", "(F)ind What:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel2.setLabelFor(this.m_findString);
        }
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        jPanel2.add((Component)jLabel2, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        jPanel2.add((Component)this.m_findString, gridBagConstraints2);
        gridBagConstraints2.gridx = 2;
        jPanel2.add((Component)this.m_findButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        jPanel2.add((Component)new JLabel(Resource.getString("RESULTS_TEXT", "Results : ")), gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        jPanel2.add((Component)this.m_resultsLabel, gridBagConstraints2);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 10, 0));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        stringArray = Resource.getResourceMnemonic(Resource.getString("SAVE_AS_TEXT", "S(a)ve As..."));
        JButton jButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton.setMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.anchor = 14;
        jPanel3.add((Component)jButton, gridBagConstraints3);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CLOSE_TEXT", "(C)lose"));
        JButton jButton2 = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton2.setMnemonic(stringArray[1].charAt(0));
        }
        jPanel3.add((Component)jButton2, gridBagConstraints3);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerProfileSummaryPanel.this.saveSummaryInTextFile();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerProfileSummaryPanel.this.dispose();
            }
        });
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 400, 20, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.add(jPanel);
        this.setTitle(Resource.getString("SER_PRO", "Server Profile"));
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    public void saveSummaryInTextFile() {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            String string = new String(Resource.getString("PROFILE_SUMMARY", "Profile_Summary_") + (gregorianCalendar.get(2) + 1) + "_" + gregorianCalendar.get(5) + "_" + gregorianCalendar.get(1) + ".txt");
            jFileChooser.setSelectedFile(new File(string));
            if (jFileChooser.showSaveDialog(this.getContentPane()) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (file.exists() && !CustomMsgBox.confirm(this.getContentPane(), Resource.getString("MSG_CONFIRM_LOGOVERWRITE", "File already exists. Do you want to overwrite ?"))) {
                    return;
                }
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                printWriter.println(VivaldiStartupDialog.PRODUCT_INFO + " " + VivaldiStartupDialog.INSTALLER_VERSION + Resource.getString("PROFIEL_SUMM_GENERATED", " Profile Summary - Generated on ") + new Date());
                int n = VivaldiStartupDialog.PRODUCT_INFO.length() + 1 + VivaldiStartupDialog.INSTALLER_VERSION.length() + Resource.getString("PROFIEL_SUMM_GENERATED", " Profile Summary - Generated on ").length() + new Date().toString().length();
                StringBuffer stringBuffer = new StringBuffer("-");
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("-");
                }
                printWriter.println(stringBuffer);
                printWriter.write(this.m_strSummaryText);
                printWriter.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new CustomMsgBox(Resource.getString("MSG_SAVELOG_INVALIDFILE", "Can not save to the file specified ! Device not ready !"));
            return;
        }
    }

    public void setSummaryText(String string) {
        this.m_taSummary.setText(string);
    }

    public class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        private String m_pattern;
        private int m_pos;
        public int m_results;
        public int m_instance;

        public MyHighlightPainter(Color color) {
            super(color);
            this.m_pattern = null;
        }

        public void highlight(JTextComponent jTextComponent, String string) {
            this.removeHighlights(jTextComponent);
            try {
                Highlighter highlighter = jTextComponent.getHighlighter();
                Document document = jTextComponent.getDocument();
                String string2 = document.getText(0, document.getLength());
                if (this.m_pattern == null || !this.m_pattern.equals(string.toLowerCase())) {
                    this.m_pattern = string.toLowerCase();
                    this.m_pos = 0;
                    int n = 0;
                    this.m_results = 0;
                    this.m_instance = 0;
                    while ((n = string2.toLowerCase().indexOf(string.toLowerCase(), n)) >= 0) {
                        ++this.m_results;
                        n += string.length();
                    }
                    ServerProfileSummaryPanel.this.m_resultsLabel.setText("" + this.m_results);
                }
                if ((this.m_pos = string2.toLowerCase().indexOf(string.toLowerCase(), this.m_pos)) >= 0) {
                    highlighter.addHighlight(this.m_pos, this.m_pos + string.length(), this);
                    ++this.m_instance;
                    this.m_pos += string.length();
                    ServerProfileSummaryPanel.this.m_resultsLabel.setText("" + this.m_instance + " of " + this.m_results);
                } else {
                    this.m_instance = 0;
                    JOptionPane.showMessageDialog(VivaldiStartupDialog.mainScreen, Resource.getString("MEGARAID_MSG", "Application has finished searching the page."), Resource.getString("FIND_TITLE", "Find"), 1);
                    ServerProfileSummaryPanel.this.m_taSummary.scrollRectToVisible(ServerProfileSummaryPanel.this.m_taSummary.modelToView(0));
                    ServerProfileSummaryPanel.this.m_resultsLabel.setText("");
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void removeHighlights(JTextComponent jTextComponent) {
            Highlighter highlighter = jTextComponent.getHighlighter();
            Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
            for (int i = 0; i < highlightArray.length; ++i) {
                if (!(highlightArray[i].getPainter() instanceof MyHighlightPainter)) continue;
                highlighter.removeHighlight(highlightArray[i]);
            }
        }
    }

    class FindAction
    implements ActionListener {
        public MyHighlightPainter m_highlightPainter;

        FindAction() {
            this.m_highlightPainter = new MyHighlightPainter(Color.red);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ServerProfileSummaryPanel.this.m_strVDName = ServerProfileSummaryPanel.this.m_findString.getText();
            this.m_highlightPainter.highlight(ServerProfileSummaryPanel.this.m_taSummary, ServerProfileSummaryPanel.this.m_strVDName);
            Highlighter.Highlight[] highlightArray = ServerProfileSummaryPanel.this.m_taSummary.getHighlighter().getHighlights();
            try {
                if (highlightArray != null && highlightArray.length > 0) {
                    ServerProfileSummaryPanel.this.m_taSummary.scrollRectToVisible(ServerProfileSummaryPanel.this.m_taSummary.modelToView(highlightArray[0].getEndOffset()));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

