/*
 * Decompiled with CFR 0.152.
 */
package GUI.Dashboard;

import Utils.Resource;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class UsageCirclePanel
extends JPanel {
    public static JPanel jp1 = new JPanel(new GridLayout(1, 2));
    int m_centerX;
    int m_centerY;
    public int m_configuredcapacity;
    public int m_startAngle;
    public int m_endAngle;

    public UsageCirclePanel(int n) {
        this.m_centerX = UsageCirclePanel.jp1.getLocation().x + UsageCirclePanel.jp1.getSize().width / 2;
        this.m_centerY = UsageCirclePanel.jp1.getLocation().y + UsageCirclePanel.jp1.getSize().height / 2;
        this.m_configuredcapacity = 0;
        this.m_startAngle = 45;
        this.m_endAngle = 0;
        this.m_configuredcapacity = n;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        BufferedImage bufferedImage = this.toBufferedImage(this.getImage(Resource.getString("DARKBLUE_ICON", "darkbluepattern.png")));
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
        TexturePaint texturePaint = new TexturePaint(bufferedImage, double_);
        graphics2D.setPaint(texturePaint);
        graphics2D.fillArc(this.m_centerX, this.m_centerY, 100, 100, this.m_startAngle, this.getEndAngle());
        BufferedImage bufferedImage2 = this.toBufferedImage(this.getImage(Resource.getString("LIGHTBLUE_ICON", "lightbluepattern.png")));
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        TexturePaint texturePaint2 = new TexturePaint(bufferedImage2, double_2);
        graphics2D.setPaint(texturePaint2);
        graphics2D.fillArc(this.m_centerX, this.m_centerY, 100, 100, this.m_startAngle + this.getEndAngle(), 360 - this.getEndAngle());
    }

    public int getEndAngle() {
        this.m_endAngle = this.m_configuredcapacity * 360 / 100;
        return this.m_endAngle;
    }

    public BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = UsageCirclePanel.hasAlpha(image);
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int n = 1;
            if (bl) {
                n = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            int n = 1;
            if (bl) {
                n = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    public Image getImage(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string))).getImage();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

