/*
 * Decompiled with CFR 0.152.
 */
package GUI.Dashboard;

import GUI.Dashboard.UsageCirclePanel;
import GUI.MainFrame;
import GUIHelper.AdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.PhysicalDriveHelper;
import KernelServices.NotifyObject;
import Services.KernelConstants;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class UsagePanel
extends JPanel
implements Observer {
    private AdapterHelper m_adapHelper = null;
    JPanel m_leftPanel = new JPanel(new BorderLayout());
    private JLabel m_totalCapacityLabel = new JLabel();
    private JLabel m_ConfiguredcapacityLabel = new JLabel();
    private JLabel m_UnconfiguredcapacityLabel = new JLabel();

    public UsagePanel(AdapterHelper adapterHelper) {
        this.m_adapHelper = adapterHelper;
        this.updatePanel();
        this.addObservers();
    }

    public void updatePanel() {
        this.removeAll();
        this.setBackground(MainFrame.BACKGROUND_COLOR);
        TitledBorder titledBorder = new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), Resource.getString("USAGE_TEXT", "Usage"));
        titledBorder.setTitleColor(MainFrame.TITLE_COLOR);
        this.setBorder(titledBorder);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.m_leftPanel.setBackground(MainFrame.BACKGROUND_COLOR);
        long l = this.m_adapHelper.getTotalCapacity();
        long l2 = this.m_adapHelper.getUsedCapacity();
        int n = 0;
        if (l != 0L) {
            n = (int)(l2 * 100L / l);
        }
        if (n == 0) {
            this.m_leftPanel.add((Component)new JLabel("   ", null, 0), "First");
        } else {
            this.m_leftPanel.add((Component)new JLabel(n + "%", null, 0), "First");
        }
        this.m_leftPanel.add((Component)new UsageCirclePanel(n), "Center");
        if (n == 100) {
            this.m_leftPanel.add((Component)new JLabel("   ", null, 0), "Last");
            this.m_leftPanel.setPreferredSize(new Dimension(100, 130));
        } else if (n < 64) {
            this.m_leftPanel.add((Component)new JLabel(100 - n + "%", null, 0), "Last");
            this.m_leftPanel.setPreferredSize(new Dimension(100, 130));
        } else {
            this.m_leftPanel.add((Component)new JLabel(100 - n + "%", null, 2), "After");
            this.m_leftPanel.setPreferredSize(new Dimension(130, 130));
        }
        this.add((Component)this.m_leftPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(MainFrame.BACKGROUND_COLOR);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 10, 5, 0);
        this.m_totalCapacityLabel.setText("<html>" + Resource.getString("TOTAL_CAPACITY_TEXT", "Total capacity:") + "<br></br>" + KernelConstants.getConvertedSize(l) + "</html>");
        jPanel.add((Component)this.m_totalCapacityLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(5, 10, 5, 0);
        this.m_ConfiguredcapacityLabel.setText("<html>" + Resource.getString("CONFIGURED_CAPACITY_TEXT", "Configured Capacity:") + "<br></br>" + KernelConstants.getConvertedSize(l2) + "</html>");
        this.m_ConfiguredcapacityLabel.setHorizontalAlignment(2);
        this.m_ConfiguredcapacityLabel.setIcon(this.getImageIcon(Resource.getString("DARKBLUE_ICON", "darkbluepattern.png")));
        jPanel.add((Component)this.m_ConfiguredcapacityLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(5, 10, 10, 0);
        this.m_UnconfiguredcapacityLabel.setText("<html>" + Resource.getString("UNCONFIGURED_CAPACITY_TEXT", "Unconfigured Capacity:") + "<br></br>" + KernelConstants.getConvertedSize(l - l2) + "</html>");
        this.m_UnconfiguredcapacityLabel.setHorizontalAlignment(2);
        this.m_UnconfiguredcapacityLabel.setIcon(this.getImageIcon(Resource.getString("LIGHTBLUE_ICON", "lightbluepattern.png")));
        jPanel.add((Component)this.m_UnconfiguredcapacityLabel, gridBagConstraints2);
        this.add((Component)jPanel, gridBagConstraints);
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void addObservers() {
        this.m_adapHelper.addObserver(this);
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapHelper.getPhysicalDrives();
        int n = physicalDriveHelperArray.length;
        for (int i = 0; i < n; ++i) {
            physicalDriveHelperArray[i].addObserver(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        GUIHelperInterface gUIHelperInterface = (GUIHelperInterface)((Object)observable);
        if (gUIHelperInterface instanceof PhysicalDriveHelper) {
            switch (n) {
                case 91: 
                case 112: 
                case 114: 
                case 115: 
                case 462: 
                case 463: {
                    long l = this.m_adapHelper.getTotalCapacity();
                    long l2 = this.m_adapHelper.getUsedCapacity();
                    this.m_leftPanel.removeAll();
                    int n2 = 0;
                    if (l != 0L) {
                        n2 = (int)(l2 * 100L / l);
                    }
                    if (n2 == 0) {
                        this.m_leftPanel.add((Component)new JLabel("   ", null, 0), "First");
                    } else {
                        this.m_leftPanel.add((Component)new JLabel(n2 + "%", null, 0), "First");
                    }
                    this.m_leftPanel.add((Component)new UsageCirclePanel(n2), "Center");
                    if (n2 == 100) {
                        this.m_leftPanel.add((Component)new JLabel("   ", null, 0), "Last");
                        this.m_leftPanel.setPreferredSize(new Dimension(100, 130));
                    } else if (n2 < 64) {
                        this.m_leftPanel.add((Component)new JLabel(100 - n2 + "%", null, 0), "Last");
                        this.m_leftPanel.setPreferredSize(new Dimension(100, 130));
                    } else {
                        this.m_leftPanel.add((Component)new JLabel(100 - n2 + "%", null, 2), "After");
                        this.m_leftPanel.setPreferredSize(new Dimension(130, 130));
                    }
                    this.m_leftPanel.repaint();
                    this.m_totalCapacityLabel.setText("<html>" + Resource.getString("TOTAL_CAPACITY_TEXT", "Total capacity:") + "<br></br>" + KernelConstants.getConvertedSize(l) + "</html>");
                    this.m_totalCapacityLabel.repaint();
                    this.m_ConfiguredcapacityLabel.setText("<html>" + Resource.getString("CONFIGURED_CAPACITY_TEXT", "Configured Capacity:") + "<br></br>" + KernelConstants.getConvertedSize(l2) + "</html>");
                    this.m_ConfiguredcapacityLabel.repaint();
                    this.m_UnconfiguredcapacityLabel.setText("<html>" + Resource.getString("UNCONFIGURED_CAPACITY_TEXT", "Unconfigured Capacity:") + "<br></br>" + KernelConstants.getConvertedSize(l - l2) + "</html>");
                    this.m_UnconfiguredcapacityLabel.repaint();
                }
            }
        } else if (gUIHelperInterface instanceof AdapterHelper && (notifyObject.getNotifyCode() == 0x102001 || notifyObject.getNotifyCode() == 0x102002 || notifyObject.getNotifyCode() == 1056772)) {
            this.addObservers();
            long l = this.m_adapHelper.getTotalCapacity();
            long l3 = this.m_adapHelper.getUsedCapacity();
            this.m_leftPanel.removeAll();
            int n3 = 0;
            if (l != 0L) {
                n3 = (int)(l3 * 100L / l);
            }
            if (n3 == 0) {
                this.m_leftPanel.add((Component)new JLabel("   ", null, 0), "First");
            } else {
                this.m_leftPanel.add((Component)new JLabel(n3 + "%", null, 0), "First");
            }
            this.m_leftPanel.add((Component)new UsageCirclePanel(n3), "Center");
            if (n3 == 100) {
                this.m_leftPanel.add((Component)new JLabel("   ", null, 0), "Last");
                this.m_leftPanel.setPreferredSize(new Dimension(100, 130));
            } else if (n3 < 64) {
                this.m_leftPanel.add((Component)new JLabel(100 - n3 + "%", null, 0), "Last");
                this.m_leftPanel.setPreferredSize(new Dimension(100, 130));
            } else {
                this.m_leftPanel.add((Component)new JLabel(100 - n3 + "%", null, 2), "After");
                this.m_leftPanel.setPreferredSize(new Dimension(130, 130));
            }
            this.m_leftPanel.repaint();
            this.m_totalCapacityLabel.setText("<html>" + Resource.getString("TOTAL_CAPACITY_TEXT", "Total capacity:") + "<br></br>" + KernelConstants.getConvertedSize(l) + "</html>");
            this.m_totalCapacityLabel.repaint();
            this.m_ConfiguredcapacityLabel.setText("<html>" + Resource.getString("CONFIGURED_CAPACITY_TEXT", "Configured Capacity:") + "<br></br>" + KernelConstants.getConvertedSize(l3) + "</html>");
            this.m_ConfiguredcapacityLabel.repaint();
            this.m_UnconfiguredcapacityLabel.setText("<html>" + Resource.getString("UNCONFIGURED_CAPACITY_TEXT", "Unconfigured Capacity:") + "<br></br>" + KernelConstants.getConvertedSize(l - l3) + "</html>");
            this.m_UnconfiguredcapacityLabel.repaint();
        }
    }
}

