/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.DetailPanel;
import GUI.DeviceTree;
import GUI.DeviceTreeModel;
import GUI.DeviceTreeNode;
import GUI.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public abstract class DevicePanel
extends JPanel {
    protected DeviceTree tree;
    protected DetailPanel detail;
    protected MainFrame mainScreen;
    private JSplitPane splitPane;
    private DeviceTreeModel treeModel;
    protected DeviceTreeNode rootNode;
    private JScrollPane leftScrollPane;
    private JPanel rightPane;

    public DevicePanel(MainFrame mainFrame) {
        this.mainScreen = mainFrame;
        DeviceTreeNode deviceTreeNode = this.constructTree();
        this.treeModel = new DeviceTreeModel(deviceTreeNode);
        this.tree = new DeviceTree(this.treeModel, mainFrame);
        this.tree.addTreeSelectionListener(MainFrame.allNodeListener);
        this.tree.addMouseListener(MainFrame.allNodeListener);
        this.leftScrollPane = new JScrollPane(this.tree);
        this.rightPane = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane(1, this.leftScrollPane, this.rightPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(300);
        this.splitPane.setDividerSize(10);
        this.tree.setDividerObj(this.splitPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
    }

    public abstract DeviceTreeNode constructTree();

    public Container getRightPane() {
        return this.rightPane;
    }

    public DeviceTree getTree() {
        return this.tree;
    }
}

