/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.CCOH.CCOHCacheGroupHelper;
import GUI.CCOH.CCOHDeviceHelper;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.BBUHelper;
import GUIHelper.CDROMHelper;
import GUIHelper.ContainerNodeHelper;
import GUIHelper.EnclosureHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PeerServerLdHelper;
import GUIHelper.PeerVirtualAdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.SasClusterObjectHelper;
import GUIHelper.ServerObjectHelper;
import GUIHelper.SpannedDriveGroupHelper;
import GUIHelper.TapeHelper;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASEnclosure;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Services.NetworkToJavaConverter;
import Utils.DoubleIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;

public class DeviceTreeNode
implements Observer {
    private ArrayList m_childComponentList = new ArrayList();
    private Object m_parent;
    private String detailClassName;
    private GUIHelperInterface objectMgr;
    private boolean logicalView;
    static int supportsMultiPath;
    static boolean enclosureAdded;
    static boolean enclosureIndexEqual;
    public static int deviceId;
    private LogicalDriveHelper[] ldHelpers = new LogicalDriveHelper[0];
    private static HashMap m_ldHashmap;
    private HashMap m_arrHashmap = new HashMap();
    private static HashMap m_arraypdHashmap;
    private static HashMap m_arraydedicatedpdHashMap;
    private int spannedDrivegroupCount = 0;

    public DeviceTreeNode(GUIHelperInterface gUIHelperInterface, boolean bl) {
        this.objectMgr = gUIHelperInterface;
        this.logicalView = bl;
        if (gUIHelperInterface == null) {
            return;
        }
        switch (gUIHelperInterface.getType()) {
            case 0: {
                this.setDetailClassName("GUI.ServerDetailPanel");
                break;
            }
            case 1: {
                this.setDetailClassName("GUI.AdapterDetailPanel");
                break;
            }
            case 7: {
                this.setDetailClassName("GUI.BBUDetailPanel");
                break;
            }
            case 2: {
                this.setDetailClassName("GUI.PhysicalDriveDetailPanel");
                break;
            }
            case 3: 
            case 12: {
                this.setDetailClassName("GUI.LogicalDriveDetailPanel");
                break;
            }
            case 4: {
                this.setDetailClassName("GUI.ArrayDetailPanel");
                break;
            }
            case 13: {
                this.setDetailClassName("GUI.SpannedDriveGroupDetailPanel");
                break;
            }
            case 6: {
                this.setDetailClassName("GUI.EnclosureDetailPanel");
                break;
            }
            case 9: {
                this.setDetailClassName("GUI.CDROMDetailPanel");
                break;
            }
            case 10: {
                this.setDetailClassName("GUI.TapeDetailPanel");
                break;
            }
            case 14: {
                this.setDetailClassName("GUI.CCOH.CCOHCacheGroupDetailPanel");
                break;
            }
            case 15: {
                this.setDetailClassName("GUI.ClusterDetailPanel");
                break;
            }
        }
    }

    public String toString() {
        DeviceTreeNode deviceTreeNode;
        if (this.objectMgr.getType() == 2 && (deviceTreeNode = (DeviceTreeNode)this.m_parent) != null && deviceTreeNode.getObjectManager().getType() == 4) {
            PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)this.objectMgr;
            if (physicalDriveHelper.getDeviceObject().getState() == 2) {
                physicalDriveHelper.setArrayHelper((ArrayHelper)deviceTreeNode.getObjectManager());
            }
            return physicalDriveHelper.getText(this.logicalView);
        }
        if (this.objectMgr.getType() == 2 && this.objectMgr.getParent().getType() == 1) {
            return ((PhysicalDriveHelper)this.objectMgr).getText(this.logicalView);
        }
        return this.objectMgr.getText();
    }

    public String getToolTipText() {
        return this.objectMgr.getDescription();
    }

    public ImageIcon getIcon() {
        if (this.objectMgr.getIcon() == null) {
            return null;
        }
        return this.objectMgr.getIcon();
    }

    public ImageIcon getStatusIcon() {
        if (this.objectMgr.getStatusIcon() == null || this.objectMgr.getIcon() == null) {
            return null;
        }
        try {
            return new DoubleIcons(this.objectMgr.getIcon(), this.objectMgr.getStatusIcon(), 1);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setParentObject(Object object) {
        this.m_parent = object;
    }

    public Object getParentObject() {
        return this.m_parent;
    }

    public Object getChild(int n) {
        if (n >= 0 && n < this.m_childComponentList.size()) {
            return this.m_childComponentList.get(n);
        }
        return null;
    }

    public int getChildCount() {
        return this.m_childComponentList.size();
    }

    public int getIndexOfChild(Object object) {
        return this.m_childComponentList.indexOf(object);
    }

    public boolean isLeaf() {
        return this.m_childComponentList.size() <= 0;
    }

    public void setDetailClassName(String string) {
        this.detailClassName = string;
    }

    public String getDetailClassName() {
        return this.detailClassName;
    }

    public GUIHelperInterface getObjectManager() {
        return this.objectMgr;
    }

    public void setsupportMultiPath(int n) {
        supportsMultiPath = n;
    }

    public int getsupportMultiPath() {
        return supportsMultiPath;
    }

    public void setenclosureIndexEqual(boolean bl) {
        enclosureIndexEqual = bl;
    }

    public boolean getenclosureIndexEqual() {
        return enclosureIndexEqual;
    }

    public void initializeLogicalView(GUIHelperInterface gUIHelperInterface) {
        this.m_childComponentList.clear();
        DeviceTreeNode deviceTreeNode = null;
        if (this.objectMgr instanceof SasClusterObjectHelper) {
            ServerObjectHelper[] serverObjectHelperArray = ((SasClusterObjectHelper)this.objectMgr).getServerHelpers();
            for (int i = 0; i < serverObjectHelperArray.length; ++i) {
                PeerServerLdHelper[] peerServerLdHelperArray;
                int n;
                Object object;
                if (!serverObjectHelperArray[i].isM_isLoggedinServer()) {
                    object = serverObjectHelperArray[i].getPeerVirtualAdapterHelpers();
                    for (n = 0; n < ((Observable[])object).length; ++n) {
                        deviceTreeNode = new DeviceTreeNode((GUIHelperInterface)((Object)object[n]), true);
                        this.m_childComponentList.add(deviceTreeNode);
                        peerServerLdHelperArray = ((PeerVirtualAdapterHelper)object[n]).getPeerServerLdHelper();
                        if (peerServerLdHelperArray == null) continue;
                        for (int j = 0; j < peerServerLdHelperArray.length; ++j) {
                            deviceTreeNode.addDummyPeerLdHelper(peerServerLdHelperArray[j]);
                        }
                    }
                    continue;
                }
                if (((ServerObjectHelper)gUIHelperInterface).isCCOHinitialised() && (object = ((ServerObjectHelper)gUIHelperInterface).getCCOHVirtualAdapHelper().getCacheGroupHelper()) != null) {
                    DeviceTreeNode deviceTreeNode2 = new DeviceTreeNode((GUIHelperInterface)object, true);
                    this.m_childComponentList.add(deviceTreeNode2);
                    peerServerLdHelperArray = ((CCOHCacheGroupHelper)object).getNonOfflineCDHelperList();
                    int n2 = peerServerLdHelperArray.size();
                    for (int j = 0; j < n2; ++j) {
                        deviceTreeNode2.addCachedDeviceDummyNode((CCOHDeviceHelper)peerServerLdHelperArray.get(j));
                    }
                }
                object = ((ServerObjectHelper)gUIHelperInterface).getAdapterHelpers();
                for (n = 0; n < ((Observable[])object).length; ++n) {
                    peerServerLdHelperArray = new DeviceTreeNode((GUIHelperInterface)((Object)object[n]), this.logicalView);
                    this.m_childComponentList.add(peerServerLdHelperArray);
                    LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)object[n]).getLogicalDrives();
                    ArrayHelper[] arrayHelperArray = ((AdapterHelper)object[n]).getArrays();
                    for (int j = 0; j < arrayHelperArray.length; ++j) {
                        if (arrayHelperArray[j].getSpanDepth() > 1) {
                            if (this.callCheckSpannedArrays(arrayHelperArray[j])) continue;
                            super.addChildNodes(arrayHelperArray[j], null, 13);
                            continue;
                        }
                        super.addUnspannedArrays(arrayHelperArray[j]);
                    }
                    super.addChildNodes(object[n], null, 4);
                    super.addChildNodes(object[n], null, 6);
                }
            }
        } else {
            Object object;
            Object object2;
            if (((ServerObjectHelper)gUIHelperInterface).isCCOHinitialised() && (object2 = ((ServerObjectHelper)gUIHelperInterface).getCCOHVirtualAdapHelper().getCacheGroupHelper()) != null) {
                DeviceTreeNode deviceTreeNode3 = new DeviceTreeNode((GUIHelperInterface)object2, true);
                this.m_childComponentList.add(deviceTreeNode3);
                object = ((CCOHCacheGroupHelper)object2).getNonOfflineCDHelperList();
                int n = ((ArrayList)object).size();
                for (int i = 0; i < n; ++i) {
                    deviceTreeNode3.addCachedDeviceDummyNode((CCOHDeviceHelper)((ArrayList)object).get(i));
                }
            }
            object2 = ((ServerObjectHelper)gUIHelperInterface).getAdapterHelpers();
            for (int i = 0; i < ((AdapterHelper[])object2).length; ++i) {
                object = new DeviceTreeNode(object2[i], this.logicalView);
                this.m_childComponentList.add(object);
                LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)object2[i]).getLogicalDrives();
                ArrayHelper[] arrayHelperArray = ((AdapterHelper)object2[i]).getArrays();
                for (int j = 0; j < arrayHelperArray.length; ++j) {
                    if (arrayHelperArray[j].getSpanDepth() > 1) {
                        if (this.callCheckSpannedArrays(arrayHelperArray[j])) continue;
                        super.addChildNodes(arrayHelperArray[j], null, 13);
                        continue;
                    }
                    super.addUnspannedArrays(arrayHelperArray[j]);
                }
                super.addChildNodes(object2[i], null, 4);
                super.addChildNodes(object2[i], null, 6);
            }
        }
    }

    private boolean isFreeCapacityAvailable(GUIHelperInterface gUIHelperInterface) {
        try {
            SL_ARRAY_INFO_T sL_ARRAY_INFO_T = ((SASArray)((ArrayHelper)gUIHelperInterface).getDeviceObject()).getSLArrayInformation();
            long l = ((SASArray)((ArrayHelper)gUIHelperInterface).getDeviceObject()).getMinimumBlockSize();
            if (sL_ARRAY_INFO_T.getfreeCount() > 0) {
                return sL_ARRAY_INFO_T.gettotalBlocks() - sL_ARRAY_INFO_T.getusedBlocks() >= l;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private void addFreeCapacityNodes(GUIHelperInterface gUIHelperInterface) {
        try {
            if (gUIHelperInterface != null) {
                SL_ARRAY_INFO_T sL_ARRAY_INFO_T = ((SASArray)((ArrayHelper)gUIHelperInterface).getDeviceObject()).getSLArrayInformation();
                int n = sL_ARRAY_INFO_T.getfreeCount();
                for (int i = 0; i < n; ++i) {
                    String string = KernelConstants.getConvertedSize(((ArrayHelper)gUIHelperInterface).getRaidSpecificFreeSpaceInBlocks(i), ((ArrayHelper)gUIHelperInterface).getBlockSize());
                    DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new ContainerNodeHelper(gUIHelperInterface, string, 8, i), true);
                    this.m_childComponentList.add(deviceTreeNode);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getTotalFreeCapacity(GUIHelperInterface gUIHelperInterface) {
        try {
            if (gUIHelperInterface != null) {
                long l = 0L;
                SL_ARRAY_INFO_T sL_ARRAY_INFO_T = ((SASArray)((ArrayHelper)gUIHelperInterface).getDeviceObject()).getSLArrayInformation();
                int n = sL_ARRAY_INFO_T.getfreeCount();
                for (int i = 0; i < n; ++i) {
                    l += ((ArrayHelper)gUIHelperInterface).getRaidSpecificFreeSpaceInBlocks(i);
                }
                return KernelConstants.getConvertedSize(l, ((ArrayHelper)gUIHelperInterface).getBlockSize());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    private void addUnconfiguredPhysicalDrives(GUIHelperInterface gUIHelperInterface) {
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)gUIHelperInterface).getPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            if (sASPhysicalDrive.getState() != 0 && sASPhysicalDrive.getState() != 1) continue;
            DeviceTreeNode deviceTreeNode = new DeviceTreeNode(physicalDriveHelperArray[i], true);
            this.m_childComponentList.add(deviceTreeNode);
        }
    }

    private int getUnconfigPDcount(GUIHelperInterface gUIHelperInterface) {
        int n = 0;
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)gUIHelperInterface).getPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            if (sASPhysicalDrive.getState() != 0 && sASPhysicalDrive.getState() != 1) continue;
            ++n;
        }
        return n;
    }

    private int getSSCDcount(GUIHelperInterface gUIHelperInterface) {
        int n = 0;
        ArrayHelper[] arrayHelperArray = ((AdapterHelper)gUIHelperInterface).getArrays();
        ArrayList<LogicalDriveHelper> arrayList = new ArrayList<LogicalDriveHelper>();
        for (int i = 0; i < arrayHelperArray.length; ++i) {
            LogicalDriveHelper[] logicalDriveHelperArray = arrayHelperArray[i].getLogicalDriveHelpers();
            for (int j = 0; j < logicalDriveHelperArray.length; ++j) {
                if (!logicalDriveHelperArray[j].isSSCD()) continue;
                arrayList.add(logicalDriveHelperArray[j]);
                ++n;
            }
        }
        return n;
    }

    private void addGlobalHotSpares(GUIHelperInterface gUIHelperInterface) {
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)gUIHelperInterface).getGlobalSpares();
        if (physicalDriveHelperArray != null && physicalDriveHelperArray.length > 0) {
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode(physicalDriveHelperArray[i], true);
                this.m_childComponentList.add(deviceTreeNode);
            }
        }
    }

    private void addPhysicalDrives(PhysicalDriveHelper[] physicalDriveHelperArray) {
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            DeviceTreeNode deviceTreeNode = new DeviceTreeNode(physicalDriveHelperArray[i], true);
            this.m_childComponentList.add(deviceTreeNode);
        }
    }

    private void addDedicatedHotSpares(PhysicalDriveHelper[] physicalDriveHelperArray) {
        if (physicalDriveHelperArray != null && physicalDriveHelperArray.length > 0) {
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode(physicalDriveHelperArray[i], true);
                this.m_childComponentList.add(deviceTreeNode);
            }
        }
    }

    private void addChildNodes(Object object, PhysicalDriveHelper[] physicalDriveHelperArray, int n) {
        switch (n) {
            case 1: {
                if (object instanceof GUIHelperInterface) {
                    DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new ContainerNodeHelper((GUIHelperInterface)object, 1), true);
                    this.m_childComponentList.add(deviceTreeNode);
                    deviceTreeNode.addVirtualDrives((GUIHelperInterface)object);
                    break;
                }
                if (!(object instanceof ArrayList)) break;
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new ContainerNodeHelper(null, 1), true);
                this.m_childComponentList.add(deviceTreeNode);
                deviceTreeNode.addVirtualDrives((ArrayList)object);
                break;
            }
            case 2: {
                if (physicalDriveHelperArray != null) {
                    DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new ContainerNodeHelper((GUIHelperInterface)object, 2), true);
                    this.m_childComponentList.add(deviceTreeNode);
                    deviceTreeNode.addPhysicalDrives(physicalDriveHelperArray);
                    break;
                }
                if (object == null || !(object instanceof ArrayList)) break;
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new ContainerNodeHelper(null, 2), true);
                this.m_childComponentList.add(deviceTreeNode);
                deviceTreeNode.addArrayNodes((ArrayList)object);
                break;
            }
            case 3: {
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new ContainerNodeHelper((GUIHelperInterface)object, 3), true);
                this.m_childComponentList.add(deviceTreeNode);
                deviceTreeNode.addDedicatedHotSpares(physicalDriveHelperArray);
                break;
            }
            case 4: {
                if (((AdapterHelper)object).getGlobalSpares() == null || ((AdapterHelper)object).getGlobalSpares().length <= 0) break;
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new ContainerNodeHelper((GUIHelperInterface)object, 4), true);
                this.m_childComponentList.add(deviceTreeNode);
                deviceTreeNode.addGlobalHotSpares((GUIHelperInterface)object);
                break;
            }
            case 5: {
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new ContainerNodeHelper((GUIHelperInterface)object, this.getTotalFreeCapacity((GUIHelperInterface)object), 5, 0), true);
                this.m_childComponentList.add(deviceTreeNode);
                deviceTreeNode.addFreeCapacityNodes((GUIHelperInterface)object);
                break;
            }
            case 6: {
                if (this.getUnconfigPDcount((GUIHelperInterface)object) <= 0) break;
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new ContainerNodeHelper((GUIHelperInterface)object, 6), true);
                this.m_childComponentList.add(deviceTreeNode);
                deviceTreeNode.addUnconfiguredPhysicalDrives((GUIHelperInterface)object);
                break;
            }
            case 13: {
                ArrayHelper arrayHelper = (ArrayHelper)object;
                System.out.println("arr.getSpanDepth()/2" + arrayHelper.getSpanDepth() / 2);
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new SpannedDriveGroupHelper((GUIHelperInterface)object, this.spannedDrivegroupCount, 13), true);
                ++this.spannedDrivegroupCount;
                this.m_childComponentList.add(deviceTreeNode);
                deviceTreeNode.addSpannedArrays((GUIHelperInterface)object, this.spannedDrivegroupCount - 1);
                if (!this.isFreeCapacityAvailable((GUIHelperInterface)object)) break;
                deviceTreeNode.addChildNodes((GUIHelperInterface)object, null, 5);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                if (this.getSSCDcount((GUIHelperInterface)object) <= 0) break;
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new ContainerNodeHelper((GUIHelperInterface)object, 9), true);
                this.m_childComponentList.add(deviceTreeNode);
                deviceTreeNode.addSSCDDrives((GUIHelperInterface)object);
            }
        }
    }

    private void addCachedDeviceDummyNode(CCOHDeviceHelper cCOHDeviceHelper) {
        DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new ContainerNodeHelper(10, cCOHDeviceHelper), true);
        this.m_childComponentList.add(deviceTreeNode);
    }

    private void addDummyPeerLdHelper(PeerServerLdHelper peerServerLdHelper) {
        DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new ContainerNodeHelper(peerServerLdHelper, 16, true), true);
        this.m_childComponentList.add(deviceTreeNode);
    }

    private void addUnspannedArrays(GUIHelperInterface gUIHelperInterface) {
        if (!this.m_arrHashmap.containsKey((ArrayHelper)gUIHelperInterface)) {
            DeviceTreeNode deviceTreeNode = new DeviceTreeNode((ArrayHelper)gUIHelperInterface, true);
            this.m_childComponentList.add(deviceTreeNode);
            this.m_arrHashmap.put((ArrayHelper)gUIHelperInterface, true);
            ArrayHelper arrayHelper = (ArrayHelper)gUIHelperInterface;
            LogicalDriveHelper[] logicalDriveHelperArray = arrayHelper.getLogicalDriveHelpers();
            if (logicalDriveHelperArray != null) {
                if (logicalDriveHelperArray[0].isSSCD()) {
                    deviceTreeNode.addVirtualDrives(gUIHelperInterface);
                } else {
                    deviceTreeNode.addChildNodes((ArrayHelper)gUIHelperInterface, null, 1);
                }
            }
            PhysicalDriveHelper[] physicalDriveHelperArray = ((ArrayHelper)gUIHelperInterface).getPhysicalDrives();
            deviceTreeNode.addChildNodes(null, physicalDriveHelperArray, 2);
            PhysicalDriveHelper[] physicalDriveHelperArray2 = ((ArrayHelper)gUIHelperInterface).getDedicatedSpares();
            if (physicalDriveHelperArray2 != null && physicalDriveHelperArray2.length > 0) {
                deviceTreeNode.addChildNodes(null, physicalDriveHelperArray2, 3);
            }
            if (this.isFreeCapacityAvailable(gUIHelperInterface)) {
                deviceTreeNode.addChildNodes(gUIHelperInterface, null, 5);
            }
        }
    }

    private void addVirtualDrives(GUIHelperInterface gUIHelperInterface) {
        LogicalDriveHelper[] logicalDriveHelperArray = ((ArrayHelper)gUIHelperInterface).getLogicalDriveHelpers();
        this.sortVirtualDrives(logicalDriveHelperArray);
        for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
            if (m_ldHashmap.containsKey(logicalDriveHelperArray[i])) continue;
            m_ldHashmap.put(logicalDriveHelperArray[i], true);
            DeviceTreeNode deviceTreeNode = new DeviceTreeNode(logicalDriveHelperArray[i], true);
            this.m_childComponentList.add(deviceTreeNode);
        }
    }

    private void addSSCDDrives(GUIHelperInterface gUIHelperInterface) {
        ArrayHelper[] arrayHelperArray = ((AdapterHelper)gUIHelperInterface).getArrays();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < arrayHelperArray.length; ++i) {
            LogicalDriveHelper[] logicalDriveHelperArray = arrayHelperArray[i].getLogicalDriveHelpers();
            for (int j = 0; j < logicalDriveHelperArray.length; ++j) {
                if (!logicalDriveHelperArray[j].isSSCD()) continue;
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode(logicalDriveHelperArray[j], true);
                this.m_childComponentList.add(deviceTreeNode);
            }
        }
    }

    private void addVirtualDrives(ArrayList arrayList) {
        this.sortVirtualDrives(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            DeviceTreeNode deviceTreeNode = new DeviceTreeNode((GUIHelperInterface)arrayList.get(i), true);
            this.m_childComponentList.add(deviceTreeNode);
        }
    }

    public void sortVirtualDrives(LogicalDriveHelper[] logicalDriveHelperArray) {
        TreeMap<Short, LogicalDriveHelper> treeMap = new TreeMap<Short, LogicalDriveHelper>();
        for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
            treeMap.put(((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getID(), logicalDriveHelperArray[i]);
        }
        Iterator iterator = treeMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            logicalDriveHelperArray[n++] = (LogicalDriveHelper)treeMap.get(iterator.next());
        }
    }

    public void sortVirtualDrives(ArrayList arrayList) {
        int n;
        LogicalDriveHelper[] logicalDriveHelperArray = new LogicalDriveHelper[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            logicalDriveHelperArray[n] = (LogicalDriveHelper)arrayList.get(n);
        }
        this.sortVirtualDrives(logicalDriveHelperArray);
        arrayList.clear();
        for (n = 0; n < logicalDriveHelperArray.length; ++n) {
            arrayList.add(logicalDriveHelperArray[n]);
        }
    }

    private void addArrayNodes(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            PhysicalDriveHelper[] physicalDriveHelperArray;
            DeviceTreeNode deviceTreeNode = new DeviceTreeNode((GUIHelperInterface)arrayList.get(i), true);
            this.m_childComponentList.add(deviceTreeNode);
            ArrayHelper arrayHelper = (ArrayHelper)arrayList.get(i);
            PhysicalDriveHelper[] physicalDriveHelperArray2 = (PhysicalDriveHelper[])m_arraypdHashmap.get(arrayHelper);
            if (physicalDriveHelperArray2 != null) {
                deviceTreeNode.addPhysicalDrives(physicalDriveHelperArray2);
            }
            if ((physicalDriveHelperArray = (PhysicalDriveHelper[])m_arraydedicatedpdHashMap.get(arrayHelper)) == null || physicalDriveHelperArray.length <= 0) continue;
            deviceTreeNode.addChildNodes(null, physicalDriveHelperArray, 3);
        }
    }

    private void addSpannedArrays(GUIHelperInterface gUIHelperInterface, int n) {
        ArrayList<LogicalDriveHelper> arrayList = new ArrayList<LogicalDriveHelper>();
        ArrayList<ArrayHelper> arrayList2 = new ArrayList<ArrayHelper>();
        LogicalDriveHelper[] logicalDriveHelperArray = ((ArrayHelper)gUIHelperInterface).getLogicalDriveHelpers();
        for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
            int n2;
            if (m_ldHashmap.containsKey(logicalDriveHelperArray[i])) continue;
            arrayList.add(logicalDriveHelperArray[i]);
            m_ldHashmap.put(logicalDriveHelperArray[i], true);
            ArrayHelper[] arrayHelperArray = logicalDriveHelperArray[i].getArrays();
            int n3 = 0;
            for (n2 = 0; n2 < arrayHelperArray.length && this.m_arrHashmap.containsKey(arrayHelperArray[n2]); ++n2) {
                ++n3;
            }
            if (n3 == arrayHelperArray.length) continue;
            for (n2 = 0; n2 < arrayHelperArray.length; ++n2) {
                if (this.m_arrHashmap.containsKey(arrayHelperArray[n2])) continue;
                arrayHelperArray[n2].setParentIdForSpan(n);
                arrayList2.add(arrayHelperArray[n2]);
                this.m_arrHashmap.put(arrayHelperArray[n2], true);
                PhysicalDriveHelper[] physicalDriveHelperArray = arrayHelperArray[n2].getPhysicalDrives();
                m_arraypdHashmap.put(arrayHelperArray[n2], physicalDriveHelperArray);
                PhysicalDriveHelper[] physicalDriveHelperArray2 = arrayHelperArray[n2].getDedicatedSpares();
                if (physicalDriveHelperArray2 == null || physicalDriveHelperArray2.length <= 0) continue;
                m_arraydedicatedpdHashMap.put(arrayHelperArray[n2], physicalDriveHelperArray2);
            }
        }
        this.addChildNodes(arrayList, null, 1);
        this.addChildNodes(arrayList2, null, 2);
    }

    private boolean callCheckSpannedArrays(GUIHelperInterface gUIHelperInterface) {
        int n = 0;
        LogicalDriveHelper[] logicalDriveHelperArray = ((ArrayHelper)gUIHelperInterface).getLogicalDriveHelpers();
        for (int i = 0; i < logicalDriveHelperArray.length && m_ldHashmap.containsKey(logicalDriveHelperArray[i]); ++i) {
            ++n;
        }
        boolean bl = n == logicalDriveHelperArray.length;
        return bl;
    }

    public void init() {
        int n;
        Object[] objectArray = null;
        switch (this.objectMgr.getType()) {
            case 15: {
                if (!(this.objectMgr instanceof SasClusterObjectHelper)) break;
                objectArray = ((SasClusterObjectHelper)this.objectMgr).getServerHelpers();
                break;
            }
            case 0: {
                n = ((ServerObjectHelper)this.objectMgr).isM_isLoggedinServer();
                if (n == 0) {
                    objectArray = ((ServerObjectHelper)this.objectMgr).getPeerVirtualAdapterHelpers();
                    break;
                }
                objectArray = ((ServerObjectHelper)this.objectMgr).getAdapterHelpers();
                break;
            }
            case 17: {
                break;
            }
            case 16: {
                break;
            }
            case 1: {
                int n2;
                int n3 = ((AdapterHelper)this.objectMgr).getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getsupportMultipath();
                this.setsupportMultiPath(n3);
                BBUHelper bBUHelper = ((AdapterHelper)this.objectMgr).getBBU();
                CDROMHelper[] cDROMHelperArray = ((AdapterHelper)this.objectMgr).getGhostCDROMs();
                EnclosureHelper[] enclosureHelperArray = ((AdapterHelper)this.objectMgr).getEnclosures();
                EnclosureHelper[] enclosureHelperArray2 = this.updateEnclosureList(enclosureHelperArray);
                PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.objectMgr).getPhysicalDrives();
                CDROMHelper[] cDROMHelperArray2 = ((AdapterHelper)this.objectMgr).getCDROMs();
                TapeHelper[] tapeHelperArray = ((AdapterHelper)this.objectMgr).getTapes();
                int n4 = 0;
                int n5 = cDROMHelperArray.length;
                if (bBUHelper != null) {
                    ++n5;
                }
                if (enclosureHelperArray2 != null) {
                    n5 += enclosureHelperArray2.length;
                }
                if (physicalDriveHelperArray != null) {
                    n5 += physicalDriveHelperArray.length;
                }
                if (cDROMHelperArray2 != null) {
                    n5 += cDROMHelperArray2.length;
                }
                if (tapeHelperArray != null) {
                    n5 += tapeHelperArray.length;
                }
                objectArray = new GUIHelperInterface[n5];
                for (n2 = 0; n2 < cDROMHelperArray.length; ++n2) {
                    objectArray[n4++] = cDROMHelperArray[n2];
                }
                if (physicalDriveHelperArray != null) {
                    for (n2 = 0; n2 < physicalDriveHelperArray.length; ++n2) {
                        if (NetworkToJavaConverter.unsignedIntToLong(physicalDriveHelperArray[n2].getEnclosureID()) != 65535L) continue;
                        objectArray[n4++] = physicalDriveHelperArray[n2];
                    }
                }
                if (enclosureHelperArray2 != null) {
                    for (n2 = 0; n2 < enclosureHelperArray2.length; ++n2) {
                        objectArray[n4++] = enclosureHelperArray2[n2];
                    }
                }
                if (tapeHelperArray != null) {
                    for (n2 = 0; n2 < tapeHelperArray.length; ++n2) {
                        if (NetworkToJavaConverter.unsignedIntToLong(tapeHelperArray[n2].getEnclosureID()) != 65535L) continue;
                        objectArray[n4++] = tapeHelperArray[n2];
                    }
                }
                if (cDROMHelperArray2 != null) {
                    for (n2 = 0; n2 < cDROMHelperArray2.length; ++n2) {
                        if (NetworkToJavaConverter.unsignedIntToLong(cDROMHelperArray2[n2].getEnclosureID()) != 65535L) continue;
                        objectArray[n4++] = cDROMHelperArray2[n2];
                    }
                }
                if (bBUHelper == null) break;
                objectArray[objectArray.length - 1] = bBUHelper;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 13: {
                break;
            }
            case 6: {
                int n6;
                PhysicalDriveHelper[] physicalDriveHelperArray = ((EnclosureHelper)this.objectMgr).getPhysicalDrives();
                CDROMHelper[] cDROMHelperArray = ((EnclosureHelper)this.objectMgr).getCDROMs();
                TapeHelper[] tapeHelperArray = ((EnclosureHelper)this.objectMgr).getTapes();
                ArrayList<Observable> arrayList = new ArrayList<Observable>();
                SASEnclosure sASEnclosure = (SASEnclosure)this.objectMgr.getDeviceObject();
                if (physicalDriveHelperArray != null) {
                    for (n6 = 0; n6 < physicalDriveHelperArray.length; ++n6) {
                        if (NetworkToJavaConverter.unsignedIntToLong(physicalDriveHelperArray[n6].getEnclosureID()) != (long)sASEnclosure.getDeviceId() && physicalDriveHelperArray[n6].getEnclosureID() != sASEnclosure.getInformation().getenclPartnerDeviceId() || NetworkToJavaConverter.unsignedIntToLong(physicalDriveHelperArray[n6].getEnclosureID()) == 65535L) continue;
                        arrayList.add(physicalDriveHelperArray[n6]);
                    }
                }
                if (cDROMHelperArray != null) {
                    for (n6 = 0; n6 < cDROMHelperArray.length; ++n6) {
                        if (NetworkToJavaConverter.unsignedIntToLong(cDROMHelperArray[n6].getEnclosureID()) == 65535L) continue;
                        arrayList.add(cDROMHelperArray[n6]);
                    }
                }
                if (tapeHelperArray != null) {
                    for (n6 = 0; n6 < tapeHelperArray.length; ++n6) {
                        if (NetworkToJavaConverter.unsignedIntToLong(tapeHelperArray[n6].getEnclosureID()) == 65535L) continue;
                        arrayList.add(tapeHelperArray[n6]);
                    }
                }
                objectArray = new GUIHelperInterface[arrayList.size()];
                for (n6 = 0; n6 < arrayList.size(); ++n6) {
                    objectArray[n6] = (GUIHelperInterface)arrayList.get(n6);
                }
                break;
            }
        }
        this.m_childComponentList.clear();
        if (objectArray == null || objectArray.length <= 0) {
            return;
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] == null) continue;
            DeviceTreeNode deviceTreeNode = new DeviceTreeNode((GUIHelperInterface)((Object)objectArray[n]), this.logicalView);
            deviceTreeNode.setParentObject(this);
            this.m_childComponentList.add(deviceTreeNode);
            deviceTreeNode.init();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    public int getRowIndex() {
        if (this.getParentObject() == null) {
            return 0;
        }
        DeviceTreeNode deviceTreeNode = (DeviceTreeNode)this.getParentObject();
        return deviceTreeNode.getRowIndex() + 1 + deviceTreeNode.getIndexOfChild(this);
    }

    public void clearm_ldHashmap() {
        m_ldHashmap.clear();
    }

    private EnclosureHelper[] updateEnclosureList(EnclosureHelper[] enclosureHelperArray) {
        boolean bl = false;
        Vector<EnclosureHelper> vector = new Vector<EnclosureHelper>();
        for (int i = 0; i < enclosureHelperArray.length; ++i) {
            if (enclosureHelperArray[i].isBackplane()) {
                PhysicalDriveHelper[] physicalDriveHelperArray = enclosureHelperArray[i].getPhysicalDrives();
                if (physicalDriveHelperArray == null || physicalDriveHelperArray.length <= 0) continue;
                vector.add(enclosureHelperArray[i]);
                continue;
            }
            vector.add(enclosureHelperArray[i]);
        }
        EnclosureHelper[] enclosureHelperArray2 = new EnclosureHelper[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            if (enclosureHelperArray[i] == null) continue;
            enclosureHelperArray2[i] = (EnclosureHelper)vector.get(i);
        }
        return enclosureHelperArray2;
    }

    static {
        m_ldHashmap = new HashMap();
        m_arraypdHashmap = new HashMap();
        m_arraydedicatedpdHashMap = new HashMap();
    }
}

