/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.DeviceTreeNode;
import GUI.MainFrame;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.BBUHelper;
import GUIHelper.CDROMHelper;
import GUIHelper.EnclosureHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.ServerObjectHelper;
import GUIHelper.TapeHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DeviceTreeRenderer
extends DefaultTreeCellRenderer {
    private JSplitPane split;
    private JTree m_tree = null;
    private DeviceTreeNode m_node = null;

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.setBackgroundNonSelectionColor(jTree.getBackground());
        this.setTextNonSelectionColor(jTree.getForeground());
        DeviceTreeNode deviceTreeNode = (DeviceTreeNode)object;
        this.m_tree = jTree;
        this.m_node = deviceTreeNode;
        if (jTree.getPathForRow(n) == null) {
            return this;
        }
        if (deviceTreeNode.getStatusIcon() != null) {
            this.setIcon(deviceTreeNode.getStatusIcon());
            this.setToolTipText(deviceTreeNode.getToolTipText());
            return this;
        }
        this.setIcon(deviceTreeNode.getIcon());
        this.setToolTipText(deviceTreeNode.getToolTipText());
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 15 * MainFrame.SCREEN_SIZE.width / 1024, dimension.height);
    }

    public void setDividerObj(JSplitPane jSplitPane) {
        this.split = jSplitPane;
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x30) != 0) {
            GUIHelperInterface gUIHelperInterface = this.m_node.getObjectManager();
            AdapterHelper adapterHelper = null;
            block0 : switch (gUIHelperInterface.getType()) {
                case 0: {
                    ServerObjectHelper serverObjectHelper = (ServerObjectHelper)gUIHelperInterface;
                    AdapterHelper[] adapterHelperArray = serverObjectHelper.getAdapterHelpers();
                    int n6 = adapterHelperArray.length;
                    for (int i = 0; i < n6; ++i) {
                        if (!adapterHelperArray[i].isAnyPDtransitioning()) continue;
                        adapterHelper = adapterHelperArray[i];
                        break block0;
                    }
                    break;
                }
                case 1: {
                    adapterHelper = (AdapterHelper)gUIHelperInterface;
                    break;
                }
                case 7: {
                    adapterHelper = (AdapterHelper)((BBUHelper)gUIHelperInterface).getParent();
                    break;
                }
                case 2: {
                    adapterHelper = (AdapterHelper)((PhysicalDriveHelper)gUIHelperInterface).getParent();
                    break;
                }
                case 3: {
                    adapterHelper = (AdapterHelper)((LogicalDriveHelper)gUIHelperInterface).getParent();
                    break;
                }
                case 4: {
                    adapterHelper = (AdapterHelper)((ArrayHelper)gUIHelperInterface).getParent();
                    break;
                }
                case 6: {
                    adapterHelper = (AdapterHelper)((EnclosureHelper)gUIHelperInterface).getParent();
                    break;
                }
                case 9: {
                    adapterHelper = (AdapterHelper)((CDROMHelper)gUIHelperInterface).getParent();
                    break;
                }
                case 10: {
                    adapterHelper = (AdapterHelper)((TapeHelper)gUIHelperInterface).getParent();
                    break;
                }
            }
            if (adapterHelper != null && adapterHelper.isAnyPDtransitioning()) {
                this.m_tree.repaint();
            }
        }
        return (n & 0xA0) == 0;
    }
}

