/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.SpannedDriveGroupHelper;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASLogical.SASLogicalDrive;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class DriveGroupPowerSavingsDialog
extends VivaldiBaseDialog {
    private ArrayHelper m_arrayHelper;
    private SpannedDriveGroupHelper m_spanHelper;
    private AdapterHelper m_AdapterHelper;
    private JLabel powerSaveModeDesc = null;
    private JComboBox powerSaveModeCombo = null;
    private short mfcDisablePowerSavings = 0;

    public DriveGroupPowerSavingsDialog(ArrayHelper arrayHelper) {
        this.m_arrayHelper = arrayHelper;
        this.m_AdapterHelper = (AdapterHelper)this.m_arrayHelper.getParent();
        this.buildUI();
    }

    public DriveGroupPowerSavingsDialog(SpannedDriveGroupHelper spannedDriveGroupHelper) {
        this.m_spanHelper = spannedDriveGroupHelper;
        this.m_AdapterHelper = (AdapterHelper)this.m_spanHelper.getParent();
        this.buildUI();
    }

    private void buildUI() {
        MR_MFC_DEFAULTS mR_MFC_DEFAULTS = this.m_AdapterHelper.getMFCDefaults();
        if (mR_MFC_DEFAULTS != null) {
            this.mfcDisablePowerSavings = mR_MFC_DEFAULTS.getdisablePowerSavings();
        }
        LogicalDriveHelper logicalDriveHelper = this.m_arrayHelper.getLogicalDriveHelpers()[0];
        MR_LD_PROPERTIES mR_LD_PROPERTIES = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getInformation().getldConfig().getproperties();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension dimension = new Dimension(125, 25);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 10, 10);
        JLabel jLabel = new JLabel();
        jLabel.setText(Resource.getString("DS_DESC", "<html>Power save (Dimmer Switch\u2122) technology that conserves energy by spinning down idle drives.The controller will automatically<br>spin up those drives from power save mode whenever necessary.</html>"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("SELECT_POWER_SAVE_MODE", "(S)elect power save mode:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        arrayList.add((byte)-2);
        arrayList.add((byte)1);
        LogicalDriveHelper[] logicalDriveHelperArray = this.m_arrayHelper.getLogicalDriveHelpers();
        if (logicalDriveHelperArray[0].getpowerSavingOptions() != 0) {
            if ((this.mfcDisablePowerSavings & 0x10) != 16) {
                arrayList.add((byte)2);
            }
            if (this.m_AdapterHelper.isSupportPSMaxWithCache() && VivaldiStartupDialog.OEM_TYPE != 2561) {
                arrayList.add((byte)6);
            }
        }
        arrayList.add((byte)0);
        PowerSaveComboBoxModel powerSaveComboBoxModel = new PowerSaveComboBoxModel(arrayList);
        this.powerSaveModeCombo = new JComboBox();
        this.powerSaveModeCombo.setPreferredSize(dimension);
        this.powerSaveModeCombo.setModel(powerSaveComboBoxModel);
        this.powerSaveModeCombo.setRenderer(new PowerSaveComboBoxRenderer());
        jLabel2.setLabelFor(this.powerSaveModeCombo);
        this.powerSaveModeCombo.setSelectedItem(mR_LD_PROPERTIES.getcurrentPSPolicy());
        this.powerSaveModeDesc = new JLabel(this.getPowerSaveModeDescription(((Byte)this.powerSaveModeCombo.getSelectedItem()).byteValue()));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.powerSaveModeCombo, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 140, 0, 0);
        jPanel.add((Component)this.powerSaveModeDesc, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 10, 10));
        stringArray = Resource.getResourceMnemonic(Resource.getString("ABOUT_OKBUTTON_TEXT", "(O)K"));
        JButton jButton = new JButton(stringArray[0]);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "(C)ancel"));
        JButton jButton2 = new JButton(stringArray[0]);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(25, 0, 10, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.add(jPanel);
        this.powerSaveModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DriveGroupPowerSavingsDialog.this.powerSaveModeDesc.setText(DriveGroupPowerSavingsDialog.this.getPowerSaveModeDescription(((Byte)DriveGroupPowerSavingsDialog.this.powerSaveModeCombo.getSelectedItem()).byteValue()));
                if (DriveGroupPowerSavingsDialog.this.powerSaveModeCombo.getSelectedIndex() == -2) {
                    // empty if block
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DriveGroupPowerSavingsDialog.this.warningDialog()) {
                    DriveGroupPowerSavingsDialog.this.dispose();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DriveGroupPowerSavingsDialog.this.dispose();
                OperationDetails operationDetails = new OperationDetails(2, "", "", null);
                LogicalDriveHelper logicalDriveHelper = DriveGroupPowerSavingsDialog.this.m_arrayHelper.getLogicalDriveHelpers()[0];
                MR_LD_PROPERTIES mR_LD_PROPERTIES = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getInformation().getldConfig().getproperties();
                mR_LD_PROPERTIES.setdefaultPSPolicy((Byte)DriveGroupPowerSavingsDialog.this.powerSaveModeCombo.getSelectedItem());
                operationDetails.setParameter(mR_LD_PROPERTIES);
                logicalDriveHelper.issueOperation(operationDetails);
            }
        });
        this.setTitle(Resource.getString("DS_PS_TITLE", "Manage Power Save Settings"));
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    public String getPowerSaveModeDescription(int n) {
        switch (n) {
            case 0: {
                return Resource.getString("DS_CTRL_DEF_DESC", "<html>This option ensures that the system will inherit the controller power save <br>mode.</html>");
            }
            case -2: {
                return Resource.getString("DS_NONE_DESC", "<html>This option ensures that the system will not spin down configured <br>drives.</html>");
            }
            case 1: {
                return Resource.getString("DS_AUTO_DESC", "<html>This option ensures that the system will decide the best power saving<br>settings for the online drives.</html>");
            }
            case 2: {
                if (this.m_AdapterHelper.isSupportPSMaxWithCache()) {
                    return Resource.getString("DS_MAX_DESC", "<html>This option ensures that the system will save maximum power by caching<br>data and avoid spinning up online drives when possible.</html>");
                }
                return Resource.getString("DS_SSM_MAX_DESC", "<html>This option ensures that the system will save maximum power by <br>spinning down online drives when possible.</html>");
            }
            case 6: {
                return Resource.getString("DS_MAX_NO_CACHE_DESC", "<html>This option ensures that the system will save maximum power without<br>caching data for online drives.</html>");
            }
        }
        return "";
    }

    public class PowerSaveComboBoxModel
    extends DefaultComboBoxModel {
        public PowerSaveComboBoxModel(ArrayList<Byte> arrayList) {
            this.updateModel(arrayList);
        }

        private void updateModel(ArrayList<Byte> arrayList) {
            if (this.getSize() > 0) {
                this.removeAllElements();
            }
            for (int n = 0; n < arrayList.size(); n = (int)((short)(n + 1))) {
                this.addElement(arrayList.get(n));
            }
        }
    }

    public class PowerSaveComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                byte by = (Byte)object;
                if (by == 0) {
                    jLabel.setText(Resource.getString("DS_CTRL_DEF_TEXT", "Controller Defined"));
                } else if (by == -2) {
                    jLabel.setText(Resource.getString("DS_NONE", "None"));
                } else if (by == 1) {
                    jLabel.setText(Resource.getString("DS_AUTO", "Auto"));
                } else if (by == 2) {
                    jLabel.setText(Resource.getString("DS_MAX", "Max"));
                } else if (by == 6) {
                    jLabel.setText(Resource.getString("DS_MAX_NO_CACHE", "Max without Cache"));
                }
            }
            return jLabel;
        }
    }
}

