/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_PD_DEVICEID_LIST;
import SASKernel.LibraryAPI.StoreLib.SL_DCMD_INPUT_T;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class DrivesSpinUpProgressDialog
extends JDialog
implements PropertyChangeListener {
    private JProgressBar m_progressBar = null;
    private JLabel m_lblPercentComplete = null;
    private SpinUpDrivesTask m_spinUpTask = null;
    private int m_iNumDrives = 0;

    public DrivesSpinUpProgressDialog(SASAdapter sASAdapter, List list) {
        MR_PD_DEVICEID_LIST mR_PD_DEVICEID_LIST = new MR_PD_DEVICEID_LIST();
        int n = list.size();
        mR_PD_DEVICEID_LIST.setSize(10 + 2 * n);
        mR_PD_DEVICEID_LIST.setCount(n);
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = ((SASPhysicalDrive)list.get(i)).getDeviceId();
        }
        mR_PD_DEVICEID_LIST.setDeviceIds(sArray);
        this.m_spinUpTask = new SpinUpDrivesTask(sASAdapter, mR_PD_DEVICEID_LIST);
        this.m_spinUpTask.addPropertyChangeListener(this);
        this.buildUI();
    }

    public void buildUI() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setValue(5);
        this.m_progressBar.setIndeterminate(true);
        this.m_progressBar.setStringPainted(false);
        this.m_lblPercentComplete = new JLabel();
        this.m_lblPercentComplete.setText(Resource.getString("LABEL_SPINNING_UP_DRIVES", "Spinning up selected drives:") + " " + 0 + "%" + Resource.getString("LABEL_COMPLETE", "complete.") + " ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.m_progressBar, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.m_lblPercentComplete, gridBagConstraints);
        this.getContentPane().add(jPanel);
        this.m_spinUpTask.execute();
        this.setTitle(Resource.getString("TITLE_DRIVES_SPIN_UP_PROGRESS", "Progress"));
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setModal(true);
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        this.setIconImage(image);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("progress" == propertyChangeEvent.getPropertyName()) {
            this.m_progressBar.setIndeterminate(false);
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.m_progressBar.setValue(n);
            this.m_lblPercentComplete.setText(Resource.getString("LABEL_SPINNING_UP_DRIVES", "Spinning up selected drives:") + " " + this.m_spinUpTask.getProgress() + "%" + " " + Resource.getString("LABEL_COMPLETE", "complete."));
            if (this.m_spinUpTask.getProgress() == 100) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    class SpinUpDrivesTask
    extends SwingWorker {
        private SASAdapter m_sasAdapter = null;
        private MR_PD_DEVICEID_LIST m_mrPdDeviceIdList = null;
        private int m_progress = 0;

        public SpinUpDrivesTask(SASAdapter sASAdapter, MR_PD_DEVICEID_LIST mR_PD_DEVICEID_LIST) {
            this.m_sasAdapter = sASAdapter;
            this.m_mrPdDeviceIdList = mR_PD_DEVICEID_LIST;
        }

        protected Object doInBackground() throws Exception {
            this.setProgress(this.m_progress);
            while (this.m_progress < 100) {
                block3: {
                    Thread.sleep(2000L);
                    SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                    sL_DCMD_INPUT_T.setopCode(0x20D0200);
                    sL_DCMD_INPUT_T.setflags('\u0003');
                    int[] nArray = new int[3];
                    nArray[0] = 0;
                    sL_DCMD_INPUT_T.setmbox(nArray);
                    sL_DCMD_INPUT_T.setpData(this.m_mrPdDeviceIdList.getByteArray());
                    byte[] byArray = sL_DCMD_INPUT_T.getByteArray();
                    try {
                        this.m_sasAdapter.dcmdPassthruOperation(byArray);
                        this.m_progress = 100;
                    }
                    catch (VKOperationFailedException vKOperationFailedException) {
                        if (vKOperationFailedException.GetErrorCode() != 85) break block3;
                        MR_PD_DEVICEID_LIST mR_PD_DEVICEID_LIST = new MR_PD_DEVICEID_LIST(byArray, 32);
                        this.m_progress = this.computeProgress(mR_PD_DEVICEID_LIST);
                    }
                }
                this.setProgress(this.m_progress);
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            if (this.getProgress() == 100) {
                DrivesSpinUpProgressDialog.this.setVisible(false);
                DrivesSpinUpProgressDialog.this.dispose();
            }
        }

        private int computeProgress(MR_PD_DEVICEID_LIST mR_PD_DEVICEID_LIST) {
            int n = this.m_mrPdDeviceIdList.getCount();
            int n2 = mR_PD_DEVICEID_LIST.getCount();
            System.out.println("initialCount: " + n + ", newCount: " + n2);
            int n3 = 100 * n2 / n;
            System.out.println("progress: " + n3);
            return n3;
        }
    }
}

