/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.DetailPanel;
import GUI.EnclosureGraphicalView;
import GUI.MainFrame;
import GUI.PropertyViewPanel;
import GUIHelper.EnclosureHelper;
import Utils.CustomTabbedPane;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Observable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EnclosureDetailPanel
extends DetailPanel {
    private CustomTabbedPane tabbedPane = new CustomTabbedPane();
    private JPanel propertiesTab = new JPanel();
    private JPanel graphicalTab = new JPanel();
    private EnclosureHelper enclHelper = null;

    public EnclosureDetailPanel(EnclosureHelper enclosureHelper, MainFrame mainFrame) {
        super(enclosureHelper, mainFrame);
        this.enclHelper = enclosureHelper;
        this.tabbedPane.addTab(Resource.getString("PROPERTY_TAB_TEXT"), null, new JScrollPane(this.propertiesTab), Resource.getString("PROPERTY_TAB_TEXT"));
        if (!enclosureHelper.isVirtual()) {
            this.tabbedPane.addTab(Resource.getString("GRAPHICALVIEW_TAB_TEXT"), null, new JScrollPane(this.graphicalTab), Resource.getString("GRAPHICALVIEW_TAB_TEXT"));
        }
        this.add((Component)this.tabbedPane, "Center");
        this.init();
        enclosureHelper.addObserver(this);
    }

    @Override
    public void init() {
        this.propertiesTab.removeAll();
        this.graphicalTab.removeAll();
        this.propertiesTab.setLayout(new BorderLayout());
        PropertyViewPanel propertyViewPanel = new PropertyViewPanel(this.enclHelper.getPropertyList());
        this.propertiesTab.add((Component)propertyViewPanel, "North");
        if (!this.enclHelper.isVirtual()) {
            this.graphicalTab.setLayout(new BorderLayout());
            this.graphicalTab.add((Component)new EnclosureGraphicalView(this.enclHelper), "Before");
        }
    }

    @Override
    public boolean canClose() {
        return true;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.init();
        this.setOperationMenu();
        this.validate();
        this.repaint();
    }
}

