/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUIHelper.EnclosureHelper;
import SASKernel.LibraryAPI.StoreLib.SL_ENCL_STATUS_EX_T;
import SASKernel.LibraryAPI.StoreLib.SL_ENCL_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_FAN_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_POWER_SUPPLY_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_TEMP_SENSOR_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_VOLTAGE_SENSOR_STATUS_T;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class EnclosureGraphicalView
extends JPanel {
    private EnclosureHelper m_enclHelper = null;
    private SL_ENCL_STATUS_EX_T m_slEnclStatusEx = null;
    private SL_ENCL_STATUS_T m_slEnclStatus = null;

    public EnclosureGraphicalView(EnclosureHelper enclosureHelper) {
        this.m_enclHelper = enclosureHelper;
        this.m_slEnclStatusEx = this.m_enclHelper.getEnclosureStatusEx();
        this.m_slEnclStatus = this.m_enclHelper.getEnclosureStatus();
        this.buildUI();
    }

    private void buildUI() {
        Object object;
        Object object2;
        Object object3;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String[] stringArray = null;
        int n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 30, 10, 0);
        this.add((Component)new JLabel(Resource.getImage("LABEL_TEMPERATURE_ICON"), 2), gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        gridBagConstraints.gridx = 1;
        int n2 = this.m_slEnclStatusEx != null ? this.m_slEnclStatusEx.getTemperatureSensorCount() : this.m_slEnclStatus.gettsCount();
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_TEMPERATURE_SENSORS", "(T)emperature Sensors"));
        JLabel jLabel = new JLabel(stringArray[0] + ": " + n2);
        jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        this.add((Component)jLabel, gridBagConstraints);
        Object[] objectArray = new String[]{"<html><b>" + Resource.getString("LABEL_TEMPERATURE_SENSOR", "Temperature Sensor") + "</b></html>", "<html><b>" + Resource.getString("PROPERTY_STATUS_TEXT", "Status") + "</b></html>", "<html><b>" + Resource.getString("LABEL_TEMPERATURE_TEXT", "Temperature") + " (" + Resource.getString("PROPERTY_TEMPERATURE_UNIT", "Celcius") + ")" + "</b></html>"};
        Object[][] objectArray2 = new Object[n2][3];
        if (n2 > 0) {
            object3 = this.m_slEnclStatusEx != null ? this.m_slEnclStatusEx.getTemperatureSensorStatus() : this.m_slEnclStatus.gettsStatus();
            for (int i = 0; i < n2; ++i) {
                objectArray2[i][0] = i + 1;
                objectArray2[i][1] = this.getEnclosureElementStatus(object3[i].gettempSensorStatusVal());
                objectArray2[i][2] = objectArray2[i][1] == Resource.getString("ENCL_ELEMSTATUS_NOT_INSTALLED", "Not Installed") ? Resource.getString("TEXT_NOT_APPLICABLE ", "N/A") : Double.valueOf(((SL_TEMP_SENSOR_STATUS_T)object3[i]).getTemperatureValue() - 20.0);
            }
        }
        object3 = new JTable(objectArray2, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        gridBagConstraints.gridx = 0;
        ++n;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(0, 30, 10, 0);
        gridBagConstraints.gridwidth = 2;
        jLabel.setLabelFor((Component)object3);
        JScrollPane jScrollPane = new JScrollPane((Component)object3);
        this.add((Component)jScrollPane, gridBagConstraints);
        ((JTable)object3).setRowSelectionAllowed(false);
        ((JTable)object3).setFillsViewportHeight(true);
        ((JTable)object3).getTableHeader().setReorderingAllowed(false);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, ((JTable)object3).getRowHeight() * 5));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(10, 30, 10, 0);
        this.add((Component)new JLabel(Resource.getImage("LABEL_FAN_ICON"), 2), gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        gridBagConstraints.gridx = 1;
        int n3 = this.m_slEnclStatusEx != null ? this.m_slEnclStatusEx.getFanCount() : this.m_slEnclStatus.getfanCount();
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_FANS_TEXT", "(F)ans"));
        JLabel jLabel2 = new JLabel(stringArray[0] + ": " + n3);
        jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        Object[] objectArray3 = new String[]{"<html><b>" + Resource.getString("LABEL_FAN_TEXT", "Fan") + "</b></html>", "<html><b>" + Resource.getString("PROPERTY_STATUS_TEXT", "Status") + "</b></html>", "<html><b>" + Resource.getString("PROPERTY_FAN_SPEED_TEXT", "Status") + "(" + Resource.getString("PROPERTY_FAN_SPEED_UNIT", "RPM") + ")" + "</b></html>", "<html><b>Speed Code</b></html>"};
        Object[][] objectArray4 = new Object[n3][4];
        if (n3 > 0) {
            object2 = this.m_slEnclStatusEx != null ? this.m_slEnclStatusEx.getCoolingStatus() : this.m_slEnclStatus.getfanStatus();
            for (int i = 0; i < n3; ++i) {
                objectArray4[i][0] = i + 1;
                objectArray4[i][1] = this.getEnclosureElementStatus(((SL_FAN_STATUS_T)object2[i]).getfanStatusVal());
                objectArray4[i][2] = ((SL_FAN_STATUS_T)object2[i]).getFansSpeed();
                objectArray4[i][3] = this.getSpeedString((byte)((SL_FAN_STATUS_T)object2[i]).getSpeedCode());
            }
        }
        object2 = new JTable(objectArray4, objectArray3){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        ((JTable)object2).setRowSelectionAllowed(false);
        jLabel2.setLabelFor((Component)object2);
        ((JTable)object2).setAutoResizeMode(4);
        gridBagConstraints.gridx = 0;
        ++n;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(0, 30, 10, 0);
        JScrollPane jScrollPane2 = new JScrollPane((Component)object2);
        this.add((Component)jScrollPane2, gridBagConstraints);
        ((JTable)object2).setFillsViewportHeight(true);
        ((JTable)object2).getTableHeader().setReorderingAllowed(false);
        jScrollPane2.setPreferredSize(new Dimension(jScrollPane2.getPreferredSize().width, ((JTable)object2).getRowHeight() * 5));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(10, 30, 10, 0);
        this.add((Component)new JLabel(Resource.getImage("LABEL_POWER_ICON"), 2), gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        gridBagConstraints.gridx = 1;
        int n4 = this.m_slEnclStatusEx != null ? this.m_slEnclStatusEx.getPowerSupplyCount() : this.m_slEnclStatus.getpsCount();
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_POWERS_TEXT", "(P)ower Supplies"));
        JLabel jLabel3 = new JLabel(stringArray[0] + ": " + n4);
        jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
        this.add((Component)jLabel3, gridBagConstraints);
        Object[] objectArray5 = new String[]{"<html><b>" + Resource.getString("LABEL_POWER_TEXT", "Power Supply") + "</b></html>", "<html><b>" + Resource.getString("PROPERTY_STATUS_TEXT", "Status") + "</b></html>"};
        Object[][] objectArray6 = new Object[n4][4];
        if (n4 > 0) {
            object = this.m_slEnclStatusEx != null ? this.m_slEnclStatusEx.getPowerSupplyStatus() : this.m_slEnclStatus.getpsStatus();
            for (int i = 0; i < n4; ++i) {
                objectArray6[i][0] = i + 1;
                objectArray6[i][1] = this.getEnclosureElementStatus(((SL_POWER_SUPPLY_STATUS_T)object[i]).getpsStatusVal());
            }
        }
        object = new JTable(objectArray6, objectArray5){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jLabel3.setLabelFor((Component)object);
        ((JTable)object).setAutoResizeMode(4);
        gridBagConstraints.gridx = 0;
        ++n;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(0, 30, 10, 0);
        ((JTable)object).setRowSelectionAllowed(false);
        JScrollPane jScrollPane3 = new JScrollPane((Component)object);
        this.add((Component)jScrollPane3, gridBagConstraints);
        ((JTable)object).setFillsViewportHeight(true);
        ((JTable)object).getTableHeader().setReorderingAllowed(false);
        jScrollPane3.setPreferredSize(new Dimension(jScrollPane3.getPreferredSize().width, ((JTable)object).getRowHeight() * 5));
        if (this.m_slEnclStatusEx != null) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.insets = new Insets(10, 30, 0, 0);
            this.add((Component)new JLabel(Resource.getImage("LABEL_VOLTAGE_ICON", "voltage_sensor.png"), 2), gridBagConstraints);
            gridBagConstraints.insets = new Insets(10, 10, 10, 0);
            gridBagConstraints.gridx = 1;
            byte by = this.m_slEnclStatusEx.getVoltageSensorCount();
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_VOLTAGE_SENSORS_TEXT", "(V)oltage Sensors"));
            JLabel jLabel4 = new JLabel(stringArray[0] + ": " + by);
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
            this.add((Component)jLabel4, gridBagConstraints);
            Object[] objectArray7 = new String[]{"<html><b>" + Resource.getString("LABEL_VOLTAGE_SENSOR_TEXT", "Voltage Sensor") + "</b></html>", "<html><b>" + Resource.getString("PROPERTY_STATUS_TEXT", "Status") + "</b></html>", "<html><b>" + Resource.getString("LABEL_VOLTAGE_TEXT", "Voltage") + "(" + Resource.getString("VOLT", "V") + ")" + "</b></html>"};
            Object[][] objectArray8 = new Object[by][3];
            if (by > 0) {
                Serializable serializable;
                SL_VOLTAGE_SENSOR_STATUS_T[] sL_VOLTAGE_SENSOR_STATUS_TArray = this.m_slEnclStatusEx.getVoltageSensorStatus();
                for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                    serializable = new StringBuffer(sL_VOLTAGE_SENSOR_STATUS_TArray[by2].isVoltageIsInNegative() ? "-" : "");
                    ((StringBuffer)serializable).append(sL_VOLTAGE_SENSOR_STATUS_TArray[by2].getVoltageInVolts());
                    objectArray8[by2][0] = by2 + 1;
                    objectArray8[by2][1] = this.getEnclosureElementStatus(sL_VOLTAGE_SENSOR_STATUS_TArray[by2].getVoltageSensorStatusVal());
                    objectArray8[by2][2] = ((StringBuffer)serializable).toString();
                }
                JTable jTable = new JTable(objectArray8, objectArray7){

                    @Override
                    public boolean isCellEditable(int n, int n2) {
                        return false;
                    }
                };
                jTable.setAutoResizeMode(4);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = ++n;
                gridBagConstraints.insets = new Insets(0, 30, 10, 0);
                jTable.setRowSelectionAllowed(false);
                jTable.getTableHeader().setReorderingAllowed(false);
                serializable = new JScrollPane(jTable);
                this.add((Component)serializable, gridBagConstraints);
                jLabel4.setLabelFor(jTable);
                jTable.setFillsViewportHeight(true);
                ((JComponent)serializable).setPreferredSize(new Dimension(((JComponent)serializable).getPreferredSize().width, jTable.getRowHeight() * 5));
            }
        }
    }

    private String getEnclosureElementStatus(int n) {
        switch (n) {
            case 1: {
                return Resource.getString("ENCL_ELEMSTATUS_OK", "OK");
            }
            case 2: {
                return Resource.getString("ENCL_ELEMSTATUS_CRITICAL", "Critical");
            }
            case 3: {
                return Resource.getString("ENCL_ELEMSTATUS_NONCRITICAL", "Non Critical");
            }
            case 7: {
                return Resource.getString("ENCL_ELEMSTATUS_NOT_AVAILABLE", "Not Available");
            }
            case 5: {
                return Resource.getString("ENCL_ELEMSTATUS_NOT_INSTALLED", "Not Installed");
            }
            case 6: {
                return Resource.getString("ENCL_ELEMSTATUS_UNKNOWN", "Unknown");
            }
            case 4: {
                return Resource.getString("ENCL_ELEMSTATUS_UNRECOVERABLE", "Unrecoverable");
            }
        }
        return "";
    }

    private String getSpeedString(byte by) {
        switch (by) {
            case 1: {
                return Resource.getString("SES_SPEED_CODE_LOWEST_SPEED", "Lowest Speed");
            }
            case 2: {
                return Resource.getString("SES_SPEED_CODE_SECOND_LOWEST_SPEED", "Second Lowest Speed");
            }
            case 3: {
                return Resource.getString("SES_SPEED_CODE_THIRD_LOWEST_SPEED", "Third Lowest Speed");
            }
            case 4: {
                return Resource.getString("SES_SPEED_CODE_INTERMEDIATE_SPEED", "Intermediate Speed");
            }
            case 5: {
                return Resource.getString("SES_SPEED_CODE_THIRD_HIGHEST_SPEED", "Third Highest Speed");
            }
            case 6: {
                return Resource.getString("SES_SPEED_CODE_SECOND_HIGHEST_SPEED", "Second Highest Speed");
            }
            case 7: {
                return Resource.getString("SES_SPEED_CODE_HIGHEST_SPEED", "Highest Speed");
            }
        }
        return "";
    }
}

