/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.VivaldiLogConfiguration;
import GUI.VivaldiStartupDialog;
import Utils.Resource;
import Utils.TableSorter;
import java.awt.Color;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class EventTable
extends JTable {
    private DefaultTableModel model = (DefaultTableModel)this.getModel();
    TableSorter sorter;

    public EventTable() {
        this.setSize(VivaldiLogConfiguration.m_width, VivaldiLogConfiguration.m_height);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        if (!VivaldiStartupDialog.isWindows) {
            this.setBackground(Color.white);
        }
        String[] stringArray = new String[]{Resource.getString("LOGGERHEADER_SEQUENCENO_TEXT", "ID"), Resource.getString("LOGGERHEADER_ERRORLEVEL_TEXT", "Error Level"), Resource.getString("LOGGERHEADER_DESCRIPTION_TEXT", "Description")};
        for (int i = 0; i < stringArray.length; ++i) {
            this.model.addColumn(stringArray[i]);
        }
        this.getColumnModel().getColumn(0).setPreferredWidth(VivaldiLogConfiguration.m_width * 100 / 1024);
        this.getColumnModel().getColumn(0).setMaxWidth(VivaldiLogConfiguration.m_width * 125 / 1024);
        this.getColumnModel().getColumn(1).setPreferredWidth(VivaldiLogConfiguration.m_width * 250 / 1024);
        this.getColumnModel().getColumn(1).setMaxWidth(VivaldiLogConfiguration.m_width * 280 / 1024);
        this.getColumnModel().getColumn(2).setPreferredWidth(VivaldiLogConfiguration.m_width * 1000 / 1024);
        this.setAutoscrolls(true);
        this.setEnabled(true);
        this.setVisible(true);
    }

    public void fillTable(String[][] stringArray) {
        this.deleteAllRow();
        Object[] objectArray = new Object[3];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[0] = stringArray[i][0];
            objectArray[1] = stringArray[i][1];
            objectArray[2] = stringArray[i][2];
            this.model.addRow(objectArray);
        }
    }

    public void deleteRow(int n) {
        this.model.removeRow(n);
    }

    public void deleteAllRow() {
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
    }

    public void refresh() {
        this.model.fireTableDataChanged();
    }
}

