/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.GUIHelperInterface;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_FLASH_COMP_INFO;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import Services.NetworkToJavaConverter;
import Utils.BouncingProgressBar;
import Utils.ColorHash;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;

public class FirmwareDialog {
    public AdapterHelper m_adapHelper = null;
    public VivaldiBaseDialog jdlg = null;
    public JPanel navigationPanel = null;
    public JPanel progressBarPanel = null;
    static SwingWorker mainWorker = null;
    public JPanel firmwarePanel = null;
    public BouncingProgressBar progresbar = null;
    public JButton goButton = null;
    public JButton browse = null;
    public GridBagConstraints c;
    public static final int[] FW_HEADER_LOCATION = new int[]{0, 32, 65408, 130944};
    public static String m_newFWFileName = "";
    public static String m_newFWVersion = "";
    public static final int CHECKWORD_477 = 926364752;
    public static final int CHECKWORD_471 = 825701456;
    public static final int CHECKWORD_511 = 825308496;
    public static final int CHECKWORD_518 = 942749008;
    public static final int CHECKWORD_523 = 858928464;
    public static final int CHECKWORD_310 = 808530768;
    public static final int CHECKWORD_VRD1 = 826561110;
    public static final int CHECKWORD_VRD2 = 843338326;
    public static final int CHECKWORD_DOB1 = 826429252;
    public static final int CHECKWORD_LIN1 = 827214156;
    public static final int CHECKWORD_DRB = 1112687696;
    public static final int CHECKWORD_EVRS = 1397904965;
    public static final int CHECKWORD_SAS = 843206468;
    public static final int CHECKWORD_1078 = 943140913;
    public static final int CHECKWORD_2108 = 942682418;
    public static final int CHECKWORD_SKIN = 1313426259;
    public static final int CHECKWORD_2208 = 942682674;
    public static final int CHECKWORD_3108 = 942682419;
    public static final int EXPANDED_FLASH_CHECKWORD = 1347962182;

    public FirmwareDialog(AdapterHelper adapterHelper) {
        this.m_adapHelper = adapterHelper;
        this.updateFirmware();
    }

    public void updateFirmware() {
        this.jdlg = new VivaldiBaseDialog();
        this.navigationPanel = new JPanel(new FlowLayout(1));
        this.jdlg.setTitle(Resource.getResourceMnemonic(Resource.getString("ADAPTER_OPERATION_4", "Load Firmware"))[0]);
        final OperationDetails operationDetails = new OperationDetails(3, "Update Controller Firmware", "Updates controller firmware with a specified firmware image", true);
        final fwDetailPanel fwDetailPanel2 = new fwDetailPanel(operationDetails, this.m_adapHelper);
        this.jdlg.getContentPane().add((Component)fwDetailPanel2, "Center");
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_LABEL_OK", "OK"));
        this.goButton = new JButton(stringArray[0]);
        this.goButton.setToolTipText(Resource.getString("ABOUT_OKBUTTON_TEXT_DSC", "OK"));
        if (stringArray.length == 2) {
            this.goButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (operationDetails.getOpcode() == 0x1150000) {
                    fwDetailPanel2.isReady();
                } else if (fwDetailPanel2.isReady() && FirmwareDialog.this.m_adapHelper.isOperationAllowed(operationDetails.getOpcode())) {
                    FirmwareDialog.this.issueOperation(operationDetails);
                }
                FirmwareDialog.this.jdlg.dispose();
            }
        });
        this.navigationPanel.add(this.goButton);
        String[] stringArray2 = Resource.getResourceMnemonic(Resource.getString("BUTTON_CANCEL_TEXT", "Go"));
        JButton jButton = new JButton(stringArray2[0]);
        jButton.setToolTipText(Resource.getString("BUTTON_CANCEL_TEXT", "Go"));
        if (stringArray2.length == 2) {
            jButton.setMnemonic(stringArray[1].charAt(0));
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane jOptionPane = new JOptionPane(Resource.getString("CONFIG_CANCEL_MSG"), 3, 0);
                JDialog jDialog = jOptionPane.createDialog(FirmwareDialog.this.jdlg, FirmwareDialog.this.jdlg.getTitle());
                Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                jDialog.setIconImage(image);
                jDialog.setVisible(true);
                Object object = jOptionPane.getValue();
                if (object instanceof Integer) {
                    if ((Integer)object == 0) {
                        jDialog.dispose();
                        FirmwareDialog.this.jdlg.dispose();
                    } else {
                        jDialog.dispose();
                    }
                }
            }
        });
        this.navigationPanel.add(jButton);
        this.jdlg.getContentPane().add((Component)this.navigationPanel, "South");
        this.jdlg.setResizable(false);
        this.jdlg.setModal(true);
        this.jdlg.pack();
        GUIUtils.centerDialogOnScreen(this.jdlg);
        this.jdlg.setVisible(true);
    }

    public void issueOperation(final OperationDetails operationDetails) {
        MR_CTRL_INFO mR_CTRL_INFO = ((SASAdapter)this.m_adapHelper.getDeviceObject()).getInformation();
        this.progresbar = new BouncingProgressBar();
        this.progresbar.setProgressBarText(new JLabel("Opening the firmware image..."));
        this.progressBarPanel = this.progresbar.getProgressbar();
        if (operationDetails.getOpcode() == 3) {
            String string;
            if (((SASAdapter)this.m_adapHelper.getDeviceObject()).getAdapterType() == 1) {
                string = null;
                MR_FLASH_COMP_INFO[] mR_FLASH_COMP_INFOArray = mR_CTRL_INFO.getimageComponent_MR_CTRL_INFO();
                for (int i = 0; i < mR_FLASH_COMP_INFOArray.length; ++i) {
                    if (!new String(mR_FLASH_COMP_INFOArray[i].getname()).trim().equals("APP")) continue;
                    string = new String(mR_FLASH_COMP_INFOArray[i].getversion()).trim();
                    break;
                }
                m_newFWVersion = this.getNewFWVersion(m_newFWFileName);
                if (!CustomMsgBox.confirmWithCheck(Resource.getString("MSG_CURRENT_FW_VERSION", "Current firmware version:") + "" + string + "\n" + Resource.getString("MSG_SELECTED_FW_VERSION", "Selected firmware version:") + " " + m_newFWVersion + "\n\n" + Resource.getString("MSG_CURRENT_FW_VERSION_REPLACEWITH", "<html>The current firmware version will be replaced with the selected firmware.<br>Do you want to continue?</html>"))) {
                    return;
                }
            } else if (((SASAdapter)this.m_adapHelper.getDeviceObject()).getAdapterType() == 2 || ((SASAdapter)this.m_adapHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapHelper.getDeviceObject()).getAdapterType() == 4) {
                string = null;
                String string2 = (String)operationDetails.getParam();
                char c = string2.charAt(0);
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                MR_FLASH_COMP_INFO[] mR_FLASH_COMP_INFOArray = mR_CTRL_INFO.getimageComponent_MR_CTRL_INFO();
                for (int i = 0; i < mR_FLASH_COMP_INFOArray.length; ++i) {
                    if (new String(mR_FLASH_COMP_INFOArray[i].getname()).trim().equals("APP")) {
                        string3 = Resource.getString("CONTOLLER_FIRMWARE", "controller firmware");
                        string4 = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
                        continue;
                    }
                    if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getname()).equals("BIOS")) continue;
                    string6 = Resource.getString("BIOS_TEXT", "BIOS");
                    string5 = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
                }
                if (c == '0' ? !CustomMsgBox.confirmWithCheck(Resource.getString("WARNING_FLASH", "Warning : This will flash the ") + string3 + Resource.getString("CURRENT_VERSION", ". Current version is ") + string4 + "\n " + Resource.getString("MSG_CONFIRM", "Are you sure ?")) : (c == '1' ? !CustomMsgBox.confirmWithCheck(Resource.getString("WARNING_FLASH", "Warning : This will flash the ") + string6 + Resource.getString("CURRENT_VERSION", ". Current version is ") + string5 + "\n " + Resource.getString("MSG_CONFIRM", "Are you sure ?")) : (c == '2' ? !CustomMsgBox.confirmWithCheck(Resource.getString("WARNING_FLASH_FCODE", "Warning : This will flash the  FCODE") + "\n " + Resource.getString("MSG_CONFIRM", "Are you sure ?")) : c == '3' && !CustomMsgBox.confirmWithCheck(Resource.getString("WARNING_FLASH_EFI_BSD", "Warning : This will flash the  EFI-BSD") + "\n " + Resource.getString("MSG_CONFIRM", "Are you sure ?"))))) {
                    return;
                }
            }
        }
        VivaldiStartupDialog.mainScreen.busy();
        try {
            if (mainWorker != null) {
                boolean bl = mainWorker.cancel(true);
            }
        }
        catch (Exception exception) {
            System.out.println("got exception in start" + exception.getMessage());
        }
        mainWorker = new SwingWorker(){
            boolean flashdone = false;
            boolean isResetNotAllowed = false;
            boolean isOFUSupported = false;
            boolean isOFUTriggered = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected String doInBackground() throws InterruptedException, VKOperationFailedException {
                if (operationDetails.getOpcode() == 0x7010000) return null;
                try {
                    Object object;
                    Object object2;
                    byte[] byArray = null;
                    byte[] byArray2 = new byte[8];
                    try {
                        object2 = (String)operationDetails.getParam();
                        byArray2[0] = ((String)object2).charAt(0) == '1' ? 1 : (((String)object2).charAt(0) == '3' ? 3 : (((String)object2).charAt(0) == '2' ? 2 : 0));
                        String string = ((String)object2).substring(1, ((String)object2).length());
                        FileInputStream fileInputStream = new FileInputStream(string);
                        object = new DataInputStream(fileInputStream);
                        byArray = new byte[(int)fileInputStream.getChannel().size()];
                        ((DataInputStream)object).readFully(byArray);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new VKOperationFailedException(4096);
                    }
                    object2 = (SASAdapter)FirmwareDialog.this.m_adapHelper.getDeviceObject();
                    if (((SASAdapter)object2).getAdapterType() == 1) {
                        if (FirmwareDialog.this.progressBarPanel != null) {
                            FirmwareDialog.this.firmwarePanel.remove(FirmwareDialog.this.progressBarPanel);
                        }
                        FirmwareDialog.this.progresbar.setProgressBarText(new JLabel("Opening the firmware image..."));
                        FirmwareDialog.this.progressBarPanel = FirmwareDialog.this.progresbar.getProgressbar();
                        FirmwareDialog.this.c.gridx = 1;
                        FirmwareDialog.this.c.gridy = 2;
                        FirmwareDialog.this.c.insets = new Insets(0, 0, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)FirmwareDialog.this.progressBarPanel, FirmwareDialog.this.c);
                        FirmwareDialog.this.firmwarePanel.repaint();
                        FirmwareDialog.this.firmwarePanel.revalidate();
                        int n = ((SASAdapter)object2).openMRCtrlFirmwareImage(byArray, byArray2);
                        if (n != 0) {
                            throw new VKOperationFailedException(n);
                        }
                        FirmwareDialog.this.firmwarePanel.remove(FirmwareDialog.this.progressBarPanel);
                        FirmwareDialog.this.progresbar.setProgressBarText(new JLabel(Resource.getString("FIRWMWARE_DOWNLAD", "Downloading the firmware image...")));
                        FirmwareDialog.this.progressBarPanel = FirmwareDialog.this.progresbar.getProgressbar();
                        FirmwareDialog.this.c.gridx = 1;
                        FirmwareDialog.this.c.gridy = 2;
                        FirmwareDialog.this.c.insets = new Insets(0, 0, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)FirmwareDialog.this.progressBarPanel, FirmwareDialog.this.c);
                        FirmwareDialog.this.firmwarePanel.repaint();
                        FirmwareDialog.this.firmwarePanel.revalidate();
                        int n2 = ((SASAdapter)object2).downloadMRCtrlFirmwareImage(byArray, byArray2);
                        if (n2 != 0) throw new VKOperationFailedException(n2);
                        ((SASAdapter)object2).createInformation();
                        object = ((SASAdapter)object2).getInformation();
                        if (((MR_CTRL_INFO)object).getadapterOperationsEx_MR_CTRL_INFO().getSupportResetNow() == 1) {
                            this.isOFUSupported = true;
                            m_newFWVersion = FirmwareDialog.this.getNewFWVersion(m_newFWFileName);
                            String string = FirmwareDialog.this.getCurrentFWVersion();
                            String string2 = "";
                            Object[] objectArray = new Object[]{new String(m_newFWVersion), new String(string)};
                            string2 = MessageFormat.format(Resource.getString("MESSAGE_COMPATIBLE_DESCRIPTION", "<html> Online Firmware Update is possible.<br> In this case, system reboot is not required for the new firmware to take effect.<br> Do you want to use this option?</html>"), objectArray);
                            if (CustomMsgBox.confirmWithCheck(FirmwareDialog.this.firmwarePanel, Resource.getString("ONLINE_FIRMWARE_UPDATE_TITLE", "Online Firmware Update"), string2)) {
                                this.isOFUTriggered = true;
                            }
                        }
                        FirmwareDialog.this.firmwarePanel.remove(FirmwareDialog.this.progressBarPanel);
                        FirmwareDialog.this.progresbar.setProgressBarText(new JLabel(Resource.getString("FIRMWARE_FLASH", "Flashing the firmware image...")));
                        FirmwareDialog.this.progressBarPanel = FirmwareDialog.this.progresbar.getProgressbar();
                        FirmwareDialog.this.c.gridx = 1;
                        FirmwareDialog.this.c.gridy = 2;
                        FirmwareDialog.this.c.insets = new Insets(0, 0, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)FirmwareDialog.this.progressBarPanel, FirmwareDialog.this.c);
                        FirmwareDialog.this.firmwarePanel.repaint();
                        FirmwareDialog.this.firmwarePanel.revalidate();
                        if (this.isOFUSupported && this.isOFUTriggered) {
                            int n3 = ((SASAdapter)object2).flashMRCtrlFirmwareImage(byArray, byArray2, true, true);
                            if (n3 == 105) {
                                this.flashdone = true;
                                this.isResetNotAllowed = true;
                                return null;
                            } else {
                                if (n3 != 0) throw new VKOperationFailedException(n3);
                                this.flashdone = true;
                            }
                            return null;
                        } else if (this.isOFUSupported && !this.isOFUTriggered) {
                            int n4 = ((SASAdapter)object2).flashMRCtrlFirmwareImage(byArray, byArray2, true, false);
                            if (n4 != 0) {
                                throw new VKOperationFailedException(n4);
                            }
                            this.flashdone = true;
                            return null;
                        } else {
                            int n5 = ((SASAdapter)object2).flashMRCtrlFirmwareImage(byArray, byArray2, false, false);
                            if (n5 != 0) {
                                throw new VKOperationFailedException(n5);
                            }
                            this.flashdone = true;
                        }
                        return null;
                    } else {
                        FirmwareDialog.this.firmwarePanel.remove(FirmwareDialog.this.progressBarPanel);
                        FirmwareDialog.this.progresbar.setProgressBarText(new JLabel(Resource.getString("FIRMWARE_FLASH", "Flashing the firmware image...")));
                        FirmwareDialog.this.progressBarPanel = FirmwareDialog.this.progresbar.getProgressbar();
                        if (((SASAdapter)FirmwareDialog.this.m_adapHelper.getDeviceObject()).getAdapterType() != 2 && ((SASAdapter)FirmwareDialog.this.m_adapHelper.getDeviceObject()).getAdapterType() != 3 && ((SASAdapter)FirmwareDialog.this.m_adapHelper.getDeviceObject()).getAdapterType() != 4) {
                            FirmwareDialog.this.c.gridx = 1;
                            FirmwareDialog.this.c.gridy = 2;
                            FirmwareDialog.this.c.insets = new Insets(0, 0, 0, 0);
                            FirmwareDialog.this.firmwarePanel.add((Component)FirmwareDialog.this.progressBarPanel, FirmwareDialog.this.c);
                        } else if (((SASAdapter)FirmwareDialog.this.m_adapHelper.getDeviceObject()).isWarhawk()) {
                            FirmwareDialog.this.c.gridx = 0;
                            FirmwareDialog.this.c.gridy = 6;
                            FirmwareDialog.this.c.insets = new Insets(0, 0, 0, 0);
                            FirmwareDialog.this.firmwarePanel.add((Component)FirmwareDialog.this.progressBarPanel, FirmwareDialog.this.c);
                        } else {
                            FirmwareDialog.this.c.gridx = 0;
                            FirmwareDialog.this.c.gridy = 12;
                            FirmwareDialog.this.c.insets = new Insets(0, 0, 0, 0);
                            FirmwareDialog.this.firmwarePanel.add((Component)FirmwareDialog.this.progressBarPanel, FirmwareDialog.this.c);
                        }
                        FirmwareDialog.this.firmwarePanel.repaint();
                        FirmwareDialog.this.firmwarePanel.revalidate();
                        ((SASAdapter)FirmwareDialog.this.m_adapHelper.getDeviceObject()).flashFWOperation(byArray, byArray2, operationDetails);
                        this.flashdone = true;
                    }
                    return null;
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    this.flashdone = false;
                    FirmwareDialog.this.progressBarPanel.setVisible(false);
                    FirmwareDialog.this.firmwarePanel.revalidate();
                    FirmwareDialog.this.firmwarePanel.repaint();
                    CustomMsgBox.errorMsg(vKOperationFailedException);
                    return null;
                }
                catch (VKInvalidOperationException vKInvalidOperationException) {
                    return null;
                }
                catch (VKNotRespondingException vKNotRespondingException) {
                    vKNotRespondingException.printStackTrace();
                    return null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
                finally {
                    VivaldiStartupDialog.mainScreen.ready();
                }
            }

            @Override
            protected void done() {
                if (operationDetails.getOpcode() == 3) {
                    FirmwareDialog.this.progressBarPanel.setVisible(false);
                    FirmwareDialog.this.firmwarePanel.revalidate();
                    FirmwareDialog.this.firmwarePanel.repaint();
                    if (this.flashdone && ((SASAdapter)FirmwareDialog.this.m_adapHelper.getDeviceObject()).getAdapterType() != 2 && ((SASAdapter)FirmwareDialog.this.m_adapHelper.getDeviceObject()).getAdapterType() != 3 && ((SASAdapter)FirmwareDialog.this.m_adapHelper.getDeviceObject()).getAdapterType() != 4) {
                        Object[] objectArray = new Object[]{new String(m_newFWVersion)};
                        if (this.isOFUTriggered && this.isResetNotAllowed) {
                            String string = MessageFormat.format(Resource.getString("MSG_RESETNOW_NOT_ALLOWED", "<html>New Firmware Version : {0} <br> is flashed successfully. But could  not continue the <br>Online Firmware Update with the new firmware. <br>System reboot is required for  the new Firmware to take effect.</html>"), objectArray);
                            int n = ((SASAdapter)FirmwareDialog.this.m_adapHelper.getDeviceObject()).closeFlash();
                            new CustomMsgBox(VivaldiStartupDialog.mainScreen, string, Resource.getString("ONLINE_FIRMWARE_UPDATE_TITLE", "Online Firmware Update"), 2);
                        } else if (this.isOFUTriggered && !this.isResetNotAllowed) {
                            String string = MessageFormat.format(Resource.getString("MSG_RESETNOW_STAT_OK", "<html>New Firmware Version: {0} <br> is flashed successfully. Online Firmware Update will start soon.</html>"), objectArray);
                            new CustomMsgBox(VivaldiStartupDialog.mainScreen, string, Resource.getString("ONLINE_FIRMWARE_UPDATE_TITLE", "Online Firmware Update"), 1);
                        } else {
                            String string = MessageFormat.format(Resource.getString("MSG_FW_REBOOT", "<html>New Firmware Version:{0}<br>is flashed successfully. System reboot is required<br>for the new Firmware to take effect.</html>"), objectArray);
                            new CustomMsgBox((Component)VivaldiStartupDialog.mainScreen, (Object)string, 2);
                        }
                    }
                }
                FirmwareDialog.this.jdlg.dispose();
            }
        };
        mainWorker.execute();
        this.goButton.setEnabled(false);
        this.browse.setEnabled(false);
        if (((SASAdapter)this.m_adapHelper.getDeviceObject()).getAdapterType() != 2 && ((SASAdapter)this.m_adapHelper.getDeviceObject()).getAdapterType() != 3 && ((SASAdapter)this.m_adapHelper.getDeviceObject()).getAdapterType() != 4) {
            this.c.gridx = 1;
            this.c.gridy = 2;
            this.c.insets = new Insets(0, 0, 0, 0);
            this.firmwarePanel.add((Component)this.progressBarPanel, this.c);
        } else if (((SASAdapter)this.m_adapHelper.getDeviceObject()).isWarhawk()) {
            this.c.gridx = 0;
            this.c.gridy = 6;
            this.c.insets = new Insets(0, 0, 0, 0);
            this.firmwarePanel.add((Component)this.progressBarPanel, this.c);
        } else {
            this.c.gridx = 0;
            this.c.gridy = 12;
            this.c.insets = new Insets(0, 0, 0, 0);
            this.firmwarePanel.add((Component)this.progressBarPanel, this.c);
        }
        this.firmwarePanel.revalidate();
        this.firmwarePanel.repaint();
        this.jdlg.repaint();
        this.jdlg.setVisible(false);
        this.jdlg.setVisible(true);
    }

    public String getCurrentFWVersion() {
        String string = "";
        MR_CTRL_INFO mR_CTRL_INFO = ((SASAdapter)this.m_adapHelper.getDeviceObject()).getInformation();
        MR_FLASH_COMP_INFO[] mR_FLASH_COMP_INFOArray = mR_CTRL_INFO.getimageComponent_MR_CTRL_INFO();
        for (int i = 0; i < mR_FLASH_COMP_INFOArray.length; ++i) {
            if (!new String(mR_FLASH_COMP_INFOArray[i].getname()).trim().equals("APP")) continue;
            string = new String(mR_FLASH_COMP_INFOArray[i].getversion()).trim();
            break;
        }
        return string;
    }

    public String getNewFWVersion(String string) {
        byte[] byArray = new byte[4];
        long l = -1L;
        File file = new File(string);
        long l2 = file.length();
        byte[] byArray2 = new byte[(int)l2];
        int n = 0;
        String string2 = "";
        int n2 = 0;
        if (((SASAdapter)this.m_adapHelper.getDeviceObject()).getInformation().gethwPresent_MR_CTRL_INFO().getmemory() == 0) {
            n2 = 1;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray2, n, (int)l2);
            int n3 = 0;
            while ((long)n3 < 0L + l2) {
                for (int i = 0; i < FW_HEADER_LOCATION.length; ++i) {
                    int n4 = n3 + FW_HEADER_LOCATION[i];
                    l = NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n4);
                    System.out.println(l);
                    int n5 = (int)l;
                    System.out.println(n5);
                    System.out.println(Integer.toHexString(n5));
                    if (!this.isValidCheckWord((int)l)) continue;
                    long l3 = 0L;
                    long l4 = 0L;
                    String string3 = "";
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    l3 += l4;
                    string3 = new String(byArray2, n4 + 16, 4).trim();
                    if (!string3.equals("APP")) continue;
                    n6 = (int)NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n4 + 20);
                    l4 = (int)NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n4 + 24);
                    n7 = (int)NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n4 + 28);
                    n8 = (int)NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n4 + 32);
                    n9 = (int)NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n4 + 36);
                    n10 = (int)NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n4 + 40);
                    n11 = (int)NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n4 + 44);
                    int n12 = n3 + n8;
                    int n13 = n3 + n9;
                    int n14 = n3 + n7;
                    String string4 = new String(byArray2, n14, 15).trim();
                    if (n2 == n11) {
                        string2 = string4;
                    }
                    n3 = (int)((long)n3 + (l4 - 131072L));
                }
                n3 += 131072;
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private boolean isValidCheckWord(int n) {
        switch (n) {
            case 808530768: 
            case 825308496: 
            case 825701456: 
            case 826429252: 
            case 826561110: 
            case 827214156: 
            case 843206468: 
            case 843338326: 
            case 858928464: 
            case 942682418: 
            case 942682419: 
            case 942682674: 
            case 942749008: 
            case 943140913: 
            case 1112687696: 
            case 1313426259: 
            case 1397904965: {
                return true;
            }
        }
        return false;
    }

    public class fwDetailPanel
    extends JPanel {
        private OperationDetails opDetails;
        private GUIHelperInterface guiHelper;
        private JTextField fwFileName;
        private JRadioButton objControllerFirmware;
        private JRadioButton objBIOS;
        private JRadioButton objEFIBSD;
        private JRadioButton objFCODE;

        public fwDetailPanel(OperationDetails operationDetails, AdapterHelper adapterHelper) {
            String[] stringArray = null;
            Object var5_5 = null;
            this.opDetails = operationDetails;
            this.guiHelper = adapterHelper;
            Font font = this.getFont();
            if (!VivaldiStartupDialog.isWindows) {
                font = Locale.getDefault().getLanguage().equals(Locale.ENGLISH.getLanguage()) ? new Font("Arial", 1, 12) : GUIUtils.getDefaultFont(15, this.getFont().getFontName(this.getLocale()), 12, this);
                if (MainFrame.SCREEN_SIZE.width <= 800) {
                    font = Locale.getDefault().getLanguage() == Locale.ENGLISH.getLanguage() ? new Font("Arial", 1, 10) : GUIUtils.getDefaultFont(13, this.getFont().getFontName(), 10, this);
                }
                this.setFont(font);
                this.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
            }
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.setLayout(new BorderLayout());
            if (operationDetails == null) {
                JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 5));
                jPanel.setOpaque(false);
                JLabel jLabel = new JLabel(Resource.getString("OPERATION_INSTRUCTION_TEXT", "<html>Select an operation from the left and press go to<br>invoke the selected Operation !</html>"), 0);
                jLabel.setFont(font);
                jPanel.add(jLabel);
                this.add((Component)jPanel, "North");
                return;
            }
            GridLayout gridLayout = new GridLayout(2, 1, 5, 5);
            gridLayout.setHgap(10);
            gridLayout.setVgap(0);
            JPanel jPanel = new JPanel(gridLayout);
            jPanel.setOpaque(false);
            JTextArea jTextArea = new JTextArea(Resource.getString("OPERATION_DESC_TEXT", "Description : ") + this.opDetails.getDescription());
            jTextArea.setFont(font);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setLineWrap(true);
            jTextArea.setOpaque(false);
            jTextArea.setBorder(BorderFactory.createEmptyBorder());
            jTextArea.setEditable(false);
            jPanel.add(jTextArea);
            this.add((Component)jPanel, "North");
            if (adapterHelper.getType() == 1 && operationDetails.getOpcode() == 3) {
                stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_BROWSE_TEXT", "Browse"));
                FirmwareDialog.this.browse = new JButton(stringArray[0]);
                FirmwareDialog.this.browse.setToolTipText(Resource.getString("BUTTON_BROWSE_TEXT_DSC", "Browse"));
                if (stringArray.length == 2) {
                    FirmwareDialog.this.browse.setMnemonic(stringArray[1].charAt(0));
                }
                this.fwFileName = new JTextField(20);
                this.fwFileName.setToolTipText(Resource.getString("FILE_NAME_DSC", "Enter Or Select File Name"));
                FirmwareDialog.this.browse.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                return file.isDirectory() || file.getPath().toUpperCase().endsWith(".ROM") || file.getPath().toUpperCase().endsWith(".FW") || file.getPath().toUpperCase().endsWith(".BIN");
                            }

                            @Override
                            public String getDescription() {
                                return Resource.getString("LABEL_FILETYPE_FWFLASH", "Firmware Flash Files(*.rom,*.fw,*.bin)");
                            }
                        });
                        if (jFileChooser.showOpenDialog(null) == 0) {
                            fwDetailPanel.this.fwFileName.setText(jFileChooser.getSelectedFile().getPath());
                        }
                    }
                });
                stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_FILE_TEXT", "File:"));
                JLabel jLabel = new JLabel(stringArray[0]);
                if (stringArray.length == 2) {
                    jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
                }
                jLabel.setLabelFor(this.fwFileName);
                AdapterHelper adapterHelper2 = (AdapterHelper)this.guiHelper;
                FirmwareDialog.this.firmwarePanel = new JPanel(new GridBagLayout());
                FirmwareDialog.this.c = new GridBagConstraints();
                this.setFont(font);
                FirmwareDialog.this.firmwarePanel.setOpaque(false);
                SASAdapter sASAdapter = (SASAdapter)adapterHelper.getDeviceObject();
                if (sASAdapter.getAdapterType() == 2 || sASAdapter.getAdapterType() == 3 || sASAdapter.getAdapterType() == 4) {
                    MR_CTRL_INFO mR_CTRL_INFO = adapterHelper2.getAdapterInfo();
                    String string = "";
                    String string2 = "";
                    String string3 = "";
                    String string4 = "";
                    MR_FLASH_COMP_INFO[] mR_FLASH_COMP_INFOArray = mR_CTRL_INFO.getimageComponent_MR_CTRL_INFO();
                    int n = Math.min(mR_FLASH_COMP_INFOArray.length, mR_CTRL_INFO.getimageComponentCount());
                    for (int i = 0; i < n; ++i) {
                        if (Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getname()).equals("APP")) {
                            string = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
                            continue;
                        }
                        if (Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getname()).equals("BIOS")) {
                            string2 = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
                            continue;
                        }
                        if (Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getname()).equals("EFI-BSD")) {
                            string3 = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
                            continue;
                        }
                        if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getname()).equals("FCODE")) continue;
                        string4 = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
                    }
                    string3 = "NA";
                    string4 = "NA";
                    FirmwareDialog.this.c.gridwidth = 1;
                    FirmwareDialog.this.c.gridheight = 1;
                    FirmwareDialog.this.c.weightx = 1.0;
                    FirmwareDialog.this.c.weighty = 1.0;
                    FirmwareDialog.this.c.fill = 0;
                    FirmwareDialog.this.c.ipadx = 0;
                    FirmwareDialog.this.c.ipady = 0;
                    FirmwareDialog.this.c.insets = new Insets(0, 0, 0, 0);
                    FirmwareDialog.this.c.gridx = 0;
                    FirmwareDialog.this.c.gridy = 0;
                    FirmwareDialog.this.c.anchor = 17;
                    if (sASAdapter.isWarhawk()) {
                        StringBuffer stringBuffer = new StringBuffer(Resource.getString("CURRENT_FW_PKG_VERSION_TEXT", "Current Firmware Package Version: "));
                        stringBuffer.append(Resource.zeroTrim(mR_CTRL_INFO.getfwPackageVersion()));
                        JLabel jLabel2 = new JLabel(stringBuffer.toString());
                        FirmwareDialog.this.c.gridy = 1;
                        FirmwareDialog.this.c.insets = new Insets(0, 10, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)jLabel2, FirmwareDialog.this.c);
                        StringBuffer stringBuffer2 = new StringBuffer(Resource.getString("CURRENT_VERSION_TEXT", "Current version: "));
                        stringBuffer2.append(string);
                        JLabel jLabel3 = new JLabel(stringBuffer2.toString());
                        FirmwareDialog.this.c.gridy = 2;
                        FirmwareDialog.this.c.insets = new Insets(0, 10, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)jLabel3, FirmwareDialog.this.c);
                        StringBuffer stringBuffer3 = new StringBuffer(Resource.getString("CURRENT_BIOS_VERSION_TEXT", "Current BIOS Version: "));
                        stringBuffer3.append(string2);
                        JLabel jLabel4 = new JLabel(stringBuffer3.toString());
                        FirmwareDialog.this.c.gridy = 3;
                        FirmwareDialog.this.c.insets = new Insets(0, 10, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)jLabel4, FirmwareDialog.this.c);
                        StringBuffer stringBuffer4 = new StringBuffer(Resource.getString("CURRENT_EFI_BSD_VERSION_TEXT", "Current EFI_BSD Version: "));
                        stringBuffer4.append(string3);
                        JLabel jLabel5 = new JLabel(stringBuffer4.toString());
                        FirmwareDialog.this.c.gridy = 4;
                        FirmwareDialog.this.c.insets = new Insets(0, 10, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)jLabel5, FirmwareDialog.this.c);
                        FirmwareDialog.this.c.gridy = 5;
                        FirmwareDialog.this.firmwarePanel.add((Component)this.fwFileName, FirmwareDialog.this.c);
                        FirmwareDialog.this.c.gridx = 1;
                        FirmwareDialog.this.firmwarePanel.add((Component)FirmwareDialog.this.browse, FirmwareDialog.this.c);
                        this.add((Component)FirmwareDialog.this.firmwarePanel, "West");
                        this.setPreferredSize(new Dimension(460 * MainFrame.SCREEN_SIZE.width / 1024, 280 * MainFrame.SCREEN_SIZE.height / 768));
                    } else {
                        JLabel jLabel6 = new JLabel(Resource.getString("FIRMWARE_UPDATE_TEXT", "Firmware to update:"));
                        FirmwareDialog.this.firmwarePanel.add((Component)jLabel6, FirmwareDialog.this.c);
                        stringArray = Resource.getResourceMnemonic(Resource.getString("CONTROLLER_FIRMWARE_TEXT", "Controller firmware"));
                        this.objControllerFirmware = new JRadioButton(stringArray[0]);
                        if (stringArray.length == 2) {
                            this.objControllerFirmware.setMnemonic(stringArray[1].charAt(0));
                        }
                        this.objControllerFirmware.setSelected(true);
                        this.objControllerFirmware.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                        FirmwareDialog.this.c.gridy = 1;
                        FirmwareDialog.this.firmwarePanel.add((Component)this.objControllerFirmware, FirmwareDialog.this.c);
                        this.objControllerFirmware.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (fwDetailPanel.this.objControllerFirmware.isSelected()) {
                                    fwDetailPanel.this.objBIOS.setSelected(false);
                                    fwDetailPanel.this.objEFIBSD.setSelected(false);
                                    fwDetailPanel.this.objFCODE.setSelected(false);
                                }
                            }
                        });
                        StringBuffer stringBuffer = new StringBuffer(Resource.getString("CURRENT_VERSION_TEXT", "Current version: "));
                        stringBuffer.append(string);
                        JLabel jLabel7 = new JLabel(stringBuffer.toString());
                        FirmwareDialog.this.c.gridy = 2;
                        FirmwareDialog.this.c.insets = new Insets(0, 10, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)jLabel7, FirmwareDialog.this.c);
                        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_LOAD_BIOS", "Load BIOS"));
                        this.objBIOS = new JRadioButton(stringArray[0]);
                        if (stringArray.length == 2) {
                            this.objBIOS.setMnemonic(stringArray[1].charAt(0));
                        }
                        this.objBIOS.setSelected(false);
                        this.objBIOS.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                        FirmwareDialog.this.c.gridy = 3;
                        FirmwareDialog.this.c.insets = new Insets(0, 0, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)this.objBIOS, FirmwareDialog.this.c);
                        this.objBIOS.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (fwDetailPanel.this.objBIOS.isSelected()) {
                                    fwDetailPanel.this.objControllerFirmware.setSelected(false);
                                    fwDetailPanel.this.objEFIBSD.setSelected(false);
                                    fwDetailPanel.this.objFCODE.setSelected(false);
                                }
                            }
                        });
                        StringBuffer stringBuffer5 = new StringBuffer(Resource.getString("CURRENT_VERSION_TEXT", "Current version: "));
                        stringBuffer5.append(string2);
                        JLabel jLabel8 = new JLabel(stringBuffer5.toString());
                        FirmwareDialog.this.c.gridy = 4;
                        FirmwareDialog.this.c.insets = new Insets(0, 10, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)jLabel8, FirmwareDialog.this.c);
                        stringArray = Resource.getResourceMnemonic(Resource.getString("EFI_BSD_TEXT", "EFI-BSD"));
                        this.objEFIBSD = new JRadioButton(stringArray[0]);
                        if (stringArray.length == 2) {
                            this.objEFIBSD.setMnemonic(stringArray[1].charAt(0));
                        }
                        this.objEFIBSD.setSelected(false);
                        this.objEFIBSD.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                        FirmwareDialog.this.c.gridy = 5;
                        FirmwareDialog.this.c.insets = new Insets(0, 0, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)this.objEFIBSD, FirmwareDialog.this.c);
                        this.objEFIBSD.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (fwDetailPanel.this.objEFIBSD.isSelected()) {
                                    fwDetailPanel.this.objControllerFirmware.setSelected(false);
                                    fwDetailPanel.this.objBIOS.setSelected(false);
                                    fwDetailPanel.this.objFCODE.setSelected(false);
                                }
                            }
                        });
                        StringBuffer stringBuffer6 = new StringBuffer(Resource.getString("CURRENT_VERSION_TEXT", "Current version: "));
                        stringBuffer6.append(string3);
                        JLabel jLabel9 = new JLabel(stringBuffer6.toString());
                        FirmwareDialog.this.c.gridy = 6;
                        FirmwareDialog.this.c.insets = new Insets(0, 10, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)jLabel9, FirmwareDialog.this.c);
                        stringArray = Resource.getResourceMnemonic(Resource.getString("FCODE_TEXT", "FCODE"));
                        this.objFCODE = new JRadioButton(stringArray[0]);
                        if (stringArray.length == 2) {
                            this.objFCODE.setMnemonic(stringArray[1].charAt(0));
                        }
                        this.objFCODE.setSelected(false);
                        this.objFCODE.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                        FirmwareDialog.this.c.gridy = 7;
                        FirmwareDialog.this.c.insets = new Insets(0, 0, 0, 0);
                        this.objFCODE.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (fwDetailPanel.this.objFCODE.isSelected()) {
                                    fwDetailPanel.this.objControllerFirmware.setSelected(false);
                                    fwDetailPanel.this.objBIOS.setSelected(false);
                                    fwDetailPanel.this.objEFIBSD.setSelected(false);
                                }
                            }
                        });
                        StringBuffer stringBuffer7 = new StringBuffer(Resource.getString("CURRENT_VERSION_TEXT", "Current version: "));
                        stringBuffer7.append(string4);
                        JLabel jLabel10 = new JLabel(stringBuffer7.toString());
                        FirmwareDialog.this.c.gridy = 8;
                        FirmwareDialog.this.c.insets = new Insets(0, 10, 0, 0);
                        FirmwareDialog.this.c.gridy = 10;
                        FirmwareDialog.this.c.insets = new Insets(0, 0, 0, 0);
                        FirmwareDialog.this.firmwarePanel.add((Component)jLabel, FirmwareDialog.this.c);
                        FirmwareDialog.this.c.gridy = 11;
                        FirmwareDialog.this.firmwarePanel.add((Component)this.fwFileName, FirmwareDialog.this.c);
                        FirmwareDialog.this.c.gridx = 1;
                        FirmwareDialog.this.firmwarePanel.add((Component)FirmwareDialog.this.browse, FirmwareDialog.this.c);
                        this.add((Component)FirmwareDialog.this.firmwarePanel, "West");
                        this.setPreferredSize(new Dimension(460 * MainFrame.SCREEN_SIZE.width / 1024, 300 * MainFrame.SCREEN_SIZE.height / 768));
                    }
                } else {
                    FirmwareDialog.this.c.gridx = 0;
                    FirmwareDialog.this.c.gridy = 0;
                    FirmwareDialog.this.c.insets = new Insets(0, 20, 0, 0);
                    FirmwareDialog.this.firmwarePanel.add((Component)jLabel, FirmwareDialog.this.c);
                    FirmwareDialog.this.c.gridx = 1;
                    FirmwareDialog.this.c.gridy = 0;
                    FirmwareDialog.this.firmwarePanel.add((Component)this.fwFileName, FirmwareDialog.this.c);
                    FirmwareDialog.this.c.gridx = 2;
                    FirmwareDialog.this.c.gridy = 0;
                    FirmwareDialog.this.firmwarePanel.add((Component)FirmwareDialog.this.browse, FirmwareDialog.this.c);
                    FirmwareDialog.this.c.insets = new Insets(0, 0, 0, 0);
                    FirmwareDialog.this.c.gridx = 0;
                    FirmwareDialog.this.c.gridy = 1;
                    this.add((Component)FirmwareDialog.this.firmwarePanel, "Center");
                    this.setPreferredSize(new Dimension(460 * MainFrame.SCREEN_SIZE.width / 1024, 150 * MainFrame.SCREEN_SIZE.height / 768));
                }
            }
        }

        public boolean isReady() {
            if (this.guiHelper.getType() == 1 && this.opDetails.getOpcode() == 3) {
                File file = new File(this.fwFileName.getText());
                m_newFWFileName = this.fwFileName.getText().trim();
                boolean bl = true;
                if (file.exists()) {
                    Object object;
                    String string = Resource.getString("CONTOLLER_FIRMWARE", "controller firmware");
                    String string2 = "0";
                    if (file.isFile()) {
                        object = (SASAdapter)this.guiHelper.getDeviceObject();
                        if (((SASAdapter)object).getAdapterType() == 1) {
                            if (file.getPath().toUpperCase().endsWith(".ROM")) {
                                bl = false;
                            }
                        } else if (((SASAdapter)object).getAdapterType() == 2 || ((SASAdapter)object).getAdapterType() == 3 || ((SASAdapter)object).getAdapterType() == 4) {
                            if (((SASAdapter)object).isWarhawk()) {
                                bl = false;
                            } else if (this.objControllerFirmware.isSelected()) {
                                bl = false;
                            } else if (this.objBIOS.isSelected()) {
                                string = Resource.getString("BIOS_TEXT", "BIOS");
                                string2 = "1";
                                if (file.getPath().toUpperCase().endsWith(".ROM")) {
                                    bl = false;
                                }
                            } else if (this.objEFIBSD.isSelected()) {
                                string = Resource.getString("EFI_BSD_TEXT", "EFI-BSD");
                                string2 = "3";
                                if (file.getPath().toUpperCase().endsWith(".ROM")) {
                                    bl = false;
                                }
                            } else if (this.objFCODE.isSelected()) {
                                string = Resource.getString("FCODE_TEXT", "FCODE");
                                string2 = "2";
                                if (file.getPath().toUpperCase().endsWith(".ROM")) {
                                    bl = false;
                                }
                            }
                        }
                    }
                    if (bl) {
                        new CustomMsgBox(this, Resource.getString("NO_FIRMWARE_FILE1", "The specified file is not a valid ") + string + Resource.getString("NO_FIRMWARE_FILE2", "file. Please check the file path and try again."));
                        return false;
                    }
                    if (file.length() / 1024L >= 16384L) {
                        new CustomMsgBox(this, Resource.getString("16MB_FLASH_IMAGE_CAPACITY_EXCEEDED", "<html>This file is equal to or exceeds the 16 MB size limit. <br><br>Please select a firmware image with size less than 16 MB.<br><br></html>"));
                        return false;
                    }
                    object = string2 + this.fwFileName.getText();
                    this.opDetails.setParameter(object);
                    return true;
                }
                new CustomMsgBox(this, Resource.getString("FIRMWARE_FILE_NOT_FOUND", "The specified file could not be found. \n Please check the file path and try again."));
                return false;
            }
            return true;
        }
    }
}

