/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.ServerObjectHelper;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import Utils.ColorHash;
import Utils.CustomTabbedPane;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GroupConsistencyCheckDialog
extends VivaldiBaseDialog {
    private CustomTabbedPane tabPane = new CustomTabbedPane();
    private String[] mnemonics;

    public GroupConsistencyCheckDialog(ServerObjectHelper serverObjectHelper) {
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(Resource.getString("GRP_CONCHECK_TITLE", "Group Consistency Check"));
        this.setSize(MainFrame.SCREEN_SIZE.width * 600 / 1024, MainFrame.SCREEN_SIZE.height * 500 / 768);
        this.setLocation((MainFrame.SCREEN_SIZE.width - this.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.getHeight()) / 2);
        AdapterHelper[] adapterHelperArray = serverObjectHelper.getAdapterHelpers();
        if (adapterHelperArray == null || adapterHelperArray.length <= 0) {
            this.dispose();
            return;
        }
        for (int i = 0; i < adapterHelperArray.length; ++i) {
            if (((SASAdapter)adapterHelperArray[i].getDeviceObject()).isWarhawk()) continue;
            this.tabPane.addTab(adapterHelperArray[i].getText(), new AdapterCCTab(adapterHelperArray[i], this));
            this.contentPane.add((Component)this.tabPane, "Center");
        }
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
        this.show();
    }

    class AdapterCCTab
    extends JPanel
    implements HelpInterface {
        private String[] mnemonics;
        private ArrayList allLogicalDrives = new ArrayList();
        private JCheckBox[] allCheckBoxes;
        private JPanel grid = new JPanel();
        private AdapterHelper m_adapterHelper;
        private JButton m_deselectAll = null;
        private JButton m_selectAll = null;
        private JButton m_checkCons = null;
        ActionListener CheckBoxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                int n2 = AdapterCCTab.this.allCheckBoxes.length;
                for (int i = 0; i < n2; ++i) {
                    if (AdapterCCTab.this.allCheckBoxes[i] == null || !AdapterCCTab.this.allCheckBoxes[i].isSelected()) continue;
                    ++n;
                }
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                boolean bl = abstractButton.getModel().isSelected();
                if (bl) {
                    AdapterCCTab.this.m_checkCons.setEnabled(true);
                    AdapterCCTab.this.m_deselectAll.setEnabled(true);
                    AdapterCCTab.this.m_selectAll.setEnabled(true);
                    if (n == n2) {
                        AdapterCCTab.this.m_selectAll.setEnabled(false);
                    }
                } else if (n == 0) {
                    AdapterCCTab.this.m_checkCons.setEnabled(false);
                    AdapterCCTab.this.m_selectAll.setEnabled(true);
                    AdapterCCTab.this.m_deselectAll.setEnabled(false);
                } else if (n != 0) {
                    AdapterCCTab.this.m_checkCons.setEnabled(true);
                    AdapterCCTab.this.m_selectAll.setEnabled(true);
                    AdapterCCTab.this.m_deselectAll.setEnabled(true);
                }
            }
        };

        public AdapterCCTab(AdapterHelper adapterHelper, final GroupConsistencyCheckDialog groupConsistencyCheckDialog2) {
            this.m_adapterHelper = adapterHelper;
            this.grid.setLayout(new BoxLayout(this.grid, 3));
            this.grid.setBorder(BorderFactory.createTitledBorder(Resource.getString("MSG_SELCCLDRIVE_TEXT", "Select Virtual Disks :")));
            this.grid.setBackground(ColorHash.getColor("LIGHT_BACKGROUND"));
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(this.grid), "Center");
            JPanel jPanel = new JPanel();
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_SELECTALL_TEXT", "Select All"));
            this.m_selectAll = new JButton(this.mnemonics[0]);
            if (this.mnemonics.length == 2) {
                this.m_selectAll.setMnemonic(this.mnemonics[1].charAt(0));
            }
            this.m_selectAll.setToolTipText(Resource.getString("BUTTON_SELECTALL_DSC", "Select All"));
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_DESELECTALL_TEXT", "Deselect All"));
            this.m_deselectAll = new JButton(this.mnemonics[0]);
            if (this.mnemonics.length == 2) {
                this.m_deselectAll.setMnemonic(this.mnemonics[1].charAt(0));
            }
            this.m_deselectAll.setToolTipText(Resource.getString("BUTTON_DESELECTALL_DSC", "Deselect All"));
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_START", "Start"));
            this.m_checkCons = new JButton(this.mnemonics[0]);
            if (this.mnemonics.length == 2) {
                this.m_checkCons.setMnemonic(this.mnemonics[1].charAt(0));
            }
            this.m_checkCons.setToolTipText(Resource.getString("BUTTON_CC_START_DSC", "Consistency Check Start"));
            this.m_selectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < AdapterCCTab.this.allCheckBoxes.length; ++i) {
                        AdapterCCTab.this.allCheckBoxes[i].setSelected(true);
                    }
                    AdapterCCTab.this.m_selectAll.setEnabled(false);
                    AdapterCCTab.this.m_deselectAll.setEnabled(true);
                    AdapterCCTab.this.m_checkCons.setEnabled(true);
                }
            });
            this.m_deselectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < AdapterCCTab.this.allCheckBoxes.length; ++i) {
                        AdapterCCTab.this.allCheckBoxes[i].setSelected(false);
                    }
                    AdapterCCTab.this.m_selectAll.setEnabled(true);
                    AdapterCCTab.this.m_deselectAll.setEnabled(false);
                    AdapterCCTab.this.m_checkCons.setEnabled(false);
                }
            });
            this.m_checkCons.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < AdapterCCTab.this.allCheckBoxes.length; ++i) {
                        if (AdapterCCTab.this.allCheckBoxes[i] == null || !AdapterCCTab.this.allCheckBoxes[i].isSelected()) continue;
                        LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)AdapterCCTab.this.allLogicalDrives.get(i);
                        logicalDriveHelper.issueOperation(new OperationDetails(6, null));
                    }
                    AdapterCCTab.this.refresh();
                }
            });
            this.refresh();
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "Close"));
            JButton jButton = new JButton(this.mnemonics[0]);
            if (this.mnemonics.length == 2) {
                jButton.setMnemonic(this.mnemonics[1].charAt(0));
            }
            jButton.setToolTipText(Resource.getString("BUTTON_CLOSE_DSC", "Close Consistency Check Operation"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    groupConsistencyCheckDialog2.closeOpt();
                }
            });
            jPanel.add(this.m_selectAll);
            jPanel.add(this.m_deselectAll);
            jPanel.add(this.m_checkCons);
            jPanel.add(jButton);
            this.add((Component)jPanel, "South");
        }

        private void refresh() {
            int n;
            this.grid.removeAll();
            this.allLogicalDrives.clear();
            LogicalDriveHelper[] logicalDriveHelperArray = this.m_adapterHelper.getLogicalDrives();
            if (logicalDriveHelperArray.length == 0) {
                this.m_selectAll.setEnabled(false);
                this.m_deselectAll.setEnabled(false);
                this.m_checkCons.setEnabled(false);
            } else {
                this.m_selectAll.setEnabled(true);
                this.m_deselectAll.setEnabled(false);
                this.m_checkCons.setEnabled(false);
            }
            for (n = 0; n < logicalDriveHelperArray.length; ++n) {
                try {
                    if (!((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getAllAllowedOperations().isOperationAllowed(6)) continue;
                    this.allLogicalDrives.add(logicalDriveHelperArray[n]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.allCheckBoxes = new JCheckBox[this.allLogicalDrives.size()];
            for (n = 0; n < this.allCheckBoxes.length; ++n) {
                LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)this.allLogicalDrives.get(n);
                this.allCheckBoxes[n] = new JCheckBox(logicalDriveHelper.getText());
                this.allCheckBoxes[n].setOpaque(false);
                this.allCheckBoxes[n].addActionListener(this.CheckBoxActionListener);
                this.grid.add(this.allCheckBoxes[n]);
            }
            this.validate();
            this.repaint();
        }

        @Override
        public String getHelpPage() {
            if (this.m_adapterHelper.isCSA()) {
                return HelpContextResourse.getHelpPageName("MSM_CSA_RUNNING_A_GROUP_CONSISTENCY_CHECK");
            }
            if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                return HelpContextResourse.getHelpPageName("");
            }
            return HelpContextResourse.getHelpPageName("");
        }
    }
}

