/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.AdapterShowProgressTab;
import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.ServerObjectHelper;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.SASAdapter.SASAdapter;
import Utils.CustomTabbedPane;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;

public class GroupShowProgressDialog
extends VivaldiBaseDialog
implements Observer,
HelpInterface {
    private AdapterHelper[] adap;
    private ServerObjectHelper server;
    private CustomTabbedPane tabpane = new CustomTabbedPane();
    private AdapterShowProgressTab[] adapterTabs;

    public GroupShowProgressDialog(ServerObjectHelper serverObjectHelper) {
        this.server = serverObjectHelper;
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(Resource.getString("GRP_SHOWPROGRESS_TITLE", "Group Show Progress"));
        this.setSize(MainFrame.SCREEN_SIZE.width * 640 / 1024, MainFrame.SCREEN_SIZE.height * 480 / 768);
        this.setLocation((MainFrame.SCREEN_SIZE.width - this.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.getHeight()) / 2);
        this.setDefaultCloseOperation(2);
        this.contentPane.add((Component)this.tabpane, "Center");
        this.refresh();
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
        this.show();
    }

    @Override
    public void dispose() {
        this.stopObserving();
        super.dispose();
    }

    @Override
    public void update(Observable observable, Object object) {
        GUIHelperInterface gUIHelperInterface = (GUIHelperInterface)((Object)observable);
        NotifyObject notifyObject = (NotifyObject)object;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL != null) {
            System.out.println("GroupShowProgress Received AEN : " + new String(mR_EVT_DETAIL.getdescription()).trim());
        }
        if (gUIHelperInterface.getType() == 1 && (notifyObject.getNotifyCode() == 0x102001 || notifyObject.getNotifyCode() == 0x102002 || notifyObject.getNotifyCode() == 1056772)) {
            this.stopObserving();
            this.refresh();
            return;
        }
    }

    private void stopObserving() {
        int n;
        for (n = 0; n < this.adap.length; ++n) {
            this.adap[n].deleteObserver(this);
        }
        if (this.adapterTabs == null) {
            return;
        }
        for (n = 0; n < this.adapterTabs.length; ++n) {
            this.adapterTabs[n].cleanUp();
        }
    }

    private void refresh() {
        int n;
        this.adap = this.server.getAdapterHelpers();
        if (this.adap == null || this.adap.length <= 0) {
            this.dispose();
            return;
        }
        this.tabpane.removeAll();
        this.adapterTabs = new AdapterShowProgressTab[this.adap.length];
        for (n = 0; n < this.adap.length; ++n) {
            this.adapterTabs[n] = new AdapterShowProgressTab(this.adap[n], this);
            if (((SASAdapter)this.adap[n].getDeviceObject()).isWarhawk() || this.adap[n].getAdapterInfo().getmaxLDs() == '\u0000') continue;
            this.adapterTabs[n].setToolTipText(this.adap[n].getText());
            this.tabpane.addTab(this.adap[n].getText(), this.adapterTabs[n]);
        }
        this.validate();
        this.repaint();
        for (n = 0; n < this.adap.length; ++n) {
            this.adap[n].addObserver(this);
        }
    }

    @Override
    public String getHelpPage() {
        for (int i = 0; i < this.adap.length; ++i) {
            if (!this.adap[i].isCSA()) continue;
            return HelpContextResourse.getHelpPageName("MSM_CSA_GROUP_SHOW_PROGRESS");
        }
        return HelpContextResourse.getHelpPageName("");
    }
}

