/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MainFrame;
import SASKernel.SASServer;
import SASKernel.SASServerInfo;
import Utils.ColorHash;
import Utils.Resource;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class HostView
extends JLabel {
    private boolean selected = false;
    private ImageIcon defaultImage = Resource.getImage("DEFAULT_HOST_IMAGE", "host.jpg");
    private ImageIcon degradedImage = Resource.getImage("DEGRADED_IMAGE", "degraded.png");
    private ImageIcon failedImage = Resource.getImage("FAILED_IMAGE", "failed.png");
    private static final Color DEFAULT_HOST_COLOR = ColorHash.getColor("DEFAULT_HOST_COLOR");
    private static final Color SELECTED_HOST_COLOR = ColorHash.getColor("SELECTED_HOST_COLOR");
    private String hostName;
    private String hostOS;
    private String hostIPAddress;
    private SASServer server;
    private int loginCnt = 0;
    private boolean m_bIsCIMOMHost;
    private String health = null;

    public SASServer getServer() {
        return this.server;
    }

    public HostView(SASServer sASServer) {
        this.server = sASServer;
        this.setFont(this.getFont().deriveFont(0, 10.0f));
        SASServerInfo sASServerInfo = sASServer.getInformation();
        this.setPreferredSize(new Dimension(200 * MainFrame.SCREEN_SIZE.width / 1024, 80 * MainFrame.SCREEN_SIZE.height / 768));
        this.hostName = sASServerInfo.getHostName();
        this.hostOS = sASServerInfo.OperatingSystemName();
        this.hostIPAddress = sASServerInfo.getIP();
        this.setHorizontalAlignment(0);
        SASServerInfo sASServerInfo2 = this.server.getInformation();
        if (sASServerInfo2.isFailedLogicalDrivePresent()) {
            this.setIcon(this.failedImage);
            this.health = Resource.getString("PD_STATE_FAILED", "Failed");
        } else if (sASServerInfo2.isDegradedLogicalDrivePresent()) {
            this.setIcon(this.degradedImage);
            this.health = Resource.getString("DEGRADED_SERVER", "Degraded");
        } else {
            this.setIcon(this.defaultImage);
            this.health = Resource.getString("LDRIVE_STATE_OPTIMAL", "Optimal");
        }
        String string = "<html>";
        if (this.server.isCIMOMServer()) {
            this.m_bIsCIMOMHost = true;
            if (this.hostName != null) {
                string = this.hostName.length() > 14 ? string + Resource.getString("LABEL_HOSTNAME_TEXT", "Host") + " : " + this.hostName.substring(0, 11) + "...<br>" : string + Resource.getString("LABEL_HOSTNAME_TEXT", "Host") + " : " + this.hostName + "<br>";
            }
            string = string + Resource.getString("LABEL_IPADDRESS_TEXT", "IP Address") + " : " + this.hostIPAddress + "<br>";
            string = string + "</html>";
        } else {
            if (this.hostName != null) {
                string = this.hostName.length() > 14 ? string + Resource.getString("LABEL_HOSTNAME_TEXT", "Host") + " : " + this.hostName.substring(0, 11) + "...<br>" : string + Resource.getString("LABEL_HOSTNAME_TEXT", "Host") + " : " + this.hostName + "<br>";
            }
            string = string + Resource.getString("LABEL_IPADDRESS_TEXT", "IP Address") + " : " + this.hostIPAddress + "<br>";
            if (this.hostOS != null) {
                string = string + Resource.getString("LABEL_OSNAME_TEXT", "OS") + " : " + this.hostOS + "<br>";
            }
            string = string + Resource.getString("LABEL_HEALTH_TEXT", "Health") + " : " + this.health + "<br>";
            string = string + "</html>";
        }
        this.setText(string);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setOpaque(true);
        this.setBackground(DEFAULT_HOST_COLOR);
    }

    public void setSelected(boolean bl) {
        if (this.selected == bl) {
            return;
        }
        this.selected = bl;
        if (bl) {
            this.setBackground(SELECTED_HOST_COLOR);
        } else {
            this.setBackground(DEFAULT_HOST_COLOR);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostOS() {
        return this.hostOS;
    }

    public String getHostIPAddress() {
        return this.hostIPAddress;
    }

    public int getLoginCnt() {
        return this.loginCnt;
    }

    public void setLoginCnt(int n) {
        this.loginCnt = n;
    }

    public boolean isCIMOMHost() {
        return this.m_bIsCIMOMHost;
    }
}

