/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.Localization;
import GUI.LogDetailsDialog;
import GUI.MainFrame;
import GUI.Scsisensedesc;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.CCOHVirtualAdapterHelper;
import GUIHelper.EnclosureHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_PROP;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_ARG_PD;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_CCOH_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_WH_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_PD_ADDRESS;
import SASKernel.LibraryAPI.StoreLib.MR_PD_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_CONNECTOR_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.LibraryAPI.StoreLib.SL_EVENT_DETAIL_T;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASEnclosure;
import SASKernel.SASServer;
import Services.KernelConstants;
import Services.LogCallBackPacket;
import Services.LogXMLParser;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import Utils.ColorHash;
import Utils.Resource;
import Utils.TableSorter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class JLogger
extends JTable
implements Observer {
    private ColorRenderer colRen = new ColorRenderer();
    private MR_CTRL_PROP propold;
    private AdapterHelper m_adapterHelper = null;
    private Hashtable logHash = new Hashtable();
    private EnclosureHelper enclosureHelper = null;
    private ArrayHelper m_arrayHelper = null;
    public static final String CONTEXT_LOGON = "LOGON";
    public static final String CONTEXT_LOGOUT = "LOGOUT";
    public static final String CONTEXT_DENY = "DENY";
    public static final String CONTEXT_CLEAR = "CLEAR";
    private MR_PD_INFO pdInfo;
    public static final int SERVER_MODE = 0;
    public static final int LOCAL_MODE = 1;
    public static int mode = 0;
    public static final String LOG_ID = "ID = ";
    public static final String LOG_ERROR_LEVEL = "ERROR/LEVEL = ";
    public static final String LOG_SEQUENCE_NUMBER = "SEQUENCE NUMBER = ";
    public static final String LOG_DATE_TIME = "TIME = ";
    public static final String LOG_LOCALIZED_MESSAGE = "LOCALIZED MESSAGE = ";
    private SASServer serverObj = null;
    private int logCount = 0;
    private AdapterHelper[] adpHelperArray = null;
    private String xmlString = "";
    private SL_EVENT_DETAIL_T eventDetail = null;
    private SASAdapter sasAdapter = null;
    private SASAdapter localSASAdapter = null;
    private ArrayList m_adpList;
    byte[] dataBuffer = null;
    private CCOHVirtualAdapterHelper m_ccohVirtualAdapHelper = null;
    private static Hashtable<Integer, Integer> m_eventConfig = new Hashtable();
    private static Hashtable<Integer, Integer> m_eventSeverity = new Hashtable();
    private DefaultTableModel model = (DefaultTableModel)this.getModel();
    public static final int STATUS_INFO = 0;
    public static final int STATUS_WARNING = 1;
    public static final int STATUS_ERROR = 2;
    public static final int STATUS_FATAL = 3;
    public static final int STATUS_DEAD = 4;
    TableSorter sorter = new TableSorter(this.model);

    public byte[] getXMLFromTagArray(Hashtable hashtable) {
        Object object;
        LogXMLParser logXMLParser = new LogXMLParser();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = (String)hashtable.get(object);
            logXMLParser.setTagValue((String)object, string);
        }
        object = logXMLParser.getXML().getBytes();
        return logXMLParser.getXML().getBytes();
    }

    public void registerToServer(SASServer sASServer, AdapterHelper[] adapterHelperArray) {
        this.serverObj = sASServer;
        this.serverObj.addObserver(this);
        this.m_adpList = this.serverObj.getAdapterArrayList();
        this.adpHelperArray = adapterHelperArray;
    }

    public void registerToServer(SASServer sASServer, CCOHVirtualAdapterHelper cCOHVirtualAdapterHelper) {
        this.serverObj = sASServer;
        this.m_ccohVirtualAdapHelper = cCOHVirtualAdapterHelper;
    }

    public Hashtable createTagArray(String string, String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(Integer.toString(gregorianCalendar.get(1)));
        stringBuffer.append("-" + decimalFormat.format(gregorianCalendar.get(2) + 1));
        stringBuffer.append("-" + decimalFormat.format(gregorianCalendar.get(5)));
        stringBuffer.append("," + decimalFormat.format(gregorianCalendar.get(11)));
        stringBuffer.append(":" + decimalFormat.format(gregorianCalendar.get(12)));
        stringBuffer.append(":" + decimalFormat.format(gregorianCalendar.get(13)));
        hashtable.put("clientTime", new String(stringBuffer));
        if (string.equals(CONTEXT_LOGON)) {
            hashtable.put("id", "10000");
            hashtable.put("class", "0");
        } else if (string.equals(CONTEXT_LOGOUT)) {
            hashtable.put("id", "10001");
            hashtable.put("class", "0");
        } else if (string.equals(CONTEXT_DENY)) {
            hashtable.put("id", "10002");
            hashtable.put("class", "1");
        } else if (string.equals(CONTEXT_CLEAR)) {
            hashtable.put("id", "10003");
            hashtable.put("class", "0");
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            hashtable.put("param" + ++n, stringArray[i]);
        }
        hashtable.put("param" + ++n, new String(stringBuffer));
        hashtable.put("paramCount", Integer.toString(n));
        return hashtable;
    }

    public void getInitialLog(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                LogXMLParser logXMLParser = (LogXMLParser)arrayList.get(i);
                Object[] objectArray = new Object[5];
                objectArray[4] = new Integer(n);
                --n;
                String string = new String();
                int n2 = 0;
                if (logXMLParser.getEventID() >= 10000 && logXMLParser.getEventID() <= 10003) {
                    n2 = logXMLParser.getMessageClass();
                } else {
                    try {
                        n2 = m_eventSeverity.get(new Integer(logXMLParser.getEventID()));
                    }
                    catch (Exception exception) {
                        n2 = 0;
                    }
                }
                objectArray[0] = logXMLParser.getEventID();
                if (n2 == 0) {
                    string = Resource.getString("INFO", "Information");
                } else if (n2 == 1) {
                    string = Resource.getString("WARN", "Warning");
                } else if (n2 == 2) {
                    string = Resource.getString("CRTL", "Critical");
                } else if (n2 == 3) {
                    string = Resource.getString("FATAL", "Fatal");
                } else if (n2 == 4) {
                    string = Resource.getString("DEAD", "Dead");
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (string != null) {
                    arrayList2.add(0, string);
                } else {
                    arrayList2.add(0, "");
                }
                if (logXMLParser.getMessageClass() != -1) {
                    arrayList2.add(1, n2 + "");
                } else {
                    arrayList2.add(1, "2");
                }
                objectArray[1] = arrayList2;
                objectArray[2] = logXMLParser.getTagValue("yyyy") == null && logXMLParser.getTagValue("month") == null && logXMLParser.getTagValue("dd") == null && logXMLParser.getTagValue("hh") == null && logXMLParser.getTagValue("mm") == null ? (logXMLParser.getTagValue("ss") != null ? logXMLParser.getTagValue("ss") + "  " + Resource.getString("TEXT_SEC_FRM_REBOOT", " seconds from reboot") : Resource.getString("TEXT_NOT_AVAILABLE", "Not available")) : logXMLParser.getTagValue("yyyy") + "-" + logXMLParser.getTagValue("month") + "-" + logXMLParser.getTagValue("dd") + ", " + logXMLParser.getTagValue("hh") + ":" + logXMLParser.getTagValue("mm") + ":" + logXMLParser.getTagValue("ss");
                objectArray[3] = logXMLParser.getTagValue("localizedMessage");
                this.append(objectArray);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void getCIMOMInitialLog(String string, int n) {
    }

    public String getEventinLocFormat(String string) {
        LogXMLParser logXMLParser = new LogXMLParser(string);
        byte[] byArray = Locale.getDefault().getLanguage().getBytes();
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = Locale.getDefault().getCountry().getBytes();
        System.arraycopy(byArray3, 0, byArray2, 0, Math.min(byArray2.length, byArray3.length));
        String string2 = new String(byArray);
        String string3 = new String(byArray2);
        Localization localization = new Localization(string2, string3);
        logXMLParser.setTagValue("languageCode", localization.getLanguage());
        String string4 = localization.getLocalizedStringWithoutUnicodeConversion(logXMLParser.getTagValue("id").trim(), logXMLParser.getParams());
        logXMLParser.setTagValue("localizedMessage", string4);
        System.out.println("LOCALIZED_MESSAGE" + string4);
        return string4;
    }

    public JLogger(String[] stringArray) {
        this.setModel(this.sorter);
        this.addLogMouseListener(this);
        this.sorter.addMouseListenerToHeaderInTable(this);
        for (int i = 0; i < stringArray.length; ++i) {
            this.model.addColumn(stringArray[i]);
        }
        this.getColumnModel().getColumn(0).setPreferredWidth(MainFrame.SCREEN_SIZE.width * 60 / 1024);
        this.getColumnModel().getColumn(0).setMaxWidth(MainFrame.SCREEN_SIZE.width * 60 / 1024);
        this.getColumnModel().getColumn(1).setPreferredWidth(MainFrame.SCREEN_SIZE.width * 100 / 1024);
        this.getColumnModel().getColumn(1).setMaxWidth(MainFrame.SCREEN_SIZE.width * 150 / 1024);
        this.getColumnModel().getColumn(2).setPreferredWidth(MainFrame.SCREEN_SIZE.width * 200 / 1024);
        this.getColumnModel().getColumn(2).setMaxWidth(MainFrame.SCREEN_SIZE.width * 250 / 1024);
        this.getColumnModel().getColumn(3).setPreferredWidth(MainFrame.SCREEN_SIZE.width * 1000 / 1024);
        this.getColumnModel().getColumn(4).setMinWidth(0);
        this.getColumnModel().getColumn(4).setMaxWidth(0);
        this.getColumnModel().getColumn(4).setWidth(0);
        this.getColumnModel().getColumn(4).setPreferredWidth(0);
        if (!VivaldiStartupDialog.isWindows) {
            this.setBackground(Color.white);
        }
        this.setAutoscrolls(true);
        this.setEnabled(true);
        this.setRowSelectionAllowed(true);
        if (!VivaldiStartupDialog.isWindows) {
            this.setDefaultRenderer(Object.class, this.colRen);
        }
    }

    public void addLogMouseListener(Component component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    JMenu jMenu = VivaldiStartupDialog.mainScreen.getLogMenu();
                    jMenu.getPopupMenu().show(JLogger.this.getLogger(), mouseEvent.getX(), mouseEvent.getY());
                    jMenu.getPopupMenu().setInvoker(jMenu);
                } else if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() >= 2 && mouseEvent.getSource() instanceof JLogger) {
                    JLogger jLogger = (JLogger)mouseEvent.getSource();
                    int n = jLogger.getSelectedRow();
                    Object[] objectArray = new Object[jLogger.getColumnCount()];
                    for (int i = 0; i < JLogger.this.sorter.getColumnCount(); ++i) {
                        objectArray[i] = JLogger.this.sorter.getValueAt(n, i);
                    }
                    new LogDetailsDialog(objectArray);
                }
            }
        });
    }

    public void changeMode(int n) {
        if (mode == n) {
            return;
        }
        if (n == 1) {
            Vector vector = (Vector)this.model.getDataVector().clone();
            this.logHash.put("serverLog", vector);
            this.clear();
            mode = n;
        } else if (n == 0) {
            Vector vector = (Vector)this.logHash.get("serverLog");
            Vector<String> vector2 = new Vector<String>();
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                vector2.add(this.model.getColumnName(i));
            }
            mode = n;
            this.model.setDataVector(vector, vector2);
            this.sorter.tableChanged(new TableModelEvent(this.model));
            this.getColumnModel().getColumn(0).setPreferredWidth(MainFrame.SCREEN_SIZE.width * 60 / 1024);
            this.getColumnModel().getColumn(0).setMaxWidth(MainFrame.SCREEN_SIZE.width * 60 / 1024);
            this.getColumnModel().getColumn(1).setPreferredWidth(MainFrame.SCREEN_SIZE.width * 100 / 1024);
            this.getColumnModel().getColumn(1).setMaxWidth(MainFrame.SCREEN_SIZE.width * 150 / 1024);
            this.getColumnModel().getColumn(2).setPreferredWidth(MainFrame.SCREEN_SIZE.width * 200 / 1024);
            this.getColumnModel().getColumn(2).setMaxWidth(MainFrame.SCREEN_SIZE.width * 250 / 1024);
            this.getColumnModel().getColumn(3).setPreferredWidth(MainFrame.SCREEN_SIZE.width * 1000 / 1024);
            this.getColumnModel().getColumn(4).setMinWidth(0);
            this.getColumnModel().getColumn(4).setMaxWidth(0);
            this.getColumnModel().getColumn(4).setWidth(0);
            this.getColumnModel().getColumn(4).setPreferredWidth(0);
        }
    }

    public int getNumRecords() {
        Vector vector;
        if (mode == 1 && this.logHash.containsKey("serverLog") && (vector = (Vector)this.logHash.get("serverLog")) != null && vector.size() > 0) {
            return vector.size();
        }
        return this.model.getRowCount();
    }

    public JLogger() {
        this(new String[]{Resource.getString("LOGGERHEADER_SEQUENCENO_TEXT", "ID"), Resource.getString("LOGGERHEADER_ERRORLEVEL_TEXT", "Error Level"), Resource.getString("LOGGERHEADER_DATETIME_TEXT", "Date / Time"), Resource.getString("LOGGERHEADER_DESCRIPTION_TEXT", "Description"), Resource.getString("SERIAL_NO", "Serial")});
    }

    public void append(Object[] objectArray) {
        this.model.addRow(objectArray);
    }

    public void prepend(Object[] objectArray) {
        this.model.insertRow(0, objectArray);
    }

    public Object[] decodeFieldsFromXML(LogXMLParser logXMLParser) {
        Object[] objectArray = new Object[5];
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = new String();
        int n = logXMLParser.getMessageClass();
        if (n == 0) {
            string = Resource.getString("INFO", "Information");
        } else if (n == 1) {
            string = Resource.getString("WARN", "Warning");
        } else if (n == 2) {
            string = Resource.getString("CRTL", "Critical");
        } else if (n == 3) {
            string = Resource.getString("FATAL", "Fatal");
        } else if (n == 4) {
            string = Resource.getString("DEAD", "Dead");
        }
        if (string != null) {
            arrayList.add(0, string);
        } else {
            arrayList.add(0, "");
        }
        if (logXMLParser.getMessageClass() != -1) {
            arrayList.add(1, logXMLParser.getMessageClass() + "");
        } else {
            arrayList.add(1, "2");
        }
        objectArray[0] = logXMLParser.getEventID();
        objectArray[1] = arrayList;
        objectArray[2] = logXMLParser.getTagValue("yyyy") == null && logXMLParser.getTagValue("month") == null && logXMLParser.getTagValue("dd") == null && logXMLParser.getTagValue("hh") == null && logXMLParser.getTagValue("mm") == null ? (logXMLParser.getTagValue("ss") != null ? logXMLParser.getTagValue("ss") + Resource.getString("TEXT_SEC_FRM_REBOOT", " seconds from reboot") : Resource.getString("TEXT_NOT_AVAILABLE", "Not available")) : logXMLParser.getTagValue("yyyy") + "-" + logXMLParser.getTagValue("month") + "-" + logXMLParser.getTagValue("dd") + ", " + logXMLParser.getTagValue("hh") + ":" + logXMLParser.getTagValue("mm") + ":" + logXMLParser.getTagValue("ss");
        objectArray[3] = logXMLParser.getTagValue("localizedMessage");
        objectArray[4] = (int)new Integer(this.getNumRecords() + 1);
        return objectArray;
    }

    public void clear() {
        int n = this.model.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.model.removeRow(0);
        }
    }

    private JLogger getLogger() {
        return this;
    }

    @Override
    public void update(Observable observable, Object object) {
        System.out.println("Inside update method");
        NotifyObject notifyObject = (NotifyObject)object;
        switch (notifyObject.getNotifyCode()) {
            case 0x101001: {
                System.out.println("Inside JLogger NOTIFYCODE_NEWLOG method");
                break;
            }
            case 0x101002: {
                System.out.println("Inside JLogger NOTIFYCODE_FRAMEWORK_NEGOTIATION_ERROR method");
                break;
            }
            case 4099: {
                System.out.println("Inside JLogger NOTIFYCODE_FRAMEWORK_POLL_REQUESTED method");
                return;
            }
            case 4101: {
                System.out.println("Inside JLogger NOTIFYCODE_NEW_VIVALDI_CFG method");
                ArrayList arrayList = (ArrayList)notifyObject.getNotifyObject();
                this.updateVivaldiLogConfig(arrayList);
                return;
            }
            default: {
                System.out.println("notify code = " + notifyObject.getNotifyCode());
                System.out.println("Inside JLogger default method");
                return;
            }
        }
        NetworkPacket networkPacket = null;
        try {
            if (notifyObject.getNotifyObject() instanceof NetworkPacket) {
                System.out.println("Inside npacket Instance");
                networkPacket = (NetworkPacket)notifyObject.getNotifyObject();
            } else if (notifyObject.getNotifyObject() instanceof LogCallBackPacket) {
                System.out.println("Inside LogCallBackPacket Instance");
                this.prepend(this.decodeFieldsFromXML(new LogXMLParser(((LogCallBackPacket)notifyObject.getNotifyObject()).getLogRecord())));
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in class cast NotifyObject to NetworkPacket");
            return;
        }
        if (networkPacket != null) {
            this.dataBuffer = networkPacket.getDatabuffer();
            this.eventDetail = new SL_EVENT_DETAIL_T(this.dataBuffer, 0);
            this.updateEvent();
        }
    }

    public Object[] decodeEventDetail(MR_EVT_DETAIL mR_EVT_DETAIL) {
        long l = mR_EVT_DETAIL.gettimeStamp();
        String string = new String(mR_EVT_DETAIL.getdescription()).trim();
        Object[] objectArray = new Object[5];
        objectArray[0] = new Integer(mR_EVT_DETAIL.getcode());
        objectArray[4] = new Integer(this.getNumRecords() + 1);
        String string2 = null;
        byte by = mR_EVT_DETAIL.getcl().geteventClass();
        int n = -1;
        if (by == 2) {
            string2 = Resource.getString("INFO", "Information");
            n = 0;
        } else if (by == 3) {
            string2 = Resource.getString("WARN", "Warning");
            n = 1;
        } else if (by == 6) {
            string2 = Resource.getString("CRTL", "Critical");
            n = 3;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 != null) {
            arrayList.add(0, string2);
        } else {
            arrayList.add(0, "Information");
        }
        if (n != -1) {
            arrayList.add(1, n + "");
        } else {
            arrayList.add(1, "0");
        }
        objectArray[1] = arrayList;
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1, 0, 0, 0);
        long l2 = calendar.getTimeInMillis() / 1000L;
        calendar.setTimeInMillis((l2 + l) * 1000L);
        DecimalFormat decimalFormat = new DecimalFormat("00");
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(calendar.get(1));
        stringBuffer.append("-" + decimalFormat.format(calendar.get(2) + 1));
        stringBuffer.append("-" + decimalFormat.format(calendar.get(5)));
        stringBuffer.append("," + decimalFormat.format(calendar.get(11)));
        stringBuffer.append(":" + decimalFormat.format(calendar.get(12)));
        stringBuffer.append(":" + decimalFormat.format(calendar.get(13)));
        objectArray[2] = stringBuffer.toString();
        objectArray[3] = string;
        return objectArray;
    }

    public boolean readCIMLogFromFile(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            bufferedReader.readLine();
            bufferedReader.readLine();
            Object[] objectArray = new String[4];
            char[] cArray = new char[LOG_ID.length()];
            char[] cArray2 = new char[LOG_ERROR_LEVEL.length()];
            char[] cArray3 = new char[LOG_DATE_TIME.length()];
            char[] cArray4 = new char[LOG_LOCALIZED_MESSAGE.length()];
            while (bufferedReader.read(cArray) != -1) {
                if (!LOG_ID.equals(new String(cArray))) {
                    return false;
                }
                objectArray[0] = Integer.parseInt(bufferedReader.readLine().trim());
                bufferedReader.read(cArray2);
                if (!LOG_ERROR_LEVEL.equals(new String(cArray2))) {
                    return false;
                }
                objectArray[1] = bufferedReader.readLine();
                bufferedReader.readLine();
                bufferedReader.read(cArray3);
                if (!LOG_DATE_TIME.equals(new String(cArray3))) {
                    return false;
                }
                objectArray[2] = bufferedReader.readLine();
                bufferedReader.read(cArray4);
                if (!LOG_LOCALIZED_MESSAGE.equals(new String(cArray4))) {
                    return false;
                }
                objectArray[3] = bufferedReader.readLine();
                this.prepend(objectArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void autoSaveCIMLogToFile(MR_EVT_DETAIL mR_EVT_DETAIL) {
        try {
            String string;
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter("cimlog.txt", true)));
            String[] stringArray = new String[5];
            stringArray[0] = "" + this.logCount;
            printWriter.println((Object)stringArray[0]);
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("[Information, ");
            stringBuffer.append(0);
            stringBuffer.append("]");
            stringArray[1] = stringBuffer.toString();
            printWriter.println((Object)stringArray[1]);
            int n = mR_EVT_DETAIL.getseqNum();
            stringArray[2] = "" + n;
            printWriter.println((Object)stringArray[2]);
            long l = mR_EVT_DETAIL.gettimeStamp();
            Calendar calendar = Calendar.getInstance();
            calendar.set(2000, 0, 1, 0, 0, 0);
            long l2 = calendar.getTimeInMillis() / 1000L;
            calendar.setTimeInMillis((l2 + l) * 1000L);
            DecimalFormat decimalFormat = new DecimalFormat("00");
            StringBuffer stringBuffer2 = new StringBuffer("");
            stringBuffer2.append(calendar.get(1));
            stringBuffer2.append("-" + decimalFormat.format(calendar.get(2) + 1));
            stringBuffer2.append("-" + decimalFormat.format(calendar.get(5)));
            stringBuffer2.append("," + decimalFormat.format(calendar.get(11)));
            stringBuffer2.append(":" + decimalFormat.format(calendar.get(12)));
            stringBuffer2.append(":" + decimalFormat.format(calendar.get(13)));
            stringArray[3] = stringBuffer2.toString();
            printWriter.println((Object)stringArray[3]);
            stringArray[4] = string = new String(mR_EVT_DETAIL.getdescription()).trim();
            printWriter.println((Object)stringArray[4]);
            printWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveCIMLogToFile(File file, String string) {
        String string2 = "." + File.separator + "Framework" + File.separator + string + "_vuosd.dhdk";
        File file2 = new File(string2);
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            printWriter.println(VivaldiStartupDialog.PRODUCT_INFO + " " + VivaldiStartupDialog.INSTALLER_VERSION + Resource.getString("MSG_TXTLOGFILE_HEADER", " Event Log - Generated on ") + new Date());
            int n = VivaldiStartupDialog.PRODUCT_INFO.length() + 1 + VivaldiStartupDialog.INSTALLER_VERSION.length() + Resource.getString("MSG_TXTLOGFILE_HEADER", " Event Log - Generated on ").length() + new Date().toString().length();
            StringBuffer stringBuffer = new StringBuffer("-");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("-");
            }
            printWriter.println(stringBuffer);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            boolean bl = false;
            String string3 = new String();
            while ((string3 = bufferedReader.readLine()) != null) {
                LogXMLParser logXMLParser = new LogXMLParser(string3);
                printWriter.print(LOG_ID);
                printWriter.println(logXMLParser.getEventID());
                printWriter.print(LOG_ERROR_LEVEL);
                printWriter.println(logXMLParser.getMessageClass());
                printWriter.print(LOG_SEQUENCE_NUMBER);
                printWriter.println(logXMLParser.getSeqNumber());
                printWriter.print(LOG_DATE_TIME);
                printWriter.println(logXMLParser.getTimeStamp());
                printWriter.print(LOG_LOCALIZED_MESSAGE);
                printWriter.println(logXMLParser.getTagValue("localizedMessage"));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearCIMLog(String string) {
        String string2 = "." + File.separator + "Framework" + File.separator + string + "_vuosd.dhdk";
        File file = new File(string2);
        try {
            this.logCount = 0;
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            printWriter.print("");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getEventinStringFormat() {
        byte[] byArray;
        String string = "";
        Object var2_2 = null;
        int n = this.eventDetail.getctrlId();
        ArrayList arrayList = this.m_adpList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SASAdapter sASAdapter = (SASAdapter)arrayList.get(i);
            if (sASAdapter.getCtrlID() != n) continue;
            this.localSASAdapter = sASAdapter;
            n = sASAdapter.getDisplayID();
            break;
        }
        if ((byArray = this.eventDetail.getByteArray()) != null) {
            System.out.println("slEventDetail is alive");
        } else {
            System.out.println("slEventDetail is not alive");
        }
        char c = this.eventDetail.getevtDetail().getargType();
        int n2 = this.eventDetail.getevtDetail().getcode();
        if (n2 == 49152 || n2 == 49153 || n2 == 49154 || n2 == 49155 || n2 == 49156 || n2 == 49157 || n2 == 49158) {
            MR_EVT_CCOH_DETAIL mR_EVT_CCOH_DETAIL = new MR_EVT_CCOH_DETAIL(this.eventDetail.getByteArray(), 12);
            Object[] objectArray = new Object[]{mR_EVT_CCOH_DETAIL.getDevIdText()};
            String string2 = Integer.toString(n2);
            string = MessageFormat.format(Resource.getEvtString(string2), objectArray);
        } else if (n2 == 65531 || n2 == 65532 || n2 == 65533 || n2 == 65535 || n2 == 65534 || n2 == 65530 || n2 == 65529 || n2 == 65528 || n2 == 65527 || n2 == 65526 || n2 == 65525 || n2 == 65523 || n2 == 65522) {
            int n3 = 0;
            n3 += 2;
            n3 += 2;
            n3 += 4;
            MR_EVT_WH_DETAIL mR_EVT_WH_DETAIL = new MR_EVT_WH_DETAIL(this.eventDetail.getByteArray(), n3 += 4);
            switch (c) {
                case '\u0000': {
                    Object[] objectArray = new Object[]{n};
                    String string3 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string3), objectArray);
                    break;
                }
                case '\u0001': {
                    Object[] objectArray = new Object[]{n, Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getSlotDriveLife_args_MR_EVT_WH_DETAIL1().getSlotId()))), Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getSlotDriveLife_args_MR_EVT_WH_DETAIL1().getPd().getdeviceId()))), Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getSlotDriveLife_args_MR_EVT_WH_DETAIL1().getDriveLife()), Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getSlotDriveLife_args_MR_EVT_WH_DETAIL1().getWarningLevel()))), Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getSlotDriveLife_args_MR_EVT_WH_DETAIL1().getErrorLevel())))};
                    String string4 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string4), objectArray);
                    break;
                }
                case '\u0002': {
                    Object[] objectArray = new Object[]{n, Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getSlotThrottle_args_MR_EVT_WH_DETAIL1().getSlotId()))), Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getSlotThrottle_args_MR_EVT_WH_DETAIL1().getPd().getdeviceId()))), Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getSlotThrottle_args_MR_EVT_WH_DETAIL1().getThrottle())))};
                    String string5 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string5), objectArray);
                    break;
                }
                case '\u0003': {
                    Object[] objectArray = new Object[]{n, Integer.toHexString(Integer.parseInt(Byte.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getTempThreshold_args_MR_EVT_WH_DETAIL1().getSensorNum()))), Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getTempThreshold_args_MR_EVT_WH_DETAIL1().getThresholdsExceeded()))), Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getTempThreshold_args_MR_EVT_WH_DETAIL1().getTemperature())))};
                    String string6 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string6), objectArray);
                    break;
                }
                case '\b': {
                    Object[] objectArray = new Object[]{n, Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getCtrl_Pfk_args_MR_EVT_WH_DETAIL().getSlotId())))};
                    String string7 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string7), objectArray);
                }
                case '\u0004': {
                    Object[] objectArray = new Object[]{n, Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getThrottle_args_MR_EVT_WH_DETAIL1().getPercentThrottle()))), Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getThrottle_args_MR_EVT_WH_DETAIL1().getPciSlotAvailPower())))};
                    String string7 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string7), objectArray);
                    break;
                }
                case '\u0005': {
                    Object[] objectArray = new Object[]{n, Integer.toHexString(Integer.parseInt(Byte.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getTemperature_args_MR_EVT_WH_DETAIL1().getFlags()))), Integer.toHexString(Integer.parseInt(Byte.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getTemperature_args_MR_EVT_WH_DETAIL1().getSensorOrSlot()))), Integer.toHexString(Integer.parseInt(Byte.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getTemperature_args_MR_EVT_WH_DETAIL1().getCurrTemp()))), Integer.toHexString(Integer.parseInt(Byte.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getTemperature_args_MR_EVT_WH_DETAIL1().getThresholdTemp()))), Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getTemperature_args_MR_EVT_WH_DETAIL1().getPd().getdeviceId())))};
                    String string8 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string8), objectArray);
                    break;
                }
                case '\u0007': {
                    Object[] objectArray = new Object[]{n, Integer.toHexString(Integer.parseInt(Short.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getPdArg_args_MR_EVT_WH_DETAIL1().getPd().getdeviceId()))), Integer.toHexString(Integer.parseInt(Byte.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getPdArg_args_MR_EVT_WH_DETAIL1().getEnclIndex()))), Integer.toHexString(Integer.parseInt(Byte.toString(mR_EVT_WH_DETAIL.getargs_MR_EVT_WH_DETAIL1().getPdArg_args_MR_EVT_WH_DETAIL1().getSlotNumber())))};
                    String string9 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string9), objectArray);
                    break;
                }
                default: {
                    System.out.println("Unhandled argType received...MR_EVT_WH_ARGS Id id ::" + c);
                    break;
                }
            }
        } else {
            switch (c) {
                case '\u0000': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_NONE:");
                    Object[] objectArray = new Object[]{n};
                    String string10 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string10), objectArray);
                    break;
                }
                case '\n': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD:");
                    Object[] objectArray = new Object[2];
                    objectArray[0] = n;
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpd();
                    String string11 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string11;
                    String string12 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string12), objectArray);
                    break;
                }
                case '\u0012': {
                    int n4;
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_STR:");
                    Object[] objectArray = new Object[2];
                    objectArray[0] = n;
                    byte[] byArray2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getstr();
                    String string13 = new String(byArray2);
                    System.out.println("EventXMLFormation.getEventXMLFormat()Str = " + string13);
                    if (n2 == 1 && (n4 = string13.indexOf("version")) != -1) {
                        string13 = string13.substring(0, n4);
                    }
                    objectArray[1] = string13.trim();
                    String string14 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string14), objectArray);
                    break;
                }
                case '\u0016': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_SPARE:");
                    Object[] objectArray = new Object[2];
                    objectArray[0] = n;
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdSpare_args_MR_EVT_DETAIL1().getpd();
                    String string15 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string15;
                    String string16 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string16), objectArray);
                    break;
                }
                case '$': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_GENERIC:");
                    Object[] objectArray = new Object[2];
                    objectArray[0] = Integer.toString(n);
                    long l = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getgeneric();
                    int n5 = (int)l;
                    objectArray[1] = n5;
                    String string17 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string17), objectArray);
                    break;
                }
                case '#': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_POWER_STATE:");
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Integer.toString(n);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdState_args_MR_EVT_DETAIL1().getpd();
                    String string18 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string18;
                    int n6 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdState_args_MR_EVT_DETAIL1().getprevState();
                    int n7 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdState_args_MR_EVT_DETAIL1().getnewState();
                    String string19 = this.getPdPowerState(n6);
                    String string20 = this.getPdPowerState(n7);
                    objectArray[2] = string19;
                    objectArray[3] = string20;
                    String string21 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string21), objectArray);
                    break;
                }
                case ' ': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_PD:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdPair_args_MR_EVT_DETAIL1().getdestPd();
                    String string22 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string22;
                    MR_EVT_ARG_PD mR_EVT_ARG_PD2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdPair_args_MR_EVT_DETAIL1().getsrcPd();
                    String string23 = this.getPdInfo(n, mR_EVT_ARG_PD2);
                    objectArray[2] = string23;
                    String string24 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string24), objectArray);
                    break;
                }
                case '\u0011': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_RATE:");
                    Object[] objectArray = new Object[]{Integer.toString(n), this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getrate()};
                    String string25 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string25), objectArray);
                    break;
                }
                case '!': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_FRU:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdFRU_args_MR_EVT_DETAIL().getpd();
                    String string26 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string26;
                    System.out.println("Afterargs[0] :" + objectArray[1]);
                    String string27 = Integer.toString(n2);
                    byte[] byArray3 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdFRU_args_MR_EVT_DETAIL().getFRU();
                    String string28 = new String(byArray3);
                    System.out.println(string28);
                    String string29 = string28.trim();
                    objectArray[2] = string29;
                    string = MessageFormat.format(Resource.getEvtString(string27), objectArray);
                    break;
                }
                case '\u001c': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_MISSING:");
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Integer.toString(n);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdMissing_args_MR_EVT_DETAIL1().getpd();
                    String string30 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string30;
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdMissing_args_MR_EVT_DETAIL1().getar();
                    objectArray[3] = objectArray[2] = Integer.valueOf(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdMissing_args_MR_EVT_DETAIL1().getrow());
                    String string31 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string31), objectArray);
                    break;
                }
                case '\u0010': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PCI:");
                    Object[] objectArray = new Object[]{Integer.toString(n), NetworkToJavaConverter.shortToHexString(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpci_args_MR_EVT_DETAIL1().getdeviceId()), NetworkToJavaConverter.shortToHexString(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpci_args_MR_EVT_DETAIL1().getvendorId()), NetworkToJavaConverter.shortToHexString(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpci_args_MR_EVT_DETAIL1().getsubDeviceId()), NetworkToJavaConverter.shortToHexString(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpci_args_MR_EVT_DETAIL1().getsubVendorId())};
                    System.out.println("Afterargs[0] :" + objectArray[1]);
                    String string32 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string32), objectArray);
                    break;
                }
                case '\u0004': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_LBA:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string33 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldLba_args_MR_EVT_DETAIL1().getld().gettargetId();
                    long l = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldLba_args_MR_EVT_DETAIL1().getlba();
                    String string34 = "0x" + Long.toHexString(l);
                    objectArray[2] = string34;
                    string = MessageFormat.format(Resource.getEvtString(string33), objectArray);
                    break;
                }
                case '\f': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_LBA:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string35 = Integer.toString(n2);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdLba_args_MR_EVT_DETAIL1().getpd();
                    String string36 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string36;
                    long l = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdLba_args_MR_EVT_DETAIL1().getlba();
                    String string37 = "0x" + Long.toHexString(l);
                    objectArray[2] = string37;
                    string = MessageFormat.format(Resource.getEvtString(string35), objectArray);
                    break;
                }
                case '\u0005': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_OWNER:");
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Integer.toString(n);
                    String string38 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldOwner_args_MR_EVT_DETAIL1().getld().gettargetId();
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldOwner_args_MR_EVT_DETAIL1().getprevOwner();
                    objectArray[3] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldOwner_args_MR_EVT_DETAIL1().getnewOwner();
                    string = MessageFormat.format(Resource.getEvtString(string38), objectArray);
                    break;
                }
                case '\r': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_LBA_LD:");
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Integer.toString(n);
                    String string39 = Integer.toString(n2);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdLbaLd_args_MR_EVT_DETAIL1().getpd();
                    String string40 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string40;
                    long l = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdLbaLd_args_MR_EVT_DETAIL1().getlba();
                    String string41 = "0x" + Long.toHexString(l);
                    objectArray[2] = string41;
                    objectArray[3] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdLbaLd_args_MR_EVT_DETAIL1().getld().gettargetId();
                    string = MessageFormat.format(Resource.getEvtString(string39), objectArray);
                    break;
                }
                case '\u0014': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_ECC:");
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Integer.toString(n);
                    String string42 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getecc_args_MR_EVT_DETAIL1().getecar();
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getecc_args_MR_EVT_DETAIL1().getelog();
                    byte[] byArray4 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getecc_args_MR_EVT_DETAIL1().getstr();
                    String string43 = new String(byArray4);
                    System.out.println(string43);
                    String string44 = string43.trim();
                    objectArray[3] = string44;
                    string = MessageFormat.format(Resource.getEvtString(string42), objectArray);
                    break;
                }
                case '\u0013': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_TIME:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string45 = Integer.toString(n2);
                    objectArray[1] = this.gettimeStamp(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().gettime_args_MR_EVT_DETAIL1().getrtc());
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().gettime_args_MR_EVT_DETAIL1().getelapsedSeconds();
                    string = MessageFormat.format(Resource.getEvtString(string45), objectArray);
                    break;
                }
                case '\u0017': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_INDEX:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string46 = Integer.toString(n2);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getPdIndex_args_MR_EVT_DETAIL1().getPd();
                    String string47 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string47;
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getPdIndex_args_MR_EVT_DETAIL1().getIndex();
                    string = MessageFormat.format(Resource.getEvtString(string46), objectArray);
                    break;
                }
                case '\u0018': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_DIAG_PASS:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string48 = Integer.toString(n2);
                    byte[] byArray5 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getdiagPass_args_MR_EVT_DETAIL().getstr();
                    String string49 = new String(byArray5).trim();
                    objectArray[1] = string49;
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getdiagPass_args_MR_EVT_DETAIL().getpassCount();
                    string = MessageFormat.format(Resource.getEvtString(string48), objectArray);
                    break;
                }
                case '\u001a': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_LBA_LBA:");
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Integer.toString(n);
                    String string50 = Integer.toString(n2);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdLbaLba_args_MR_EVT_DETAIL1().getpd();
                    String string51 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string51;
                    String string52 = "0x" + Long.toHexString(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdLbaLba_args_MR_EVT_DETAIL1().getpdlba1());
                    objectArray[2] = string52;
                    String string53 = "0x" + Long.toHexString(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdLbaLba_args_MR_EVT_DETAIL1().getpdlba2());
                    objectArray[3] = string53;
                    string = MessageFormat.format(Resource.getEvtString(string50), objectArray);
                    break;
                }
                case '\u001b': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PORT_PHY");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string54 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getportPhy_args_MR_EVT_DETAIL1().getport();
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getportPhy_args_MR_EVT_DETAIL1().getphy();
                    string = MessageFormat.format(Resource.getEvtString(string54), objectArray);
                    break;
                }
                case '\u0015': {
                    String string55;
                    int n8;
                    String string56;
                    int n9;
                    String string57;
                    int n10;
                    String string58;
                    int n11;
                    String string59;
                    int n12;
                    String string60;
                    int n13;
                    String string61;
                    int n14;
                    String string62;
                    int n15;
                    String string63;
                    int n16;
                    String string64;
                    int n17;
                    String string65;
                    int n18;
                    String string66;
                    String string67;
                    int n19;
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_PROP:");
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Integer.toString(n);
                    String string68 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getld().gettargetId();
                    System.out.println("EVENT ID =" + n2);
                    objectArray[2] = "";
                    objectArray[3] = "";
                    String string69 = this.oldLDName();
                    String string70 = this.newLDName();
                    int n20 = string69.compareTo(string70);
                    if (n20 != 0) {
                        objectArray[2] = objectArray[2] + string69;
                        objectArray[3] = objectArray[3] + string70;
                    }
                    if ((n19 = (string67 = this.getcheckDefaultReadCachePolicy()).indexOf("@")) != -1) {
                        string66 = string67.substring(0, n19);
                        String string71 = string67.substring(n19 + 1, string67.length());
                        objectArray[2] = objectArray[2] + string66 + ";";
                        objectArray[3] = objectArray[3] + string71 + ";";
                    }
                    if ((n18 = (string66 = this.getcheckDefaultWriteCachePolicy()).indexOf("@")) != -1) {
                        string65 = string66.substring(0, n18);
                        String string72 = string66.substring(n18 + 1, string66.length());
                        objectArray[2] = objectArray[2] + string65 + ";";
                        objectArray[3] = objectArray[3] + string72 + ";";
                    }
                    if ((n17 = (string65 = this.getcheckDefaultIoPolicy()).indexOf("@")) != -1) {
                        string64 = string65.substring(0, n17);
                        String string73 = string65.substring(n17 + 1, string65.length());
                        objectArray[2] = objectArray[2] + string64 + ";";
                        objectArray[3] = objectArray[3] + string73 + ";";
                    }
                    if ((n16 = (string64 = this.getcheckAccessPolicy()).indexOf("@")) != -1) {
                        string63 = string64.substring(0, n16);
                        String string74 = string64.substring(n16 + 1, string64.length());
                        objectArray[2] = objectArray[2] + string63 + ";";
                        objectArray[3] = objectArray[3] + string74 + ";";
                    }
                    if ((n15 = (string63 = this.getcheckDiskCachePolicy()).indexOf("@")) != -1) {
                        string62 = string63.substring(0, n15);
                        String string75 = string63.substring(n15 + 1, string63.length());
                        objectArray[2] = objectArray[2] + string62 + ";";
                        objectArray[3] = objectArray[3] + string75 + ";";
                    }
                    if ((n14 = (string62 = this.getVdAccessState()).indexOf("@")) != -1) {
                        string61 = string62.substring(0, n14);
                        String string76 = string62.substring(n14 + 1, string62.length());
                        System.out.println("acccesspolicy:" + string62);
                        objectArray[2] = objectArray[2] + string61 + ";";
                        objectArray[3] = objectArray[3] + string76 + ";";
                    }
                    if ((n13 = (string61 = this.getcheckCurrentReadCachePolicy()).indexOf("@")) != -1) {
                        string60 = string61.substring(0, n13);
                        String string77 = string61.substring(n13 + 1, string61.length());
                        objectArray[2] = objectArray[2] + string60 + ";";
                        objectArray[3] = objectArray[3] + string77 + ";";
                    }
                    if ((n12 = (string60 = this.getcheckCurrentWriteCachePolicy()).indexOf("@")) != -1) {
                        string59 = string60.substring(0, n12);
                        String string78 = string60.substring(n12 + 1, string60.length());
                        objectArray[2] = objectArray[2] + string59 + ";";
                        objectArray[3] = objectArray[3] + string78 + ";";
                    }
                    if ((n11 = (string59 = this.getcheckCurrentIoPolicy()).indexOf("@")) != -1) {
                        string58 = string59.substring(0, n11);
                        String string79 = string59.substring(n11 + 1, string59.length());
                        objectArray[2] = objectArray[2] + string58 + ";";
                        objectArray[3] = objectArray[3] + string79 + ";";
                    }
                    if ((n10 = (string58 = this.getcheckBgi()).indexOf("@")) != -1) {
                        string57 = string58.substring(0, n10);
                        String string80 = string58.substring(n10 + 1, string58.length());
                        objectArray[2] = objectArray[2] + string57 + ";";
                        objectArray[3] = objectArray[3] + string80 + ";";
                    }
                    if ((n9 = (string57 = this.getcheckAutoSnapshot()).indexOf("@")) != -1) {
                        string56 = string57.substring(0, n9);
                        String string81 = string57.substring(n9 + 1, string57.length());
                        objectArray[2] = objectArray[2] + string56 + ";";
                        objectArray[3] = objectArray[3] + string81 + ";";
                    }
                    if ((n8 = (string56 = this.getcheckDisableAutoDeleteOldestPIT()).indexOf("@")) != -1) {
                        string55 = string56.substring(0, n8);
                        String string82 = string56.substring(n8 + 1, string56.length());
                        objectArray[2] = objectArray[2] + string55 + ";";
                        objectArray[3] = objectArray[3] + string82 + ";";
                    }
                    if (this.localSASAdapter.getInformation().getldOperations_MR_CTRL_INFO().getSupportPowerSavings() == 1) {
                        int n21;
                        String string83;
                        string55 = this.getDefaultPSPolicy();
                        int n22 = string55.indexOf("@");
                        if (n22 != -1) {
                            string83 = string55.substring(0, n22);
                            String string84 = string55.substring(n22 + 1, string55.length());
                            objectArray[2] = objectArray[2] + string83 + ";";
                            objectArray[3] = objectArray[3] + string84 + ";";
                        }
                        if ((n21 = (string83 = this.getCurrentPSPolicy()).indexOf("@")) != -1) {
                            String string85 = string83.substring(0, n21);
                            String string86 = string83.substring(n21 + 1, string83.length());
                            System.out.println("psPolicy:" + string56);
                            objectArray[2] = objectArray[2] + string85 + ";";
                            objectArray[3] = objectArray[3] + string86 + ";";
                            System.out.println("psPolicyold : " + string85);
                            System.out.println("psPolicynew : " + string86);
                        }
                    }
                    string = MessageFormat.format(Resource.getEvtString(string68), objectArray);
                    break;
                }
                case '+': {
                    String string87;
                    int n23;
                    String string88;
                    int n24;
                    String string89;
                    int n25;
                    String string90;
                    int n26;
                    String string91;
                    String string92;
                    int n27;
                    String string93;
                    int n28;
                    String string94;
                    int n29;
                    String string95;
                    int n30;
                    String string96;
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_PROP_PS:");
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Integer.toString(n);
                    String string97 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getld().gettargetId();
                    System.out.println("EVENT ID =" + n2);
                    objectArray[2] = "";
                    objectArray[3] = "";
                    String string98 = this.oldLDName();
                    String string99 = this.newLDName();
                    int n31 = string98.compareTo(string99);
                    if (n31 != 0) {
                        objectArray[2] = objectArray[2] + string98;
                        objectArray[3] = objectArray[3] + string99;
                        string = MessageFormat.format(Resource.getEvtString(string97), objectArray);
                    }
                    String string100 = this.getcheckDefaultReadCachePolicy();
                    System.out.println(string100);
                    int n32 = string100.indexOf("@");
                    if (n32 != -1) {
                        string96 = string100.substring(0, n32);
                        String string101 = string100.substring(n32 + 1, string100.length());
                        System.out.println("readcachepolicy:" + string100);
                        objectArray[2] = objectArray[2] + string96 + ";";
                        objectArray[3] = objectArray[3] + string101 + ";";
                        System.out.println("readcachepolicyOLD:" + string96);
                        System.out.println("readcachepolicyNEW:" + string101);
                    }
                    if ((n30 = (string96 = this.getcheckDefaultWriteCachePolicy()).indexOf("@")) != -1) {
                        string95 = string96.substring(0, n30);
                        String string102 = string96.substring(n30 + 1, string96.length());
                        System.out.println("writecachepolicy:" + string96);
                        objectArray[2] = objectArray[2] + string95 + ";";
                        objectArray[3] = objectArray[3] + string102 + ";";
                        System.out.println("writecachepolicyOLD:" + string95);
                        System.out.println("writecachepolicyNEW:" + string102);
                    }
                    if ((n29 = (string95 = this.getcheckDefaultIoPolicy()).indexOf("@")) != -1) {
                        string94 = string95.substring(0, n29);
                        String string103 = string95.substring(n29 + 1, string95.length());
                        System.out.println("ioPolicy:" + string95);
                        objectArray[2] = objectArray[2] + string94 + ";";
                        objectArray[3] = objectArray[3] + string103 + ";";
                        System.out.println("ioPolicyOLD : " + string94);
                        System.out.println("ioPolicyNEW : " + string103);
                    }
                    if ((n28 = (string94 = this.getcheckAccessPolicy()).indexOf("@")) != -1) {
                        string93 = string94.substring(0, n28);
                        String string104 = string94.substring(n28 + 1, string94.length());
                        objectArray[2] = objectArray[2] + string93 + ";";
                        objectArray[3] = objectArray[3] + string104 + ";";
                        System.out.println("accessPolicy_OLD : " + string93);
                        System.out.println("accessPolicy_NEW : " + string104);
                    }
                    if ((n27 = (string93 = this.getcheckDiskCachePolicy()).indexOf("@")) != -1) {
                        string92 = string93.substring(0, n27);
                        String string105 = string93.substring(n27 + 1, string93.length());
                        System.out.println("ioPolicy:" + string93);
                        objectArray[2] = objectArray[2] + string92 + ";";
                        objectArray[3] = objectArray[3] + string105 + ";";
                        System.out.println("discCachePolicyOLD : " + string92);
                        System.out.println("discCachePolicyNEW : " + string105);
                    }
                    string92 = this.getcheckCurrentReadCachePolicy();
                    System.out.println(string92);
                    int n33 = string92.indexOf("@");
                    if (n33 != -1) {
                        string91 = string92.substring(0, n33);
                        String string106 = string92.substring(n33 + 1, string92.length());
                        System.out.println("readcachepolicy:" + string92);
                        objectArray[2] = objectArray[2] + string91 + ";";
                        objectArray[3] = objectArray[3] + string106 + ";";
                        System.out.println("currentReadcachepolicyold:" + string91);
                        System.out.println("currentReadcachepolicynew:" + string106);
                    }
                    if ((n26 = (string91 = this.getcheckCurrentWriteCachePolicy()).indexOf("@")) != -1) {
                        string90 = string91.substring(0, n26);
                        System.out.println("currentWritecachepolicyold:" + string90);
                        String string107 = string91.substring(n26 + 1, string91.length());
                        System.out.println("currentWritecachepolicynewStr:" + string107);
                        System.out.println("writecachepolicy:" + string91);
                        objectArray[2] = objectArray[2] + string90 + ";";
                        objectArray[3] = objectArray[3] + string107 + ";";
                        System.out.println("currentWritecachepolicyold:" + string90);
                        System.out.println("currentWritecachepolicynew:" + string107);
                    }
                    if ((n25 = (string90 = this.getcheckBgi()).indexOf("@")) != -1) {
                        string89 = string90.substring(0, n25);
                        String string108 = string90.substring(n25 + 1, string90.length());
                        System.out.println("checkBgi:" + string90);
                        objectArray[2] = objectArray[2] + string89 + ";";
                        objectArray[3] = objectArray[3] + string108 + ";";
                        System.out.println("checkBgiOLD : " + string89);
                        System.out.println("checkBgiNEW : " + string108);
                    }
                    if ((n24 = (string89 = this.getcheckAutoSnapshot()).indexOf("@")) != -1) {
                        string88 = string89.substring(0, n24);
                        String string109 = string89.substring(n24 + 1, string89.length());
                        System.out.println("autoSS:" + string89);
                        objectArray[2] = objectArray[2] + string88 + ";";
                        objectArray[3] = objectArray[3] + string109 + ";";
                        System.out.println("autoSS_OLD : " + string88);
                        System.out.println("autoSS_NEW : " + string109);
                    }
                    if ((n23 = (string88 = this.getcheckDisableAutoDeleteOldestPIT()).indexOf("@")) != -1) {
                        string87 = string88.substring(0, n23);
                        String string110 = string88.substring(n23 + 1, string88.length());
                        System.out.println("oldestPit:" + string88);
                        objectArray[2] = objectArray[2] + string87 + ";";
                        objectArray[3] = objectArray[3] + string110 + ";";
                        System.out.println("oldestPit_OLD : " + string87);
                        System.out.println("oldestPit_NEW : " + string110);
                    }
                    if (this.localSASAdapter.getInformation().getldOperations_MR_CTRL_INFO().getSupportPowerSavings() == 1) {
                        int n34;
                        String string111;
                        string87 = this.getDefaultPSPolicy();
                        int n35 = string87.indexOf("@");
                        if (n35 != -1) {
                            string111 = string87.substring(0, n25);
                            String string112 = string87.substring(n25 + 1, string87.length());
                            System.out.println("psPolicy:" + string88);
                            objectArray[2] = objectArray[2] + string111 + ";";
                            objectArray[3] = objectArray[3] + string112 + ";";
                            System.out.println("psPolicyold : " + string111);
                            System.out.println("psPolicynew : " + string112);
                        }
                        if ((n34 = (string111 = this.getCurrentPSPolicy()).indexOf("@")) != -1) {
                            String string113 = string111.substring(0, n34);
                            String string114 = string111.substring(n34 + 1, string111.length());
                            System.out.println("psPolicy:" + string88);
                            objectArray[2] = objectArray[2] + string113 + ";";
                            objectArray[3] = objectArray[3] + string114 + ";";
                            System.out.println("psPolicyold : " + string113);
                            System.out.println("psPolicynew : " + string114);
                        }
                    }
                    string = MessageFormat.format(Resource.getEvtString(string97), objectArray);
                    break;
                }
                case '\u0007': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_PROG:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string115 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProg_args_MR_EVT_DETAIL1().getld().gettargetId();
                    float f = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProg_args_MR_EVT_DETAIL1().getprog().getprogress();
                    float f2 = f / 65535.0f * 100.0f;
                    String string116 = Float.toString(f2);
                    objectArray[2] = string116;
                    string = MessageFormat.format(Resource.getEvtString(string115), objectArray);
                    break;
                }
                case '\u000e': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_PROG:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdProg_args_MR_EVT_DETAIL1().getpd();
                    String string117 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    int n36 = (int)this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdProg_args_MR_EVT_DETAIL1().getprog().getprogress();
                    int n37 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdProg_args_MR_EVT_DETAIL1().getprog().getelapsedSecs();
                    String string118 = Integer.toString(n37);
                    objectArray[1] = string117;
                    objectArray[2] = n36 + "," + string118;
                    String string119 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string119), objectArray);
                    break;
                }
                case '\u001d': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_ADDRESS:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = n;
                    byte by = (byte)this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdAddress().getscsiDevType();
                    String string120 = this.getDevicetype(by);
                    String string121 = Integer.toString(n2);
                    objectArray[1] = string120;
                    MR_PD_ADDRESS mR_PD_ADDRESS = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdAddress();
                    String string122 = this.getPdAddress(n, mR_PD_ADDRESS);
                    objectArray[2] = string122;
                    string = MessageFormat.format(Resource.getEvtString(string121), objectArray);
                    break;
                }
                case '&': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_LD:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string123 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getLD_ld_MR_EVT_DETAIL1().getLd().gettargetId();
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getLD_ld_MR_EVT_DETAIL1().getProviderLd().gettargetId();
                    string = MessageFormat.format(Resource.getEvtString(string123), objectArray);
                    break;
                }
                case ')': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_LD:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string124 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldSnapProg_args_MR_EVT_DETAIL().getld().gettargetId();
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldSnapProg_args_MR_EVT_DETAIL().getpitRtc();
                    float f = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldSnapProg_args_MR_EVT_DETAIL().getprog().getprogress();
                    float f3 = f / 65535.0f * 100.0f;
                    String string125 = Float.toString(f3);
                    int n38 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldSnapProg_args_MR_EVT_DETAIL().getprog().getelapsedSecs();
                    String string126 = Integer.toString(n38);
                    objectArray[3] = string125 + "," + string126;
                    string = MessageFormat.format(Resource.getEvtString(string124), objectArray);
                    break;
                }
                case '\u000f': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_STATE:");
                    Object[] objectArray = new Object[4];
                    System.out.println("Ctrl ID" + n);
                    String string127 = Integer.toString(n);
                    objectArray[0] = string127;
                    System.out.println("Ctrl ID" + objectArray[0]);
                    String string128 = Integer.toString(n2);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdState_args_MR_EVT_DETAIL1().getpd();
                    System.out.println("JLogger.getEventinStringFormat()" + mR_EVT_ARG_PD.getdeviceId());
                    String string129 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    System.out.println("Event ID = " + string128);
                    objectArray[1] = string129;
                    int n39 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdState_args_MR_EVT_DETAIL1().getprevState();
                    int n40 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdState_args_MR_EVT_DETAIL1().getnewState();
                    String string130 = this.getPdState(n39);
                    String string131 = this.getPdState(n40);
                    objectArray[2] = string130;
                    objectArray[3] = string131;
                    string = MessageFormat.format(Resource.getEvtString(string128), objectArray);
                    break;
                }
                case '\b': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_STATE:");
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Integer.toString(n);
                    String string132 = Integer.toString(n2);
                    short s = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldState_args_MR_EVT_DETAIL1().getld().gettargetId();
                    objectArray[1] = Integer.toString(s);
                    System.out.println(objectArray[1]);
                    int n41 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldState_args_MR_EVT_DETAIL1().getprevState();
                    int n42 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldState_args_MR_EVT_DETAIL1().getnewState();
                    String string133 = this.getLdState(n41);
                    String string134 = this.getLdState(n42);
                    objectArray[2] = string133;
                    objectArray[3] = string134;
                    string = MessageFormat.format(Resource.getEvtString(string132), objectArray);
                    break;
                }
                case '\u001f': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_CONNECTOR:");
                    Object[] objectArray = new Object[2];
                    objectArray[0] = Integer.toString(n);
                    String string135 = Integer.toString(n2);
                    MR_SAS_CONNECTOR_INFO mR_SAS_CONNECTOR_INFO = null;
                    byte[] byArray6 = mR_SAS_CONNECTOR_INFO.getName();
                    String string136 = new String(byArray6);
                    System.out.println(string136);
                    String string137 = string136.trim();
                    objectArray[1] = string137;
                    string = MessageFormat.format(Resource.getEvtString(string135), objectArray);
                    break;
                }
                case '\'': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_PIT:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string138 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getMR_EVT_ARGS_LD_PIT().getLd().gettargetId();
                    String string139 = this.gettimeStamp(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getMR_EVT_ARGS_LD_PIT().getPitRtc());
                    objectArray[2] = string139;
                    string = MessageFormat.format(Resource.getEvtString(string138), objectArray);
                    break;
                }
                case '(': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_VIEW:");
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Integer.toString(n);
                    String string140 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getView_args_MR_EVT_DETAIL1().getLd().gettargetId();
                    objectArray[2] = this.gettimeStamp(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getView_args_MR_EVT_DETAIL1().getPitRtc());
                    objectArray[3] = this.gettimeStamp(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getView_args_MR_EVT_DETAIL1().getViewRtc());
                    string = MessageFormat.format(Resource.getEvtString(string140), objectArray);
                    break;
                }
                case '\u001e': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_BITMAP:");
                    Object[] objectArray = new Object[2];
                    objectArray[0] = Integer.toString(n);
                    String string141 = Integer.toString(n2);
                    if (this.eventDetail.getevtDetail().getcode() == 264) {
                        String string142 = " ";
                        int n43 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getArgsBitmap().getCount();
                        if (n43 != 0) {
                            AdapterHelper adapterHelper = this.adpHelperArray[n];
                            PhysicalDriveHelper[] physicalDriveHelperArray = adapterHelper.getPhysicalDrives();
                            if (physicalDriveHelperArray != null && physicalDriveHelperArray.length > 0) {
                                for (int i = 0; i < n43; ++i) {
                                    char c2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getArgsBitmap().getEvtBitmap()[i];
                                    if (c2 == '\u0000') {
                                        System.out.println("Byte at index " + i + " is 0");
                                        continue;
                                    }
                                    int n44 = 1;
                                    int n45 = 0;
                                    MR_PD_ADDRESS mR_PD_ADDRESS = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdAddress();
                                    while (n44 != 0) {
                                        if ((c2 & n44) != 0) {
                                            int n46 = i * 8 + n45;
                                            for (int j = 0; j < physicalDriveHelperArray.length; ++j) {
                                                if (n46 != physicalDriveHelperArray[j].getDeviceID()) continue;
                                                if (string142 == " ") {
                                                    string142 = this.getPdAddress(n, mR_PD_ADDRESS);
                                                    break;
                                                }
                                                string142 = string142 + "," + this.getPdAddress(n, mR_PD_ADDRESS);
                                                break;
                                            }
                                        }
                                        n44 <<= 1;
                                        ++n45;
                                    }
                                }
                            } else {
                                System.out.println("Error - failed to get PD list");
                            }
                        } else {
                            System.out.println("Error - event bit map count is 0 . Bit Map is " + this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getArgsBitmap().getEvtBitmap());
                        }
                        objectArray[1] = string142;
                    } else if (this.eventDetail.getevtDetail().getcode() == 324 || this.eventDetail.getevtDetail().getcode() == 325 || this.eventDetail.getevtDetail().getcode() == 324 || this.eventDetail.getevtDetail().getcode() == 325) {
                        String string143 = "";
                        int n47 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getArgsBitmap().getCount();
                        if (n47 != 0) {
                            for (int i = 0; i < n47; ++i) {
                                char c3 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getArgsBitmap().getEvtBitmap()[i];
                                if (c3 == '\u0000') continue;
                                System.out.println("byteIndex = " + i + "byteValue =" + c3);
                                int n48 = 1;
                                int n49 = 0;
                                while (n48 != 0) {
                                    if ((c3 & n48) != 0) {
                                        int n50 = i * 8 + n49;
                                        String string144 = Integer.toString(n50);
                                        string143 = string143.isEmpty() ? string143 + string144 : string143 + "," + string144;
                                    }
                                    n48 <<= 1;
                                    ++n49;
                                }
                            }
                        }
                        objectArray[1] = string143.intern();
                    }
                    string = MessageFormat.format(Resource.getEvtString(string141), objectArray);
                    break;
                }
                case '%': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_KEYINFO:");
                    Object[] objectArray = new Object[2];
                    objectArray[0] = Integer.toString(n);
                    String string145 = Integer.toString(n2);
                    byte by = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getkeyInfo_args_MR_EVT_DETAIL().getkeytype();
                    String string146 = this.getKeyType(by);
                    objectArray[1] = "";
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getkeyInfo_args_MR_EVT_DETAIL().getpd();
                    String string147 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[2] = string147;
                    objectArray[3] = Character.valueOf(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getkeyInfo_args_MR_EVT_DETAIL().getkeyIdLength());
                    string = MessageFormat.format(Resource.getEvtString(string145), objectArray);
                    break;
                }
                case '\u0019': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_DIAG_FAIL:");
                    Object[] objectArray = new Object[6];
                    objectArray[0] = Integer.toString(n);
                    String string148 = Integer.toString(n2);
                    byte[] byArray7 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getdiagFail_args_MR_EVT_DETAIL().getstr();
                    String string149 = new String(byArray7);
                    objectArray[1] = string149.trim();
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getdiagFail_args_MR_EVT_DETAIL().getpassCount();
                    objectArray[3] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getdiagFail_args_MR_EVT_DETAIL().getoffset();
                    objectArray[4] = Character.valueOf(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getdiagFail_args_MR_EVT_DETAIL().getgoodData());
                    objectArray[5] = Character.valueOf(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getdiagFail_args_MR_EVT_DETAIL().getbadData());
                    break;
                }
                case '\u0001': {
                    String string150;
                    int n51;
                    int n52;
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_CDB_SENSE:");
                    Object[] objectArray = new Object[5];
                    String string151 = "";
                    String string152 = "";
                    objectArray[0] = Integer.toString(n);
                    String string153 = Integer.toString(n2);
                    int n53 = this.getAdditionalSenseCodeDescription(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getcdbSense_args_MR_EVT_DETAIL1().getsense()[12] << 8 | this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getcdbSense_args_MR_EVT_DETAIL1().getsense()[13]);
                    if (n53 > 0) {
                        string152 = Scsisensedesc.additionalSenseCodeDescription[n53 - 1];
                        System.out.println("Sense Desc Value is ::" + string152);
                    } else {
                        string152 = "Unknown Sense Code";
                        System.out.println("cdbsense Value is ::" + string151);
                    }
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getcdbSense_args_MR_EVT_DETAIL1().getpd();
                    String string154 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string154 + "-" + string152;
                    int n54 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getcdbSense_args_MR_EVT_DETAIL1().getcdbLength();
                    if (n54 > 16) {
                        n54 = 16;
                    }
                    System.out.println("JLogger.getEventinStringFormat() cdb len" + n54);
                    String string155 = "";
                    for (n52 = n54 - 1; n52 >= 0; --n52) {
                        byte by = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getcdbSense_args_MR_EVT_DETAIL1().getcdb()[n52];
                        String string156 = Byte.toString(by);
                        n51 = Integer.parseInt(string156.trim());
                        string150 = Integer.toHexString(n51);
                        if (string150.length() == 1) {
                            string150 = "0" + string150;
                        }
                        if (string150.length() > 2) {
                            string150 = string150.substring(string150.length() - 2);
                        }
                        System.out.println("getcdb value is : " + string156.trim());
                        System.out.println("getcdb value is : " + string150);
                        string155 = " 0x" + string150 + string155;
                        objectArray[2] = string155;
                    }
                    n52 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getcdbSense_args_MR_EVT_DETAIL1().getsenseLength();
                    if (n52 > 64) {
                        n52 = 64;
                    }
                    System.out.println("JLogger.getEventinStringFormat() sense Length = " + n52);
                    String string157 = "";
                    for (int i = n52 - 1; i >= 0; --i) {
                        n51 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getcdbSense_args_MR_EVT_DETAIL1().getsense()[i];
                        string150 = Byte.toString((byte)n51);
                        int n55 = Integer.parseInt(string150.trim());
                        String string158 = Integer.toHexString(n55);
                        if (string158.length() == 1) {
                            string158 = "0" + string158;
                        }
                        if (string158.length() > 2) {
                            string158 = string158.substring(string158.length() - 2);
                        }
                        System.out.println("getsense value is : " + string150.trim());
                        System.out.println("getsense value is : " + string158);
                        string157 = " 0x" + string158 + string157;
                        objectArray[3] = string157;
                    }
                    if (this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getcdbSense_args_MR_EVT_DETAIL1().getsasAddress() != 0L) {
                        long l = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getcdbSense_args_MR_EVT_DETAIL1().getsasAddress();
                        objectArray[4] = "0x" + Long.toHexString(l).toUpperCase();
                    }
                    string = MessageFormat.format(Resource.getEvtString(string153), objectArray);
                    break;
                }
                case '\u0002': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD:");
                    Object[] objectArray = new Object[2];
                    objectArray[0] = Integer.toString(n);
                    String string159 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getld().gettargetId();
                    if (this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getld().getIsRemote().booleanValue()) {
                        string = MessageFormat.format(Resource.getEvtString(string159), objectArray);
                        string = string + Resource.getString("REMOTE_VD", " -Remote VD");
                        break;
                    }
                    string = MessageFormat.format(Resource.getEvtString(string159), objectArray);
                    break;
                }
                case '\u0003': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_COUNT:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string160 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldCount_args_MR_EVT_DETAIL1().getld().gettargetId();
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldCount_args_MR_EVT_DETAIL1().getcount();
                    string = MessageFormat.format(Resource.getEvtString(string160), objectArray);
                    break;
                }
                case '\u0006': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_LBA_PD_LBA:");
                    Object[] objectArray = new Object[5];
                    objectArray[0] = Integer.toString(n);
                    String string161 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldLbaPdLba_args_MR_EVT_DETAIL1().getld().gettargetId();
                    long l = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldLbaPdLba_args_MR_EVT_DETAIL1().getldLba();
                    String string162 = "0x" + Long.toHexString(l);
                    objectArray[2] = string162;
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldLbaPdLba_args_MR_EVT_DETAIL1().getpd();
                    String string163 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[3] = string163;
                    long l2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldLbaPdLba_args_MR_EVT_DETAIL1().getpdLba();
                    String string164 = "0x" + Long.toHexString(l2);
                    objectArray[4] = string164;
                    string = MessageFormat.format(Resource.getEvtString(string161), objectArray);
                    break;
                }
                case '\t': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_LD_STRIP:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string165 = Integer.toString(n2);
                    objectArray[1] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldStrip_args_MR_EVT_DETAIL1().getld().gettargetId();
                    int n56 = (int)this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldStrip_args_MR_EVT_DETAIL1().getstrip();
                    objectArray[2] = n56;
                    string = MessageFormat.format(Resource.getEvtString(string165), objectArray);
                    break;
                }
                case '\"': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_PATHINFO:");
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Integer.toString(n);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getPdPath_args_MR_EVT_DETAIL1().getpd();
                    String string166 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string166;
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getPdPath_args_MR_EVT_DETAIL1().getPath();
                    if (this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getPdPath_args_MR_EVT_DETAIL1().getsasAddr() != 0L) {
                        objectArray[3] = "0x" + Long.toHexString(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getPdPath_args_MR_EVT_DETAIL1().getsasAddr()).toUpperCase();
                    }
                    String string167 = Integer.toString(n2);
                    string = MessageFormat.format(Resource.getEvtString(string167), objectArray);
                    break;
                }
                case '\u000b': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_ERR:");
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Integer.toString(n);
                    String string168 = Integer.toString(n2);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdErr_args_MR_EVT_DETAIL1().getpd();
                    String string169 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string169;
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdErr_args_MR_EVT_DETAIL1().geterr();
                    if (this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdErr_args_MR_EVT_DETAIL1().getsasAddr() != 0L) {
                        objectArray[3] = "0x" + Long.toHexString(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdErr_args_MR_EVT_DETAIL1().getsasAddr()).toUpperCase();
                    }
                    string = MessageFormat.format(Resource.getEvtString(string168), objectArray);
                    break;
                }
                case '*': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PFINFO:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string170 = Integer.toString(n2);
                    short s = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpfInfo().getPfAction();
                    String string171 = "";
                    if (s == 0) {
                        string171 = "EXACT";
                    } else if (s == 1) {
                        string171 = "ACTIVATE";
                    } else if (s == 2) {
                        string171 = "DEACTIVATE";
                    } else if (s == 3) {
                        string171 = "TRIAL";
                    }
                    objectArray[1] = string171;
                    String string172 = "";
                    short s2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpfInfo().getFeatures().getEnableRaid6();
                    if (s2 == 1) {
                        string172 = string172.length() > 0 ? string172 + " - R6" : string172 + " R6";
                        objectArray[2] = string172;
                    } else {
                        System.out.println("Error in R6-->" + s2);
                    }
                    s2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpfInfo().getFeatures().getEnableRaid5();
                    if (s2 == 1) {
                        string172 = string172.length() > 0 ? string172 + " - R5" : string172 + " R5";
                    } else {
                        System.out.println("Error in R5-->" + s2);
                    }
                    s2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpfInfo().getFeatures().getEnableSecurity();
                    if (s2 == 1) {
                        string172 = string172.length() > 0 ? string172 + " - SafeStore" : string172 + " SafeStore";
                        objectArray[2] = string172;
                    } else {
                        System.out.println("Error in SafeStore-->" + s2);
                    }
                    s2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpfInfo().getFeatures().getEnableCTIO();
                    if (s2 == 1) {
                        string172 = string172.length() > 0 ? string172 + " - FastPath" : string172 + " FastPath";
                        objectArray[2] = string172;
                    } else {
                        System.out.println("Error in FastPath-->" + s2);
                    }
                    s2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpfInfo().getFeatures().getEnableSnapshot();
                    if (s2 == 1) {
                        string172 = string172.length() > 0 ? string172 + " - Recovery" : string172 + " Recovery";
                        objectArray[2] = string172;
                    } else {
                        System.out.println("Error in Recovery-->" + s2);
                    }
                    s2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpfInfo().getFeatures().getEnableSSC();
                    if (s2 == 1) {
                        string172 = string172.length() > 0 ? string172 + " - CacheCade" : string172 + " CacheCade";
                        objectArray[2] = string172;
                    } else {
                        System.out.println("Error in CacheCade-->" + s2);
                    }
                    string = MessageFormat.format(Resource.getEvtString(string170), objectArray);
                    break;
                }
                case ',': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_PD_TEMPERATURE:");
                    Object[] objectArray = new Object[3];
                    objectArray[0] = Integer.toString(n);
                    String string173 = Integer.toString(n2);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getPDTemp_args_MR_EVT_DETAIL().getPd();
                    String string174 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string174;
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getPDTemp_args_MR_EVT_DETAIL().getTemperature();
                    string = MessageFormat.format(Resource.getEvtString(string173), objectArray);
                    break;
                }
                case '-': {
                    System.out.println("INSIDE case MR_EVT_ARGS.MR_EVT_ARGS_DFF_LIFE:");
                    Object[] objectArray = new Object[5];
                    objectArray[0] = Integer.toString(n);
                    String string175 = Integer.toString(n2);
                    MR_EVT_ARG_PD mR_EVT_ARG_PD = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getPDLife_Args_MR_EVT_DETAIL().getPd();
                    String string176 = this.getPdInfo(n, mR_EVT_ARG_PD);
                    objectArray[1] = string176;
                    objectArray[2] = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getPDLife_Args_MR_EVT_DETAIL().getLife();
                    objectArray[3] = Character.valueOf(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getPDLife_Args_MR_EVT_DETAIL().getWarningLevel());
                    objectArray[4] = Character.valueOf(this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getPDLife_Args_MR_EVT_DETAIL().getCriticalLevel());
                    string = MessageFormat.format(Resource.getEvtString(string175), objectArray);
                    break;
                }
                default: {
                    char c4 = this.eventDetail.getevtDetail().getargType();
                    System.out.println("Unhandled argType received...MR_EVT_ARGS Id id ::" + c4);
                }
            }
        }
        return string;
    }

    public String getKeyType(byte by) {
        String string = "";
        String string2 = Byte.toString(by);
        int n = Integer.parseInt(string2);
        switch (n) {
            case 1: {
                string = "unlocked";
                break;
            }
            case 2: {
                string = "newely created";
                break;
            }
            case 3: {
                string = "re-keyed";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public String oldLDName() {
        byte[] byArray = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getname();
        String string = new String(byArray);
        System.out.println(string);
        String string2 = string.trim();
        System.out.println("old name =" + string2);
        return string2;
    }

    public String newLDName() {
        byte[] byArray = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getname();
        String string = new String(byArray);
        String string2 = string.trim();
        System.out.println("new name =" + string2);
        return string2;
    }

    public String getPdPowerState(int n) {
        System.out.println("Inside getPdPowerState function: pdstate ::" + n);
        String string = "";
        switch ((byte)n) {
            case 0: {
                string = Resource.getString("PD_DRIVE_STATE_ACTIVE ", "On");
                break;
            }
            case 1: {
                string = Resource.getString("PD_DRIVE_STATE_STOP ", "Powersave");
                break;
            }
            case -1: {
                string = Resource.getString("PD_DRIVE_STATE_TRANSITIONING", "Transition");
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public String getDevicetype(byte by) {
        String string = Resource.getString("PDTYPE_UNKNOWN", "Unknown");
        switch (by) {
            case 5: {
                string = Resource.getString("DEV_CDROM_TEXT", "CDROM");
                break;
            }
            case 0: {
                string = Resource.getString("DEV_DIRECT_TEXT", "Disk");
                break;
            }
            case 1: {
                string = Resource.getString("DEV_TAPE_TEXT", "TAPE");
                break;
            }
            case 13: {
                string = Resource.getString("ENCLOSURE_TEXT", "Enclosure");
            }
        }
        return string;
    }

    public String getPdAddress(int n, MR_PD_ADDRESS mR_PD_ADDRESS) {
        String string = "";
        System.out.println("Inside getPDInfo function:");
        try {
            System.out.println("Inside getPDInfo try block:");
            AdapterHelper adapterHelper = this.adpHelperArray[n];
            int n2 = -1;
            try {
                n2 = (byte)this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getpdAddress().getscsiDevType();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            short s = mR_PD_ADDRESS.getdeviceId();
            short s2 = mR_PD_ADDRESS.getenclDeviceId();
            char c = mR_PD_ADDRESS.getslotNumber();
            string = "-:-:" + c;
            if (this.eventDetail.getevtDetail().getcode() == 247 || this.eventDetail.getevtDetail().getcode() == 248) {
                System.out.println("Inside device insert / removed block:");
                String string2 = "" + s;
                return string2;
            }
            if (s == s2 || this.eventDetail.getevtDetail().getcl().getlocale() == 4 || n2 == 5 || n2 == 1) {
                System.out.println("Inside Enclosure block:");
                String string3 = "" + s2;
                return string3;
            }
            String string4 = this.getEnclosureInfo(adapterHelper, mR_PD_ADDRESS) + ":" + (short)mR_PD_ADDRESS.getslotNumber();
            return string4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public String getEnclosureInfo(AdapterHelper adapterHelper, MR_EVT_ARG_PD mR_EVT_ARG_PD) {
        String string = "-:-";
        char c = mR_EVT_ARG_PD.getenclIndex();
        EnclosureHelper[] enclosureHelperArray = adapterHelper.getEnclosures();
        for (int i = 0; i < enclosureHelperArray.length; ++i) {
            SASEnclosure sASEnclosure = (SASEnclosure)enclosureHelperArray[i].getDeviceObject();
            System.out.println("JLogger.getEnclosureInfo() encl.deviceid == " + sASEnclosure.getDeviceId());
            System.out.println("JLogger.getEnclosureInfo() pd.encldeviceid == " + mR_EVT_ARG_PD.enclIndexShort);
            if (sASEnclosure.getEnclInfo().getdeviceId() != mR_EVT_ARG_PD.enclIndexShort) continue;
            this.enclosureHelper = enclosureHelperArray[i];
            if (enclosureHelperArray[i].getConnectorIndex() == 255) {
                System.out.println("INSIDE if(enclHelpers[i].getConnectorIndex() ==(0xffff & 0xff))");
                String string2 = "-:-";
                return string2;
            }
            if (this.enclosureHelper.isBackplane()) {
                return string;
            }
            String string3 = this.enclosureHelper.getConnectorname();
            string = string3 + ":" + Integer.valueOf(sASEnclosure.getEnclInfo().getenclPosition());
            return string;
        }
        return string;
    }

    public String getEnclosureInfo(AdapterHelper adapterHelper, MR_PD_ADDRESS mR_PD_ADDRESS) {
        String string = "-:-";
        char c = mR_PD_ADDRESS.getenclIndex();
        EnclosureHelper[] enclosureHelperArray = adapterHelper.getEnclosures();
        for (int i = 0; i < enclosureHelperArray.length; ++i) {
            SASEnclosure sASEnclosure = (SASEnclosure)enclosureHelperArray[i].getDeviceObject();
            if (sASEnclosure.getEnclInfo().getdeviceId() != mR_PD_ADDRESS.getenclDeviceId()) continue;
            this.enclosureHelper = enclosureHelperArray[i];
            if (enclosureHelperArray[i].getConnectorIndex() == 255) {
                System.out.println("INSIDE if(enclHelpers[i].getConnectorIndex() ==(0xffff & 0xff))");
                String string2 = "-:-";
                return string2;
            }
            if (this.enclosureHelper.isBackplane()) {
                return string;
            }
            String string3 = this.enclosureHelper.getConnectorname();
            string = string3 + ":" + Integer.valueOf(sASEnclosure.getEnclInfo().getenclPosition());
            return string;
        }
        return string;
    }

    public String getPdInfo(int n, MR_EVT_ARG_PD mR_EVT_ARG_PD) {
        String string = "";
        System.out.println("Inside getPDInfo function:");
        try {
            System.out.println("Inside getPDInfo try block:");
            AdapterHelper adapterHelper = this.adpHelperArray[n];
            short s = mR_EVT_ARG_PD.getdeviceId();
            char c = mR_EVT_ARG_PD.getslotNumber();
            string = "-:-:" + c;
            char c2 = mR_EVT_ARG_PD.getenclIndex();
            System.out.println("enclIndex = " + c2);
            short s2 = mR_EVT_ARG_PD.enclIndexShort;
            if (s == s2 || this.eventDetail.getevtDetail().getcl().getlocale() == 4) {
                System.out.println("Inside Enclosure block:");
                String string2 = "" + s2;
                return string2;
            }
            String string3 = this.getEnclosureInfo(adapterHelper, mR_EVT_ARG_PD) + ":" + (short)mR_EVT_ARG_PD.getslotNumber();
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public int getAdditionalSenseCodeDescription(int n) {
        try {
            switch (n) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 6;
                }
                case 6: {
                    return 7;
                }
                case 17: {
                    return 8;
                }
                case 18: {
                    return 9;
                }
                case 19: {
                    return 10;
                }
                case 20: {
                    return 11;
                }
                case 21: {
                    return 12;
                }
                case 256: {
                    return 13;
                }
                case 512: {
                    return 14;
                }
                case 768: {
                    return 15;
                }
                case 769: {
                    return 16;
                }
                case 770: {
                    return 17;
                }
                case 1024: {
                    return 18;
                }
                case 1025: {
                    return 19;
                }
                case 1026: {
                    return 20;
                }
                case 1027: {
                    return 21;
                }
                case 1028: {
                    return 22;
                }
                case 1280: {
                    return 23;
                }
                case 1536: {
                    return 24;
                }
                case 1792: {
                    return 25;
                }
                case 2048: {
                    return 26;
                }
                case 2049: {
                    return 27;
                }
                case 2050: {
                    return 28;
                }
                case 2304: {
                    return 29;
                }
                case 2305: {
                    return 30;
                }
                case 2306: {
                    return 31;
                }
                case 2307: {
                    return 32;
                }
                case 2560: {
                    return 33;
                }
                case 3072: {
                    return 34;
                }
                case 3073: {
                    return 35;
                }
                case 3074: {
                    return 36;
                }
                case 4096: {
                    return 37;
                }
                case 4352: {
                    return 38;
                }
                case 4353: {
                    return 39;
                }
                case 4354: {
                    return 40;
                }
                case 4355: {
                    return 41;
                }
                case 4356: {
                    return 42;
                }
                case 4357: {
                    return 43;
                }
                case 4358: {
                    return 44;
                }
                case 4359: {
                    return 45;
                }
                case 4360: {
                    return 46;
                }
                case 4361: {
                    return 47;
                }
                case 4362: {
                    return 48;
                }
                case 4363: {
                    return 49;
                }
                case 4364: {
                    return 50;
                }
                case 4608: {
                    return 51;
                }
                case 4864: {
                    return 52;
                }
                case 5120: {
                    return 53;
                }
                case 5121: {
                    return 54;
                }
                case 5122: {
                    return 55;
                }
                case 5123: {
                    return 56;
                }
                case 5124: {
                    return 57;
                }
                case 5376: {
                    return 58;
                }
                case 5377: {
                    return 59;
                }
                case 5378: {
                    return 60;
                }
                case 5632: {
                    return 61;
                }
                case 5888: {
                    return 62;
                }
                case 5889: {
                    return 63;
                }
                case 5890: {
                    return 64;
                }
                case 5891: {
                    return 65;
                }
                case 5892: {
                    return 66;
                }
                case 5893: {
                    return 67;
                }
                case 5894: {
                    return 68;
                }
                case 5895: {
                    return 69;
                }
                case 5896: {
                    return 70;
                }
                case 6144: {
                    return 71;
                }
                case 6145: {
                    return 72;
                }
                case 6146: {
                    return 73;
                }
                case 6147: {
                    return 74;
                }
                case 6148: {
                    return 75;
                }
                case 6149: {
                    return 76;
                }
                case 6150: {
                    return 77;
                }
                case 6400: {
                    return 78;
                }
                case 6401: {
                    return 79;
                }
                case 6402: {
                    return 80;
                }
                case 6403: {
                    return 81;
                }
                case 6656: {
                    return 82;
                }
                case 6912: {
                    return 83;
                }
                case 7168: {
                    return 84;
                }
                case 7169: {
                    return 85;
                }
                case 7170: {
                    return 86;
                }
                case 7424: {
                    return 87;
                }
                case 7680: {
                    return 88;
                }
                case 8192: {
                    return 89;
                }
                case 8448: {
                    return 90;
                }
                case 8449: {
                    return 91;
                }
                case 8704: {
                    return 92;
                }
                case 9216: {
                    return 93;
                }
                case 9472: {
                    return 94;
                }
                case 9728: {
                    return 95;
                }
                case 9729: {
                    return 96;
                }
                case 9730: {
                    return 97;
                }
                case 9731: {
                    return 98;
                }
                case 9984: {
                    return 99;
                }
                case 10240: {
                    return 100;
                }
                case 10241: {
                    return 101;
                }
                case 10496: {
                    return 102;
                }
                case 10752: {
                    return 103;
                }
                case 10753: {
                    return 104;
                }
                case 10754: {
                    return 105;
                }
                case 11008: {
                    return 106;
                }
                case 11264: {
                    return 107;
                }
                case 11265: {
                    return 108;
                }
                case 11266: {
                    return 109;
                }
                case 11520: {
                    return 110;
                }
                case 12032: {
                    return 111;
                }
                case 12288: {
                    return 112;
                }
                case 12289: {
                    return 113;
                }
                case 12290: {
                    return 114;
                }
                case 12291: {
                    return 115;
                }
                case 12544: {
                    return 116;
                }
                case 12545: {
                    return 117;
                }
                case 12800: {
                    return 118;
                }
                case 12801: {
                    return 119;
                }
                case 13056: {
                    return 120;
                }
                case 13824: {
                    return 121;
                }
                case 14080: {
                    return 122;
                }
                case 14592: {
                    return 123;
                }
                case 14848: {
                    return 124;
                }
                case 15104: {
                    return 125;
                }
                case 15106: {
                    return 126;
                }
                case 15105: {
                    return 127;
                }
                case 15107: {
                    return 128;
                }
                case 15108: {
                    return 129;
                }
                case 15109: {
                    return 130;
                }
                case 15110: {
                    return 131;
                }
                case 15111: {
                    return 132;
                }
                case 15112: {
                    return 133;
                }
                case 15113: {
                    return 134;
                }
                case 15114: {
                    return 135;
                }
                case 15115: {
                    return 136;
                }
                case 15116: {
                    return 137;
                }
                case 15117: {
                    return 138;
                }
                case 15118: {
                    return 139;
                }
                case 15616: {
                    return 140;
                }
                case 15872: {
                    return 141;
                }
                case 16128: {
                    return 142;
                }
                case 16129: {
                    return 143;
                }
                case 16130: {
                    return 144;
                }
                case 16131: {
                    return 145;
                }
                case 16384: {
                    return 146;
                }
                case 16640: {
                    return 148;
                }
                case 16896: {
                    return 149;
                }
                case 17152: {
                    return 150;
                }
                case 17408: {
                    return 151;
                }
                case 17664: {
                    return 152;
                }
                case 17920: {
                    return 153;
                }
                case 18176: {
                    return 154;
                }
                case 18944: {
                    return 155;
                }
                case 18432: {
                    return 156;
                }
                case 18688: {
                    return 157;
                }
                case 19200: {
                    return 158;
                }
                case 19456: {
                    return 159;
                }
                case 19968: {
                    return 160;
                }
                case 20480: {
                    return 161;
                }
                case 20481: {
                    return 162;
                }
                case 20482: {
                    return 163;
                }
                case 20736: {
                    return 164;
                }
                case 20992: {
                    return 165;
                }
                case 21248: {
                    return 166;
                }
                case 21249: {
                    return 167;
                }
                case 21250: {
                    return 168;
                }
                case 21504: {
                    return 169;
                }
                case 21760: {
                    return 170;
                }
                case 22272: {
                    return 171;
                }
                case 22528: {
                    return 172;
                }
                case 22784: {
                    return 173;
                }
                case 23040: {
                    return 174;
                }
                case 23041: {
                    return 175;
                }
                case 23042: {
                    return 176;
                }
                case 23043: {
                    return 177;
                }
                case 23296: {
                    return 178;
                }
                case 23297: {
                    return 179;
                }
                case 23298: {
                    return 180;
                }
                case 23299: {
                    return 181;
                }
                case 23552: {
                    return 182;
                }
                case 23553: {
                    return 183;
                }
                case 23554: {
                    return 184;
                }
                case 24576: {
                    return 185;
                }
                case 24832: {
                    return 186;
                }
                case 24833: {
                    return 187;
                }
                case 24834: {
                    return 188;
                }
                case 25088: {
                    return 189;
                }
                case 25344: {
                    return 190;
                }
                case 25600: {
                    return 191;
                }
                case 22: {
                    return 192;
                }
                case 23: {
                    return 193;
                }
                case 1029: {
                    return 194;
                }
                case 1030: {
                    return 195;
                }
                case 1031: {
                    return 196;
                }
                case 1032: {
                    return 197;
                }
                case 2051: {
                    return 198;
                }
                case 2308: {
                    return 199;
                }
                case 2816: {
                    return 200;
                }
                case 2817: {
                    return 201;
                }
                case 2818: {
                    return 202;
                }
                case 3075: {
                    return 203;
                }
                case 3076: {
                    return 204;
                }
                case 3077: {
                    return 205;
                }
                case 3078: {
                    return 206;
                }
                case 3079: {
                    return 207;
                }
                case 3080: {
                    return 208;
                }
                case 3081: {
                    return 209;
                }
                case 3082: {
                    return 210;
                }
                case 4365: {
                    return 211;
                }
                case 4366: {
                    return 212;
                }
                case 4367: {
                    return 213;
                }
                case 4368: {
                    return 214;
                }
                case 4369: {
                    return 215;
                }
                case 5125: {
                    return 216;
                }
                case 5126: {
                    return 217;
                }
                case 5633: {
                    return 218;
                }
                case 5634: {
                    return 219;
                }
                case 5635: {
                    return 220;
                }
                case 5636: {
                    return 221;
                }
                case 5897: {
                    return 222;
                }
                case 6151: {
                    return 223;
                }
                case 7936: {
                    return 224;
                }
                case 9732: {
                    return 225;
                }
                case 9985: {
                    return 226;
                }
                case 9986: {
                    return 227;
                }
                case 9987: {
                    return 228;
                }
                case 9988: {
                    return 229;
                }
                case 9989: {
                    return 230;
                }
                case 10497: {
                    return 231;
                }
                case 10498: {
                    return 232;
                }
                case 10499: {
                    return 233;
                }
                case 10500: {
                    return 234;
                }
                case 10755: {
                    return 235;
                }
                case 11267: {
                    return 236;
                }
                case 11268: {
                    return 237;
                }
                case 12292: {
                    return 238;
                }
                case 12293: {
                    return 239;
                }
                case 12294: {
                    return 240;
                }
                case 12295: {
                    return 241;
                }
                case 12296: {
                    return 242;
                }
                case 12297: {
                    return 243;
                }
                case 13312: {
                    return 244;
                }
                case 13568: {
                    return 245;
                }
                case 13569: {
                    return 246;
                }
                case 13570: {
                    return 247;
                }
                case 13571: {
                    return 248;
                }
                case 13572: {
                    return 249;
                }
                case 14849: {
                    return 250;
                }
                case 14850: {
                    return 251;
                }
                case 15119: {
                    return 252;
                }
                case 15121: {
                    return 253;
                }
                case 15122: {
                    return 254;
                }
                case 15123: {
                    return 255;
                }
                case 15124: {
                    return 256;
                }
                case 15125: {
                    return 257;
                }
                case 15873: {
                    return 258;
                }
                case 15874: {
                    return 259;
                }
                case 21761: {
                    return 261;
                }
                case 23808: {
                    return 262;
                }
                case 24063: {
                    return 263;
                }
                case 24064: {
                    return 264;
                }
                case 24065: {
                    return 265;
                }
                case 24066: {
                    return 266;
                }
                case 24067: {
                    return 267;
                }
                case 24068: {
                    return 268;
                }
                case 25345: {
                    return 269;
                }
                case 25601: {
                    return 270;
                }
                case 25856: {
                    return 271;
                }
                case 26112: {
                    return 272;
                }
                case 26113: {
                    return 273;
                }
                case 26114: {
                    return 274;
                }
                case 26115: {
                    return 275;
                }
                case 26368: {
                    return 276;
                }
                case 26369: {
                    return 277;
                }
                case 26370: {
                    return 278;
                }
                case 26371: {
                    return 279;
                }
                case 26372: {
                    return 280;
                }
                case 26373: {
                    return 281;
                }
                case 26374: {
                    return 282;
                }
                case 26375: {
                    return 283;
                }
                case 26624: {
                    return 284;
                }
                case 26880: {
                    return 285;
                }
                case 26881: {
                    return 286;
                }
                case 26882: {
                    return 287;
                }
                case 27136: {
                    return 288;
                }
                case 27392: {
                    return 289;
                }
                case 27393: {
                    return 290;
                }
                case 27394: {
                    return 291;
                }
                case 27648: {
                    return 292;
                }
                case 27904: {
                    return 293;
                }
                case 28160: {
                    return 294;
                }
                case 28928: {
                    return 296;
                }
                case 29184: {
                    return 297;
                }
                case 29185: {
                    return 298;
                }
                case 29186: {
                    return 299;
                }
                case 29187: {
                    return 300;
                }
                case 29188: {
                    return 301;
                }
                case 29440: {
                    return 302;
                }
                case 29441: {
                    return 303;
                }
                case 29442: {
                    return 304;
                }
                case 29443: {
                    return 305;
                }
                case 29444: {
                    return 306;
                }
                case 29445: {
                    return 307;
                }
                case 32768: {
                    return 308;
                }
                case 32769: {
                    return 309;
                }
                case 32770: {
                    return 310;
                }
                case 32771: {
                    return 311;
                }
                case 32772: {
                    return 312;
                }
                case 32773: {
                    return 313;
                }
                case 32774: {
                    return 314;
                }
                case 32775: {
                    return 315;
                }
                case 32776: {
                    return 316;
                }
                case 32777: {
                    return 317;
                }
                case 32778: {
                    return 318;
                }
                case 32779: {
                    return 319;
                }
                case 32780: {
                    return 320;
                }
                case 1033: {
                    return 321;
                }
                case 2052: {
                    return 322;
                }
                case 9217: {
                    return 323;
                }
                case 9733: {
                    return 324;
                }
                case 9734: {
                    return 325;
                }
                case 9735: {
                    return 326;
                }
                case 9736: {
                    return 327;
                }
                case 9737: {
                    return 328;
                }
                case 9738: {
                    return 329;
                }
                case 9739: {
                    return 330;
                }
                case 9740: {
                    return 331;
                }
                case 9741: {
                    return 332;
                }
                case 10501: {
                    return 333;
                }
                case 10502: {
                    return 334;
                }
                case 10756: {
                    return 335;
                }
                case 10757: {
                    return 336;
                }
                case 11269: {
                    return 337;
                }
                case 11776: {
                    return 338;
                }
                case 11777: {
                    return 339;
                }
                case 11778: {
                    return 340;
                }
                case 11779: {
                    return 341;
                }
                case 11780: {
                    return 342;
                }
                case 11781: {
                    return 343;
                }
                case 14336: {
                    return 344;
                }
                case 14338: {
                    return 345;
                }
                case 14340: {
                    return 346;
                }
                case 14342: {
                    return 347;
                }
                case 14851: {
                    return 348;
                }
                case 14852: {
                    return 349;
                }
                case 15126: {
                    return 350;
                }
                case 15875: {
                    return 351;
                }
                case 15876: {
                    return 352;
                }
                case 16132: {
                    return 353;
                }
                case 16133: {
                    return 354;
                }
                case 16134: {
                    return 355;
                }
                case 16135: {
                    return 356;
                }
                case 16136: {
                    return 357;
                }
                case 16137: {
                    return 358;
                }
                case 16138: {
                    return 359;
                }
                case 16139: {
                    return 360;
                }
                case 16140: {
                    return 361;
                }
                case 16141: {
                    return 362;
                }
                case 16142: {
                    return 363;
                }
                case 16143: {
                    return 364;
                }
                case 16144: {
                    return 365;
                }
                case 16145: {
                    return 366;
                }
                case 18177: {
                    return 367;
                }
                case 18178: {
                    return 368;
                }
                case 18179: {
                    return 369;
                }
                case 18180: {
                    return 370;
                }
                case 21762: {
                    return 371;
                }
                case 21763: {
                    return 372;
                }
                case 21764: {
                    return 373;
                }
                case 23809: {
                    return 374;
                }
                case 23810: {
                    return 375;
                }
                case 23824: {
                    return 376;
                }
                case 23825: {
                    return 377;
                }
                case 23826: {
                    return 378;
                }
                case 23827: {
                    return 379;
                }
                case 23828: {
                    return 380;
                }
                case 23829: {
                    return 381;
                }
                case 23830: {
                    return 382;
                }
                case 23831: {
                    return 383;
                }
                case 23832: {
                    return 384;
                }
                case 23833: {
                    return 385;
                }
                case 23834: {
                    return 386;
                }
                case 23835: {
                    return 387;
                }
                case 23836: {
                    return 388;
                }
                case 23840: {
                    return 389;
                }
                case 23841: {
                    return 390;
                }
                case 23842: {
                    return 391;
                }
                case 23843: {
                    return 392;
                }
                case 23844: {
                    return 393;
                }
                case 23845: {
                    return 394;
                }
                case 23846: {
                    return 395;
                }
                case 23847: {
                    return 396;
                }
                case 23848: {
                    return 397;
                }
                case 23849: {
                    return 398;
                }
                case 23850: {
                    return 399;
                }
                case 23851: {
                    return 400;
                }
                case 23852: {
                    return 401;
                }
                case 23856: {
                    return 402;
                }
                case 23857: {
                    return 403;
                }
                case 23858: {
                    return 404;
                }
                case 23859: {
                    return 405;
                }
                case 23860: {
                    return 406;
                }
                case 23861: {
                    return 407;
                }
                case 23862: {
                    return 408;
                }
                case 23863: {
                    return 409;
                }
                case 23864: {
                    return 410;
                }
                case 23865: {
                    return 411;
                }
                case 23866: {
                    return 412;
                }
                case 23867: {
                    return 413;
                }
                case 23868: {
                    return 414;
                }
                case 23872: {
                    return 415;
                }
                case 23873: {
                    return 416;
                }
                case 23874: {
                    return 417;
                }
                case 23875: {
                    return 418;
                }
                case 23876: {
                    return 419;
                }
                case 23877: {
                    return 420;
                }
                case 23878: {
                    return 421;
                }
                case 23879: {
                    return 422;
                }
                case 23880: {
                    return 423;
                }
                case 23881: {
                    return 424;
                }
                case 23882: {
                    return 425;
                }
                case 23883: {
                    return 426;
                }
                case 23884: {
                    return 427;
                }
                case 23888: {
                    return 428;
                }
                case 23889: {
                    return 429;
                }
                case 23890: {
                    return 430;
                }
                case 23891: {
                    return 431;
                }
                case 23892: {
                    return 432;
                }
                case 23893: {
                    return 433;
                }
                case 23894: {
                    return 434;
                }
                case 23895: {
                    return 435;
                }
                case 23896: {
                    return 436;
                }
                case 23897: {
                    return 437;
                }
                case 23898: {
                    return 438;
                }
                case 23899: {
                    return 439;
                }
                case 23900: {
                    return 440;
                }
                case 23904: {
                    return 441;
                }
                case 23905: {
                    return 442;
                }
                case 23906: {
                    return 443;
                }
                case 23907: {
                    return 444;
                }
                case 23908: {
                    return 445;
                }
                case 23909: {
                    return 446;
                }
                case 23910: {
                    return 447;
                }
                case 23911: {
                    return 448;
                }
                case 23912: {
                    return 449;
                }
                case 23913: {
                    return 450;
                }
                case 23914: {
                    return 451;
                }
                case 23915: {
                    return 452;
                }
                case 23916: {
                    return 453;
                }
                case 24129: {
                    return 454;
                }
                case 24130: {
                    return 455;
                }
                case 24131: {
                    return 456;
                }
                case 24133: {
                    return 457;
                }
                case 24135: {
                    return 458;
                }
                case 26376: {
                    return 459;
                }
                case 26377: {
                    return 460;
                }
                case 28416: {
                    return 461;
                }
                case 28417: {
                    return 462;
                }
                case 28418: {
                    return 463;
                }
                case 28419: {
                    return 464;
                }
                case 28420: {
                    return 465;
                }
                case 28421: {
                    return 466;
                }
                case 29446: {
                    return 467;
                }
            }
            if (n >= 16512 && n <= 16639) {
                return 147;
            }
            if (n >= 19712 && n <= 19967) {
                return 260;
            }
            if (n >= 28672 && n <= 28927) {
                return 295;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return n;
        }
    }

    public String getLdState(int n) {
        String string = "";
        System.out.println(n);
        switch (n) {
            case 0: {
                string = Resource.getString("LDRIVE_STATE_OFFLINE", "Offline");
                System.out.println(string);
                break;
            }
            case 1: {
                string = Resource.getString("LDRIVE_STATE_PARTDERGRADED", "Partially Degraded");
                System.out.println(string);
                break;
            }
            case 2: {
                string = Resource.getString("LDRIVE_STATE_DEGRADED", "Degraded");
                System.out.println(string);
                break;
            }
            case 3: {
                string = Resource.getString("LDRIVE_STATE_OPTIMAL", "Optimal");
                System.out.println(string);
            }
        }
        System.out.println("OLD LD STATE::" + string);
        return string;
    }

    public String getPdState(int n) {
        String string = "";
        System.out.println(n);
        switch (n) {
            case 0: {
                string = Resource.getString("PD_STATE_UNCONFGOOD", "Unconfigured Good");
                break;
            }
            case 1: {
                string = Resource.getString("PD_STATE_UNCONFBAD", "Unconfigured Bad");
                break;
            }
            case 16: {
                string = Resource.getString("PD_STATE_OFFLINE", "Offline");
                break;
            }
            case 2: {
                string = Resource.getString("PD_STATE_HOTSPARE", "Hot Spare");
                break;
            }
            case 17: {
                string = Resource.getString("PD_STATE_FAILED", "Failed");
                break;
            }
            case 20: {
                string = Resource.getString("PD_STATE_REBUILD", "Rebuild");
                break;
            }
            case 24: {
                string = Resource.getString("PD_STATE_ONLINE", "Online");
                break;
            }
            case 32: {
                string = Resource.getString("REPLACING_PHYSICAL_DRIVE_INPROGRESS", "Replacing");
                break;
            }
            case 64: {
                string = Resource.getString("PD_STATE_SYSTEM", "Drive is exposed and controlled by hos");
                break;
            }
            case 128: {
                string = Resource.getString("PD_STATE_SHIELD_UNCONFIGURED", "Unconfigured - shielded");
                break;
            }
            case 144: {
                string = Resource.getString("PD_STATE_SHIELD_CONFIGURED", "Configured - shielded");
                break;
            }
            case 130: {
                string = Resource.getString("PD_STATE_SHIELD_HOT_SPARE", "Hot Spare - shielded");
                break;
            }
            case 192: {
                string = Resource.getString("PD_STATE_SHIELD_REPLACING", "Shield Replacing");
            }
        }
        return string;
    }

    public String getcheckAccessPolicy() {
        String string = "";
        char c = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getaccessPolicy();
        char c2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getaccessPolicy();
        String string2 = "";
        String string3 = "";
        if (c != c2) {
            if (c == '\u0000') {
                string2 = Resource.getString("OLD_ACCESS_POLICY1", "Access Policy: Read Write");
            } else if (c == '\u0002') {
                string2 = Resource.getString("OLD_ACCESS_POLICY2", "Access Policy: Read Only");
            } else if (c == '\u0003') {
                string2 = Resource.getString("OLD_ACCESS_POLICY3", "Access Policy: Blocked");
            }
            if (c2 == '\u0000') {
                string3 = Resource.getString("NEW_ACCESS_POLICY1", "Access Policy: Read Write");
            } else if (c2 == '\u0002') {
                string3 = Resource.getString("NEW_ACCESS_POLICY2", "Access Policy: Read Only");
            } else if (c2 == '\u0003') {
                string3 = Resource.getString("NEW_ACCESS_POLICY3", "Access Policy: Blocked");
            }
            string = string2 + "@" + string3;
            System.out.println("accessPolicy:::" + string);
        }
        return string;
    }

    public String getcheckBgi() {
        String string = "";
        char c = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getnoBGI();
        char c2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getnoBGI();
        String string2 = "";
        String string3 = "";
        if (c != c2) {
            if (c == '\u0000') {
                string2 = Resource.getString("OLD_BGI_STATUS1", "BGI: Enabled");
            } else if (c == '\u0001') {
                string2 = Resource.getString("OLD_BGI_STATUS2", "BGI: Disabled");
            }
            if (c2 == '\u0000') {
                string3 = Resource.getString("NEW_BGI_STATUS1", "BGI: Enabled");
            } else if (c2 == '\u0001') {
                string3 = Resource.getString("NEW_BGI_STATUS2", "BGI: Disabled");
            }
            string = string2 + "@" + string3;
            System.out.println("BGI:::" + string);
        }
        return string;
    }

    public String getcheckAutoSnapshot() {
        String string = "";
        byte by = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getautoSnapshot();
        byte by2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getautoSnapshot();
        String string2 = "";
        String string3 = "";
        if (by != by2) {
            if (by == 0) {
                string2 = Resource.getString("OLD_SNAPSHOT_STATUS1", "AutoSnapshot: Disabled");
            } else if (by == 1) {
                string2 = Resource.getString("OLD_SNAPSHOT_STATUS2", "AutoSnapshot: Enabled");
            }
            if (by2 == 0) {
                string3 = Resource.getString("NEW_SNAPSHOT_STATUS1", "AutoSnapshot: Disabled");
            } else if (by2 == 1) {
                string3 = Resource.getString("NEW_SNAPSHOT_STATUS2", "AutoSnapshot: Enabled");
            }
            string = string2 + "@" + string3;
            System.out.println("autoSnapShot::::" + string);
        }
        return string;
    }

    public String getcheckDisableAutoDeleteOldestPIT() {
        String string = "";
        byte by = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getdisableAutoDeleteOldestPIT();
        byte by2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getdisableAutoDeleteOldestPIT();
        String string2 = "";
        String string3 = "";
        if (by != by2) {
            if (by == 0) {
                string2 = "AutoDeleteOldestPIT: Enabled";
            } else if (by == 1) {
                string2 = Resource.getString("OLD_PIT_STATUS2", "AutoDeleteOldestPIT: Disabled");
            }
            if (by2 == 0) {
                string3 = Resource.getString("NEW_PIT_STATUS1", "AutoDeleteOldestPIT: Enabled");
            } else if (by2 == 1) {
                string3 = Resource.getString("NEW_PIT_STATUS2", "AutoDeleteOldestPIT: Disabled");
            }
            string = string2 + "@" + string3;
            System.out.println("disableAutoSS::::" + string);
        }
        return string;
    }

    public String getcheckDiskCachePolicy() {
        char c;
        String string = "";
        char c2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getdiskCachePolicy();
        if (c2 == (c = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getdiskCachePolicy())) {
            return "";
        }
        String string2 = "";
        String string3 = "";
        if (c2 == '\u0000') {
            string2 = Resource.getString("OLD_DISCCACHE_POLICY1", "Disk Cache Policy: Unchanged");
        } else if (c2 == '\u0001') {
            string2 = Resource.getString("OLD_DISCCACHE_POLICY2", "Disk Cache Policy: Enable");
        } else if (c2 == '\u0002') {
            string2 = Resource.getString("OLD_DISCCACHE_POLICY3", "Disk Cache Policy: Disable");
        }
        if (c == '\u0000') {
            string3 = Resource.getString("NEW_DISCCACHE_POLICY1", "Disk Cache Policy: Unchanged");
        } else if (c == '\u0001') {
            string3 = Resource.getString("NEW_DISCCACHE_POLICY2", "Disk Cache Policy: Enable");
        } else if (c == '\u0002') {
            string3 = Resource.getString("NEW_DISCCACHE_POLICY3", "Disk Cache Policy: Disable");
        }
        string = string2 + "@" + string3;
        return string;
    }

    public String getVdAccessState() {
        byte by;
        String string = "";
        byte by2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getnonShared();
        if (by2 == (by = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getnonShared())) {
            return "";
        }
        String string2 = "";
        String string3 = "";
        if (by2 == 0) {
            string2 = "Shared";
            string3 = "Exclusive";
        } else if (by2 == 1) {
            string3 = "Shared";
            string2 = "Exclusive";
        }
        string = string2 + "@" + string3;
        return string;
    }

    public String getcheckDefaultIoPolicy() {
        char c;
        String string = "";
        char c2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getdefaultCachePolicy();
        if (c2 == (c = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getdefaultCachePolicy())) {
            return "";
        }
        int n = c2 & 0x60;
        int n2 = c & 0x60;
        if (n == n2) {
            return "";
        }
        String string2 = "";
        String string3 = "";
        if (n == 0) {
            string2 = Resource.getString("DIRECT_IO_POLICY", "Default IO Policy: Direct IO");
        } else if (n == 96) {
            string2 = Resource.getString("CACHED_IO_POLICY", "Default IO Policy: Cached IO");
        }
        if (n2 == 0) {
            string3 = Resource.getString("DIRECT_IO_POLICY", "Default IO Policy: Direct IO");
        } else if (n2 == 96) {
            string3 = Resource.getString("CACHED_IO_POLICY", "Default IO Policy: Cached IO");
        }
        string = string2 + "@" + string3;
        return string;
    }

    public String getcheckDefaultWriteCachePolicy() {
        char c;
        String string = "";
        char c2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getdefaultCachePolicy();
        if (c2 == (c = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getdefaultCachePolicy())) {
            return "";
        }
        int n = c2 & 0x11;
        int n2 = c & 0x11;
        if (n == n2) {
            return "";
        }
        String string2 = "";
        String string3 = "";
        if (n == 0) {
            string2 = Resource.getString("DEFAULT_WRITE_POLICY1", "Default Write Policy: Write Through");
        } else if (n == 1) {
            string2 = Resource.getString("DEFAULT_WRITE_POLICY2", "Default Write Policy: Write Back");
        } else if (n == 16) {
            string2 = Resource.getString("DEFAULT_WRITE_POLICY3", "Default Write Policy: Write Back for failed or missing battery");
        } else if (n == 17) {
            string2 = Resource.getString("DEFAULT_WRITE_POLICY3", "Default Write Policy: Write Back for failed or missing battery");
        }
        if (n2 == 0) {
            string3 = Resource.getString("DEFAULT_WRITE_POLICY1", "Default Write Policy: Write Through");
        } else if (n2 == 1) {
            string3 = Resource.getString("DEFAULT_WRITE_POLICY2", "Default Write Policy: Write Back");
        } else if (n2 == 16) {
            string3 = Resource.getString("DEFAULT_WRITE_POLICY3", "Default Write Policy: Write Back for failed or missing battery");
        } else if (n2 == 17) {
            string3 = Resource.getString("DEFAULT_WRITE_POLICY3", "Default Write Policy: Write Back for failed or missing battery");
        }
        string = string2 + "@" + string3;
        return string;
    }

    public String getcheckDefaultReadCachePolicy() {
        char c;
        String string = "";
        char c2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getdefaultCachePolicy();
        if (c2 == (c = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getdefaultCachePolicy())) {
            return "";
        }
        int n = c2 & 0xC;
        int n2 = c & 0xC;
        if (n == n2) {
            return "";
        }
        String string2 = "";
        String string3 = "";
        if (n == 0) {
            string2 = Resource.getString("DEFAULT_READ_POLICY1", "Default Read Policy: No Read Ahead");
        } else if (n == 12) {
            string2 = Resource.getString("DEFAULT_READ_POLICY2", "Default Read Policy: Adaptive Read Ahead");
        } else if (n == 4) {
            string2 = Resource.getString("DEFAULT_READ_POLICY3", "Default Read Policy: Always Read Ahead");
        }
        if (n2 == 0) {
            string3 = Resource.getString("DEFAULT_READ_POLICY1", "Default Read Policy: No Read Ahead");
        } else if (n2 == 12) {
            string3 = Resource.getString("DEFAULT_READ_POLICY2", "Default Read Policy: Adaptive Read Ahead");
        } else if (n2 == 4) {
            string3 = Resource.getString("DEFAULT_READ_POLICY3", "Default Read Policy: Always Read Ahead");
        }
        string = string2 + "@" + string3;
        return string;
    }

    public String getcheckCurrentIoPolicy() {
        String string = "";
        System.out.println("inside getcheckCurrentIoPolicy");
        try {
            char c = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getcurrentCachePolicy();
            char c2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getcurrentCachePolicy();
            if (c == c2) {
                return "";
            }
            int n = c & 0x60;
            int n2 = c2 & 0x60;
            if (n == n2) {
                return "";
            }
            String string2 = "";
            String string3 = "";
            if (n == 0) {
                string2 = Resource.getString("DEFAULT_IO_POLICY1", "Default IO Policy: Direct IO");
            } else if (n == 96) {
                string2 = Resource.getString("DEFAULT_IO_POLICY2", "Default IO Policy: Cached IO");
            }
            if (n2 == 0) {
                string3 = Resource.getString("DEFAULT_IO_POLICY1", "Default IO Policy: Direct IO");
            } else if (n2 == 96) {
                string3 = Resource.getString("DEFAULT_IO_POLICY2", "Default IO Policy: Cached IO");
            }
            string = string2 + "@" + string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String getcheckCurrentWriteCachePolicy() {
        String string = "";
        char c = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getcurrentCachePolicy();
        char c2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getcurrentCachePolicy();
        System.out.println("oldDefCachePolicy==" + c);
        System.out.println("newDefCachePolicy==" + c2);
        if (c == c2) {
            System.out.println("oldDefCachePolicy==newDefCachePolicy");
            return "";
        }
        System.out.println("BEFORE oldWriteCachePolicy");
        int n = c & 0x11;
        int n2 = c2 & 0x11;
        System.out.println("After oldWriteCachePolicy");
        if (n == n2) {
            return "";
        }
        String string2 = "";
        String string3 = "";
        if (n == 0) {
            string2 = Resource.getString("CURRENT_WRITE_POLICY1", "Current Write Policy: Write Through");
            System.out.println("oldWriteCachePolicy==" + n);
        } else if (n == 1) {
            string2 = Resource.getString("CURRENT_WRITE_POLICY2", "Current Write Policy: Write Back");
        } else if (n == 16) {
            string2 = Resource.getString("CURRENT_WRITE_POLICY3", "Current Write Policy: Write Back for failed or missing battery");
        } else if (n == 17) {
            string2 = Resource.getString("CURRENT_WRITE_POLICY3", "Current Write Policy: Write Back for failed or missing battery");
        }
        if (n2 == 0) {
            string3 = Resource.getString("CURRENT_WRITE_POLICY1", "Current Write Policy: Write Through");
        } else if (n2 == 1) {
            string3 = Resource.getString("CURRENT_WRITE_POLICY2", "Current Write Policy: Write Back");
        } else if (n2 == 16) {
            string3 = Resource.getString("CURRENT_WRITE_POLICY3", "Current Write Policy: Write Back for failed or missing battery");
        } else if (n2 == 17) {
            string3 = Resource.getString("CURRENT_WRITE_POLICY3", "Current Write Policy: Write Back for failed or missing battery");
        }
        string = string2 + "@" + string3;
        return string;
    }

    public String getcheckCurrentReadCachePolicy() {
        char c;
        String string = "";
        char c2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getcurrentCachePolicy();
        if (c2 == (c = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getcurrentCachePolicy())) {
            return "";
        }
        int n = c2 & 0xC;
        int n2 = c & 0xC;
        if (n == n2) {
            return "";
        }
        String string2 = "";
        String string3 = "";
        if (n == 0) {
            string2 = Resource.getString("CURRENT_READ_POLICY1", "Current Read Policy: No Read Ahead");
        } else if (n == 12) {
            string2 = Resource.getString("CURRENT_READ_POLICY2", "Current Read Policy: Adaptive Read Ahead");
        } else if (n == 4) {
            string2 = Resource.getString("CURRENT_READ_POLICY3", "Current Read Policy: Always Read Ahead");
        }
        if (n2 == 0) {
            string3 = Resource.getString("CURRENT_READ_POLICY1", "Current Read Policy: No Read Ahead");
        } else if (n2 == 12) {
            string3 = Resource.getString("CURRENT_READ_POLICY2", "Current Read Policy: Adaptive Read Ahead");
        } else if (n2 == 4) {
            string3 = Resource.getString("CURRENT_READ_POLICY3", "Current Read Policy: Always Read Ahead");
        }
        string = string2 + "@" + string3;
        return string;
    }

    public String getDefaultPSPolicy() {
        String string = "";
        byte by = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getdefaultPSPolicy();
        byte by2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getdefaultPSPolicy();
        String string2 = "";
        String string3 = "";
        if (by == by2) {
            return "";
        }
        string2 = by == 0 ? Resource.getString("DEFAULT_PS_POLICY1", "Default Power Save Policy: Controller Defined") : (by == 1 ? Resource.getString("DEFAULT_PS_POLICY2", "Default Power Save Policy: Auto") : (by == 2 ? Resource.getString("DEFAULT_PS_POLICY3", "Default Power Save Policy: Max") : (by == 4 ? Resource.getString("DEFAULT_PS_POLICY4", "Default Power Save Policy: Dont Cache") : (by == 6 ? Resource.getString("DEFAULT_PS_POLICY5", "Default Power Save Policy:  Max without Cache") : Resource.getString("DEFAULT_PS_POLICY6", "Default Power Save Policy:  None")))));
        if (by2 == 0) {
            string3 = string3 + Resource.getString("DEFAULT_PS_POLICY1", "Default Power Save Policy: Controller Defined");
        } else if (by2 == 1) {
            string3 = string3 + Resource.getString("DEFAULT_PS_POLICY2", "Default Power Save Policy: Auto");
        } else if (by2 == 2) {
            string2 = Resource.getString("CURRENT_PS_POLICY3", "Default Power Save Policy: Max");
            string3 = string3 + string2;
        } else {
            string3 = by2 == 4 ? string3 + Resource.getString("DEFAULT_PS_POLICY4", "Default Power Save Policy: Dont Cache") : (by2 == 6 ? string3 + Resource.getString("DEFAULT_PS_POLICY5", "Default Power Save Policy:  Max without Cache") : string3 + Resource.getString("DEFAULT_PS_POLICY6", "Default Power Save Policy:  None"));
        }
        string = string2 + "@" + string3;
        return string;
    }

    public String getCurrentPSPolicy() {
        String string = "";
        byte by = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getprevProp().getcurrentPSPolicy();
        byte by2 = this.eventDetail.getevtDetail().getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp().getcurrentPSPolicy();
        String string2 = "";
        String string3 = "";
        if (by == by2) {
            return "";
        }
        string2 = by == 0 ? Resource.getString("CURRENT_PS_POLICY1", "Current Power Save Policy:   Controller Defined") : (by == 1 ? Resource.getString("CURRENT_PS_POLICY2", "Current Power Save Policy:  Auto") : (by == 2 ? Resource.getString("CURRENT_PS_POLICY3", "Current Power Save Policy:   Max") : (by == 4 ? Resource.getString("CURRENT_PS_POLICY4", "Current Power Save Policy:   Dont Cache") : (by == 6 ? Resource.getString("CURRENT_PS_POLICY5", "Current Power Save Policy:   Max without Cache") : Resource.getString("CURRENT_PS_POLICY6", "Current Power Save Policy:  None")))));
        string3 = by2 == 0 ? string3 + Resource.getString("CURRENT_PS_POLICY1", "Current Power Save Policy:   Controller Defined") : (by2 == 1 ? string3 + Resource.getString("CURRENT_PS_POLICY2", "Current Power Save Policy:  Auto") : (by2 == 2 ? string3 + Resource.getString("CURRENT_PS_POLICY3", "Current Power Save Policy:   Max") : (by2 == 4 ? string3 + Resource.getString("CURRENT_PS_POLICY4", "Current Power Save Policy:   Dont Cache") : (by2 == 6 ? string3 + Resource.getString("CURRENT_PS_POLICY5", "Current Power Save Policy:   Max without Cache") : string3 + Resource.getString("CURRENT_PS_POLICY6", "Current Power Save Policy:  None")))));
        string = string2 + "@" + string3;
        return string;
    }

    public void updateEvent() {
        Object object;
        Object object2;
        Object[] objectArray;
        System.out.println("Inside Update event in JLogger");
        System.out.println("Ctrl ID -> " + this.eventDetail.getctrlId());
        int n = this.eventDetail.getevtDetail().getcode();
        String string = "";
        int n2 = 0;
        try {
            objectArray = Integer.toString(n);
            try {
                n2 = m_eventConfig.get(new Integer(n));
            }
            catch (Exception exception) {
                n2 = 0;
            }
            if (n2 == 0) {
                return;
            }
            string = this.getEventinStringFormat();
        }
        catch (Exception exception) {
            System.out.println("Exception in getting the Event Dercription");
            exception.printStackTrace();
        }
        objectArray = new Object[5];
        StringBuffer stringBuffer = new StringBuffer("");
        objectArray[0] = this.eventDetail.getevtDetail().getcode();
        ArrayList<Comparable<StringBuffer>> arrayList = new ArrayList<Comparable<StringBuffer>>();
        int n3 = this.eventDetail.getevtDetail().getcl().geteventClass();
        if (n3 == -1) {
            return;
        }
        try {
            n3 = m_eventSeverity.get(new Integer(this.eventDetail.getevtDetail().getcode()));
        }
        catch (Exception exception) {
            n3 = 0;
        }
        if (n3 == 0) {
            stringBuffer.append(Resource.getString("INFO", "Information"));
        } else if (n3 == 1) {
            stringBuffer.append(Resource.getString("WARN", "Warning"));
        } else if (n3 == 2) {
            stringBuffer.append(Resource.getString("CRTL", "ERROR"));
        } else if (n3 == 3) {
            stringBuffer.append(Resource.getString("FATAL", "Fatal"));
        } else if (n3 == 4) {
            stringBuffer.append(Resource.getString("DEAD", "Dead"));
        } else {
            stringBuffer.append(Resource.getString("INFO", "Information"));
        }
        arrayList.add(stringBuffer);
        arrayList.add(1, Integer.valueOf(n3));
        objectArray[1] = arrayList;
        if (this.eventDetail.getevtDetail().gettimeStamp() == 0) {
            objectArray[2] = Resource.getString("TEXT_NOT_AVAILABLE", "Not available");
        } else {
            object2 = KernelConstants.getTimeStamp(this.eventDetail.getevtDetail().gettimeStamp());
            System.out.println(KernelConstants.getTimeStamp(this.eventDetail.getevtDetail().gettimeStamp()).toString());
            object = " " + ((MR_TIME_STAMP)object2).getyear() + "-" + (((MR_TIME_STAMP)object2).getmonth() + 1) + "-" + ((MR_TIME_STAMP)object2).getday() + "," + ((MR_TIME_STAMP)object2).gethour() + ":" + ((MR_TIME_STAMP)object2).getmin() + ":" + ((MR_TIME_STAMP)object2).getsec();
            System.out.println((String)object);
            StringBuffer stringBuffer2 = new StringBuffer("");
            stringBuffer2.append(((MR_TIME_STAMP)object2).getyear() + "-");
            if (((MR_TIME_STAMP)object2).getmonth() + 1 <= 9) {
                stringBuffer2.append("0" + (((MR_TIME_STAMP)object2).getmonth() + 1) + "-");
            } else {
                stringBuffer2.append(((MR_TIME_STAMP)object2).getmonth() + 1 + "-");
            }
            if (((MR_TIME_STAMP)object2).getday() <= 9) {
                stringBuffer2.append("0" + ((MR_TIME_STAMP)object2).getday() + "," + " ");
            } else {
                stringBuffer2.append(((MR_TIME_STAMP)object2).getday() + "," + " ");
            }
            if (((MR_TIME_STAMP)object2).gethour() == 0) {
                stringBuffer2.append("00:");
            } else {
                float f = ((MR_TIME_STAMP)object2).gethour();
                if (f <= 9.0f && f != 0.0f) {
                    stringBuffer2.append("0" + ((MR_TIME_STAMP)object2).gethour() + ":");
                } else {
                    stringBuffer2.append(((MR_TIME_STAMP)object2).gethour() + ":");
                }
            }
            if (((MR_TIME_STAMP)object2).getmin() <= 9) {
                stringBuffer2.append("0" + ((MR_TIME_STAMP)object2).getmin() + ":");
            } else {
                stringBuffer2.append(((MR_TIME_STAMP)object2).getmin() + ":");
            }
            if (((MR_TIME_STAMP)object2).getsec() <= 9) {
                stringBuffer2.append("0" + ((MR_TIME_STAMP)object2).getsec());
            } else {
                stringBuffer2.append(((MR_TIME_STAMP)object2).getsec());
            }
            objectArray[2] = stringBuffer2.toString();
        }
        objectArray[3] = string;
        objectArray[4] = new Integer(this.getNumRecords() + 1);
        if (mode == 1) {
            object2 = (Vector)this.logHash.get("serverLog");
            object = new Vector<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                ((Vector)object).add(objectArray[i]);
            }
            ((Vector)object2).add(0, object);
        } else {
            this.prepend(objectArray);
        }
    }

    public static int getCurrentMode() {
        return mode;
    }

    public String gettimeStamp(int n) {
        MR_TIME_STAMP mR_TIME_STAMP = KernelConstants.getTimeStamp(n);
        System.out.println(KernelConstants.getTimeStamp(this.eventDetail.getevtDetail().gettimeStamp()).toString());
        String string = " " + mR_TIME_STAMP.getyear() + "-" + (mR_TIME_STAMP.getmonth() + 1) + "-" + mR_TIME_STAMP.getday() + "," + mR_TIME_STAMP.gethour() + ":" + mR_TIME_STAMP.getmin() + ":" + mR_TIME_STAMP.getsec();
        System.out.println(string);
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(mR_TIME_STAMP.getyear() + "-");
        if (mR_TIME_STAMP.getmonth() + 1 <= 9) {
            stringBuffer.append("0" + (mR_TIME_STAMP.getmonth() + 1) + "-");
        } else {
            stringBuffer.append(mR_TIME_STAMP.getmonth() + 1 + "-");
        }
        if (mR_TIME_STAMP.getday() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.getday() + "," + " ");
        } else {
            stringBuffer.append(mR_TIME_STAMP.getday() + "," + " ");
        }
        if (mR_TIME_STAMP.gethour() == 0) {
            stringBuffer.append("00:");
        } else if (mR_TIME_STAMP.gethour() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.gethour() + ":");
        } else {
            stringBuffer.append(mR_TIME_STAMP.gethour() + ":");
        }
        if (mR_TIME_STAMP.getmin() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.getmin() + ":");
        } else {
            stringBuffer.append(mR_TIME_STAMP.getmin() + ":");
        }
        if (mR_TIME_STAMP.getsec() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.getsec());
        } else {
            stringBuffer.append(mR_TIME_STAMP.getsec());
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    public void updateKernelEvent(String string) {
        Object[] objectArray = new Object[5];
        StringBuffer stringBuffer = new StringBuffer("");
        LogXMLParser logXMLParser = new LogXMLParser(string);
        objectArray[0] = logXMLParser.getEventID();
        ArrayList<Comparable<StringBuffer>> arrayList = new ArrayList<Comparable<StringBuffer>>();
        stringBuffer.append(Resource.getString("INFO", "Information"));
        arrayList.add(stringBuffer);
        arrayList.add(1, Integer.valueOf(0));
        objectArray[1] = arrayList;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer2.append(Integer.toString(gregorianCalendar.get(1)));
        stringBuffer2.append("-" + decimalFormat.format(gregorianCalendar.get(2) + 1));
        stringBuffer2.append("-" + decimalFormat.format(gregorianCalendar.get(5)));
        stringBuffer2.append("," + decimalFormat.format(gregorianCalendar.get(11)));
        stringBuffer2.append(":" + decimalFormat.format(gregorianCalendar.get(12)));
        stringBuffer2.append(":" + decimalFormat.format(gregorianCalendar.get(13)));
        objectArray[2] = new String(stringBuffer2);
        objectArray[3] = this.getEventinLocFormat(string);
        objectArray[4] = new Integer(this.getNumRecords() + 1);
        this.prepend(objectArray);
    }

    public void updateVivaldiLogConfig(ArrayList arrayList) {
        String string = "";
        String string2 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = (String)arrayList.get(i);
            try {
                int n = string.indexOf("=");
                if (n == -1) continue;
                int n2 = Integer.parseInt(string.substring(0, n).trim());
                string2 = string.substring(n + 1, string.length());
                int n3 = string2.indexOf(";");
                if (n3 != -1) {
                    int n4 = Integer.parseInt(string2.substring(0, n3).trim());
                    int n5 = Integer.parseInt(string2.substring(n3 + 1, string2.length()).trim());
                    m_eventConfig.put(new Integer(n2), new Integer(n4));
                    m_eventSeverity.put(new Integer(n2), new Integer(n5));
                    continue;
                }
                m_eventConfig.put(new Integer(n2), new Integer(0));
                m_eventSeverity.put(new Integer(n2), new Integer(0));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ColorRenderer
    extends DefaultTableCellRenderer {
        private final Color[] colors = new Color[]{ColorHash.getColor("LOG_INFO_COLOR"), ColorHash.getColor("LOG_WARNING_COLOR"), ColorHash.getColor("LOG_ERROR_COLOR"), ColorHash.getColor("LOG_FATAL_COLOR"), ColorHash.getColor("LOG_DEAD_COLOR")};

        private ColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if ((n2 = jTable.convertColumnIndexToModel(n2)) == 1) {
                this.setText(((ArrayList)object).get(0) + "");
            } else {
                this.setText(object + "");
            }
            ArrayList arrayList = (ArrayList)jTable.getValueAt(n, jTable.convertColumnIndexToView(1));
            int n3 = Integer.parseInt(arrayList.get(1) + "");
            if (n3 < 0 || n3 >= this.colors.length) {
                n3 = 0;
            }
            Color color = this.colors[n3];
            this.setForeground(color);
            return component;
        }
    }
}

