/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.VivaldiBaseDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASLogical.SASArray;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JoinMirrorDialog
extends VivaldiBaseDialog {
    private JRadioButton joinRadioButton = null;
    private JRadioButton newVDRadioButton = null;
    private ArrayHelper m_arrayHelper;

    public JoinMirrorDialog(ArrayHelper arrayHelper) {
        this.m_arrayHelper = arrayHelper;
        this.buildUI();
    }

    private void buildUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        String[] stringArray = null;
        ButtonGroup buttonGroup = new ButtonGroup();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 15, 0, 0);
        jPanel.add((Component)new JLabel(Resource.getString("DESCRIPTION_JOIN_MIRROR_SUMMARY")), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_JOIN", "Join the mirror arm with existing virtual drive"));
        this.joinRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.joinRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.joinRadioButton.setToolTipText(Resource.getString("TOOLTIP_JOIN_BUTTON", "Join the mirror arm with existing virtual drive"));
        this.joinRadioButton.setSelected(true);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)this.joinRadioButton, gridBagConstraints);
        buttonGroup.add(this.joinRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 0, 15);
        jPanel.add((Component)new JLabel(Resource.getString("DESCRIPTION_JOIN_MIRROR", " <html> This option ensures that the data will be copied from drives in the existing virtual <br>drives in the system to the drives that are brought in as part of the mirror to be.<br><br></html>")), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_NEW_VD", "Bring the mirror arm as a new virtual drive"));
        this.newVDRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.newVDRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.newVDRadioButton.setToolTipText(Resource.getString("TOOLTIP_NEW_VD_BUTTON", "Bring the mirror arm as a new virtual drive"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        if (this.maxVDLimitReached()) {
            this.newVDRadioButton.setEnabled(false);
        }
        jPanel.add((Component)this.newVDRadioButton, gridBagConstraints);
        buttonGroup.add(this.newVDRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 0, 15);
        gridBagConstraints.gridwidth = 5;
        JLabel jLabel = new JLabel();
        if (this.maxVDLimitReached()) {
            jLabel.setText(Resource.getString("DESCRIPTION_NEW_VD_GRAYED_OUT", "<html> <font color=gray> This option ensures that a new virtual drive will be created with the drive arms and<br>the virtual drive will be in degrated state until there is suffificent hot spare drives in <br>the system to make the newly added virtual drive to optimal state.<br><br></html> "));
            jLabel.setEnabled(false);
        } else {
            jLabel.setText(Resource.getString("DESCRIPTION_NEW_VD", "<html> This option ensures that a new virtual drive will be created with the drive arms and<br>the virtual drive will be in degrated state until there is suffificent hot spare drives in <br>the system to make the newly added virtual drive to optimal state.<br><br></html> "));
        }
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 10, 10));
        stringArray = Resource.getResourceMnemonic(Resource.getString("OK_BUTTON_TEXT", "(O)K"));
        JButton jButton = new JButton(stringArray[0]);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "(C)ancel"));
        JButton jButton2 = new JButton(stringArray[0]);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(25, 0, 15, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JoinMirrorDialog.this.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JoinMirrorDialog.this.dispose();
                OperationDetails operationDetails = null;
                if (JoinMirrorDialog.this.joinRadioButton.isSelected()) {
                    if (CustomMsgBox.confirm(Resource.getString("CONFIRM_JOIN", "<html>The data in the existing virtual drives will be copied to the drives that<br>are brought in as part of the mirrored drives.<br><br>Are you sure you want to perform this operation?<br></html>"))) {
                        JoinMirrorDialog.this.dispose();
                        SASArray sASArray = (SASArray)JoinMirrorDialog.this.m_arrayHelper.getDeviceObject();
                        operationDetails = new OperationDetails(0x3110300, sASArray.getInformation());
                        operationDetails.setArgument(0);
                        try {
                            sASArray.fireOperation(operationDetails);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                } else if (JoinMirrorDialog.this.newVDRadioButton != null & JoinMirrorDialog.this.newVDRadioButton.isSelected() && CustomMsgBox.confirm(Resource.getString("CONFIRM_NEW_VD", "<html> A new virtual drive will be created with the selected drive arm and the<br>virtual drive will be in degraded state until a hot spare drive available to<br>replace it.<br><br>Are you sure you want to perform this operation?<br></html>"))) {
                    JoinMirrorDialog.this.dispose();
                    SASArray sASArray = (SASArray)JoinMirrorDialog.this.m_arrayHelper.getDeviceObject();
                    operationDetails = new OperationDetails(0x3110300, sASArray.getInformation());
                    operationDetails.setArgument(2);
                    try {
                        sASArray.fireOperation(operationDetails);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.add(jPanel);
        this.setTitle(Resource.getString("JOIN_MIRROR_TITLE", "Join Mirror - Choose Option"));
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    private boolean maxVDLimitReached() {
        AdapterHelper adapterHelper = (AdapterHelper)this.m_arrayHelper.getParent();
        LogicalDriveHelper[] logicalDriveHelperArray = adapterHelper.getLogicalDrives();
        return adapterHelper.MAX_LOGICAL_DRIVES - logicalDriveHelperArray.length <= 0;
    }
}

