/*
 * Decompiled with CFR 0.152.
 */
package GUI.LDAP;

import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUI.VivaldiStartupSettings;
import Utils.ColorHash;
import Utils.CustomJOptionDialog;
import Utils.HelpContextResourse;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextField;

public class LDAPLoginDialog
extends VivaldiBaseDialog
implements HelpInterface {
    private JLabel ldapServerIPLabel;
    private JTextField ldapServerIP;
    private JLabel userNameLabel;
    private JTextField userName;
    private JLabel passwordLabel;
    private JPasswordField password;
    private JLabel domainLabel;
    private JTextField domain;
    private JLabel portLabel;
    private JTextField port;
    private JCheckBox defaultPortCheckBox;
    private JCheckBox rememberCheckBox;
    private JRootPane rootPane;
    private JButton defaultButton;
    private JPanel content = new JPanel();
    private JPanel defaultpanel = new JPanel();
    private boolean isRememeberChkSelected = false;
    public JButton loginButton;
    public JButton cancelButton;
    public static final String DEFAULT_PORT = "389";

    public LDAPLoginDialog() {
        super((Frame)null);
        int n;
        int n2;
        this.addComponents();
        this.getLDAPProperties();
        this.contentPane.add((Component)this.content, "Center");
        this.setModal(true);
        int n3 = MainFrame.SCREEN_SIZE.height > 700 ? (MainFrame.SCREEN_SIZE.height > 900 ? 225 : 275) : (n2 = 310);
        if (VivaldiStartupDialog.OEM_TYPE == 98761) {
            n = 500;
            this.banner.setPreferredSize(new Dimension(n, (int)this.banner.getDimension().getHeight()));
        } else {
            n = MainFrame.SCREEN_SIZE.width > 1100 ? 412 : 450;
        }
        this.setSize(MainFrame.SCREEN_SIZE.width * n / 1024, MainFrame.SCREEN_SIZE.height * n2 / 768);
        this.pack();
        this.setResizable(false);
        this.ldapServerIP.requestFocus();
    }

    private void addComponents() {
        this.ldapServerIP = new JTextField(15);
        this.userName = new JTextField(15);
        this.password = new JPasswordField(15);
        this.domain = new JTextField(15);
        this.ldapServerIP.addKeyListener(this);
        this.userName.addKeyListener(this);
        this.password.addKeyListener(this);
        this.domain.addKeyListener(this);
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_LOGIN_TEXT", "Login"));
        this.loginButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.loginButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.cancelButton = new JButton(Resource.getString("BUTTON_CANCEL_TEXT", "Cancel"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LDAP_SERVERIP_TEXT", "LDAP Server IP Address:"));
        this.ldapServerIPLabel = new JLabel(stringArray[0], 2);
        if (stringArray.length == 2) {
            this.ldapServerIPLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("USERNAME_TEXT", "User Name:"));
        this.userNameLabel = new JLabel(stringArray[0], 2);
        if (stringArray.length == 2) {
            this.userNameLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.userNameLabel.setLabelFor(this.userName);
        stringArray = Resource.getResourceMnemonic(Resource.getString("PASSWORD_TEXT", "Password:"));
        this.passwordLabel = new JLabel(stringArray[0], 2);
        if (stringArray.length == 2) {
            this.passwordLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.passwordLabel.setLabelFor(this.password);
        stringArray = Resource.getResourceMnemonic(Resource.getString("DEFAULT_PORT_TEXT", "Port:"));
        this.portLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            this.portLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("DEFAULT_PORT_CHECKBOX_TEXT", "Use Default Port"));
        this.defaultPortCheckBox = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            this.defaultPortCheckBox.setMnemonic(stringArray[1].charAt(0));
        }
        this.defaultPortCheckBox.setSelected(true);
        this.port = new JTextField(5);
        this.port.setEnabled(false);
        this.port.setText(DEFAULT_PORT);
        this.defaultPortCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LDAPLoginDialog.this.defaultPortCheckBox.isSelected()) {
                    LDAPLoginDialog.this.port.setEnabled(false);
                    LDAPLoginDialog.this.port.setText(LDAPLoginDialog.DEFAULT_PORT);
                    if (LDAPLoginDialog.this.ldapServerIP.getText().trim().equals("") || LDAPLoginDialog.this.domain.getText().trim().equals("") || LDAPLoginDialog.this.userName.getText().trim().equals("") || new String(LDAPLoginDialog.this.password.getPassword()).trim().equals("")) {
                        LDAPLoginDialog.this.loginButton.setEnabled(false);
                    } else {
                        LDAPLoginDialog.this.loginButton.setEnabled(true);
                    }
                } else {
                    LDAPLoginDialog.this.port.setEnabled(true);
                    LDAPLoginDialog.this.port.setText(VivaldiStartupSettings.getLDAPServerPort());
                    if (LDAPLoginDialog.this.ldapServerIP.getText().trim().equals("") || LDAPLoginDialog.this.port.getText().trim().equals("") || LDAPLoginDialog.this.domain.getText().trim().equals("") || LDAPLoginDialog.this.userName.getText().trim().equals("") || new String(LDAPLoginDialog.this.password.getPassword()).trim().equals("")) {
                        LDAPLoginDialog.this.loginButton.setEnabled(false);
                    }
                }
            }
        });
        stringArray = Resource.getResourceMnemonic(Resource.getString("DISTINGUISHED_NAME_TEXT", "Distinguished Name:"));
        this.domainLabel = new JLabel(stringArray[0], 2);
        if (stringArray.length == 2) {
            this.domainLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.domainLabel.setLabelFor(this.domain);
        this.setTitle(Resource.getString("LDAP_AUTHENTICATE_DIALOG_TITLE", "LDAP Login"));
        this.content.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 14, 10);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.content.add((Component)this.ldapServerIPLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.content.add((Component)this.ldapServerIP, gridBagConstraints);
        String string = Resource.getString("LDAP_LOGIN_TIP", "<html>Use your LDAP server <br> credentials to login</html>");
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 4, 5, 10);
        this.content.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 4, 14, 10);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.content.add((Component)this.userNameLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.userName);
        JButton jButton = new JButton();
        ImageIcon imageIcon = Resource.getImage("TIPIMAGE", "Help16.png");
        jButton.setOpaque(false);
        jButton.setIcon(imageIcon);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setHorizontalAlignment(2);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = Resource.getString("LDAP_DIALOG_TIPS_TO_LOGIN", " <html> Enter the IP address of the LDAP server in the LDAP Server IP Address field.<br> <br> Enter the LDAP server's user name and password in the User Name and Password fields respectively.<br> An example of a user name can be username@testldap.com. Based on the privileges alloted to you,<br> the MegaRAID Storage Manager servers are launched with full access rights or read only rights.<br> <br> Enter the name of the Domain Controller in the Distinguished Name field.<br> An example of a  Domain Controller name can be dc= TESTLDAP, dc=com. <br> <br>Select the Use Default Port check box to use the default port number. <br>If you do not want to use the default port number, uncheck the Use Default Port check box <br> and enter a port number in the Port field.<br><br>Select the Remember my Login Details check box to save all the values entered in this dialog. </html>");
                Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                int n = CustomJOptionDialog.showDialog(Resource.getString("LDAP_DIALOG_TIPS_TO_LOGIN_TITLE", "Tips To Login"), image, string, 1, 99, 99);
            }
        });
        jPanel.add(jButton);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 14, 10);
        this.content.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 4, 14, 10);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.content.add((Component)this.passwordLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.userName.setNextFocusableComponent(this.password);
        this.content.add((Component)this.password, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 4, 14, 10);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.content.add((Component)this.domainLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.content.add((Component)this.domain, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.defaultpanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.portLabel);
        jPanel2.add(this.port);
        this.content.add((Component)this.defaultPortCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.content.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 4, 14, 10);
        ++gridBagConstraints.gridy;
        stringArray = Resource.getResourceMnemonic(Resource.getString("REMEMBER_CHECKBOX_TEXT", "Remember my Login Details"));
        this.rememberCheckBox = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            this.rememberCheckBox.setMnemonic(stringArray[1].charAt(0));
        }
        this.content.add((Component)this.rememberCheckBox, gridBagConstraints);
        this.rememberCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    LDAPLoginDialog.this.isRememeberChkSelected = true;
                } else {
                    LDAPLoginDialog.this.isRememeberChkSelected = false;
                }
            }
        });
        this.userNameLabel.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
        this.rootPane = this.getRootPane();
        this.ldapServerIPLabel.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
        this.passwordLabel.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
        this.portLabel.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
        this.content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.loginButton);
        jPanel3.add(this.cancelButton);
        this.defaultButton = this.loginButton;
        this.rootPane.setDefaultButton(this.defaultButton);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (focusEvent.getSource() instanceof JTextField) {
                    JTextField jTextField = (JTextField)focusEvent.getSource();
                    jTextField.setSelectionStart(0);
                    jTextField.setSelectionEnd(jTextField.getText().length());
                } else if (focusEvent.getSource() instanceof JButton) {
                    LDAPLoginDialog.this.defaultButton = (JButton)focusEvent.getSource();
                    LDAPLoginDialog.this.rootPane.setDefaultButton(LDAPLoginDialog.this.defaultButton);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getSource() instanceof JButton) {
                    LDAPLoginDialog.this.defaultButton = LDAPLoginDialog.this.loginButton;
                    LDAPLoginDialog.this.rootPane.setDefaultButton(LDAPLoginDialog.this.defaultButton);
                }
            }
        };
        this.userName.addFocusListener(focusAdapter);
        this.password.addFocusListener(focusAdapter);
        this.loginButton.addFocusListener(focusAdapter);
        this.cancelButton.addFocusListener(focusAdapter);
        this.contentPane.add((Component)jPanel3, "South");
    }

    private void getLDAPProperties() {
        this.ldapServerIP.setText(VivaldiStartupSettings.getLDAPServerIP());
        this.userName.setText(VivaldiStartupSettings.getLDAPServerUserName());
        this.password.setText(VivaldiStartupSettings.getLDAPServerPassword());
        this.domain.setText(VivaldiStartupSettings.getLDAPServerDomainName());
        String string = VivaldiStartupSettings.getLDAPServerPort();
        if (string != null && !string.equals(DEFAULT_PORT)) {
            this.port.setText(string);
            this.port.setEnabled(true);
            this.defaultPortCheckBox.setSelected(false);
        }
    }

    public void setLDAPProperties() {
        VivaldiStartupSettings.setLDAPServerIP(this.ldapServerIP.getText());
        VivaldiStartupSettings.setLDAPServerUserName(this.userName.getText());
        VivaldiStartupSettings.setLDAPServerPassword(new String(this.password.getPassword()));
        VivaldiStartupSettings.setLDAPServerDomainName(this.domain.getText());
        VivaldiStartupSettings.setLDAPServerPort(this.port.getText());
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.ldapServerIP.getText().trim().equals("") || this.port.getText().trim().equals("") || this.domain.getText().trim().equals("") || this.userName.getText().trim().equals("") || new String(this.password.getPassword()).trim().equals("")) {
            this.loginButton.setEnabled(false);
        } else {
            this.loginButton.setEnabled(true);
        }
    }

    public boolean getLoginButtonState() {
        return !this.ldapServerIP.getText().trim().equals("") && !this.port.getText().trim().equals("") && !this.domain.getText().trim().equals("") && !this.userName.getText().trim().equals("") && !new String(this.password.getPassword()).trim().equals("");
    }

    public String getServerIP() {
        return this.ldapServerIP.getText();
    }

    public String getUserName() {
        return this.userName.getText();
    }

    public String getPassword() {
        return new String(this.password.getPassword());
    }

    public String getDomain() {
        return this.domain.getText();
    }

    public Short getPort() {
        if (this.defaultPortCheckBox.isSelected()) {
            return new Short(DEFAULT_PORT);
        }
        return new Short(this.port.getText());
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("MR_LDAP_SUPPORT");
    }

    public void setButtonFocus() {
        this.defaultButton = this.loginButton;
        this.rootPane.setDefaultButton(this.defaultButton);
    }

    public void setUserName(JTextField jTextField) {
        this.userName = jTextField;
    }

    public void setPassword(JPasswordField jPasswordField) {
        this.password = jPasswordField;
    }

    public void setDomain(JTextField jTextField) {
        this.domain = jTextField;
    }

    public void setPort(JTextField jTextField) {
        this.port = jTextField;
    }

    public boolean isRememberCheckBoxSelected() {
        return this.isRememeberChkSelected;
    }
}

