/*
 * Decompiled with CFR 0.152.
 */
package GUI.LDAP;

import Utils.Resource;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.swing.JOptionPane;

public class MSMServerDiscovery {
    public DirContext ldapServerContext = null;
    private String ipAddress;
    private String userName;
    private String password;
    private String domain;
    private short port;
    private String ldapUserRole;
    private static final String ROOT_CONTEXT = "CN=Computers";
    private static final String OU_ATTRIBUTE = "ou=MSM";
    private static final String USERS_CONTEXT = "CN=Users";

    public MSMServerDiscovery(String string, String string2, String string3, String string4, short s) {
        this.ipAddress = string;
        this.domain = string2;
        this.userName = string3;
        this.password = string4;
        this.port = s;
    }

    public int connectToServer() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = new String("ldap://" + this.ipAddress + ":" + this.port + "/" + this.domain);
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string);
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", this.userName);
        hashtable.put("java.naming.security.credentials", this.password);
        hashtable.put("java.naming.referral", "follow");
        try {
            this.ldapServerContext = new InitialDirContext(hashtable);
            this.ldapServerContext.lookup(string);
        }
        catch (NamingException namingException) {
            if (namingException.getMessage().contains("error code 49") && (namingException.getMessage().contains("data 525") || namingException.getMessage().contains("data 52e"))) {
                JOptionPane.showMessageDialog(null, Resource.getString("ERROR_INVALID_LDAP_CREDENTIALS", "The user name or password that you have entered is incorrect. Please try again."), null, 0);
            } else if (namingException.getMessage().contains("Invalid name")) {
                JOptionPane.showMessageDialog(null, Resource.getString("ERROR_INVALID_LDAP_DOMAIN_NAME", "The Distinguished Name you entered is incorrect."), null, 0);
            } else if (namingException.getMessage().contains("socket closed")) {
                JOptionPane.showMessageDialog(null, Resource.getString("ERROR_INVALID_LDAP_PORT", "The port number that you have entered is invalid."), null, 0);
            } else if (namingException.getMessage().contains("Connection refused")) {
                JOptionPane.showMessageDialog(null, Resource.getString("ERROR_INVALID_LDAP_URL", "Incorrect LDAP url"), null, 0);
            } else if (namingException.getMessage().contains("error code 49") && namingException.getMessage().contains("data 532")) {
                JOptionPane.showMessageDialog(null, Resource.getString("ERROR_INVALID_LDAP_PASSWORD", "Your password has expired. You must change your password to login to LDAP server."), null, 0);
            } else {
                JOptionPane.showMessageDialog(null, Resource.getString("ERROR_INVALID_LDAP_DETAILS", "You have entered incorrect LDAP details. Please try again."), null, 0);
            }
            return -1;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "You have entered incorrect LDAP details. Please try again. ", null, 0);
            System.out.println("Exception while authenticating LDAP Server.");
            return -1;
        }
        return 1;
    }

    public String getUserRole(String string) {
        String string2 = "(&(objectClass=user)(" + string + "))";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string3 = null;
        try {
            NamingEnumeration<SearchResult> namingEnumeration = this.ldapServerContext.search(USERS_CONTEXT, string2, searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                Attribute attribute = attributes.get("memberOf");
                if (attribute == null) continue;
                for (int i = 0; i < attribute.size(); ++i) {
                    string3 = (String)attribute.get(i);
                    if (!string3.contains("Administrators")) continue;
                    return string3;
                }
                return string3;
            }
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
        return null;
    }

    public ArrayList<NameClassPair> getAllObjects(String string) {
        ArrayList<NameClassPair> arrayList = new ArrayList<NameClassPair>();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = this.ldapServerContext.list(string);
            while (namingEnumeration.hasMore()) {
                NameClassPair nameClassPair = namingEnumeration.next();
                arrayList.add(nameClassPair);
            }
        }
        catch (NamingException namingException) {
            System.out.println("got exception" + namingException.getMessage() + ":" + namingException.toString());
        }
        return arrayList;
    }

    public void close(Context context) {
        try {
            context.close();
        }
        catch (NamingException namingException) {
            System.out.println("got exception in closing" + namingException.getMessage() + ":" + namingException.toString());
        }
    }

    public ArrayList<String> getRegisteredMSMList() {
        ArrayList<String> arrayList;
        block3: {
            arrayList = new ArrayList<String>();
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            try {
                NamingEnumeration<SearchResult> namingEnumeration = this.ldapServerContext.search(ROOT_CONTEXT, OU_ATTRIBUTE, searchControls);
                while (namingEnumeration.hasMore()) {
                    SearchResult searchResult = namingEnumeration.next();
                    Attributes attributes = searchResult.getAttributes();
                    Attribute attribute = attributes.get("cn");
                    String string = (String)attribute.get();
                    arrayList.add(string);
                }
            }
            catch (NamingException namingException) {
                if (namingException instanceof PartialResultException) break block3;
                namingException.printStackTrace();
            }
        }
        return arrayList;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String string) {
        this.ipAddress = string;
    }

    public String getLDAPUserName() {
        if (this.userName.contains("@")) {
            String[] stringArray = this.userName.split("@");
            return stringArray[0];
        }
        if (this.userName.contains("\\")) {
            String[] stringArray = this.userName.split("\\\\");
            return stringArray[1];
        }
        return this.userName;
    }

    public String getLDAPUserRole() {
        return this.ldapUserRole;
    }

    public void setLDAPUserRole() {
        this.ldapUserRole = this.getUserRole("sAMAccountName=" + this.getLDAPUserName());
    }
}

