/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.DetailPanel;
import GUI.GraphicalViewColorCodes;
import GUI.LogicalDriveEraseDialog;
import GUI.LogicalDriveGraphicalView;
import GUI.MainFrame;
import GUI.OperationViewPanel;
import GUI.PropertyViewPanel;
import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.reconfiguration.VirtualDriveExpandOperation;
import GUI.venus.wizard.WizardController;
import GUI.venus.wizard.WizardNavigationException;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.adapterOperations_MR_CTRL_INFO;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASLogical.SASLogicalDriveOperationsAllowed;
import Snapshot.EnableMegaRAIDRecoveryPage;
import Snapshot.EnableSchedulePage;
import Snapshot.SetSnapshotPropertiesPanel;
import Snapshot.SnapshotPropertySettingsPage;
import Snapshot.SnapshotPropertyViewPanel;
import Snapshot.SnapshotsDetailPanel;
import Utils.ColorHash;
import Utils.CustomMsgBox;
import Utils.CustomTabbedPane;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class LogicalDriveDetailPanel
extends DetailPanel {
    private CustomTabbedPane tabbedPane = new CustomTabbedPane();
    private JPanel propertiesTab = new JPanel();
    private JPanel graphicalTab = new JPanel();
    private JPanel snapshotTab = new JPanel();
    private OperationViewPanel opView;
    private LogicalDriveHelper logi;
    private String[] mnemonics;
    private boolean isWindowsServer;
    private boolean viewOnly;
    private SnapshotsDetailPanel snapshotPanel = null;

    public LogicalDriveDetailPanel(LogicalDriveHelper logicalDriveHelper, MainFrame mainFrame) {
        super(logicalDriveHelper, mainFrame);
        this.logi = logicalDriveHelper;
        this.propertiesTab.setLayout(new BorderLayout());
        this.tabbedPane.addTab(Resource.getString("PROPERTY_TAB_TEXT", "Properties"), null, new JScrollPane(this.propertiesTab), Resource.getString("PROPERTY_TAB_TEXT", "Properties"));
        this.snapshotTab.setLayout(new BorderLayout());
        this.isWindowsServer = ((AdapterHelper)logicalDriveHelper.getParent()).isWindowsAndNotDell();
        this.viewOnly = ((AdapterHelper)logicalDriveHelper.getParent()).isViewOnlyMode();
        adapterOperations_MR_CTRL_INFO adapterOperations_MR_CTRL_INFO2 = ((AdapterHelper)logicalDriveHelper.getParent()).getAdapterInfo().getadapterOperations_MR_CTRL_INFO();
        if (adapterOperations_MR_CTRL_INFO2.isSupportSnapshot() && VivaldiStartupDialog.OEM_TYPE != 2561 && ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getInformation().getsnapshotRepository() == 1) {
            this.tabbedPane.addTab(Resource.getString("SNAPSHOTS_TAB_TEXT", "Snapshots"), null, new JScrollPane(this.snapshotTab), Resource.getString("SNAPSHOTS_TAB_TEXT", "Snapshots"));
            this.tabbedPane.setSelectedIndex(1);
        }
        this.add((Component)this.tabbedPane, "Center");
        this.init();
        logicalDriveHelper.addObserver(this);
    }

    @Override
    public void init() {
        JPanel jPanel;
        this.propertiesTab.removeAll();
        this.graphicalTab.removeAll();
        PropertyViewPanel propertyViewPanel = new PropertyViewPanel(this.logi.getPropertyList());
        this.propertiesTab.add((Component)propertyViewPanel, "North");
        if (((SASLogicalDrive)this.logi.getDeviceObject()).getInformation().getsnapshotRepository() == 1) {
            this.snapshotTab.removeAll();
            jPanel = new SnapshotPropertyViewPanel(this.logi.getSnapshotPropertyList(), this.logi);
            this.snapshotTab.add((Component)jPanel, "North");
        }
        this.graphicalTab.setLayout(new BorderLayout());
        jPanel = new LogicalDriveGraphicalView(this.logi);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(jPanel);
        this.graphicalTab.add((Component)jPanel2, "Center");
        Color[] colorArray = new Color[]{ColorHash.getColor("GRAPHICAL_VIEW_USED")};
        String[] stringArray = new String[]{Resource.getString("LEGEND_LDRIVELOCATION_TEXT", "Virtual Disk Location")};
        this.graphicalTab.add((Component)new GraphicalViewColorCodes(colorArray, stringArray), "South");
        this.opView = new OperationViewPanel(this.logi);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add(this.opView);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_OPERATION_GO", "Go"));
        JButton jButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        jButton.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 120 / 1024, MainFrame.SCREEN_SIZE.height * 30 / 768));
        jButton.setToolTipText(Resource.getString("BUTTON_OPERATION_GO_DSC", "Go"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogicalDriveDetailPanel.this.opView.invokeOperation();
            }
        });
        jPanel4.add(jButton);
        this.validate();
        this.repaint();
    }

    @Override
    public boolean canClose() {
        this.logi.deleteObserver(this);
        return true;
    }

    @Override
    public void gotoTab(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    @Override
    public int getTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        switch (n) {
            case 52: 
            case 65: 
            case 69: 
            case 77: {
                break;
            }
            case 347: {
                try {
                    this.snapshotTab.removeAll();
                    this.tabbedPane.remove(1);
                    this.validate();
                    this.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            default: {
                this.init();
                this.setOperationMenu();
                this.validate();
                this.repaint();
            }
        }
    }

    @Override
    public JMenu getSubMenu(JMenu jMenu) {
        int n = jMenu.getItemCount();
        JMenu jMenu2 = null;
        for (int i = 0; i < n; ++i) {
            jMenu2 = (JMenu)jMenu.getItem(i);
            if (!jMenu2.getName().trim().equals("Virtual Drive")) continue;
            return jMenu2;
        }
        return jMenu2;
    }

    @Override
    public void populateOperationMenu(JMenu jMenu, OperationDetails operationDetails) {
        SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = null;
        try {
            sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)this.logi.getDeviceObject()).getAllAllowedOperations();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (jMenu == null) {
            return;
        }
        String[] stringArray = null;
        switch (operationDetails.getOpcode()) {
            case 1134: {
                if (this.viewOnly || !this.isWindowsServer || !sASLogicalDriveOperationsAllowed.isEnableSnapshot()) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("LDRIVE_OPERATION_ENABLE_SNAPSHOT", "E(n)able MegaRAID Recovery"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new EnableSnapshotAction());
                break;
            }
            case 1135: {
                if (this.viewOnly || !this.isWindowsServer || !sASLogicalDriveOperationsAllowed.isDisableSnapshot()) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("LDRIVE_OPERATION_DISABLE_SNAPSHOT", "Di(s)able MegaRAID Recovery"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_DISABLE_SNAPSHOT", "<html>If you disable snapshots on this virtual drive, you will lose any<br>snapshot-related data that is currently stored on its associated<br>snapshot repository and you will not be able to create any new<br>snapshots.<br><br>Are you sure you want to disable snapshots on"));
                            stringBuffer.append(" ");
                            stringBuffer.append(Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + ((SASLogicalDrive)LogicalDriveDetailPanel.this.logi.getDeviceObject()).getID() + " " + ((SASLogicalDrive)LogicalDriveDetailPanel.this.logi.getDeviceObject()).getName() + " ? </html>");
                            if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, Resource.getString("CONFIRM_DISABLE_SNAPSHOT_TITLE", "Confirm Disable Snapshots"), stringBuffer.toString())) {
                                return;
                            }
                            ((SASLogicalDrive)LogicalDriveDetailPanel.this.logi.getDeviceObject()).disableSnapshot();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                break;
            }
            case 1137: {
                boolean bl = false;
                if (!bl || this.viewOnly || !this.isWindowsServer || ((SASLogicalDrive)this.logi.getDeviceObject()).getInformation().getsnapshotRepository() != 1 || !this.logi.isDriveCleanUpPossible()) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("DRIVE_CLEAN_UP_TITLE", "Drive Clean Up"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_DRIVE_CLEAN_UP", "<html>You have unused snapshot virtual drives in the system. Please bring<br>back the drives to use those snapshot repository space or clean up the<br>drives so that you can use it for new snapshot repository,<br><br>All the old data will be lost when you clean up the drives.<br><br>Are you sure you want to clean up the drives?<br></html>"));
                            if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, Resource.getString("CONFIRM_DRIVECLEAN", "Confirm Drive Clean Up"), stringBuffer.toString())) {
                                return;
                            }
                            ((SASLogicalDrive)LogicalDriveDetailPanel.this.logi.getDeviceObject()).SnapshotGarbageCollection((byte)((SASLogicalDrive)LogicalDriveDetailPanel.this.logi.getDeviceObject()).getID());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                break;
            }
            case 1138: {
                if (this.viewOnly || !this.isWindowsServer || ((SASLogicalDrive)this.logi.getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() != 1 || ((SASLogicalDrive)this.logi.getDeviceObject()).getInformation().getldConfig().getparams().getstate() == '\u0000') break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("LDRIVE_OPERATION_MANAGE_SNAPSHOTS", "(M)anage Snapshots"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            new SetSnapshotPropertiesPanel(LogicalDriveDetailPanel.this.logi);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                break;
            }
            case 1143: {
                if (((SASAdapter)((SASLogicalDrive)this.logi.getDeviceObject()).parent()).getAdapterType() == 3 && ((SASAdapter)((SASLogicalDrive)this.logi.getDeviceObject()).parent()).getAdapterType() == 4 || !this.logi.canExpand() || this.logi.isSSCD() && ((AdapterHelper)this.logi.getParent()).getAdapterInfo().getMaxSSCsize() != 0) break;
                String[] stringArray2 = Resource.getResourceMnemonic(Resource.getString("MENU_VD_EXPAND", "Expand VD"));
                JMenuItem jMenuItem = new JMenuItem(stringArray2[0]);
                if (stringArray2.length == 2) {
                    jMenuItem.setMnemonic(stringArray2[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        new VirtualDriveExpandOperation(LogicalDriveDetailPanel.this.logi, LogicalDriveDetailPanel.this.logi.getArrays()[0]);
                    }
                });
                break;
            }
            case 1146: {
                adapterOperations_MR_CTRL_INFO adapterOperations_MR_CTRL_INFO2;
                LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.logi.getParent()).getLogicalDrives();
                if (this.viewOnly || !this.isWindowsServer || ((SASLogicalDrive)this.logi.getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() != 1 || !(adapterOperations_MR_CTRL_INFO2 = ((AdapterHelper)this.logi.getParent()).getAdapterInfo().getadapterOperations_MR_CTRL_INFO()).isSupportSnapshot()) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("LDDRIVE_OPERATION_MANAGE_SNAPSHOT", "(M)anage Snapshots"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            new SnapshotsDetailPanel(LogicalDriveDetailPanel.this.logi);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                break;
            }
            case 1162: {
                if (this.viewOnly) break;
                stringArray = ((AdapterHelper)this.logi.getParent()).isCSA() ? Resource.getResourceMnemonic(Resource.getString("LDRIVE_OPERATION_ENABLE_CSA_CACHING", "Enable Nytro\u2122 (C)ache")) : Resource.getResourceMnemonic(Resource.getString("LDRIVE_OPERATION_ENABLE_SSD_CACHING", "Enable SSD (C)aching"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                final String string = stringArray[0];
                jMenu.add(jMenuItem);
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string2 = "";
                        string2 = ((AdapterHelper)LogicalDriveDetailPanel.this.logi.getParent()).isCSA() ? Resource.getString("ENABLE_CSA_CACHING_MESSAGE", "<html>When you enable Nytro\u2122 Cache, this virtual drive will become<br>associated with an existing or future Nytro\u2122 Cache drive.</html>") : Resource.getString("ENABLE_SSD_CACHING_MESSAGE", "<html>When you enable SSD caching, this virtual drive will become<br>associated with an existing or future CacheCade\u2122 SSD Caching<br>virtual drive.</html>");
                        if (!CustomMsgBox.confirmWithOkCancelCheck(VivaldiStartupDialog.mainScreen, string, string2)) {
                            return;
                        }
                        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)LogicalDriveDetailPanel.this.logi.getDeviceObject();
                        byte[] byArray = new byte[]{(byte)sASLogicalDrive.getID()};
                        try {
                            ((SASAdapter)((AdapterHelper)LogicalDriveDetailPanel.this.logi.getParent()).getDeviceObject()).setAssociatedLdIds(byArray);
                        }
                        catch (VKOperationFailedException vKOperationFailedException) {
                            CustomMsgBox.errorMsg(vKOperationFailedException);
                        }
                    }
                });
                break;
            }
            case 1163: {
                if (this.viewOnly) break;
                stringArray = ((AdapterHelper)this.logi.getParent()).isCSA() ? Resource.getResourceMnemonic(Resource.getString("LDRIVE_OPERATION_DISABLE_CSA_CACHING", "Disable Nytro\u2122 (C)ache")) : Resource.getResourceMnemonic(Resource.getString("LDRIVE_OPERATION_DISABLE_SSD_CACHING", "Disable SSD (C)aching"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                final String string = stringArray[0];
                jMenu.add(jMenuItem);
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)LogicalDriveDetailPanel.this.logi.getDeviceObject();
                        String string2 = "";
                        string2 = ((AdapterHelper)LogicalDriveDetailPanel.this.logi.getParent()).isCSA() ? Resource.getString("DISABLE_CSA_CACHING_MESSAGE", " <html>If you disable Nytro\u2122 Cache, any associations that <br>this virtual drive has with Nytro\u2122 Cache drives will be <br>removed. It may take some time to complete this operation.<br><br>Are you sure you want to disable caching on Virtual Drive?") : Resource.getString("DISABLE_SSD_CACHING_MESSAGE", "<html>If you disable SSD caching, any associations that this<br>virtual drive has with CacheCade\u2122 SSD Caching virtual<br>drives will be removed. It may take some time to<br>complete this operation.<br><br>Are you sure you want to disable SSD caching on Virtual<br>Drive") + " " + sASLogicalDrive.getID() + "?</html>";
                        if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, string, string2)) {
                            return;
                        }
                        byte[] byArray = new byte[]{(byte)sASLogicalDrive.getID()};
                        ((SASAdapter)((AdapterHelper)LogicalDriveDetailPanel.this.logi.getParent()).getDeviceObject()).unsetAssociatedLdIds(byArray);
                    }
                });
                break;
            }
            case 1165: {
                if (this.viewOnly) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("LDRIVE_OPERATION_REMOVE_BLOCKED_ACCESS", "Remove (B)locked Access"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                final boolean bl = ((AdapterHelper)this.logi.getParent()).isCSA();
                jMenu.add(jMenuItem);
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = Resource.getString("CONFIRM_REMOVE_BLOCKED_ACCESS_TITLE", "Confirm Remove Blocked Access");
                        if (LogicalDriveDetailPanel.this.logi.isBlockedDueToPeerUnavailability()) {
                            StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_REMOVE_BLOCKED_ACCESS_MESSAGE_PEERUNAVAILABALITY", "<html>You have chosen to manually unblock access to the virtual drive.<br>Forcing removal of blocked access from a VD will result in data <br>loss Do you wish to proceed?.<br><br>"));
                            stringBuffer.append(Resource.getString("CONFIRM_REMOVE_BLOCKED_ACCESS_MESSAGE_NOTE1", "Note: Access to the virtual drive was blocked automatically due to<br>a problem with the associated cache.<br>To preserve data please select 'No' below and attempt to bring all<br>"));
                            stringBuffer.append(Resource.getString("CONFIRM_REMOVE_BLOCKED_ACCESS_MESSAGE_NOTE2", "controllers to online state or select 'Yes' below and restore <br> data from an available backup<br><br><html>"));
                            if (CustomMsgBox.confirmWithCheck((Component)VivaldiStartupDialog.getVivaldiStartupDialogObj(), string, stringBuffer.toString(), "MR_REMOVING_BLOCKED_ACCESS")) {
                                ((SASLogicalDrive)LogicalDriveDetailPanel.this.logi.getDeviceObject()).clearBlockedAccess();
                            }
                        } else if (LogicalDriveDetailPanel.this.logi.isBlockedDueToSSCDOffline()) {
                            StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_REMOVE_BLOCKED_ACCESS_MESSAGE1", "<html>You have chosen to unblock access to the virtual drive.<br>Access was blocked automatically due to a problem with<br>the associated cache.<br><br>"));
                            ArrayList<LogicalDriveHelper> arrayList = ((AdapterHelper)LogicalDriveDetailPanel.this.logi.getParent()).getOfflineWBSSCDlist();
                            if (arrayList.size() == 1) {
                                stringBuffer.append(Resource.getString("CONFIRM_REMOVE_BLOCKED_ACCESS_MESSAGE2B1", "You should first try to bring<br>"));
                                stringBuffer.append(arrayList.get(0).getSSCDShortText() + " ");
                                if (bl) {
                                    stringBuffer.append(Resource.getString("CSA_CONFIRM_REMOVE_BLOCKED_ACCESS_MESSAGE2B2", "back online.<br>Once you have fixed the Nytro\u2122 Cache virtual drive, <br>this blocked virtual drive will return to its former <br>access policy automatically.<br><br>"));
                                } else {
                                    stringBuffer.append(Resource.getString("CONFIRM_REMOVE_BLOCKED_ACCESS_MESSAGE2B2", " back online.<br>Once you have fixed the CacheCade virtual drive, this<br>blocked virtual drive will return to its former access<br>policy automatically.<br><br>"));
                                }
                            } else if (bl) {
                                stringBuffer.append(Resource.getString("CSA_CONFIRM_REMOVE_BLOCKED_ACCESS_MESSAGE2A", "You should first try to bring any problematic <br> Nytro\u2122 Cache virtual drives back to an <br>optimal status. Once they are fixed, the blocked<br> virtual drive will return to its former access policy<br>automatically.<br><br>"));
                            } else {
                                stringBuffer.append(Resource.getString("CONFIRM_REMOVE_BLOCKED_ACCESS_MESSAGE2A", "You should first try to bring any problem<br>CacheCade\u2122 - SSD Caching virtual drives back to<br>an optimal status. Once they are fixed, the blocked<br>virtual drive will return to its former access policy<br>automatically.<br><br>"));
                            }
                            stringBuffer.append(Resource.getString("CONFIRM_REMOVE_BLOCKED_ACCESS_MESSAGE3", "You should only manually change the access policy as a<br>last resort, as it will likely result in data loss.<br><br>Are you sure you want to manually change the access<br>policy from blocked back to the default policy?<br></html>"));
                            if (CustomMsgBox.confirmWithCheck((Component)VivaldiStartupDialog.getVivaldiStartupDialogObj(), string, stringBuffer.toString(), "MR_REMOVING_BLOCKED_ACCESS")) {
                                ((SASLogicalDrive)LogicalDriveDetailPanel.this.logi.getDeviceObject()).clearBlockedAccess();
                            }
                        }
                    }
                });
                break;
            }
            case 1161: {
                if (this.logi.isCSACacheCade() && this.logi.getLdParameters().getstate() != '\u0000' && sASLogicalDriveOperationsAllowed.canStartSecureEraseNonSED()) {
                    String[] stringArray3 = Resource.getResourceMnemonic(Resource.getString("CSA_VD_ERASE_OP", "(C)lear Nytro\u2122 Cache"));
                    JMenuItem jMenuItem = new JMenuItem(stringArray3[0]);
                    jMenuItem.setMnemonic(stringArray3[1].charAt(0));
                    jMenuItem.setToolTipText(Resource.getString("CSA_VD_ERASE_OP", "(C)lear Nytro\u2122 Cache"));
                    jMenuItem.setEnabled(true);
                    jMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                String string = Resource.getString("CONFIRM_CSA_CC_LD_ERASE_DESC", "<html> You have chosen to perform clear operation on the selected <br>Nytro\u2122 Cache drive. This is a destructive operation and <br>wipes out all the data present on the drive. <br> <br>Once the erase operation is complete the virtual drive will be deleted.<br><br>Are you sure you want to proceed? </html>");
                                if (CustomMsgBox.confirm(string.toString())) {
                                    boolean bl = false;
                                    SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)LogicalDriveDetailPanel.this.logi.getDeviceObject();
                                    OperationDetails operationDetails = new OperationDetails(0x3130100, sASLogicalDrive.getInformation());
                                    int n = 128;
                                    operationDetails.setArgument(n);
                                    try {
                                        sASLogicalDrive.fireOperation(operationDetails);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    });
                    break;
                }
                if (this.logi.isEncrypted() || this.logi.getLdParameters().getstate() == '\u0000' || !sASLogicalDriveOperationsAllowed.canStartSecureEraseNonSED()) break;
                String[] stringArray4 = Resource.getResourceMnemonic(Resource.getString("LD_ERASE_OP", "(V)irtual Drive Erase"));
                JMenuItem jMenuItem = new JMenuItem(stringArray4[0]);
                jMenuItem.setMnemonic(stringArray4[1].charAt(0));
                jMenuItem.setToolTipText(Resource.getString("LD_ERASE_OP", "(V)irtual Drive Erase"));
                jMenuItem.setEnabled(true);
                jMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            new LogicalDriveEraseDialog(LogicalDriveDetailPanel.this.logi);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                jMenu.add(jMenuItem);
            }
        }
    }

    public void populateOperationMenu(JMenu jMenu) {
        if (jMenu == null) {
            return;
        }
    }

    class EnableSnapshotAction
    implements ActionListener {
        EnableSnapshotAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                WizardController wizardController = new WizardController();
                HashMap hashMap = wizardController.getWizardData();
                hashMap.put("LogicalDriveHelper", LogicalDriveDetailPanel.this.logi);
                hashMap.put("AdapterHelper", (AdapterHelper)LogicalDriveDetailPanel.this.logi.getParent());
                wizardController.addPage(EnableMegaRAIDRecoveryPage.class.getName(), "EnableMegaRAIDRecoveryPage");
                wizardController.addPage(EnableSchedulePage.class.getName(), "EnableSchedulePage");
                wizardController.addPage(SnapshotPropertySettingsPage.class.getName(), "SnapshotPropertySettingsPage");
                wizardController.setFirstPage("EnableMegaRAIDRecoveryPage");
                wizardController.addPageTransition("EnableMegaRAIDRecoveryPage", 0, "EnableSchedulePage");
                wizardController.addPageTransition("EnableSchedulePage", 0, "SnapshotPropertySettingsPage");
                wizardController.launchWizard();
            }
            catch (WizardNavigationException wizardNavigationException) {
                wizardNavigationException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

