/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.VivaldiBaseDialog;
import GUIHelper.LogicalDriveHelper;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASLogical.SASLogicalDrive;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LogicalDriveEraseDialog
extends VivaldiBaseDialog {
    private JRadioButton simpleModeRadioButton = null;
    private JRadioButton normalModeRadioButton = null;
    private JRadioButton thoroughModeRadioButton = null;
    private JCheckBox deleteVDAfterErase = null;
    private LogicalDriveHelper m_ldHelper;
    private int m_iEraseMode = 0;
    private String m_strEraseMode = "Simple";
    private byte m_deleteVDMode = 0;

    public LogicalDriveEraseDialog(LogicalDriveHelper logicalDriveHelper) {
        this.m_ldHelper = logicalDriveHelper;
        this.buildUI();
    }

    private void buildUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        String[] stringArray = null;
        ButtonGroup buttonGroup = new ButtonGroup();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 15, 0, 0);
        jPanel.add((Component)new JLabel(Resource.getString("DESC_LD_ERASE")), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("ERASE_MODE_SIMPLE_BUTTON"));
        this.simpleModeRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.simpleModeRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.simpleModeRadioButton.setSelected(true);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)this.simpleModeRadioButton, gridBagConstraints);
        buttonGroup.add(this.simpleModeRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 0, 15);
        jPanel.add((Component)new JLabel(Resource.getString("LD_ERASE_MODE_SIMPLE_DESC")), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("ERASE_MODE_NORMAL_BUTTON"));
        this.normalModeRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.normalModeRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)this.normalModeRadioButton, gridBagConstraints);
        buttonGroup.add(this.normalModeRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 0, 15);
        jPanel.add((Component)new JLabel(Resource.getString("LD_ERASE_MODE_NORMAL_DESC")), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("ERASE_MODE_THOROUGH_BUTTON"));
        this.thoroughModeRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.thoroughModeRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)this.thoroughModeRadioButton, gridBagConstraints);
        buttonGroup.add(this.thoroughModeRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 0, 15);
        jPanel.add((Component)new JLabel(Resource.getString("LD_ERASE_MODE_THOROUGH_DESC")), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CHECKBOX_DELETE_VD_AFTER_ERASE", "(D)elete Virtual Drive after Erase"));
        this.deleteVDAfterErase = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            this.deleteVDAfterErase.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)this.deleteVDAfterErase, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 10, 10));
        stringArray = Resource.getResourceMnemonic(Resource.getString("OK_BUTTON_TEXT", "(O)K"));
        JButton jButton = new JButton(stringArray[0]);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "(C)ancel"));
        JButton jButton2 = new JButton(stringArray[0]);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(25, 0, 15, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogicalDriveEraseDialog.this.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogicalDriveEraseDialog.this.dispose();
                OperationDetails operationDetails = null;
                if (LogicalDriveEraseDialog.this.simpleModeRadioButton.isSelected()) {
                    LogicalDriveEraseDialog.this.setEraseMode(0);
                    LogicalDriveEraseDialog.this.m_strEraseMode = "Simple";
                    LogicalDriveEraseDialog.this.m_iEraseMode = 0;
                } else if (LogicalDriveEraseDialog.this.normalModeRadioButton.isSelected()) {
                    LogicalDriveEraseDialog.this.setEraseMode(1);
                    LogicalDriveEraseDialog.this.m_strEraseMode = "Normal";
                    LogicalDriveEraseDialog.this.m_iEraseMode = 1;
                } else if (LogicalDriveEraseDialog.this.thoroughModeRadioButton.isSelected()) {
                    LogicalDriveEraseDialog.this.setEraseMode(2);
                    LogicalDriveEraseDialog.this.m_strEraseMode = "Thorough";
                    LogicalDriveEraseDialog.this.m_iEraseMode = 2;
                }
                Object[] objectArray = new Object[2];
                StringBuffer stringBuffer = new StringBuffer();
                objectArray[0] = stringBuffer.append(" ").append(LogicalDriveEraseDialog.this.m_strEraseMode);
                String string = "";
                if (LogicalDriveEraseDialog.this.deleteVDAfterErase.isSelected()) {
                    objectArray[1] = stringBuffer.append(LogicalDriveEraseDialog.this.m_ldHelper.getDescription());
                    LogicalDriveEraseDialog.this.m_deleteVDMode = (byte)1;
                    string = MessageFormat.format(Resource.getString("CONFIRM_LD_ERASE_DESC_NEW1"), objectArray);
                } else {
                    objectArray[1] = stringBuffer.append(LogicalDriveEraseDialog.this.m_ldHelper.getDescription());
                    LogicalDriveEraseDialog.this.m_deleteVDMode = (byte)0;
                    string = MessageFormat.format(Resource.getString("CONFIRM_LD_ERASE_DESC_NEW2"), objectArray);
                }
                if (CustomMsgBox.confirm(string)) {
                    LogicalDriveEraseDialog.this.dispose();
                    SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)LogicalDriveEraseDialog.this.m_ldHelper.getDeviceObject();
                    operationDetails = new OperationDetails(0x3130100, sASLogicalDrive.getInformation());
                    System.out.println("m_iEraseMode :" + LogicalDriveEraseDialog.this.m_iEraseMode);
                    operationDetails.setArgument(LogicalDriveEraseDialog.this.m_iEraseMode);
                    operationDetails.setParameter(LogicalDriveEraseDialog.this.m_deleteVDMode);
                    try {
                        sASLogicalDrive.fireOperation(operationDetails);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.add(jPanel);
        this.setTitle(Resource.getString("VIRTUAL_DRIVE_ERASE_TITLE", "Mode Selection - Virtual Drive Erase"));
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    private void setEraseMode(int n) {
        this.m_iEraseMode = n;
    }
}

