/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MainFrame;
import GUI.VivaldiStartupDialog;
import GUIHelper.LogicalDriveHelper;
import SASKernel.ISASObject;
import SASKernel.SASLogical.SASArray;
import Services.UsageInfo;
import Utils.ColorHash;
import Utils.Cube;
import Utils.Resource;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JPanel;

public class LogicalDriveGraphicalView
extends JPanel {
    private Vector usageList;
    private int MAXWIDTH;
    private int MAXHEIGHT;
    private int ARRAYWIDTH;
    private int OFFSET;
    private int GAP;
    private int CAPHEIGHT;
    private long arraySizeMax = 0L;

    public LogicalDriveGraphicalView(LogicalDriveHelper logicalDriveHelper) {
        this.usageList = logicalDriveHelper.getDiskDetails();
        if (this.usageList == null || this.usageList.size() <= 0) {
            return;
        }
        this.CAPHEIGHT = 20 * MainFrame.SCREEN_SIZE.height / 768;
        this.MAXWIDTH = 100 * MainFrame.SCREEN_SIZE.width / 1024 * this.usageList.size();
        this.MAXHEIGHT = 300 * MainFrame.SCREEN_SIZE.height / 768;
        this.ARRAYWIDTH = 80 * MainFrame.SCREEN_SIZE.width / 1024;
        this.OFFSET = 20 * MainFrame.SCREEN_SIZE.width / 1024;
        this.GAP = 30 * MainFrame.SCREEN_SIZE.width / 1024;
        this.setPreferredSize(new Dimension(this.MAXWIDTH + 2 * this.GAP, this.MAXHEIGHT + this.CAPHEIGHT + this.GAP * 2));
        for (int i = 0; i < this.usageList.size(); ++i) {
            UsageInfo usageInfo = (UsageInfo)this.usageList.get(i);
            long l = ((ISASObject)usageInfo.getSASObject()).getSize();
            if (l <= this.arraySizeMax) continue;
            this.arraySizeMax = l;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.usageList == null || this.usageList.size() <= 0) {
            return;
        }
        int n = (this.getWidth() - this.MAXWIDTH) / 2;
        int n2 = (this.getHeight() - this.MAXHEIGHT + this.CAPHEIGHT) / 2;
        for (int i = 0; i < this.usageList.size(); ++i) {
            UsageInfo usageInfo = (UsageInfo)this.usageList.get(i);
            int n3 = n2;
            int n4 = this.ARRAYWIDTH;
            int n5 = n + i * (this.GAP + n4);
            long l = ((SASArray)usageInfo.getSASObject()).getSize();
            int n6 = (int)(1.0 * (double)this.MAXHEIGHT / (double)this.arraySizeMax * (double)l);
            Cube cube = new Cube(graphics, n5, n3, n4, n6, this.CAPHEIGHT, this.OFFSET, Color.black, ColorHash.getColor("GRAPHICAL_VIEW_UNUSED"));
            cube.fillBlock((int)(1.0 * (double)usageInfo.getStartSector() / (double)l * (double)n6), (int)(1.0 * (double)usageInfo.getEndSector() / (double)l * (double)n6), ColorHash.getColor("GRAPHICAL_VIEW_USED"));
            String string = Resource.getString("ARRAY_TEXT", "Array") + ((SASArray)usageInfo.getSASObject()).getID();
            if (VivaldiStartupDialog.isWindows) {
                graphics.setColor(ColorHash.getColor("GRAPHICAL_VIEW_USED"));
            }
            graphics.drawBytes(string.getBytes(), 0, string.length(), n5, n3 + this.MAXHEIGHT + this.GAP / 2);
        }
    }
}

