/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import Framework.Configurator.ConfiguratorInfo;
import Framework.Configurator.ConfiguratorManager;
import GUI.AboutDialog;
import GUI.AdapterMenuListener;
import GUI.CCOH.CCOHBaseDialog;
import GUI.CCOH.CCOHCacheGroupHelper;
import GUI.CCOH.CCOHConfigurationEngine;
import GUI.CCOH.CCOHManageCacheDevicesDialog;
import GUI.Dashboard.DashboardPanel;
import GUI.DefaultNoOptionDialog;
import GUI.DetailPanel;
import GUI.DevicePanel;
import GUI.DeviceTree;
import GUI.DeviceTreeNode;
import GUI.GroupConsistencyCheckDialog;
import GUI.GroupInitializeDialog;
import GUI.GroupShowProgressDialog;
import GUI.JLogger;
import GUI.LogicalDevicePanel;
import GUI.PhysicalDevicePanel;
import GUI.PreservedCache.ManagePreservedCacheDialog;
import GUI.RemoteServerPanel;
import GUI.ToolBarHandler;
import GUI.TreeNodeListener;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiBrandingPanel;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.BBUHelper;
import GUIHelper.CCOHVirtualAdapterHelper;
import GUIHelper.EnclosureHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.PortHelper;
import GUIHelper.SasClusterObjectHelper;
import GUIHelper.ServerObjectHelper;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import Plugins.GUIPluginBase;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CONFIG_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_LIST_T;
import SASKernel.LibraryAPI.StoreLib.SL_EVENT_DETAIL_T;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASKernel;
import SASKernel.SASServer;
import SASKernel.VirtualAdapter;
import Services.FrameworkUtilities;
import Services.LogXMLParser;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import Utils.BouncingProgressBar;
import Utils.CustomMsgBox;
import Utils.CustomTabbedPane;
import Utils.GUIUtils;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.LastScreenPosition;
import Utils.MsgBoxReturn;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class MainFrame
extends JFrame
implements HelpInterface,
Observer {
    private JMenuBar menubar;
    private JPanel[] tabPanels = new JPanel[3];
    ConfiguratorManager configManager = null;
    private JLogger logger;
    private JMenu fileMenu;
    private JMenu opMenu;
    private JMenu plugMenu;
    private JMenu helpMenu;
    private JMenu logMenu;
    private JMenu toolsMenu;
    private JLabel logLabel;
    private JMenuItem serversMenu;
    public static MsgBoxReturn msgRet = new MsgBoxReturn();
    private Hashtable m_objHash = new Hashtable();
    private Hashtable m_pluginHash = new Hashtable();
    private DetailPanel currentPanel;
    private CustomTabbedPane tabbedPane;
    private CustomTabbedPane mainTabbedPane;
    private JLabel logo;
    private ImageIcon logoIcon;
    private static JToolBar toolBar;
    public static final Dimension SCREEN_SIZE;
    public static Dimension DASHBOARD_SCREEN_SIZE;
    public static final TreeNodeListener allNodeListener;
    private static SASServer server;
    private static ServerObjectHelper serverHelper;
    private static SasClusterObjectHelper clusterHelper;
    public static boolean fullAccess;
    public static final int NO_OF_LOGS = 3000;
    public static final int NO_OF_LOGS_CIM = 3000;
    public static final long POLLING_PERIOD = 300000L;
    private static int nodeindex;
    private static Thread pollThread;
    public static MainFrame parent;
    private static LinkedHashMap<Integer, JButton> toolBarServButtons;
    private static LinkedHashMap<Integer, JButton> toolBarAdpButtons;
    private static LinkedHashMap<Integer, JButton> toolBarMainButtons;
    private ArrayList<Integer> toolBarEnabledOpers;
    private JPopupMenu addRemoveMenu = new JPopupMenu();
    private static JButton toolBarOptions;
    RemoteServerPanel remoteServerPanel;
    private static boolean isManageCIMOM;
    public static Color BACKGROUND_COLOR;
    public static Color TITLE_COLOR;
    public VivaldiBaseDialog m_progressPanel = null;
    private boolean pollThreadInterrupted = false;

    public MainFrame(SASServer sASServer, byte by) {
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        CCOHVirtualAdapterHelper cCOHVirtualAdapterHelper;
        VirtualAdapter virtualAdapter;
        SL_CCOH_DEV_LIST_T sL_CCOH_DEV_LIST_T;
        JComponent jComponent;
        Object object4;
        JComponent jComponent2;
        Object object5;
        Object object6;
        if (VivaldiStartupDialog.isWindows && ((Boolean)(object6 = (Boolean)((Toolkit)(object5 = Toolkit.getDefaultToolkit())).getDesktopProperty("win.highContrast.on"))).booleanValue()) {
            BACKGROUND_COLOR = Color.BLACK;
            TITLE_COLOR = Color.WHITE;
        }
        this.setTitle(VivaldiStartupDialog.FRAME_TITLE);
        object5 = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        this.setIconImage((Image)object5);
        server = sASServer;
        server.addObserver(this);
        object6 = "";
        try {
            object6 = !server.isLDAPServer() && !VivaldiStartupDialog.UseSystemCredential ? new String(server.getUsrName(), "UTF-16LE") : (VivaldiStartupDialog.UseSystemCredential ? (VivaldiStartupDialog.isAdministrator() ? new String("Administrator") : new String("Guest")) : server.getLDAPUserName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.menubar = new JMenuBar();
        this.populateMenuItems();
        toolBar = new JToolBar();
        toolBar.setRollover(true);
        this.populateToolBar();
        if (!VivaldiStartupDialog.isWindows) {
            toolBar.setBorder(BorderFactory.createBevelBorder(0));
            toolBar.setBorderPainted(true);
        }
        toolBar.setFloatable(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(Resource.getString("WELCOME_LABEL", "Welcome: ") + (String)object6 + " " + "[");
        jPanel2.add(jLabel);
        if (by == 0) {
            jComponent2 = new JLabel(Resource.getString("LOGINMODE_FULLACCESS", "Full Access") + "]");
            gridBagConstraints.insets = new Insets(0, 0, 0, 75);
            jPanel2.add((Component)jComponent2, gridBagConstraints);
        } else {
            jComponent2 = new JLabel(Resource.getString("[LOGINMODE_VIEWONLY", "View Only") + "]");
            gridBagConstraints.insets = new Insets(0, 0, 0, 75);
            jPanel2.add((Component)jComponent2, gridBagConstraints);
        }
        jComponent2 = new JPanel(new FlowLayout(2));
        JLabel jLabel2 = new JLabel("<html><body>" + Resource.getString("LOGOFF_LABEL", "Log Off") + "&nbsp&nbsp&nbsp</body></html>");
        jLabel2.setHorizontalAlignment(4);
        gridBagConstraints.insets = new Insets(0, 100, 0, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)VivaldiBrandingPanel.getInstance().getBannerPanel(), "South");
        jPanel3.add((Component)this.menubar, "North");
        jPanel3.add((Component)toolBar, "Center");
        jPanel.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel2, "East");
        Container container = this.getContentPane();
        container.add((Component)jPanel, "North");
        ImageIcon imageIcon = Resource.getImage("LOAD_ICON");
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBackground(Color.WHITE);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 10, 5, 5);
        JLabel jLabel3 = new JLabel();
        jLabel3.setIcon(imageIcon);
        jPanel4.add((Component)jLabel3, gridBagConstraints2);
        container.add((Component)jPanel4, "Center");
        if (!VivaldiStartupDialog.useEmailCOnfigurator) {
            this.setSize(SCREEN_SIZE);
            this.setVisible(true);
            this.setDefaultCloseOperation(3);
            this.setExtendedState(6);
        }
        server = sASServer;
        try {
            sASServer.createAdapters();
        }
        catch (Exception exception) {
            // empty catch block
        }
        serverHelper = new ServerObjectHelper(sASServer);
        if (sASServer.getInformation().ismaxHaNodes() && VivaldiStartupDialog.kernel.getSASServerArrayList().size() > 1) {
            clusterHelper = new SasClusterObjectHelper();
        }
        AdapterHelper[] adapterHelperArray = serverHelper.getAdapterHelpers();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.logOut();
                HelpContext.unregisterHelp(VivaldiStartupDialog.mainScreen);
                ((SASKernel)server.parent()).destroyKernel();
            }
        });
        fullAccess = by == 0;
        this.setTitle(VivaldiStartupDialog.FRAME_TITLE);
        object5 = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        this.setIconImage((Image)object5);
        this.menubar = new JMenuBar();
        this.populateMenuItems();
        toolBar = new JToolBar();
        toolBar.setRollover(true);
        this.populateToolBar();
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("SERVERS_BUTTON_TEXT", "Servers"));
        if (!VivaldiStartupDialog.isWindows) {
            toolBar.setBorder(BorderFactory.createBevelBorder(0));
            toolBar.setBorderPainted(true);
        }
        toolBar.setFloatable(false);
        if (server.isCIMOMServer() && isManageCIMOM) {
            this.toolsMenu.setVisible(true);
        }
        if (server.isCIMOMServer()) {
            isManageCIMOM = server.manageCIMMOMServer();
        }
        this.logger = new JLogger();
        this.logger.updateVivaldiLogConfig(server.readVivaldiLogConfig());
        try {
            object4 = Locale.getDefault().getLanguage().getBytes();
            byte[] byArray = new byte[2];
            byte[] byArray2 = Locale.getDefault().getCountry().getBytes();
            System.arraycopy(byArray2, 0, byArray, 0, Math.min(byArray.length, byArray2.length));
            if (!server.isCIMOMServer()) {
                server.registerLogRecord((byte[])object4, byArray);
            } else {
                System.out.println("Going 2 get Initial log 4 CIMOM server");
            }
            this.logger.getInitialLog(server.readLogRecord(1, 3000, (byte[])object4, byArray));
            this.logger.registerToServer(server, serverHelper.getAdapterHelpers());
            this.logger.registerToServer(server, serverHelper.getCCOHVirtualAdapHelper());
            this.writeLog("LOGON");
        }
        catch (Exception exception) {
            System.out.println("Exception while logging initial log");
            exception.printStackTrace();
        }
        this.tabbedPane = new CustomTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (MainFrame.this.tabbedPane.getSelectedIndex() < 0) {
                    return;
                }
                if (MainFrame.this.tabbedPane.getSelectedIndex() == 0) {
                    MainFrame.this.updateDetailsPanel(null);
                } else {
                    DeviceTree deviceTree = ((DevicePanel)MainFrame.this.tabPanels[MainFrame.this.tabbedPane.getSelectedIndex()]).getTree();
                    if (deviceTree.getSelectedNode() == null) {
                        deviceTree.setSelectionRow(0);
                    }
                    MainFrame.this.updateDetailsPanel(deviceTree.getSelectedNode());
                }
            }
        });
        this.tabbedPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("background") && VivaldiStartupDialog.isWindows) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Boolean bl = (Boolean)toolkit.getDesktopProperty("win.highContrast.on");
                    if (bl.booleanValue()) {
                        BACKGROUND_COLOR = Color.BLACK;
                        TITLE_COLOR = Color.WHITE;
                    } else {
                        BACKGROUND_COLOR = Color.WHITE;
                        TITLE_COLOR = Color.BLACK;
                    }
                    ((DashboardPanel)MainFrame.this.tabPanels[0]).updateControllerTabs(serverHelper);
                }
            }
        });
        object4 = new LastScreenPosition();
        object4.selectedTreeNodeObjectID = sASServer.getID();
        this.reboot((LastScreenPosition)object4);
        server.RegistrationCommandForAEN();
        int n = 1;
        int n2 = 1;
        if (MainFrame.SCREEN_SIZE.height < 700) {
            n = 4;
            n2 = 5;
        }
        object6 = "";
        try {
            object6 = !server.isLDAPServer() && !VivaldiStartupDialog.UseSystemCredential ? new String(server.getUsrName(), "UTF-16LE") : (VivaldiStartupDialog.UseSystemCredential ? (VivaldiStartupDialog.isAdministrator() ? new String("Administrator") : new String("Guest")) : server.getLDAPUserName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        jPanel = new JPanel(new BorderLayout());
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(Resource.getString("WELCOME_LABEL", "Welcome: ") + (String)object6 + " " + "[");
        jPanel2.add(jLabel);
        if (by == 0) {
            jComponent = new JLabel(Resource.getString("LOGINMODE_FULLACCESS", "Full Access") + "]");
            gridBagConstraints.insets = new Insets(0, 0, 0, 75);
            jPanel2.add((Component)jComponent, gridBagConstraints);
        } else {
            jComponent = new JLabel(Resource.getString("[LOGINMODE_VIEWONLY", "View Only") + "]");
            gridBagConstraints.insets = new Insets(0, 0, 0, 75);
            jPanel2.add((Component)jComponent, gridBagConstraints);
        }
        jComponent = new JPanel();
        jComponent.setBackground(Color.WHITE);
        jComponent.setLayout(new GridBagLayout());
        if (VivaldiStartupDialog.OEM_TYPE == 98761) {
            jLabel2 = new JLabel("<html><body><font color = black><a href=\"" + Resource.getString("LOGOFF_LABEL", "Log Off") + "\">" + Resource.getString("LOGOFF_LABEL", "Log Off") + "</font></a>&nbsp&nbsp&nbsp</body></html>");
            jLabel2.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    System.out.println("inside mouse click");
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            });
        } else {
            jLabel2 = new JLabel("<html><body><a href=\"" + Resource.getString("LOGOFF_LABEL", "Log Off") + "\">" + Resource.getString("LOGOFF_LABEL", "Log Off") + "</a>&nbsp&nbsp&nbsp</body></html>");
            jLabel2.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    System.out.println("inside mouse click");
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            });
        }
        jLabel2.setHorizontalAlignment(4);
        gridBagConstraints.insets = new Insets(0, 100, 0, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)VivaldiBrandingPanel.getInstance().getBannerPanel(), "South");
        jPanel3.add((Component)this.menubar, "North");
        jPanel3.add((Component)toolBar, "Center");
        jPanel.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel2, "East");
        container.removeAll();
        container.add((Component)jPanel, "North");
        JPanel jPanel5 = VivaldiBrandingPanel.getInstance().getSmallBanner();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.tabbedPane, "Center");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        String[] stringArray2 = Resource.getResourceMnemonic(Resource.getString("BUTTON_EVENT_FILTER_TEXT", "(E)vent Log Filter"));
        jPanel6.add((Component)new JScrollPane(this.logger), "Center");
        this.logger.addLogMouseListener(jPanel6);
        jPanel6.setPreferredSize(SCREEN_SIZE);
        this.logLabel = new JLabel(Resource.getString("STATUS_LOG_SERVER", "Displaying log from server"), 2);
        if (!VivaldiStartupDialog.isWindows) {
            this.logLabel.setBackground(Color.lightGray);
        }
        this.logLabel.setOpaque(true);
        jPanel6.add((Component)this.logLabel, "South");
        for (int i = 0; i < jPanel6.getComponentCount(); ++i) {
            this.logger.addLogMouseListener(jPanel6.getComponent(i));
        }
        JSplitPane jSplitPane = new JSplitPane(0, jPanel5, jPanel6);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setBorder(null);
        jSplitPane.setDividerSize(10);
        if (MainFrame.SCREEN_SIZE.height < 822) {
            jSplitPane.setDividerLocation(MainFrame.SCREEN_SIZE.height - 320);
        } else {
            jSplitPane.setDividerLocation(502);
        }
        if (!VivaldiStartupDialog.useEmailCOnfigurator) {
            this.setSize(SCREEN_SIZE);
            this.setVisible(true);
            this.setDefaultCloseOperation(3);
            this.setExtendedState(6);
        }
        container.add((Component)jSplitPane, "Center");
        this.setSize(SCREEN_SIZE);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        this.setExtendedState(6);
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
        jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DefaultNoOptionDialog defaultNoOptionDialog = new DefaultNoOptionDialog(Resource.getString("DASHBOARD_CONFIRMATION_TITLE", "Dashboard - Confirmation"), Resource.getString("DASHBOARD_LOGOFF_MESSAGE", "Are you sure you want to log off?"), 3);
                if (defaultNoOptionDialog.getOptionPaneValue()) {
                    defaultNoOptionDialog.dispose();
                    int n = MainFrame.this.logoffServer();
                    if (n == 0 && !MainFrame.this.pollThreadInterrupted) {
                        MainFrame.this.dispose();
                        if (VivaldiStartupDialog.UseSystemCredential) {
                            VivaldiStartupDialog.closeonLogoff = true;
                            VivaldiStartupDialog.displayVivaldiStartupDialog(false);
                        } else {
                            VivaldiStartupDialog.displayVivaldiStartupDialog(true);
                        }
                        VivaldiStartupDialog.mainScreen = null;
                    }
                } else {
                    defaultNoOptionDialog.dispose();
                }
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension;
                Component component = (Component)componentEvent.getSource();
                DASHBOARD_SCREEN_SIZE = dimension = component.getSize();
                ((DashboardPanel)MainFrame.this.tabPanels[0]).repaintControllerTabs();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.startPollThread();
        if (by == 0 && serverHelper.isCCOHinitialised() && (sL_CCOH_DEV_LIST_T = (virtualAdapter = (VirtualAdapter)(cCOHVirtualAdapterHelper = serverHelper.getCCOHVirtualAdapHelper()).getDeviceObject()).getCCOHCDs()) != null && sL_CCOH_DEV_LIST_T.getCount() != 0) {
            object3 = cCOHVirtualAdapterHelper.getCCOHConfig();
            if (object3 == null) {
                if (virtualAdapter.isCCOHLicenseFound()) {
                    if (CustomMsgBox.confirm(VivaldiStartupDialog.mainScreen, Resource.getString("NO_CACHE_GROUP_MSG"), Resource.getString("NO_CACHE_GROUP_TITLE", "No Cache Group"), 1)) {
                        new CCOHBaseDialog(cCOHVirtualAdapterHelper);
                    }
                } else {
                    JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, Resource.getString("CCOH_LICENSE_NOT_FOUND_MSG"), Resource.getString("CCOH_LICENSE_NOT_FOUND_TITLE", "LSI Nytro XD license not found"), -1, 1);
                }
            } else if (sL_CCOH_DEV_LIST_T.getCount() > ((SL_CCOH_CONFIG_T)object3).getCacheDeviceList().getCount()) {
                object2 = new CCOHConfigurationEngine(cCOHVirtualAdapterHelper, true, false);
                objectArray = new Object[2];
                StringBuffer stringBuffer = new StringBuffer();
                objectArray[0] = stringBuffer.append(Resource.getString("NEW_CACHE_DEVS_DETECTED_MSG1", "<html>The following Cache devices are not part of a cache<br>group:<br><br>"));
                objectArray[1] = stringBuffer.append(this.getNewCacheDevsText((CCOHConfigurationEngine)object2));
                objectArray[2] = stringBuffer.append(Resource.getString("NEW_CACHE_DEVS_DETECTED_MSG2", "<br>Would you like to add these cache devices to the cache<br>group now?</html>"));
                object = MessageFormat.format(Resource.getString("NEW_CACHE_DEVS_DETECTED_MSG_NEW"), objectArray);
                if (CustomMsgBox.confirm(VivaldiStartupDialog.mainScreen, (String)object, Resource.getString("NEW_CACHE_DEVS_DETECTED_TITLE", "New Cache Devices Detected"), 1)) {
                    new CCOHManageCacheDevicesDialog(cCOHVirtualAdapterHelper, (CCOHConfigurationEngine)object2);
                }
            }
        }
        int n3 = 0;
        if (serverHelper != null) {
            for (int i = 0; i < adapterHelperArray.length; ++i) {
                n3 = ((SASAdapter)adapterHelperArray[i].getDeviceObject()).getInformation().getAdapterStatus_MR_CTRL_INFO().getHeadLessMode();
                arrayList.add(((SASAdapter)adapterHelperArray[i].getDeviceObject()).getInformation().getAdapterStatus_MR_CTRL_INFO().getHeadLessMode());
                if (n3 != 1) continue;
                arrayList2.add(Resource.zeroTrim(((SASAdapter)adapterHelperArray[i].getDeviceObject()).getInformation().getproductName()) + Resource.getString("BUS", "(Bus ") + ((SASAdapter)adapterHelperArray[i].getDeviceObject()).getPciInformation().getbusNumber() + Resource.getString("DEV", ",Dev ") + ((SASAdapter)adapterHelperArray[i].getDeviceObject()).getPciInformation().getdeviceNumber() + ")");
            }
        }
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            int n4 = 0;
            n4 = (Integer)arrayList.get(i);
            if (n4 != 1) continue;
            bl = true;
            break;
        }
        if (bl) {
            final VivaldiBaseDialog vivaldiBaseDialog = new VivaldiBaseDialog();
            vivaldiBaseDialog.setBackground(Color.WHITE);
            vivaldiBaseDialog.setTitle(Resource.getString("CTRL_SAFE_MODE_TITLE", "Controller In Safe Mode"));
            object3 = new JLabel();
            ((JLabel)object3).setText(Resource.getString("BOOT_ERROR_HANDLING_MESSAGE", ""));
            object2 = new DefaultTableModel();
            objectArray = new JTable((TableModel)object2);
            ((DefaultTableModel)object2).addColumn(Resource.getString("CTRL_SAFE_MODE_COLMN", "Controller(s) In Safe mode"));
            for (int i = 0; i < arrayList2.size(); ++i) {
                ((DefaultTableModel)object2).addRow(new Object[]{arrayList2.get(i)});
            }
            ImageIcon imageIcon2 = Resource.getImage("WARNING");
            object = new JButton();
            ((AbstractButton)object).setText(Resource.getString("BUTTON_CLOSE_SAFEMODE_LIST", "Close"));
            JPanel jPanel7 = new JPanel();
            jPanel7.add((Component)object);
            JPanel jPanel8 = new JPanel(new BorderLayout());
            JPanel jPanel9 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 40);
            JLabel jLabel4 = new JLabel(Resource.getString("CTRLS_IN_SAFE_MODE", "The following Controller(s) are running in safe mode."));
            jLabel4.setIcon(imageIcon2);
            gridBagConstraints3.anchor = 18;
            jPanel9.add((Component)jLabel4, gridBagConstraints3);
            ++gridBagConstraints3.gridy;
            jPanel9.add((Component)object3, gridBagConstraints3);
            JScrollPane jScrollPane = new JScrollPane((Component)objectArray, 20, 30);
            jScrollPane.setPreferredSize(new Dimension(300, 125));
            jPanel8.add((Component)jPanel9, "First");
            jPanel8.add((Component)jScrollPane, "Center");
            jPanel8.add((Component)jPanel7, "Last");
            vivaldiBaseDialog.getContentPane().add(jPanel8);
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    vivaldiBaseDialog.dispose();
                }
            });
            vivaldiBaseDialog.getContentPane().add((Component)jPanel8, "Center");
            vivaldiBaseDialog.setResizable(false);
            vivaldiBaseDialog.setModal(true);
            vivaldiBaseDialog.pack();
            GUIUtils.centerDialogOnScreen(vivaldiBaseDialog);
            vivaldiBaseDialog.setVisible(true);
        }
    }

    public String getNewCacheDevsText(CCOHConfigurationEngine cCOHConfigurationEngine) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<AdapterHelper> arrayList = cCOHConfigurationEngine.getHelpersForCacheDevsToBeAdded();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(cCOHConfigurationEngine.getHelperCDText(arrayList.get(i)));
            stringBuffer.append("<br>");
        }
        return stringBuffer.toString();
    }

    public void loginToServer(SASServer sASServer, int n) {
        Object object;
        server = sASServer;
        serverHelper = new ServerObjectHelper(sASServer);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.logOut();
                HelpContext.unregisterHelp(VivaldiStartupDialog.mainScreen);
                ((SASKernel)server.parent()).destroyKernel();
            }
        });
        fullAccess = n == 0;
        this.logger = new JLogger();
        try {
            object = Locale.getDefault().getLanguage().getBytes();
            byte[] byArray = new byte[2];
            byte[] byArray2 = Locale.getDefault().getCountry().getBytes();
            System.arraycopy(byArray2, 0, byArray, 0, Math.min(byArray.length, byArray2.length));
            this.writeLog("LOGON");
            if (!server.isCIMOMServer()) {
                server.registerLogRecord((byte[])object, byArray);
                this.logger.getInitialLog(server.readLogRecord(1, 3000, (byte[])object, byArray));
            } else {
                isManageCIMOM = server.manageCIMMOMServer();
                System.out.println("Going 2 get Initial log 4 CIMOM server");
                this.logger.getCIMOMInitialLog(server.getCIMOMIP(), 3000);
            }
            this.logger.registerToServer(server, serverHelper.getAdapterHelpers());
            this.logger.registerToServer(server, serverHelper.getCCOHVirtualAdapHelper());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tabbedPane = new CustomTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (MainFrame.this.tabbedPane.getSelectedIndex() < 0) {
                    return;
                }
                if (MainFrame.this.tabbedPane.getSelectedIndex() == 0) {
                    MainFrame.this.updateDetailsPanel(null);
                } else {
                    DeviceTree deviceTree = ((DevicePanel)MainFrame.this.tabPanels[MainFrame.this.tabbedPane.getSelectedIndex()]).getTree();
                    if (deviceTree.getSelectedNode() == null) {
                        deviceTree.setSelectionRow(0);
                    }
                    MainFrame.this.updateDetailsPanel(deviceTree.getSelectedNode());
                }
            }
        });
        object = new LastScreenPosition();
        object.selectedTreeNodeObjectID = sASServer.getID();
        this.reboot((LastScreenPosition)object);
        server.RegistrationCommandForAEN();
        int n2 = 1;
        int n3 = 1;
        if (MainFrame.SCREEN_SIZE.height < 700) {
            n2 = 4;
            n3 = 5;
        }
        this.mainTabbedPane.addTab(sASServer.getSvrWWN(), null, this.tabbedPane, sASServer.getSvrWWN());
        this.startPollThread();
        this.updateMenu();
    }

    private void updateMenu() {
        Component[] componentArray = this.fileMenu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem = (JMenuItem)componentArray[i];
            String string = jMenuItem.getActionCommand();
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                System.out.println("got exp");
            }
            if (n != 1004 && n != 1005 && n != 1123 && n != 1128) continue;
            if (serverHelper != null) {
                jMenuItem.addActionListener(new GroupMenuListener(serverHelper));
                jMenuItem.setEnabled(true);
                continue;
            }
            jMenuItem.setEnabled(false);
        }
    }

    public int getSelectedView() {
        return this.tabbedPane.getSelectedIndex();
    }

    private void populateMenuItems() {
        JMenuItem jMenuItem;
        Object object;
        boolean bl;
        Object object2;
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_MANAGE_TEXT"));
        this.fileMenu = new JMenu(stringArray[0]);
        if (stringArray.length == 2) {
            this.fileMenu.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_GRCHKCONSISTENCY_TEXT", "Check Consistency"));
        JMenuItem jMenuItem2 = new JMenuItem(stringArray[0]);
        if (stringArray.length == 2) {
            jMenuItem2.setMnemonic(stringArray[1].charAt(0));
        }
        jMenuItem2.setActionCommand("1004");
        boolean bl2 = false;
        if (serverHelper != null) {
            object2 = this.getServerHelper().getAdapterHelpers();
            for (int i = 0; i < ((AdapterHelper[])object2).length; ++i) {
                if (object2[i].getCCCapableLogicalDrives().length <= 0) continue;
                bl2 = true;
                break;
            }
        }
        if (serverHelper != null && bl2 && fullAccess) {
            jMenuItem2.addActionListener(new GroupMenuListener(serverHelper));
            jMenuItem2.setEnabled(true);
        } else {
            jMenuItem2.setEnabled(false);
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_GRPROGRESS_TEXT", "Show Progress"));
        object2 = new JMenuItem(stringArray[0]);
        if (stringArray.length == 2) {
            ((AbstractButton)object2).setMnemonic(stringArray[1].charAt(0));
        }
        ((AbstractButton)object2).setActionCommand("1123");
        if (serverHelper != null) {
            ((AbstractButton)object2).addActionListener(new GroupMenuListener(serverHelper));
            AdapterHelper[] adapterHelperArray = this.getServerHelper().getAdapterHelpers();
            bl = this.isNonWarhawkHBAExists();
            ((JMenuItem)object2).setEnabled(bl);
        } else {
            ((JMenuItem)object2).setEnabled(false);
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_GRINITIALIZE_TEXT", "Initialize"));
        JMenuItem jMenuItem3 = new JMenuItem(stringArray[0]);
        jMenuItem3.setActionCommand("1005");
        if (stringArray.length == 2) {
            jMenuItem3.setMnemonic(stringArray[1].charAt(0));
        }
        bl = false;
        if (serverHelper != null) {
            object = this.getServerHelper().getAdapterHelpers();
            for (int i = 0; i < ((AdapterHelper[])object).length; ++i) {
                if (object[i].getLogicalDrives() == null || object[i].getLogicalDrives().length <= 0 || ((SASAdapter)((AdapterHelper)object[i]).getDeviceObject()).isWarhawk()) continue;
                bl = true;
                break;
            }
        }
        if (serverHelper != null && bl && fullAccess) {
            jMenuItem3.addActionListener(new GroupMenuListener(serverHelper));
            jMenuItem3.setEnabled(true);
        } else {
            jMenuItem3.setEnabled(false);
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_RESCAN_TEXT"));
        object = new JMenuItem(stringArray[0]);
        ((AbstractButton)object).setMnemonic(82);
        if (stringArray.length == 2) {
            ((AbstractButton)object).setMnemonic(stringArray[1].charAt(0));
        }
        if (serverHelper != null) {
            ((JMenuItem)object).setAccelerator(KeyStroke.getKeyStroke(116, 0));
            ((AbstractButton)object).setActionCommand("1001");
            ((AbstractButton)object).addActionListener(new GroupMenuListener(server));
        } else {
            ((JMenuItem)object).setEnabled(false);
        }
        ((AbstractButton)object).addActionListener(new GroupMenuListener(server));
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_EXIT_TEXT", "Exit"));
        String[] stringArray2 = Resource.getResourceMnemonic(Resource.getString("SERVERS_BUTTON_TEXT", "Servers"));
        this.serversMenu = new JMenuItem(stringArray2[0]);
        if (stringArray2.length == 2) {
            this.serversMenu.setMnemonic(stringArray2[1].charAt(0));
        }
        this.serversMenu.setToolTipText(Resource.getString("SERVERS_BUTTON_TEXT", "Servers"));
        this.serversMenu.setActionCommand("1002");
        this.serversMenu.addActionListener(new GroupMenuListener());
        JMenuItem jMenuItem4 = new JMenuItem(stringArray[0]);
        jMenuItem4.setMnemonic(88);
        if (stringArray.length == 2) {
            jMenuItem4.setMnemonic(stringArray[1].charAt(0));
        }
        jMenuItem4.setActionCommand("1003");
        jMenuItem4.addActionListener(new GroupMenuListener());
        this.fileMenu.add((JMenuItem)object);
        this.fileMenu.addSeparator();
        if (!VivaldiStartupDialog.isStandAloneMode) {
            this.fileMenu.add(this.serversMenu);
            this.fileMenu.addSeparator();
        }
        this.fileMenu.add(jMenuItem2);
        this.fileMenu.addSeparator();
        this.fileMenu.add(jMenuItem3);
        this.fileMenu.addSeparator();
        this.fileMenu.add((JMenuItem)object2);
        this.fileMenu.addSeparator();
        this.fileMenu.add(jMenuItem4);
        this.menubar.add(this.fileMenu);
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_OPERATION_TEXT", "Go To"));
        this.opMenu = new JMenu(stringArray[0]);
        if (stringArray.length == 2) {
            this.opMenu.setMnemonic(stringArray[1].charAt(0));
        }
        String[] stringArray3 = Resource.getResourceMnemonic(Resource.getString("MENU_SERVER", "(S)erver"));
        JMenu jMenu = new JMenu(stringArray3[0]);
        if (stringArray3.length == 2) {
            jMenu.setMnemonic(stringArray3[1].charAt(0));
        }
        jMenu.setName("Server");
        String[] stringArray4 = Resource.getResourceMnemonic(Resource.getString("MENU_CACHE_GROUP", "Cache (G)roup"));
        JMenu jMenu2 = new JMenu(stringArray4[0]);
        if (stringArray4.length == 2) {
            jMenu2.setMnemonic(stringArray4[1].charAt(0));
        }
        jMenu2.setName("Cache Group");
        stringArray4 = Resource.getResourceMnemonic(Resource.getString("MENU_CONTROLLER", "Controller"));
        JMenu jMenu3 = new JMenu(stringArray4[0]);
        if (stringArray4.length == 2) {
            jMenu3.setMnemonic(stringArray4[1].charAt(0));
        }
        jMenu3.setName("Controller");
        stringArray4 = Resource.getResourceMnemonic(Resource.getString("MENU_DRIVEGROUP", "Drive Group"));
        JMenu jMenu4 = new JMenu(stringArray4[0]);
        if (stringArray4.length == 2) {
            jMenu4.setMnemonic(stringArray4[1].charAt(0));
        }
        jMenu4.setName("Drive Group");
        stringArray4 = Resource.getResourceMnemonic(Resource.getString("MENU_PHYSICALDRIVE", "Physical Drive"));
        JMenu jMenu5 = new JMenu(stringArray4[0]);
        if (stringArray4.length == 2) {
            jMenu5.setMnemonic(stringArray4[1].charAt(0));
        }
        jMenu5.setName("Physical Drive");
        stringArray4 = Resource.getResourceMnemonic(Resource.getString("MENU_VIRTUALDRIVE", "Virtual Drive"));
        JMenu jMenu6 = new JMenu(stringArray4[0]);
        if (stringArray4.length == 2) {
            jMenu6.setMnemonic(stringArray4[1].charAt(0));
        }
        jMenu6.setName("Virtual Drive");
        stringArray4 = Resource.getResourceMnemonic(Resource.getString("MENU_BBU", "BBU"));
        JMenu jMenu7 = new JMenu(stringArray4[0]);
        if (stringArray4.length == 2) {
            jMenu7.setMnemonic(stringArray4[1].charAt(0));
        }
        jMenu7.setName("BBU");
        if (serverHelper != null && serverHelper.isCCOHinitialised()) {
            this.opMenu.add(jMenu);
            this.opMenu.add(jMenu2);
        }
        this.opMenu.add(jMenu3);
        this.opMenu.add(jMenu4);
        this.opMenu.add(jMenu5);
        this.opMenu.add(jMenu6);
        this.opMenu.add(jMenu7);
        jMenu.setEnabled(false);
        jMenu2.setEnabled(false);
        jMenu3.setEnabled(false);
        jMenu4.setEnabled(false);
        jMenu5.setEnabled(false);
        jMenu6.setEnabled(false);
        jMenu7.setEnabled(false);
        this.opMenu.setVisible(fullAccess);
        this.menubar.add(this.opMenu);
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_LOG_TEXT", "Log"));
        this.logMenu = new JMenu(stringArray[0]);
        if (stringArray.length == 2) {
            this.logMenu.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_LOGSAVE_TEXT", "Save"));
        JMenuItem jMenuItem5 = new JMenuItem(stringArray[0]);
        if (server != null) {
            if (stringArray.length == 2) {
                jMenuItem5.setMnemonic(stringArray[1].charAt(0));
            }
            jMenuItem5.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.saveLogInFile();
                }
            });
            this.logMenu.add(jMenuItem5);
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_LOGSAVE_TEXT_FORMAT", "Save as Text"));
        JMenuItem jMenuItem6 = new JMenuItem(stringArray[0]);
        if (stringArray.length == 2) {
            jMenuItem6.setMnemonic(stringArray[1].charAt(0));
        }
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.saveLogInTextFile();
            }
        });
        this.logMenu.add(jMenuItem6);
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_LOGCLEAR_TEXT", "Clear"));
        JMenuItem jMenuItem7 = new JMenuItem(stringArray[0]);
        if (stringArray.length == 2) {
            jMenuItem7.setMnemonic(stringArray[1].charAt(0));
        }
        jMenuItem7.setEnabled(fullAccess);
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.clearLogRecords();
            }
        });
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_LOGVIEW_TEXT", "Load"));
        JMenuItem jMenuItem8 = new JMenuItem(stringArray[0]);
        if (stringArray.length == 2) {
            jMenuItem8.setMnemonic(stringArray[1].charAt(0));
        }
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.loadLogRecord();
            }
        });
        this.logMenu.addSeparator();
        this.logMenu.add(jMenuItem7);
        this.logMenu.addSeparator();
        this.logMenu.add(jMenuItem8);
        if (JLogger.getCurrentMode() == 1) {
            jMenuItem = new JMenuItem(Resource.getResourceMnemonic(Resource.getString("MENU_LOGREMOTE_TEXT", "Revert to Current Log"))[0]);
            if (Resource.getResourceMnemonic(Resource.getString("MENU_LOGREMOTE_TEXT", "Revert to Current Log")).length == 2) {
                jMenuItem.setMnemonic(Resource.getResourceMnemonic(Resource.getString("MENU_LOGREMOTE_TEXT", "Revert to Current Log"))[1].charAt(0));
            }
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.logMenu.remove(MainFrame.this.logMenu.getItemCount() - 1);
                    MainFrame.this.logger.changeMode(0);
                    MainFrame.this.logLabel.setText(Resource.getString("STATUS_LOG_SERVER", "Displaying log from server"));
                    MainFrame.this.logMenu.getItem(0).setEnabled(true);
                    MainFrame.this.logMenu.getItem(1).setEnabled(true);
                    MainFrame.this.logMenu.getItem(3).setEnabled(true);
                }
            });
            this.logMenu.add(jMenuItem);
            jMenuItem6.setEnabled(false);
            jMenuItem5.setEnabled(false);
            jMenuItem7.setEnabled(false);
        }
        this.menubar.add(this.logMenu);
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_TOOLS_TEXT", "Tools"));
        this.toolsMenu = new JMenu(stringArray[0]);
        if (stringArray.length == 2) {
            this.toolsMenu.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_CONFIGURE_TEXT", "Configure"));
        jMenuItem = new JMenu(stringArray[0]);
        if (stringArray.length == 2) {
            jMenuItem.setMnemonic(stringArray[1].charAt(0));
        }
        this.populateConfigurators(this.toolsMenu);
        if (VivaldiStartupDialog.useEmailCOnfigurator) {
            VivaldiStartupDialog.closeonLogoff = true;
            VivaldiStartupDialog.displayVivaldiStartupDialog(false);
        }
        this.toolsMenu.setVisible(fullAccess);
        if (server != null) {
            this.menubar.add(this.toolsMenu);
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_HELP_TEXT", "Help"));
        this.helpMenu = new JMenu(stringArray[0]);
        if (stringArray.length == 2) {
            this.helpMenu.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_HELPME_TEXT", "Contents"));
        JMenuItem jMenuItem9 = new JMenuItem(stringArray[0]);
        if (stringArray.length == 2) {
            jMenuItem9.setMnemonic(stringArray[1].charAt(0));
        }
        this.helpMenu.add(jMenuItem9);
        jMenuItem9.setActionCommand("3000");
        jMenuItem9.addActionListener(new GroupMenuListener());
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_ABOUT_TEXT", "About MegaRAID Storage Manager"));
        JMenuItem jMenuItem10 = new JMenuItem(stringArray[0]);
        if (stringArray.length == 2) {
            jMenuItem10.setMnemonic(stringArray[1].charAt(0));
        }
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog aboutDialog = new AboutDialog(server);
                aboutDialog.setLocation((MainFrame.SCREEN_SIZE.width - aboutDialog.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - aboutDialog.getHeight()) / 2);
                aboutDialog.show();
            }
        });
        this.helpMenu.add(jMenuItem10);
        this.menubar.add(this.helpMenu);
    }

    private void populateConfigurators(JMenu jMenu) {
        this.configManager = ConfiguratorManager.getInstance(this);
        this.configManager.discoverConfigurators();
        if (this.configManager.getConfiguratorCount() > 0) {
            ConfiguratorInfo[] configuratorInfoArray = this.configManager.getConfiguratorList();
            for (int i = 0; i < configuratorInfoArray.length; ++i) {
                JMenuItem jMenuItem = new JMenuItem(configuratorInfoArray[i].getName());
                jMenuItem.setMnemonic(configuratorInfoArray[i].getName().charAt(0));
                if (VivaldiStartupDialog.useEmailCOnfigurator) {
                    jMenuItem.setActionCommand(configuratorInfoArray[i].getName());
                    if (configuratorInfoArray[i].getName().equalsIgnoreCase("Monitor Configure Alerts")) {
                        try {
                            this.configManager.invokeConfigurator(configuratorInfoArray[i].getName());
                        }
                        catch (VKObjectNotPresentException vKObjectNotPresentException) {
                            new CustomMsgBox(Resource.getString("MSG_COMPONENT_NOT_RUNNING_ERROR", "Error : One or more target component is not running."));
                        }
                        catch (VKNotRespondingException vKNotRespondingException) {
                            new CustomMsgBox(Resource.getString("MSG_CONFIGURATOR_NOT_RESPONDING_ERROR", "Error : Configurator not responding."));
                        }
                        catch (VKInvalidOperationException vKInvalidOperationException) {
                            new CustomMsgBox(Resource.getString("MSG_CONFIGURATOR_INVALID_OPERATION_ERROR", "Error : Invalid operation."));
                        }
                        catch (VKOperationFailedException vKOperationFailedException) {
                            new CustomMsgBox(Resource.getString("MSG_CONFIGURATOR_OPERATION_FAILED_ERROR", "Error : Operation failed."));
                        }
                        catch (Exception exception) {
                            new CustomMsgBox(Resource.getString("MSG_CONFIGURATOR_EXCEPTION_ERROR", "Error : Unknown exception."));
                        }
                    }
                } else {
                    jMenuItem.setActionCommand(configuratorInfoArray[i].getName());
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                MainFrame.this.configManager.invokeConfigurator(actionEvent.getActionCommand());
                            }
                            catch (VKObjectNotPresentException vKObjectNotPresentException) {
                                new CustomMsgBox(Resource.getString("MSG_COMPONENT_NOT_RUNNING_ERROR", "Error : One or more target component is not running."));
                            }
                            catch (VKNotRespondingException vKNotRespondingException) {
                                new CustomMsgBox(Resource.getString("MSG_CONFIGURATOR_NOT_RESPONDING_ERROR", "Error : Configurator not responding."));
                            }
                            catch (VKInvalidOperationException vKInvalidOperationException) {
                                new CustomMsgBox(Resource.getString("MSG_CONFIGURATOR_INVALID_OPERATION_ERROR", "Error : Invalid operation."));
                            }
                            catch (VKOperationFailedException vKOperationFailedException) {
                                new CustomMsgBox(Resource.getString("MSG_CONFIGURATOR_OPERATION_FAILED_ERROR", "Error : Operation failed."));
                            }
                            catch (Exception exception) {
                                new CustomMsgBox(Resource.getString("MSG_CONFIGURATOR_EXCEPTION_ERROR", "Error : Unknown exception."));
                            }
                        }
                    });
                }
                jMenu.add(jMenuItem);
                jMenuItem.setVisible(false);
                if (server.isCIMOMServer()) {
                    if (this.configManager.isCIMOMMonitor(configuratorInfoArray[i])) {
                        jMenuItem.setVisible(true);
                    }
                    if (this.configManager.isMonitorPlugin(configuratorInfoArray[i])) {
                        jMenuItem.setVisible(false);
                    }
                    if (!this.configManager.isMRMonitor(configuratorInfoArray[i])) continue;
                    jMenuItem.setVisible(false);
                    continue;
                }
                if (this.configManager.isCIMOMMonitor(configuratorInfoArray[i])) {
                    jMenuItem.setVisible(false);
                }
                if (this.configManager.isMonitorPlugin(configuratorInfoArray[i])) {
                    jMenuItem.setVisible(true);
                }
                if (!this.configManager.isMRMonitor(configuratorInfoArray[i])) continue;
                jMenuItem.setVisible(true);
            }
        }
    }

    private void populatePlugins(JMenu jMenu) {
        File file = new File(".\\Classes\\Plugins");
        if (!file.isDirectory()) {
            return;
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".class");
            }
        };
        String[] stringArray = file.list(filenameFilter);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object obj = Class.forName("Plugins." + stringArray[i].substring(0, stringArray[i].length() - 6)).newInstance();
                if (!(obj instanceof GUIPluginBase)) continue;
                GUIPluginBase gUIPluginBase = (GUIPluginBase)obj;
                this.m_pluginHash.put(gUIPluginBase.getName(), gUIPluginBase);
                JMenuItem jMenuItem = new JMenuItem(gUIPluginBase.getName());
                jMenuItem.setToolTipText(gUIPluginBase.getDescription());
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                        GUIPluginBase gUIPluginBase = (GUIPluginBase)MainFrame.this.m_pluginHash.get(jMenuItem.getText());
                        gUIPluginBase.show();
                    }
                });
                jMenu.add(jMenuItem);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JMenu getDynamicMenu() {
        return this.opMenu;
    }

    public void updateDetailsPanel(DeviceTreeNode deviceTreeNode) {
        if (this.tabbedPane.getSelectedComponent() instanceof DevicePanel) {
            DetailPanel detailPanel;
            Container container = ((DevicePanel)this.tabbedPane.getSelectedComponent()).getRightPane();
            container.removeAll();
            if (deviceTreeNode == null) {
                return;
            }
            this.currentPanel = detailPanel = (DetailPanel)this.loadDynamic(deviceTreeNode);
            if (this.currentPanel != null) {
                this.menubar.removeAll();
                this.populateMenuItems();
                this.currentPanel.setOperationMenu();
                this.toolBarEnabledOpers = this.currentPanel.getEnabledOpers();
                GUIHelperInterface gUIHelperInterface = this.currentPanel.getGUIHelperInterface();
                this.updateToolBar(gUIHelperInterface);
            }
            if (detailPanel != null) {
                container.add(detailPanel);
            }
            container.validate();
            container.repaint();
        }
        this.validate();
        this.repaint();
    }

    public Object loadDynamic(DeviceTreeNode deviceTreeNode) {
        ISASObject iSASObject = deviceTreeNode.getObjectManager().getDeviceObject();
        if (iSASObject != null && this.m_objHash.containsKey(iSASObject)) {
            return this.m_objHash.get(iSASObject);
        }
        String string = deviceTreeNode.getDetailClassName();
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Object[] objectArray = new Object[]{deviceTreeNode.getObjectManager(), this};
            Object obj = constructorArray[0].newInstance(objectArray);
            if (iSASObject != null) {
                this.m_objHash.put(iSASObject, obj);
            }
            return obj;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public JLogger getLog() {
        return this.logger;
    }

    public DetailPanel getCurrentPanel() {
        return this.currentPanel;
    }

    public void logOut() {
        try {
            this.writeLog("LOGOUT");
            server.unregisterLog();
            server.logout();
        }
        catch (Exception exception) {
            System.out.println("Logout failure !");
        }
    }

    public int logoffServer() {
        try {
            this.writeLog("LOGOUT");
            server.unregisterLog();
            server.logout();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Logout failure !");
            return 1;
        }
        return 0;
    }

    public void setStandAloneMode(boolean bl) {
        toolBar.setVisible(!bl);
    }

    public DeviceTree getPhysicalTree() {
        return ((DevicePanel)this.tabPanels[1]).getTree();
    }

    public DeviceTree getLogicalTree() {
        return ((DevicePanel)this.tabPanels[2]).getTree();
    }

    public void displayManagePreservedCache() {
        AdapterHelper[] adapterHelperArray = this.getServerHelper().getAdapterHelpers();
        for (int i = 0; i < adapterHelperArray.length; ++i) {
            if (adapterHelperArray[i].getAdapterInfo().getCacheIsPinned() == 0 || adapterHelperArray[i].getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getforeignConfigImport() == 0) continue;
            new ManagePreservedCacheDialog(adapterHelperArray[i]);
        }
    }

    public void refreshTree(LastScreenPosition lastScreenPosition) {
        JComponent jComponent;
        if (lastScreenPosition == null) {
            return;
        }
        if (lastScreenPosition.topTabIndex == 0) {
            jComponent = ((DashboardPanel)this.tabPanels[0]).getControllerTabbedPane();
            if (((JTabbedPane)jComponent).getTabCount() > lastScreenPosition.selectedTreeNodeObjectID) {
                ((JTabbedPane)jComponent).setSelectedIndex(lastScreenPosition.selectedTreeNodeObjectID);
            } else {
                ((JTabbedPane)jComponent).setSelectedIndex(0);
            }
        }
        if (lastScreenPosition.topTabIndex > 0) {
            jComponent = lastScreenPosition.topTabIndex == 1 ? this.getPhysicalTree() : this.getLogicalTree();
            if (this.selectTreeNode((DeviceTree)jComponent, (DeviceTreeNode)((JTree)jComponent).getModel().getRoot(), lastScreenPosition.selectedTreeNodeType, lastScreenPosition.selectedTreeNodeObjectID, lastScreenPosition.topTabIndex)) {
                if (this.getCurrentPanel() != null) {
                    this.getCurrentPanel().gotoTab(lastScreenPosition.detailPanelTabIndex);
                }
            } else {
                ((JTree)jComponent).setSelectionRow(-1);
                ((JTree)jComponent).setSelectionRow(0);
                nodeindex = 0;
            }
        }
    }

    public void reboot(LastScreenPosition lastScreenPosition) {
        System.out.println("inside reboot");
        Collection collection = this.m_objHash.values();
        Object object = collection.iterator();
        while (object.hasNext()) {
            ((DetailPanel)object.next()).canClose();
        }
        this.m_objHash.clear();
        this.tabbedPane.removeAll();
        if (!(this.tabPanels[0] instanceof DashboardPanel)) {
            this.tabPanels[0] = new DashboardPanel(serverHelper);
        } else {
            ((DashboardPanel)this.tabPanels[0]).updateControllerTabs(serverHelper);
        }
        this.tabPanels[1] = new PhysicalDevicePanel(this);
        this.tabPanels[2] = new LogicalDevicePanel(this);
        this.tabbedPane.addTab(Resource.getString("DASHBOARD_TAB_TEXT", "Dashboard"), null, this.tabPanels[0], Resource.getString("DASHBOARD_TAB_TEXT", "Dashboard"));
        this.tabbedPane.addTab(Resource.getString("PHYSICAL_TAB_TEXT", "Physical"), null, this.tabPanels[1], Resource.getString("PHYSICAL_TAB_TEXT", "Physical"));
        this.tabbedPane.addTab(Resource.getString("LOGICAL_TAB_TEXT", "Logical"), null, this.tabPanels[2], Resource.getString("LOGICAL_TAB_TEXT", "Logical"));
        if (lastScreenPosition == null) {
            return;
        }
        this.tabbedPane.setSelectedIndex(lastScreenPosition.topTabIndex);
        if (lastScreenPosition.topTabIndex == 0) {
            object = ((DashboardPanel)this.tabPanels[0]).getControllerTabbedPane();
            if (((JTabbedPane)object).getTabCount() > lastScreenPosition.selectedTreeNodeObjectID) {
                ((JTabbedPane)object).setSelectedIndex(lastScreenPosition.selectedTreeNodeObjectID);
            } else {
                ((JTabbedPane)object).setSelectedIndex(0);
            }
        }
        if (lastScreenPosition.topTabIndex > 0) {
            object = lastScreenPosition.topTabIndex == 1 ? this.getPhysicalTree() : this.getLogicalTree();
            if (this.selectTreeNode((DeviceTree)object, (DeviceTreeNode)((JTree)object).getModel().getRoot(), lastScreenPosition.selectedTreeNodeType, lastScreenPosition.selectedTreeNodeObjectID, lastScreenPosition.topTabIndex)) {
                if (this.getCurrentPanel() != null) {
                    this.getCurrentPanel().gotoTab(lastScreenPosition.detailPanelTabIndex);
                }
            } else {
                ((JTree)object).setSelectionRow(-1);
                ((JTree)object).setSelectionRow(0);
                nodeindex = 0;
            }
        }
    }

    public void refreshVirtualPanel() {
        this.tabbedPane.remove(this.tabPanels[2]);
        this.tabPanels[2] = new LogicalDevicePanel(this);
        this.tabbedPane.insertTab(Resource.getString("LOGICAL_TAB_TEXT", "Logical"), null, this.tabPanels[2], Resource.getString("LOGICAL_TAB_TEXT", "Logical"), 2);
        this.tabbedPane.validate();
        this.tabbedPane.repaint();
        this.validate();
        this.repaint();
    }

    public void selectPreviousNode(LastScreenPosition lastScreenPosition) {
        JComponent jComponent;
        this.tabbedPane.setSelectedIndex(lastScreenPosition.topTabIndex);
        if (lastScreenPosition.topTabIndex == 0) {
            jComponent = ((DashboardPanel)this.tabPanels[0]).getControllerTabbedPane();
            if (((JTabbedPane)jComponent).getTabCount() > lastScreenPosition.selectedTreeNodeObjectID) {
                ((JTabbedPane)jComponent).setSelectedIndex(lastScreenPosition.selectedTreeNodeObjectID);
            } else {
                ((JTabbedPane)jComponent).setSelectedIndex(0);
            }
        }
        if (lastScreenPosition.topTabIndex > 0) {
            jComponent = lastScreenPosition.topTabIndex == 1 ? this.getPhysicalTree() : this.getLogicalTree();
            if (this.selectTreeNode((DeviceTree)jComponent, (DeviceTreeNode)((JTree)jComponent).getModel().getRoot(), lastScreenPosition.selectedTreeNodeType, lastScreenPosition.selectedTreeNodeObjectID, lastScreenPosition.topTabIndex)) {
                if (this.getCurrentPanel() != null) {
                    this.getCurrentPanel().gotoTab(lastScreenPosition.detailPanelTabIndex);
                }
            } else {
                ((JTree)jComponent).setSelectionRow(-1);
                ((JTree)jComponent).setSelectionRow(0);
                nodeindex = 0;
            }
        }
    }

    private void updateLogicalTree() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VivaldiStartupDialog.mainScreen.getLogicalTree().updateUI();
            }
        });
    }

    private void updatePhysicalTree() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VivaldiStartupDialog.mainScreen.getPhysicalTree().updateUI();
            }
        });
    }

    public void refreshPhysicalPanel() {
        this.tabbedPane.remove(this.tabPanels[1]);
        this.tabPanels[1] = new PhysicalDevicePanel(this);
        this.tabbedPane.insertTab(Resource.getString("PHYSICAL_TAB_TEXT", "Physical"), null, this.tabPanels[1], Resource.getString("PHYSICAL_TAB_TEXT", "Physical"), 1);
        this.tabbedPane.validate();
        this.tabbedPane.repaint();
        this.validate();
        this.repaint();
    }

    public void refreshPeerServerNode() {
        clusterHelper = new SasClusterObjectHelper();
    }

    private boolean selectTreeNode(DeviceTree deviceTree, DeviceTreeNode deviceTreeNode, int n, int n2, int n3) {
        if (deviceTreeNode.getObjectManager().getType() == n && deviceTreeNode.getObjectManager().getDeviceObject().getID() == n2) {
            deviceTree.setSelectionRow(-1);
            if (n3 == 2) {
                deviceTree.setSelectionRow(nodeindex);
                nodeindex = 0;
            } else {
                deviceTree.setSelectionRow(MainFrame.allNodeListener.rowNumber);
            }
            return true;
        }
        for (int i = 0; i < deviceTreeNode.getChildCount(); ++i) {
            if (n3 == 2) {
                ++nodeindex;
            }
            if (!this.selectTreeNode(deviceTree, (DeviceTreeNode)deviceTreeNode.getChild(i), n, n2, n3)) continue;
            return true;
        }
        return false;
    }

    public void writeLog(String string) {
        String[] stringArray = new String[3];
        stringArray[0] = "";
        if (server.getUsrName() != null) {
            try {
                stringArray[0] = stringArray[0] + new String(server.getUsrName(), "UTF-16LE");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stringArray[1] = "127.0.0.1";
        try {
            if (!VivaldiStartupDialog.isStandAloneMode) {
                stringArray[1] = FrameworkUtilities.getLocalHostAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string.equals("LOGON")) {
            stringArray[2] = fullAccess ? "$ACCESS_FULL" : "$ACCESS_VIEW";
        }
        byte[] byArray = this.logger.getXMLFromTagArray(this.logger.createTagArray(string, stringArray));
        if (!server.isCIMOMServer()) {
            server.writeKernelLogRecord(byArray);
        } else {
            String string2 = new String(byArray);
            this.logger.updateKernelEvent(string2);
        }
    }

    public void saveLogInFile() {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            String string = new String(server.getInformation().getHostName() + "_");
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            string = string + (gregorianCalendar.get(2) + 1) + "_" + gregorianCalendar.get(5) + "_" + gregorianCalendar.get(1) + ".log";
            jFileChooser.setSelectedFile(new File(string));
            if (jFileChooser.showSaveDialog(this.getContentPane()) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (file.exists() && !CustomMsgBox.confirm(this.getContentPane(), Resource.getString("MSG_CONFIRM_LOGOVERWRITE", "File already exists. Do you want to overwrite ?"))) {
                    return;
                }
                byte[] byArray = Locale.getDefault().getLanguage().getBytes();
                byte[] byArray2 = new byte[2];
                byte[] byArray3 = Locale.getDefault().getCountry().getBytes();
                System.arraycopy(byArray3, 0, byArray2, 0, Math.min(byArray2.length, byArray3.length));
                this.writeToFile(file, server.readLogRecord(1, this.logger.getNumRecords(), byArray, byArray2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new CustomMsgBox(Resource.getString("MSG_SAVELOG_INVALIDFILE", "Can not save to the file specified ! Device not ready !"));
            return;
        }
    }

    public void saveLogInTextFile() {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            String string = new String(server.getInformation().getHostName() + "_");
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            string = string + (gregorianCalendar.get(2) + 1) + "_" + gregorianCalendar.get(5) + "_" + gregorianCalendar.get(1) + ".txt";
            jFileChooser.setSelectedFile(new File(string));
            if (jFileChooser.showSaveDialog(this.getContentPane()) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (file.exists() && !CustomMsgBox.confirm(this.getContentPane(), Resource.getString("MSG_CONFIRM_LOGOVERWRITE", "File already exists. Do you want to overwrite ?"))) {
                    return;
                }
                byte[] byArray = Locale.getDefault().getLanguage().getBytes();
                byte[] byArray2 = new byte[2];
                byte[] byArray3 = Locale.getDefault().getCountry().getBytes();
                System.arraycopy(byArray3, 0, byArray2, 0, Math.min(byArray2.length, byArray3.length));
                this.writeToTextFile(file, server.readLogRecord(1, this.logger.getNumRecords(), byArray, byArray2), this.logger.getNumRecords());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new CustomMsgBox(Resource.getString("MSG_SAVELOG_INVALIDFILE", "Can not save to the file specified ! Device not ready !"));
            return;
        }
    }

    private void writeToFile(File file, ArrayList arrayList) throws Exception {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = ((LogXMLParser)arrayList.get(i)).getTagValue("localizedMessage");
            String string2 = "";
            for (int j = 0; j < string.length(); ++j) {
                string2 = string2 + "&#" + NetworkToJavaConverter.unsignedCharToInt(string.charAt(j)) + ";";
            }
            ((LogXMLParser)arrayList.get(i)).setTagValue("localizedMessage", string2);
            String string3 = ((LogXMLParser)arrayList.get(i)).getXML();
            string2 = "";
            for (int j = 0; j < string3.length(); ++j) {
                if (string3.substring(j).startsWith("amp;")) {
                    j += 3;
                    continue;
                }
                string2 = string2 + string3.charAt(j);
            }
            byte[] byArray = string2.getBytes();
            int n = 0;
            int n2 = 0;
            while (n < byArray.length && n2 < byArray.length) {
                if (byArray[n] == 10 || byArray[n] == 13) {
                    ++n;
                    continue;
                }
                byArray[n2++] = byArray[n++];
            }
            printWriter.println(new String(byArray, 0, n2));
        }
        printWriter.close();
    }

    public void clearLogRecords() {
        if (!CustomMsgBox.confirm(this.getContentPane(), Resource.getString("MSG_CONFIRM_LOGDELETE", "This will delete the log. Are you sure ?"))) {
            return;
        }
        if (CustomMsgBox.confirm(this.getContentPane(), Resource.getString("MSG_CONFIRM_LOGSAVE_BEFORE_DELETE", "Do you want to save the existing log ?"))) {
            this.saveLogInFile();
        }
        try {
            if (!server.isCIMOMServer()) {
                server.clearLogRecord();
            } else if (server.isCIMOMServer()) {
                server.clearCIMOMLogRecord();
            }
            this.logger.clear();
            this.writeLog("CLEAR");
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            // empty catch block
        }
    }

    public void loadLogRecord() {
        Object object;
        ArrayList<LogXMLParser> arrayList = new ArrayList<LogXMLParser>();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        if (jFileChooser.showOpenDialog(this.getContentPane()) == 1) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            object = new String();
            while ((object = bufferedReader.readLine()) != null) {
                try {
                    LogXMLParser logXMLParser = new LogXMLParser((String)object);
                    if (logXMLParser.getAttrCount() <= 0) continue;
                    arrayList.add(logXMLParser);
                }
                catch (Exception exception) {}
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.changeMode(1);
        this.logger.clear();
        if (arrayList.size() == 0) {
            this.logLabel.setText(Resource.getString("STATUS_LOG_FILE_ERROR", "No Valid Log found in ") + file.getName());
        } else {
            this.logger.getInitialLog(arrayList);
            this.logLabel.setText(Resource.getString("STATUS_LOG_LOCAL", "Displaying log from file ") + file.getName());
            this.logMenu.getItem(0).setEnabled(false);
            this.logMenu.getItem(1).setEnabled(false);
            this.logMenu.getItem(3).setEnabled(false);
        }
        if (!this.logMenu.getItem(this.logMenu.getItemCount() - 1).getText().equals(Resource.getResourceMnemonic(Resource.getString("MENU_LOGREMOTE_TEXT", "Revert to Current Log"))[0])) {
            object = new JMenuItem(Resource.getResourceMnemonic(Resource.getString("MENU_LOGREMOTE_TEXT", "Revert to Current Log"))[0]);
            if (Resource.getResourceMnemonic(Resource.getString("MENU_LOGREMOTE_TEXT", "Revert to Current Log")).length == 2) {
                ((AbstractButton)object).setMnemonic(Resource.getResourceMnemonic(Resource.getString("MENU_LOGREMOTE_TEXT", "Revert to Current Log"))[1].charAt(0));
            }
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.logMenu.remove(MainFrame.this.logMenu.getItemCount() - 1);
                    MainFrame.this.logger.changeMode(0);
                    MainFrame.this.logLabel.setText(Resource.getString("STATUS_LOG_SERVER", "Displaying log from server"));
                    MainFrame.this.logMenu.getItem(0).setEnabled(true);
                    MainFrame.this.logMenu.getItem(1).setEnabled(true);
                    MainFrame.this.logMenu.getItem(3).setEnabled(true);
                }
            });
            this.logMenu.add((JMenuItem)object);
            this.logMenu.getItem(0).setEnabled(false);
            this.logMenu.getItem(1).setEnabled(false);
            this.logMenu.getItem(3).setEnabled(false);
        }
    }

    public void loadCIMLogRecord() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        if (jFileChooser.showOpenDialog(this.getContentPane()) == 1) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        this.logger.changeMode(1);
        this.logger.clear();
        if (!this.logger.readCIMLogFromFile(file)) {
            this.logLabel.setText(Resource.getString("STATUS_LOG_FILE_ERROR", "No Valid Log found in ") + file.getName());
            this.logger.clear();
        } else {
            this.logLabel.setText(Resource.getString("STATUS_LOG_LOCAL", "Displaying log from file ") + file.getName());
        }
        if (!this.logMenu.getItem(this.logMenu.getItemCount() - 1).getText().equals(Resource.getResourceMnemonic(Resource.getString("MENU_LOGREMOTE_TEXT", "Revert to Current Log"))[0])) {
            JMenuItem jMenuItem = new JMenuItem(Resource.getResourceMnemonic(Resource.getString("MENU_LOGREMOTE_TEXT", "Revert to Current Log"))[0]);
            if (Resource.getResourceMnemonic(Resource.getString("MENU_LOGREMOTE_TEXT", "Revert to Current Log")).length == 2) {
                jMenuItem.setMnemonic(Resource.getResourceMnemonic(Resource.getString("MENU_LOGREMOTE_TEXT", "Revert to Current Log"))[1].charAt(0));
            }
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.logMenu.remove(MainFrame.this.logMenu.getItemCount() - 1);
                    MainFrame.this.logger.changeMode(0);
                    MainFrame.this.logMenu.getItem(1).setEnabled(true);
                    MainFrame.this.logLabel.setText(Resource.getString("STATUS_LOG_SERVER", "Displaying log from server"));
                }
            });
            this.logMenu.add(jMenuItem);
            this.logMenu.getItem(1).setEnabled(false);
        }
    }

    public JMenu getLogMenu() {
        return this.logMenu;
    }

    public ServerObjectHelper getServerHelper() {
        return serverHelper;
    }

    public SasClusterObjectHelper getclusterHelper() {
        return clusterHelper;
    }

    public LastScreenPosition getLastScreenPosition() {
        LastScreenPosition lastScreenPosition = new LastScreenPosition();
        lastScreenPosition.topTabIndex = this.tabbedPane.getSelectedIndex();
        if (lastScreenPosition.topTabIndex == 0) {
            JTabbedPane jTabbedPane = ((DashboardPanel)this.tabPanels[0]).getControllerTabbedPane();
            lastScreenPosition.selectedTreeNodeObjectID = jTabbedPane != null ? jTabbedPane.getSelectedIndex() : 0;
        } else {
            DeviceTree deviceTree = ((DevicePanel)this.tabPanels[lastScreenPosition.topTabIndex]).getTree();
            if (deviceTree == null || deviceTree.getSelectionCount() <= 0 || deviceTree.getSelectedNode() == null) {
                return lastScreenPosition;
            }
            GUIHelperInterface gUIHelperInterface = deviceTree.getSelectedNode().getObjectManager();
            if (gUIHelperInterface == null || gUIHelperInterface.getDeviceObject() == null) {
                return lastScreenPosition;
            }
            lastScreenPosition.selectedTreeNodeType = gUIHelperInterface.getType();
            lastScreenPosition.selectedTreeNodeObjectID = gUIHelperInterface.getDeviceObject().getID();
            lastScreenPosition.detailPanelTabIndex = this.getCurrentPanel() != null ? this.getCurrentPanel().getTabIndex() : -1;
        }
        return lastScreenPosition;
    }

    public void startPollThread() {
        pollThread = new Thread(){

            @Override
            public void run() {
                boolean bl = true;
                while (bl) {
                    try {
                        if (server.pollLoggedInFramework() != 0) {
                            MainFrame.this.connLost();
                            bl = false;
                        }
                        if (MainFrame.this.pollThreadInterrupted) {
                            MainFrame.this.pollThreadInterrupted = false;
                            this.interrupted();
                        }
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("Poll thread interrupted");
                    }
                }
            }
        };
        pollThread.start();
    }

    public void requestPoll() {
        if (!this.pollThreadInterrupted) {
            pollThread.interrupt();
            this.pollThreadInterrupted = true;
        }
    }

    public void connLost() {
        try {
            server.logout();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CustomMsgBox.confirm(Resource.getString("MSG_CONN_LOST", "Connection to the server has been lost . Do you want to relogin ?"))) {
            this.dispose();
            VivaldiStartupDialog.m_isRelogin = true;
            VivaldiStartupDialog.displayVivaldiStartupDialog(true);
        } else {
            this.dispose();
            System.exit(0);
        }
    }

    public SASServer getServer() {
        return server;
    }

    public void setServer(SASServer sASServer) {
        server = sASServer;
    }

    public void busy() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    public void ready() {
        this.setCursor(Cursor.getDefaultCursor());
        this.setEnabled(true);
    }

    @Override
    public String getHelpPage() {
        GUIHelperInterface gUIHelperInterface = null;
        gUIHelperInterface = this.tabbedPane.getSelectedIndex() == 0 ? ((DashboardPanel)this.tabPanels[this.tabbedPane.getSelectedIndex()]).getServerObjectHelper() : ((DevicePanel)this.tabPanels[this.tabbedPane.getSelectedIndex()]).tree.getSelectedNode().getObjectManager();
        AdapterHelper adapterHelper = null;
        if (gUIHelperInterface instanceof AdapterHelper) {
            adapterHelper = (AdapterHelper)gUIHelperInterface;
            if (adapterHelper.isCSA()) {
                return HelpContextResourse.getHelpPageName("MSM_CSA_MONITORING_CONTROLLERS_AND_THEIR_ATTACHED_DEVICES");
            }
            if (((SASAdapter)adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                return HelpContextResourse.getHelpPageName("MR_MONITORING_CONTROLLERS");
            }
            return HelpContextResourse.getHelpPageName("IR_MONITORING_CONTROLLERS");
        }
        if (gUIHelperInterface instanceof ArrayHelper) {
            adapterHelper = (AdapterHelper)((ArrayHelper)gUIHelperInterface).getParent();
            if (adapterHelper.isCSA()) {
                return HelpContextResourse.getHelpPageName("MSM_CSA_MONITORING_CONTROLLERS_AND_THEIR_ATTACHED_DEVICES");
            }
            if (((SASAdapter)adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                return HelpContextResourse.getHelpPageName("");
            }
            return HelpContextResourse.getHelpPageName("");
        }
        if (gUIHelperInterface instanceof BBUHelper) {
            adapterHelper = (AdapterHelper)((BBUHelper)gUIHelperInterface).getParent();
            if (adapterHelper.isCSA()) {
                return HelpContextResourse.getHelpPageName("MSM_CSA_MONITORING_SUPERCAP");
            }
            if (((SASAdapter)adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                return HelpContextResourse.getHelpPageName("MR_MONITORING_BATTERY_BACKUP_UNITS");
            }
            return HelpContextResourse.getHelpPageName("");
        }
        if (gUIHelperInterface instanceof EnclosureHelper) {
            adapterHelper = (AdapterHelper)((EnclosureHelper)gUIHelperInterface).getParent();
            if (adapterHelper.isCSA()) {
                return HelpContextResourse.getHelpPageName("MSM_CSA_MONITORING_ENCLOSURES");
            }
            if (((SASAdapter)adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                return HelpContextResourse.getHelpPageName("MR_MONITORING_ENCLOSURES");
            }
            return HelpContextResourse.getHelpPageName("IR_MONITORING_ENCLOSURES");
        }
        if (gUIHelperInterface instanceof LogicalDriveHelper) {
            adapterHelper = (AdapterHelper)((LogicalDriveHelper)gUIHelperInterface).getParent();
            if (adapterHelper.isCSA()) {
                return HelpContextResourse.getHelpPageName("MSM_CSA_MONITORING_VIRTUAL_DRIVES");
            }
            if (((SASAdapter)adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                return HelpContextResourse.getHelpPageName("MR_MONITORING_VIRTUAL_DRIVES");
            }
            return HelpContextResourse.getHelpPageName("IR_MONITORING_VIRTUAL_DRIVES");
        }
        if (gUIHelperInterface instanceof PhysicalDriveHelper) {
            adapterHelper = (AdapterHelper)((PhysicalDriveHelper)gUIHelperInterface).getParent();
            if (adapterHelper.isCSA()) {
                return HelpContextResourse.getHelpPageName("MSM_CSA_MONITORING_DRIVES");
            }
            if (((SASAdapter)adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                return HelpContextResourse.getHelpPageName("MR_MONITORING_DRIVES");
            }
            return HelpContextResourse.getHelpPageName("IR_MONITORING_DRIVES_AND_OTHER_PHYSICAL_DEVICES");
        }
        if (gUIHelperInterface instanceof PortHelper) {
            adapterHelper = (AdapterHelper)((PortHelper)gUIHelperInterface).getParent();
            if (((SASAdapter)adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                return HelpContextResourse.getHelpPageName("");
            }
            return HelpContextResourse.getHelpPageName("");
        }
        if (gUIHelperInterface instanceof ServerObjectHelper) {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                return HelpContextResourse.getHelpPageName("MR_MEGARAID_STORAGE_MANAGER_MAIN_MENU");
            }
            if (this.tabbedPane.getSelectedIndex() == 0) {
                return HelpContextResourse.getHelpPageName("MR_MEGARAID_STORAGE_MANAGER_MAIN_MENU");
            }
            return HelpContextResourse.getHelpPageName("MR_MONITORING_CONTROLLERS_AND_THEIR_ATTACHED_DEVICES");
        }
        if (gUIHelperInterface instanceof CCOHCacheGroupHelper) {
            return HelpContextResourse.getHelpPageName("NYTRO_XD_CACHE_GROUP_NODE");
        }
        return HelpContextResourse.getHelpPageName("HELP_PAGE_DEFAULT");
    }

    public void writeToTextFile(File file, ArrayList arrayList, int n) throws IOException {
        int n2;
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        printWriter.println(VivaldiStartupDialog.PRODUCT_INFO + " " + VivaldiStartupDialog.INSTALLER_VERSION + Resource.getString("MSG_TXTLOGFILE_HEADER", " Event Log - Generated on ") + new Date());
        int n3 = VivaldiStartupDialog.PRODUCT_INFO.length() + 1 + VivaldiStartupDialog.INSTALLER_VERSION.length() + Resource.getString("MSG_TXTLOGFILE_HEADER", " Event Log - Generated on ").length() + new Date().toString().length();
        StringBuffer stringBuffer = new StringBuffer("-");
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append("-");
        }
        printWriter.println(stringBuffer);
        n2 = n;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = ((LogXMLParser)arrayList.get(i)).getTagValue("id");
            --n2;
            String string2 = ((LogXMLParser)arrayList.get(i)).getTagValue("seqNum");
            StringBuffer stringBuffer2 = null;
            if (((LogXMLParser)arrayList.get(i)).getTagValue("dd") != null) {
                stringBuffer2 = new StringBuffer(((LogXMLParser)arrayList.get(i)).getTagValue("dd"));
                stringBuffer2.append("-" + ((LogXMLParser)arrayList.get(i)).getTagValue("month"));
                stringBuffer2.append("-" + ((LogXMLParser)arrayList.get(i)).getTagValue("yyyy"));
                stringBuffer2.append(" " + ((LogXMLParser)arrayList.get(i)).getTagValue("hh"));
                stringBuffer2.append(":" + ((LogXMLParser)arrayList.get(i)).getTagValue("mm"));
                stringBuffer2.append(":" + ((LogXMLParser)arrayList.get(i)).getTagValue("ss"));
            }
            String string3 = ((LogXMLParser)arrayList.get(i)).getTagValue("localizedMessage");
            string3 = string3.replace('\n', ' ');
            printWriter.println(Resource.getString("MSG_TXTFILE_ID", "ID = ") + string);
            if (string2 != null) {
                printWriter.println(Resource.getString("MSG_TXTFILE_SEQNUM", "SEQUENCE NUMBER = ") + string2);
            }
            if (((LogXMLParser)arrayList.get(i)).getTagValue("dd") == null && ((LogXMLParser)arrayList.get(i)).getTagValue("month") == null && ((LogXMLParser)arrayList.get(i)).getTagValue("yyyy") == null && ((LogXMLParser)arrayList.get(i)).getTagValue("hh") == null && ((LogXMLParser)arrayList.get(i)).getTagValue("mm") == null) {
                stringBuffer2 = ((LogXMLParser)arrayList.get(i)).getTagValue("dd") != null ? new StringBuffer(((LogXMLParser)arrayList.get(i)).getTagValue("dd") + Resource.getString("TEXT_SEC_FRM_REBOOT", " seconds from reboot")) : new StringBuffer(Resource.getString("TEXT_NOT_AVAILABLE", "Not available"));
            }
            printWriter.println(Resource.getString("MSG_TXTFILE_TIME", "TIME = ") + stringBuffer2);
            printWriter.println(Resource.getString("MSG_TXTFILE_LOCALIZEDMSG", "LOCALIZED MESSAGE = ") + string3);
            printWriter.println();
        }
        printWriter.close();
    }

    private void populateToolBar() {
        int n;
        ToolBarHandler.updateAddedOperations();
        JButton jButton = ToolBarHandler.createToolBarButton(ToolBarHandler.getToolBarButtonIconStr(ToolBarHandler.SEPARATOR), false, false);
        toolBar.add(jButton);
        int[] nArray = ToolBarHandler.getToolBarGrpOperations();
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            JButton jButton2 = null;
            if (VivaldiStartupDialog.isStandAloneMode && n == 1002) continue;
            boolean bl = this.isNonWarhawkHBAExists();
            jButton2 = n == 1001 && serverHelper == null ? ToolBarHandler.createToolBarButton(n, ToolBarHandler.getToolBarButtonIconStr(n), "" + n, ToolBarHandler.getToolBarButtonName(n), false, false) : ToolBarHandler.createToolBarButton(n, ToolBarHandler.getToolBarButtonIconStr(n), "" + n, ToolBarHandler.getToolBarButtonName(n), true, false);
            if (n == 1123) {
                if (!bl) continue;
                jButton2.addActionListener(new GroupMenuListener(serverHelper));
                toolBarServButtons.put(n, jButton2);
                if (!ToolBarHandler.getAddedToolButtons().contains(new Integer(n))) continue;
                toolBar.add(jButton2);
                continue;
            }
            jButton2.addActionListener(new GroupMenuListener(serverHelper));
            toolBarServButtons.put(n, jButton2);
            if (!ToolBarHandler.getAddedToolButtons().contains(new Integer(n))) continue;
            toolBar.add(jButton2);
        }
        int[] nArray2 = ToolBarHandler.getToolBarAdpOperations();
        for (n = 0; n < nArray2.length; ++n) {
            int n2 = nArray2[n];
            JButton jButton3 = ToolBarHandler.createToolBarButton(n2, ToolBarHandler.getToolBarButtonIconStr(n2), "" + n2, ToolBarHandler.getToolBarButtonName(n2), false, false);
            toolBarAdpButtons.put(n2, jButton3);
            if (!ToolBarHandler.getAddedToolButtons().contains(new Integer(n2))) continue;
            toolBar.add(jButton3);
        }
        int[] nArray3 = ToolBarHandler.getToolBarMainOperations();
        for (int i = 0; i < nArray3.length; ++i) {
            int n3 = nArray3[i];
            JButton jButton4 = null;
            jButton4 = ToolBarHandler.createToolBarButton(n3, ToolBarHandler.getToolBarButtonIconStr(n3), "" + n3, ToolBarHandler.getToolBarButtonName(n3), true, false);
            jButton4.addActionListener(new GroupMenuListener(serverHelper));
            toolBarMainButtons.put(n3, jButton4);
            if (!ToolBarHandler.getAddedToolButtons().contains(new Integer(n3))) continue;
            toolBar.add(jButton4);
        }
    }

    private void updateToolBar(GUIHelperInterface gUIHelperInterface) {
        AdapterHelper adapterHelper = null;
        if (gUIHelperInterface.getType() == 1) {
            adapterHelper = (AdapterHelper)gUIHelperInterface;
        }
        int[] nArray = ToolBarHandler.getToolBarGrpOperations();
        int[] nArray2 = ToolBarHandler.getToolBarAdpOperations();
        for (int i = 0; i < nArray2.length; ++i) {
            int n = nArray2[i];
            JButton jButton = toolBarAdpButtons.get(n);
            if (gUIHelperInterface.getType() == 1 && this.toolBarEnabledOpers.contains(n)) {
                ActionListener[] actionListenerArray = (ActionListener[])jButton.getListeners(ActionListener.class);
                for (int j = 0; j < actionListenerArray.length; ++j) {
                    jButton.removeActionListener(actionListenerArray[j]);
                }
                jButton.addActionListener(new AdapterMenuListener(adapterHelper));
                jButton.setEnabled(true);
            } else {
                jButton.setEnabled(false);
            }
            toolBarAdpButtons.put(n, jButton);
        }
        MainFrame.updateToolBar();
    }

    public static void updateToolBar() {
        toolBar.removeAll();
        JButton jButton = ToolBarHandler.createToolBarButton(ToolBarHandler.getToolBarButtonIconStr(ToolBarHandler.SEPARATOR), false, false);
        toolBar.add(jButton);
        boolean bl = false;
        for (JButton jButton2 : toolBarServButtons.values()) {
            if (!ToolBarHandler.getAddedToolButtons().contains(new Integer(jButton2.getActionCommand()))) continue;
            toolBar.add(jButton2);
            bl = true;
        }
        bl = false;
        for (JButton jButton2 : toolBarAdpButtons.values()) {
            if (!ToolBarHandler.getAddedToolButtons().contains(new Integer(jButton2.getActionCommand()))) continue;
            toolBar.add(jButton2);
            bl = true;
        }
        for (JButton jButton2 : toolBarMainButtons.values()) {
            if (!ToolBarHandler.getAddedToolButtons().contains(new Integer(jButton2.getActionCommand()))) continue;
            toolBar.add(jButton2);
            bl = true;
        }
    }

    private static JButton getToolBarOption() {
        if (toolBarOptions != null) {
            return toolBarOptions;
        }
        toolBarOptions = new JButton();
        ImageIcon imageIcon = Resource.getImage("ADDACTION");
        toolBarOptions.setIcon(imageIcon);
        toolBarOptions.setToolTipText("Add or Remove Buttons");
        toolBarOptions.setEnabled(true);
        toolBarOptions.setFocusable(false);
        toolBarOptions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    ToolBarHandler.updateAddedOperations();
                    JDialog jDialog = new ToolBarHandler().getToolBarOptionsDialog();
                    jDialog.pack();
                    GUIUtils.centerDialogOnScreen(jDialog);
                    jDialog.setVisible(true);
                }
            }
        });
        return toolBarOptions;
    }

    public String getServerIP() {
        return this.getIP(server.getSvrWWN());
    }

    private String getIP(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        return string.split(":")[0];
    }

    private boolean isNonWarhawkHBAExists() {
        boolean bl = false;
        if (serverHelper != null) {
            AdapterHelper[] adapterHelperArray = this.getServerHelper().getAdapterHelpers();
            for (int i = 0; i < adapterHelperArray.length; ++i) {
                if (((SASAdapter)adapterHelperArray[i].getDeviceObject()).isWarhawk()) continue;
                bl |= true;
                break;
            }
        }
        return bl;
    }

    public JMenu getToolsMenu() {
        return this.toolsMenu;
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        NetworkPacket networkPacket = null;
        byte[] byArray = null;
        SL_EVENT_DETAIL_T sL_EVENT_DETAIL_T = null;
        if (notifyObject.getNotifyCode() == 0x101001 && notifyObject.getNotifyObject() instanceof NetworkPacket) {
            networkPacket = (NetworkPacket)notifyObject.getNotifyObject();
            byArray = networkPacket.getDatabuffer();
            sL_EVENT_DETAIL_T = new SL_EVENT_DETAIL_T(byArray, 0);
            int n = sL_EVENT_DETAIL_T.getevtDetail().getcode();
            if (n == 451) {
                this.m_progressPanel = new VivaldiBaseDialog();
                this.m_progressPanel.setBackground(Color.WHITE);
                this.m_progressPanel.setSize(400, 200);
                this.m_progressPanel.setTitle(VivaldiStartupDialog.FRAME_TITLE);
                BouncingProgressBar bouncingProgressBar = new BouncingProgressBar();
                bouncingProgressBar.setProgressBarText(new JLabel(Resource.getString("MSG_RESETNOW_PROGRESS", "Online Firmware Update is in Progress...")));
                JPanel jPanel = bouncingProgressBar.getProgressbar();
                this.m_progressPanel.add(jPanel);
                this.m_progressPanel.setVisible(true);
                this.m_progressPanel.setLocation((MainFrame.SCREEN_SIZE.width - this.m_progressPanel.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.m_progressPanel.getHeight()) / 2);
                this.m_progressPanel.setCursor(Cursor.getPredefinedCursor(3));
                this.m_progressPanel.setEnabled(false);
                this.busy();
            }
            if (n == 452) {
                if (this.m_progressPanel != null) {
                    this.m_progressPanel.setVisible(false);
                    this.m_progressPanel.dispose();
                }
                this.ready();
            }
        }
    }

    static {
        SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
        DASHBOARD_SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
        allNodeListener = new TreeNodeListener();
        fullAccess = false;
        nodeindex = 0;
        toolBarServButtons = new LinkedHashMap();
        toolBarAdpButtons = new LinkedHashMap();
        toolBarMainButtons = new LinkedHashMap();
        toolBarOptions = null;
        isManageCIMOM = false;
        BACKGROUND_COLOR = Color.WHITE;
        TITLE_COLOR = Color.BLACK;
    }

    class ToolBarListener
    implements ItemListener {
        private ServerObjectHelper servObj;
        private SASServer sasServObj;

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)itemEvent.getSource();
            String string = jCheckBoxMenuItem.getText();
            int n = -1;
            n = ToolBarHandler.getToolBarButtonId(string);
            if (n != -1) {
                if (jCheckBoxMenuItem.getState()) {
                    if (!ToolBarHandler.getAddedToolButtons().contains(n)) {
                        ToolBarHandler.appendToolBarButton(n);
                    }
                } else {
                    ToolBarHandler.removeToolBarButton(new Integer(n));
                }
                MainFrame.updateToolBar();
            }
        }
    }

    class GroupMenuListener
    implements ActionListener {
        private ServerObjectHelper servObj;
        private SASServer sasServObj;

        public GroupMenuListener(ServerObjectHelper serverObjectHelper) {
            this.servObj = serverObjectHelper;
            if (this.servObj != null) {
                this.sasServObj = (SASServer)this.servObj.getDeviceObject();
            }
        }

        public GroupMenuListener(SASServer sASServer) {
            this.sasServObj = sASServer;
        }

        public GroupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.servObj = MainFrame.this.getServerHelper();
            this.sasServObj = (SASServer)this.servObj.getDeviceObject();
            String string = actionEvent.getActionCommand();
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                System.out.println("Got exp" + exception.getMessage());
            }
            switch (n) {
                case 1123: {
                    new GroupShowProgressDialog(this.servObj);
                    break;
                }
                case 1001: {
                    MainFrame.this.busy();
                    try {
                        if (this.sasServObj == null && this.servObj != null) {
                            this.sasServObj = (SASServer)this.servObj.getDeviceObject();
                        }
                        if (this.sasServObj != null) {
                            this.sasServObj.rescan();
                        }
                        MainFrame.this.refreshPeerServerNode();
                    }
                    catch (VKOperationFailedException vKOperationFailedException) {
                        vKOperationFailedException.printStackTrace();
                        CustomMsgBox.errorMsg(vKOperationFailedException);
                        new CustomMsgBox(Resource.getString("MSG_FATAL_RESCAN_ERROR", "Fatal error : rescan failed ! Exiting ... "));
                        System.exit(0);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        new CustomMsgBox(Resource.getString("MSG_FATAL_RESCAN_ERROR", "Fatal error : rescan failed ! Exiting ... "));
                        System.exit(0);
                    }
                    serverHelper = new ServerObjectHelper(this.sasServObj);
                    MainFrame.this.reboot(MainFrame.this.getLastScreenPosition());
                    server.RegistrationCommandForAEN();
                    MainFrame.this.logger.registerToServer(server, serverHelper.getAdapterHelpers());
                    MainFrame.this.logger.registerToServer(server, serverHelper.getCCOHVirtualAdapHelper());
                    MainFrame.this.ready();
                    break;
                }
                case 1002: {
                    VivaldiStartupDialog.displayVivaldiStartupDialog(false);
                    break;
                }
                case 1003: {
                    if (MainFrame.this.currentPanel != null && !MainFrame.this.currentPanel.canClose()) break;
                    MainFrame.this.logOut();
                    ((SASKernel)server.parent()).destroyKernel();
                    System.exit(0);
                    break;
                }
                case 1005: {
                    new GroupInitializeDialog(serverHelper);
                    break;
                }
                case 1004: {
                    new GroupConsistencyCheckDialog(serverHelper);
                    break;
                }
                case 3000: {
                    HelpContext.executeHelpProcess(HelpContextResourse.getHelpPageName("HELP_PAGE_DEFAULT"));
                }
            }
        }
    }
}

