/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.AdvancedPowerSettingsSchedule;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_PROP;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.Operations.OperationDetails;
import Utils.GUIUtils;
import Utils.OptionDialog;
import Utils.Resource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;

public class ManagePowerSettingsPanel
extends VivaldiBaseDialog {
    private JCheckBox m_chkBxPowerSave = null;
    private JPanel m_spin_down_panel = null;
    private JSpinner delayTimeSpinner = null;
    private JLabel powerSaveModeDesc = null;
    private JComboBox powerSaveModeCombo = null;
    JComboBox driveStandbyTimeCombo = null;
    private JButton advancedButton = null;
    private JCheckBox unconfigdrivesSpindownChkbox = null;
    private JCheckBox configdrivesSpindownChkbox = null;
    private JCheckBox hotSpareSpindownChkbox = null;
    private String[] strMnemonics = null;
    private boolean m_configuredDriveSpinDownPossible = false;
    private short mfcDisablePowerSavings = 0;
    private AdapterHelper m_helper = null;
    boolean m_powerStateforConfig = false;

    public ManagePowerSettingsPanel(AdapterHelper adapterHelper, boolean bl) {
        Object object;
        JComponent jComponent;
        Object object2;
        this.m_helper = adapterHelper;
        this.m_powerStateforConfig = bl;
        MR_MFC_DEFAULTS mR_MFC_DEFAULTS = this.m_helper.getMFCDefaults();
        if (mR_MFC_DEFAULTS != null) {
            this.mfcDisablePowerSavings = mR_MFC_DEFAULTS.getdisablePowerSavings();
        }
        MR_CTRL_PROP mR_CTRL_PROP = this.m_helper.getAdapterProperties();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension dimension = new Dimension(125, 25);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        JLabel jLabel = new JLabel();
        if (VivaldiStartupDialog.OEM_TYPE == 71244) {
            jLabel.setText(Resource.getString("DS_DESC_CTRL", "<html>Power save (Dimmer Switch\u2122) technology that conserves energy by spinning down idle drives.The controller<br>will automatically spin up those drives from power save mode whenever necessary.</html>"));
        } else {
            jLabel.setText(Resource.getString("POWER_SAVE_MODE_DESC_OTHERS", " <html>The controller conserves energy by placing certain unused drives into powersave mode.<br>The controller will automatically spin up drives from powersave mode<br>whenever necessary.<br><br></html>"));
        }
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        if (this.m_powerStateforConfig) {
            object2 = Resource.getResourceMnemonic(Resource.getString("ALLOW_POWERSAVE_MODE", "Allow (u)nconfigured drives to enter powersave mode."));
            this.m_chkBxPowerSave = new JCheckBox(object2[0]);
            if (((String[])object2).length == 2) {
                this.m_chkBxPowerSave.setMnemonic(object2[1].charAt(0));
            }
            this.m_chkBxPowerSave.setSelected(mR_CTRL_PROP.getOnOffProperties_MR_CTRL_PROP().isSpinDownUnconfiguredDrivesEnabled());
            this.m_chkBxPowerSave.setOpaque(false);
            jPanel.add((Component)this.m_chkBxPowerSave, gridBagConstraints);
        } else {
            object2 = new JLabel(Resource.getString("SPECIFY_POWER_SAVE_SETTINGS", "Specify the power save settings below:"));
            jPanel.add((Component)object2, gridBagConstraints);
            jComponent = new JLabel(Resource.getString("DS_SPIN_DOWN", "Spin Down"));
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            ++gridBagConstraints.gridy;
            jPanel.add((Component)object2, gridBagConstraints);
            this.strMnemonics = Resource.getResourceMnemonic(Resource.getString("DS_UG_DRIVES", "(U)nconfigured Drives"));
            this.unconfigdrivesSpindownChkbox = new JCheckBox(this.strMnemonics[0]);
            if (this.strMnemonics.length == 2) {
                this.unconfigdrivesSpindownChkbox.setMnemonic(this.strMnemonics[1].charAt(0));
            }
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this.unconfigdrivesSpindownChkbox, gridBagConstraints);
            if (mR_CTRL_PROP.getOnOffProperties_MR_CTRL_PROP().isSpinDownUnconfiguredDrivesEnabled()) {
                this.unconfigdrivesSpindownChkbox.setSelected(true);
            }
            this.strMnemonics = Resource.getResourceMnemonic(Resource.getString("DS_HS_DRIVES", "(H)ot spare Drives"));
            this.hotSpareSpindownChkbox = new JCheckBox(this.strMnemonics[0]);
            if (this.strMnemonics.length == 2) {
                this.hotSpareSpindownChkbox.setMnemonic(this.strMnemonics[1].charAt(0));
            }
            object = this.m_helper.getAdapterInfo();
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this.hotSpareSpindownChkbox, gridBagConstraints);
            if (!((MR_CTRL_INFO)object).getproperties().getOnOffProperties_MR_CTRL_PROP().isdisableSpinDownHS()) {
                this.hotSpareSpindownChkbox.setSelected(true);
            }
            this.strMnemonics = Resource.getResourceMnemonic(Resource.getString("DS_CONF_DRIVES", "(C)onfigured Drives"));
            this.configdrivesSpindownChkbox = new JCheckBox(this.strMnemonics[0]);
            if (this.strMnemonics.length == 2) {
                this.configdrivesSpindownChkbox.setMnemonic(this.strMnemonics[1].charAt(0));
            }
            if (this.m_helper.isPowerSaveSupportedOnConfiguredDrives()) {
                this.m_configuredDriveSpinDownPossible = true;
            }
            if (this.m_configuredDriveSpinDownPossible) {
                gridBagConstraints.insets = new Insets(5, 5, 0, 0);
                ++gridBagConstraints.gridy;
                jPanel.add((Component)this.configdrivesSpindownChkbox, gridBagConstraints);
                if (mR_CTRL_PROP.getdefaultLdPSPolicy() != -2) {
                    this.configdrivesSpindownChkbox.setSelected(true);
                }
            }
            this.strMnemonics = Resource.getResourceMnemonic(Resource.getString("SPECIFY_DRIVE_STANDBY_TIME", "(D)rive standby time:"));
            JLabel jLabel2 = new JLabel(this.strMnemonics[0]);
            if (this.strMnemonics.length == 2) {
                jLabel2.setDisplayedMnemonic(this.strMnemonics[1].charAt(0));
            }
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(10, 5, 0, 0);
            jPanel.add((Component)jLabel2, gridBagConstraints);
            String[] stringArray = new String[]{Resource.getString("TEXT_THIRTY", "30 mins"), Resource.getString("TEXT_ONE", "01 hour"), Resource.getString("TEXT_ONE_THIRTY", "01.5 hours"), Resource.getString("TEXT_TWO", "02 hours"), Resource.getString("TEXT_THREE", "03 hours"), Resource.getString("TEXT_FOUR", "04 hours"), Resource.getString("TEXT_FIVE", "05 hours"), Resource.getString("TEXT_SIX", "06 hours"), Resource.getString("TEXT_SEVEN", "07 hours"), Resource.getString("TEXT_EIGHT", "08 hours"), Resource.getString("TEXT_NINE", "09 hours"), Resource.getString("TEXT_TEN", "10 hours"), Resource.getString("TEXT_ELEVEN", "11 hours"), Resource.getString("TEXT_TWELVE", "12 hours"), Resource.getString("TEXT_THIRTEEN", "13 hours"), Resource.getString("TEXT_FOURTEEN", "14 hours"), Resource.getString("TEXT_FIFTEEN", "15 hours"), Resource.getString("TEXT_SIXTEEN", "16 hours"), Resource.getString("TEXT_SEVENTEEN", "17 hours"), Resource.getString("TEXT_EIGHTEEN", "18 hours"), Resource.getString("TEXT_NINETEEN", "19 hours"), Resource.getString("TEXT_TWENTY", "20 hours"), Resource.getString("TEXT_TWENTY_ONE", "21 hours"), Resource.getString("TEXT_TWENTY_TWO", "22 hours"), Resource.getString("TEXT_TWENTY_THREE", "23 hours"), Resource.getString("TEXT_TWENTY_FOUR", "24 hours")};
            this.driveStandbyTimeCombo = new JComboBox<String>(stringArray);
            this.driveStandbyTimeCombo.setPreferredSize(dimension);
            jLabel2.setLabelFor(this.driveStandbyTimeCombo);
            short s = mR_CTRL_PROP.getspinDownTime();
            int n = 0;
            if (s == 60) {
                n = 1;
            } else if (s == 90) {
                n = 2;
            } else if (s != 30) {
                n = (byte)(s / 60 + 1);
            }
            this.driveStandbyTimeCombo.setSelectedIndex(n);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            jPanel.add((Component)this.driveStandbyTimeCombo, gridBagConstraints);
            if (this.unconfigdrivesSpindownChkbox.isSelected() || this.hotSpareSpindownChkbox.isSelected() || this.configdrivesSpindownChkbox.isSelected()) {
                this.driveStandbyTimeCombo.setEnabled(true);
            } else {
                this.driveStandbyTimeCombo.setEnabled(false);
            }
            JLabel jLabel3 = new JLabel(Resource.getString("SPECIFY_SPIN_DOWN_TEXT_NEW", "<html>Ensure that if the drives are idle for the specified time, then the drives will go to power<br>save mode.</html>"));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(0, 135, 0, 0);
            jPanel.add((Component)jLabel3, gridBagConstraints);
            this.strMnemonics = Resource.getResourceMnemonic(Resource.getString("SELECT_POWER_SAVE_MODE", "(S)elect power save mode:"));
            JLabel jLabel4 = new JLabel(this.strMnemonics[0]);
            if (this.strMnemonics.length == 2) {
                jLabel4.setDisplayedMnemonic(this.strMnemonics[1].charAt(0));
            }
            ArrayList<Byte> arrayList = new ArrayList<Byte>();
            byte by = (byte)(mR_CTRL_PROP.getdefaultLdPSPolicy() & 4);
            System.out.println("dontCacheBitVal==" + by);
            arrayList.add((byte)(1 ^ by));
            if ((this.mfcDisablePowerSavings & 0x10) != 16) {
                arrayList.add((byte)(2 ^ by));
            }
            System.out.println("propold.getdefaultLdPSPolicy()==" + mR_CTRL_PROP.getdefaultLdPSPolicy());
            System.out.println("propold.getdefaultLdPSPolicy()==" + mR_CTRL_PROP.getdefaultLdPSPolicy());
            if (this.m_helper.isSupportPSMaxWithCache() && VivaldiStartupDialog.OEM_TYPE != 2561) {
                arrayList.add((byte)6);
            }
            PowerSaveComboBoxModel powerSaveComboBoxModel = new PowerSaveComboBoxModel(arrayList);
            this.powerSaveModeCombo = new JComboBox();
            this.powerSaveModeCombo.setPreferredSize(dimension);
            this.powerSaveModeCombo.setModel(powerSaveComboBoxModel);
            this.powerSaveModeCombo.setRenderer(new PowerSaveComboBoxRenderer());
            jLabel4.setLabelFor(this.powerSaveModeCombo);
            this.powerSaveModeCombo.setSelectedItem(mR_CTRL_PROP.getdefaultLdPSPolicy());
            this.powerSaveModeDesc = new JLabel(this.getPowerSaveModeDescription(((Byte)this.powerSaveModeCombo.getSelectedItem()).byteValue()));
            if (this.m_configuredDriveSpinDownPossible) {
                ++gridBagConstraints.gridy;
                gridBagConstraints.insets = new Insets(10, 5, 0, 0);
                jPanel.add((Component)jLabel4, gridBagConstraints);
                ++gridBagConstraints.gridy;
                gridBagConstraints.insets = new Insets(0, 5, 0, 0);
                jPanel.add((Component)this.powerSaveModeCombo, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.insets = new Insets(0, 135, 0, 0);
                jPanel.add((Component)this.powerSaveModeDesc, gridBagConstraints);
            }
            this.strMnemonics = Resource.getResourceMnemonic(Resource.getString("DS_ADVANCED", "(A)dvanced..."));
            this.advancedButton = new JButton(this.strMnemonics[0]);
            if (this.strMnemonics.length == 2) {
                this.advancedButton.setMnemonic(this.strMnemonics[1].charAt(0));
            }
            if (this.m_configuredDriveSpinDownPossible && this.mfcDisablePowerSavings != -1 && (this.mfcDisablePowerSavings & 0x40) != 0) {
                gridBagConstraints.gridx = 0;
                ++gridBagConstraints.gridy;
                gridBagConstraints.insets = new Insets(10, 5, 0, 0);
                jPanel.add((Component)this.advancedButton, gridBagConstraints);
            }
            if (this.configdrivesSpindownChkbox.isSelected()) {
                this.powerSaveModeCombo.setEnabled(true);
                this.advancedButton.setEnabled(true);
            } else {
                this.powerSaveModeCombo.setEnabled(false);
                this.advancedButton.setEnabled(false);
            }
            this.unconfigdrivesSpindownChkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ManagePowerSettingsPanel.this.unconfigdrivesSpindownChkbox.isSelected()) {
                        ManagePowerSettingsPanel.this.driveStandbyTimeCombo.setEnabled(true);
                    } else if (!ManagePowerSettingsPanel.this.hotSpareSpindownChkbox.isSelected() && !ManagePowerSettingsPanel.this.configdrivesSpindownChkbox.isSelected()) {
                        ManagePowerSettingsPanel.this.driveStandbyTimeCombo.setEnabled(false);
                    }
                }
            });
            this.hotSpareSpindownChkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ManagePowerSettingsPanel.this.hotSpareSpindownChkbox.isSelected()) {
                        ManagePowerSettingsPanel.this.driveStandbyTimeCombo.setEnabled(true);
                    } else if (!ManagePowerSettingsPanel.this.unconfigdrivesSpindownChkbox.isSelected() && !ManagePowerSettingsPanel.this.configdrivesSpindownChkbox.isSelected()) {
                        ManagePowerSettingsPanel.this.driveStandbyTimeCombo.setEnabled(false);
                    }
                }
            });
            this.configdrivesSpindownChkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ManagePowerSettingsPanel.this.configdrivesSpindownChkbox.isSelected()) {
                        ManagePowerSettingsPanel.this.driveStandbyTimeCombo.setEnabled(true);
                        ManagePowerSettingsPanel.this.powerSaveModeCombo.setEnabled(true);
                        ManagePowerSettingsPanel.this.advancedButton.setEnabled(true);
                    } else {
                        ManagePowerSettingsPanel.this.powerSaveModeCombo.setEnabled(false);
                        ManagePowerSettingsPanel.this.advancedButton.setEnabled(false);
                        if (!ManagePowerSettingsPanel.this.unconfigdrivesSpindownChkbox.isSelected() && !ManagePowerSettingsPanel.this.hotSpareSpindownChkbox.isSelected()) {
                            ManagePowerSettingsPanel.this.driveStandbyTimeCombo.setEnabled(false);
                        }
                    }
                }
            });
            this.powerSaveModeCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManagePowerSettingsPanel.this.powerSaveModeDesc.setText(ManagePowerSettingsPanel.this.getPowerSaveModeDescription(((Byte)ManagePowerSettingsPanel.this.powerSaveModeCombo.getSelectedItem()).byteValue()));
                }
            });
            this.driveStandbyTimeCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            this.advancedButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new AdvancedPowerSettingsSchedule(ManagePowerSettingsPanel.this.m_helper);
                }
            });
        }
        object2 = new JPanel(new GridLayout(1, 2, 10, 10));
        this.strMnemonics = Resource.getResourceMnemonic(Resource.getString("ABOUT_OKBUTTON_TEXT", "(O)K"));
        jComponent = new JButton(this.strMnemonics[0]);
        this.strMnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "(C)ancel"));
        object = new JButton(this.strMnemonics[0]);
        ((Container)object2).add(jComponent);
        ((Container)object2).add((Component)object);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ManagePowerSettingsPanel.this.warningDialog()) {
                    ManagePowerSettingsPanel.this.dispose();
                }
            }
        });
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ManagePowerSettingsPanel.this.m_powerStateforConfig) {
                    OperationDetails operationDetails = new OperationDetails(40, "", "", null);
                    MR_CTRL_PROP mR_CTRL_PROP = ManagePowerSettingsPanel.this.m_helper.getAdapterProperties();
                    mR_CTRL_PROP.getOnOffProperties_MR_CTRL_PROP().setEnableSpinDownUnconfigured(ManagePowerSettingsPanel.this.m_chkBxPowerSave.isSelected() ? 1 : 0);
                    operationDetails.setParameter(mR_CTRL_PROP);
                    ManagePowerSettingsPanel.this.m_helper.issueOperation(operationDetails);
                    ManagePowerSettingsPanel.this.dispose();
                } else {
                    String string = null;
                    String string2 = null;
                    if (!(ManagePowerSettingsPanel.this.unconfigdrivesSpindownChkbox.isSelected() || ManagePowerSettingsPanel.this.hotSpareSpindownChkbox.isSelected() || ManagePowerSettingsPanel.this.configdrivesSpindownChkbox.isSelected())) {
                        string = Resource.getString("POWER_SAVE_SETTINGS_CONFIRM", "Power Save Settings - Confirmation");
                        string2 = Resource.getString("DS_PS_CONFIRM_MSG", "<html>The system will not have power savings for any of the drives.<br>Are you sure you want to proceed?");
                    } else {
                        string = Resource.getString("DS_PS_SAVED_CONFIRM_TITLE", "Power Save Settings Saved - Confirmation");
                        string2 = Resource.getString("DS_PS_SAVED_CONFIRM_MSG", "<html>Do you want to save the changes you have made to power<br>save settings?<html>");
                    }
                    OptionDialog optionDialog = new OptionDialog();
                    if (optionDialog.YesNoDialog(string, string2, true)) {
                        ManagePowerSettingsPanel.this.dispose();
                        OperationDetails operationDetails = new OperationDetails(40, "", "", null);
                        MR_CTRL_PROP mR_CTRL_PROP = ManagePowerSettingsPanel.this.m_helper.getAdapterProperties();
                        if (ManagePowerSettingsPanel.this.m_powerStateforConfig) {
                            mR_CTRL_PROP.getOnOffProperties_MR_CTRL_PROP().setEnableSpinDownUnconfigured(ManagePowerSettingsPanel.this.unconfigdrivesSpindownChkbox.isSelected() ? 1 : 0);
                        } else {
                            mR_CTRL_PROP.getOnOffProperties_MR_CTRL_PROP().setEnableSpinDownUnconfigured(ManagePowerSettingsPanel.this.unconfigdrivesSpindownChkbox.isSelected() ? 1 : 0);
                            mR_CTRL_PROP.getOnOffProperties_MR_CTRL_PROP().setdisableSpinDownHS(ManagePowerSettingsPanel.this.hotSpareSpindownChkbox.isSelected() ? 0 : 1);
                            if (ManagePowerSettingsPanel.this.unconfigdrivesSpindownChkbox.isSelected() || ManagePowerSettingsPanel.this.hotSpareSpindownChkbox.isSelected() || ManagePowerSettingsPanel.this.configdrivesSpindownChkbox.isSelected()) {
                                String string3 = ManagePowerSettingsPanel.this.driveStandbyTimeCombo.getSelectedItem().toString();
                                int n = new Integer(string3.substring(0, 2));
                                if (n != 30 && n != 45) {
                                    n *= 60;
                                    if (string3.contains(".")) {
                                        n += 30;
                                    }
                                }
                                mR_CTRL_PROP.setspinDownTime((short)n);
                            }
                            if (ManagePowerSettingsPanel.this.m_configuredDriveSpinDownPossible) {
                                if (ManagePowerSettingsPanel.this.configdrivesSpindownChkbox.isSelected()) {
                                    mR_CTRL_PROP.setdefaultLdPSPolicy((Byte)ManagePowerSettingsPanel.this.powerSaveModeCombo.getSelectedItem());
                                } else {
                                    mR_CTRL_PROP.setdefaultLdPSPolicy((byte)-2);
                                }
                            }
                        }
                        operationDetails.setParameter(mR_CTRL_PROP);
                        ManagePowerSettingsPanel.this.m_helper.issueOperation(operationDetails);
                    } else {
                        return;
                    }
                }
            }
        });
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(15, 0, 10, 0);
        jPanel.add((Component)object2, gridBagConstraints);
        this.add(jPanel);
        this.setTitle(Resource.getString("DS_PS_TITLE", "Manage Power Save Settings"));
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    public String getPowerSaveModeDescription(int n) {
        switch (n) {
            case 5: {
                return Resource.getString("DS_AUTO_DESC", "<html>This option ensures that the system will decide the best power saving<br>settings for the online drives.</html>");
            }
            case 6: {
                if (this.m_helper.isSupportPSMaxWithCache()) {
                    return Resource.getString("DS_MAX_DESC", "<html>This option ensures that the system will save maximum power by caching<br>data and avoid spinning up online drives when possible.</html>");
                }
                return Resource.getString("DS_SSM_MAX_DESC", "<html>This option ensures that the system will save maximum power by <br>spinning down online drives when possible.</html>");
            }
        }
        return "";
    }

    public boolean getSelectedPowerSaveMode() {
        return this.m_chkBxPowerSave.isSelected();
    }

    public int getSpinDownDelayTime() {
        return (Integer)this.delayTimeSpinner.getValue();
    }

    private void createDialog(JOptionPane jOptionPane, String string) {
        JDialog jDialog = jOptionPane.createDialog(this, string);
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        jDialog.setIconImage(image);
        jDialog.setVisible(true);
    }

    public class PowerSaveComboBoxModel
    extends DefaultComboBoxModel {
        public PowerSaveComboBoxModel(ArrayList<Byte> arrayList) {
            this.updateModel(arrayList);
        }

        private void updateModel(ArrayList<Byte> arrayList) {
            if (this.getSize() > 0) {
                this.removeAllElements();
            }
            for (int n = 0; n < arrayList.size(); n = (int)((short)(n + 1))) {
                this.addElement(arrayList.get(n));
            }
        }
    }

    public class PowerSaveComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                byte by = (Byte)object;
                if (by == 1 || by == 5) {
                    jLabel.setText(Resource.getString("DS_AUTO", "Auto"));
                } else if (by == 2 || by == 6) {
                    jLabel.setText(Resource.getString("DS_MAX", "Max"));
                }
            }
            return jLabel;
        }
    }
}

