/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MainFrame;
import GUI.ManagePowerSettingsPanel;
import GUI.ScheduleCCAdvanced;
import GUI.UnprotectedDriveGroupsDialog;
import GUI.VivaldiStartupDialog;
import GUI.security.ChangeEncyptionSettingsPanel;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_FW_STATUS;
import SASKernel.LibraryAPI.StoreLib.MR_CC_SCHEDULE_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_PROP;
import SASKernel.LibraryAPI.StoreLib.MR_FLASH_COMP_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PARAMETERS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_PD_REF;
import SASKernel.LibraryAPI.StoreLib.MR_PR_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_RECON;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_PHY_CONNECTION;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_PHY_CONNECTIONS;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.spareType_MR_SPARE;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASLogical.SASLogicalDriveOperationsAllowed;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.NetworkToJavaConverter;
import Utils.ColorHash;
import Utils.CustomComboBox;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.MultiSelectList;
import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import Wizard.ConfigWizard.GUIData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Observable;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class OperationDetailPanel
extends JPanel {
    private OperationDetails opDetails;
    private GUIHelperInterface guiHelper;
    private JTextField fwFileName;
    private JCheckBox quickInit;
    private JComboBox arrayCmb;
    private JComboBox phDriveCmb;
    private JSpinner maxPD;
    private JSpinner rebuildRate;
    private JSpinner prRate;
    private JSpinner bgiRate;
    private JSpinner ccRate;
    private JSpinner reconRate;
    private JSpinner freqHour;
    private JSpinner freqMin;
    private JSpinner freqSec;
    private JCheckBox freqContinuous;
    private JComboBox opMode;
    private MultiSelectList listPanel;
    private JList m_driveGroupsList = null;
    private JTextField ldName;
    private JComboBox readPolicy;
    private JComboBox writePolicy;
    private JComboBox accessPolicy;
    private JComboBox diskCachePolicy;
    private JComboBox cachePolicy;
    private JComboBox bgInit;
    private JCheckBox bbucheck;
    private static JCheckBox m_exposetoOS;
    boolean bbuPresent = false;
    private int EXE_FREQ_HOUR_MAX_VAL = 596522;
    private int EXE_FREQ_MIN_MAX_VAL = 59;
    private int EXE_FREQ_SEC_MAX_VAL = 59;
    private JRadioButton ccFixError;
    private JRadioButton ccOnError;
    private JComboBox ccOption;
    private JCheckBox ccContinuous;
    private JComboBox ccMonth;
    private JComboBox ccDay;
    private JComboBox ccTime;
    private JButton ccAdvanced;
    private JComboBox ccYear;
    private ScheduleCCAdvanced scheduleAdvanced;
    private ItemListener ccMonthListener = null;
    private ItemListener ccContinuousListener = null;
    private ItemListener ccOptionListener = null;
    private ActionListener ccAdvancedListener = null;
    private JList physicalDrivesList = null;
    private Vector vecPhysicalDrives = null;
    private MR_CTRL_PROP propold;
    private static final int MAX_LDNAME_LENGTH = 15;
    private ItemListener bbuCheckListener = null;
    private JLabel objNextLearnLabel;
    private JLabel objNextLearnTime;
    private JRadioButton enableAutoLearn;
    private JRadioButton disableAutoLearn;
    private JSpinner delayLearnCycle;
    private JLabel objDelayLearnLabel;
    private JLabel hours;
    private JCheckBox remindLearnCycle;
    private JRadioButton objControllerFirmware;
    private JRadioButton objBIOS;
    private JRadioButton objEFIBSD;
    private JRadioButton objFCODE;
    private JTable phyTable;
    private ChangeEncyptionSettingsPanel m_changeEncypSettingsPanel = null;
    private ManagePowerSettingsPanel m_managePowerSettingsPanel = null;
    private JLabel m_cmbBxWritePolicyDesc = new JLabel();
    public JPanel firmwarePanel;
    protected static final Border noFocusBorder;

    public OperationDetailPanel(OperationDetails operationDetails, GUIHelperInterface gUIHelperInterface) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        this.opDetails = operationDetails;
        this.guiHelper = gUIHelperInterface;
        Font font = this.getFont();
        if (!VivaldiStartupDialog.isWindows) {
            font = Locale.getDefault().getLanguage() == Locale.ENGLISH.getLanguage() ? new Font("Arial", 1, 12) : GUIUtils.getDefaultFont(15, this.getFont().getFontName(this.getLocale()), 12, this);
            if (MainFrame.SCREEN_SIZE.width <= 800) {
                font = Locale.getDefault().getLanguage() == Locale.ENGLISH.getLanguage() ? new Font("Arial", 1, 10) : GUIUtils.getDefaultFont(13, this.getFont().getFontName(), 10, this);
            }
            this.setFont(font);
            this.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
        }
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.setLayout(new BorderLayout());
        if (operationDetails == null) {
            JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 5));
            jPanel.setOpaque(false);
            JLabel jLabel = new JLabel(Resource.getString("OPERATION_INSTRUCTION_TEXT", "<html>Select an operation from the left and press go to<br>invoke the selected Operation !</html>"), 0);
            jLabel.setFont(font);
            jPanel.add(jLabel);
            this.add((Component)jPanel, "North");
            return;
        }
        GridLayout gridLayout = new GridLayout(2, 1, 5, 5);
        gridLayout.setHgap(10);
        gridLayout.setVgap(0);
        JPanel jPanel = new JPanel(gridLayout);
        jPanel.setOpaque(false);
        JTextArea jTextArea = new JTextArea(Resource.getString("OPERATION_DESC_TEXT", "Description : ") + this.opDetails.getDescription());
        jTextArea.setFont(font);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setOpaque(false);
        jTextArea.setBorder(BorderFactory.createEmptyBorder());
        jTextArea.setEditable(false);
        jPanel.add(jTextArea);
        this.add((Component)jPanel, "North");
        if (gUIHelperInterface.getType() == 1 && operationDetails.getOpcode() == 3) {
            stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_BROWSE_TEXT", "Browse"));
            JButton jButton = new JButton(stringArray[0]);
            jButton.setToolTipText(Resource.getString("BUTTON_BROWSE_TEXT_DSC", "Browse"));
            if (stringArray.length == 2) {
                jButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.fwFileName = new JTextField(20);
            this.fwFileName.setToolTipText(Resource.getString("FILE_NAME_DSC", "Enter Or Select File Name"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory() || file.getPath().toUpperCase().endsWith(".ROM") || file.getPath().toUpperCase().endsWith(".FW") || file.getPath().toUpperCase().endsWith(".BIN");
                        }

                        @Override
                        public String getDescription() {
                            return Resource.getString("LABEL_FILETYPE_FWFLASH", "Firmware Flash Files(*.rom,*.fw,*.bin)");
                        }
                    });
                    if (jFileChooser.showOpenDialog(null) == 0) {
                        OperationDetailPanel.this.fwFileName.setText(jFileChooser.getSelectedFile().getPath());
                    }
                }
            });
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_FILE_TEXT", "File:"));
            JLabel jLabel = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            jLabel.setLabelFor(this.fwFileName);
            AdapterHelper adapterHelper = (AdapterHelper)this.guiHelper;
            this.firmwarePanel = new JPanel();
            this.setFont(font);
            this.firmwarePanel.setOpaque(false);
            SASAdapter sASAdapter = (SASAdapter)gUIHelperInterface.getDeviceObject();
            if (sASAdapter.getAdapterType() == 2 || sASAdapter.getAdapterType() == 3 || sASAdapter.getAdapterType() == 4) {
                MR_CTRL_INFO mR_CTRL_INFO = adapterHelper.getAdapterInfo();
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                MR_FLASH_COMP_INFO[] mR_FLASH_COMP_INFOArray = mR_CTRL_INFO.getimageComponent_MR_CTRL_INFO();
                int n = Math.min(mR_FLASH_COMP_INFOArray.length, mR_CTRL_INFO.getimageComponentCount());
                for (int i = 0; i < n; ++i) {
                    if (Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getname()).equals("APP")) {
                        string = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
                        continue;
                    }
                    if (Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getname()).equals("BIOS")) {
                        string2 = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
                        continue;
                    }
                    if (Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getname()).equals("EFI-BSD")) {
                        string3 = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
                        continue;
                    }
                    if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getname()).equals("FCODE")) continue;
                    string4 = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
                }
                string3 = "NA";
                string4 = "NA";
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.firmwarePanel.setLayout(gridBagLayout);
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.ipady = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 17;
                if (sASAdapter.isWarhawk()) {
                    StringBuffer stringBuffer = new StringBuffer(Resource.getString("CURRENT_FW_PKG_VERSION_TEXT", "Current Firmware Package Version: "));
                    stringBuffer.append(Resource.zeroTrim(mR_CTRL_INFO.getfwPackageVersion()));
                    JLabel jLabel2 = new JLabel(stringBuffer.toString());
                    gridBagConstraints.gridy = 1;
                    gridBagConstraints.insets = new Insets(0, 10, 0, 0);
                    this.firmwarePanel.add((Component)jLabel2, gridBagConstraints);
                    StringBuffer stringBuffer2 = new StringBuffer(Resource.getString("CURRENT_VERSION_TEXT", "Current version: "));
                    stringBuffer2.append(string);
                    JLabel jLabel3 = new JLabel(stringBuffer2.toString());
                    gridBagConstraints.gridy = 2;
                    gridBagConstraints.insets = new Insets(0, 10, 0, 0);
                    this.firmwarePanel.add((Component)jLabel3, gridBagConstraints);
                    StringBuffer stringBuffer3 = new StringBuffer(Resource.getString("CURRENT_BIOS_VERSION_TEXT", "Current BIOS Version: "));
                    stringBuffer3.append(string2);
                    JLabel jLabel4 = new JLabel(stringBuffer3.toString());
                    gridBagConstraints.gridy = 3;
                    gridBagConstraints.insets = new Insets(0, 10, 0, 0);
                    this.firmwarePanel.add((Component)jLabel4, gridBagConstraints);
                    StringBuffer stringBuffer4 = new StringBuffer(Resource.getString("CURRENT_EFI_BSD_VERSION_TEXT", "Current EFI_BSD Version: "));
                    stringBuffer4.append(string3);
                    JLabel jLabel5 = new JLabel(stringBuffer4.toString());
                    gridBagConstraints.gridy = 4;
                    gridBagConstraints.insets = new Insets(0, 10, 0, 0);
                    this.firmwarePanel.add((Component)jLabel5, gridBagConstraints);
                    gridBagConstraints.gridy = 5;
                    this.firmwarePanel.add((Component)this.fwFileName, gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    this.firmwarePanel.add((Component)jButton, gridBagConstraints);
                    this.add((Component)this.firmwarePanel, "West");
                    this.setPreferredSize(new Dimension(460 * MainFrame.SCREEN_SIZE.width / 1024, 220 * MainFrame.SCREEN_SIZE.height / 768));
                } else {
                    JLabel jLabel6 = new JLabel(Resource.getString("FIRMWARE_UPDATE_TEXT", "Firmware to update:"));
                    this.firmwarePanel.add((Component)jLabel6, gridBagConstraints);
                    stringArray = Resource.getResourceMnemonic(Resource.getString("CONTROLLER_FIRMWARE_TEXT", "Controller firmware"));
                    this.objControllerFirmware = new JRadioButton(stringArray[0]);
                    if (stringArray.length == 2) {
                        this.objControllerFirmware.setMnemonic(stringArray[1].charAt(0));
                    }
                    this.objControllerFirmware.setSelected(true);
                    this.objControllerFirmware.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                    gridBagConstraints.gridy = 1;
                    this.firmwarePanel.add((Component)this.objControllerFirmware, gridBagConstraints);
                    this.objControllerFirmware.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (OperationDetailPanel.this.objControllerFirmware.isSelected()) {
                                OperationDetailPanel.this.objBIOS.setSelected(false);
                                OperationDetailPanel.this.objEFIBSD.setSelected(false);
                                OperationDetailPanel.this.objFCODE.setSelected(false);
                            }
                        }
                    });
                    StringBuffer stringBuffer = new StringBuffer(Resource.getString("CURRENT_VERSION_TEXT", "Current version: "));
                    stringBuffer.append(string);
                    JLabel jLabel7 = new JLabel(stringBuffer.toString());
                    gridBagConstraints.gridy = 2;
                    gridBagConstraints.insets = new Insets(0, 10, 0, 0);
                    this.firmwarePanel.add((Component)jLabel7, gridBagConstraints);
                    stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_LOAD_BIOS", "Load BIOS"));
                    this.objBIOS = new JRadioButton(stringArray[0]);
                    if (stringArray.length == 2) {
                        this.objBIOS.setMnemonic(stringArray[1].charAt(0));
                    }
                    this.objBIOS.setSelected(false);
                    this.objBIOS.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                    gridBagConstraints.gridy = 3;
                    gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                    this.firmwarePanel.add((Component)this.objBIOS, gridBagConstraints);
                    this.objBIOS.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (OperationDetailPanel.this.objBIOS.isSelected()) {
                                OperationDetailPanel.this.objControllerFirmware.setSelected(false);
                                OperationDetailPanel.this.objEFIBSD.setSelected(false);
                                OperationDetailPanel.this.objFCODE.setSelected(false);
                            }
                        }
                    });
                    StringBuffer stringBuffer5 = new StringBuffer(Resource.getString("CURRENT_VERSION_TEXT", "Current version: "));
                    stringBuffer5.append(string2);
                    JLabel jLabel8 = new JLabel(stringBuffer5.toString());
                    gridBagConstraints.gridy = 4;
                    gridBagConstraints.insets = new Insets(0, 10, 0, 0);
                    this.firmwarePanel.add((Component)jLabel8, gridBagConstraints);
                    stringArray = Resource.getResourceMnemonic(Resource.getString("EFI_BSD_TEXT", "EFI-BSD"));
                    this.objEFIBSD = new JRadioButton(stringArray[0]);
                    if (stringArray.length == 2) {
                        this.objEFIBSD.setMnemonic(stringArray[1].charAt(0));
                    }
                    this.objEFIBSD.setSelected(false);
                    this.objEFIBSD.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                    gridBagConstraints.gridy = 5;
                    gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                    this.firmwarePanel.add((Component)this.objEFIBSD, gridBagConstraints);
                    this.objEFIBSD.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (OperationDetailPanel.this.objEFIBSD.isSelected()) {
                                OperationDetailPanel.this.objControllerFirmware.setSelected(false);
                                OperationDetailPanel.this.objBIOS.setSelected(false);
                                OperationDetailPanel.this.objFCODE.setSelected(false);
                            }
                        }
                    });
                    StringBuffer stringBuffer6 = new StringBuffer(Resource.getString("CURRENT_VERSION_TEXT", "Current version: "));
                    stringBuffer6.append(string3);
                    JLabel jLabel9 = new JLabel(stringBuffer6.toString());
                    gridBagConstraints.gridy = 6;
                    gridBagConstraints.insets = new Insets(0, 10, 0, 0);
                    this.firmwarePanel.add((Component)jLabel9, gridBagConstraints);
                    stringArray = Resource.getResourceMnemonic(Resource.getString("FCODE_TEXT", "FCODE"));
                    this.objFCODE = new JRadioButton(stringArray[0]);
                    if (stringArray.length == 2) {
                        this.objFCODE.setMnemonic(stringArray[1].charAt(0));
                    }
                    this.objFCODE.setSelected(false);
                    this.objFCODE.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                    gridBagConstraints.gridy = 7;
                    gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                    this.objFCODE.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (OperationDetailPanel.this.objFCODE.isSelected()) {
                                OperationDetailPanel.this.objControllerFirmware.setSelected(false);
                                OperationDetailPanel.this.objBIOS.setSelected(false);
                                OperationDetailPanel.this.objEFIBSD.setSelected(false);
                            }
                        }
                    });
                    StringBuffer stringBuffer7 = new StringBuffer(Resource.getString("CURRENT_VERSION_TEXT", "Current version: "));
                    stringBuffer7.append(string4);
                    JLabel jLabel10 = new JLabel(stringBuffer7.toString());
                    gridBagConstraints.gridy = 8;
                    gridBagConstraints.insets = new Insets(0, 10, 0, 0);
                    gridBagConstraints.gridy = 10;
                    gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                    this.firmwarePanel.add((Component)jLabel, gridBagConstraints);
                    gridBagConstraints.gridy = 11;
                    this.firmwarePanel.add((Component)this.fwFileName, gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    this.firmwarePanel.add((Component)jButton, gridBagConstraints);
                    this.add((Component)this.firmwarePanel, "West");
                    this.setPreferredSize(new Dimension(460 * MainFrame.SCREEN_SIZE.width / 1024, 220 * MainFrame.SCREEN_SIZE.height / 768));
                }
            } else {
                this.firmwarePanel.add(jLabel);
                this.firmwarePanel.add(this.fwFileName);
                this.firmwarePanel.add(jButton);
                this.add((Component)this.firmwarePanel, "Center");
                this.setPreferredSize(new Dimension(460 * MainFrame.SCREEN_SIZE.width / 1024, 150 * MainFrame.SCREEN_SIZE.height / 768));
            }
        } else if (gUIHelperInterface.getType() == 1 && operationDetails.getOpcode() == 2) {
            JComponent jComponent;
            JLabel jLabel;
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel2.setLayout(gridBagLayout);
            Dimension dimension = new Dimension(MainFrame.SCREEN_SIZE.width * 60 / 1024, MainFrame.SCREEN_SIZE.height * 20 / 768);
            int n = 0;
            int n2 = 0;
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            JFormattedTextField jFormattedTextField = new JFormattedTextField();
            if (((AdapterHelper)gUIHelperInterface).getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getrbldRate() != 0) {
                this.propold = ((AdapterHelper)this.guiHelper).getAdapterProperties();
                stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_REBUILDRATE_TEXT", "Rebuild Rate"));
                jLabel = new JLabel(stringArray[0] + " (%)  ");
                if (stringArray.length == 2) {
                    jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
                }
                jLabel.setFont(font);
                this.rebuildRate = new JSpinner(new SpinnerNumberModel(this.propold.getrebuildRate(), 0, 100, 1));
                jComponent = this.rebuildRate.getEditor();
                if (jComponent instanceof JSpinner.NumberEditor) {
                    jFormattedTextField = ((JSpinner.NumberEditor)jComponent).getTextField();
                }
                jFormattedTextField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                        if (!Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyCode() != 8 && keyEvent.getKeyCode() != 127) {
                            keyEvent.consume();
                            return;
                        }
                    }
                });
                jLabel.setLabelFor(this.rebuildRate);
                this.rebuildRate.setPreferredSize(dimension);
                this.rebuildRate.setToolTipText(Resource.getString("REBUIL_DRATE_DSC", "Rebuild Rate"));
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.anchor = 13;
                jPanel2.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.anchor = 17;
                jPanel2.add((Component)this.rebuildRate, gridBagConstraints);
            }
            if (((AdapterHelper)gUIHelperInterface).getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getpatrolRate() != 0) {
                stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_PATROLREADRATE_TEXT", "Patrol Rate"));
                jLabel = new JLabel(stringArray[0] + " (%)   ");
                if (stringArray.length == 2) {
                    jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
                }
                jLabel.setFont(font);
                this.prRate = new JSpinner(new SpinnerNumberModel(this.propold.getpatrolReadRate(), 0, 100, 1));
                jComponent = this.prRate.getEditor();
                if (jComponent instanceof JSpinner.NumberEditor) {
                    jFormattedTextField = ((JSpinner.NumberEditor)jComponent).getTextField();
                }
                jFormattedTextField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                        if (!Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyCode() != 8 && keyEvent.getKeyCode() != 127) {
                            keyEvent.consume();
                            return;
                        }
                    }
                });
                jLabel.setLabelFor(this.prRate);
                this.prRate.setPreferredSize(dimension);
                this.prRate.setToolTipText(Resource.getString("PATROL_READRATE_DSC", "Patrol Rate"));
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.anchor = 13;
                jPanel2.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.anchor = 17;
                jPanel2.add((Component)this.prRate, gridBagConstraints);
            }
            if (((AdapterHelper)gUIHelperInterface).getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getbgiRate() != 0) {
                stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_BGIRATE_TEXT", "BGI Rate"));
                jLabel = new JLabel(stringArray[0] + " (%)   ");
                if (stringArray.length == 2) {
                    jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
                }
                jLabel.setFont(font);
                this.bgiRate = new JSpinner(new SpinnerNumberModel(this.propold.getbgiRate(), 0, 100, 1));
                jComponent = this.bgiRate.getEditor();
                if (jComponent instanceof JSpinner.NumberEditor) {
                    jFormattedTextField = ((JSpinner.NumberEditor)jComponent).getTextField();
                }
                jFormattedTextField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                        if (!Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyCode() != 8 && keyEvent.getKeyCode() != 127) {
                            keyEvent.consume();
                            return;
                        }
                    }
                });
                jLabel.setLabelFor(this.bgiRate);
                this.bgiRate.setPreferredSize(dimension);
                this.bgiRate.setToolTipText(Resource.getString("BGI_RATE_DSC", "BGI Rate"));
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.anchor = 13;
                jPanel2.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.anchor = 17;
                jPanel2.add((Component)this.bgiRate, gridBagConstraints);
            }
            if (((AdapterHelper)gUIHelperInterface).getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getccRate() != 0) {
                stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_CCRATE_TEXT", "Check Consistency Rate"));
                jLabel = new JLabel(stringArray[0] + " (%)   ");
                if (stringArray.length == 2) {
                    jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
                }
                jLabel.setFont(font);
                this.ccRate = new JSpinner(new SpinnerNumberModel(this.propold.getccRate(), 0, 100, 1));
                jComponent = this.ccRate.getEditor();
                if (jComponent instanceof JSpinner.NumberEditor) {
                    jFormattedTextField = ((JSpinner.NumberEditor)jComponent).getTextField();
                }
                jFormattedTextField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                        if (!Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyCode() != 8 && keyEvent.getKeyCode() != 127) {
                            keyEvent.consume();
                            return;
                        }
                    }
                });
                jLabel.setLabelFor(this.ccRate);
                this.ccRate.setPreferredSize(dimension);
                this.ccRate.setToolTipText(Resource.getString("CC_RATE_DSC", "Check Consistency Rate"));
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.anchor = 13;
                jPanel2.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.anchor = 17;
                jPanel2.add((Component)this.ccRate, gridBagConstraints);
            }
            if (((AdapterHelper)gUIHelperInterface).getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getreconRate() != 0) {
                stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_RECONRATE_TEXT", "Reconstruction Rate"));
                jLabel = new JLabel(stringArray[0] + " (%)   ");
                if (stringArray.length == 2) {
                    jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
                }
                jLabel.setFont(font);
                this.reconRate = new JSpinner(new SpinnerNumberModel(this.propold.getreconRate(), 0, 100, 1));
                jComponent = this.reconRate.getEditor();
                if (jComponent instanceof JSpinner.NumberEditor) {
                    jFormattedTextField = ((JSpinner.NumberEditor)jComponent).getTextField();
                }
                jFormattedTextField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                        if (!Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyCode() != 8 && keyEvent.getKeyCode() != 127) {
                            keyEvent.consume();
                            return;
                        }
                    }
                });
                jLabel.setLabelFor(this.reconRate);
                this.reconRate.setPreferredSize(dimension);
                this.reconRate.setToolTipText(Resource.getString("RECON_RATE_DSC", "Reconstruction Rate"));
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.anchor = 13;
                jPanel2.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.anchor = 17;
                jPanel2.add((Component)this.reconRate, gridBagConstraints);
            }
            this.setPreferredSize(new Dimension(460 * MainFrame.SCREEN_SIZE.width / 1024, 200 * MainFrame.SCREEN_SIZE.height / 768));
            jPanel2.setOpaque(false);
            this.add((Component)jPanel2, "Center");
        } else if (gUIHelperInterface.getType() == 2 && operationDetails.getOpcode() == 11) {
            AdapterHelper adapterHelper = (AdapterHelper)this.guiHelper.getParent();
            ArrayHelper[] arrayHelperArray = adapterHelper.getArrays();
            ArrayList<ArrayHelper> arrayList = new ArrayList<ArrayHelper>();
            for (int i = 0; i < arrayHelperArray.length; ++i) {
                if (!arrayHelperArray[i].isPDEligibleforDHSP((PhysicalDriveHelper)gUIHelperInterface)) continue;
                arrayList.add(arrayHelperArray[i]);
            }
            arrayHelperArray = new ArrayHelper[arrayList.size()];
            arrayList.toArray(arrayHelperArray);
            this.m_driveGroupsList = new JList<ArrayHelper>(arrayHelperArray);
            this.m_driveGroupsList.setVisibleRowCount(5);
            this.m_driveGroupsList.setSelectionMode(2);
            class ArrayListRenderer
            extends DefaultListCellRenderer {
                ArrayListRenderer() {
                }

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    ArrayHelper arrayHelper = (ArrayHelper)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (arrayHelper.getSpanDepth() > 1) {
                        stringBuffer.append(Resource.getString("SPANNED_DRIVE_GROUP_TEXT", "Spanned Drive Group"));
                        stringBuffer.append(" ");
                        stringBuffer.append(arrayHelper.getParentIDForSpan());
                        stringBuffer.append(", ");
                        stringBuffer.append(arrayHelper.getText());
                        stringBuffer.append(": " + arrayHelper.getTotalCapacity());
                    } else {
                        stringBuffer.append(arrayHelper.getText());
                        stringBuffer.append(": " + arrayHelper.getTotalCapacity());
                    }
                    JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    jLabel.setText(stringBuffer.toString());
                    return jLabel;
                }
            }
            this.m_driveGroupsList.setCellRenderer(new ArrayListRenderer());
            String[] stringArray3 = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_DRIVE_GROUPS", "(S)elect drive group(s):"));
            JLabel jLabel = new JLabel(stringArray3[0]);
            if (stringArray3.length == 2 && stringArray3.length == 2) {
                jLabel.setDisplayedMnemonic(stringArray3[1].charAt(0));
            }
            jLabel.setLabelFor(this.m_driveGroupsList);
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 0, 1, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            jPanel3.add((Component)new JLabel(Resource.getString("DEDICATED_HSP_DESC", "<html>A dedicated hot spare will only replace problematic drives on selected drive groups.<br><br></html>")), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            jPanel3.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets.bottom = 10;
            gridBagConstraints.gridy = 2;
            JScrollPane jScrollPane = new JScrollPane(this.m_driveGroupsList, 20, 31);
            jPanel3.add((Component)jScrollPane, gridBagConstraints);
            jPanel3.setOpaque(false);
            this.add((Component)jPanel3, "Center");
        } else if (gUIHelperInterface.getType() == 1 && operationDetails.getOpcode() == 16) {
            this.opDetails.setOpcode(15);
            gUIHelperInterface.issueOperation(this.opDetails);
            MR_PR_PROPERTIES mR_PR_PROPERTIES = (MR_PR_PROPERTIES)this.opDetails.getParam();
            JPanel jPanel4 = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel4.setLayout(gridBagLayout);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_MODE_TEXT", "Operation Mode :"));
            JLabel jLabel = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            jLabel.setFont(font);
            Object[] objectArray = new String[]{Resource.getString("OPMODE_AUTO", "Auto"), Resource.getString("OPMODE_MANUAL", "Manual"), Resource.getString("OPMODE_DISABLED", "Disabled")};
            this.opMode = new CustomComboBox(objectArray);
            this.opMode.setToolTipText(Resource.getString("OPMODE_DSC", "Operation Mode"));
            this.opMode.setSelectedIndex(mR_PR_PROPERTIES.getopMode());
            this.opMode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (OperationDetailPanel.this.opMode.getSelectedIndex() != -1) {
                        if (OperationDetailPanel.this.opMode.getSelectedIndex() == 2) {
                            OperationDetailPanel.this.maxPD.setEnabled(false);
                            for (int i = 0; i < OperationDetailPanel.this.listPanel.getListCount(); ++i) {
                                OperationDetailPanel.this.listPanel.setSelection(false, i);
                            }
                            OperationDetailPanel.this.freqContinuous.setEnabled(false);
                            OperationDetailPanel.this.freqHour.setEnabled(false);
                            OperationDetailPanel.this.freqMin.setEnabled(false);
                            OperationDetailPanel.this.freqSec.setEnabled(false);
                        } else {
                            OperationDetailPanel.this.maxPD.setEnabled(true);
                            for (int i = 0; i < OperationDetailPanel.this.listPanel.getListCount(); ++i) {
                                OperationDetailPanel.this.listPanel.setSelection(true, i);
                            }
                            OperationDetailPanel.this.freqContinuous.setEnabled(true);
                            OperationDetailPanel.this.freqHour.setEnabled(true);
                            OperationDetailPanel.this.freqMin.setEnabled(true);
                            OperationDetailPanel.this.freqSec.setEnabled(true);
                        }
                    }
                }
            });
            jLabel.setLabelFor(this.opMode);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            jPanel4.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            jPanel4.add((Component)this.opMode, gridBagConstraints);
            stringArray = Resource.getResourceMnemonic(Resource.getString("MAXPD_COUNT_TEXT", "Maximum PD Count for patrolling :"));
            JLabel jLabel11 = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel11.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            jLabel11.setFont(font);
            int n = NetworkToJavaConverter.unsignedCharToInt(mR_PR_PROPERTIES.getmaxPD());
            short s = ((AdapterHelper)gUIHelperInterface).getAdapterInfo().getMaxPDs();
            this.maxPD = new JSpinner(new SpinnerNumberModel(n, 0, s - 1, 1));
            jLabel11.setLabelFor(this.maxPD);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 13;
            jPanel4.add((Component)jLabel11, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            jPanel4.add((Component)this.maxPD, gridBagConstraints);
            this.maxPD.setToolTipText(Resource.getString("MAXPD_COUNT_DSC", "Maximum PD Count for patrolling"));
            Object[] objectArray2 = ((AdapterHelper)this.guiHelper).getLogicalDrives();
            short[] sArray = mR_PR_PROPERTIES.getexcludedLD();
            this.listPanel = new MultiSelectList(objectArray2);
            for (int i = 0; i < objectArray2.length; ++i) {
                for (int j = 0; j < mR_PR_PROPERTIES.getexcludeLdCount(); ++j) {
                    if (((LogicalDriveHelper)objectArray2[i]).getDeviceObject().getID() != sArray[j]) continue;
                    this.listPanel.setSelectedIndex(i, true);
                }
            }
            this.listPanel.setTitle(Resource.getString("LABEL_SELECTLD_TEXT", "Select Excluded Virtual Disks :"));
            JScrollPane jScrollPane = new JScrollPane(this.listPanel);
            jScrollPane.setPreferredSize(new Dimension(250 * MainFrame.SCREEN_SIZE.width / 1024, 150 * MainFrame.SCREEN_SIZE.height / 768));
            jScrollPane.setMaximumSize(jScrollPane.getPreferredSize());
            jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 10;
            jPanel4.add((Component)jScrollPane, gridBagConstraints);
            this.listPanel.setToolTipText(Resource.getString("LABEL_SELECTLD_DSC", "Select Excluded Virtual Disks"));
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_PATROL_CONTINUOUS", "Continuous Patrolling"));
            this.freqContinuous = new JCheckBox(stringArray[0]);
            if (stringArray.length == 2) {
                this.freqContinuous.setMnemonic(stringArray[1].charAt(0));
            }
            this.freqContinuous.setToolTipText(Resource.getString("CHECKBOX_PATROL_CONTINUOUS_DCS", "Continuous Patrolling"));
            this.freqContinuous.setOpaque(false);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 10;
            jPanel4.add((Component)this.freqContinuous, gridBagConstraints);
            stringArray = Resource.getResourceMnemonic(Resource.getString("FREQUENCY_TEXT", "Execution Frequency :"));
            JLabel jLabel12 = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel12.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            jLabel12.setFont(font);
            this.freqHour = new JSpinner(new SpinnerNumberModel(0, 0, this.EXE_FREQ_HOUR_MAX_VAL, 1));
            jLabel12.setLabelFor(this.freqHour);
            this.freqMin = new JSpinner(new SpinnerNumberModel(0, 0, this.EXE_FREQ_MIN_MAX_VAL, 1));
            this.freqSec = new JSpinner(new SpinnerNumberModel(1, 0, this.EXE_FREQ_SEC_MAX_VAL, 1));
            this.freqHour.setToolTipText(Resource.getString("FREQUENCY_HOUR_DSC", "Execution Frequency Hours"));
            this.freqMin.setToolTipText(Resource.getString("FREQUENCY_MIN_DSC", "Execution Frequency Minutes"));
            this.freqSec.setToolTipText(Resource.getString("FREQUENCY_SEC_DSC", "Execution Frequency Seconds"));
            this.freqHour.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    if ((keyEvent.getKeyChar() < '0' || keyEvent.getKeyChar() > '9') && keyEvent.getKeyChar() != '\b') {
                        keyEvent.consume();
                    }
                }
            });
            this.freqMin.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    if ((keyEvent.getKeyChar() < '0' || keyEvent.getKeyChar() > '9') && keyEvent.getKeyChar() != '\b') {
                        keyEvent.consume();
                    }
                }
            });
            this.freqSec.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    if ((keyEvent.getKeyChar() < '0' || keyEvent.getKeyChar() > '9') && keyEvent.getKeyChar() != '\b') {
                        keyEvent.consume();
                    }
                }
            });
            this.freqContinuous.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OperationDetailPanel.this.freqHour.setEnabled(!OperationDetailPanel.this.freqContinuous.isSelected());
                    OperationDetailPanel.this.freqMin.setEnabled(!OperationDetailPanel.this.freqContinuous.isSelected());
                    OperationDetailPanel.this.freqSec.setEnabled(!OperationDetailPanel.this.freqContinuous.isSelected());
                }
            });
            if (mR_PR_PROPERTIES.getexecFreq() > 0) {
                int n3 = mR_PR_PROPERTIES.getexecFreq();
                if (n3 >= 3600) {
                    this.freqHour.setValue(new Integer(n3 / 3600));
                    n3 %= 3600;
                }
                if (n3 >= 60) {
                    this.freqMin.setValue(new Integer(n3 / 60));
                    n3 %= 60;
                }
                this.freqSec.setValue(new Integer(n3));
            } else if (mR_PR_PROPERTIES.getexecFreq() == -1) {
                this.freqContinuous.setSelected(true);
                this.freqHour.setEnabled(false);
                this.freqMin.setEnabled(false);
                this.freqSec.setEnabled(false);
            }
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.anchor = 13;
            jPanel4.add((Component)jLabel12, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new FlowLayout());
            jPanel5.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
            jPanel5.add(this.freqHour);
            jPanel5.add(new JLabel(Resource.getString("FREQUENCY_TEXT_HOUR", "Hour")));
            jPanel5.add(this.freqMin);
            jPanel5.add(new JLabel(Resource.getString("FREQUENCY_TEXT_MINUTE", "Minute")));
            jPanel5.add(this.freqSec);
            jPanel5.add(new JLabel(Resource.getString("FREQUENCY_TEXT_SEC", "Second")));
            jPanel4.add((Component)jPanel5, gridBagConstraints);
            this.setPreferredSize(new Dimension(700 * MainFrame.SCREEN_SIZE.width / 1024, 400 * MainFrame.SCREEN_SIZE.height / 768));
            jPanel4.setOpaque(false);
            this.add((Component)jPanel4, "Center");
            if (mR_PR_PROPERTIES.getopMode() == '\u0002') {
                this.maxPD.setEnabled(false);
                this.listPanel.setEnabled(false);
                for (int i = 0; i < this.listPanel.getListCount(); ++i) {
                    this.listPanel.setSelection(false, i);
                }
                this.freqContinuous.setEnabled(false);
                this.freqHour.setEnabled(false);
                this.freqMin.setEnabled(false);
                this.freqSec.setEnabled(false);
            }
            this.opDetails.setOpcode(16);
        } else if (gUIHelperInterface.getType() == 1 && operationDetails.getOpcode() == 18088704) {
            int n;
            this.opDetails.setOpcode(18088448);
            gUIHelperInterface.issueOperation(this.opDetails);
            MR_CC_SCHEDULE_PROPERTIES mR_CC_SCHEDULE_PROPERTIES = ((SASAdapter)gUIHelperInterface.getDeviceObject()).getCCSchProperties();
            JPanel jPanel6 = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel6.setLayout(gridBagLayout);
            Dimension dimension = new Dimension(MainFrame.SCREEN_SIZE.width * 100 / 1024, MainFrame.SCREEN_SIZE.height * 20 / 768);
            Dimension dimension2 = new Dimension(MainFrame.SCREEN_SIZE.width * 50 / 1024, MainFrame.SCREEN_SIZE.height * 20 / 768);
            Dimension dimension3 = new Dimension(MainFrame.SCREEN_SIZE.width * 70 / 1024, MainFrame.SCREEN_SIZE.height * 20 / 768);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            stringArray2 = Resource.getResourceMnemonic(Resource.getString("CTRL_OP_CC_RUN_TEXT", "Run consistency check:"));
            JLabel jLabel = new JLabel(stringArray2[0]);
            jLabel.setFont(font);
            if (stringArray2.length == 2) {
                jLabel.setDisplayedMnemonic(stringArray2[1].charAt(0));
            }
            Object[] objectArray = new String[]{Resource.getString("CTRL_OP_CC_OPTION_HOURLY", "Hourly"), Resource.getString("CTRL_OP_CC_OPTION_DAILY", "Daily"), Resource.getString("CTRL_OP_CC_OPTION_WEEKLY", "Weekly"), Resource.getString("CTRL_OP_CC_OPTION_MONTHLY", "Monthly"), Resource.getString("CTRL_OP_CC_OPTION_DISABLE", "Disable")};
            this.ccOption = new CustomComboBox(objectArray);
            stringArray2 = Resource.getResourceMnemonic(Resource.getString("ABOUT_CC_ADVANCED_BUTTON_TEXT", "Advanced"));
            this.ccAdvanced = new JButton(stringArray2[0]);
            if (stringArray2.length == 2) {
                this.ccAdvanced.setMnemonic(stringArray2[1].charAt(0));
            }
            this.ccAdvanced.setToolTipText(Resource.getString("CTRL_BUTTON_CC_ADVANCED_DSC", "Consistency Check Advanced Window"));
            this.ccAdvanced.setPreferredSize(dimension);
            LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.guiHelper).getLogicalDrives();
            ScheduleCCAdvanced.setMode(mR_CC_SCHEDULE_PROPERTIES.getopMode());
            ScheduleCCAdvanced.setexcludeCount(mR_CC_SCHEDULE_PROPERTIES.getexcludeLdCount());
            ScheduleCCAdvanced.setexclude(mR_CC_SCHEDULE_PROPERTIES.getexcludedLD());
            this.ccAdvancedListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OperationDetailPanel.this.scheduleAdvanced = new ScheduleCCAdvanced(OperationDetailPanel.this.guiHelper, OperationDetailPanel.this.opDetails);
                }
            };
            this.ccAdvanced.addActionListener(this.ccAdvancedListener);
            this.ccOption.setPreferredSize(dimension);
            this.ccOption.setToolTipText(Resource.getString("CTRL_OP_CC_OPTION_DSC", "Consistency Check Opertaion Mode"));
            jLabel.setLabelFor(this.ccOption);
            this.ccOptionListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        if (OperationDetailPanel.this.ccOption.getSelectedIndex() == 4) {
                            OperationDetailPanel.this.ccContinuous.setEnabled(false);
                            OperationDetailPanel.this.ccMonth.setEnabled(false);
                            OperationDetailPanel.this.ccDay.setEnabled(false);
                            OperationDetailPanel.this.ccYear.setEnabled(false);
                            OperationDetailPanel.this.ccTime.setEnabled(false);
                            OperationDetailPanel.this.ccAdvanced.setEnabled(false);
                            OperationDetailPanel.this.ccOption.setEnabled(true);
                            OperationDetailPanel.this.ccContinuous.setSelected(false);
                        } else {
                            OperationDetailPanel.this.ccContinuous.setEnabled(true);
                            OperationDetailPanel.this.ccMonth.setEnabled(true);
                            OperationDetailPanel.this.ccDay.setEnabled(true);
                            OperationDetailPanel.this.ccYear.setEnabled(true);
                            OperationDetailPanel.this.ccTime.setEnabled(true);
                            OperationDetailPanel.this.ccAdvanced.setEnabled(true);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            jPanel6.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.ccOption.addItemListener(this.ccOptionListener);
            JPanel jPanel7 = new JPanel();
            this.ccAdvanced.setBounds(20, 20, 50, 50);
            jPanel7.add(this.ccOption);
            jPanel7.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel7.add(this.ccAdvanced);
            jPanel7.setOpaque(false);
            jPanel6.add((Component)jPanel7, gridBagConstraints);
            stringArray2 = Resource.getResourceMnemonic(Resource.getString("CTRL_OP_CC_RUN_CONTINUOUS_TEXT", "Run consistency check continuously"));
            this.ccContinuous = new JCheckBox(stringArray2[0]);
            if (stringArray2.length == 2) {
                this.ccContinuous.setMnemonic(stringArray2[1].charAt(0));
            }
            this.ccContinuous.setToolTipText(Resource.getString("CHECKBOX_CC_RUN_CONTINUOUS_DSC", "consistency check continuously"));
            this.ccContinuousListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        if (OperationDetailPanel.this.ccContinuous.isSelected()) {
                            OperationDetailPanel.this.ccOption.setEnabled(false);
                        } else {
                            OperationDetailPanel.this.ccOption.setEnabled(true);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.ccContinuous.addItemListener(this.ccContinuousListener);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            jPanel6.add((Component)this.ccContinuous, gridBagConstraints);
            stringArray2 = Resource.getResourceMnemonic(Resource.getString("CTRL_OP_CC_START_DATE_TEXT", "Start on:"));
            jLabel = new JLabel(stringArray2[0]);
            jLabel.setFont(font);
            if (stringArray2.length == 2) {
                jLabel.setDisplayedMnemonic(stringArray2[1].charAt(0));
            }
            gridBagConstraints.gridy = 3;
            gridBagConstraints.insets = new Insets(0, 0, 0, 60);
            jPanel6.add((Component)jLabel, gridBagConstraints);
            String[] stringArray4 = new String[]{Resource.getString("MONTH_JANUARY_TEXT", "January"), Resource.getString("MONTH_FEBRUARY_TEXT", "February"), Resource.getString("MONTH_MARCH_TEXT", "March"), Resource.getString("MONTH_APRIL_TEXT", "April"), Resource.getString("MONTH_MAY_TEXT", "May"), Resource.getString("MONTH_JUNE_TEXT", "June"), Resource.getString("MONTH_JULY_TEXT", "July"), Resource.getString("MONTH_AUGUST_TEXT", "August"), Resource.getString("MONTH_SEPTEMBER_TEXT", "September"), Resource.getString("MONTH_OCTOBER_TEXT", "October"), Resource.getString("MONTH_NOVEMBER_TEXT", "November"), Resource.getString("MONTH_DECEMBER_TEXT", "December")};
            this.ccMonth = new JComboBox<String>(stringArray4);
            jLabel.setLabelFor(this.ccMonth);
            this.ccMonth.setPreferredSize(dimension);
            this.ccMonthListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        int n = OperationDetailPanel.this.ccMonth.getSelectedIndex();
                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                        if (gregorianCalendar.get(2) < 2) {
                            gregorianCalendar.set(1, gregorianCalendar.get(1) + 1);
                        }
                        gregorianCalendar.set(2, n);
                        int n2 = ((Calendar)gregorianCalendar).getActualMaximum(5);
                        OperationDetailPanel.this.ccDay.removeAllItems();
                        for (int i = 1; i <= n2; ++i) {
                            OperationDetailPanel.this.ccDay.addItem(new Integer(i).toString());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            this.ccMonth.addItemListener(this.ccMonthListener);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.ccDay = new JComboBox();
            this.ccDay.setPreferredSize(dimension2);
            gridBagConstraints.fill = 0;
            this.ccYear = new JComboBox();
            this.ccYear.setPreferredSize(dimension3);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            int n4 = gregorianCalendar.get(1);
            this.ccYear.addItem(n4);
            for (int i = 1; i <= 10; ++i) {
                this.ccYear.addItem(n4 + i);
            }
            JPanel jPanel8 = new JPanel();
            jPanel8.add(this.ccMonth);
            jPanel8.add(this.ccDay);
            jPanel8.add(this.ccYear);
            jPanel8.setOpaque(false);
            jPanel6.add((Component)jPanel8, gridBagConstraints);
            stringArray2 = Resource.getResourceMnemonic(Resource.getString("CTRL_OP_CC_START_TIME_TEXT", "Start time:"));
            jLabel = new JLabel(stringArray2[0]);
            jLabel.setFont(font);
            if (stringArray2.length == 2) {
                jLabel.setDisplayedMnemonic(stringArray2[1].charAt(0));
            }
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 50);
            jPanel6.add((Component)jLabel, gridBagConstraints);
            this.ccTime = new JComboBox();
            String[] stringArray5 = new String[]{"12:00", "01:00", "02:00", "03:00", "04:00", "05:00", "06:00", "07:00", "08:00", "09:00", "10:00", "11:00"};
            for (n = 0; n < stringArray5.length; ++n) {
                this.ccTime.addItem(stringArray5[n] + " " + Resource.getString("TIME_AM_TEXT", "AM"));
            }
            for (n = 0; n < stringArray5.length; ++n) {
                this.ccTime.addItem(stringArray5[n] + " " + Resource.getString("TIME_PM_TEXT", "PM"));
            }
            this.ccTime.setPreferredSize(dimension);
            jLabel.setLabelFor(this.ccTime);
            gridBagConstraints.gridy = 6;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel6.add((Component)this.ccTime, gridBagConstraints);
            this.setPreferredSize(new Dimension(460 * MainFrame.SCREEN_SIZE.width / 1024, 350 * MainFrame.SCREEN_SIZE.height / 768));
            jPanel6.setOpaque(false);
            this.add((Component)jPanel6, "Center");
            this.ccMonth.setSelectedIndex(1);
            this.ccMonth.setSelectedIndex(0);
            n = mR_CC_SCHEDULE_PROPERTIES.getexecFreq();
            if (n == 3600) {
                this.ccOption.setSelectedIndex(0);
            } else if (n == 86400) {
                this.ccOption.setSelectedIndex(1);
            } else if (n == 604800) {
                this.ccOption.setSelectedIndex(2);
            } else if (n >= 2419200 && n <= 2678400) {
                this.ccOption.setSelectedIndex(3);
            } else if (n == -1) {
                this.ccContinuous.setSelected(true);
            }
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
            long l = gregorianCalendar2.getTimeInMillis();
            long l2 = (long)mR_CC_SCHEDULE_PROPERTIES.getnextExec() * 1000L;
            TimeZone timeZone = TimeZone.getDefault();
            gregorianCalendar2.setTimeInMillis(l + l2);
            int n5 = gregorianCalendar2.get(2);
            int n6 = gregorianCalendar2.get(5) - 1;
            int n7 = gregorianCalendar2.get(1);
            this.ccMonth.setSelectedIndex(n5);
            this.ccDay.setSelectedIndex(n6);
            this.ccYear.setSelectedItem(n7);
            boolean bl = timeZone.inDaylightTime(gregorianCalendar2.getTime());
            if (bl) {
                int n8 = timeZone.getDSTSavings();
                gregorianCalendar2.setTimeInMillis(l + l2 - (long)n8);
            } else {
                gregorianCalendar2.setTimeInMillis(l + l2);
            }
            String string = (gregorianCalendar2.get(10) < 10 ? "0" : "") + new Integer(gregorianCalendar2.get(10)).toString() + ":00 " + (gregorianCalendar2.get(9) == 0 ? Resource.getString("TIME_AM_TEXT", "AM") : Resource.getString("TIME_PM_TEXT", "PM"));
            if (string.equals("00:00 PM")) {
                string = "12:00 PM";
            }
            this.ccTime.setSelectedItem(string);
            if (mR_CC_SCHEDULE_PROPERTIES.getopMode() == 0) {
                this.ccOption.setSelectedIndex(4);
            }
            this.opDetails.setOpcode(18088704);
        } else if (gUIHelperInterface.getType() == 1 && operationDetails.getOpcode() == 0x1020200) {
            JPanel jPanel9 = new JPanel(new GridLayout(2, 1));
            jPanel9.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.ccOnError = new JRadioButton(Resource.getString("MSG_CC_ON_ERROR", "Stop Consistency Check on Error"), false);
            this.ccFixError = new JRadioButton(Resource.getString("MSG_CC_FIX_ERROR", "Continue Consistency Check and Fix Errors"), false);
            this.ccOnError.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
            this.ccFixError.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
            this.ccFixError.setToolTipText(Resource.getString("MSG_CC_FIX_ERROR_DSC", "Continue Consistency Check and Fix Errors"));
            this.ccOnError.setToolTipText(Resource.getString("MSG_CC_ON_ERROR_DSC", "Stop Consistency Check on Error"));
            if (((AdapterHelper)gUIHelperInterface).getAdapterProperties().getAbortCCOnError() == 1) {
                this.ccOnError.setSelected(true);
            } else if (((AdapterHelper)gUIHelperInterface).getAdapterProperties().getAbortCCOnError() == 0) {
                this.ccFixError.setSelected(true);
            }
            JPanel jPanel10 = new JPanel();
            jPanel10.setOpaque(false);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel10.setLayout(gridBagLayout);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 10;
            buttonGroup.add(this.ccOnError);
            buttonGroup.add(this.ccFixError);
            jPanel9.add(this.ccOnError);
            jPanel9.add(this.ccFixError);
            int n = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("MSG_CC_FIX_ERROR", "Continue Consistency Check and Fix Errors"));
            jPanel9.setPreferredSize(new Dimension(n + 60, (int)jPanel9.getPreferredSize().getHeight()));
            jPanel10.add((Component)jPanel9, gridBagConstraints);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n9 = fontMetrics.getHeight() * 2 + 200;
            this.add((Component)jPanel10, "Center");
            int n10 = this.getPreferredSize().width < 450 ? 450 : this.getPreferredSize().width;
            this.setPreferredSize(new Dimension(n10, n9));
        } else if (this.guiHelper.getType() == 1 && this.opDetails.getOpcode() == 0x7010000) {
            AdapterHelper adapterHelper = (AdapterHelper)this.guiHelper;
            this.opDetails.setOpcode(0x7010000);
            MR_SAS_PHY_CONNECTIONS mR_SAS_PHY_CONNECTIONS = ((SASAdapter)this.guiHelper.getDeviceObject()).getPhyConnections();
            MR_SAS_PHY_CONNECTION[] mR_SAS_PHY_CONNECTIONArray = mR_SAS_PHY_CONNECTIONS.getphy();
            int n = mR_SAS_PHY_CONNECTIONS.getcount();
            Object[][] objectArray = new Object[n][3];
            JPanel jPanel11 = new JPanel();
            jPanel11.setOpaque(false);
            jPanel11.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel(Resource.getString("PHY_DETAILS", "Phy Details:"));
            gridBagConstraints.anchor = 23;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(5, 10, 10, 0);
            jPanel11.add((Component)jLabel, gridBagConstraints);
            Object[] objectArray3 = new String[]{"SAS Address", "Phy", "Select Link Speed"};
            String[] stringArray6 = new String[5];
            stringArray6[0] = "Auto";
            stringArray6[1] = "1.5Gbps";
            stringArray6[2] = "3.0Gbps";
            stringArray6[3] = "6.0Gbps";
            if (adapterHelper.getAdapterInfo().getdeviceInterface_MR_CTRL_INFO().getSAS_12G() == 1) {
                stringArray6[4] = "12.0Gbps";
            }
            for (int i = 0; i < n; ++i) {
                int n11;
                long l = mR_SAS_PHY_CONNECTIONArray[i].getsasAddr();
                objectArray[i][0] = Long.toHexString(l);
                objectArray[i][1] = i;
                adapterHelper.phySpeed[i][0] = n11 = mR_SAS_PHY_CONNECTIONArray[i].getlinkSpeedControl();
                if (0 == n11) {
                    objectArray[i][2] = stringArray6[0];
                    continue;
                }
                if (1 == n11) {
                    objectArray[i][2] = stringArray6[1];
                    continue;
                }
                if (2 == n11) {
                    objectArray[i][2] = stringArray6[2];
                    continue;
                }
                if (4 == n11) {
                    objectArray[i][2] = stringArray6[3];
                    continue;
                }
                if (8 != n11) continue;
                objectArray[i][2] = stringArray6[4];
            }
            DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray3);
            this.phyTable = new JTable(defaultTableModel){

                @Override
                public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                    Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                    if (n % 2 == 0) {
                        component.setBackground(Color.lightGray);
                        component.setForeground(Color.black);
                    } else {
                        component.setBackground(Color.white);
                        component.setForeground(Color.black);
                    }
                    return component;
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return n2 != 0 && n2 != 1;
                }
            };
            this.phyTable.setShowGrid(false);
            this.phyTable.setShowVerticalLines(true);
            this.phyTable.setCellSelectionEnabled(true);
            this.phyTable.setSurrendersFocusOnKeystroke(true);
            this.phyTable.setShowHorizontalLines(true);
            this.phyTable.setRowMargin(this.phyTable.getRowMargin() + 1);
            TableColumn tableColumn = this.phyTable.getColumnModel().getColumn(2);
            tableColumn.setCellRenderer(new ComboRenderer(stringArray6));
            tableColumn.setCellEditor(new ComboEditor(stringArray6));
            SelectionListener selectionListener = new SelectionListener(this.phyTable);
            this.phyTable.getSelectionModel().addListSelectionListener(selectionListener);
            this.phyTable.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
            TableColumn tableColumn2 = null;
            for (int i = 0; i < 3; ++i) {
                tableColumn2 = this.phyTable.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn2.setPreferredWidth(175);
                    continue;
                }
                if (i != 1) continue;
                tableColumn2.setPreferredWidth(30);
            }
            this.phyTable.setRowHeight(18);
            TableColumn tableColumn3 = this.phyTable.getColumnModel().getColumn(2);
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray6);
            tableColumn3.setCellEditor(new DefaultCellEditor(jComboBox));
            JScrollPane jScrollPane = new JScrollPane(this.phyTable, 20, 31);
            if (VivaldiStartupDialog.isWindows) {
                jScrollPane.setPreferredSize(new Dimension(400, 110));
            } else {
                jScrollPane.setPreferredSize(new Dimension(550, 130));
            }
            jScrollPane.setBackground(ColorHash.getColor("GRAPHICAL_VIEW_UNUSED"));
            gridBagConstraints.anchor = 23;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(10, 15, 10, 0);
            jPanel11.add((Component)jScrollPane, gridBagConstraints);
            this.add((Component)jPanel11, "Center");
        } else if (gUIHelperInterface.getType() == 3 && operationDetails.getOpcode() == 2) {
            JPanel jPanel12 = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel12.setLayout(gridBagLayout);
            jPanel12.setOpaque(false);
            int n = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)gUIHelperInterface.getDeviceObject();
            boolean bl = ((AdapterHelper)gUIHelperInterface.getParent()).getAdapterInfo().getldOperations_MR_CTRL_INFO().isSupportSSCWriteBack();
            MR_LD_PROPERTIES mR_LD_PROPERTIES = sASLogicalDrive.getInformation().getldConfig().getproperties();
            MR_LD_PARAMETERS mR_LD_PARAMETERS = sASLogicalDrive.getInformation().getldConfig().getparams();
            if (mR_LD_PARAMETERS.isSSCD()) {
                this.setPreferredSize(new Dimension(400, 200));
                byte by = ((SASAdapter)sASLogicalDrive.parent()).getAdapterType();
                if (by != 2 && by != 3 && by != 4) {
                    stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_LDNAME_TEXT", "Name : "));
                    JLabel jLabel = new JLabel(stringArray[0]);
                    if (stringArray.length == 2) {
                        jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
                    }
                    jLabel.setFont(font);
                    this.ldName = new JTextField(15);
                    this.ldName.setToolTipText(Resource.getString("LD_NAME_DSC", "Logical Drive Name"));
                    jLabel.setLabelFor(this.ldName);
                    this.ldName.setFont(font);
                    if (!Resource.isLocaleSupportedForOEM()) {
                        this.ldName.setEnabled(false);
                        this.ldName.setText("");
                    } else {
                        this.ldName.addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyTyped(KeyEvent keyEvent) {
                                if (keyEvent.getKeyChar() == '\b') {
                                    return;
                                }
                                if (OperationDetailPanel.this.ldName.getText().length() >= 15) {
                                    keyEvent.consume();
                                }
                            }
                        });
                        if (sASLogicalDrive.getName() != null) {
                            this.ldName.setText(sASLogicalDrive.getName().trim());
                        }
                    }
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.anchor = 13;
                    jPanel12.add((Component)jLabel, gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel12.add((Component)this.ldName, gridBagConstraints);
                    stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_DEFWRITEPOLICY_TEXT", "Default Write Policy : "));
                    JLabel jLabel13 = new JLabel(stringArray[0]);
                    if (stringArray.length == 2) {
                        jLabel13.setDisplayedMnemonic(stringArray[1].charAt(0));
                    }
                    jLabel13.setFont(font);
                    Object[] objectArray = null;
                    LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)gUIHelperInterface;
                    objectArray = !bl ? new Object[]{new GUIData(Resource.getString("CACHECADE_WRITE_THROUGH", "Write Through"), 0)} : (logicalDriveHelper.isCSACacheCade() || mR_LD_PARAMETERS.getPRL() == 0 ? new Object[]{new GUIData(Resource.getString("CACHECADE_WRITE_BACK", "Write Back"), 1), new GUIData(Resource.getString("CACHECADE_WRITE_THROUGH", "Write Through"), 0)} : new Object[]{new GUIData(Resource.getString("CACHECADE_WRITE_BACK", "Write Back"), 1), new GUIData(Resource.getString("CACHECADE_WRITE_THROUGH", "Write Through"), 0), new GUIData(Resource.getString("CACHECADE_ALWAYS_WRITE_BACK", "Always Write Back"), 17)});
                    this.writePolicy = new JComboBox<Object>(objectArray);
                    this.writePolicy.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = ((GUIData)((OperationDetailPanel)OperationDetailPanel.this).writePolicy.getSelectedItem()).flag;
                            String string = null;
                            if (n == 0) {
                                string = Resource.getString("CACHECADE_WRITE_THROUGH_SELECTED_DESC", "<html>Write Through means that the cache can only be used for<br>reads. It will not support any writes.</html>");
                            } else if (n == 17) {
                                string = Resource.getString("CACHECADE_ALWAYS_WRITE_BACK_SELECTED_DESC", "<html>Always Write Back means that the cache can be used for<br>both read and write I/O,even if the CacheCade\u2122 Virtual Drive<br>enters into a degraded state (risking data loss).</html>");
                            } else if (n == 1) {
                                string = ((LogicalDriveHelper)OperationDetailPanel.this.guiHelper).isCSACacheCade() ? Resource.getString("CSA_CACHECADE_WRITE_BACK_SELECTED_DESC", "<html>Write Back means that the cache can be used for both read and <br> write I/O.<br><br>Important: If the Nytro\u2122 Cache drive becomes degraded, <br>the policy may temporarily change to read-only.</html>") : (((SASLogicalDrive)OperationDetailPanel.this.guiHelper.getDeviceObject()).getInformation().getldConfig().getparams().getPRL() == 0 ? Resource.getString("CACHECADE_WRITE_BACK_SELECTED_R0_DESC", "<html>Write Back means that the cache can be used for both<br>read and write I/O.</html>") : Resource.getString("CACHECADE_WRITE_BACK_SELECTED_DESC", "<html>Write Back means that the cache can be used for both<br>read and write I/O.<br><br>Important: If the CacheCade\u2122 Virtual Drive becomes degraded,<br>the policy may temporarily change to read-only.</html>"));
                            }
                            OperationDetailPanel.this.m_cmbBxWritePolicyDesc.setText(string);
                        }
                    });
                    byte by2 = sASLogicalDrive.getDefaultWritePolicy();
                    this.writePolicy.setEnabled(bl);
                    if (!bl) {
                        this.writePolicy.setSelectedIndex(0);
                    } else if (by2 == 1) {
                        this.writePolicy.setSelectedIndex(0);
                    } else if (by2 == 0) {
                        this.writePolicy.setSelectedIndex(1);
                    } else {
                        this.writePolicy.setSelectedIndex(2);
                    }
                    this.writePolicy.setFont(font);
                    this.writePolicy.setToolTipText(Resource.getString("DEFWRITE_POLICY_DSC", "Default Write Policy"));
                    jLabel13.setLabelFor(this.writePolicy);
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n;
                    gridBagConstraints.anchor = 13;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)jLabel13, gridBagConstraints);
                    }
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.anchor = 17;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)this.writePolicy, gridBagConstraints);
                    }
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = ++n;
                    gridBagConstraints.anchor = 13;
                    gridBagConstraints.gridwidth = 2;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)this.m_cmbBxWritePolicyDesc, gridBagConstraints);
                    }
                }
                this.add((Component)jPanel12, "Center");
                if (this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                    this.setPreferredSize(new Dimension(460 * MainFrame.SCREEN_SIZE.width / 1024, 400 * MainFrame.SCREEN_SIZE.height / 1368));
                }
            } else {
                boolean bl2;
                int n12;
                Object object;
                Object object2;
                JLabel jLabel;
                this.setPreferredSize(new Dimension(460 * MainFrame.SCREEN_SIZE.width / 1024, 400 * MainFrame.SCREEN_SIZE.height / 768));
                byte by = ((SASAdapter)sASLogicalDrive.parent()).getAdapterType();
                boolean bl3 = false;
                boolean bl4 = false;
                if (((SASAdapter)sASLogicalDrive.parent()).getInformation().gethwPresent_MR_CTRL_INFO().getmemory() == 0) {
                    bl3 = true;
                }
                if (((AdapterHelper)this.guiHelper.getParent()).isSWRController()) {
                    bl4 = true;
                }
                if (by != 2 && by != 3 && by != 4) {
                    int n13;
                    int n14;
                    stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_LDNAME_TEXT", "Name : "));
                    jLabel = new JLabel(stringArray[0]);
                    if (stringArray.length == 2) {
                        jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
                    }
                    jLabel.setFont(font);
                    this.ldName = new JTextField(15);
                    this.ldName.setToolTipText(Resource.getString("LD_NAME_DSC", "Logical Drive Name"));
                    jLabel.setLabelFor(this.ldName);
                    this.ldName.setFont(font);
                    if (!Resource.isLocaleSupportedForOEM()) {
                        this.ldName.setEnabled(false);
                        this.ldName.setText("");
                    } else {
                        this.ldName.addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyTyped(KeyEvent keyEvent) {
                                if (keyEvent.getKeyChar() == '\b') {
                                    return;
                                }
                                if (OperationDetailPanel.this.ldName.getText().length() >= 15) {
                                    keyEvent.consume();
                                }
                            }
                        });
                        if (sASLogicalDrive.getName() != null) {
                            this.ldName.setText(sASLogicalDrive.getName().trim());
                        }
                    }
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.anchor = 13;
                    jPanel12.add((Component)jLabel, gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel12.add((Component)this.ldName, gridBagConstraints);
                    stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_READPOLICY_TEXT", "Read Policy : "));
                    JLabel jLabel14 = new JLabel(stringArray[0]);
                    if (stringArray.length == 2) {
                        jLabel14.setDisplayedMnemonic(stringArray[1].charAt(0));
                    }
                    jLabel14.setFont(font);
                    if (bl3 && !bl4) {
                        this.readPolicy = new CustomComboBox(new Object[]{new GUIData(Resource.getString("READ_AHEAD_NONE", "No Read Ahead"), 0)});
                        this.readPolicy.setSelectedIndex(0);
                    } else {
                        this.readPolicy = new CustomComboBox(new Object[]{new GUIData(Resource.getString("READ_AHEAD_NONE", "No Read Ahead"), 0), new GUIData(Resource.getString("READ_AHEAD_ALWAYS", "Always Read Ahead"), 4)});
                        byte by3 = sASLogicalDrive.getReadPolicy();
                        for (n14 = 0; n14 < this.readPolicy.getItemCount(); ++n14) {
                            if (((GUIData)this.readPolicy.getItemAt((int)n14)).flag != by3) continue;
                            this.readPolicy.setSelectedIndex(n14);
                            break;
                        }
                    }
                    jLabel14.setLabelFor(this.readPolicy);
                    this.readPolicy.setFont(font);
                    this.readPolicy.setToolTipText(Resource.getString("READ_POLICY_DSC", "Read Policy"));
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n;
                    gridBagConstraints.anchor = 13;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)jLabel14, gridBagConstraints);
                    }
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.anchor = 17;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)this.readPolicy, gridBagConstraints);
                    }
                    ++n;
                    this.bbuPresent = false;
                    try {
                        ((AdapterHelper)this.guiHelper.getParent()).getBBU().getDeviceObject();
                        this.bbuPresent = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_DEFWRITEPOLICY_TEXT", "Default Write Policy : "));
                    object2 = new JLabel(stringArray[0]);
                    if (stringArray.length == 2) {
                        ((JLabel)object2).setDisplayedMnemonic(stringArray[1].charAt(0));
                    }
                    ((JComponent)object2).setFont(font);
                    if (bl4) {
                        this.writePolicy = new JComboBox<Object>(new Object[]{new GUIData(Resource.getString("WRITEPOLICY_WRITE_THROUGH", "Write Through"), 0), new GUIData(Resource.getString("WRITE_BACK", "Write Back"), 17)});
                        n14 = sASLogicalDrive.getWritePolicy();
                        if (n14 == 0) {
                            this.writePolicy.setSelectedIndex(0);
                        } else {
                            this.writePolicy.setSelectedIndex(1);
                        }
                    } else if (bl3) {
                        this.writePolicy = new JComboBox<Object>(new Object[]{new GUIData(Resource.getString("WRITEPOLICY_WRITE_THROUGH", "Write Through"), 0)});
                        this.writePolicy.setSelectedIndex(0);
                    } else {
                        this.writePolicy = new JComboBox<Object>(new Object[]{new GUIData(Resource.getString("WRITEPOLICY_WRITE_THROUGH", "Write Through"), 0), new GUIData(Resource.getString("WRITE_BACK", "Write Back"), 17), new GUIData(Resource.getString("WRITE_BACK_WITH_BBU", "Write Back with BBU"), 1)});
                        n14 = sASLogicalDrive.getDefaultWritePolicy();
                        if (n14 == 0) {
                            this.writePolicy.setSelectedIndex(0);
                        } else if (n14 == 1) {
                            this.writePolicy.setSelectedIndex(2);
                        } else {
                            this.writePolicy.setSelectedIndex(1);
                        }
                    }
                    this.writePolicy.setFont(font);
                    this.writePolicy.setToolTipText(Resource.getString("DEFWRITE_POLICY_DSC", "Default Write Policy"));
                    ((JLabel)object2).setLabelFor(this.writePolicy);
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n;
                    gridBagConstraints.anchor = 13;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)object2, gridBagConstraints);
                    }
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.anchor = 17;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)this.writePolicy, gridBagConstraints);
                    }
                    ++n;
                    ++n;
                    gridBagConstraints.gridwidth = 1;
                    stringArray = Resource.getResourceMnemonic(Resource.getString("PROPERTY_IOPOLICY_TEXT", "IO Policy"));
                    JLabel jLabel15 = new JLabel(stringArray[0] + " : ");
                    if (stringArray.length == 2) {
                        jLabel15.setDisplayedMnemonic(stringArray[1].charAt(0));
                    }
                    jLabel15.setFont(font);
                    if (bl3) {
                        this.cachePolicy = new CustomComboBox(new Object[]{new GUIData(Resource.getString("DIRECT_IO", "Direct IO"), 0)});
                        this.cachePolicy.setSelectedIndex(0);
                    } else {
                        this.cachePolicy = new CustomComboBox(new Object[]{new GUIData(Resource.getString("DIRECT_IO", "Direct IO"), 0), new GUIData(Resource.getString("CACHED_IO", "Cached IO"), 96)});
                        byte by4 = sASLogicalDrive.getIOCachePolicy();
                        for (n13 = 0; n13 < this.cachePolicy.getItemCount(); ++n13) {
                            if (((GUIData)this.cachePolicy.getItemAt((int)n13)).flag != by4) continue;
                            this.cachePolicy.setSelectedIndex(n13);
                            break;
                        }
                    }
                    jLabel15.setLabelFor(this.cachePolicy);
                    this.cachePolicy.setFont(font);
                    this.cachePolicy.setToolTipText(Resource.getString("IO_POLICY_DSC", "IO Policy"));
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n;
                    gridBagConstraints.anchor = 13;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)jLabel15, gridBagConstraints);
                    }
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.anchor = 17;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)this.cachePolicy, gridBagConstraints);
                    }
                    ++n;
                    stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_ACCESSPOLICY_TEXT", "Access Policy : "));
                    object = new JLabel(stringArray[0]);
                    if (stringArray.length == 2) {
                        ((JLabel)object).setDisplayedMnemonic(stringArray[1].charAt(0));
                    }
                    ((JComponent)object).setFont(font);
                    this.accessPolicy = new CustomComboBox(new Object[]{new GUIData(Resource.getString("ACCESS_READ_WRITE", "Read Write"), 0), new GUIData(Resource.getString("ACCESS_READ_ONLY", "Read Only"), 2), new GUIData(Resource.getString("ACCESS_BLOCKED", "Blocked"), 3)});
                    ((JLabel)object).setLabelFor(this.accessPolicy);
                    this.accessPolicy.setFont(font);
                    this.accessPolicy.setToolTipText(Resource.getString("ACCESS_POLICY_DSC", "Access Policy"));
                    n13 = mR_LD_PROPERTIES.getaccessPolicy();
                    for (n12 = 0; n12 < this.accessPolicy.getItemCount(); ++n12) {
                        if (((GUIData)this.accessPolicy.getItemAt((int)n12)).flag != n13) continue;
                        this.accessPolicy.setSelectedIndex(n12);
                        break;
                    }
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n;
                    gridBagConstraints.anchor = 13;
                    n12 = ((LogicalDriveHelper)gUIHelperInterface).isBlockedDueToSSCDOffline() ? 1 : 0;
                    bl2 = ((LogicalDriveHelper)gUIHelperInterface).isBlockedDueToPeerUnavailability();
                    if (!(this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive")) || n12 != 0 && bl2)) {
                        jPanel12.add((Component)object, gridBagConstraints);
                    }
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.anchor = 17;
                    if (!(this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive")) || n12 != 0 && bl2)) {
                        jPanel12.add((Component)this.accessPolicy, gridBagConstraints);
                    }
                    if (n12 == 0 || !bl2) {
                        ++n;
                    }
                }
                if (((AdapterHelper)this.guiHelper.getParent()).getAdapterInfo().getldOperations_MR_CTRL_INFO().getdiskCachePolicy() != 0) {
                    stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_DISKCACHEPOLICY_TEXT", "Disk Cache Policy : "));
                    jLabel = new JLabel(stringArray[0]);
                    if (stringArray.length == 2) {
                        jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
                    }
                    jLabel.setFont(font);
                    this.diskCachePolicy = by == 2 || by == 3 || by == 4 ? new CustomComboBox(new Object[]{new GUIData(Resource.getString("DISK_CACHE_ENABLED", "Enabled"), 1), new GUIData(Resource.getString("DISK_CACHE_DISABLED", "Disabled"), 2)}) : new CustomComboBox(new Object[]{new GUIData(Resource.getString("DISK_CACHE_UNCHANGED", "Unchanged"), 0), new GUIData(Resource.getString("DISK_CACHE_ENABLED", "Enabled"), 1), new GUIData(Resource.getString("DISK_CACHE_DISABLED", "Disabled"), 2)});
                    jLabel.setLabelFor(this.diskCachePolicy);
                    this.diskCachePolicy.setFont(font);
                    this.diskCachePolicy.setToolTipText(Resource.getString("DISKCACHE_POLICY_DSC", "Disk Cache Policy : "));
                    char c = mR_LD_PROPERTIES.getdiskCachePolicy();
                    for (int i = 0; i < this.diskCachePolicy.getItemCount(); ++i) {
                        if (((GUIData)this.diskCachePolicy.getItemAt((int)i)).flag != c) continue;
                        this.diskCachePolicy.setSelectedIndex(i);
                        break;
                    }
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n;
                    gridBagConstraints.anchor = 13;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)jLabel, gridBagConstraints);
                    }
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.anchor = 17;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)this.diskCachePolicy, gridBagConstraints);
                    }
                    object2 = this.guiHelper.getDeviceObject();
                    if (this.isVDCompriseOfSSDDrives(sASLogicalDrive) && ((AdapterHelper)this.guiHelper.getParent()).getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getBlockSSDWriteCacheChange() == 1) {
                        this.diskCachePolicy.setSelectedIndex(0);
                        this.diskCachePolicy.setEnabled(false);
                    }
                    ++n;
                }
                if (by != 2 && by != 3 && by != 4) {
                    stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_BACKGROUNDINIT_TEXT", "Background Initialization :"));
                    jLabel = new JLabel(stringArray[0]);
                    if (stringArray.length == 2) {
                        jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
                    }
                    jLabel.setFont(font);
                    byte by5 = sASLogicalDrive.getInformation().getldConfig().getparams().getPRL();
                    this.bgInit = bl4 && by5 != 5 ? new CustomComboBox(new Object[]{new GUIData(Resource.getString("BGINIT_DISABLE", "Disabled"), 1)}) : new CustomComboBox(new Object[]{new GUIData(Resource.getString("BGINIT_DISABLE", "Disabled"), 1), new GUIData(Resource.getString("DISK_CACHE_ENABLED", "Enabled"), 0)});
                    jLabel.setLabelFor(this.bgInit);
                    this.bgInit.setFont(font);
                    this.bgInit.setToolTipText(Resource.getString("BACK_GROUNDINIT_DSC", "Background Initialization"));
                    char c = mR_LD_PROPERTIES.getnoBGI();
                    for (int i = 0; i < this.bgInit.getItemCount(); ++i) {
                        if (((GUIData)this.bgInit.getItemAt((int)i)).flag != c) continue;
                        this.bgInit.setSelectedIndex(i);
                        break;
                    }
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n;
                    gridBagConstraints.anchor = 13;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)jLabel, gridBagConstraints);
                    }
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.anchor = 17;
                    if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                        jPanel12.add((Component)this.bgInit, gridBagConstraints);
                    }
                    ++n;
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    gridBagConstraints.anchor = 13;
                    LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)gUIHelperInterface;
                    object = (SASLogicalDrive)gUIHelperInterface.getDeviceObject();
                    SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)object).getLDAllowedOps();
                    if (((SASAdapter)sASLogicalDrive.parent()).getInformation().getmaxHANodes() > 1 && sASLogicalDriveOperationsAllowed.isEnableHAShare()) {
                        m_exposetoOS = new JCheckBox();
                        n12 = mR_LD_PROPERTIES.getnonShared();
                        bl2 = false;
                        bl2 = n12 != 1;
                        m_exposetoOS.setSelected(bl2);
                        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_EXPOSE_VD_TO_OS", "Provide (S)hared Access"));
                        m_exposetoOS.setText(stringArray[0]);
                        if (stringArray.length == 2) {
                            m_exposetoOS.setMnemonic(stringArray[1].charAt(0));
                        }
                        if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                            jPanel12.add((Component)m_exposetoOS, gridBagConstraints);
                        }
                    }
                }
                this.add((Component)jPanel12, "Center");
                if (this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                    this.setPreferredSize(new Dimension(460 * MainFrame.SCREEN_SIZE.width / 1024, 400 * MainFrame.SCREEN_SIZE.height / 1368));
                }
            }
        } else if (gUIHelperInterface.getType() == 3 && operationDetails.getOpcode() == 9) {
            Object object;
            boolean bl = true;
            stringArray = Resource.getResourceMnemonic(Resource.getString("CHECKBOX_FASTINIT_TEXT", "Fast Initialization"));
            LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)gUIHelperInterface;
            try {
                object = (SASLogicalDrive)gUIHelperInterface.getDeviceObject();
                SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)object).getAllAllowedOperations();
                if (sASLogicalDriveOperationsAllowed.canfullFGDisallow()) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception in isfullFGDisallowed");
            }
            this.quickInit = new JCheckBox(stringArray[0]);
            if (stringArray.length == 2) {
                this.quickInit.setMnemonic(stringArray[1].charAt(0));
            }
            this.quickInit.setFont(font);
            this.quickInit.setToolTipText(Resource.getString("CHECKBOX_FASTINIT_DSC", "Fast Initialization"));
            this.quickInit.setOpaque(false);
            if (!bl) {
                this.quickInit.setSelected(true);
                this.quickInit.setEnabled(false);
                this.quickInit.setForeground(Color.BLACK);
            }
            object = new JPanel();
            ((Container)object).add(this.quickInit);
            ((JComponent)object).setOpaque(false);
            this.add((Component)object);
            this.setPreferredSize(new Dimension(460 * MainFrame.SCREEN_SIZE.width / 1024, 120 * MainFrame.SCREEN_SIZE.height / 768));
        } else if (gUIHelperInterface.getType() == 2 && operationDetails.getOpcode() == 3) {
            PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)this.guiHelper;
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelper.getDeviceObject();
            int n = ((SASAdapter)sASPhysicalDrive.parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixSSDHDDInLD();
            int n15 = ((SASAdapter)sASPhysicalDrive.parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixInLD();
            int n16 = ((SASAdapter)sASPhysicalDrive.parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowSSDMixInLD();
            AdapterHelper adapterHelper = (AdapterHelper)this.guiHelper.getParent();
            ArrayHelper[] arrayHelperArray = adapterHelper.getArrays();
            boolean bl = false;
            Vector<ArrayHelper> vector = new Vector<ArrayHelper>();
            for (int n17 = 0; n17 < arrayHelperArray.length; n17 = (int)((short)(n17 + 1))) {
                if (!((SASArray)arrayHelperArray[n17].getDeviceObject()).checkForMissingPhysicalDrive() || sASPhysicalDrive.getSize() < arrayHelperArray[n17].getDeviceObject().getSize()) continue;
                bl = true;
                if (arrayHelperArray[n17].isArrayEncrypted() && arrayHelperArray[n17].isFDEOnlyDriveGroup() && !physicalDriveHelper.isFDECapable()) {
                    bl = false;
                }
                if (bl) {
                    PhysicalDriveHelper[] physicalDriveHelperArray = arrayHelperArray[n17].getPhysicalDrives();
                    for (int n18 = 0; n18 < physicalDriveHelperArray.length; n18 = (int)((short)(n18 + 1))) {
                        SASPhysicalDrive sASPhysicalDrive2 = (SASPhysicalDrive)physicalDriveHelperArray[n18].getDeviceObject();
                        if (sASPhysicalDrive2.getInformation().getUserDataBlockSize() != sASPhysicalDrive.getInformation().getUserDataBlockSize()) {
                            bl = false;
                            break;
                        }
                        if (sASPhysicalDrive2.getMediatype() == 0 && sASPhysicalDrive.getMediatype() == 0) {
                            if (n15 != 0 || sASPhysicalDrive2.getDriveType() == sASPhysicalDrive.getDriveType()) continue;
                            bl = false;
                            break;
                        }
                        if (sASPhysicalDrive2.getMediatype() == 0 && sASPhysicalDrive.getMediatype() == 1) {
                            if (n != 0) continue;
                            bl = false;
                            break;
                        }
                        if (sASPhysicalDrive2.getMediatype() == 1 && sASPhysicalDrive.getMediatype() == 0) {
                            if (n != 0) continue;
                            bl = false;
                            break;
                        }
                        if (sASPhysicalDrive2.getMediatype() != 1 || sASPhysicalDrive.getMediatype() != 1) continue;
                        if (arrayHelperArray[n17].isSSCD() && physicalDriveHelper.isIneligibleForSSCD()) {
                            bl = false;
                            break;
                        }
                        if (n16 != 0 || sASPhysicalDrive2.getDriveType() == sASPhysicalDrive.getDriveType()) continue;
                        bl = false;
                        break;
                    }
                }
                if (!bl) continue;
                vector.add(arrayHelperArray[n17]);
            }
            this.arrayCmb = new CustomComboBox((Vector)vector);
            this.arrayCmb.setFont(font);
            this.arrayCmb.setToolTipText(Resource.getString("ARRAY_LIST_DSC", "Array List"));
            this.phDriveCmb = new CustomComboBox();
            this.phDriveCmb.setFont(font);
            this.phDriveCmb.setToolTipText(Resource.getString("PHYSICAL_DRIVE_DSC", "PHYSICAL DRIVE"));
            this.arrayCmb.setSelectedIndex(-1);
            this.arrayCmb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ArrayHelper arrayHelper = (ArrayHelper)OperationDetailPanel.this.arrayCmb.getSelectedItem();
                    OperationDetailPanel.this.phDriveCmb.removeAllItems();
                    PhysicalDriveHelper[] physicalDriveHelperArray = arrayHelper.getPhysicalDrivesforMissingDrives();
                    for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                        if (physicalDriveHelperArray[i] != null) continue;
                        OperationDetailPanel.this.phDriveCmb.addItem(new GUIData(Resource.getString("TEXT_ARRAY_ROW", "Row Index ") + i, i));
                    }
                    if (OperationDetailPanel.this.phDriveCmb.getItemCount() > 0) {
                        OperationDetailPanel.this.phDriveCmb.setSelectedIndex(0);
                    }
                }
            });
            if (this.arrayCmb.getItemCount() > 0) {
                this.arrayCmb.setSelectedIndex(0);
            }
            JPanel jPanel13 = new JPanel();
            jPanel13.setOpaque(false);
            jPanel13.add(this.arrayCmb);
            jPanel13.add(this.phDriveCmb);
            this.setPreferredSize(new Dimension(500 * MainFrame.SCREEN_SIZE.width / 1024, 150 * MainFrame.SCREEN_SIZE.height / 768));
            this.add((Component)jPanel13, "Center");
        } else if (gUIHelperInterface.getType() == 2 && operationDetails.getOpcode() == 21) {
            this.m_driveGroupsList = new JList((Vector)operationDetails.getParam());
            this.m_driveGroupsList.setVisibleRowCount(5);
            this.m_driveGroupsList.setSelectionMode(2);
            class ArrayListRenderer
            extends DefaultListCellRenderer {
                ArrayListRenderer() {
                }

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    ArrayHelper arrayHelper = (ArrayHelper)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (arrayHelper.getSpanDepth() > 1) {
                        stringBuffer.append(Resource.getString("SPANNED_DRIVE_GROUP_TEXT", "Spanned Drive Group"));
                        stringBuffer.append(" ");
                        stringBuffer.append(arrayHelper.getParentIDForSpan());
                        stringBuffer.append(": ");
                        stringBuffer.append(arrayHelper.getText(false));
                    } else {
                        stringBuffer.append(Resource.getString("LABEL_DRIVE_GROUP", "Drive Group:"));
                        stringBuffer.append(" " + arrayHelper.getDeviceObject().getID());
                    }
                    JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    jLabel.setText(stringBuffer.toString());
                    return jLabel;
                }
            }
            this.m_driveGroupsList.setCellRenderer(new ArrayListRenderer());
            String[] stringArray7 = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_DRIVE_GROUPS"));
            JLabel jLabel = new JLabel(stringArray7[0]);
            if (stringArray7.length == 2) {
                jLabel.setDisplayedMnemonic(stringArray7[1].charAt(0));
            }
            jLabel.setLabelFor(this.m_driveGroupsList);
            JPanel jPanel14 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 0, 1, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            jPanel14.add((Component)new JLabel(Resource.getString("DEDICATED_HSP_DESC")), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            jPanel14.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets.bottom = 10;
            gridBagConstraints.gridy = 2;
            JScrollPane jScrollPane = new JScrollPane(this.m_driveGroupsList, 20, 31);
            jPanel14.add((Component)jScrollPane, gridBagConstraints);
            jPanel14.setOpaque(false);
            this.add((Component)jPanel14, "Center");
        } else if (gUIHelperInterface.getType() == 2 && operationDetails.getOpcode() == 34275584) {
            PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)gUIHelperInterface;
            JPanel jPanel15 = new JPanel();
            jPanel15.setOpaque(false);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel15.setLayout(gridBagLayout);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 17;
            JLabel jLabel = new JLabel(Resource.getString("SELECT_REPLACE", "Select Replacement:"));
            jPanel15.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.vecPhysicalDrives = physicalDriveHelper.getEligibleCopyBackDrives();
            if (this.vecPhysicalDrives != null && this.vecPhysicalDrives.size() > 0) {
                Vector<String> vector = new Vector<String>();
                for (int i = 0; i < this.vecPhysicalDrives.size(); ++i) {
                    PhysicalDriveHelper physicalDriveHelper2 = (PhysicalDriveHelper)this.vecPhysicalDrives.get(i);
                    vector.add(physicalDriveHelper2.getCopyBackPDText());
                }
                this.physicalDrivesList = new JList(vector);
                this.physicalDrivesList.setSelectedIndex(0);
                this.physicalDrivesList.setVisibleRowCount(10);
                this.physicalDrivesList.getSelectionModel().setSelectionMode(0);
                jPanel15.add((Component)new JScrollPane(this.physicalDrivesList, 20, 31), gridBagConstraints);
                this.add((Component)jPanel15, "West");
            }
        } else if (gUIHelperInterface.getType() == 1 && operationDetails.getOpcode() == 0x1150000) {
            this.m_changeEncypSettingsPanel = new ChangeEncyptionSettingsPanel((AdapterHelper)gUIHelperInterface);
            this.add((Component)this.m_changeEncypSettingsPanel, "West");
        } else if (gUIHelperInterface.getType() == 1 && operationDetails.getOpcode() == 40) {
            this.propold = ((AdapterHelper)gUIHelperInterface).getAdapterProperties();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReady() {
        if (this.guiHelper.getType() == 1 && this.opDetails.getOpcode() == 3) {
            File file = new File(this.fwFileName.getText());
            boolean bl = true;
            if (file.exists()) {
                Object object;
                String string = Resource.getString("CONTOLLER_FIRMWARE", "controller firmware");
                String string2 = "0";
                if (file.isFile()) {
                    object = (SASAdapter)this.guiHelper.getDeviceObject();
                    if (((SASAdapter)object).getAdapterType() == 1) {
                        if (file.getPath().toUpperCase().endsWith(".ROM")) {
                            bl = false;
                        }
                    } else if (((SASAdapter)object).getAdapterType() == 2 || ((SASAdapter)object).getAdapterType() == 3 || ((SASAdapter)object).getAdapterType() == 4) {
                        if (((SASAdapter)object).isWarhawk()) {
                            bl = false;
                        } else if (this.objControllerFirmware.isSelected()) {
                            bl = false;
                        } else if (this.objBIOS.isSelected()) {
                            string = Resource.getString("BIOS_TEXT", "BIOS");
                            string2 = "1";
                            if (file.getPath().toUpperCase().endsWith(".ROM")) {
                                bl = false;
                            }
                        } else if (this.objEFIBSD.isSelected()) {
                            string = Resource.getString("EFI_BSD_TEXT", "EFI-BSD");
                            string2 = "3";
                            if (file.getPath().toUpperCase().endsWith(".ROM")) {
                                bl = false;
                            }
                        } else if (this.objFCODE.isSelected()) {
                            string = Resource.getString("FCODE_TEXT", "FCODE");
                            string2 = "2";
                            if (file.getPath().toUpperCase().endsWith(".ROM")) {
                                bl = false;
                            }
                        }
                    }
                }
                if (bl) {
                    new CustomMsgBox(this, Resource.getString("NO_FIRMWARE_FILE1", "The specified file is not a valid ") + string + Resource.getString("NO_FIRMWARE_FILE2", "file. Please check the file path and try again."));
                    return false;
                }
                if (file.length() / 1024L >= 16384L) {
                    new CustomMsgBox(Resource.getString("16MB_FLASH_IMAGE_CAPACITY_EXCEEDED", "<html>This file exceeds the 16 MB size limit. <br><br>Please select a firmware image with size less than 16 MB.<br><br></html>"));
                    return false;
                }
                object = string2 + this.fwFileName.getText();
                this.opDetails.setParameter(object);
                return true;
            }
            new CustomMsgBox(this, Resource.getString("FIRMWARE_FILE_NOT_FOUND", "The specified file could not be found. \n Please check the file path and try again."));
            return false;
        }
        if (this.guiHelper.getType() == 1 && this.opDetails.getOpcode() == 2) {
            try {
                MR_CTRL_PROP mR_CTRL_PROP = new MR_CTRL_PROP(this.propold.getByteArray(), 0);
                if (this.rebuildRate != null) {
                    mR_CTRL_PROP.setrebuildRate((char)((Integer)this.rebuildRate.getValue()).intValue());
                }
                if (this.bgiRate != null) {
                    mR_CTRL_PROP.setbgiRate((char)((Integer)this.bgiRate.getValue()).intValue());
                }
                if (this.ccRate != null) {
                    mR_CTRL_PROP.setccRate((char)((Integer)this.ccRate.getValue()).intValue());
                }
                if (this.prRate != null) {
                    mR_CTRL_PROP.setpatrolReadRate((char)((Integer)this.prRate.getValue()).intValue());
                }
                if (this.reconRate != null) {
                    mR_CTRL_PROP.setreconRate((char)((Integer)this.reconRate.getValue()).intValue());
                }
                this.opDetails.setParameter(mR_CTRL_PROP);
                this.opDetails.setBatchOperation(true);
                return true;
            }
            catch (Exception exception) {
                new CustomMsgBox(Resource.getString("MSG_INVALID_INPUT", "Invalid input specified !"));
                return false;
            }
        }
        if (this.guiHelper.getType() == 1 && this.opDetails.getOpcode() == 0x7010000) {
            AdapterHelper adapterHelper = (AdapterHelper)this.guiHelper;
            for (int i = 0; i < 8; ++i) {
                adapterHelper.phySpeed[i][1] = this.getSelectedSpeedFromJtable(i);
            }
            return true;
        }
        if (this.guiHelper.getType() == 1 && this.opDetails.getOpcode() == 16) {
            try {
                if (!this.guiHelper.isOperationAllowed(15)) return true;
                this.opDetails.setOpcode(15);
                this.guiHelper.issueOperation(this.opDetails);
                MR_PR_PROPERTIES mR_PR_PROPERTIES = (MR_PR_PROPERTIES)this.opDetails.getParam();
                this.opDetails.setOpcode(16);
                mR_PR_PROPERTIES.setopMode((char)this.opMode.getSelectedIndex());
                mR_PR_PROPERTIES.setmaxPD((char)((Integer)this.maxPD.getValue()).byteValue());
                if (this.listPanel != null) {
                    Object[] objectArray = this.listPanel.getSelectedObjects();
                    mR_PR_PROPERTIES.setexcludeLdCount((char)objectArray.length);
                    short[] sArray = new short[objectArray.length];
                    for (int i = 0; i < sArray.length; ++i) {
                        sArray[i] = ((LogicalDriveHelper)objectArray[i]).getDeviceObject().getID();
                    }
                    mR_PR_PROPERTIES.setexcludedLD(sArray);
                }
                if (this.freqContinuous.isSelected()) {
                    mR_PR_PROPERTIES.setexecFreq(-1);
                } else {
                    if ((Integer)this.freqHour.getValue() == 0 && (Integer)this.freqMin.getValue() == 0 && (Integer)this.freqSec.getValue() == 0) {
                        new CustomMsgBox(VivaldiStartupDialog.mainScreen, Resource.getString("MSG_EXECUTION_FRE_NOZERO_VAL", "Execution frequency can't be zero second!"));
                        return false;
                    }
                    mR_PR_PROPERTIES.setexecFreq((Integer)this.freqHour.getValue() * 3600 + (Integer)this.freqMin.getValue() * 60 + (Integer)this.freqSec.getValue());
                }
                this.opDetails.setParameter(mR_PR_PROPERTIES);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.guiHelper.getType() == 1 && this.opDetails.getOpcode() == 18088704) {
            boolean bl = false;
            try {
                boolean bl2;
                MR_CC_SCHEDULE_PROPERTIES mR_CC_SCHEDULE_PROPERTIES = ((SASAdapter)this.guiHelper.getDeviceObject()).getCCSchProperties();
                this.opDetails.setOpcode(18088704);
                if (this.ccContinuous.isSelected()) {
                    mR_CC_SCHEDULE_PROPERTIES.setexecFreq(-1);
                } else {
                    switch (this.ccOption.getSelectedIndex()) {
                        case 0: {
                            mR_CC_SCHEDULE_PROPERTIES.setexecFreq(3600);
                            break;
                        }
                        case 1: {
                            mR_CC_SCHEDULE_PROPERTIES.setexecFreq(86400);
                            break;
                        }
                        case 2: {
                            mR_CC_SCHEDULE_PROPERTIES.setexecFreq(604800);
                            break;
                        }
                        case 3: {
                            mR_CC_SCHEDULE_PROPERTIES.setexecFreq(2592000);
                            break;
                        }
                        case 4: {
                            mR_CC_SCHEDULE_PROPERTIES.setopMode((byte)0);
                            bl = true;
                            ScheduleCCAdvanced.setMode(mR_CC_SCHEDULE_PROPERTIES.getopMode());
                        }
                    }
                }
                int n = this.ccMonth.getSelectedIndex();
                int n2 = this.ccDay.getSelectedIndex() + 1;
                String string = this.ccYear.getSelectedItem().toString();
                String string3 = this.ccTime.getSelectedItem().toString();
                int n3 = new Integer(string);
                int n4 = new Integer(string3.substring(0, 2));
                boolean bl3 = bl2 = this.ccTime.getSelectedIndex() > 11;
                if (bl2 && n4 != 12) {
                    n4 += 12;
                }
                if (!bl2 && n4 == 12) {
                    n4 -= 12;
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                if (!bl) {
                    if (gregorianCalendar.get(1) == n3) {
                        if (n < gregorianCalendar.get(2)) {
                            new CustomMsgBox((Component)this, (Object)Resource.getString("MSG_CCSCHEDULE_DATE", "The specified date occurs in the past"), 1);
                            return false;
                        }
                        if (n == gregorianCalendar.get(2) && n2 < gregorianCalendar.get(5)) {
                            new CustomMsgBox((Component)this, (Object)Resource.getString("MSG_CCSCHEDULE_DATE", "The specified date occurs in the past"), 1);
                            return false;
                        }
                        if (n == gregorianCalendar.get(2) && n2 == gregorianCalendar.get(5) && n4 <= gregorianCalendar.get(11)) {
                            new CustomMsgBox((Component)this, (Object)Resource.getString("MSG_CCSCHEDULE_DATE", "The specified date occurs in the past"), 1);
                            return false;
                        }
                    }
                    gregorianCalendar.set(1, n3);
                    gregorianCalendar.set(2, n);
                    gregorianCalendar.set(5, n2);
                    gregorianCalendar.set(11, n4);
                    gregorianCalendar.set(12, 0);
                    gregorianCalendar.set(13, 0);
                    GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
                    TimeZone timeZone = TimeZone.getDefault();
                    Date date = gregorianCalendar.getTime();
                    long l = gregorianCalendar2.getTimeInMillis() / 1000L;
                    long l2 = gregorianCalendar.getTimeInMillis() / 1000L;
                    boolean bl4 = timeZone.inDaylightTime(date);
                    if (bl4) {
                        int n5 = timeZone.getDSTSavings();
                        mR_CC_SCHEDULE_PROPERTIES.setnextExec((int)(l2 - l + (long)(n5 / 1000)));
                    } else {
                        mR_CC_SCHEDULE_PROPERTIES.setnextExec((int)(l2 - l));
                    }
                    mR_CC_SCHEDULE_PROPERTIES.setexcludeLdCount(ScheduleCCAdvanced.getexcludedLDCount());
                    mR_CC_SCHEDULE_PROPERTIES.setexcludedLD(ScheduleCCAdvanced.getexcluded());
                    if (ScheduleCCAdvanced.getOpMode() == 0) {
                        ScheduleCCAdvanced.setMode((byte)2);
                    }
                    mR_CC_SCHEDULE_PROPERTIES.setopMode(ScheduleCCAdvanced.getOpMode());
                }
                this.opDetails.setParameter(mR_CC_SCHEDULE_PROPERTIES);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.guiHelper.getType() == 3 && this.opDetails.getOpcode() == 2) {
            int n;
            SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.guiHelper.getDeviceObject();
            MR_LD_PARAMETERS mR_LD_PARAMETERS = sASLogicalDrive.getInformation().getldConfig().getparams();
            MR_LD_PROPERTIES mR_LD_PROPERTIES = sASLogicalDrive.getInformation().getldConfig().getproperties();
            if (((AdapterHelper)this.guiHelper.getParent()).isCSA() && mR_LD_PARAMETERS.isSSCD()) {
                if (this.ldName.getText().length() > 15) {
                    new CustomMsgBox(this, Resource.getString("CSA_MSG_BIG_LD_NAME"));
                    return false;
                }
                mR_LD_PROPERTIES.setname(this.ldName.getText().getBytes());
                int n6 = ((GUIData)this.writePolicy.getSelectedItem()).flag;
                if (((SASLogicalDrive)this.guiHelper.getDeviceObject()).getDefaultWritePolicy() != n6) {
                    String string = null;
                    String string4 = null;
                    if (mR_LD_PARAMETERS.getPRL() == 0 && n6 == 1) {
                        string = Resource.getString("TITLE_CSA_CACHECADE_WRITE_BACK_SELECTED");
                        string4 = Resource.getString("CSA_CACHECADE_WRITE_BACK_SELECTED_WARNING");
                        if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive")) && JOptionPane.showConfirmDialog(null, string4, string, 0, 2) == 1) {
                            return false;
                        }
                    }
                }
                byte by = sASLogicalDrive.getReadPolicy();
                byte by2 = sASLogicalDrive.getIOCachePolicy();
                byte by3 = (byte)(by | n6 | by2);
                mR_LD_PROPERTIES.setdefaultCachePolicy((char)by3);
                this.opDetails.setParameter(mR_LD_PROPERTIES);
                return true;
            }
            if (mR_LD_PARAMETERS.isSSCD()) {
                if (this.ldName.getText().length() > 15) {
                    new CustomMsgBox(this, Resource.getString("MSG_BIG_LDNAME", "Virtual Disk Name is too big !"));
                    return false;
                }
                mR_LD_PROPERTIES.setname(this.ldName.getText().getBytes());
                int n7 = ((GUIData)this.writePolicy.getSelectedItem()).flag;
                if (((SASLogicalDrive)this.guiHelper.getDeviceObject()).getDefaultWritePolicy() != n7) {
                    String string = null;
                    String string5 = null;
                    if (n7 == 17) {
                        string = Resource.getString("TITLE_CACHECADE_ALWAYS_WRITE_BACK_SELECTED", "Always Write Back Selected");
                        string5 = Resource.getString("CACHECADE_ALWAYS_WRITE_BACK_SELECTED_WARNING", "<html>Always Write Back means that the cache can be used for both read and write I/O,<br>even if the CacheCade\u2122 Virtual Drive enters into a degraded state (risking data loss).<br><br>Are you sure you want to select Always Write Back mode?<br><br></html>");
                        if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive")) && JOptionPane.showConfirmDialog(null, string5, string, 0, 2) == 1) {
                            return false;
                        }
                    } else if (mR_LD_PARAMETERS.getPRL() == 0 && n7 == 1) {
                        string = Resource.getString("TITLE_CACHECADE_WRITE_BACK_SELECTED", "Write Back Selected");
                        string5 = Resource.getString("CACHECADE_WRITE_BACK_SELECTED_WARNING", "<html>Selecting Write Back policy for RAID 0 CacheCade\u2122 SSD-Caching Virtual Drive,<br>may result in data loss, if any of the participating SSD drives fail.<br><br>Are you sure you want to proceed?<br><br></html>");
                        if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive")) && JOptionPane.showConfirmDialog(null, string5, string, 0, 2) == 1) {
                            return false;
                        }
                    }
                }
                byte by = sASLogicalDrive.getReadPolicy();
                byte by4 = sASLogicalDrive.getIOCachePolicy();
                byte by5 = (byte)(by | n7 | by4);
                mR_LD_PROPERTIES.setdefaultCachePolicy((char)by5);
                this.opDetails.setParameter(mR_LD_PROPERTIES);
                return true;
            }
            SASAdapter sASAdapter = (SASAdapter)sASLogicalDrive.parent();
            MR_LD_PROPERTIES mR_LD_PROPERTIES2 = new MR_LD_PROPERTIES(mR_LD_PROPERTIES.getByteArray(), 0);
            if (sASAdapter.getAdapterType() == 2 || sASAdapter.getAdapterType() == 3 || sASAdapter.getAdapterType() == 4) {
                int n8 = ((GUIData)this.diskCachePolicy.getSelectedItem()).flag;
                if (n8 == 1 && !CustomMsgBox.confirm(Resource.getString("MSG_WRITE_CACHE_ENABLE_WARNING", "<html>You have elected to enable caching for the virtual disk. Data may<br>be lost or corrupted in the event of a sudden power lost when<br>caching is enabled on a volume with mirroring properties.<br>Are you sure you want to enable caching?</html>"))) {
                    return false;
                }
                mR_LD_PROPERTIES2.setdiskCachePolicy((char)n8);
                this.opDetails.setParameter(mR_LD_PROPERTIES2);
                return true;
            }
            if (this.ldName.getText().length() > 15) {
                new CustomMsgBox(this, Resource.getString("MSG_BIG_LDNAME", "Virtual Disk Name is too big !"));
                return false;
            }
            mR_LD_PROPERTIES2.setname(this.ldName.getText().getBytes());
            int n9 = ((GUIData)this.readPolicy.getSelectedItem()).flag;
            int n10 = ((GUIData)this.writePolicy.getSelectedItem()).flag;
            if (((SASLogicalDrive)this.guiHelper.getDeviceObject()).getDefaultWritePolicy() != n10) {
                String string = null;
                String string6 = null;
                if (n10 == 0) {
                    string = Resource.getString("TITLE_WRITE_THROUGH_SELECTED", "Write Through Selected");
                    string6 = Resource.getString("WRITE_THROUGH_SELECTED_DESC", "<html>Write Through mode eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Are you sure you want to select Write Through mode? <br><br></html>");
                } else if (n10 == 17) {
                    string = Resource.getString("TITLE_ALWAYS_WRITE_BACK_SELECTED", "Always Write Back Selected");
                    string6 = Resource.getString("ALWAYS_WRITE_BACK_SELECTED_DESC", "<html>Always Write Back mode provides optimal performance, but data loss will <br>occur if there is a power failure and no cache battery installed or the battery <br>is failed or discharged.<br><br>Are you sure you want to select Always Write Back mode? <br><br></html>");
                } else if (n10 == 1) {
                    string = Resource.getString("TITLE_WRITE_BACK_WITH_BBU_SELECTED", "Write Back with BBU Selected");
                    string6 = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_DESC", "<html>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance. <br><br>However, slower performance should be expected when BBU is not <br>installed,not fully charged, or running through re-learn cycle.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                    if (sASAdapter.getInformation().gethwPresent_MR_CTRL_INFO().getbbu() == 0) {
                        string6 = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_NO_OR_BAD_BATTERY_DESC", "<html>You have selected Write Back with BBU.<br><br>Write policy will switch to Write Through due to one of the following reasons: <br>1. Battery is not installed<br><br>2. Battery charge is low.<br><br>3. Battery has failed.<br><br>4. Battery is undergoing re-learn cycle.<br><br>Write Through eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                    } else {
                        Object object;
                        int n11;
                        MR_BBU_FW_STATUS mR_BBU_FW_STATUS = null;
                        n = 5;
                        try {
                            n = sASAdapter.getBBUObject().getInformation().getStatus().getbatteryType();
                            mR_BBU_FW_STATUS = sASAdapter.getBBUObject().getStatus().getMrbbufwStatus();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (mR_BBU_FW_STATUS != null) {
                            if (mR_BBU_FW_STATUS.getreplacePack() || mR_BBU_FW_STATUS.getremainingCapacityLow()) {
                                string6 = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_NO_OR_BAD_BATTERY_DESC", "<html>You have selected Write Back with BBU.<br><br>Write policy will switch to Write Through due to one of the following reasons: <br>1. Battery is not installed<br><br>2. Battery charge is low.<br><br>3. Battery has failed.<br><br>4. Battery is undergoing re-learn cycle.<br><br>Write Through eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                            } else if (n == 1 && (mR_BBU_FW_STATUS.getlearnCycleRequested() || mR_BBU_FW_STATUS.getlearnCycleActive() || mR_BBU_FW_STATUS.getdischargeActive())) {
                                string6 = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_NO_OR_BAD_BATTERY_DESC", "<html>You have selected Write Back with BBU.<br><br>Write policy will switch to Write Through due to one of the following reasons: <br>1. Battery is not installed<br><br>2. Battery charge is low.<br><br>3. Battery has failed.<br><br>4. Battery is undergoing re-learn cycle.<br><br>Write Through eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                            }
                        }
                        LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.guiHelper.getParent()).getLogicalDrives();
                        for (n11 = 0; n11 < logicalDriveHelperArray.length; ++n11) {
                            object = (SASLogicalDrive)logicalDriveHelperArray[n11].getDeviceObject();
                            if (!((SASLogicalDrive)object).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon()) continue;
                            string6 = Resource.getString("RECONSTRUCTION_IN_PROGRESS", "<html>You cannot change the properties of a virtual drive. Reconstruction is<br>in progress<br><br></html>");
                            break;
                        }
                        if (n11 < logicalDriveHelperArray.length && !this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive"))) {
                            object = UIManager.getIcon("OptionPane.warningIcon");
                            JOptionPane.showMessageDialog(null, string6, string, 0, (Icon)object);
                            return false;
                        }
                    }
                }
                if (!this.opDetails.getName().equalsIgnoreCase(Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive")) && JOptionPane.showConfirmDialog(null, string6, string, 0, 2) == 1) {
                    return false;
                }
            }
            int n12 = ((GUIData)this.cachePolicy.getSelectedItem()).flag;
            byte by = (byte)(n9 | n10 | n12);
            mR_LD_PROPERTIES2.setdefaultCachePolicy((char)by);
            int n13 = ((GUIData)this.accessPolicy.getSelectedItem()).flag;
            mR_LD_PROPERTIES2.setaccessPolicy((char)n13);
            if (this.diskCachePolicy != null) {
                n = ((GUIData)this.diskCachePolicy.getSelectedItem()).flag;
                mR_LD_PROPERTIES2.setdiskCachePolicy((char)n);
            }
            n = ((GUIData)this.bgInit.getSelectedItem()).flag;
            mR_LD_PROPERTIES2.setnoBGI((char)n);
            this.opDetails.setParameter(mR_LD_PROPERTIES2);
            if (m_exposetoOS == null) return true;
            if (m_exposetoOS.isSelected()) {
                mR_LD_PROPERTIES2.setnonShared((byte)0);
                this.opDetails.setParameter(mR_LD_PROPERTIES2);
                return true;
            } else {
                mR_LD_PROPERTIES2.setnonShared((byte)1);
                this.opDetails.setParameter(mR_LD_PROPERTIES2);
            }
            return true;
        }
        if (this.guiHelper.getType() == 3 && this.opDetails.getOpcode() == 9) {
            this.opDetails.setParameter(new Boolean(!this.quickInit.isSelected()));
            return true;
        } else {
            if (this.guiHelper.getType() == 2 && this.opDetails.getOpcode() == 3) {
                if (this.arrayCmb.getSelectedIndex() >= 0 && this.phDriveCmb.getSelectedIndex() >= 0) {
                    ArrayList<Byte> arrayList = new ArrayList<Byte>();
                    arrayList.add(new Byte((byte)((ArrayHelper)this.arrayCmb.getSelectedItem()).getDeviceObject().getID()));
                    arrayList.add(new Byte((byte)((GUIData)this.phDriveCmb.getSelectedItem()).flag));
                    this.opDetails.setParameter(arrayList);
                    return true;
                }
                new CustomMsgBox(this, Resource.getString("MSG_NOARRAY_SELECTED", "Please specify an array !"));
                return false;
            }
            if (this.guiHelper.getType() == 3 && this.opDetails.getOpcode() == 0x30E0000) {
                if (CustomMsgBox.confirm(Resource.getString("MSG_CLEAR_BAD_BLOCK_WARNING", "<html>This operation will be destructive to data. Make sure the<br>bad blocks do not affect data before you clear them.<br><br>Are you sure you want to clear bad blocks?</html>"))) return true;
                return false;
            }
            if (this.guiHelper.getType() == 2 && this.opDetails.getOpcode() == 11) {
                Vector vector;
                Object[] objectArray = null;
                Object var2_22 = null;
                if (this.m_driveGroupsList.getSelectedIndices().length <= 0) {
                    new CustomMsgBox(VivaldiStartupDialog.mainScreen, Resource.getString("MSG_NOARRAY_SELECTED", "Please specify an array !"));
                    return false;
                }
                if (this.m_driveGroupsList.getSelectedIndices().length > 16) {
                    new CustomMsgBox(VivaldiStartupDialog.mainScreen, Resource.getString("MSG_MAX_SELECTED_ARRAYS", "Dedicated Hotspare can't be created for more than 16 arrays !"));
                    return false;
                }
                objectArray = this.m_driveGroupsList.getSelectedValues();
                PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)this.guiHelper;
                boolean bl = false;
                if (physicalDriveHelper.isEncrypted()) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        ArrayHelper arrayHelper = (ArrayHelper)objectArray[i];
                        if (arrayHelper.isFDEEncrypted()) continue;
                        bl = true;
                    }
                    if (bl) {
                        bl = false;
                        if (JOptionPane.showConfirmDialog(null, Resource.getString("WARN_REPROVISIONING_ON_SECURED_FDE_DISK"), Resource.getString("TITLE_WARN_REPROVISIONING_ON_SECURED_FDE_DISK"), 0, 2) == 1) {
                            return false;
                        }
                    }
                }
                if (physicalDriveHelper.isPDPICapable() && (vector = this.getPIDisabledDriveGroupsList(objectArray)).size() > 0) {
                    int n = vector.size();
                    Object[] objectArray2 = new Object[4];
                    objectArray2[0] = physicalDriveHelper.getDescription();
                    StringBuffer stringBuffer = new StringBuffer();
                    String string = "";
                    if (vector.size() > 1) {
                        for (int i = 0; i < vector.size(); ++i) {
                            string = stringBuffer.append(vector.get(i)).toString();
                        }
                    }
                    objectArray2[1] = string;
                    System.out.println("size ==" + n + physicalDriveHelper.getDescription());
                    objectArray2[2] = physicalDriveHelper.getDescription();
                    objectArray2[3] = physicalDriveHelper.getDescription();
                    String string7 = MessageFormat.format(Resource.getString("WARN_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION", "<html> If you assign {0} as a hot spare for {1} <br> you will permanently lose the data protection features on {2}<br>because the drive group is/are not capable of data protection.<br> <br> Are you sure you want to assign {3} <br >as hot spare?</html>"), objectArray2);
                    if (JOptionPane.showConfirmDialog(null, string7, Resource.getString("TITLE_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION", "Assign Dedicated Hot Spare - Confirmation"), 0, 2) == 1) {
                        return false;
                    }
                }
                ArrayList<Short> arrayList = new ArrayList<Short>();
                Object[] objectArray3 = this.m_driveGroupsList.getSelectedValues();
                for (int i = 0; i < objectArray3.length; ++i) {
                    arrayList.add(new Short(((ArrayHelper)objectArray3[i]).getDeviceObject().getID()));
                    this.opDetails.setParameter(arrayList);
                }
                return true;
            } else if (this.guiHelper.getType() == 2 && (this.opDetails.getOpcode() == 20 || this.opDetails.getOpcode() == 21)) {
                Object object;
                PhysicalDriveHelper physicalDriveHelper;
                Object[] objectArray = null;
                short[] sArray = null;
                if (this.opDetails.getOpcode() == 21) {
                    Vector vector;
                    if (this.m_driveGroupsList.getSelectedIndices().length <= 0) {
                        new CustomMsgBox(VivaldiStartupDialog.mainScreen, Resource.getString("MSG_NOARRAY_SELECTED", "Please specify an array !"));
                        return false;
                    }
                    if (this.m_driveGroupsList.getSelectedIndices().length > 16) {
                        new CustomMsgBox(VivaldiStartupDialog.mainScreen, Resource.getString("MSG_MAX_SELECTED_ARRAYS", "Dedicated Hotspare can't be created for more than 16 arrays !"));
                        return false;
                    }
                    objectArray = this.m_driveGroupsList.getSelectedValues();
                    physicalDriveHelper = (PhysicalDriveHelper)this.guiHelper;
                    boolean bl = false;
                    if (physicalDriveHelper.isEncrypted()) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            object = (ArrayHelper)objectArray[i];
                            if (((ArrayHelper)object).isFDEEncrypted()) continue;
                            bl = true;
                        }
                        if (bl) {
                            bl = false;
                            if (JOptionPane.showConfirmDialog(null, Resource.getString("WARN_REPROVISIONING_ON_SECURED_FDE_DISK", "<html>One or more secured FDE drives are chosen for this operation.<br>Any data on the drives will be permanently lost.<br><br>Are your sure you want to proceed?<br><br></html>"), Resource.getString("TITLE_WARN_REPROVISIONING_ON_SECURED_FDE_DISK", "Confirm instant secure erase"), 0, 2) == 1) {
                                return false;
                            }
                        }
                    }
                    if (physicalDriveHelper.isPDPICapable() && (vector = this.getPIDisabledDriveGroupsList(objectArray)).size() > 0) {
                        object = new StringBuffer(Resource.getString("WARN_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION1", "<html> If you assign"));
                        ((StringBuffer)object).append(" ").append(physicalDriveHelper.getDescription()).append(" ");
                        ((StringBuffer)object).append(Resource.getString("WARN_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION2", "<br> as a hot spare for "));
                        if (vector.size() > 1) {
                            ((StringBuffer)object).append(Resource.getString("WARN_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION3", "<br>"));
                        }
                        for (int i = 0; i < vector.size(); ++i) {
                            ((StringBuffer)object).append(vector.get(i));
                            ((StringBuffer)object).append(Resource.getString("WARN_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION3", "<br>"));
                        }
                        ((StringBuffer)object).append(Resource.getString("WARN_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION4", "you will permanently lose the data protection features on <br>"));
                        ((StringBuffer)object).append(physicalDriveHelper.getDescription());
                        ((StringBuffer)object).append(Resource.getString("WARN_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION3", "<br>"));
                        if (vector.size() == 1) {
                            ((StringBuffer)object).append(Resource.getString("WARN_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION5", "because the drive group is"));
                        } else {
                            ((StringBuffer)object).append(Resource.getString("WARN_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION6", "because the drive groups are"));
                        }
                        ((StringBuffer)object).append(" ").append(Resource.getString("WARN_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION7", "not capable of data protection.<br> <br> Are you sure you want to assign"));
                        ((StringBuffer)object).append(" ").append(physicalDriveHelper.getDescription()).append(" ");
                        ((StringBuffer)object).append(Resource.getString("WARN_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION3", "<br>"));
                        ((StringBuffer)object).append(Resource.getString("WARN_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION8", "as hot spare? </html>"));
                        if (JOptionPane.showConfirmDialog(null, ((StringBuffer)object).toString(), Resource.getString("TITLE_ASSIGN_DEDICATED_HOTSPARE_CONFIRMATION", "Assign Dedicated Hot Spare - Confirmation"), 0, 2) == 1) {
                            return false;
                        }
                    }
                    sArray = new short[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        sArray[i] = ((ArrayHelper)objectArray[i]).getDeviceObject().getID();
                    }
                }
                if (this.opDetails.getOpcode() == 20) {
                    Object[] objectArray4;
                    Object object2;
                    Object object3;
                    physicalDriveHelper = (PhysicalDriveHelper)this.guiHelper;
                    AdapterHelper adapterHelper = (AdapterHelper)physicalDriveHelper.getParent();
                    Vector vector = adapterHelper.getFDEEncryptedDriveGroups();
                    if (!vector.isEmpty() && !physicalDriveHelper.isFDECapable()) {
                        object = Resource.getString("NON_FDE_GLOBAL_HS_TITLE", "Non-FDE Global Hot Spare");
                        JPanel jPanel = new JPanel(new GridBagLayout());
                        object3 = new GridBagConstraints();
                        ((GridBagConstraints)object3).gridx = 0;
                        ((GridBagConstraints)object3).gridy = 0;
                        ((GridBagConstraints)object3).insets = new Insets(5, 10, 5, 10);
                        ((GridBagConstraints)object3).fill = 1;
                        object2 = new JLabel(Resource.getString("NON_FDE_GLOBAL_HS_DESC", "<html>This global hot spare will not protect the following drive<br>groups because it is not capable of full disk encryption<br>(FDE). <br><br>Only hot spares capable of FDE can protect drive groups<br>secured using FDE.<br><br></html>"));
                        jPanel.add((Component)object2, object3);
                        objectArray4 = Resource.getResourceMnemonic(Resource.getString("FDE_DRIVE_GRP_LABEL", "FDE Drive Groups: "));
                        JLabel jLabel = new JLabel((String)objectArray4[0]);
                        if (objectArray4.length == 2) {
                            jLabel.setDisplayedMnemonic(((String)objectArray4[1]).charAt(0));
                        }
                        ((GridBagConstraints)object3).gridy = 1;
                        jPanel.add((Component)jLabel, object3);
                        JList jList = new JList(vector);
                        jList.setVisibleRowCount(5);
                        jList.setSelectionMode(0);
                        JScrollPane jScrollPane = new JScrollPane(jList, 20, 31);
                        ((GridBagConstraints)object3).gridy = 2;
                        jPanel.add((Component)jScrollPane, object3);
                        VivaldiBaseOptionDialog vivaldiBaseOptionDialog = new VivaldiBaseOptionDialog(VivaldiStartupDialog.mainScreen, (String)object, jPanel, -1, 2);
                        vivaldiBaseOptionDialog.buildUI();
                    }
                    object = new Vector();
                    PhysicalDriveHelper physicalDriveHelper2 = (PhysicalDriveHelper)this.guiHelper;
                    object3 = (SASPhysicalDrive)physicalDriveHelper2.getDeviceObject();
                    object2 = (AdapterHelper)physicalDriveHelper2.getParent();
                    objectArray4 = ((AdapterHelper)object2).getArrays();
                    int n = ((SASAdapter)((SASPhysicalDrive)object3).parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixSSDHDDInLD();
                    int n14 = ((SASAdapter)((SASPhysicalDrive)object3).parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixInLD();
                    int n15 = ((SASAdapter)((SASPhysicalDrive)object3).parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowSSDMixInLD();
                    block24: for (int i = 0; i < objectArray4.length; ++i) {
                        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)objectArray4[i].getLogicalDriveHelpers()[0].getDeviceObject();
                        if (sASLogicalDrive.getInformation().getldConfig().getparams().getPRL() == 0) continue;
                        PhysicalDriveHelper[] physicalDriveHelperArray = ((ArrayHelper)objectArray4[i]).getPhysicalDrives();
                        for (int j = 0; j < physicalDriveHelperArray.length; ++j) {
                            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[j].getDeviceObject();
                            if (physicalDriveHelperArray[j].getmediaType() == '\u0000' && ((SASPhysicalDrive)object3).getMediatype() == 0) {
                                if (n14 != 0 || sASPhysicalDrive.getDriveType() == ((SASPhysicalDrive)object3).getDriveType()) continue;
                                ((Vector)object).add(((ArrayHelper)objectArray4[i]).getDescription());
                                continue block24;
                            }
                            if (physicalDriveHelperArray[j].getmediaType() == '\u0000' && ((SASPhysicalDrive)object3).getMediatype() == 1) {
                                if (n != 0) continue;
                                ((Vector)object).add(((ArrayHelper)objectArray4[i]).getDescription());
                                continue block24;
                            }
                            if (physicalDriveHelperArray[j].getmediaType() == '\u0001' && ((SASPhysicalDrive)object3).getMediatype() == 0) {
                                if (n != 0) continue;
                                ((Vector)object).add(((ArrayHelper)objectArray4[i]).getDescription());
                                continue block24;
                            }
                            if (physicalDriveHelperArray[j].getmediaType() != '\u0001' || ((SASPhysicalDrive)object3).getMediatype() != 1 || n15 != 0 || sASPhysicalDrive.getDriveType() == ((SASPhysicalDrive)object3).getDriveType()) continue;
                            ((Vector)object).add(((ArrayHelper)objectArray4[i]).getDescription());
                            continue block24;
                        }
                    }
                    if (!((Vector)object).isEmpty()) {
                        UnprotectedDriveGroupsDialog unprotectedDriveGroupsDialog = new UnprotectedDriveGroupsDialog((Vector)object, physicalDriveHelper2.getmediaType(), physicalDriveHelper2.getPDDriveType());
                    }
                }
                char c = (char)(this.opDetails.getOpcode() != 20 ? 1 : 0);
                MR_SPARE mR_SPARE = new MR_SPARE(new MR_PD_REF(((SASPhysicalDrive)((PhysicalDriveHelper)this.guiHelper).getDeviceObject()).getDeviceId(), ((SASPhysicalDrive)((PhysicalDriveHelper)this.guiHelper).getDeviceObject()).getSeqNum()));
                if (objectArray != null && sArray != null) {
                    mR_SPARE.setarrayRef(sArray, (byte)objectArray.length);
                }
                spareType_MR_SPARE spareType_MR_SPARE2 = mR_SPARE.getspareType_MR_SPARE1();
                spareType_MR_SPARE2.setisDedicated(c);
                spareType_MR_SPARE2.setisEnclAffinity(spareType_MR_SPARE2.getisEnclAffinity());
                this.opDetails.setOpcode(0x4040000);
                this.opDetails.setParameter(mR_SPARE);
                return true;
            } else if (this.guiHelper.getType() == 1 && this.opDetails.getOpcode() == 0x1020200) {
                this.opDetails.setOpcode(0x1020100);
                MR_CTRL_PROP mR_CTRL_PROP = ((AdapterHelper)this.guiHelper).getCtrlProperties(this.opDetails);
                this.opDetails.setOpcode(0x1020200);
                mR_CTRL_PROP.setAbortCCOnError((byte)(!this.ccFixError.isSelected() ? 1 : 0));
                this.opDetails.setParameter(mR_CTRL_PROP);
                return true;
            } else if (this.guiHelper.getType() == 2 && this.opDetails.getOpcode() == 34275584) {
                int n = this.physicalDrivesList.getSelectedIndex();
                if (n == -1) {
                    new CustomMsgBox(this, Resource.getString("MSG_SELECT_DESTINATION_COPYBACK_DRIVE", "Please select atleast one destination drive to Replace."));
                    return false;
                }
                PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)this.vecPhysicalDrives.get(n);
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.guiHelper.getDeviceObject();
                SASPhysicalDrive sASPhysicalDrive2 = (SASPhysicalDrive)physicalDriveHelper.getDeviceObject();
                ArrayList<Observable> arrayList = new ArrayList<Observable>();
                arrayList.add(sASPhysicalDrive2);
                arrayList.add(sASPhysicalDrive);
                arrayList.add(physicalDriveHelper);
                this.opDetails.setParameter(arrayList);
                return true;
            } else if (this.guiHelper.getType() == 1 && this.opDetails.getOpcode() == 0x1150000) {
                this.m_changeEncypSettingsPanel.launchSelectedOpDialog();
                return true;
            } else if (this.guiHelper.getType() == 1 && this.opDetails.getOpcode() == 40) {
                MR_CTRL_PROP mR_CTRL_PROP = new MR_CTRL_PROP(this.propold.getByteArray(), 0);
                if (((SASAdapter)((AdapterHelper)this.guiHelper).getDeviceObject()).getInformation().getpdOperations_MR_CTRL_INFO().isPowerStateForConfig()) {
                    mR_CTRL_PROP.getOnOffProperties_MR_CTRL_PROP().setEnableSpinDownUnconfigured(this.m_managePowerSettingsPanel.getSelectedPowerSaveMode() ? 1 : 0);
                } else {
                    mR_CTRL_PROP.setspinDownTime((short)this.m_managePowerSettingsPanel.getSpinDownDelayTime());
                }
                this.opDetails.setParameter(mR_CTRL_PROP);
                return true;
            } else {
                if (this.guiHelper.getType() != 3 || this.opDetails.getOpcode() != 12) return true;
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.guiHelper.getDeviceObject();
                MR_RECON mR_RECON = new MR_RECON();
                mR_RECON.setldRef(sASLogicalDrive.getInformation().getldConfig().getproperties().getldRef());
                mR_RECON.setoperation((byte)0);
                this.opDetails.setParameter(mR_RECON);
            }
        }
        return true;
    }

    private Vector getFDEOnlyDriveGroupsList(Object[] objectArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < objectArray.length; ++i) {
            ArrayHelper arrayHelper = (ArrayHelper)objectArray[i];
            if (!arrayHelper.isFDEOnlyDriveGroup()) continue;
            vector.add(arrayHelper.getDescription());
        }
        return vector;
    }

    private Vector getPIDisabledDriveGroupsList(Object[] objectArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < objectArray.length; ++i) {
            ArrayHelper arrayHelper = (ArrayHelper)objectArray[i];
            if (arrayHelper.isArrayPIEnabled()) continue;
            vector.add(arrayHelper.getDescription());
        }
        return vector;
    }

    public Object GetData(JTable jTable, int n, int n2) {
        Object object = jTable.getModel().getValueAt(n, n2);
        return object;
    }

    public int getSelectedSpeedFromJtable(int n) {
        int n2 = 0;
        String[] stringArray = new String[]{"Auto", "1.5Gbps", "3.0Gbps", "6.0Gbps", "12.0Gbps"};
        Object object = this.phyTable.getModel().getValueAt(n, 2);
        n2 = object.equals(stringArray[0]) ? 0 : (object.equals(stringArray[1]) ? 1 : (object.equals(stringArray[2]) ? 2 : (object.equals(stringArray[3]) ? 4 : 8)));
        return n2;
    }

    private boolean isVDCompriseOfSSDDrives(SASLogicalDrive sASLogicalDrive) {
        LogicalDriveHelper[] logicalDriveHelperArray;
        boolean bl = false;
        for (LogicalDriveHelper logicalDriveHelper : logicalDriveHelperArray = ((AdapterHelper)this.guiHelper.getParent()).getLogicalDrives()) {
            PhysicalDriveHelper[] physicalDriveHelperArray;
            if (sASLogicalDrive.getID() != ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getID()) continue;
            for (PhysicalDriveHelper physicalDriveHelper : physicalDriveHelperArray = logicalDriveHelper.getPDListInLd()) {
                if (physicalDriveHelper.getmediaType() != '\u0001') continue;
                return true;
            }
        }
        return bl;
    }

    static {
        noFocusBorder = new EmptyBorder(0, 0, 0, 0);
    }

    class SelectionListener
    implements ListSelectionListener {
        JTable table;

        public SelectionListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n = this.table.getSelectedColumn();
                int n2 = this.table.getSelectedRow();
                if (n == 2) {
                    TableCellEditor tableCellEditor = this.table.getCellEditor(n2, n);
                    Component component = tableCellEditor.getTableCellEditorComponent(this.table, this.table.getValueAt(n2, n), true, n2, n);
                    JComboBox jComboBox = (JComboBox)component;
                    this.table.editCellAt(n2, n);
                    jComboBox.setPopupVisible(true);
                }
            }
        }
    }

    class ComboEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox comboBox;
        Component component;

        public ComboEditor(String[] stringArray) {
            this.comboBox = new JComboBox<String>(stringArray);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (n2 == 2) {
                this.comboBox.setSelectedItem(object);
                this.component = this.comboBox;
            }
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }
    }

    class ComboRenderer
    implements TableCellRenderer {
        JLabel label = new JLabel();
        JComboBox comboBox;

        public ComboRenderer(String[] stringArray) {
            this.label.setOpaque(true);
            this.comboBox = new JComboBox<String>(stringArray);
            this.comboBox.setBorder(BorderFactory.createEmptyBorder());
            Font font = UIManager.getFont("Table.font");
            this.label.setFont(font);
            this.comboBox.setFont(font);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent;
            if (n2 == 2) {
                this.comboBox.setSelectedItem(object);
                jComponent = this.comboBox;
            } else {
                this.label.setText((String)object);
                jComponent = this.label;
            }
            if (bl) {
                jComponent.setForeground(jTable.getSelectionForeground());
                jComponent.setBackground(jTable.getSelectionBackground());
            } else {
                jComponent.setForeground(jTable.getForeground());
                jComponent.setBackground(jTable.getBackground());
            }
            if (jComponent == this.label) {
                if (bl2) {
                    jComponent.setRequestFocusEnabled(true);
                    this.label.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                    if (!bl && jTable.isCellEditable(n, n2)) {
                        Color color = UIManager.getColor("Table.focusCellForeground");
                        if (color != null) {
                            this.label.setForeground(color);
                        }
                        if ((color = UIManager.getColor("Table.focusCellBackground")) != null) {
                            this.label.setBackground(color);
                        }
                    }
                } else {
                    this.label.setBorder(noFocusBorder);
                }
            }
            return jComponent;
        }
    }
}

