/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MainFrame;
import GUI.OperationDetailPanel;
import GUI.VivaldiStartupDialog;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASLogical.SASLogicalDriveOperationsAllowed;
import Utils.ColorHash;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class OperationViewPanel
extends JPanel {
    private JPanel inner = new JPanel();
    private int selectedOperation = -1;
    private ArrayList opList;
    private OperationDetailPanel opDetail;
    private GUIHelperInterface guiHelper;
    private JSplitPane split;
    private ButtonGroup radioGrp = null;

    public OperationViewPanel(GUIHelperInterface gUIHelperInterface, int n) {
        this.guiHelper = gUIHelperInterface;
        this.opList = gUIHelperInterface.getOperationList();
        if (this.opList == null || this.opList.size() <= 0) {
            return;
        }
        int n2 = this.opList.size();
        this.inner.setLayout(new GridLayout(0, 1, 0, 0));
        Font font = this.getFont();
        if (!VivaldiStartupDialog.isWindows) {
            font = Locale.getDefault().getLanguage() == Locale.ENGLISH.getLanguage() ? new Font("Arial", 1, 12) : GUIUtils.getDefaultFont(15, this.getFont().getFontName(this.getLocale()), 12, this);
            if (MainFrame.SCREEN_SIZE.width <= 800) {
                font = Locale.getDefault().getLanguage() == Locale.ENGLISH.getLanguage() ? new Font("Arial", 1, 10) : GUIUtils.getDefaultFont(13, this.getFont().getFontName(), 10, this);
            }
        }
        this.radioGrp = new ButtonGroup();
        for (int i = 0; i < n; ++i) {
            JComponent jComponent = null;
            OperationDetails operationDetails = null;
            if (i < n2) {
                operationDetails = (OperationDetails)this.opList.get(i);
                jComponent = new JRadioButton(operationDetails.getName());
                ((JRadioButton)jComponent).setMnemonic(operationDetails.getMnemonics());
                jComponent.setToolTipText(operationDetails.getDescription());
                jComponent.setFont(font);
                jComponent.setName(operationDetails.getName());
                jComponent.setEnabled(!operationDetails.isDisabled());
                this.radioGrp.add((JRadioButton)jComponent);
                ((JRadioButton)jComponent).addActionListener(new OperationRadioListener(i));
            } else {
                jComponent = new JLabel();
            }
            jComponent.setOpaque(true);
            if (i % 2 == 0) {
                jComponent.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
            } else {
                jComponent.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR2"));
            }
            this.inner.add(jComponent);
        }
        this.inner.setPreferredSize(new Dimension(300 * MainFrame.SCREEN_SIZE.width / 1024, 450 * MainFrame.SCREEN_SIZE.height / 768));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.setPreferredSize(new Dimension(300 * MainFrame.SCREEN_SIZE.width / 1024, 450 * MainFrame.SCREEN_SIZE.height / 768));
        JScrollPane jScrollPane = new JScrollPane(this.inner, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(this.getSize().width, n * 35));
        this.split = new JSplitPane(1, jScrollPane, null);
        this.split.setPreferredSize(new Dimension(0, 300 * MainFrame.SCREEN_SIZE.height / 768));
        this.split.setDividerLocation(300 * MainFrame.SCREEN_SIZE.width / 1024);
        this.add((Component)this.split, "Center");
        this.addOpDetailPanel();
    }

    public OperationViewPanel(GUIHelperInterface gUIHelperInterface) {
        this(gUIHelperInterface, 15);
    }

    public void invokeOperation() {
        if (this.selectedOperation < 0) {
            new CustomMsgBox(this, Resource.getString("MSG_NO_OP_SELCTED", "Please select an operation !"));
            return;
        }
        if (this.opDetail != null) {
            OperationDetails operationDetails = (OperationDetails)this.opList.get(this.selectedOperation);
            if (operationDetails.getOpcode() == 0x1150000) {
                this.opDetail.isReady();
            } else if (this.opDetail.isReady()) {
                if (operationDetails.getOpcode() == 3 && this.guiHelper instanceof LogicalDriveHelper && !((LogicalDriveHelper)this.guiHelper).isSSCD()) {
                    SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)((LogicalDriveHelper)this.guiHelper).getDeviceObject()).getLDAllowedOps();
                    if (sASLogicalDriveOperationsAllowed != null && sASLogicalDriveOperationsAllowed.isForceDeleteLD()) {
                        if (((LogicalDriveHelper)this.guiHelper).isOperationAllowed(operationDetails)) {
                            this.guiHelper.issueOperation(operationDetails);
                        }
                    } else if (this.guiHelper.isOperationAllowed(operationDetails.getOpcode())) {
                        this.guiHelper.issueOperation(operationDetails);
                    }
                } else if (this.guiHelper.isOperationAllowed(operationDetails.getOpcode())) {
                    this.guiHelper.issueOperation(operationDetails);
                } else {
                    return;
                }
            }
        }
    }

    public OperationDetails getSelectedOperation() {
        if (this.selectedOperation < 0) {
            return null;
        }
        return (OperationDetails)this.opList.get(this.selectedOperation);
    }

    private void addOpDetailPanel() {
        this.opDetail = new OperationDetailPanel(this.getSelectedOperation(), this.guiHelper);
        this.split.setRightComponent(this.opDetail);
        this.split.setRightComponent(new JScrollPane(this.opDetail, 20, 30));
        this.split.setDividerLocation(330 * MainFrame.SCREEN_SIZE.width / 1024);
        this.split.validate();
    }

    public void disableSelectedOperation() {
        ButtonModel buttonModel = this.radioGrp.getSelection();
        this.radioGrp.clearSelection();
        buttonModel.setEnabled(false);
    }

    public void setSelectedOperation(int n) {
        System.out.println("Inside setSelectedOperation.");
        if (this.opList != null && this.opList.size() > 0 && 0 <= n && n < this.opList.size()) {
            Enumeration<AbstractButton> enumeration = this.radioGrp.getElements();
            System.out.println("buttons: " + enumeration);
            OperationDetails operationDetails = (OperationDetails)this.opList.get(n);
            if (operationDetails != null) {
                System.out.println("Inside selectedOpDetail != null.");
                while (enumeration.hasMoreElements()) {
                    JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                    System.out.println("button: " + jRadioButton.getName());
                    if (!jRadioButton.getName().equals(operationDetails.getName())) continue;
                    jRadioButton.setSelected(true);
                    jRadioButton.doClick();
                    return;
                }
            }
        }
    }

    private class OperationRadioListener
    implements ActionListener {
        private int select;

        public OperationRadioListener(int n) {
            this.select = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OperationViewPanel.this.selectedOperation = this.select;
            OperationViewPanel.this.addOpDetailPanel();
        }
    }
}

