/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.ConfiguredDriveTableModel;
import GUI.VDTableRenderer;
import GUI.VivaldiBaseDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_PROP;
import SASKernel.LibraryAPI.StoreLib.MR_PR_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_PR_STATUS;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PatrolReadPropDialog
extends VivaldiBaseDialog {
    private JComboBox opModeCombo;
    private JComboBox intervalCombo;
    private JComboBox prMonth;
    private JComboBox prDay;
    private JComboBox prYear;
    private JComboBox prTime;
    private JSpinner maxPDSpinner;
    private JSpinner hourSpinner;
    private JSpinner minutesSpinner;
    private ConfiguredDriveTableModel m_availableVDArrayTableModel;
    private ConfiguredDriveTableModel m_includedVDArrayTableModel;
    private JTable availableVDArrayTable;
    private JTable includedVDArrayTable;
    private ArrayList<LogicalDriveHelper> includedVDHelperList;
    private ArrayList<LogicalDriveHelper> availableVDHelperList;
    private JCheckBox performDrvChkCheckbox;
    private JCheckBox nonStopPatrolCheckbox;
    private JButton m_addButton;
    private JButton m_addAllButton;
    private JButton m_removeButton;
    private JButton m_removeAllButton;
    private JButton m_okButton;
    private boolean okButtonFlag;
    private ItemListener prMonthListener;
    private ItemListener prContinuousListener;
    private ItemListener prOptionListener;
    private AdapterHelper m_AdapterHelper;
    private PhysicalDriveHelper[] phys;
    private boolean b_intervalCombo;
    private boolean b_prMonth;
    private boolean b_prDay;
    private boolean b_prYear;
    private boolean b_prTime;
    private boolean b_maxPDSpinner;
    private boolean b_nonStopPatrolCheckbox;
    private boolean b_performDrvChkCheckbox;
    private boolean b_m_addButton;
    private boolean b_m_addAllButton;
    private boolean b_m_removeButton;
    private boolean b_m_removeAllButton;
    private boolean b_availableVDArrayTable;
    private boolean b_includedVDArrayTable;
    private boolean b_m_okButton;
    private boolean prRunning;
    private int execFreq;
    private boolean isDHSpresent;
    private boolean m_controllerisSWR;
    private boolean[] rbRunning;
    private String PRDGStartOn;

    public PatrolReadPropDialog(AdapterHelper adapterHelper) {
        int n;
        Object object;
        GridBagConstraints gridBagConstraints;
        JPanel jPanel;
        GridBagConstraints gridBagConstraints2;
        JPanel jPanel2;
        String[] stringArray;
        MR_PR_PROPERTIES mR_PR_PROPERTIES;
        block51: {
            this.m_availableVDArrayTableModel = null;
            this.m_includedVDArrayTableModel = null;
            this.availableVDArrayTable = new JTable();
            this.includedVDArrayTable = new JTable();
            this.includedVDHelperList = new ArrayList();
            this.availableVDHelperList = new ArrayList();
            this.performDrvChkCheckbox = new JCheckBox();
            this.nonStopPatrolCheckbox = new JCheckBox();
            this.m_addButton = new JButton();
            this.m_addAllButton = new JButton();
            this.m_removeButton = new JButton();
            this.m_removeAllButton = new JButton();
            this.m_okButton = new JButton();
            this.okButtonFlag = false;
            this.prMonthListener = null;
            this.prContinuousListener = null;
            this.prOptionListener = null;
            this.prRunning = false;
            this.isDHSpresent = false;
            this.m_controllerisSWR = false;
            this.PRDGStartOn = "";
            this.m_AdapterHelper = adapterHelper;
            OperationDetails operationDetails = new OperationDetails(15, "", "", null);
            this.m_AdapterHelper.issueOperation(operationDetails);
            mR_PR_PROPERTIES = (MR_PR_PROPERTIES)operationDetails.getParam();
            stringArray = null;
            if (adapterHelper.isSWRController()) {
                this.m_controllerisSWR = true;
            }
            jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            gridBagConstraints2 = new GridBagConstraints();
            stringArray = Resource.getResourceMnemonic(Resource.getString("PR_MODE_SELECT", "Select patrol read (m)ode:"));
            JLabel jLabel = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            String[] stringArray2 = new String[]{Resource.getString("TEXT_AUTOMATIC", "Automatic"), Resource.getString("OPMODE_MANUAL", "Manual"), Resource.getString("CTRL_OP_CC_OPTION_DISABLE", "Disable")};
            this.opModeCombo = new JComboBox<String>(stringArray2);
            this.opModeCombo.setSelectedIndex(mR_PR_PROPERTIES.getopMode());
            jLabel.setLabelFor(this.opModeCombo);
            this.opModeCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PatrolReadPropDialog.this.opModeCombo.getSelectedIndex() == 1) {
                        PatrolReadPropDialog.this.maxPDSpinner.setEnabled(true);
                        if (PatrolReadPropDialog.this.prRunning) {
                            PatrolReadPropDialog.this.performDrvChkCheckbox.setEnabled(false);
                        } else {
                            PatrolReadPropDialog.this.performDrvChkCheckbox.setEnabled(true);
                            PatrolReadPropDialog.this.performDrvChkCheckbox.setSelected(true);
                        }
                        if (PatrolReadPropDialog.this.performDrvChkCheckbox.isSelected()) {
                            PatrolReadPropDialog.this.prMonth.setEnabled(false);
                            PatrolReadPropDialog.this.prDay.setEnabled(false);
                            PatrolReadPropDialog.this.prYear.setEnabled(false);
                            PatrolReadPropDialog.this.prTime.setEnabled(false);
                        } else {
                            PatrolReadPropDialog.this.prMonth.setEnabled(true);
                            PatrolReadPropDialog.this.prDay.setEnabled(true);
                            PatrolReadPropDialog.this.prYear.setEnabled(true);
                            PatrolReadPropDialog.this.prTime.setEnabled(true);
                        }
                        PatrolReadPropDialog.this.intervalCombo.setEnabled(false);
                        PatrolReadPropDialog.this.nonStopPatrolCheckbox.setEnabled(false);
                        PatrolReadPropDialog.this.setButtonStatus();
                        PatrolReadPropDialog.this.setOKbuttonStatus();
                    } else if (PatrolReadPropDialog.this.opModeCombo.getSelectedIndex() == 2) {
                        PatrolReadPropDialog.this.setEnabledFalse();
                    } else {
                        PatrolReadPropDialog.this.maxPDSpinner.setEnabled(true);
                        if (PatrolReadPropDialog.this.prRunning) {
                            PatrolReadPropDialog.this.performDrvChkCheckbox.setEnabled(false);
                        } else {
                            PatrolReadPropDialog.this.performDrvChkCheckbox.setEnabled(true);
                            PatrolReadPropDialog.this.performDrvChkCheckbox.setSelected(true);
                        }
                        if (PatrolReadPropDialog.this.performDrvChkCheckbox.isSelected()) {
                            PatrolReadPropDialog.this.prMonth.setEnabled(false);
                            PatrolReadPropDialog.this.prDay.setEnabled(false);
                            PatrolReadPropDialog.this.prYear.setEnabled(false);
                            PatrolReadPropDialog.this.prTime.setEnabled(false);
                        } else {
                            PatrolReadPropDialog.this.prMonth.setEnabled(true);
                            PatrolReadPropDialog.this.prDay.setEnabled(true);
                            PatrolReadPropDialog.this.prYear.setEnabled(true);
                            PatrolReadPropDialog.this.prTime.setEnabled(true);
                        }
                        if (PatrolReadPropDialog.this.nonStopPatrolCheckbox.isSelected()) {
                            PatrolReadPropDialog.this.intervalCombo.setEnabled(false);
                        } else {
                            PatrolReadPropDialog.this.intervalCombo.setEnabled(true);
                        }
                        PatrolReadPropDialog.this.nonStopPatrolCheckbox.setEnabled(true);
                        PatrolReadPropDialog.this.setButtonStatus();
                        PatrolReadPropDialog.this.setOKbuttonStatus();
                    }
                }
            });
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(10, 15, 0, 0);
            jPanel2.add((Component)jLabel, gridBagConstraints2);
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.insets = new Insets(0, 15, 0, 0);
            jPanel2.add((Component)this.opModeCombo, gridBagConstraints2);
            stringArray = Resource.getResourceMnemonic(Resource.getString("PR_MAX_PD_LABEL", "Ma(x)imum number of Physical drives allowed for patrol read concurrently:"));
            JLabel jLabel2 = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            int n2 = mR_PR_PROPERTIES.getmaxPD() == '\uffffffff' ? 255 : (int)mR_PR_PROPERTIES.getmaxPD();
            short s = this.m_AdapterHelper.getAdapterInfo().getMaxPDs();
            this.maxPDSpinner = this.m_controllerisSWR || ((SASAdapter)adapterHelper.getDeviceObject()).getInformation().gethwPresent_MR_CTRL_INFO().getmemory() == 0 ? new JSpinner(new SpinnerNumberModel(n2, 0, s, 1)) : new JSpinner(new SpinnerNumberModel(n2, 0, s - 1, 1));
            jLabel2.setLabelFor(this.maxPDSpinner);
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.insets = new Insets(10, 15, 0, 0);
            jPanel2.add((Component)jLabel2, gridBagConstraints2);
            gridBagConstraints2.gridy = 3;
            gridBagConstraints2.insets = new Insets(0, 15, 0, 0);
            jPanel2.add((Component)this.maxPDSpinner, gridBagConstraints2);
            stringArray = Resource.getResourceMnemonic(Resource.getString("PR_VD_PD_DESC", "Include the Virtual drives for whose physical drives, patrol read should be performed:"));
            JLabel jLabel3 = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            gridBagConstraints2.gridy = 4;
            gridBagConstraints2.insets = new Insets(10, 15, 0, 0);
            jPanel2.add((Component)jLabel3, gridBagConstraints2);
            stringArray = Resource.getResourceMnemonic(Resource.getString("PR_AVAILABLE", "Availa(b)le Virtual drives:"));
            JLabel jLabel4 = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            gridBagConstraints2.gridy = 5;
            gridBagConstraints2.insets = new Insets(0, 15, 0, 0);
            jPanel2.add((Component)jLabel4, gridBagConstraints2);
            stringArray = Resource.getResourceMnemonic(Resource.getString("PR_INCLUDED", "I(n)cluded Virtual drives:"));
            JLabel jLabel5 = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel5.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            gridBagConstraints2.gridy = 5;
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(0, 15, 0, 0);
            jPanel2.add((Component)jLabel5, gridBagConstraints2);
            LogicalDriveHelper[] logicalDriveHelperArray = this.m_AdapterHelper.getLogicalDrives();
            for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
                this.availableVDHelperList.add(logicalDriveHelperArray[i]);
            }
            this.m_availableVDArrayTableModel = new ConfiguredDriveTableModel(this.availableVDHelperList);
            if (this.m_availableVDArrayTableModel != null) {
                this.availableVDArrayTable.setModel(this.m_availableVDArrayTableModel);
            }
            this.availableVDArrayTable.setShowGrid(false);
            this.availableVDArrayTable.setCellSelectionEnabled(false);
            this.availableVDArrayTable.setRowSelectionAllowed(true);
            this.availableVDArrayTable.setColumnSelectionAllowed(false);
            this.availableVDArrayTable.setSelectionMode(2);
            this.availableVDArrayTable.setAutoResizeMode(4);
            this.availableVDArrayTable.setAutoscrolls(true);
            this.availableVDArrayTable.getTableHeader().setReorderingAllowed(false);
            this.availableVDArrayTable.changeSelection(0, 0, true, false);
            VDTableRenderer vDTableRenderer = new VDTableRenderer();
            this.availableVDArrayTable.setDefaultRenderer(LogicalDriveHelper.class, vDTableRenderer);
            this.availableVDArrayTable.getSelectionModel().addListSelectionListener(new availableVDArrayTableListSelectionListener());
            jLabel4.setLabelFor(this.availableVDArrayTable);
            JScrollPane jScrollPane = new JScrollPane(this.availableVDArrayTable, 20, 30);
            jScrollPane.setPreferredSize(new Dimension(300, 125));
            gridBagConstraints2.gridy = 6;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 15, 0, 10);
            jPanel2.add((Component)jScrollPane, gridBagConstraints2);
            JPanel jPanel3 = new JPanel(new GridLayout(4, 1, 0, 5));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            stringArray = Resource.getResourceMnemonic(Resource.getString("PR_ADD", "(A)dd >"));
            this.m_addButton.setText(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_addButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.m_addButton.setEnabled(false);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.anchor = 10;
            jPanel3.add((Component)this.m_addButton, gridBagConstraints3);
            stringArray = Resource.getResourceMnemonic(Resource.getString("PR_ADD_ALL", "A(d)d All >>"));
            this.m_addAllButton.setText(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_addAllButton.setMnemonic(stringArray[1].charAt(0));
            }
            gridBagConstraints3.gridy = 1;
            jPanel3.add((Component)this.m_addAllButton, gridBagConstraints3);
            stringArray = Resource.getResourceMnemonic(Resource.getString("PR_REMOVE", "(R)emove <"));
            this.m_removeButton.setText(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_removeButton.setMnemonic(stringArray[1].charAt(0));
            }
            gridBagConstraints3.gridy = 2;
            this.m_removeButton.setEnabled(false);
            jPanel3.add((Component)this.m_removeButton, gridBagConstraints3);
            stringArray = Resource.getResourceMnemonic(Resource.getString("PR_REMOVE_ALL", "Remo(v)e All <<"));
            this.m_removeAllButton.setText(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_removeAllButton.setMnemonic(stringArray[1].charAt(0));
            }
            gridBagConstraints3.gridy = 3;
            jPanel3.add((Component)this.m_removeAllButton, gridBagConstraints3);
            this.setButtonStatus();
            gridBagConstraints2.gridy = 6;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.insets = new Insets(0, 15, 0, 0);
            jPanel2.add((Component)jPanel3, gridBagConstraints2);
            this.m_includedVDArrayTableModel = new ConfiguredDriveTableModel(this.includedVDHelperList);
            if (this.m_includedVDArrayTableModel != null) {
                this.includedVDArrayTable.setModel(this.m_includedVDArrayTableModel);
            }
            this.includedVDArrayTable.setShowGrid(false);
            this.includedVDArrayTable.setCellSelectionEnabled(false);
            this.includedVDArrayTable.setRowSelectionAllowed(true);
            this.includedVDArrayTable.setColumnSelectionAllowed(false);
            this.includedVDArrayTable.setSelectionMode(2);
            this.includedVDArrayTable.setAutoResizeMode(4);
            this.includedVDArrayTable.setAutoscrolls(true);
            this.includedVDArrayTable.getTableHeader().setReorderingAllowed(false);
            this.includedVDArrayTable.changeSelection(0, 0, true, false);
            this.includedVDArrayTable.setDefaultRenderer(LogicalDriveHelper.class, vDTableRenderer);
            this.includedVDArrayTable.getSelectionModel().addListSelectionListener(new includedVDArrayTableListSelectionListener());
            jLabel5.setLabelFor(this.includedVDArrayTable);
            JScrollPane jScrollPane2 = new JScrollPane(this.includedVDArrayTable, 20, 30);
            jScrollPane2.setPreferredSize(new Dimension(300, 125));
            gridBagConstraints2.gridy = 6;
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 15);
            jPanel2.add((Component)jScrollPane2, gridBagConstraints2);
            JPanel jPanel4 = new JPanel(new GridBagLayout());
            jPanel4.setBorder(BorderFactory.createTitledBorder(Resource.getString("PR_INTERVAL", "Patrol Read Interval")));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            stringArray = Resource.getResourceMnemonic(Resource.getString("PR_INTERVAL_LABEL", "Selec(t):"));
            JLabel jLabel6 = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel6.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            String[] stringArray3 = new String[]{Resource.getString("CTRL_OP_CC_OPTION_HOURLY", "Hourly"), Resource.getString("CTRL_OP_CC_OPTION_DAILY", "Daily"), Resource.getString("CTRL_OP_CC_OPTION_WEEKLY", "Weekly"), Resource.getString("CTRL_OP_CC_OPTION_MONTHLY", "Monthly")};
            this.intervalCombo = new JComboBox<String>(stringArray3);
            this.intervalCombo.setSelectedIndex(0);
            jLabel6.setLabelFor(this.intervalCombo);
            stringArray = Resource.getResourceMnemonic(Resource.getString("PR_NON_STOP", "R(u)n patrol read non-stop"));
            this.nonStopPatrolCheckbox.setText(stringArray[0]);
            if (stringArray.length == 2) {
                this.nonStopPatrolCheckbox.setMnemonic(stringArray[1].charAt(0));
            }
            if (this.opModeCombo.getSelectedIndex() == 1) {
                this.intervalCombo.setEnabled(false);
                this.nonStopPatrolCheckbox.setEnabled(false);
            } else {
                this.intervalCombo.setEnabled(true);
                this.nonStopPatrolCheckbox.setEnabled(true);
            }
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            jPanel4.add((Component)jLabel6, gridBagConstraints4);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            jPanel4.add((Component)this.intervalCombo, gridBagConstraints4);
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 1;
            jPanel4.add((Component)this.nonStopPatrolCheckbox, gridBagConstraints4);
            gridBagConstraints2.gridy = 7;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(5, 15, 0, 0);
            jPanel2.add((Component)jPanel4, gridBagConstraints2);
            jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(Resource.getString("PR_SCHEDULE", "Patrol read Schedule")));
            gridBagConstraints = new GridBagConstraints();
            try {
                object = this.m_AdapterHelper.getPatrolReadStatus();
                block1 : switch (((MR_PR_STATUS)object).getstate()) {
                    case '\u0000': 
                    case '\u00ff': {
                        this.prRunning = false;
                        break;
                    }
                    case '\u0001': 
                    case '\u0002': {
                        this.prRunning = true;
                        break;
                    }
                    default: {
                        this.phys = adapterHelper.getPhysicalDrives();
                        int n3 = this.phys.length;
                        for (int i = 0; i < n3; ++i) {
                            short s2 = ((SASPhysicalDrive)this.phys[i].getDeviceObject()).getState();
                            if (s2 != 24 && s2 != 2 || this.phys[i].getInformation().getprogInfo() == null || this.phys[i].getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() != 1) continue;
                            this.prRunning = true;
                            break block1;
                        }
                        break block51;
                    }
                }
                {
                    break block51;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("PR_START", "(P)erform Patrol read when I press OK."));
        this.performDrvChkCheckbox.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.performDrvChkCheckbox.setMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.performDrvChkCheckbox, gridBagConstraints);
        if (this.prRunning) {
            this.performDrvChkCheckbox.setEnabled(false);
        } else {
            this.performDrvChkCheckbox.setEnabled(true);
            this.performDrvChkCheckbox.setSelected(true);
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("PR_START_TIME", "Start patrol read on:"));
        object = new JLabel(stringArray[0]);
        String[] stringArray4 = new String[]{Resource.getString("MONTH_JANUARY_TEXT", "January"), Resource.getString("MONTH_FEBRUARY_TEXT", "February"), Resource.getString("MONTH_MARCH_TEXT", "March"), Resource.getString("MONTH_APRIL_TEXT", "April"), Resource.getString("MONTH_MAY_TEXT", "May"), Resource.getString("MONTH_JUNE_TEXT", "June"), Resource.getString("MONTH_JULY_TEXT", "July"), Resource.getString("MONTH_AUGUST_TEXT", "August"), Resource.getString("MONTH_SEPTEMBER_TEXT", "September"), Resource.getString("MONTH_OCTOBER_TEXT", "October"), Resource.getString("MONTH_NOVEMBER_TEXT", "November"), Resource.getString("MONTH_DECEMBER_TEXT", "December")};
        this.prMonth = new JComboBox<String>(stringArray4);
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)object, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new GridLayout(2, 4, 3, 0));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        stringArray = Resource.getResourceMnemonic(Resource.getString("PR_MONTH", "M(o)nth:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.prMonthListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    int n = PatrolReadPropDialog.this.prMonth.getSelectedIndex();
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    if (gregorianCalendar.get(2) < 2) {
                        gregorianCalendar.set(1, gregorianCalendar.get(1) + 1);
                    }
                    gregorianCalendar.set(2, n);
                    int n2 = ((Calendar)gregorianCalendar).getActualMaximum(5);
                    PatrolReadPropDialog.this.prDay.removeAllItems();
                    for (int i = 1; i <= n2; ++i) {
                        PatrolReadPropDialog.this.prDay.addItem(new Integer(i).toString());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.prMonth.addItemListener(this.prMonthListener);
        stringArray = Resource.getResourceMnemonic(Resource.getString("PR_DAY", "Dat(e):"));
        JLabel jLabel7 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel7.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.prDay = new JComboBox();
        this.prYear = new JComboBox();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n4 = gregorianCalendar.get(1);
        this.prYear.addItem(n4);
        for (int i = 1; i <= 10; ++i) {
            this.prYear.addItem(n4 + i);
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("PR_YEAR", "(Y)ear:"));
        JLabel jLabel8 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel8.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.prTime = new JComboBox();
        String[] stringArray5 = new String[]{"12:00", "01:00", "02:00", "03:00", "04:00", "05:00", "06:00", "07:00", "08:00", "09:00", "10:00", "11:00"};
        for (n = 0; n < stringArray5.length; ++n) {
            this.prTime.addItem(stringArray5[n] + " " + Resource.getString("TIME_AM_TEXT", "AM"));
        }
        for (n = 0; n < stringArray5.length; ++n) {
            this.prTime.addItem(stringArray5[n] + " " + Resource.getString("TIME_PM_TEXT", "PM"));
        }
        this.execFreq = mR_PR_PROPERTIES.getexecFreq();
        if (this.execFreq == 3600) {
            this.intervalCombo.setSelectedIndex(0);
        } else if (this.execFreq == 86400) {
            this.intervalCombo.setSelectedIndex(1);
        } else if (this.execFreq == 604800) {
            this.intervalCombo.setSelectedIndex(2);
        } else if (this.execFreq >= 2419200 && this.execFreq <= 2678400) {
            this.intervalCombo.setSelectedIndex(3);
        } else if (this.execFreq == -1) {
            this.nonStopPatrolCheckbox.setSelected(true);
            this.intervalCombo.setEnabled(false);
        }
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
        long l = gregorianCalendar2.getTimeInMillis();
        long l2 = (long)mR_PR_PROPERTIES.getnextExec() * 1000L;
        TimeZone timeZone = TimeZone.getDefault();
        gregorianCalendar2.setTimeInMillis(l + l2);
        int n5 = gregorianCalendar2.get(2);
        int n6 = gregorianCalendar2.get(5) - 1;
        int n7 = gregorianCalendar2.get(1);
        this.prMonth.setSelectedIndex(-1);
        this.prMonth.setSelectedIndex(n5);
        this.prDay.setSelectedIndex(-1);
        this.prDay.setSelectedIndex(n6);
        this.prYear.setSelectedItem(n7);
        boolean bl = timeZone.inDaylightTime(gregorianCalendar2.getTime());
        if (bl) {
            int n8 = timeZone.getDSTSavings();
            gregorianCalendar2.setTimeInMillis(l + l2 - (long)n8);
        } else {
            gregorianCalendar2.setTimeInMillis(l + l2);
        }
        String string = (gregorianCalendar2.get(10) < 10 ? "0" : "") + new Integer(gregorianCalendar2.get(10)).toString() + ":00 " + (gregorianCalendar2.get(9) == 0 ? Resource.getString("TIME_AM_TEXT", "AM") : Resource.getString("TIME_PM_TEXT", "PM"));
        if (string.equals("00:00 PM")) {
            string = "12:00 PM";
        }
        this.prTime.setSelectedItem(string);
        stringArray = Resource.getResourceMnemonic(Resource.getString("PR_TIME", "T(i)me:"));
        JLabel jLabel9 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel9.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 0;
        jPanel5.add((Component)jLabel, gridBagConstraints5);
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 0;
        jPanel5.add((Component)jLabel7, gridBagConstraints5);
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 0;
        jPanel5.add((Component)jLabel8, gridBagConstraints5);
        gridBagConstraints5.gridx = 3;
        gridBagConstraints5.gridy = 0;
        jPanel5.add((Component)jLabel9, gridBagConstraints5);
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 1;
        jPanel5.add((Component)this.prMonth, gridBagConstraints5);
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 1;
        jPanel5.add((Component)this.prDay, gridBagConstraints5);
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 1;
        jPanel5.add((Component)this.prYear, gridBagConstraints5);
        gridBagConstraints5.gridx = 3;
        gridBagConstraints5.gridy = 1;
        jPanel5.add((Component)this.prTime, gridBagConstraints5);
        jLabel.setLabelFor(this.prMonth);
        jLabel7.setLabelFor(this.prDay);
        jLabel8.setLabelFor(this.prYear);
        jLabel9.setLabelFor(this.prTime);
        if (this.performDrvChkCheckbox.isSelected()) {
            this.prMonth.setEnabled(false);
            this.prDay.setEnabled(false);
            this.prYear.setEnabled(false);
            this.prTime.setEnabled(false);
        }
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints2.gridy = 8;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(5, 15, 0, 0);
        jPanel2.add((Component)jPanel, gridBagConstraints2);
        JPanel jPanel6 = new JPanel(new GridLayout(1, 2, 10, 10));
        stringArray = Resource.getResourceMnemonic(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
        this.m_okButton = new JButton(stringArray[0]);
        this.getRootPane().setDefaultButton(this.m_okButton);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "Cancel"));
        JButton jButton = new JButton(stringArray[0]);
        jPanel6.add(this.m_okButton);
        jPanel6.add(jButton);
        ArrayHelper[] arrayHelperArray = this.m_AdapterHelper.getArrays();
        for (int i = 0; i < arrayHelperArray.length; ++i) {
            if (arrayHelperArray[i].getDedicatedSpares() == null) continue;
            this.isDHSpresent = true;
            break;
        }
        if (this.m_AdapterHelper.getGlobalSpares() != null || this.isDHSpresent) {
            this.m_okButton.setEnabled(true);
            this.okButtonFlag = true;
        } else {
            this.setOKbuttonStatus();
        }
        gridBagConstraints2.gridy = 9;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints2.anchor = 10;
        jPanel2.add((Component)jPanel6, gridBagConstraints2);
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogicalDriveHelper[] logicalDriveHelperArray;
                ArrayHelper[] arrayHelperArray;
                LogicalDriveHelper logicalDriveHelper;
                int n;
                int[] nArray = PatrolReadPropDialog.this.availableVDArrayTable.getSelectedRows();
                int n2 = nArray.length;
                boolean bl = true;
                ArrayList arrayList = new ArrayList();
                for (n = 0; n < n2; ++n) {
                    nArray[n] = PatrolReadPropDialog.this.availableVDArrayTable.convertRowIndexToModel(nArray[n]);
                    arrayList.add(PatrolReadPropDialog.this.availableVDHelperList.get(nArray[n]));
                }
                block1: for (n = 0; n < arrayList.size(); ++n) {
                    logicalDriveHelper = (LogicalDriveHelper)arrayList.get(n);
                    arrayHelperArray = logicalDriveHelper.getArrays();
                    logicalDriveHelperArray = arrayHelperArray[0].getLogicalDriveHelpers();
                    for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
                        if (arrayList.contains(logicalDriveHelperArray[i])) continue;
                        bl = false;
                        continue block1;
                    }
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    logicalDriveHelper = (LogicalDriveHelper)arrayList.get(n);
                    arrayHelperArray = logicalDriveHelper.getArrays();
                    logicalDriveHelperArray = arrayHelperArray[0].getLogicalDriveHelpers();
                    if (!bl) {
                        String string = Resource.getString("PATROL_READ_TITLE", "Patrol read - Information");
                        JOptionPane jOptionPane = new JOptionPane(Resource.getString("PR_ADD_VD"), 1, 0);
                        PatrolReadPropDialog.this.createDialog(jOptionPane, string);
                        Object object = jOptionPane.getValue();
                        if (!(object instanceof Integer)) continue;
                        if ((Integer)object != 0) break;
                        bl = true;
                        for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
                            if (PatrolReadPropDialog.this.includedVDHelperList.contains(logicalDriveHelperArray[i])) continue;
                            PatrolReadPropDialog.this.includedVDHelperList.add(logicalDriveHelperArray[i]);
                        }
                        continue;
                    }
                    for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
                        if (PatrolReadPropDialog.this.includedVDHelperList.contains(logicalDriveHelperArray[i])) continue;
                        PatrolReadPropDialog.this.includedVDHelperList.add(logicalDriveHelperArray[i]);
                    }
                }
                PatrolReadPropDialog.this.availableVDHelperList.removeAll(PatrolReadPropDialog.this.includedVDHelperList);
                PatrolReadPropDialog.this.m_availableVDArrayTableModel.updateModel(PatrolReadPropDialog.this.availableVDHelperList);
                PatrolReadPropDialog.this.m_includedVDArrayTableModel.updateModel(PatrolReadPropDialog.this.includedVDHelperList);
                PatrolReadPropDialog.this.setButtonStatus();
                PatrolReadPropDialog.this.setOKbuttonStatus();
                PatrolReadPropDialog.this.m_addButton.setEnabled(false);
                PatrolReadPropDialog.this.m_removeButton.setEnabled(false);
            }
        });
        this.m_addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PatrolReadPropDialog.this.availableVDHelperList.size();
                for (int i = 0; i < n; ++i) {
                    PatrolReadPropDialog.this.includedVDHelperList.add(PatrolReadPropDialog.this.availableVDHelperList.get(i));
                }
                PatrolReadPropDialog.this.availableVDHelperList.removeAll(PatrolReadPropDialog.this.includedVDHelperList);
                PatrolReadPropDialog.this.m_availableVDArrayTableModel.updateModel(PatrolReadPropDialog.this.availableVDHelperList);
                PatrolReadPropDialog.this.m_includedVDArrayTableModel.updateModel(PatrolReadPropDialog.this.includedVDHelperList);
                PatrolReadPropDialog.this.setButtonStatus();
                PatrolReadPropDialog.this.setOKbuttonStatus();
                PatrolReadPropDialog.this.m_removeButton.setEnabled(false);
            }
        });
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogicalDriveHelper[] logicalDriveHelperArray;
                ArrayHelper[] arrayHelperArray;
                LogicalDriveHelper logicalDriveHelper;
                int n;
                int[] nArray = PatrolReadPropDialog.this.includedVDArrayTable.getSelectedRows();
                int n2 = nArray.length;
                boolean bl = true;
                ArrayList arrayList = new ArrayList();
                for (n = 0; n < n2; ++n) {
                    nArray[n] = PatrolReadPropDialog.this.includedVDArrayTable.convertRowIndexToModel(nArray[n]);
                    arrayList.add(PatrolReadPropDialog.this.includedVDHelperList.get(nArray[n]));
                }
                block1: for (n = 0; n < arrayList.size(); ++n) {
                    logicalDriveHelper = (LogicalDriveHelper)arrayList.get(n);
                    arrayHelperArray = logicalDriveHelper.getArrays();
                    logicalDriveHelperArray = arrayHelperArray[0].getLogicalDriveHelpers();
                    for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
                        if (arrayList.contains(logicalDriveHelperArray[i])) continue;
                        bl = false;
                        continue block1;
                    }
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    logicalDriveHelper = (LogicalDriveHelper)arrayList.get(n);
                    arrayHelperArray = logicalDriveHelper.getArrays();
                    logicalDriveHelperArray = arrayHelperArray[0].getLogicalDriveHelpers();
                    if (!bl) {
                        String string = Resource.getString("PATROL_READ_TITLE", "Patrol read - Information");
                        JOptionPane jOptionPane = new JOptionPane(Resource.getString("PR_REMOVE_VD"), 1, 0);
                        PatrolReadPropDialog.this.createDialog(jOptionPane, string);
                        Object object = jOptionPane.getValue();
                        if (!(object instanceof Integer)) continue;
                        if ((Integer)object != 0) break;
                        bl = true;
                        for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
                            if (PatrolReadPropDialog.this.availableVDHelperList.contains(logicalDriveHelperArray[i])) continue;
                            PatrolReadPropDialog.this.availableVDHelperList.add(logicalDriveHelperArray[i]);
                        }
                        continue;
                    }
                    for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
                        if (PatrolReadPropDialog.this.availableVDHelperList.contains(logicalDriveHelperArray[i])) continue;
                        PatrolReadPropDialog.this.availableVDHelperList.add(logicalDriveHelperArray[i]);
                    }
                }
                PatrolReadPropDialog.this.includedVDHelperList.removeAll(PatrolReadPropDialog.this.availableVDHelperList);
                PatrolReadPropDialog.this.m_availableVDArrayTableModel.updateModel(PatrolReadPropDialog.this.availableVDHelperList);
                PatrolReadPropDialog.this.m_includedVDArrayTableModel.updateModel(PatrolReadPropDialog.this.includedVDHelperList);
                PatrolReadPropDialog.this.setButtonStatus();
                PatrolReadPropDialog.this.setOKbuttonStatus();
                PatrolReadPropDialog.this.m_removeButton.setEnabled(false);
                PatrolReadPropDialog.this.m_addButton.setEnabled(false);
            }
        });
        this.m_removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PatrolReadPropDialog.this.includedVDHelperList.size();
                for (int i = 0; i < n; ++i) {
                    PatrolReadPropDialog.this.availableVDHelperList.add(PatrolReadPropDialog.this.includedVDHelperList.get(i));
                }
                PatrolReadPropDialog.this.includedVDHelperList.removeAll(PatrolReadPropDialog.this.availableVDHelperList);
                PatrolReadPropDialog.this.m_availableVDArrayTableModel.updateModel(PatrolReadPropDialog.this.availableVDHelperList);
                PatrolReadPropDialog.this.m_includedVDArrayTableModel.updateModel(PatrolReadPropDialog.this.includedVDHelperList);
                PatrolReadPropDialog.this.setButtonStatus();
                PatrolReadPropDialog.this.setOKbuttonStatus();
                PatrolReadPropDialog.this.m_addButton.setEnabled(false);
            }
        });
        this.nonStopPatrolCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PatrolReadPropDialog.this.nonStopPatrolCheckbox.isSelected()) {
                    PatrolReadPropDialog.this.intervalCombo.setEnabled(false);
                } else {
                    PatrolReadPropDialog.this.intervalCombo.setEnabled(true);
                }
            }
        });
        this.performDrvChkCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PatrolReadPropDialog.this.performDrvChkCheckbox.isSelected()) {
                    PatrolReadPropDialog.this.prMonth.setEnabled(false);
                    PatrolReadPropDialog.this.prDay.setEnabled(false);
                    PatrolReadPropDialog.this.prYear.setEnabled(false);
                    PatrolReadPropDialog.this.prTime.setEnabled(false);
                } else {
                    PatrolReadPropDialog.this.prMonth.setEnabled(true);
                    PatrolReadPropDialog.this.prDay.setEnabled(true);
                    PatrolReadPropDialog.this.prYear.setEnabled(true);
                    PatrolReadPropDialog.this.prTime.setEnabled(true);
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PatrolReadPropDialog.this.warningDialog()) {
                    PatrolReadPropDialog.this.dispose();
                }
            }
        });
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OperationDetails operationDetails = new OperationDetails(15, "", "", null);
                PatrolReadPropDialog.this.m_AdapterHelper.issueOperation(operationDetails);
                MR_PR_PROPERTIES mR_PR_PROPERTIES = (MR_PR_PROPERTIES)operationDetails.getParam();
                operationDetails.setOpcode(16);
                if (PatrolReadPropDialog.this.opModeCombo.getSelectedIndex() == 2) {
                    mR_PR_PROPERTIES.setopMode((char)PatrolReadPropDialog.this.opModeCombo.getSelectedIndex());
                    operationDetails.setParameter(mR_PR_PROPERTIES);
                    PatrolReadPropDialog.this.m_AdapterHelper.issueOperation(operationDetails);
                    String string = Resource.getString("PR_SAVE_TITLE", "Patrol read properties saved");
                    JOptionPane jOptionPane = new JOptionPane(Resource.getString("PR_SAVE"), 1);
                    PatrolReadPropDialog.this.createDialog(jOptionPane, string);
                } else {
                    String string;
                    int n;
                    if (PatrolReadPropDialog.this.opModeCombo.getSelectedIndex() == 0) {
                        if (PatrolReadPropDialog.this.nonStopPatrolCheckbox.isSelected()) {
                            mR_PR_PROPERTIES.setexecFreq(-1);
                        } else {
                            switch (PatrolReadPropDialog.this.intervalCombo.getSelectedIndex()) {
                                case 0: {
                                    mR_PR_PROPERTIES.setexecFreq(3600);
                                    break;
                                }
                                case 1: {
                                    mR_PR_PROPERTIES.setexecFreq(86400);
                                    break;
                                }
                                case 2: {
                                    mR_PR_PROPERTIES.setexecFreq(604800);
                                    break;
                                }
                                case 3: {
                                    mR_PR_PROPERTIES.setexecFreq(2592000);
                                    break;
                                }
                            }
                        }
                    }
                    if (!PatrolReadPropDialog.this.performDrvChkCheckbox.isSelected()) {
                        boolean bl;
                        int n2 = PatrolReadPropDialog.this.prMonth.getSelectedIndex();
                        n = PatrolReadPropDialog.this.prDay.getSelectedIndex() + 1;
                        string = PatrolReadPropDialog.this.prYear.getSelectedItem().toString();
                        String string2 = PatrolReadPropDialog.this.prTime.getSelectedItem().toString();
                        int n3 = new Integer(string);
                        int n4 = new Integer(string2.substring(0, 2));
                        boolean bl2 = bl = PatrolReadPropDialog.this.prTime.getSelectedIndex() > 11;
                        if (bl && n4 != 12) {
                            n4 += 12;
                        }
                        if (!bl && n4 == 12) {
                            n4 -= 12;
                        }
                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                        boolean bl3 = false;
                        if (!bl3) {
                            if (gregorianCalendar.get(1) == n3) {
                                if (n2 < gregorianCalendar.get(2)) {
                                    new CustomMsgBox(Resource.getString("MSG_CCSCHEDULE_DATE", "The specified date occurs in the past"));
                                    return;
                                }
                                if (n2 == gregorianCalendar.get(2) && n < gregorianCalendar.get(5)) {
                                    new CustomMsgBox(Resource.getString("MSG_CCSCHEDULE_DATE", "The specified date occurs in the past"));
                                    return;
                                }
                                if (n2 == gregorianCalendar.get(2) && n == gregorianCalendar.get(5) && n4 <= gregorianCalendar.get(11)) {
                                    new CustomMsgBox(Resource.getString("MSG_CCSCHEDULE_DATE", "The specified date occurs in the past"));
                                    return;
                                }
                            }
                            gregorianCalendar.set(1, n3);
                            gregorianCalendar.set(2, n2);
                            gregorianCalendar.set(5, n);
                            gregorianCalendar.set(11, n4);
                            gregorianCalendar.set(12, 0);
                            gregorianCalendar.set(13, 0);
                            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
                            TimeZone timeZone = TimeZone.getDefault();
                            Date date = gregorianCalendar.getTime();
                            long l = gregorianCalendar2.getTimeInMillis() / 1000L;
                            long l2 = gregorianCalendar.getTimeInMillis() / 1000L;
                            boolean bl4 = timeZone.inDaylightTime(date);
                            if (bl4) {
                                int n5 = timeZone.getDSTSavings();
                                mR_PR_PROPERTIES.setnextExec((int)(l2 - l + (long)(n5 / 1000)));
                            } else {
                                mR_PR_PROPERTIES.setnextExec((int)(l2 - l));
                            }
                        }
                    }
                    mR_PR_PROPERTIES.setexcludeLdCount((char)PatrolReadPropDialog.this.availableVDHelperList.size());
                    short[] sArray = new short[PatrolReadPropDialog.this.availableVDHelperList.size()];
                    for (n = 0; n < sArray.length; ++n) {
                        sArray[n] = ((LogicalDriveHelper)PatrolReadPropDialog.this.availableVDHelperList.get(n)).getDeviceObject().getID();
                    }
                    mR_PR_PROPERTIES.setexcludedLD(sArray);
                    mR_PR_PROPERTIES.setopMode((char)PatrolReadPropDialog.this.opModeCombo.getSelectedIndex());
                    mR_PR_PROPERTIES.setmaxPD((char)((Integer)PatrolReadPropDialog.this.maxPDSpinner.getValue()).byteValue());
                    operationDetails.setParameter(mR_PR_PROPERTIES);
                    PatrolReadPropDialog.this.m_AdapterHelper.issueOperation(operationDetails);
                    JOptionPane jOptionPane = null;
                    if (PatrolReadPropDialog.this.performDrvChkCheckbox.isSelected()) {
                        operationDetails.setOpcode(17);
                        if (PatrolReadPropDialog.this.checkIfPatrolReadCanRun() && PatrolReadPropDialog.this.checkIncludedDGPDs()) {
                            PatrolReadPropDialog.this.m_AdapterHelper.issueOperation(operationDetails);
                            string = Resource.getString("PR_SAVE_START_TITLE", "Patrol read properties saved and started");
                            jOptionPane = PatrolReadPropDialog.this.m_AdapterHelper.getGlobalSpares() != null ? new JOptionPane(Resource.getString("PR_SAVE_START", "Patrol Read properties have been saved and started") + " on \n" + PatrolReadPropDialog.this.PRDGStartOn + "\n\t" + Resource.getString("GLOBAL_HOT_SPARES_TEXT", "Global HSP"), 1) : new JOptionPane(Resource.getString("PR_SAVE_START", "Patrol read properties saved and started") + " on \n" + PatrolReadPropDialog.this.PRDGStartOn, 1);
                            PatrolReadPropDialog.this.createDialog(jOptionPane, string);
                        } else if (PatrolReadPropDialog.this.m_AdapterHelper.getGlobalSpares() != null) {
                            PatrolReadPropDialog.this.m_AdapterHelper.issueOperation(operationDetails);
                            string = Resource.getString("PR_SAVE_START_TITLE", "Patrol read properties saved and started");
                            jOptionPane = new JOptionPane(Resource.getString("PR_SAVE_START") + " on \n" + Resource.getString("GLOBAL_HOT_SPARES_TEXT", "Global HSP"), 1);
                            PatrolReadPropDialog.this.createDialog(jOptionPane, string);
                        } else {
                            string = Resource.getString("PR_SAVE_TITLE", "Patrol read properties saved");
                            jOptionPane = new JOptionPane(Resource.getString("PR_SAVE"), 1);
                            PatrolReadPropDialog.this.createDialog(jOptionPane, string);
                        }
                    } else {
                        string = Resource.getString("PR_SAVE_TITLE", "Patrol read properties saved");
                        jOptionPane = new JOptionPane(Resource.getString("PR_SAVE"), 1);
                        PatrolReadPropDialog.this.createDialog(jOptionPane, string);
                    }
                }
                PatrolReadPropDialog.this.dispose();
            }
        });
        this.add(jPanel2);
        if (mR_PR_PROPERTIES.getopMode() == '\u0002') {
            this.setEnabledFalse();
        }
        this.setTitle(Resource.getString("PR_SETPROP_TITLE", "Patrol Read - Set properties"));
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    private void setButtonStatus() {
        if (this.availableVDHelperList.size() == 0) {
            this.m_addButton.setEnabled(false);
            this.m_addAllButton.setEnabled(false);
            this.m_removeAllButton.setFocusable(true);
        } else {
            this.m_addButton.setEnabled(true);
            this.m_addAllButton.setEnabled(true);
        }
        if (this.includedVDHelperList.size() == 0) {
            this.m_removeButton.setEnabled(false);
            this.m_removeAllButton.setEnabled(false);
            this.m_addAllButton.requestFocus();
        } else {
            this.m_removeButton.setEnabled(true);
            this.m_removeAllButton.setEnabled(true);
            this.m_removeAllButton.requestFocus();
        }
    }

    public void setOKbuttonStatus() {
        if (!this.okButtonFlag) {
            if (this.includedVDHelperList.size() == 0) {
                this.m_okButton.setEnabled(false);
            } else {
                this.m_okButton.setEnabled(true);
            }
        }
    }

    @Override
    protected boolean warningDialog() {
        String string = Resource.getString("PR_CONFIRMATION_TITLE", "Patrol read - Confirmation");
        int[] nArray = new int[]{89, 78};
        Object[] objectArray = new String[]{"Yes", "No"};
        JOptionPane jOptionPane = new JOptionPane(Resource.getString("CONFIG_CANCEL_MSG"), 3, 0, null, objectArray, objectArray[1]);
        JDialog jDialog = jOptionPane.createDialog(null, string);
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        jDialog.setIconImage(image);
        PatrolReadPropDialog.addMnemonicsToButtons(jDialog, (String[])objectArray, nArray);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        System.out.println(" value = " + object);
        System.out.println(" Possi = " + (String)objectArray[0]);
        return object instanceof String && ((String)object).toString() == objectArray[0];
    }

    private void createDialog(JOptionPane jOptionPane, String string) {
        JDialog jDialog = jOptionPane.createDialog(this, string);
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        jDialog.setIconImage(image);
        jDialog.setVisible(true);
    }

    public static void addMnemonicsToButtons(Component component, String[] stringArray, int[] nArray) {
        Component[] componentArray = PatrolReadPropDialog.getAllSubComponents(component);
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(componentArray[i] instanceof AbstractButton)) continue;
            AbstractButton abstractButton = (AbstractButton)componentArray[i];
            String string = abstractButton.getText();
            if (string == null) {
                string = "";
            }
            int n2 = stringArray.length;
            for (int j = 0; j < n2; ++j) {
                if (!string.equals(stringArray[j])) continue;
                abstractButton.setMnemonic(nArray[j]);
            }
        }
    }

    public static Component[] getAllSubComponents(Component component) {
        Vector vector = new Vector();
        PatrolReadPropDialog.addSubComponentsToVector(component, vector);
        int n = vector.size();
        Component[] componentArray = new Component[n];
        for (int i = 0; i < n; ++i) {
            componentArray[i] = (Component)vector.elementAt(i);
        }
        vector.removeAllElements();
        return componentArray;
    }

    private static void addSubComponentsToVector(Component component, Vector vector) {
        if (component == null) {
            return;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                vector.addElement(componentArray[i]);
                if (!(componentArray[i] instanceof Container)) continue;
                PatrolReadPropDialog.addSubComponentsToVector(componentArray[i], vector);
            }
        }
    }

    private boolean checkFirmwareAllowsPROnSSD() {
        MR_CTRL_PROP mR_CTRL_PROP = this.m_AdapterHelper.getAdapterProperties();
        OperationDetails operationDetails = new OperationDetails(15, null);
        this.m_AdapterHelper.issueOperation(operationDetails);
        MR_PR_PROPERTIES mR_PR_PROPERTIES = (MR_PR_PROPERTIES)operationDetails.getParam();
        boolean bl = mR_CTRL_PROP.getOnOffProperties_MR_CTRL_PROP().isSSDPatrolReadEnabled();
        return mR_PR_PROPERTIES.getOptions() == '\u0001' && bl;
    }

    private boolean isHddPresent(LogicalDriveHelper logicalDriveHelper) {
        if (logicalDriveHelper != null) {
            PhysicalDriveHelper[] physicalDriveHelperArray = logicalDriveHelper.getPDListInLd();
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                if (physicalDriveHelperArray[i] == null || physicalDriveHelperArray[i].getmediaType() != '\u0000') continue;
                return true;
            }
        }
        return false;
    }

    private boolean canPatrolReadRunOnSSD() {
        for (int i = 0; i < this.includedVDHelperList.size(); ++i) {
            if (!this.isHddPresent(this.includedVDHelperList.get(i))) continue;
            return true;
        }
        return this.checkFirmwareAllowsPROnSSD();
    }

    private boolean isSSDDrivesPresentinIncludedLDList() {
        for (int i = 0; i < this.includedVDHelperList.size(); ++i) {
            PhysicalDriveHelper[] physicalDriveHelperArray = this.includedVDHelperList.get(i).getPDListInLd();
            if (physicalDriveHelperArray[i] == null || physicalDriveHelperArray[i].getmediaType() != '\u0001') continue;
            return true;
        }
        return false;
    }

    public boolean checkIfPatrolReadCanRun() {
        int n;
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_AdapterHelper.getPhysicalDrives();
        LogicalDriveHelper[] logicalDriveHelperArray = this.m_AdapterHelper.getLogicalDrives();
        OperationDetails operationDetails = new OperationDetails(15, null);
        MR_PR_PROPERTIES mR_PR_PROPERTIES = operationDetails.getParam() != null ? (MR_PR_PROPERTIES)operationDetails.getParam() : null;
        ArrayHelper[] arrayHelperArray = this.m_AdapterHelper.getArrays();
        int n2 = arrayHelperArray.length;
        int n3 = this.includedVDHelperList.size();
        this.rbRunning = new boolean[n3];
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            this.rbRunning[n] = false;
        }
        if (mR_PR_PROPERTIES != null && (short)mR_PR_PROPERTIES.getopMode() == 2) {
            String string = Resource.getString("PR_DISABLED_TITLE", "Patrol read - Disabled");
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("PR_DISABLED", "Patrol read is disabled."), 0);
            this.createDialog(jOptionPane, string);
            return false;
        }
        if (physicalDriveHelperArray.length <= 0) {
            String string = Resource.getString("PR_NO_PD_TITLE", "Patrol read - No PD");
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("PR_NO_PD", "Patrol read cannot be started because there are no PD available."), 0);
            this.createDialog(jOptionPane, string);
            return false;
        }
        if (logicalDriveHelperArray.length <= 0 && this.m_AdapterHelper.getGlobalSpares() == null) {
            String string = Resource.getString("PR_NO_CONFIG_TITLE", "Patrol read - No Configuration");
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("PR_NO_CONFIG", "Patrol read cannot be started because there is no configuration available."), 0);
            this.createDialog(jOptionPane, string);
            return false;
        }
        if (this.isSSDDrivesPresentinIncludedLDList() && !this.canPatrolReadRunOnSSD()) {
            String string = Resource.getString("PR_SSD_TITLE", "Patrol read - Operation not possible");
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("PR_ON_SSD", "Operation can not be started on VD consisting of only SSD !"), 0);
            this.createDialog(jOptionPane, string);
            return false;
        }
        for (n = 0; n < n3; ++n) {
            ArrayHelper[] arrayHelperArray2 = this.includedVDHelperList.get(n).getArrays();
            for (int i = 0; i < arrayHelperArray2.length; ++i) {
                PhysicalDriveHelper[] physicalDriveHelperArray2 = arrayHelperArray2[i].getPhysicalDrives();
                for (int n5 = 0; n5 < physicalDriveHelperArray2.length; n5 = (int)((short)(n5 + 1))) {
                    if (((SASPhysicalDrive)physicalDriveHelperArray2[n5].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getrbld() != 0) {
                        this.rbRunning[n] = true;
                        continue;
                    }
                    if (((SASPhysicalDrive)physicalDriveHelperArray2[n5].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getCopyBack() == 0) continue;
                    this.rbRunning[n] = true;
                }
            }
        }
        for (n = 0; n < n3; ++n) {
            if (!this.rbRunning[n]) continue;
            ++n4;
        }
        if (n4 == n3) {
            String string = Resource.getString("MSG_RBLD_INPROGRESS", "Operation can not be started while Rebuild is in progress !");
            this.displayMessageBox(string);
            return false;
        }
        return true;
    }

    public boolean checkIncludedDGPDs() {
        String string = null;
        ArrayHelper[] arrayHelperArray = this.m_AdapterHelper.getArrays();
        OperationDetails operationDetails = new OperationDetails(15, null);
        this.m_AdapterHelper.issueOperation(operationDetails);
        int n = arrayHelperArray.length;
        int n2 = this.includedVDHelperList.size();
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        String string3 = "";
        for (int n4 = 0; n4 < n; n4 = (int)((short)(n4 + 1))) {
            bl2 = false;
            bl = false;
            LogicalDriveHelper[] logicalDriveHelperArray = arrayHelperArray[n4].getLogicalDriveHelpers();
            for (int n5 = 0; n5 < logicalDriveHelperArray.length; n5 = (int)((short)(n5 + 1))) {
                if (!this.includedVDHelperList.contains(logicalDriveHelperArray[n5])) {
                    bl2 = true;
                    break;
                }
                if (((SASLogicalDrive)logicalDriveHelperArray[n5].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon()) {
                    string = Resource.getString("MSG_RECON_INPROGRESS", "Operation can not be started while reconstruction is in progress !");
                    this.displayMessageBox(string);
                    return false;
                }
                if (((SASLogicalDrive)logicalDriveHelperArray[n5].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getcc()) {
                    string = arrayHelperArray[n4].getText() + " : " + Resource.getString("MSG_CC_INPROGRESS", "Operation can not be started while check consistency is in progress !");
                    this.displayMessageBox(string);
                    bl = true;
                    break;
                }
                if (((SASLogicalDrive)logicalDriveHelperArray[n5].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getbgi() || ((SASLogicalDrive)logicalDriveHelperArray[n5].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getfgi()) {
                    string = arrayHelperArray[n4].getText() + " : " + Resource.getString("MSG_BGI_INPROGRESS", "Operation cannot be started while initialization is in progress !");
                    this.displayMessageBox(string);
                    bl = true;
                    break;
                }
                if (this.isSSDDrivesPresentinIncludedLDList()) {
                    if (this.isHddPresent(logicalDriveHelperArray[n5]) || this.checkFirmwareAllowsPROnSSD()) continue;
                    string = arrayHelperArray[n4].getText() + " : " + Resource.getString("PR_ON_SSD", "Operation can not be started on VD consisting of only SSD !");
                    this.displayMessageBox(string);
                    bl = true;
                    break;
                }
                boolean bl3 = false;
                PhysicalDriveHelper[] physicalDriveHelperArray = logicalDriveHelperArray[n5].getPDListInLd();
                for (int n6 = 0; n6 < physicalDriveHelperArray.length; n6 = (int)((short)(n6 + 1))) {
                    if (((SASPhysicalDrive)physicalDriveHelperArray[n6].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getrbld() != 0) {
                        string = arrayHelperArray[n4].getText() + " : " + Resource.getString("MSG_REBUILD_INPROGRESS", "Operation can not be started while Rebuild is in progress !");
                        this.displayMessageBox(string);
                        bl = true;
                        bl3 = true;
                        break;
                    }
                    if (((SASPhysicalDrive)physicalDriveHelperArray[n6].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getCopyBack() == 0) continue;
                    string = arrayHelperArray[n4].getText() + " : " + Resource.getString("MSG_COPYBACK_INPROGRESS", "Operation can not be started while Copyback is in progress !");
                    this.displayMessageBox(string);
                    bl = true;
                    bl3 = true;
                    break;
                }
                if (bl3) break;
            }
            if (bl2) continue;
            if (bl) {
                if (arrayHelperArray[n4].getDedicatedSpares() != null) {
                    if (string3.length() > 1) {
                        string3 = string3 + "\t" + arrayHelperArray[n4].getText() + "\n";
                        continue;
                    }
                    string3 = Resource.getString("DEDICATED_HOT_SPARES_TEXT", "Dedicated HSP") + "" + Resource.getString("SUMMARY_TEXT_DG_NAME", "Drive Group Name: ") + "\n\t" + arrayHelperArray[n4].getText() + "\n";
                    continue;
                }
                n3 += arrayHelperArray[n4].getLogicalDriveHelpers().length;
                continue;
            }
            if (string2.length() > 1) {
                if (arrayHelperArray[n4].getSpanDepth() > 1) {
                    string2 = string2 + "\t" + Resource.getString("SPANNED_DRIVE_GROUP_TEXT", "Spanned Drive Group") + " " + arrayHelperArray[n4].getParentIDForSpan() + ", " + arrayHelperArray[n4].getText() + "\n";
                    continue;
                }
                string2 = string2 + "\t" + arrayHelperArray[n4].getText() + "\n";
                continue;
            }
            string2 = arrayHelperArray[n4].getSpanDepth() > 1 ? Resource.getString("SUMMARY_TEXT_DG_NAME", "Drive Group Name: ") + "\n\t" + Resource.getString("SPANNED_DRIVE_GROUP_TEXT", "Spanned Drive Group") + " " + arrayHelperArray[n4].getParentIDForSpan() + ", " + arrayHelperArray[n4].getText() + "\n" : Resource.getString("SUMMARY_TEXT_DG_NAME", "Drive Group Name: ") + "\n\t" + arrayHelperArray[n4].getText() + "\n";
        }
        if (n3 == n2) {
            return false;
        }
        this.PRDGStartOn = string3 + "\n" + string2;
        return true;
    }

    private void displayMessageBox(String string) {
        String string2 = Resource.getString("PR_BACKGROUND_PROCESS_TITLE", "Patrol read - Background process running");
        JOptionPane jOptionPane = new JOptionPane(string, 0);
        this.createDialog(jOptionPane, string2);
    }

    private void setEnabledFalse() {
        this.intervalCombo.setEnabled(false);
        this.prMonth.setEnabled(false);
        this.prDay.setEnabled(false);
        this.prYear.setEnabled(false);
        this.prTime.setEnabled(false);
        this.maxPDSpinner.setEnabled(false);
        this.nonStopPatrolCheckbox.setEnabled(false);
        this.performDrvChkCheckbox.setEnabled(false);
        this.m_addButton.setEnabled(false);
        this.m_addAllButton.setEnabled(false);
        this.m_removeButton.setEnabled(false);
        this.m_removeAllButton.setEnabled(false);
        this.m_okButton.setEnabled(true);
    }

    class includedVDArrayTableListSelectionListener
    implements ListSelectionListener {
        includedVDArrayTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PatrolReadPropDialog.this.opModeCombo.getSelectedIndex() != 2) {
                PatrolReadPropDialog.this.m_addButton.setEnabled(false);
                PatrolReadPropDialog.this.m_removeButton.setEnabled(true);
            }
        }
    }

    class availableVDArrayTableListSelectionListener
    implements ListSelectionListener {
        availableVDArrayTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PatrolReadPropDialog.this.opModeCombo.getSelectedIndex() != 2) {
                PatrolReadPropDialog.this.m_addButton.setEnabled(true);
                PatrolReadPropDialog.this.m_removeButton.setEnabled(false);
            }
        }
    }
}

