/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.DetailPanel;
import GUI.GraphicalViewColorCodes;
import GUI.MainFrame;
import GUI.OperationViewPanel;
import GUI.PhysicalDriveEraseDialog;
import GUI.PhysicalDriveGraphicalView;
import GUI.PropertyViewPanel;
import GUI.VivaldiStartupDialog;
import GUI.security.ConfirmSecureEraseDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.ColorHash;
import Utils.CustomComboBox;
import Utils.CustomMsgBox;
import Utils.CustomTabbedPane;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PhysicalDriveDetailPanel
extends DetailPanel {
    private CustomTabbedPane tabbedPane = new CustomTabbedPane();
    private JPanel propertiesTab = new JPanel();
    private JPanel graphicalTab = new JPanel();
    private PhysicalDriveGraphicalView graphicalView;
    private JComboBox logicalDriveSel = null;
    private OperationViewPanel opView;
    private PhysicalDriveHelper phy;
    private String[] mnemonics;

    public PhysicalDriveDetailPanel(PhysicalDriveHelper physicalDriveHelper, MainFrame mainFrame) {
        super(physicalDriveHelper, mainFrame);
        this.phy = physicalDriveHelper;
        this.tabbedPane.addTab(Resource.getString("PROPERTY_TAB_TEXT", "Properties"), null, new JScrollPane(this.propertiesTab), Resource.getString("PROPERTY_TAB_TEXT", "Properties"));
        this.init();
        physicalDriveHelper.addObserver(this);
    }

    @Override
    public void init() {
        this.propertiesTab.removeAll();
        this.graphicalTab.removeAll();
        AdapterHelper adapterHelper = (AdapterHelper)this.phy.getParent();
        LogicalDriveHelper[] logicalDriveHelperArray = adapterHelper.getLogicalDrives();
        this.populateLogicalDriveCombo(logicalDriveHelperArray);
        this.propertiesTab.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        PropertyViewPanel propertyViewPanel = new PropertyViewPanel(this.phy.getPropertyList());
        this.propertiesTab.add((Component)propertyViewPanel, "North");
        this.graphicalView = new PhysicalDriveGraphicalView(this.phy);
        this.graphicalTab.setLayout(new FlowLayout(1, MainFrame.SCREEN_SIZE.width * 40 / 1024, MainFrame.SCREEN_SIZE.height * 20 / 768));
        this.graphicalTab.add(this.graphicalView);
        Color[] colorArray = new Color[]{ColorHash.getColor("GRAPHICAL_VIEW_USED"), ColorHash.brighterColor(ColorHash.getColor("GRAPHICAL_VIEW_UNUSED"), -30), ColorHash.getColor("GRAPHICAL_VIEW_UNUSABLE"), ColorHash.getColor("GRAPHICAL_VIEW_HIGHLIGHTED")};
        String[] stringArray = new String[]{Resource.getString("LEGEND_USED_TEXT", "Configured"), Resource.getString("LEGEND_UNUSED_TEXT", "Available"), Resource.getString("LEGEND_UNUSABLE_TEXT", "Reserved"), Resource.getString("LEGEND_HIGHLIGHTED_TEXT", "Selected VD")};
        JPanel jPanel = new JPanel(new BorderLayout(0, 20));
        jPanel.add((Component)new GraphicalViewColorCodes(colorArray, stringArray), "North");
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_VIRTUAL_DISK_TEXT", "Select Virtual Disk"));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        jLabel.setLabelFor(this.logicalDriveSel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)this.logicalDriveSel, "Center");
        jPanel.add((Component)jPanel2, "Center");
        this.graphicalTab.add(jPanel);
        this.logicalDriveSel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (PhysicalDriveDetailPanel.this.logicalDriveSel.getSelectedIndex() <= 0) {
                    PhysicalDriveDetailPanel.this.graphicalView.highLightLogicalDrive(null);
                } else {
                    PhysicalDriveDetailPanel.this.graphicalView.highLightLogicalDrive((LogicalDriveHelper)PhysicalDriveDetailPanel.this.logicalDriveSel.getSelectedItem());
                }
            }
        });
        this.opView = new OperationViewPanel(this.phy, 15);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.opView, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout());
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_OPERATION_GO", "Go"));
        JButton jButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        jButton.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 120 / 1024, MainFrame.SCREEN_SIZE.height * 30 / 768));
        jButton.setToolTipText(Resource.getString("BUTTON_OPERATION_GO_DSC", "Go"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                OperationDetails operationDetails = PhysicalDriveDetailPanel.this.opView.getSelectedOperation();
                PhysicalDriveDetailPanel.this.opView.invokeOperation();
                if (operationDetails != null && operationDetails.getOpcode() == 34275584 && !((object = operationDetails.getParam()) instanceof VKOperationFailedException) && object instanceof ArrayList) {
                    PhysicalDriveHelper physicalDriveHelper = null;
                    ArrayList arrayList = (ArrayList)operationDetails.getParam();
                    if (arrayList != null && arrayList.size() > 0 && (physicalDriveHelper = (PhysicalDriveHelper)arrayList.get(2)) != null) {
                        System.out.println("destPDHelper: " + physicalDriveHelper);
                        String string = PhysicalDriveDetailPanel.this.phy.getCopyBackPDText() + " " + Resource.getString("MSG_REPLACE_BY", "will be\nreplaced by") + " " + physicalDriveHelper.getCopyBackPDText();
                        string = string + Resource.getString("MSG_REPLACE_BY1", ".\n\nThis may take some time. Go to the show\nprogress option to view the progress of this\nreplacement or abort the operation.");
                        new CustomMsgBox(VivaldiStartupDialog.mainScreen, string, Resource.getString("MSG_REPLACE_PHYSICAL_DISK_INFO_TITLE", "Replace Drive"), 1);
                        PhysicalDriveDetailPanel.this.opView.disableSelectedOperation();
                        PhysicalDriveDetailPanel.this.opView.setSelectedOperation(0);
                    }
                }
            }
        });
        jPanel4.add(jButton);
        if (this.phy.getM_opList_size() == 0) {
            if (this.tabbedPane.getTabCount() == 3 && MainFrame.fullAccess) {
                this.tabbedPane.removeTabAt(1);
                this.tabbedPane.setSelectedIndex(0);
            }
        } else if (this.tabbedPane.getTabCount() == 3 || MainFrame.fullAccess) {
            // empty if block
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void afterInvokation(OperationDetails operationDetails) {
        Object object;
        System.out.println("In physical drive afterInvokation");
        if (operationDetails != null && operationDetails.getOpcode() == 34275584 && !((object = operationDetails.getParam()) instanceof VKOperationFailedException) && object instanceof ArrayList) {
            PhysicalDriveHelper physicalDriveHelper = null;
            ArrayList arrayList = (ArrayList)operationDetails.getParam();
            if (arrayList != null && arrayList.size() > 0 && (physicalDriveHelper = (PhysicalDriveHelper)arrayList.get(2)) != null) {
                System.out.println("destPDHelper: " + physicalDriveHelper);
                String string = this.phy.getCopyBackPDText() + " " + Resource.getString("MSG_REPLACE_BY", "will be\nreplaced by") + " " + physicalDriveHelper.getCopyBackPDText();
                string = string + Resource.getString("MSG_REPLACE_BY1", ".\n\nThis may take some time. Go to the show\nprogress option to view the progress of this\nreplacement or abort the operation.");
                new CustomMsgBox(VivaldiStartupDialog.mainScreen, string, Resource.getString("MSG_REPLACE_PHYSICAL_DISK_INFO_TITLE", "Replace Drive"), 1);
            }
        }
    }

    private void populateLogicalDriveCombo(LogicalDriveHelper[] logicalDriveHelperArray) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(Resource.getString("COMBO_SELECTLDRIVE_TEXT", "-- Select Virtual Disk (VD) --"));
        for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
            vector.add(logicalDriveHelperArray[i]);
        }
        this.logicalDriveSel = new CustomComboBox((Vector)vector);
        this.logicalDriveSel.setBackground(ColorHash.getColor("GENERAL_BKGROUND"));
        this.logicalDriveSel.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 120 / 1024, 20));
        this.logicalDriveSel.setToolTipText(Resource.getString("LOGICAL_DRIVE_DSC", "Logical Drive"));
    }

    @Override
    public boolean canClose() {
        this.phy.deleteObserver(this);
        return true;
    }

    @Override
    public void gotoTab(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    @Override
    public int getTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        switch (n) {
            case 84: 
            case 94: 
            case 103: 
            case 276: 
            case 279: {
                break;
            }
            case 303: {
                super.update(observable, object);
                break;
            }
            default: {
                this.init();
                this.setOperationMenu();
                this.validate();
                this.repaint();
            }
        }
    }

    @Override
    public JMenu getSubMenu(JMenu jMenu) {
        int n = jMenu.getItemCount();
        JMenu jMenu2 = null;
        for (int i = 0; i < n; ++i) {
            jMenu2 = (JMenu)jMenu.getItem(i);
            if (!jMenu2.getName().trim().equals("Physical Drive")) continue;
            return jMenu2;
        }
        return jMenu2;
    }

    @Override
    public void populateOperationMenu(JMenu jMenu, OperationDetails operationDetails) {
        if (jMenu == null) {
            return;
        }
        switch (operationDetails.getOpcode()) {
            case 1127: {
                String[] stringArray;
                AdapterHelper adapterHelper = (AdapterHelper)this.phy.getParent();
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.phy.getDeviceObject();
                if (this.phy.getmediaType() == '\u0002' && sASPhysicalDrive.getInformation().getproperties_MR_PD_INFO().getUseSSEraseType() != 0 && sASPhysicalDrive.getState() == 0) {
                    String[] stringArray2 = Resource.getResourceMnemonic(Resource.getString("PHDRIVE_ERASE_OP", "Drive (E)rase"));
                    JMenuItem jMenuItem = new JMenuItem(stringArray2[0]);
                    jMenuItem.setMnemonic(stringArray2[1].charAt(0));
                    jMenuItem.setToolTipText(Resource.getString("CSA_PD_ERASE_TOOLTIP_TEXT", " Erases the contents of the Nytro\u2122 flash module."));
                    jMenuItem.setEnabled(true);
                    jMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                String string = Resource.getString("CSA_PHDRIVE_ERASE_OP_DESC", "<html> This operation erases the contents of the Nytro\u2122 flash module. <br><br>Are you sure you want to proceed? </html>");
                                if (CustomMsgBox.confirm(string.toString())) {
                                    SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)PhysicalDriveDetailPanel.this.phy.getDeviceObject();
                                    OperationDetails operationDetails = new OperationDetails(34537728, sASPhysicalDrive.getInformation());
                                    int n = 128;
                                    operationDetails.setArgument(n);
                                    try {
                                        sASPhysicalDrive.fireOperation(operationDetails);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    });
                    break;
                }
                if (this.phy.isFDECapable()) {
                    String[] stringArray3 = Resource.getResourceMnemonic(Resource.getString("PHDRIVE_SECURE_ERASE_OP", "Instant Secure (E)rase"));
                    JMenuItem jMenuItem = new JMenuItem(stringArray3[0]);
                    jMenuItem.setMnemonic(stringArray3[1].charAt(0));
                    jMenuItem.setToolTipText(Resource.getString("PHDRIVE_SECURE_ERASE_OP_DESC", "Securely erases the drive, removing drive security."));
                    jMenuItem.setEnabled(sASPhysicalDrive.getState() != 24 && sASPhysicalDrive.getState() != 64);
                    jMenuItem.addActionListener(new SecureEraseAction());
                    jMenu.add(jMenuItem);
                    break;
                }
                if (sASPhysicalDrive.getState() != 0 || sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getSecured()) break;
                boolean bl = true;
                try {
                    sASPhysicalDrive.updateAllAllowedOperations();
                    stringArray = sASPhysicalDrive.getAllAllowedOperations();
                    if (!stringArray.canStartSecureEraseNonSED()) {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!bl) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("PHDRIVE_ERASE_OP", "Drive (E)rase"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                jMenuItem.setMnemonic(stringArray[1].charAt(0));
                jMenuItem.setToolTipText(Resource.getString("PHDRIVE_ERASE_OP_DESC", "Drive erase operation overwrites the drive with pre-defined pattern(s), erasing all the data present on it."));
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new PDSecureEraseAction());
                jMenu.add(jMenuItem);
            }
        }
    }

    class PDSecureEraseAction
    implements ActionListener {
        PDSecureEraseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PhysicalDriveEraseDialog physicalDriveEraseDialog = new PhysicalDriveEraseDialog(PhysicalDriveDetailPanel.this.phy);
            physicalDriveEraseDialog.buildUI();
        }
    }

    class SecureEraseAction
    implements ActionListener {
        SecureEraseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConfirmSecureEraseDialog confirmSecureEraseDialog = new ConfirmSecureEraseDialog(PhysicalDriveDetailPanel.this.phy);
            confirmSecureEraseDialog.buildUI();
            if (confirmSecureEraseDialog.getSelectedOption() == 0) {
                AdapterHelper adapterHelper = (AdapterHelper)PhysicalDriveDetailPanel.this.phy.getParent();
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)PhysicalDriveDetailPanel.this.phy.getDeviceObject();
                try {
                    if (sASPhysicalDrive.getAllAllowedOperations().isReprovisionAllowed()) {
                        PhysicalDriveDetailPanel.this.phy.issueOperation(new OperationDetails(34341632, null));
                    }
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    vKOperationFailedException.printStackTrace();
                }
                catch (VKInvalidOperationException vKInvalidOperationException) {
                    vKInvalidOperationException.printStackTrace();
                }
                catch (VKNotRespondingException vKNotRespondingException) {
                    vKNotRespondingException.printStackTrace();
                }
                if (adapterHelper.isSecuritySupported() && PhysicalDriveDetailPanel.this.phy.isSecureForeign() && PhysicalDriveDetailPanel.this.phy.isSecureLocked()) {
                    PhysicalDriveDetailPanel.this.phy.issueOperation(new OperationDetails(34341120, null));
                }
            }
        }
    }
}

