/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.VivaldiBaseDialog;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PhysicalDriveEraseDialog
extends VivaldiBaseDialog {
    private JRadioButton simpleModeRadioButton = null;
    private JRadioButton normalModeRadioButton = null;
    private JRadioButton thoroughModeRadioButton = null;
    private PhysicalDriveHelper m_pdHelper;
    private int m_iEraseMode = 0;
    private String m_strEraseMode = "Simple";

    public PhysicalDriveEraseDialog(PhysicalDriveHelper physicalDriveHelper) {
        this.m_pdHelper = physicalDriveHelper;
    }

    public void buildUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        String[] stringArray = null;
        ButtonGroup buttonGroup = new ButtonGroup();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 15, 0, 0);
        jPanel.add((Component)new JLabel(Resource.getString("DESC_PD_ERASE", " <html>Drive Erase operates on a specified drive and overwrites all user-accessible sectors with the<br>specified pattern for the specified number of passes. <br> <br>Select the mode for Drive Erase operation: </html>")), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("ERASE_MODE_SIMPLE_BUTTON", "(S)imple"));
        this.simpleModeRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.simpleModeRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.simpleModeRadioButton.setSelected(true);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)this.simpleModeRadioButton, gridBagConstraints);
        buttonGroup.add(this.simpleModeRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 0, 15);
        jPanel.add((Component)new JLabel(Resource.getString("PD_ERASE_MODE_SIMPLE_DESC", "<html>Specifies a single pass erase operation that writes pattern A to the physical drive</html>")), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("ERASE_MODE_NORMAL_BUTTON", "(N)ormal"));
        this.normalModeRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.normalModeRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)this.normalModeRadioButton, gridBagConstraints);
        buttonGroup.add(this.normalModeRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 0, 15);
        jPanel.add((Component)new JLabel(Resource.getString("PD_ERASE_MODE_NORMAL_DESC", "<html>Specifies a three pass erase operation that first overwrites the physical drive contents with<br>random values then overwrites it with pattern A and then overwrites it with pattern B</html>")), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("ERASE_MODE_THOROUGH_BUTTON", "(T)horough"));
        this.thoroughModeRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.thoroughModeRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)this.thoroughModeRadioButton, gridBagConstraints);
        buttonGroup.add(this.thoroughModeRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 0, 15);
        jPanel.add((Component)new JLabel(Resource.getString("PD_ERASE_MODE_THOROUGH_DESC", "<html>Specifies a nine pass erase operation that repeats the normal mode thrice.</html>")), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 10, 10));
        stringArray = Resource.getResourceMnemonic(Resource.getString("OK_BUTTON_TEXT", "(O)K"));
        JButton jButton = new JButton(stringArray[0]);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "(C)ancel"));
        JButton jButton2 = new JButton(stringArray[0]);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(25, 0, 15, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PhysicalDriveEraseDialog.this.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PhysicalDriveEraseDialog.this.dispose();
                OperationDetails operationDetails = null;
                if (PhysicalDriveEraseDialog.this.simpleModeRadioButton.isSelected()) {
                    PhysicalDriveEraseDialog.this.setEraseMode(0);
                    PhysicalDriveEraseDialog.this.m_strEraseMode = "Simple";
                } else if (PhysicalDriveEraseDialog.this.normalModeRadioButton.isSelected()) {
                    PhysicalDriveEraseDialog.this.setEraseMode(1);
                    PhysicalDriveEraseDialog.this.m_strEraseMode = "Normal";
                } else if (PhysicalDriveEraseDialog.this.thoroughModeRadioButton.isSelected()) {
                    PhysicalDriveEraseDialog.this.setEraseMode(2);
                    PhysicalDriveEraseDialog.this.m_strEraseMode = "Thorough";
                }
                StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_PD_ERASE_DESC1", "<html> You have chosen to perform Drive Erase operation in"));
                stringBuffer.append(" ").append(PhysicalDriveEraseDialog.this.m_strEraseMode);
                stringBuffer.append(Resource.getString("CONFIRM_PD_ERASE_DESC2", "<br> mode on the selected drive. This will take several minutes to complete. This is a <br> destructive operation and will wipe out all the data present on the drive. <br> <br> Are you sure you want to proceed? </html>"));
                if (CustomMsgBox.confirm(stringBuffer.toString())) {
                    PhysicalDriveEraseDialog.this.dispose();
                    SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)PhysicalDriveEraseDialog.this.m_pdHelper.getDeviceObject();
                    operationDetails = new OperationDetails(34537728, sASPhysicalDrive.getInformation());
                    operationDetails.setArgument(PhysicalDriveEraseDialog.this.m_iEraseMode);
                    try {
                        sASPhysicalDrive.fireOperation(operationDetails);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.add(jPanel);
        this.setTitle(Resource.getString("DRIVE_ERASE_TITLE", "Mode Selection \u2013 Drive Erase"));
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    private void setEraseMode(int n) {
        this.m_iEraseMode = n;
    }
}

