/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MainFrame;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.ISASObject;
import Services.UsageInfo;
import Utils.ColorHash;
import Utils.Cylinder3D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JPanel;

public class PhysicalDriveGraphicalView
extends JPanel {
    private Vector usageList;
    private LogicalDriveHelper logicalDrvSel = null;
    private long totalSector;
    private int MAXWIDTH;
    private int MAXHEIGHT;
    private int CAPHEIGHT;

    public PhysicalDriveGraphicalView(PhysicalDriveHelper physicalDriveHelper) {
        this.usageList = physicalDriveHelper.getUsageDetails();
        this.MAXWIDTH = 160 * MainFrame.SCREEN_SIZE.width / 1024;
        this.MAXHEIGHT = 255 * MainFrame.SCREEN_SIZE.height / 768;
        this.CAPHEIGHT = 30 * MainFrame.SCREEN_SIZE.height / 768;
        this.totalSector = physicalDriveHelper.getDeviceObject().getSize();
        this.setPreferredSize(new Dimension(this.MAXWIDTH + 30, this.MAXHEIGHT + this.CAPHEIGHT * 3));
    }

    public void highLightLogicalDrive(LogicalDriveHelper logicalDriveHelper) {
        this.logicalDrvSel = logicalDriveHelper;
        this.getParent().validate();
        this.getParent().repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        int n = (this.getWidth() - this.MAXWIDTH) / 2;
        int n2 = (this.getHeight() - this.MAXHEIGHT) / 2;
        Cylinder3D cylinder3D = new Cylinder3D(graphics, n, n2, this.MAXWIDTH, this.MAXHEIGHT, 30, ColorHash.getColor("BORDER_COLOR"), ColorHash.getColor("GRAPHICAL_VIEW_UNUSED"), Color.white);
        if (this.usageList == null) {
            return;
        }
        for (int i = 0; i < this.usageList.size(); ++i) {
            UsageInfo usageInfo = (UsageInfo)this.usageList.get(i);
            int n3 = (int)(usageInfo.getStartSector() * (long)this.MAXHEIGHT / this.totalSector);
            int n4 = (int)(usageInfo.getEndSector() * (long)this.MAXHEIGHT / this.totalSector);
            Color color = usageInfo.getSASObject() == null ? ColorHash.getColor("GRAPHICAL_VIEW_UNUSABLE") : (this.logicalDrvSel != null && this.logicalDrvSel.getDeviceObject().getID() == ((ISASObject)usageInfo.getSASObject()).getID() ? ColorHash.getColor("GRAPHICAL_VIEW_HIGHLIGHTED") : ColorHash.getColor("GRAPHICAL_VIEW_USED"));
            cylinder3D.fillCylinder(n3, n4, color);
        }
    }
}

