/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import Services.LogXMLParser;
import Utils.Resource;
import Utils.TableSorter;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class PopupViewPanel
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel allButtonsPanel = new JPanel(new BorderLayout());
    private JPanel buttonsPanel = new JPanel(new FlowLayout());
    private JPanel dismisallPanel = new JPanel(new FlowLayout());
    GridBagConstraints gbc = new GridBagConstraints();
    JPanel bannerPanel = new JPanel(new BorderLayout());
    JButton abortButton;
    static PopupViewPanel test = null;
    private JButton dismissallButton = null;
    private JButton dismissButton = null;
    private JButton openItemButton = null;
    private JPanel labelPanel = new JPanel(new BorderLayout());
    JTable table = null;
    Timer timer = null;
    int serialNumber = 0;
    DefaultTableModel tableModel = null;
    JLabel imageLabel = null;
    JLabel descriptionLabel = null;
    public static boolean isWindows = false;
    public TableSorter tableSorter = null;
    ImageIcon imageIcon = null;
    public static int OEM_TYPE;

    public PopupViewPanel(int n) {
        OEM_TYPE = n;
    }

    public void displayTree(String string, JPanel jPanel) {
        try {
            String string2;
            switch (OEM_TYPE) {
                case 71244: {
                    string2 = Resource.getPopupString("PRODUCT_INFO", "MegaRAID Storage Manager");
                    break;
                }
                case 2561: {
                    string2 = Resource.getPopupString("PRODUCT_INFO2", "Dell SAS RAID Storage Manager");
                    break;
                }
                case 98761: {
                    string2 = Resource.getPopupString("PRODUCT_INFO1", "RAID Web Console 2");
                    break;
                }
                default: {
                    String string3 = Resource.getPopupString("PRODUCT_INFO", "MegaRAID Storage Manager");
                    return;
                }
            }
            String string4 = string2 + " " + string;
            String string5 = System.getProperty("os.name");
            if (string5.contains("Windows")) {
                isWindows = true;
            }
            if (isWindows) {
                UIManager.setLookAndFeel(WindowsLookAndFeel.class.getName());
            } else {
                UIManager.setLookAndFeel(UIManager.getInstalledLookAndFeels()[0].getClassName());
            }
            int n = Toolkit.getDefaultToolkit().getScreenSize().height > 700 ? 250 : 300;
            int n2 = Toolkit.getDefaultToolkit().getScreenSize().width > 1000 ? 430 : 480;
            int n3 = 85;
            int n4 = Toolkit.getDefaultToolkit().getScreenSize().width * 180 / 800;
            this.bannerPanel.add((Component)jPanel, "South");
            this.imageLabel = new JLabel("", 2);
            this.descriptionLabel = new JLabel("", 2);
            this.labelPanel.setBorder(new LineBorder(Color.gray));
            this.allButtonsPanel.add((Component)this.buttonsPanel, "East");
            this.labelPanel.setLayout(new BoxLayout(this.labelPanel, 1));
            this.labelPanel.add(this.bannerPanel);
            this.labelPanel.add(this.imageLabel);
            this.labelPanel.add(this.descriptionLabel);
            this.tableModel = new DefaultTableModel();
            this.tableSorter = new TableSorter(this.tableModel);
            String[] stringArray = null;
            stringArray = Resource.getResourceMnemonic(Resource.getPopupString("POPUP_ALERTS_LABEL", "A(l)erts"));
            JLabel jLabel = new JLabel(stringArray[0]);
            jLabel.setHorizontalAlignment(2);
            if (stringArray.length == 2) {
                jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            JPanel jPanel2 = new JPanel();
            stringArray = Resource.getResourceMnemonic(Resource.getPopupString("LOGGERHEADER_ERRORLEVEL_TEXT", "Error Level"));
            this.tableModel.addColumn(stringArray[0]);
            stringArray = Resource.getResourceMnemonic(Resource.getPopupString("LOGGERHEADER_DATETIME_TEXT", "Date / Time"));
            this.tableModel.addColumn(stringArray[0]);
            stringArray = Resource.getResourceMnemonic(Resource.getPopupString("LOGGERHEADER_DESCRIPTION_TEXT", "Description"));
            this.tableModel.addColumn(stringArray[0]);
            this.table = new JTable(this.tableSorter){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() >= 2) {
                        PopupViewPanel.this.openItemOption();
                    }
                }
            });
            this.tableSorter.addMouseListenerToHeaderInTable(this.table);
            int n5 = 0;
            PopupCellRenderer popupCellRenderer = new PopupCellRenderer();
            TableColumn tableColumn = this.table.getColumnModel().getColumn(n5);
            tableColumn.setCellRenderer(popupCellRenderer);
            this.table.setSelectionMode(0);
            this.table.setAutoResizeMode(0);
            this.table.setAutoscrolls(true);
            this.table.setOpaque(true);
            SelectionListener selectionListener = new SelectionListener(this.table);
            this.table.getSelectionModel().addListSelectionListener(selectionListener);
            this.table.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
            JScrollPane jScrollPane = new JScrollPane(this.table, 20, 30);
            JPanel jPanel3 = new JPanel();
            int n6 = Toolkit.getDefaultToolkit().getScreenSize().width * 400 / 1024;
            int n7 = Toolkit.getDefaultToolkit().getScreenSize().height * 35 / 250;
            int n8 = n6 / 10;
            this.table.getColumnModel().getColumn(0).setPreferredWidth(2 * n8);
            this.table.getColumnModel().getColumn(1).setPreferredWidth(3 * n8);
            this.table.getColumnModel().getColumn(2).setPreferredWidth(5 * n8);
            jLabel.setLabelFor(jPanel3);
            jPanel2.add((Component)jLabel, "North");
            jPanel3.add((Component)jPanel2, "North");
            jPanel3.add(jScrollPane);
            jScrollPane.setPreferredSize(new Dimension(n6, n7));
            stringArray = Resource.getResourceMnemonic(Resource.getPopupString("POPUP_DISMISS_ALL", "Dismiss (A)ll"));
            this.dismissallButton = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.dismissallButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.dismissallButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (JOptionPane.showConfirmDialog(PopupViewPanel.this.getContentPane(), Resource.getPopupString("POPUP_DELETE_ALL", "Are you sure you want to Delete All?"), Resource.getPopupString("POPUP_NOTIFICATION_TITLE", "Event Notification Application"), 0) == 0) {
                        DefaultTableModel defaultTableModel = (DefaultTableModel)PopupViewPanel.this.tableSorter.getModel();
                        defaultTableModel.getDataVector().removeAllElements();
                        PopupViewPanel.this.setVisible(false);
                    }
                }
            });
            this.dismissallButton.setToolTipText(Resource.getPopupString("POPUP_DISMISS_ALL", "Dismiss All"));
            this.dismisallPanel.add(this.dismissallButton);
            this.allButtonsPanel.add((Component)this.dismisallPanel, "West");
            stringArray = Resource.getResourceMnemonic(Resource.getPopupString("POPUP_OPEN_ITEM", "(O)pen Item"));
            this.openItemButton = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.openItemButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.openItemButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PopupViewPanel.this.openItemOption();
                }
            });
            this.openItemButton.setToolTipText(Resource.getPopupString("POPUP_OPEN_ITEM", "Open Item"));
            this.buttonsPanel.add(this.openItemButton);
            stringArray = Resource.getResourceMnemonic(Resource.getPopupString("POPUP_DISMISS", "(D)ismiss"));
            this.dismissButton = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.dismissButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.dismissButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = PopupViewPanel.this.table.getSelectedRow();
                    if (n != -1) {
                        if (JOptionPane.showConfirmDialog(PopupViewPanel.this.getContentPane(), Resource.getPopupString("POPUP_DELETE_ITEM", "Are you sure you want to Delete ?"), Resource.getPopupString("POPUP_NOTIFICATION_TITLE", "Event Notification Application"), 0) == 0) {
                            int[] nArray = PopupViewPanel.this.tableSorter.getSortedRowIndexes();
                            PopupViewPanel.this.tableModel.removeRow(nArray[n]);
                            nArray = PopupViewPanel.this.tableSorter.getSortedRowIndexes();
                            System.out.println("indeces length is :" + nArray.length);
                            System.out.println("table row size is :" + PopupViewPanel.this.table.getRowCount());
                            if (PopupViewPanel.this.table.getRowCount() > 0) {
                                if (PopupViewPanel.this.table.getRowCount() == 1) {
                                    PopupViewPanel.this.table.changeSelection(0, 0, false, false);
                                } else if (n == 0) {
                                    PopupViewPanel.this.table.changeSelection(0, 0, false, false);
                                } else {
                                    PopupViewPanel.this.table.changeSelection(nArray[n - 1], 0, false, false);
                                }
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, Resource.getPopupString("POPUP_SELECT_ROW_DELETE", "Please select the row to delete"));
                    }
                }
            });
            this.dismissButton.setToolTipText(Resource.getPopupString("POPUP_DISMISS", "Dismiss"));
            this.buttonsPanel.add(this.dismissButton);
            this.dismissallButton.setEnabled(true);
            this.dismissButton.setEnabled(false);
            this.openItemButton.setEnabled(false);
            this.labelPanel.setPreferredSize(new Dimension(n4, n3));
            this.add((Component)this.labelPanel, "North");
            this.add(jPanel3);
            this.add((Component)this.allButtonsPanel, "South");
            this.setSize(Toolkit.getDefaultToolkit().getScreenSize().width * n2 / 1024, Toolkit.getDefaultToolkit().getScreenSize().height * n / 600);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    PopupViewPanel.this.windowClosingOption();
                }
            });
            Image image = Toolkit.getDefaultToolkit().getImage(Resource.getPopupString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
            this.setIconImage(image);
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - n2) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - n) / 2);
            this.setTitle(string4 + " - Alerts");
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void openItemOption() {
        int n = this.table.getSelectedRow();
        if (n != -1) {
            JDialog jDialog;
            int n2;
            String string = "";
            for (n2 = 0; n2 < this.tableSorter.getColumnCount(); ++n2) {
                string = (String)this.tableSorter.getValueAt(n, 2);
            }
            n2 = (Integer)this.tableSorter.getValueAt(n, 0);
            System.out.println("messageType :" + n2);
            JOptionPane jOptionPane = new JOptionPane(string, this.getJDialogMessageType(n2));
            if (jOptionPane != null && (jDialog = jOptionPane.createDialog(this.getContentPane(), Resource.getString("POPUP_NOTIFICATION_TITLE", "Event Notification Application"))) != null) {
                jDialog.setModalityType(Dialog.ModalityType.MODELESS);
                jDialog.setVisible(true);
            }
        } else {
            JOptionPane.showMessageDialog(null, Resource.getPopupString("POPUP_SELECT_ROW_DISPLAY", "Please select the row to display"));
        }
    }

    private void windowClosingOption() {
        if (JOptionPane.showConfirmDialog(this.getContentPane(), Resource.getPopupString("POPUP_EXIT_CONFIRMATION", "Are you sure you want to exit?"), Resource.getPopupString("POPUP_NOTIFICATION_TITLE", "Event Notification Application"), 0) == 0) {
            this.setVisible(false);
        }
    }

    public void addRow(String string, String string2, int n) {
        if (this.table != null) {
            LogXMLParser logXMLParser;
            if (this.table.getRowCount() <= 0) {
                this.table.clearSelection();
            }
            string = (logXMLParser = new LogXMLParser(string)).getTagValue("yyyy") == null && logXMLParser.getTagValue("month") == null && logXMLParser.getTagValue("dd") == null && logXMLParser.getTagValue("hh") == null && logXMLParser.getTagValue("mm") == null ? (logXMLParser.getTagValue("ss") != null ? logXMLParser.getTagValue("ss") + "  " + Resource.getPopupString("TEXT_SEC_FRM_REBOOT", " seconds from reboot") : Resource.getPopupString("TEXT_NOT_AVAILABLE", "Not available")) : logXMLParser.getTagValue("yyyy") + "-" + logXMLParser.getTagValue("month") + "-" + logXMLParser.getTagValue("dd") + ", " + logXMLParser.getTagValue("hh") + ":" + logXMLParser.getTagValue("mm") + ":" + logXMLParser.getTagValue("ss");
            this.tableModel.insertRow(0, new Object[]{n, string, string2});
            this.table.changeSelection(0, 0, false, false);
            this.setVisible(true);
            this.setFocusable(true);
            this.setAlwaysOnTop(true);
            this.setState(0);
        }
    }

    public ImageIcon getImageIcon(int n) {
        ImageIcon imageIcon = null;
        if (n == 0) {
            imageIcon = Resource.getImage("INFO_IMAGE", "info.png");
        } else if (n == 1) {
            imageIcon = Resource.getImage("WARNING_IMAGE", "warning.png");
        } else if (n == 2) {
            imageIcon = Resource.getImage("ERROR_IMAGE", "error.png");
        } else if (n == 3) {
            imageIcon = Resource.getImage("FATAL_IMAGE", "fatal.png");
        }
        return imageIcon;
    }

    public String getMessageInfo(int n) {
        String string = "";
        if (n == 0) {
            string = Resource.getPopupString("INFO", "Information");
        } else if (n == 1) {
            string = Resource.getPopupString("WARN", "Warning");
        } else if (n == 2) {
            string = Resource.getPopupString("CRTL", "Critical");
        } else if (n == 3) {
            string = Resource.getPopupString("FATAL", "Fatal");
        }
        return string;
    }

    public int getJDialogMessageType(int n) {
        int n2 = 1;
        if (n == 0) {
            n2 = 1;
        } else if (n == 1) {
            n2 = 2;
        } else if (n == 2) {
            n2 = 0;
        } else if (n == 3) {
            n2 = 0;
        } else if (n == 4) {
            // empty if block
        }
        return n2;
    }

    class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            System.out.println("in valueChanged");
            if (listSelectionEvent.getSource().equals(this.table.getSelectionModel()) && this.table.getRowSelectionAllowed()) {
                if (this.table.getRowCount() > 0) {
                    PopupViewPanel.this.openItemButton.setEnabled(true);
                    PopupViewPanel.this.dismissButton.setEnabled(true);
                    PopupViewPanel.this.dismissallButton.setEnabled(true);
                    int n = this.table.getSelectedRow();
                    if (n > -1) {
                        int n2 = (Integer)this.table.getValueAt(n, 0);
                        String string = (String)this.table.getValueAt(n, 2);
                        String string2 = (String)this.table.getValueAt(n, 1);
                        ImageIcon imageIcon = PopupViewPanel.this.getImageIcon(n2);
                        String string3 = PopupViewPanel.this.getMessageInfo(n2);
                        PopupViewPanel.this.imageLabel.setIcon(imageIcon);
                        PopupViewPanel.this.imageLabel.setText(string3 + " " + string2 + " :");
                        PopupViewPanel.this.imageLabel.setToolTipText(string3);
                        PopupViewPanel.this.descriptionLabel.setText(string);
                    } else {
                        PopupViewPanel.this.openItemButton.setEnabled(false);
                        PopupViewPanel.this.dismissButton.setEnabled(false);
                        PopupViewPanel.this.imageLabel.setIcon(null);
                        PopupViewPanel.this.imageLabel.setText("");
                        PopupViewPanel.this.imageLabel.setToolTipText("");
                        PopupViewPanel.this.descriptionLabel.setText("");
                        this.table.changeSelection(0, 0, false, false);
                    }
                } else {
                    PopupViewPanel.this.setVisible(false);
                    PopupViewPanel.this.openItemButton.setEnabled(false);
                    PopupViewPanel.this.dismissButton.setEnabled(false);
                    PopupViewPanel.this.dismissallButton.setEnabled(false);
                    PopupViewPanel.this.imageLabel.setIcon(null);
                    PopupViewPanel.this.imageLabel.setText("");
                    PopupViewPanel.this.descriptionLabel.setText("");
                }
            }
        }
    }

    class PopupCellRenderer
    extends DefaultTableCellRenderer {
        PopupCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            System.out.println("in getTableCellRendererComponent :" + n);
            int n3 = Integer.parseInt(object.toString());
            ImageIcon imageIcon = PopupViewPanel.this.getImageIcon(n3);
            String string = PopupViewPanel.this.getMessageInfo(n3);
            JLabel jLabel = new JLabel();
            jLabel.setIcon(imageIcon);
            jLabel.setText(string);
            jLabel.setOpaque(true);
            jLabel.setBackground(jTable.getBackground());
            jLabel.setForeground(jTable.getForeground());
            jLabel.setToolTipText(string);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            }
            this.setHorizontalAlignment(0);
            return jLabel;
        }
    }
}

