/*
 * Decompiled with CFR 0.152.
 */
package GUI.PremiumFeatures;

import GUI.PremiumFeatures.PremiumFeature;
import GUI.PremiumFeatures.PremiumFeaturesDialog;
import GUI.PremiumFeatures.ReHostPanel;
import GUI.PremiumFeatures.ReHostWizard;
import GUI.PremiumFeatures.SecurePFConfirmation;
import GUI.PremiumFeatures.SecurePFWizard;
import GUI.venus.wizard.WizardController;
import GUI.venus.wizard.WizardNavigationException;
import GUIHelper.AdapterHelper;
import Utils.Resource;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class ConfigureKeyVaultPanel {
    private boolean rehostFlag;
    private boolean secureFlag;
    private AdapterHelper adapterHelper;
    private PremiumFeaturesDialog parent;
    private ArrayList<PremiumFeature> nonSecureFeatures = new ArrayList();
    public static final String RE_HOST_PAGE = "ReHost page";
    public static final int ADAPTER_HELPER = 0;
    public static final int PF_DIALOG = 1;
    public static final int SECURE_FEATURES = 2;
    public static final String REHOST_PAGE = "ReHostPage";
    public static final String SECURE_FEATURE_PAGE = "SecureFeaturePage";

    public ConfigureKeyVaultPanel(JDialog jDialog, AdapterHelper adapterHelper, boolean bl, ArrayList<PremiumFeature> arrayList) {
        this.rehostFlag = bl;
        this.secureFlag = arrayList != null;
        this.nonSecureFeatures = arrayList;
        this.parent = (PremiumFeaturesDialog)jDialog;
        this.adapterHelper = adapterHelper;
        this.buildPanel();
    }

    private void buildPanel() {
        block24: {
            if (this.rehostFlag && this.secureFlag) {
                try {
                    Object object;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (this.nonSecureFeatures != null) {
                        for (int i = 0; i < this.nonSecureFeatures.size(); ++i) {
                            object = this.nonSecureFeatures.get(i);
                            arrayList.add(((PremiumFeature)object).getFeatureName());
                        }
                    }
                    System.out.println("nonsecure features::" + arrayList);
                    WizardController wizardController = new WizardController();
                    object = wizardController.getWizardData();
                    ((HashMap)object).put(0, this.adapterHelper);
                    ((HashMap)object).put(1, this.parent);
                    ((HashMap)object).put(2, arrayList);
                    ((HashMap)object).put("WarningDialogTitle", Resource.getString("REHOST_WARNING_TITLE"));
                    wizardController.addPage(ReHostWizard.class.getName(), REHOST_PAGE);
                    wizardController.addPage(SecurePFWizard.class.getName(), SECURE_FEATURE_PAGE);
                    wizardController.setFirstPage(REHOST_PAGE);
                    wizardController.addPageTransition(REHOST_PAGE, 1, SECURE_FEATURE_PAGE);
                    wizardController.launchWizard();
                }
                catch (WizardNavigationException wizardNavigationException) {
                    wizardNavigationException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (this.rehostFlag) {
                try {
                    int n = new ReHostPanel(this.adapterHelper, this.parent).getSelectedOption();
                    if (n != 0) break block24;
                    try {
                        int n2 = this.parent.getPFKeyControllerHandle().securePremiumFeatures();
                        if (n2 == 0) {
                            this.parent.updateDialog();
                        } else if (n2 == 93 || n2 == 33) {
                            JOptionPane jOptionPane = new JOptionPane("Re-hosting cannot be completed because of the incompatible keyvault", 2);
                            JDialog jDialog = jOptionPane.createDialog("Incompatible Keyvault");
                            Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                            jDialog.setIconImage(image);
                            jDialog.setVisible(true);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (this.secureFlag) {
                int n;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (n = 0; n < this.nonSecureFeatures.size(); ++n) {
                    PremiumFeature premiumFeature = this.nonSecureFeatures.get(n);
                    arrayList.add(premiumFeature.getFeatureName());
                }
                System.out.println("nonsecure features::" + arrayList);
                n = new SecurePFConfirmation((Window)this.parent, arrayList).getSelectedOption();
                if (n == 0) {
                    try {
                        int n3 = this.parent.getPFKeyControllerHandle().securePremiumFeatures();
                        if (n3 == 0) {
                            this.parent.updateDialog();
                        } else if (n3 == 93 || n3 == 33) {
                            JOptionPane jOptionPane = new JOptionPane("MegaRAID Advanced Software Options cannot be secured because of the incompatible keyvault", 2);
                            JDialog jDialog = jOptionPane.createDialog("Incompatible Keyvault");
                            Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                            jDialog.setIconImage(image);
                            jDialog.setVisible(true);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }
}

