/*
 * Decompiled with CFR 0.152.
 */
package GUI.PremiumFeatures;

import GUI.PremiumFeatures.PremiumFeature;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_PF_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_PF_LIST;
import SASKernel.SASAdapter.SASAdapter;
import Utils.Resource;
import java.util.ArrayList;
import java.util.HashMap;

public class PFKeyController {
    private SASAdapter adapter;
    private String safeIdStr;
    private int timeRemaining;
    private short maxDisks;
    private static short maxHaNodes;
    private boolean isKeyvaultAccessible;
    private String ctrlSn = "";
    private String raidKeySn = "";
    private static final String CLUSTER_STR = "Cluster";
    private static final String SAS_STR = "SAS";
    private static final String RAID6_STR = "MegaRAID RAID6";
    private static final String WIDE_CACHE_STR = "Wide Cache";
    private static final String RAID5_STR = "MegaRAID RAID5";
    private static final String SECURITY_STR = "MegaRAID SafeStore";
    private static final String MAXDRIVES_STR = "Max Drives";
    private static final String CTIO_STR = "MegaRAID FastPath";
    private static final String SNAPSHOT_STR = "MegaRAID Recovery";
    private static final String SSC_STR = "MegaRAID CacheCade";
    private static final String SSCWB_STR = "MegaRAID CacheCade Pro 2.0";
    private static String MAXHANODES_STR;
    private static final String REDUCED_FEATURE_SET_STR = "Reduced Feature Set";
    private static final String CCOH_STR = "LSI Nytro XD";
    private static final String CACHE_VAULT_STR = "MegaRAID CacheVault";
    private static final short ENABLE = 1;
    public static final short[] premiumFeatureOrder;
    HashMap<Short, PremiumFeature> premiumFeatures = new HashMap();
    private boolean isNvramKeyPresent;
    private boolean isTrialKeyPresent;
    static short haNodes;

    public PFKeyController(SASAdapter sASAdapter) {
        this.adapter = sASAdapter;
        this.initialize();
    }

    private void initialize() {
        try {
            this.adapter.ctrlDataRefresh();
            try {
                this.setSafeIdStr(this.adapter.getSafeId());
            }
            catch (Exception exception) {
                System.out.println("got exp in getting safeid");
            }
            try {
                this.setCtrlSn(Resource.zeroTrim(this.adapter.getCtrlMfgInfo()));
            }
            catch (Exception exception) {
                System.out.println("got exp in getting ctrlsn");
            }
            try {
                this.setRaidKeySn(Resource.zeroTrim(this.adapter.getRaidKeyMfgInfo()));
            }
            catch (Exception exception) {
                System.out.println("got exp in getting raidKeysn");
                this.setRaidKeySn("");
            }
            this.setKeyvaultAccessible(this.adapter.getInformation().gethwPresent_MR_CTRL_INFO().getUpgradeKey() == 1);
            System.out.println("keyvault hw present:" + this.isKeyvaultAccessible());
            this.setTimeRemaining(this.adapter.getInformation().getPFKTrialTimeRemaining());
            System.out.println("time=" + this.getTimeRemaining());
            MR_PF_LIST mR_PF_LIST = this.adapter.getPremiumFeatures();
            System.out.println("got the features");
            this.convertToFeatureList(mR_PF_LIST);
        }
        catch (Exception exception) {
            System.out.println("got exception in getting features" + exception.getMessage());
        }
    }

    public int deActivateTrialKey() {
        int n = -1;
        try {
            n = this.adapter.deactivateTrialKeys();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public int securePremiumFeatures() {
        try {
            return this.adapter.securePremiumFeatures();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return vKOperationFailedException.GetErrorCode();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String getSafeIdStr() {
        return this.safeIdStr;
    }

    public void setSafeIdStr(String string) {
        this.safeIdStr = string;
    }

    public void convertToFeatureList(MR_PF_LIST mR_PF_LIST) {
        MR_PF_INFO mR_PF_INFO = mR_PF_LIST.getActiveFeatures();
        MR_PF_INFO mR_PF_INFO2 = mR_PF_LIST.getPrimaryFeatures();
        MR_PF_INFO mR_PF_INFO3 = mR_PF_LIST.getUpgradeFeatures();
        MR_PF_INFO mR_PF_INFO4 = mR_PF_LIST.getKeyvaultFeatures();
        MR_PF_INFO mR_PF_INFO5 = mR_PF_LIST.getNvramFeatures();
        MR_PF_INFO mR_PF_INFO6 = mR_PF_LIST.getTrialFeatures();
        MR_PF_INFO mR_PF_INFO7 = mR_PF_LIST.getBoottimeFeatures();
        for (int i = 0; i < premiumFeatureOrder.length; ++i) {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = bl = premiumFeatureOrder[i] == 3;
            if (mR_PF_INFO != null) {
                bl3 = mR_PF_INFO.getFeatureStatus(premiumFeatureOrder[i]);
                if (bl) {
                    this.setMaxDisks(mR_PF_INFO.getFeatures().getMaxDisks());
                }
                if ((haNodes = mR_PF_INFO.getFeatures().getEnableMaxHaNodes()) != 0) {
                    this.setMaxHaNodes(haNodes);
                }
            }
            if (mR_PF_INFO4 != null) {
                bl2 = mR_PF_INFO4.getFeatureStatus(premiumFeatureOrder[i]);
            }
            if (mR_PF_INFO3 != null && !bl2) {
                bl2 = mR_PF_INFO3.getFeatureStatus(premiumFeatureOrder[i]);
            }
            if (mR_PF_INFO2 != null) {
                System.out.println("inside factory");
                bl4 = mR_PF_INFO2.getFeatureStatus(premiumFeatureOrder[i]);
            }
            if (mR_PF_INFO5 != null) {
                bl5 = mR_PF_INFO5.getFeatureStatus(premiumFeatureOrder[i]);
            }
            if (mR_PF_INFO6 != null) {
                bl6 = mR_PF_INFO6.getFeatureStatus(premiumFeatureOrder[i]);
            }
            if (mR_PF_INFO7 != null) {
                bl7 = mR_PF_INFO7.getFeatureStatus(premiumFeatureOrder[i]);
            }
            if (!bl3) continue;
            String string = PFKeyController.getFeatureName(premiumFeatureOrder[i]);
            PremiumFeature premiumFeature = new PremiumFeature(premiumFeatureOrder[i], string, true, bl6, this.getTimeRemaining(), bl4, bl5, bl2, bl7);
            premiumFeature.setValidity(this.getTimeRemaining());
            premiumFeature.setFWSupported(this.isFWSupported(premiumFeatureOrder[i]));
            this.premiumFeatures.put(premiumFeatureOrder[i], premiumFeature);
        }
        this.isTrialKeyPresent = this.getTrialFeatureList().size() != 0;
        this.isNvramKeyPresent = this.getNvramFeatureList().size() != 0;
    }

    public boolean isFWSupported(short s) {
        switch (s) {
            case 1: {
                return this.adapter.getInformation().getclusterActive() != '\u0000';
            }
            case 4: {
                return this.adapter.getInformation().getraidLevels_MR_CTRL_INFO().getraidLevel_6() != 0;
            }
            case 6: {
                return this.adapter.getInformation().getraidLevels_MR_CTRL_INFO().getraidLevel_5() != 0;
            }
            case 7: {
                return this.adapter.getInformation().getadapterOperations_MR_CTRL_INFO().isSupportSecurity();
            }
            case 8: {
                return this.adapter.getInformation().getldOperations_MR_CTRL_INFO().getSupportFastPath() == 1;
            }
            case 9: {
                return this.adapter.getInformation().getadapterOperations_MR_CTRL_INFO().isSupportSnapshot();
            }
            case 10: {
                return this.adapter.getInformation().getMaxSSCsize() > 0;
            }
            case 13: {
                return this.adapter.getInformation().getldOperations_MR_CTRL_INFO().isSupportSSCWriteBack();
            }
            case 15: {
                return this.adapter.getInformation().getmaxHANodes() != 0 && this.adapter.getInformation().getadapterOperations_MR_CTRL_INFO().getclusterSupported() == 1;
            }
            case 2: 
            case 3: 
            case 5: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return true;
    }

    public static String getFeatureName(short s) {
        String string = null;
        switch (s) {
            case 1: {
                string = Resource.getString("CLUSTER_TEXT_PF", CLUSTER_STR);
                break;
            }
            case 2: {
                string = SAS_STR;
                break;
            }
            case 4: {
                string = RAID6_STR;
                break;
            }
            case 5: {
                string = Resource.getString("WIDE_CACHE_STR_1", WIDE_CACHE_STR);
                break;
            }
            case 6: {
                string = RAID5_STR;
                break;
            }
            case 7: {
                string = Resource.getString("SECURITY_STR_1", SECURITY_STR);
                break;
            }
            case 3: {
                string = Resource.getString("MAXDRIVES_STR_1", MAXDRIVES_STR);
                break;
            }
            case 8: {
                string = CTIO_STR;
                break;
            }
            case 9: {
                string = SNAPSHOT_STR;
                break;
            }
            case 10: {
                string = SSC_STR;
                break;
            }
            case 11: {
                string = Resource.getString("RED_FEATURE_SET", REDUCED_FEATURE_SET_STR);
                break;
            }
            case 12: {
                string = CACHE_VAULT_STR;
                break;
            }
            case 13: {
                string = SSCWB_STR;
                break;
            }
            case 14: {
                string = CCOH_STR;
                break;
            }
            case 15: {
                string = PFKeyController.getMAxHanodes();
            }
        }
        return string;
    }

    public static String getMAxHanodes() {
        Short s = new Short(haNodes);
        String string = s.toString();
        Integer n = 2;
        if (s == 1) {
            string = n.toString();
        }
        return MAXHANODES_STR + " " + string;
    }

    public ArrayList<PremiumFeature> getFeatureList() {
        ArrayList<PremiumFeature> arrayList = new ArrayList<PremiumFeature>();
        for (int i = 0; i < premiumFeatureOrder.length; ++i) {
            PremiumFeature premiumFeature = this.premiumFeatures.get(premiumFeatureOrder[i]);
            if (premiumFeature == null) continue;
            arrayList.add(premiumFeature);
        }
        return arrayList;
    }

    public ArrayList<PremiumFeature> getPrimaryFeatureList() {
        ArrayList<PremiumFeature> arrayList = new ArrayList<PremiumFeature>();
        for (int i = 0; i < premiumFeatureOrder.length; ++i) {
            PremiumFeature premiumFeature = this.premiumFeatures.get(premiumFeatureOrder[i]);
            if (premiumFeature == null || !premiumFeature.isStoredInFactory() || !premiumFeature.getLocationStr().equals(PremiumFeature.FACTORY_STR)) continue;
            arrayList.add(premiumFeature);
        }
        return arrayList;
    }

    public ArrayList<PremiumFeature> getNvramFeatureList() {
        ArrayList<PremiumFeature> arrayList = new ArrayList<PremiumFeature>();
        for (int i = 0; i < premiumFeatureOrder.length; ++i) {
            PremiumFeature premiumFeature = this.premiumFeatures.get(premiumFeatureOrder[i]);
            if (premiumFeature == null || !premiumFeature.isNonSecuredFeature()) continue;
            arrayList.add(premiumFeature);
        }
        return arrayList;
    }

    public ArrayList<PremiumFeature> getTrialFeatureList() {
        ArrayList<PremiumFeature> arrayList = new ArrayList<PremiumFeature>();
        for (int i = 0; i < premiumFeatureOrder.length; ++i) {
            PremiumFeature premiumFeature = this.premiumFeatures.get(premiumFeatureOrder[i]);
            if (premiumFeature == null || !premiumFeature.isRealTrialFeature()) continue;
            arrayList.add(premiumFeature);
        }
        return arrayList;
    }

    public HashMap<Short, PremiumFeature> getFeatureMap() {
        return this.premiumFeatures;
    }

    public boolean isNvramFeaturePresent() {
        return this.isNvramKeyPresent;
    }

    public boolean isTrialFeaturePresent() {
        return this.isTrialKeyPresent;
    }

    public int getTimeRemaining() {
        return this.timeRemaining;
    }

    public void setTimeRemaining(int n) {
        this.timeRemaining = n;
    }

    public boolean isKeyvaultAccessible() {
        return this.isKeyvaultAccessible;
    }

    public void setKeyvaultAccessible(boolean bl) {
        this.isKeyvaultAccessible = bl;
    }

    public short getMaxDisks() {
        return this.maxDisks;
    }

    public void setMaxDisks(short s) {
        this.maxDisks = s;
    }

    public short getMaxHaNodes() {
        return maxHaNodes;
    }

    public void setMaxHaNodes(short s) {
        maxHaNodes = s;
    }

    public String getCtrlSn() {
        return this.ctrlSn;
    }

    public void setCtrlSn(String string) {
        this.ctrlSn = string;
    }

    public String getRaidKeySn() {
        return this.raidKeySn;
    }

    public void setRaidKeySn(String string) {
        this.raidKeySn = string;
    }

    static {
        MAXHANODES_STR = "HA-DAS Nodes:";
        premiumFeatureOrder = new short[]{8, 9, 10, 13, 7, 4, 6, 12, 14, 15};
        haNodes = 1;
    }
}

