/*
 * Decompiled with CFR 0.152.
 */
package GUI.PremiumFeatures;

import Utils.Resource;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PremiumFeature {
    public static final int ENABLE = 1;
    public static final int DISABLE = 2;
    private static ImageIcon activatedImage = Resource.getImage("DEFAULT_HOST_IMAGE", "host.jpg");
    private static ImageIcon deActivatedImage = Resource.getImage("FAILED_IMAGE", "failed.png");
    public static final String ENABLE_STR = Resource.getString("PROPERTY_ENABLED", "Enabled");
    public static final String DISABLE_STR = Resource.getString("PROPERTY_DISABLED", "Disabled");
    public static final String SECURE_STR = Resource.getString("SECURE_STR", "Secured");
    public static final String NOT_SECURE_STR = Resource.getString("NON_SECURE_STR", "Not secured");
    public static final String FACTORY_STR = Resource.getString("FACTORY_INSTALLED_STR", "Factory installed");
    public static final String Boot_STR = "-";
    public static final String BOOTLABEL_STR = "Boot";
    public static final String UNKNOWN_STR = Resource.getString("ENCL_TYPE_UNKNOWN", "Unknown");
    public static final String UNLIMITED_STR = Resource.getString("UNLIMITED_STR", "Unlimited");
    public static final String TRIAL_EXPIRED_STR = Resource.getString("TRIAL_EXPIRED_STR", "Trial software- Expired");
    public static final String UNSUPPORTED_STR = Resource.getString("UNSUPPORTED_STR", "Unsupported");
    public static final String DEACTIVE_STR = Resource.getString("DEACTIVE_STR", "Feature will deactivate on restart");
    private short featureId;
    private String featureName;
    private boolean featureStatus;
    private boolean isTrialfeature;
    private boolean isStoredInFactory;
    private boolean isStoredInNvram;
    private boolean isStoredInKeyvault;
    private int validity;
    private boolean isFWSupported;
    private boolean isbootTime;
    private static final int minToDay = 1440;
    private static final int minToHrs = 60;

    public PremiumFeature(short s, String string, boolean bl) {
        this.featureId = s;
        this.featureName = string;
        this.featureStatus = bl;
    }

    public PremiumFeature(short s, String string, boolean bl, boolean bl2, int n, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.featureId = s;
        this.featureName = string;
        this.featureStatus = bl;
        this.isTrialfeature = bl2;
        this.validity = n;
        this.isStoredInFactory = bl3;
        this.isStoredInNvram = bl4;
        this.isStoredInKeyvault = bl5;
        this.isbootTime = bl6;
    }

    public String toString() {
        return "FeatureId=" + this.getFeatureId() + "FeatureName=" + this.getFeatureName() + "FeatureStatus=" + this.getFeatureStatus() + "isTrialfeature=" + this.isTrialfeature + "validity=" + this.validity + "isStoredInFactory=" + this.isStoredInFactory + "isStoredInNvram=" + this.isStoredInNvram + "isStoredInKeyvault=" + this.isStoredInKeyvault + "isbootime=" + this.isbootTime;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String string) {
        this.featureName = string;
    }

    public boolean getFeatureStatus() {
        return this.featureStatus;
    }

    public String getFeatureStatus(int n) {
        switch (n) {
            case 1: {
                return ENABLE_STR;
            }
            case 2: {
                return DISABLE_STR;
            }
        }
        return "" + n;
    }

    public static Icon getFeatureStatusIcon(int n) {
        switch (n) {
            case 1: {
                return activatedImage;
            }
            case 2: {
                return deActivatedImage;
            }
        }
        return deActivatedImage;
    }

    public String getLicenseType(int n) {
        if (this.isStoredInFactory || this.isStoredInNvram || this.isStoredInKeyvault) {
            if (!this.isFWSupported()) {
                return "<html>" + UNLIMITED_STR + "<font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
            }
            return UNLIMITED_STR;
        }
        if (this.isbootTime) {
            if (!this.isFWSupported()) {
                return "<html>" + UNLIMITED_STR + "<font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
            }
            return BOOTLABEL_STR;
        }
        if (this.isTrialfeature()) {
            if (n == 0 || n < 1) {
                if (!this.isFWSupported()) {
                    return "<html>" + TRIAL_EXPIRED_STR + "<font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
                }
                return TRIAL_EXPIRED_STR;
            }
            Object[] objectArray = null;
            if (n < 60) {
                objectArray = new Object[]{n};
                String string = MessageFormat.format(Resource.getString("TRIAL_STR4"), objectArray);
                if (!this.isFWSupported()) {
                    return "<html>" + string + "<font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
                }
                return string;
            }
            int n2 = n / 1440;
            int n3 = (n - n2 * 1440) / 60;
            if (n2 > 0) {
                objectArray = new Object[]{n2};
                String string = MessageFormat.format(Resource.getString("TRIAL_STR2"), objectArray);
                if (!this.isFWSupported()) {
                    return "<html>" + string + "<font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
                }
                return string;
            }
            objectArray = new Object[]{n3};
            String string = MessageFormat.format(Resource.getString("TRIAL_STR3"), objectArray);
            if (!this.isFWSupported()) {
                return "<html>" + string + "<font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
            }
            return string;
        }
        if (!this.isFWSupported()) {
            return "<html>" + DEACTIVE_STR + "<font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
        }
        return DEACTIVE_STR;
    }

    public void setFeatureStatus(boolean bl) {
        this.featureStatus = bl;
    }

    public int getValidity() {
        return this.validity;
    }

    public void setValidity(int n) {
        this.validity = n;
    }

    public short getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(short s) {
        this.featureId = s;
    }

    public String getLocationStr() {
        if (this.isStoredInKeyvault()) {
            return SECURE_STR;
        }
        if (this.isStoredInNvram()) {
            return NOT_SECURE_STR;
        }
        if (this.isStoredInFactory()) {
            return FACTORY_STR;
        }
        if (this.isTrialfeature()) {
            return NOT_SECURE_STR;
        }
        if (this.isBoottime()) {
            return Boot_STR;
        }
        return NOT_SECURE_STR;
    }

    public String getLocationHTMLStr() {
        if (this.isStoredInKeyvault()) {
            if (!this.isFWSupported()) {
                return "<html><font color=#408080>" + SECURE_STR + "</font><font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
            }
            return "<html><font color=#408080>" + SECURE_STR + "</font></html>";
        }
        if (this.isStoredInNvram()) {
            if (!this.isFWSupported()) {
                return "<html><font color=#FF0000>" + NOT_SECURE_STR + "</font><font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
            }
            return "<html><font color=#FF0000>" + NOT_SECURE_STR + "</font></html>";
        }
        if (this.isStoredInFactory()) {
            if (!this.isFWSupported()) {
                System.out.println("inside factory");
                return "<html><font color=#FF00FF>" + FACTORY_STR + "</font><font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
            }
            System.out.println("inside factory else");
            return "<html><font color=#FF00FF>" + FACTORY_STR + "</font></html>";
        }
        if (this.isBoottime()) {
            System.out.println("inside boottime");
            if (!this.isFWSupported()) {
                return "<html><font color=#FF0000>" + NOT_SECURE_STR + "</font><font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
            }
            System.out.println("inside boottime else");
            return "<html><font color=#FF0000>-</font></html>";
        }
        if (this.isTrialfeature()) {
            if (!this.isFWSupported()) {
                return "<html><font color=#FF0000>" + NOT_SECURE_STR + "</font><font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
            }
            return "<html><font color=#FF0000>" + NOT_SECURE_STR + "</font></html>";
        }
        if (!this.isFWSupported()) {
            return "<html><font color=#FF0000>" + NOT_SECURE_STR + "</font><font color=#FF0000> (" + UNSUPPORTED_STR + ")</font></html>";
        }
        return "<html><font color=##FF0000>" + NOT_SECURE_STR + "</font></html>";
    }

    public boolean isStoredInFactory() {
        return this.isStoredInFactory;
    }

    public boolean isStoredInNvram() {
        return this.isStoredInNvram;
    }

    public boolean isStoredInKeyvault() {
        return this.isStoredInKeyvault;
    }

    public boolean isTrialfeature() {
        return this.isTrialfeature;
    }

    public boolean isBoottime() {
        return this.isbootTime;
    }

    public void setIsTrialfeature(boolean bl) {
        this.isTrialfeature = bl;
    }

    public boolean isRealTrialFeature() {
        boolean bl;
        if (!this.isTrialfeature()) {
            return false;
        }
        boolean bl2 = bl = this.isStoredInFactory() || this.isStoredInKeyvault() || this.isStoredInNvram();
        return !bl;
    }

    public boolean isNonSecuredFeature() {
        if (!this.isStoredInNvram()) {
            return false;
        }
        boolean bl = this.getLocationStr().equals(NOT_SECURE_STR);
        return bl;
    }

    public boolean isFWSupported() {
        return this.isFWSupported;
    }

    public void setFWSupported(boolean bl) {
        this.isFWSupported = bl;
    }
}

