/*
 * Decompiled with CFR 0.152.
 */
package GUI.PremiumFeatures;

import GUI.PremiumFeatures.PremiumFeature;
import Utils.Resource;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

class PremiumFeatureTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Class[] m_colTypes = new Class[]{Object.class, Object.class, Object.class};
    private String locationHeader = Resource.getString("PFKEY_LOCATION", "Mode");
    private String featuresHeader = Resource.getString("FEATURE_HEADING", "Advanced Software Option");
    private String statusHeader = Resource.getString("PFKEY_LICENSE_TYPE");
    private String licenseTypeHeader = Resource.getString("PFKEY_LICENSE_VALIDITY", "License ");
    private String[] featureTableHeader = new String[]{this.featuresHeader, this.licenseTypeHeader, this.locationHeader};
    ArrayList<PremiumFeature> featureList = new ArrayList();

    PremiumFeatureTableModel() {
    }

    public Class getColumnClass(int n) {
        return this.m_colTypes[n];
    }

    @Override
    public int getColumnCount() {
        return this.featureTableHeader.length;
    }

    @Override
    public int getRowCount() {
        return this.featureList.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.featureTableHeader[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PremiumFeature premiumFeature = this.featureList.get(n);
        switch (n2) {
            case 0: {
                return premiumFeature.getFeatureName();
            }
            case 1: {
                return premiumFeature.getLicenseType(premiumFeature.getValidity());
            }
            case 2: {
                String string = premiumFeature.getLocationHTMLStr();
                System.out.println("inside boot" + string);
                return string;
            }
        }
        return new String();
    }

    public void appendPremiumFetaure(PremiumFeature premiumFeature) {
        this.featureList.add(premiumFeature);
        this.fireTableRowsInserted(this.featureList.size() - 1, this.featureList.size() - 1);
    }

    public void clearPremiumFeatures() {
        int n = this.featureList.size();
        if (n > 0) {
            this.featureList.clear();
            this.fireTableRowsDeleted(0, n - 1);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }
}

