/*
 * Decompiled with CFR 0.152.
 */
package GUI.PremiumFeatures;

import GUI.PremiumFeatures.ConfigureKeyVaultPanel;
import GUI.PremiumFeatures.DeactivateKeysConFirmation;
import GUI.PremiumFeatures.PFKeyActivationPage;
import GUI.PremiumFeatures.PFKeyController;
import GUI.PremiumFeatures.PFKeySummaryPage;
import GUI.PremiumFeatures.PremiumFeature;
import GUI.PremiumFeatures.PremiumFeatureTableModel;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUI.venus.wizard.WizardController;
import GUI.venus.wizard.WizardNavigationException;
import GUIHelper.AdapterHelper;
import SASKernel.SASAdapter.SASAdapter;
import Utils.GUIUtils;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class PremiumFeaturesDialog
extends VivaldiBaseDialog {
    private static final long serialVersionUID = 1L;
    JPanel basePanel = new JPanel();
    JPanel mainPanel = new JPanel();
    private PFKeyController pfkeyHandle;
    private AdapterHelper adpHelperObj;
    private PremiumFeatureTableModel pfkeyTableModel = new PremiumFeatureTableModel();
    private static final Color EVEN_ROW_COLOR = new Color(241, 245, 250);
    private String m_strHelpPage = "MR_MANAGING_MEGARAID_ADVANCED_SOFTWARE";
    public static final String KEY_ACTIVATION_PAGE = "KeyActivationPage";
    public static final String FEATURE_SUMMARY_PAGE = "FeatureSummaryPage";
    public static final int ADAPTER_HELPER = 0;
    public static final int CURRENT_FEATURES = 1;
    public static final int KEY_FEATURES = 2;
    public static final int KEY_STR = 3;
    public static final int TRIAL_STATUS = 4;
    public static final int KEY_FEATURES_IR = 5;
    JTable featureTable;
    JLabel featurelicenseDesc;
    JLabel PFKeyViewLabel;
    String[] mnemonics;
    JButton keyEnableButton;
    JLabel featureDesc;
    JButton helpButton;
    private JButton deactivateTrialButton = null;
    private JButton configureKeyVault = null;
    private JTextField safeIdText = new JTextField(40);
    private PremiumFeaturesDialog pfkDialog = null;
    JLabel tipsLinkButton;
    JPanel temp;
    private boolean m_isWarpDrive = false;

    public PremiumFeaturesDialog() {
        this.init();
    }

    public PremiumFeaturesDialog(AdapterHelper adapterHelper) {
        this.adpHelperObj = adapterHelper;
        this.m_isWarpDrive = this.adpHelperObj.isWarhawk();
        this.init();
    }

    public PremiumFeaturesDialog(AdapterHelper adapterHelper, boolean bl) {
        this.adpHelperObj = adapterHelper;
        if (bl) {
            this.init();
        }
    }

    public static void main(String[] stringArray) {
        PremiumFeaturesDialog premiumFeaturesDialog = new PremiumFeaturesDialog();
    }

    public JPanel getPFKeyPanel() {
        return this.basePanel;
    }

    private void init() {
        Object object;
        this.basePanel.removeAll();
        this.pfkeyHandle = null;
        this.basePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 18;
        int n = this.adpHelperObj.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getDisableOnlinePFKChange();
        String string = new String();
        if (this.m_isWarpDrive) {
            string = Resource.getString("IR_PFKEY_VIEW_TEXT", "<html>Advanced Software Options enable special functionality or features that may not be available in the standard <br>configuration of the controller.</html>");
            this.m_strHelpPage = "NYTRO_XD_APPLYING_THE_ACTIVATION_KEY";
        } else {
            string = Resource.getString("PFKEY_VIEW_TEXT", "A premium feature is a special function that may not be available in the standard configuration of the controller.");
        }
        this.PFKeyViewLabel = new JLabel(string);
        int n2 = this.PFKeyViewLabel.getPreferredSize().width;
        if (!this.m_isWarpDrive) {
            this.temp = new JPanel(new FlowLayout(2));
            object = new JLabel(Resource.getString("PFKEY_BENEFITS_HELP", "<html><a href=>Benefits of each premium feature</a></html>"));
            ((JLabel)object).setHorizontalAlignment(2);
            ((JComponent)object).setOpaque(false);
            try {
                ((JComponent)object).setToolTipText(this.getBenefitsURI().toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            ((Component)object).addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        PremiumFeaturesDialog.open(PremiumFeaturesDialog.this.getBenefitsURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            });
            this.temp.add((Component)object);
            this.temp.setPreferredSize(new Dimension(this.PFKeyViewLabel.getPreferredSize().width, this.temp.getPreferredSize().height));
        }
        ++gridBagConstraints2.gridy;
        object = null;
        object = this.m_isWarpDrive ? Resource.getString("IR_PFKEY_FEATURES_HEADING", "(A)ctivated Advanced Software Options:") : Resource.getString("PFKEY_FEATURES_HEADING", "(A)ctivated MegaRAID Advanced Software Options:");
        this.mnemonics = Resource.getResourceMnemonic((String)object);
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        jLabel.setVerticalTextPosition(1);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.featureTable = new JTable(this.pfkeyTableModel){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                Boolean bl = false;
                if (VivaldiStartupDialog.isWindows) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    bl = (Boolean)toolkit.getDesktopProperty("win.highContrast.on");
                }
                if (n % 2 == 0 && !this.isCellSelected(n, n2) && !bl.booleanValue()) {
                    component.setBackground(EVEN_ROW_COLOR);
                } else {
                    component.setBackground(this.getBackground());
                }
                return component;
            }
        };
        TableRowSorter<PremiumFeatureTableModel> tableRowSorter = new TableRowSorter<PremiumFeatureTableModel>(this.pfkeyTableModel);
        this.featureTable.setRowSorter(tableRowSorter);
        this.featureTable.setFillsViewportHeight(true);
        jLabel.setLabelFor(this.featureTable);
        this.featureTable.setSelectionMode(0);
        this.featureTable.setCellSelectionEnabled(false);
        this.pfkeyTableModel.clearPremiumFeatures();
        ArrayList<PremiumFeature> arrayList = this.getPFKeyControllerHandle().getFeatureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.pfkeyTableModel.appendPremiumFetaure(arrayList.get(i));
        }
        if (!this.getPFKeyControllerHandle().isKeyvaultAccessible()) {
            this.featureTable.removeColumn(this.featureTable.getColumnModel().getColumn(2));
        }
        JScrollPane jScrollPane = new JScrollPane(this.featureTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(this.PFKeyViewLabel.getPreferredSize().width, 102));
        String string2 = Resource.getString("PFKEY_FEATURES_DES", "<html>You will be prompted to provide the below Safe ID and Serial Number on the LSI Advanced Software License Management <br>Portal in order to obtain the Activation Key that enables the MegaRAID Advanced Software Options.</html>");
        if (this.m_isWarpDrive) {
            string2 = Resource.getString("IR_PFKEY_FEATURES_DES", "<html>You will be prompted to provide the below Safe ID and Serial Number on the LSI Advanced Software License <br>Management Portal in order to obtain the Activation Key that enables the Advanced Software Options.</html>");
        }
        this.featureDesc = new JLabel(string2);
        try {
            this.featurelicenseDesc = new JLabel(Resource.getString("PFKEY_LICENSE_DES", "<html><a href=>LSI Advanced Software License Management Portal</a></html>"));
            this.featurelicenseDesc.setBorder(null);
            this.featurelicenseDesc.setOpaque(false);
            try {
                this.featurelicenseDesc.setToolTipText(this.getHelpURI().toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            this.featurelicenseDesc.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        PremiumFeaturesDialog.open(PremiumFeaturesDialog.this.getHelpURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("SAFE_ID_LABEL", "Sa(f)e ID:"));
        JLabel jLabel2 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel2.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        String string3 = this.getPFKeyControllerHandle().getSafeIdStr();
        this.safeIdText.setText(string3);
        this.safeIdText.setEditable(false);
        jLabel2.setLabelFor(this.safeIdText);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("CTRL_SERIAL_NO", "(S)erial Number:"));
        JLabel jLabel3 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel3.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        String string4 = this.getPFKeyControllerHandle().getCtrlSn();
        if (this.m_isWarpDrive) {
            try {
                string4 = new String(this.adpHelperObj.getAdapterInfo().getserialNo()).trim();
            }
            catch (Exception exception) {
                System.out.println("PremiumFeaturesDialog.init() - getserialNo throws exception for Warpdrive");
            }
        }
        JTextField jTextField = new JTextField(40);
        jTextField.setText(string4);
        jTextField.setEditable(false);
        jLabel3.setLabelFor(jTextField);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("ENABLE_BUTTON", "Ac(t)ivate..."));
        this.keyEnableButton = new JButton(this.mnemonics[0]);
        this.keyEnableButton.setMnemonic(this.mnemonics[1].charAt(0));
        jPanel2.add(this.keyEnableButton);
        jPanel.add((Component)jPanel2, "West");
        this.keyEnableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WizardController wizardController = new WizardController();
                    HashMap hashMap = wizardController.getWizardData();
                    hashMap.put(0, PremiumFeaturesDialog.this.adpHelperObj);
                    hashMap.put(1, PremiumFeaturesDialog.this.getPFKeyControllerHandle().getFeatureMap());
                    hashMap.put(4, PremiumFeaturesDialog.this.getPFKeyControllerHandle().isTrialFeaturePresent());
                    if (PremiumFeaturesDialog.this.m_isWarpDrive) {
                        hashMap.put("WarningDialogTitle", Resource.getString("IR_PFK_ACTIV_WARNING_TITLE"));
                    } else {
                        hashMap.put("WarningDialogTitle", Resource.getString("ACTIV_WARNING_TITLE"));
                    }
                    wizardController.addPage(PFKeyActivationPage.class.getName(), PremiumFeaturesDialog.KEY_ACTIVATION_PAGE);
                    wizardController.addPage(PFKeySummaryPage.class.getName(), PremiumFeaturesDialog.FEATURE_SUMMARY_PAGE);
                    wizardController.setFirstPage(PremiumFeaturesDialog.KEY_ACTIVATION_PAGE);
                    wizardController.addPageTransition(PremiumFeaturesDialog.KEY_ACTIVATION_PAGE, 1, PremiumFeaturesDialog.FEATURE_SUMMARY_PAGE);
                    wizardController.launchWizard();
                    PremiumFeaturesDialog.this.updateDialog();
                }
                catch (WizardNavigationException wizardNavigationException) {
                    wizardNavigationException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JPanel jPanel3 = new JPanel();
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("CONFIG_KEY_VAULT", "Configure Key (V)ault..."));
        this.configureKeyVault = new JButton(this.mnemonics[0]);
        this.configureKeyVault.setMnemonic(this.mnemonics[1].charAt(0));
        if (this.isRehostNeeded() || this.isSecureFeaturesNeeded()) {
            this.configureKeyVault.setVisible(true);
        } else {
            this.configureKeyVault.setVisible(false);
        }
        this.configureKeyVault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                boolean bl2 = false;
                if (PremiumFeaturesDialog.this.isRehostNeeded()) {
                    bl = true;
                }
                if (PremiumFeaturesDialog.this.isSecureFeaturesNeeded()) {
                    bl2 = true;
                }
                if (bl || bl2) {
                    ArrayList<PremiumFeature> arrayList = null;
                    if (bl2) {
                        arrayList = PremiumFeaturesDialog.this.getPFKeyControllerHandle().getNvramFeatureList();
                    }
                    ConfigureKeyVaultPanel configureKeyVaultPanel = new ConfigureKeyVaultPanel(PremiumFeaturesDialog.this.pfkDialog, PremiumFeaturesDialog.this.adpHelperObj, bl, arrayList);
                }
            }
        });
        jPanel3.add(this.configureKeyVault);
        if (!this.m_isWarpDrive) {
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("DEACTIVATE_BUTTON", "(D)eactivate All Trial Software"));
            this.deactivateTrialButton = new JButton(this.mnemonics[0]);
            this.deactivateTrialButton.setMnemonic(this.mnemonics[1].charAt(0));
            if (this.getPFKeyControllerHandle().isTrialFeaturePresent() && this.getPFKeyControllerHandle().getTimeRemaining() > 0) {
                this.deactivateTrialButton.setEnabled(true);
            } else {
                this.deactivateTrialButton.setEnabled(false);
            }
            this.deactivateTrialButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    ArrayList<PremiumFeature> arrayList = PremiumFeaturesDialog.this.getPFKeyControllerHandle().getTrialFeatureList();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (n = 0; n < arrayList.size(); ++n) {
                        PremiumFeature premiumFeature = arrayList.get(n);
                        arrayList2.add(premiumFeature.getFeatureName());
                    }
                    System.out.println("trial features::" + arrayList2);
                    n = new DeactivateKeysConFirmation((Window)PremiumFeaturesDialog.this.pfkDialog, arrayList2).getSelectedOption();
                    if (n == 0) {
                        try {
                            int n2 = PremiumFeaturesDialog.this.getPFKeyControllerHandle().deActivateTrialKey();
                            if (n2 == 89) {
                                JOptionPane jOptionPane = new JOptionPane(Resource.getString("RESTART_MSG", "<html>Please restart the system for the changes to take effect. Make sure <br>to stop all the I\\Os and the other operations before you restart your <br>system.</html>"), 2);
                                JDialog jDialog = jOptionPane.createDialog(Resource.getString("RESTART_TITLE", "System Restart Required"));
                                Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                                jDialog.setIconImage(image);
                                jDialog.setVisible(true);
                            }
                            if (n2 == 89 || n2 == 0) {
                                PremiumFeaturesDialog.this.updateDialog();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            jPanel3.add(this.deactivateTrialButton);
            jPanel.add((Component)jPanel3, "East");
            jPanel.setPreferredSize(new Dimension(this.PFKeyViewLabel.getPreferredSize().width, jPanel.getPreferredSize().height));
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
            ++gridBagConstraints2.gridy;
            try {
                this.tipsLinkButton = new JLabel();
                this.tipsLinkButton.setText(Resource.getString("PFKEY_TIPS_LINK", "<html><a href=>Tips on activating MegaRAID Advanced Software Options</a></html>"));
                this.tipsLinkButton.setBorder(null);
                this.tipsLinkButton.setOpaque(false);
                try {
                    this.tipsLinkButton.setToolTipText(this.getKeyMgrURI().toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                this.tipsLinkButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        try {
                            PremiumFeaturesDialog.open(PremiumFeaturesDialog.this.getKeyMgrURI());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n != 1) {
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
            this.mainPanel.add(this.PFKeyViewLabel);
            if (!this.m_isWarpDrive) {
                ++gridBagConstraints2.gridy;
                gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
                this.mainPanel.add((Component)this.temp, gridBagConstraints2);
            }
            ++gridBagConstraints2.gridy;
            this.mainPanel.add((Component)jLabel, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets = new Insets(0, 10, 5, 10);
            this.mainPanel.add((Component)jScrollPane, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
            this.mainPanel.add((Component)this.featureDesc, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
            this.mainPanel.add((Component)this.featurelicenseDesc, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets = new Insets(5, 10, 0, 10);
            this.mainPanel.add((Component)jLabel2, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
            this.mainPanel.add((Component)this.safeIdText, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets = new Insets(5, 10, 0, 10);
            this.mainPanel.add((Component)jLabel3, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
            this.mainPanel.add((Component)jTextField, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
            this.mainPanel.add((Component)jPanel, gridBagConstraints2);
            if (!this.m_isWarpDrive) {
                ++gridBagConstraints2.gridy;
                this.mainPanel.add((Component)this.tipsLinkButton, gridBagConstraints2);
            }
        } else {
            System.out.println("inside boot time");
            this.PFKeyViewLabel = new JLabel(Resource.getString("PFKEY_VIEW_TEXT_ONLINEENABLED", "Shows a preview of MegaRAID Advanced Software Options features or special functionalities enabled on the controller."));
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
            this.mainPanel.add(this.PFKeyViewLabel);
            if (!this.m_isWarpDrive) {
                ++gridBagConstraints2.gridy;
                gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
                this.mainPanel.add((Component)this.temp, gridBagConstraints2);
            }
            ++gridBagConstraints2.gridy;
            this.mainPanel.add((Component)jLabel, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets = new Insets(0, 10, 5, 10);
            this.mainPanel.add((Component)jScrollPane, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
        }
        JPanel jPanel4 = new JPanel(new FlowLayout(1));
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("CLOSE_TEXT", "(C)lose"));
        JButton jButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        jPanel4.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PremiumFeaturesDialog.this.pfkDialog.dispose();
            }
        });
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("MENU_HELP_TEXT", "(H)elp"));
        this.helpButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.helpButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        jPanel4.add(this.helpButton);
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpContext.executeHelpProcess(PremiumFeaturesDialog.this.getHelpPage());
            }
        });
        jPanel4.setPreferredSize(new Dimension(650, 35));
        this.mnemonics = this.m_isWarpDrive ? (n != 1 ? Resource.getResourceMnemonic(Resource.getString("IR_MANAGE_ADV_SOFTWARE_OPTIONS_TITLE", "Manage Advanced Software Options")) : Resource.getResourceMnemonic(Resource.getString("IR_ADV_SOFTWARE_OPTIONS_TITLE", "Advanced Software Options"))) : (n != 1 ? Resource.getResourceMnemonic(Resource.getString("PFKEY_TITLE", "Manage Premium Features")) : Resource.getResourceMnemonic(Resource.getString("PFKEY_TITLE_BOOT", "Premium Features")));
        this.setTitle(this.mnemonics[0]);
        this.setModal(true);
        ScrollPane scrollPane = new ScrollPane(0);
        scrollPane.add(this.mainPanel);
        scrollPane.setPreferredSize(new Dimension(650, 400));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.basePanel.add((Component)scrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.basePanel.add((Component)jPanel4, gridBagConstraints);
        this.add((Component)this.basePanel, "Center");
        this.pack();
        this.pfkDialog = this;
        GUIUtils.centerDialogOnScreen(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                boolean bl = false;
                boolean bl2 = false;
                System.out.println("getPFKeyControllerHandle().getRaidKeySn()=" + PremiumFeaturesDialog.this.getPFKeyControllerHandle().getRaidKeySn());
                System.out.println("getPFKeyControllerHandle().getCtrlSn()=" + PremiumFeaturesDialog.this.getPFKeyControllerHandle().getCtrlSn());
                if (PremiumFeaturesDialog.this.isRehostNeeded()) {
                    bl = true;
                    System.out.println("rehostFlag=" + bl);
                }
                if (PremiumFeaturesDialog.this.isSecureFeaturesNeeded()) {
                    bl2 = true;
                }
                if (bl || bl2) {
                    ArrayList<PremiumFeature> arrayList = null;
                    if (bl2) {
                        arrayList = PremiumFeaturesDialog.this.getPFKeyControllerHandle().getNvramFeatureList();
                    }
                    ConfigureKeyVaultPanel configureKeyVaultPanel = new ConfigureKeyVaultPanel(PremiumFeaturesDialog.this.pfkDialog, PremiumFeaturesDialog.this.adpHelperObj, bl, arrayList);
                }
            }
        });
        this.keyEnableButton.requestFocusInWindow();
        ArrayList<JComponent> arrayList2 = new ArrayList<JComponent>();
        arrayList2.add(this.featureTable);
        arrayList2.add(this.featureDesc);
        arrayList2.add(this.safeIdText);
        arrayList2.add(this.keyEnableButton);
        if (this.deactivateTrialButton != null) {
            arrayList2.add(this.deactivateTrialButton);
        }
        arrayList2.add(this.helpButton);
        this.setResizable(false);
        this.setVisible(true);
        this.keyEnableButton.requestFocusInWindow();
    }

    private static void open(URI uRI) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uRI);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpPage);
    }

    private URI getBenefitsURI() throws URISyntaxException {
        String string = Resource.getString("PFKEY_FEATURES_BENEFIT_URI", "http://www.lsi.com/channel/products/storagesw/Pages/AdvancedSoftwareOptions.aspx");
        return new URI(string);
    }

    private URI getHelpURI() throws URISyntaxException {
        String string = Resource.getString("PFKEY_FEATURES_HELP_URI", "http://softwarelicense.lsi.com");
        return new URI(string);
    }

    private URI getKeyMgrURI() throws URISyntaxException {
        String string = Resource.getString("PFKEY_FEATURES_KEYMGR_URI", "http://www.lsi.com/channel/licensing");
        return new URI(string);
    }

    public PFKeyController getPFKeyControllerHandle() {
        if (this.pfkeyHandle == null) {
            this.pfkeyHandle = new PFKeyController((SASAdapter)this.adpHelperObj.getDeviceObject());
        }
        return this.pfkeyHandle;
    }

    public void setAdpObj(AdapterHelper adapterHelper) {
        this.adpHelperObj = adapterHelper;
    }

    public void initialize() {
        this.init();
    }

    public void updateDialog() {
        this.pfkeyHandle = null;
        this.pfkeyTableModel.clearPremiumFeatures();
        ArrayList<PremiumFeature> arrayList = this.getPFKeyControllerHandle().getFeatureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.pfkeyTableModel.appendPremiumFetaure(arrayList.get(i));
        }
        String string = this.getPFKeyControllerHandle().getSafeIdStr();
        this.safeIdText.setText(string);
        if (this.deactivateTrialButton != null) {
            if (this.getPFKeyControllerHandle().isTrialFeaturePresent() && this.getPFKeyControllerHandle().getTimeRemaining() > 0) {
                this.deactivateTrialButton.setEnabled(true);
            } else {
                this.deactivateTrialButton.setEnabled(false);
            }
        }
        if (this.isRehostNeeded() || this.isSecureFeaturesNeeded()) {
            this.configureKeyVault.setVisible(true);
        } else {
            this.configureKeyVault.setVisible(false);
        }
    }

    private boolean isRehostNeeded() {
        return this.getPFKeyControllerHandle().isKeyvaultAccessible() && !this.getPFKeyControllerHandle().getRaidKeySn().trim().equals("") && !this.getPFKeyControllerHandle().getRaidKeySn().equals(this.getPFKeyControllerHandle().getCtrlSn());
    }

    private boolean isSecureFeaturesNeeded() {
        return this.getPFKeyControllerHandle().isNvramFeaturePresent() && this.getPFKeyControllerHandle().isKeyvaultAccessible();
    }
}

