/*
 * Decompiled with CFR 0.152.
 */
package GUI.PremiumFeatures;

import GUI.PremiumFeatures.PremiumFeaturesDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ReHostPanel
extends VivaldiBaseOptionDialog {
    private AdapterHelper adapterHelper;
    private PremiumFeaturesDialog parent;

    public ReHostPanel(AdapterHelper adapterHelper, PremiumFeaturesDialog premiumFeaturesDialog) {
        super((Window)premiumFeaturesDialog);
        this.adapterHelper = adapterHelper;
        this.parent = premiumFeaturesDialog;
        String string = Resource.getString("REHOST_TITLE", "Re Hosting Process - Confirm");
        super.initUI(string, 2, -1);
        this.buildUI();
    }

    @Override
    public void buildUI() {
        String[] stringArray;
        this.m_panel = new JPanel();
        this.m_panel.removeAll();
        this.m_panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        String string = Resource.getString("REHOST_ONLY_DESC", "<html>To transfer Advanced Software Options from one controller to another controller you need to complete the re-hosting process.<br>Only then you will be able to secure the Advanced Software Options in the key vault.<br><br>Please furnish the below details in the LSI Advanced Software License Management Portal in order to complete the <br>re-hosting process.If you have already completed the process then select the checkbox below and proceed with yes button.<br></html>");
        if (!VivaldiStartupDialog.isWindows) {
            string = Resource.getString("REHOST_ONLY_DESC1");
        }
        JLabel jLabel = new JLabel(string);
        this.m_panel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        try {
            stringArray = new JLabel(Resource.getString("PFKEY_LICENSE_DES", " <html><a href=>LSI Advanced Software License Management Portal</a></html>"));
            stringArray.setBorder(null);
            stringArray.setOpaque(false);
            try {
                stringArray.setToolTipText(this.getHelpURI().toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            stringArray.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        ReHostPanel.open(ReHostPanel.this.getHelpURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            });
            this.m_panel.add((Component)stringArray, gridBagConstraints);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        stringArray = Resource.getResourceMnemonic(Resource.getString("KEY_VAULT_ID", "F(o)rmer Serial Number:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_panel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        String string2 = this.parent.getPFKeyControllerHandle().getRaidKeySn();
        JTextField jTextField = new JTextField(40);
        jTextField.setText(string2);
        jTextField.setEditable(false);
        jLabel2.setLabelFor(jTextField);
        this.m_panel.add((Component)jTextField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        stringArray = Resource.getResourceMnemonic(Resource.getString("NEW_CTRL_SERIAL_NO", "N(e)w serial number:"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_panel.add((Component)jLabel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        String string3 = this.parent.getPFKeyControllerHandle().getCtrlSn();
        JTextField jTextField2 = new JTextField(40);
        jTextField2.setText(string3);
        jTextField2.setEditable(false);
        jLabel3.setLabelFor(jTextField2);
        this.m_panel.add((Component)jTextField2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        stringArray = Resource.getResourceMnemonic(Resource.getString("SAFE_ID_LABEL", "Sa(f)e ID:"));
        JLabel jLabel4 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_panel.add((Component)jLabel4, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        JTextField jTextField3 = new JTextField(40);
        String string4 = this.parent.getPFKeyControllerHandle().getSafeIdStr();
        jTextField3.setText(string4);
        jTextField3.setEditable(false);
        jLabel4.setLabelFor(jTextField3);
        this.m_panel.add((Component)jTextField3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        stringArray = Resource.getResourceMnemonic(Resource.getString("REHOST_CONFIRM", "(I) acknowledge that I have completed the re hosting process in the external site."));
        final JCheckBox jCheckBox = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            jCheckBox.setMnemonic(stringArray[1].charAt(0));
        }
        jCheckBox.setSelected(false);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.m_panel.add((Component)jCheckBox, gridBagConstraints);
        this.setYesEnabled(false);
        this.setModalProperty(true);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReHostPanel.this.setYesEnabled(jCheckBox.isSelected());
            }
        });
        super.buildUI();
    }

    private URI getHelpURI() throws URISyntaxException {
        String string = Resource.getString("PFKEY_FEATURES_HELP_URI", "http://softwarelicense.lsi.com");
        return new URI(string);
    }

    private static void open(URI uRI) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uRI);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

