/*
 * Decompiled with CFR 0.152.
 */
package GUI.PremiumFeatures;

import GUI.VivaldiStartupDialog;
import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SecurePFConfirmation
extends VivaldiBaseOptionDialog {
    private ArrayList<String> nonSecurePfs = new ArrayList();

    public SecurePFConfirmation(Window window, ArrayList<String> arrayList) {
        super(window);
        String string = Resource.getString("CONFIRMATION_SECURE_FEATURE", "Secure Premium Feature - Confirmation");
        super.initUI(string, 0, 2);
        this.nonSecurePfs = arrayList;
        this.buildUI();
    }

    @Override
    public void buildUI() {
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new BorderLayout());
        String string = Resource.getString("SECURE_FEATURES_DESC", "<html> The following Advanced Software Options are not secured in the key vault.Please <br>secure to avoid loosing them.<br><br><b>If you have any unused Activation Keys, make sure you activate all of them <br>first. All non-activated Activation Keys will stop working after this operation.\t</b><br></html>");
        if (!VivaldiStartupDialog.isWindows) {
            string = Resource.getString("SECURE_FEATURES_DESC1", "<html> The following Advanced Software Options are not secured in the key vault.Please <br>secure to avoid loosing them.<br><br><font color=red>If you have any unused Activation Keys, make sure you activate all of them <br>first. All non-activated Activation Keys will stop working after this operation.\t</font><br></html>");
        }
        JLabel jLabel = new JLabel(string);
        this.m_panel.add((Component)jLabel, "North");
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("FEATURE_HEADING1", "(P)remium features:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JList<Object> jList = new JList<Object>(this.nonSecurePfs.toArray());
        jList.setVisibleRowCount(5);
        jList.setSelectionBackground(jList.getBackground());
        jList.setSelectionForeground(jList.getForeground());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(jList);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jLabel2.setLabelFor(jScrollPane);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        JLabel jLabel3 = new JLabel(Resource.getString("SECURE_FEATURES_CONF", "Do you want to secure these premium features keys now?"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CONFIRM_TEXT", "(C)onfirm"));
        final JCheckBox jCheckBox = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            jCheckBox.setMnemonic(stringArray[1].charAt(0));
        }
        jCheckBox.setSelected(false);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        this.setYesEnabled(false);
        this.setModalProperty(true);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SecurePFConfirmation.this.setYesEnabled(jCheckBox.isSelected());
            }
        });
        jLabel2.setPreferredSize(new Dimension(jLabel3.getPreferredSize().width, jLabel2.getPreferredSize().height));
        jScrollPane.setPreferredSize(new Dimension(jLabel3.getPreferredSize().width, jScrollPane.getPreferredSize().height));
        jCheckBox.setPreferredSize(new Dimension(jLabel3.getPreferredSize().width, jCheckBox.getPreferredSize().height));
        this.m_panel.add((Component)jPanel, "West");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jCheckBox.requestFocusInWindow();
            }
        });
        super.buildUI();
    }
}

