/*
 * Decompiled with CFR 0.152.
 */
package GUI.PremiumFeatures;

import GUI.PremiumFeatures.PremiumFeaturesDialog;
import GUI.VivaldiStartupDialog;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import SASKernel.SASAdapter.SASAdapter;
import Utils.HelpContextResourse;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SecurePFWizard
extends DefaultWizardPage
implements HelpInterface {
    private JPanel m_contentPanel = null;
    private ArrayList<String> nonSecurePfs = new ArrayList();
    private boolean needToSecurePF = false;
    private PremiumFeaturesDialog parent;
    private AdapterHelper adapter = null;

    @Override
    protected void reinitialise() {
        this.m_isFinishWizardPage = true;
        this.nonSecurePfs = (ArrayList)this.m_hmWizardData.get(2);
        this.adapter = (AdapterHelper)this.m_hmWizardData.get(0);
        this.parent = (PremiumFeaturesDialog)this.m_hmWizardData.get(1);
        this.m_strHelpFileName = this.adapter.isWarhawk() ? "NYTRO_XD_APPLYING_THE_ACTIVATION_KEY" : "HELP_PAGE_DEFAULT";
    }

    @Override
    public JPanel getContentPanel() {
        if (this.m_contentPanel == null) {
            this.buildUI();
        }
        return this.m_contentPanel;
    }

    public void buildUI() {
        this.m_contentPanel = new JPanel();
        this.m_contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        gridBagConstraints.fill = 2;
        String string = Resource.getString("SECURE_FEATURES_WIZ_DESC", "<html> The following  Advanced Software Options will be secured as part of the re-hosting process.<b><br><br>If you have any unused Activation Keys, make sure you activate all of them first. All non-activated<br> Activation Keys will stop working after this operation.\t</b><br></html>");
        if (!VivaldiStartupDialog.isWindows) {
            string = Resource.getString("SECURE_FEATURES_WIZ_DESC1", "<html> The following Advanced Software Options will be secured as part of the re-hosting process.<font color=red><br><br>If you have any unused Activation keys, make sure you activate all of them first. All non-activated <br>Activation Keys will stop working after this operation.\t</font><br></html>");
        }
        JLabel jLabel = new JLabel(string);
        this.m_contentPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(15, 10, 0, 10);
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("FEATURE_HEADING1", "(P)remium features:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        this.m_contentPanel.add((Component)jLabel2, gridBagConstraints);
        JList<Object> jList = new JList<Object>(this.nonSecurePfs.toArray());
        jList.setVisibleRowCount(7);
        jList.setSelectionBackground(jList.getBackground());
        jList.setSelectionForeground(jList.getForeground());
        JScrollPane jScrollPane = new JScrollPane(jList, 20, 30);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 7, 25, 10);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(jScrollPane);
        jLabel2.setLabelFor(jScrollPane);
        this.m_contentPanel.add((Component)jPanel, gridBagConstraints);
    }

    @Override
    public void onNext() {
        SASAdapter sASAdapter = (SASAdapter)this.adapter.getDeviceObject();
        try {
            int n = this.parent.getPFKeyControllerHandle().securePremiumFeatures();
            if (n == 0) {
                this.parent.updateDialog();
            } else if (n == 93 || n == 33) {
                JOptionPane jOptionPane = new JOptionPane("Re-hosting cannot be completed because of the incompatible keyvault", 2);
                JDialog jDialog = jOptionPane.createDialog("Incompatible Keyvault");
                Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                jDialog.setIconImage(image);
                jDialog.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dispose();
    }

    private URI getHelpURI() throws URISyntaxException {
        return new URI("http://insight.lsi.com");
    }

    private static void open(URI uRI) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uRI);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getPageID() {
        return "SecureFeaturePage";
    }

    @Override
    public String getTitle() {
        return Resource.getString("CONFIG_SECURE_TITLE", "Configure Key Vault - Secure Advanced Software Options");
    }

    private void updatePanel() {
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpFileName);
    }
}

