/*
 * Decompiled with CFR 0.152.
 */
package GUI.PreservedCache;

import GUI.PreservedCache.ConfirmDiscardDialog;
import GUI.PreservedCache.DeleteOfflineVirtualDrives;
import GUI.PreservedCache.ListItemData;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASLogical.SASLogicalDrive;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManagePreservedCacheDialog
extends VivaldiBaseDialog {
    private DefaultListModel m_model = new DefaultListModel();
    private final AdapterHelper m_adapter;
    private LogicalDriveHelper[] m_ldHelper;
    private JList m_listPanel;
    private boolean m_isAccessBlockedVDsPresent = false;
    private boolean m_isAccessBlockedVDsPresentDueToPeerUnavailabality = false;
    private JLabel m_managePreservedCacheLabel = new JLabel();
    private String m_strMissingState = Resource.getString("LDRIVE_MISSING", "Missing");

    public ManagePreservedCacheDialog(AdapterHelper adapterHelper) {
        this.m_adapter = adapterHelper;
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("DISCARD_PRESERVED_CACHE_BUTTON_TEXT", "Discard Cache"));
        final JButton jButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE_TEXT_WITH_MNEMONIC", "Close"));
        JButton jButton2 = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton2.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_ldHelper = this.m_adapter.getLogicalDrives();
        this.m_model = new DefaultListModel();
        int n = this.RefreshDriveListBox();
        if (n == 0) {
            this.dispose();
            return;
        }
        this.m_listPanel = new JList(this.m_model);
        this.m_listPanel.setPrototypeCellValue("Virtual Drive: 99, NAME 99, 5000MB, Offline");
        Rectangle rectangle = this.m_listPanel.getCellBounds(0, 1);
        Dimension dimension = new Dimension();
        dimension.height = rectangle.height * 6;
        dimension.width = rectangle.width;
        this.m_listPanel.setMinimumSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(this.m_listPanel);
        stringArray = Resource.getResourceMnemonic(Resource.getString("VIRTUAL_DRIVES_LABEL", "Virtual drives with preserved cache:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel.setLabelFor(this.m_listPanel);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        String string = Resource.getString("ADAPTER_TEXT", "Controller") + ":  " + Resource.zeroTrim(adapterHelper.getAdapterInfo().getproductName());
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 25, 0, 25);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.m_managePreservedCacheLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.contentPane.add((Component)jPanel, "Center");
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        this.contentPane.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jButton2);
        this.contentPane.add((Component)jPanel2, "South");
        jButton.setEnabled(false);
        this.m_listPanel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                jButton.setEnabled(ManagePreservedCacheDialog.this.m_listPanel.getSelectedIndex() != -1);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePreservedCacheDialog.this.OnCloseButton();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePreservedCacheDialog.this.OnDiscardButton();
                int n = ManagePreservedCacheDialog.this.RefreshDriveListBox();
                if (n == 0) {
                    ManagePreservedCacheDialog.this.dispose();
                }
            }
        });
        this.setTitle(Resource.getString("TITLE_MANAGE_PRESERVED_CACHE", "Manage Preserved Cache"));
        this.setModal(true);
        this.setResizable(false);
        jScrollPane.setFocusable(true);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    private void OnCloseButton() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("RETAIN_PRESERVED_CACHE", "Controller will retain the remaining preserved cache."));
        this.dispose();
        JOptionPane.showMessageDialog(VivaldiStartupDialog.mainScreen, stringBuffer.toString(), Resource.getString("PRESERVED_CACHE_RETAINED_TITLE", "Preserved Cache Retained"), 2);
    }

    private int RefreshDriveListBox() {
        this.m_model.clear();
        this.m_isAccessBlockedVDsPresent = false;
        this.m_isAccessBlockedVDsPresentDueToPeerUnavailabality = false;
        OperationDetails operationDetails = new OperationDetails(0x30D0000, "", "", Boolean.TRUE);
        operationDetails.setOpcode(0x30D0000);
        this.m_adapter.issueOperation(operationDetails);
        long l = (Long)operationDetails.getParam();
        if (l == 0L) {
            return 0;
        }
        int n = this.m_adapter.getAdapterInfo().getmaxLDs();
        for (int i = 0; i < n; ++i) {
            int n2;
            long l2 = 1L << i;
            long l3 = 0L;
            SASLogicalDrive sASLogicalDrive = null;
            if ((l2 & l) == 0L) continue;
            boolean bl = false;
            for (n2 = 0; n2 < this.m_ldHelper.length; ++n2) {
                l3 = this.m_ldHelper[n2].getDeviceObject().getID();
                if (l3 != (long)i) continue;
                bl = true;
                break;
            }
            if (bl) {
                sASLogicalDrive = (SASLogicalDrive)this.m_ldHelper[n2].getDeviceObject();
                if (!this.m_isAccessBlockedVDsPresent || !this.m_isAccessBlockedVDsPresentDueToPeerUnavailabality) {
                    this.m_isAccessBlockedVDsPresent = this.m_ldHelper[n2].isBlockedDueToSSCDOffline();
                    this.m_isAccessBlockedVDsPresentDueToPeerUnavailabality = this.m_ldHelper[n2].isBlockedDueToPeerUnavailability();
                }
                this.m_model.addElement(new ListItemData(sASLogicalDrive.getID(), this.m_ldHelper[n2].getText(), this.m_ldHelper[n2]));
                continue;
            }
            this.m_model.addElement(new ListItemData(i, Resource.getString("LDRIVE_TEXT", "Virtual Drive") + ":  " + i + ", " + this.m_strMissingState, null));
        }
        this.updateLabel();
        return this.m_model.size();
    }

    private void OnDiscardButton() {
        int n;
        Object[] objectArray = this.m_listPanel.getSelectedValues();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n].toString().contains(this.m_strMissingState)) {
                bl = true;
                continue;
            }
            if (((ListItemData)objectArray[n]).isBlockedDueToSSCDOffline() || ((ListItemData)objectArray[n]).isM_isBlockedDuetoPeerunavailabality()) {
                bl3 = true;
                continue;
            }
            bl2 = true;
            defaultListModel.addElement(objectArray[n]);
        }
        if (bl || bl3) {
            n = this.m_adapter.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getforeignConfigImport();
            ConfirmDiscardDialog confirmDiscardDialog = new ConfirmDiscardDialog(n);
            if (confirmDiscardDialog.getSelectedOption() == 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i].toString().contains(this.m_strMissingState)) {
                        OperationDetails operationDetails = new OperationDetails(51183872, "", "", ((ListItemData)objectArray[i]).getId());
                        this.m_adapter.issueOperation(operationDetails);
                        continue;
                    }
                    if (!((ListItemData)objectArray[i]).isBlockedDueToSSCDOffline() && !((ListItemData)objectArray[i]).isM_isBlockedDuetoPeerunavailabality()) continue;
                    ((ListItemData)objectArray[i]).getSASLD().clearBlockedAccess();
                }
            } else {
                return;
            }
        }
        if (bl2) {
            DeleteOfflineVirtualDrives deleteOfflineVirtualDrives = new DeleteOfflineVirtualDrives(this.m_adapter, defaultListModel);
            if (deleteOfflineVirtualDrives.getSelectedOption() == 0) {
                for (int i = 0; i < defaultListModel.size(); ++i) {
                    OperationDetails operationDetails = new OperationDetails(3, "", "", null);
                    ((ListItemData)defaultListModel.getElementAt(i)).getLDHelper().issueOperation(operationDetails);
                }
            } else {
                return;
            }
        }
    }

    private void updateLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_isAccessBlockedVDsPresent) {
            stringBuffer.append(Resource.getString("MANAGE_PRESERVED_CACHE_TEXT_NEW1", "<html>The controller lost access to one or more drives. When access to the drives<br>was lost, the system preserved the data in the cache.<br><br>Some virtual drives are in blocked access state due to loss of associated<br>CacheCade\u2122 - SSD Caching virtual drive(s).<br><br>The preserved cache will persist until you import the relevant virtual drives<br>or discard the cache. As long as there is preservedcache, you will not be<br>able to perform certain operations on virtual drives.<br></html>"));
            this.m_managePreservedCacheLabel.setText(stringBuffer.toString());
        } else {
            stringBuffer.append(Resource.getString("MANAGE_PRESERVED_CACHE_TEXT_NEW2", "<html>The controller lost access to one or more drives. When access to the drives<br>was lost, the system preserved the data in the cache.<br><br>The preserved cache will persist until you import the relevant virtual drives<br>or discard the cache. As long as there is preservedcache, you will not be<br>able to perform certain operations on virtual drives.<br></html>"));
            this.m_managePreservedCacheLabel.setText(stringBuffer.toString());
        }
    }
}

