/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MainFrame;
import GUI.VivaldiStartupDialog;
import GUIHelper.PropertyInfo;
import Utils.ColorHash;
import Utils.GUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class PropertyViewPanel
extends JPanel {
    private JPanel inner = new JPanel();
    private PropertyInfo info = null;
    private HashMap<String, PropertyInfo> m_labelPropInfoMap = new HashMap();

    public PropertyViewPanel(ArrayList arrayList, int n) {
        Font font;
        if (arrayList == null || arrayList.size() < 0) {
            return;
        }
        int n2 = arrayList.size();
        if (n % 2 == 1) {
            ++n;
        }
        List list = arrayList;
        if (n > 10) {
            this.inner.setLayout(new GridLayout(0, 2, 1, 0));
            list = PropertyViewPanel.shufflePropertyList(arrayList);
        } else {
            this.inner.setLayout(new GridLayout(0, 1, 1, 0));
        }
        if (!VivaldiStartupDialog.isWindows) {
            font = Locale.getDefault().getLanguage() == Locale.ENGLISH.getLanguage() ? new Font("Arial", 1, 12) : GUIUtils.getDefaultFont(15, this.getFont().getFontName(this.getLocale()), 12, this);
            if (MainFrame.SCREEN_SIZE.width <= 800) {
                font = Locale.getDefault().getLanguage() == Locale.ENGLISH.getLanguage() ? new Font("Arial", 1, 10) : GUIUtils.getDefaultFont(13, this.getFont().getFontName(), 10, this);
            }
        } else {
            font = this.getFont();
        }
        for (int i = 0; i < n; ++i) {
            JLabel jLabel = new JLabel();
            JLabel jLabel2 = new JLabel();
            JLabel jLabel3 = new JLabel();
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
            PropertyInfo propertyInfo = null;
            if (i < n2) {
                GridBagConstraints gridBagConstraints;
                JPanel jPanel3;
                propertyInfo = (PropertyInfo)list.get(i);
                if (propertyInfo.isnameHyperLink) {
                    jLabel.setText("<html><body><a href=\"" + propertyInfo.name + "\">" + propertyInfo.name + "</a></body></html>");
                    this.m_labelPropInfoMap.put(jLabel.getText(), propertyInfo);
                    jLabel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            System.out.println("inside click" + PropertyViewPanel.this.m_labelPropInfoMap.get(((JLabel)mouseEvent.getSource()).getText()));
                            ((PropertyInfo)PropertyViewPanel.this.m_labelPropInfoMap.get(((JLabel)mouseEvent.getSource()).getText())).invokeListener();
                        }

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                        }
                    });
                    jPanel2.add(jLabel);
                } else {
                    jLabel.setText(propertyInfo.name);
                    jPanel2.add(jLabel);
                }
                if (propertyInfo.hasTooltip) {
                    jPanel3 = new JPanel(new GridBagLayout());
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = 0;
                    jLabel2.setText(propertyInfo.value);
                    jPanel3.add((Component)jLabel2, gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    jLabel3.setText("<html><body><a href=\"" + propertyInfo.tooltipValue + "\">" + propertyInfo.tooltipValue + "</a></body></html>");
                    jLabel3.setToolTipText(propertyInfo.tooltip);
                    jLabel3.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                        }

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                        }
                    });
                    jPanel3.add((Component)jLabel3, gridBagConstraints);
                    jPanel.add((Component)jPanel3, "West");
                    jPanel2.add(jPanel);
                } else if (propertyInfo.isValueHyperLink) {
                    jLabel2.setText("<html><body><a href=\"" + propertyInfo.value + "\">" + propertyInfo.value + "</a></body></html>");
                    this.m_labelPropInfoMap.put(jLabel2.getText(), propertyInfo);
                    jLabel2.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            ((PropertyInfo)PropertyViewPanel.this.m_labelPropInfoMap.get(((JLabel)mouseEvent.getSource()).getText())).invokeListener();
                        }

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                        }
                    });
                    jPanel2.add(jLabel2);
                } else if (propertyInfo.hasIcon) {
                    jPanel3 = new JPanel(new GridBagLayout());
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = 0;
                    jPanel3.add((Component)new JLabel(propertyInfo.icon), gridBagConstraints);
                    jPanel.add((Component)jPanel3, "West");
                    gridBagConstraints.gridx = 1;
                    jLabel2.setText(propertyInfo.value);
                    jPanel3.add((Component)jLabel2, gridBagConstraints);
                    jPanel2.add(jPanel);
                } else if (propertyInfo.hasLink) {
                    jPanel3 = new JPanel(new GridBagLayout());
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = 0;
                    jLabel2.setText(propertyInfo.value);
                    jPanel3.add((Component)jLabel2, gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    jPanel3.add((Component)propertyInfo.label, gridBagConstraints);
                    jPanel.add((Component)jPanel3, "West");
                    jPanel2.add(jPanel);
                } else {
                    jLabel2.setText(propertyInfo.value);
                    jPanel2.add(jLabel2);
                }
                if (propertyInfo.showFont == null) {
                    jLabel.setFont(font);
                    jLabel2.setFont(font);
                    jLabel3.setFont(font);
                } else {
                    jLabel.setFont(propertyInfo.showFont);
                    jLabel2.setFont(propertyInfo.showFont);
                    jLabel3.setFont(propertyInfo.showFont);
                }
            }
            jLabel.setOpaque(true);
            jLabel2.setOpaque(true);
            jLabel3.setOpaque(true);
            jPanel.setOpaque(true);
            if (n > 10) {
                if (i % 4 <= 1) {
                    jLabel.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                    jLabel2.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                    jLabel3.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                    jPanel.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                } else {
                    jLabel.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR2"));
                    jLabel2.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR2"));
                    jLabel3.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR2"));
                    jPanel.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR2"));
                }
            } else if (i % 2 == 0) {
                jLabel.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                jLabel2.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                jLabel3.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                jPanel.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
            } else {
                jLabel.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR2"));
                jLabel2.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR2"));
                jLabel3.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR2"));
                jPanel.setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR2"));
            }
            jLabel.setBorder(new EmptyBorder(8, 10, 8, 10));
            jLabel2.setBorder(new EmptyBorder(8, 10, 8, 10));
            jLabel3.setBorder(new EmptyBorder(8, 10, 8, 10));
            this.inner.add(jPanel2);
        }
        this.inner.setBackground(Color.BLACK);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(5, 5, 5, 5), new LineBorder(Color.black)));
        this.add((Component)this.inner, "Center");
    }

    public PropertyViewPanel(ArrayList arrayList) {
        this(arrayList, arrayList.size());
    }

    private static List shufflePropertyList(List list) {
        int n;
        int n2;
        ArrayList arrayList = new ArrayList();
        arrayList.ensureCapacity(list.size());
        int n3 = list.size();
        int n4 = n2 = n3 % 2 == 0 ? n3 / 2 : n3 / 2 + 1;
        arrayList.addAll(list);
        int n5 = 1;
        for (n = 2; n < n3; n += 2) {
            arrayList.set(n, list.get(n5++));
        }
        for (n = 1; n < n3; n += 2) {
            arrayList.set(n, list.get(n4++));
        }
        return arrayList;
    }
}

